/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.sql.compile.ParameterizedConstantNode;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.LocalField;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SqlXmlUtil;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.IsNullNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ParameterNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UntypedNullConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public class UnaryOperatorNode
extends ValueNode {
    String operator;
    String methodName;
    private int operatorType;
    String resultInterfaceType;
    String receiverInterfaceType;
    ValueNode operand;
    public static final int XMLPARSE_OP = 0;
    public static final int XMLSERIALIZE_OP = 1;
    static final String[] UnaryOperators = new String[]{"xmlparse", "xmlserialize"};
    static final String[] UnaryMethodNames = new String[]{"XMLParse", "XMLSerialize"};
    static final String[] UnaryResultTypes = new String[]{"com.pivotal.gemfirexd.internal.iapi.types.XMLDataValue", "com.pivotal.gemfirexd.internal.iapi.types.StringDataValue"};
    static final String[] UnaryArgTypes = new String[]{"com.pivotal.gemfirexd.internal.iapi.types.StringDataValue", "com.pivotal.gemfirexd.internal.iapi.types.XMLDataValue"};
    private Object[] additionalArgs;
    private SqlXmlUtil sqlxUtil;

    @Override
    public void init(Object operand, Object operatorOrOpType, Object methodNameOrAddedArgs) {
        this.operand = (ValueNode)operand;
        if (operatorOrOpType instanceof String) {
            this.operator = (String)operatorOrOpType;
            this.methodName = (String)methodNameOrAddedArgs;
            this.operatorType = -1;
        } else {
            SanityManager.ASSERT((operatorOrOpType instanceof Integer && (methodNameOrAddedArgs == null || methodNameOrAddedArgs instanceof Object[]) ? 1 : 0) != 0, (String)"Init params in UnaryOperator node have the wrong type.");
            this.operatorType = (Integer)operatorOrOpType;
            this.operator = UnaryOperators[this.operatorType];
            this.methodName = UnaryMethodNames[this.operatorType];
            this.resultInterfaceType = UnaryResultTypes[this.operatorType];
            this.receiverInterfaceType = UnaryArgTypes[this.operatorType];
            this.additionalArgs = (Object[])methodNameOrAddedArgs;
        }
    }

    @Override
    public void init(Object operand) {
        this.operand = (ValueNode)operand;
        this.operatorType = -1;
    }

    void setOperator(String operator) {
        this.operator = operator;
        this.operatorType = -1;
    }

    public String getOperatorString() {
        return this.operator;
    }

    void setMethodName(String methodName) {
        this.methodName = methodName;
        this.operatorType = -1;
    }

    @Override
    public String toString() {
        return "operator: " + this.operator + "\n" + "methodName: " + this.methodName + "\n" + super.toString();
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.operand != null) {
            this.printLabel(depth, "operand: ");
            this.operand.treePrint(depth + 1);
        }
    }

    public final ValueNode getOperand() {
        return this.operand;
    }

    public ValueNode getParameterOperand() throws StandardException {
        Class<?> opclass;
        if (!this.requiresTypeFromContext()) {
            return null;
        }
        UnaryOperatorNode tempUON = this;
        ValueNode operand = tempUON.getOperand();
        while ((opclass = (operand = tempUON.getOperand()).getClass()) != ParameterNode.class && opclass != ParameterizedConstantNode.class) {
            tempUON = (UnaryOperatorNode)operand;
        }
        return tempUON.getOperand();
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.bindOperand(fromList, subqueryList, aggregateVector);
        if (this.operatorType == 0) {
            this.bindXMLParse();
        } else if (this.operatorType == 1) {
            this.bindXMLSerialize();
        }
        return this;
    }

    protected void bindOperand(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.operand = this.operand.bindExpression(fromList, subqueryList, aggregateVector);
        if (this.operand.requiresTypeFromContext() && !this.operand.isParameterizedConstantNode()) {
            this.bindParameter();
            if (this.operand.getTypeServices() == null) {
                return;
            }
        }
        if (!(this.operand instanceof UntypedNullConstantNode) && this.operand.getTypeId().userType() && !(this instanceof IsNullNode)) {
            this.operand = this.operand.genSQLJavaSQLTree();
        }
    }

    private void bindXMLParse() throws StandardException {
        TypeId operandType = this.operand.getTypeId();
        if (operandType != null) {
            switch (operandType.getJDBCTypeId()) {
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    break;
                }
                default: {
                    throw StandardException.newException("42X25", (Object)this.methodName, (Object)operandType.getSQLTypeName());
                }
            }
        }
        this.sqlxUtil = new SqlXmlUtil();
        this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(2009));
    }

    private void bindXMLSerialize() throws StandardException {
        TypeId operandType = this.operand.getTypeId();
        if (operandType != null && !operandType.isXMLTypeId()) {
            throw StandardException.newException("42X25", (Object)this.methodName, (Object)operandType.getSQLTypeName());
        }
        SanityManager.ASSERT((this.additionalArgs != null && this.additionalArgs.length > 0 ? 1 : 0) != 0, (String)"Failed to locate target type for XMLSERIALIZE operator");
        DataTypeDescriptor targetType = (DataTypeDescriptor)this.additionalArgs[0];
        TypeId targetTypeId = targetType.getTypeId();
        switch (targetTypeId.getJDBCTypeId()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                break;
            }
            default: {
                throw StandardException.newException("42Z73", targetTypeId.getSQLTypeName());
            }
        }
        this.setType(targetType);
        this.setCollationUsingCompilationSchema();
    }

    @Override
    public ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        if (this.operand != null) {
            this.operand = this.operand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        }
        return this;
    }

    @Override
    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        return this.operand == null ? false : this.operand.categorize(referencedTabs, simplePredsOnly);
    }

    @Override
    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        if (this.operand != null) {
            this.operand = this.operand.remapColumnReferencesToExpressions();
        }
        return this;
    }

    @Override
    public boolean isConstantExpression() {
        return this.operand == null ? true : this.operand.isConstantExpression();
    }

    @Override
    public boolean constantExpression(PredicateList whereClause) {
        return this.operand == null ? true : this.operand.constantExpression(whereClause);
    }

    void bindParameter() throws StandardException {
        if (this.operatorType == 0) {
            throw StandardException.newException("42Z79");
        }
        if (this.operatorType == 1) {
            throw StandardException.newException("42Z70");
        }
        if (this.operand.getTypeServices() == null) {
            throw StandardException.newException("42X36", this.operator);
        }
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        boolean xmlGen;
        boolean bl = xmlGen = this.operatorType == 0 || this.operatorType == 1;
        if (xmlGen) {
            mb.pushNewStart("com.pivotal.gemfirexd.internal.impl.sql.execute.SqlXmlExecutor");
            mb.pushNewComplete(this.addXmlOpMethodParams(acb, mb));
        }
        String resultTypeName = this.operatorType == -1 ? this.getTypeCompiler().interfaceName() : this.resultInterfaceType;
        boolean needField = !this.getTypeId().isBooleanTypeId();
        String receiverType = this.getReceiverInterfaceName();
        this.operand.generateExpression(acb, mb);
        mb.cast(receiverType);
        if (needField) {
            LocalField field = acb.newFieldDeclaration(2, resultTypeName);
            mb.getField(field);
            if (xmlGen) {
                mb.callMethod((short)182, null, this.methodName, resultTypeName, 2);
            } else {
                mb.callMethod((short)185, null, this.methodName, resultTypeName, 1);
            }
            mb.putField(field);
        } else {
            mb.callMethod((short)185, null, this.methodName, resultTypeName, 0);
        }
    }

    public String getReceiverInterfaceName() throws StandardException {
        SanityManager.ASSERT((this.operand != null ? 1 : 0) != 0, (String)"cannot get interface without operand");
        if (this.operatorType != -1) {
            return this.receiverInterfaceType;
        }
        return this.operand.getTypeCompiler().interfaceName();
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        return this.operand != null ? this.operand.getOrderableVariantType() : 3;
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = v.visit(this);
        if (v.skipChildren(this)) {
            return returnNode;
        }
        if (this.operand != null && !v.stopTraversal()) {
            this.operand = (ValueNode)this.operand.accept(v);
        }
        return returnNode;
    }

    protected int addXmlOpMethodParams(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.operatorType != 0 && this.operatorType != 1) {
            return 0;
        }
        if (this.operatorType == 1) {
            DataTypeDescriptor targetType = (DataTypeDescriptor)this.additionalArgs[0];
            mb.push(targetType.getJDBCTypeId());
            mb.push(targetType.getMaximumWidth());
            mb.push(this.getSchemaDescriptor(null, false).getCollationType());
            return 3;
        }
        acb.pushThisAsActivation(mb);
        mb.push(this.getCompilerContext().addSavedObject(this.sqlxUtil));
        mb.push((Boolean)this.additionalArgs[0]);
        return 3;
    }

    @Override
    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (this.isSameNodeType(o)) {
            UnaryOperatorNode other = (UnaryOperatorNode)o;
            return this.operator.equals(other.operator) && (this.operand == other.operand || this.operand != null && this.operand.isEquivalent(other.operand));
        }
        return false;
    }

    @Override
    public ValueNode genExpressionOperands(ResultColumnList outerResultColumns, ResultColumn parentRC, boolean remapToNew) throws StandardException {
        this.operand = this.operand.genExpressionOperands(outerResultColumns, null, remapToNew);
        return this;
    }

    @Override
    protected void optimizeForOffHeap(boolean shouldOptimize) {
        this.operand.optimizeForOffHeap(shouldOptimize);
    }
}

