/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.TypeCompiler;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CastNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public class ExtractOperatorNode
extends UnaryOperatorNode {
    private static final String[] fieldName = new String[]{"YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND"};
    private static final String[] fieldMethod = new String[]{"getYear", "getMonth", "getDate", "getHours", "getMinutes", "getSeconds"};
    private int extractField;

    @Override
    public void init(Object field, Object operand) {
        this.extractField = (Integer)field;
        super.init(operand, "EXTRACT " + fieldName[this.extractField], fieldMethod[this.extractField]);
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.bindOperand(fromList, subqueryList, aggregateVector);
        TypeId opTypeId = this.operand.getTypeId();
        int operandType = opTypeId.getJDBCTypeId();
        TypeCompiler tc = this.operand.getTypeCompiler();
        if (opTypeId.isStringTypeId()) {
            int castType = this.extractField < 3 ? 91 : 92;
            this.operand = (ValueNode)this.getNodeFactory().getNode(60, this.operand, DataTypeDescriptor.getBuiltInDataTypeDescriptor(castType, true, tc.getCastToCharWidth(this.operand.getTypeServices())), this.getContextManager());
            ((CastNode)this.operand).bindCastNodeOnly();
            opTypeId = this.operand.getTypeId();
            operandType = opTypeId.getJDBCTypeId();
        }
        if (operandType != 91 && operandType != 92 && operandType != 93) {
            throw StandardException.newException("42X25", (Object)("EXTRACT " + fieldName[this.extractField]), (Object)opTypeId.getSQLTypeName());
        }
        if (operandType == 91 && this.extractField > 2) {
            throw StandardException.newException("42X25", (Object)("EXTRACT " + fieldName[this.extractField]), (Object)opTypeId.getSQLTypeName());
        }
        if (operandType == 92 && this.extractField < 3) {
            throw StandardException.newException("42X25", (Object)("EXTRACT " + fieldName[this.extractField]), (Object)opTypeId.getSQLTypeName());
        }
        if (operandType == 93 && this.extractField == 5) {
            this.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(8), this.operand.getTypeServices().isNullable()));
        } else {
            this.setType(new DataTypeDescriptor(TypeId.INTEGER_ID, this.operand.getTypeServices().isNullable()));
        }
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "field is " + fieldName[this.extractField] + "\n";
    }
}

