/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public class CurrentDatetimeOperatorNode
extends ValueNode {
    public static final int CURRENT_DATE = 0;
    public static final int CURRENT_TIME = 1;
    public static final int CURRENT_TIMESTAMP = 2;
    private static final int[] jdbcTypeId = new int[]{91, 92, 93};
    private static final String[] methodName = new String[]{"CURRENT DATE", "CURRENT TIME", "CURRENT TIMESTAMP"};
    private int whichType;

    @Override
    public void init(Object whichType) {
        this.whichType = (Integer)whichType;
        SanityManager.ASSERT((this.whichType >= 0 && this.whichType <= 2 ? 1 : 0) != 0);
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.checkReliability(methodName[this.whichType], 1);
        this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId[this.whichType], false));
        return this;
    }

    @Override
    protected int getOrderableVariantType() {
        return 2;
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        switch (this.whichType) {
            case 0: {
                acb.getCurrentDateExpression(mb);
                break;
            }
            case 1: {
                acb.getCurrentTimeExpression(mb);
                break;
            }
            case 2: {
                acb.getCurrentTimestampExpression(mb);
            }
        }
        acb.generateDataValue(mb, this.getTypeCompiler(), this.getTypeServices().getCollationType(), null);
    }

    @Override
    public String toString() {
        return super.toString() + "method = " + methodName[this.whichType] + "\n";
    }

    @Override
    protected boolean isEquivalent(ValueNode o) {
        if (this.isSameNodeType(o)) {
            CurrentDatetimeOperatorNode other = (CurrentDatetimeOperatorNode)o;
            return other.whichType == this.whichType;
        }
        return false;
    }

    public String getMethodName() {
        return methodName[this.whichType];
    }
}

