/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.NodeFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.ProviderInfo;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.ProviderList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SelectNode;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ColumnInfo;

public class CreateViewNode
extends DDLStatementNode {
    ResultColumnList resultColumns;
    ResultSetNode queryExpression;
    String qeText;
    int checkOption;
    ProviderInfo[] providerInfos;
    ColumnInfo[] colInfos;

    @Override
    public void init(Object newObjectName, Object resultColumns, Object queryExpression, Object checkOption, Object qeText) throws StandardException {
        this.initAndCheck(newObjectName);
        this.resultColumns = (ResultColumnList)resultColumns;
        this.queryExpression = (ResultSetNode)queryExpression;
        this.checkOption = (Integer)checkOption;
        this.qeText = ((String)qeText).trim();
        this.implicitCreateSchema = true;
    }

    @Override
    public String toString() {
        return super.toString() + "checkOption: " + this.checkOption + "\n" + "qeText: " + this.qeText + "\n";
    }

    @Override
    public String statementToString() {
        return "CREATE VIEW";
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.resultColumns != null) {
            this.printLabel(depth, "resultColumns: ");
            this.resultColumns.treePrint(depth + 1);
        }
        this.printLabel(depth, "queryExpression: ");
        this.queryExpression.treePrint(depth + 1);
    }

    public int getCheckOption() {
        return this.checkOption;
    }

    public ProviderInfo[] getProviderInfo() {
        return this.providerInfos;
    }

    public ColumnInfo[] getColumnInfo() {
        return this.colInfos;
    }

    @Override
    public void bindStatement() throws StandardException {
        String duplicateColName;
        CompilerContext cc = this.getCompilerContext();
        DataDictionary dataDictionary = this.getDataDictionary();
        this.providerInfos = this.bindViewDefinition(dataDictionary, cc, this.getLanguageConnectionContext(), this.getNodeFactory(), this.queryExpression, this.getContextManager());
        ResultColumnList qeRCL = this.queryExpression.getResultColumns();
        if (this.resultColumns != null) {
            if (this.resultColumns.size() != qeRCL.visibleSize()) {
                throw StandardException.newException("42X56", this.getFullName());
            }
            qeRCL.copyResultColumnNames(this.resultColumns);
        }
        if ((duplicateColName = qeRCL.verifyUniqueNames(this.resultColumns == null)) != null) {
            throw StandardException.newException("42Y13", duplicateColName);
        }
        if (this.queryExpression.getResultColumns().size() > 5000) {
            throw StandardException.newException("54011", (Object)String.valueOf(this.queryExpression.getResultColumns().size()), (Object)this.getRelativeName(), (Object)String.valueOf(5000));
        }
        this.colInfos = new ColumnInfo[this.queryExpression.getResultColumns().size()];
        this.genColumnInfos(this.colInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProviderInfo[] bindViewDefinition(DataDictionary dataDictionary, CompilerContext compilerContext, LanguageConnectionContext lcc, NodeFactory nodeFactory, ResultSetNode queryExpr, ContextManager cm) throws StandardException {
        FromList fromList = (FromList)nodeFactory.getNode(37, nodeFactory.doJoinOrderOptimization(), cm);
        ProviderList prevAPL = compilerContext.getCurrentAuxiliaryProviderList();
        ProviderList apl = new ProviderList();
        try {
            compilerContext.setCurrentAuxiliaryProviderList(apl);
            compilerContext.pushCurrentPrivType(0);
            queryExpr = queryExpr.bindNonVTITables(dataDictionary, fromList);
            queryExpr = queryExpr.bindVTITables(fromList);
            queryExpr.bindExpressions(fromList);
            if (queryExpr instanceof SelectNode && queryExpr.referencesSessionSchema()) {
                throw StandardException.newException("XCL51.S");
            }
            queryExpr.bindResultColumns(fromList);
            queryExpr.bindUntypedNullsToResultColumns(null);
        }
        finally {
            compilerContext.popCurrentPrivType();
            compilerContext.setCurrentAuxiliaryProviderList(prevAPL);
        }
        DependencyManager dm = dataDictionary.getDependencyManager();
        ProviderInfo[] providerInfos = dm.getPersistentProviderInfos(apl);
        dm.clearColumnInfoInProviders(apl);
        SanityManager.ASSERT((fromList.size() == 0 ? 1 : 0) != 0, (String)("fromList.size() is expected to be 0, not " + fromList.size() + " on return from RS.bindExpressions()"));
        return providerInfos;
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.queryExpression.referencesSessionSchema();
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getCreateViewConstantAction(this.getSchemaDescriptor().getSchemaName(), this.getRelativeName(), 2, this.qeText, this.checkOption, this.colInfos, this.providerInfos, null);
    }

    private void genColumnInfos(ColumnInfo[] colInfos) {
        ResultColumnList rcl = this.queryExpression.getResultColumns();
        int rclSize = rcl.size();
        for (int index = 0; index < rclSize; ++index) {
            ResultColumn rc = (ResultColumn)rcl.elementAt(index);
            colInfos[index] = new ColumnInfo(rc.getName(), rc.getType(), null, null, null, null, 0, 0L, false, false, 0L, 0L);
        }
    }

    ResultSetNode getParsedQueryExpression() {
        return this.queryExpression;
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = v.visit(this);
        if (v.skipChildren(this)) {
            return returnNode;
        }
        if (!v.stopTraversal()) {
            super.accept(v);
        }
        if (this.queryExpression != null && !v.stopTraversal()) {
            this.queryExpression = (ResultSetNode)this.queryExpression.accept(v);
        }
        return returnNode;
    }
}

