/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ColumnQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.NodeFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AndNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryComparisonOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BooleanConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CollectAndEliminateColumnsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.VirtualColumnNode;
import java.util.ArrayList;
import java.util.Vector;

public class ColumnReference
extends ValueNode {
    String columnName;
    TableName tableName;
    private int tableNumber;
    private int columnNumber;
    private ResultColumn source;
    ResultColumn origSource;
    private String origName;
    int origTableNumber = -1;
    int origColumnNumber = -1;
    private boolean replacesAggregate;
    private int nestingLevel = -1;
    private int sourceLevel = -1;
    private boolean scoped;
    private ArrayList remaps;
    private boolean finalRemapDoneSubqueryPreds = false;

    @Override
    public void init(Object columnName, Object tableName, Object tokBeginOffset, Object tokEndOffset) {
        this.columnName = (String)columnName;
        this.tableName = (TableName)tableName;
        this.setBeginOffset((Integer)tokBeginOffset);
        this.setEndOffset((Integer)tokEndOffset);
        this.tableNumber = -1;
        this.remaps = null;
    }

    @Override
    public void init(Object columnName, Object tableName) {
        this.columnName = (String)columnName;
        this.tableName = (TableName)tableName;
        this.tableNumber = -1;
        this.remaps = null;
    }

    @Override
    public String toString() {
        return "columnName: " + this.columnName + "\n" + "tableNumber: " + this.tableNumber + "\n" + "columnNumber: " + this.columnNumber + "\n" + "replacesAggregate: " + this.replacesAggregate + "\n" + "tableName: " + (this.tableName != null ? this.tableName.toString() : "null") + "\n" + "nestingLevel: " + this.nestingLevel + "\n" + "sourceLevel: " + this.sourceLevel + "\n" + super.toString();
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.source != null) {
            this.printLabel(depth, "source: ");
            this.source.treePrint(depth + 1);
        }
    }

    boolean getCorrelated() {
        SanityManager.ASSERT((this.nestingLevel != -1 ? 1 : 0) != 0, (String)("nestingLevel on " + this.columnName + " is not expected to be -1"));
        SanityManager.ASSERT((this.sourceLevel != -1 ? 1 : 0) != 0, (String)("sourceLevel on " + this.columnName + " is not expected to be -1"));
        return this.sourceLevel != this.nestingLevel;
    }

    void setNestingLevel(int nestingLevel) {
        SanityManager.ASSERT((nestingLevel != -1 ? 1 : 0) != 0, (String)"nestingLevel is not expected to be -1");
        this.nestingLevel = nestingLevel;
    }

    public int getNestingLevel() {
        return this.nestingLevel;
    }

    void setSourceLevel(int sourceLevel) {
        SanityManager.ASSERT((sourceLevel != -1 ? 1 : 0) != 0, (String)"sourceLevel is not expected to be -1");
        this.sourceLevel = sourceLevel;
    }

    int getSourceLevel() {
        return this.sourceLevel;
    }

    public void markGeneratedToReplaceAggregate() {
        this.replacesAggregate = true;
    }

    public boolean getGeneratedToReplaceAggregate() {
        return this.replacesAggregate;
    }

    @Override
    public ValueNode getClone() throws StandardException {
        ColumnReference newCR = (ColumnReference)this.getNodeFactory().getNode(62, this.columnName, this.tableName, this.getContextManager());
        newCR.copyFields(this);
        return newCR;
    }

    public void copyFields(ColumnReference oldCR) throws StandardException {
        super.copyFields(oldCR);
        this.tableName = oldCR.getTableNameNode();
        this.tableNumber = oldCR.getTableNumber();
        this.columnNumber = oldCR.getColumnNumber();
        this.source = oldCR.getSource();
        this.nestingLevel = oldCR.getNestingLevel();
        this.sourceLevel = oldCR.getSourceLevel();
        this.replacesAggregate = oldCR.getGeneratedToReplaceAggregate();
        this.scoped = oldCR.isScoped();
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        SanityManager.ASSERT((fromList != null ? 1 : 0) != 0, (String)"fromList is expected to be non-null");
        if (fromList.size() == 0) {
            throw StandardException.newException("42X15", this.columnName);
        }
        ResultColumn matchingRC = fromList.bindColumnReference(this);
        if (matchingRC == null) {
            throw StandardException.newException("42X04", this.getSQLColumnName());
        }
        this.columnNumber = matchingRC.getColumnPosition();
        return this;
    }

    public String getSQLColumnName() {
        if (this.tableName == null) {
            return this.columnName;
        }
        return this.tableName.toString() + "." + this.columnName;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    public int getTableNumber() {
        return this.tableNumber;
    }

    public void setTableNumber(int tableNumber) {
        SanityManager.ASSERT((tableNumber != -1 ? 1 : 0) != 0, (String)"tableNumber not expected to be -1");
        this.tableNumber = tableNumber;
    }

    @Override
    public String getTableName() {
        return this.tableName != null ? this.tableName.getTableName() : null;
    }

    public String getSourceTableName() {
        return this.source != null ? this.source.getTableName() : null;
    }

    public String getSourceSchemaName() throws StandardException {
        return this.source != null ? this.source.getSchemaName() : null;
    }

    @Override
    public boolean updatableByCursor() {
        return this.source != null ? this.source.updatableByCursor() : false;
    }

    public TableName getTableNameNode() {
        return this.tableName;
    }

    public void setTableNameNode(TableName tableName) {
        this.tableName = tableName;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int colNum) {
        this.columnNumber = colNum;
    }

    public ResultColumn getSource() {
        return this.source;
    }

    public void setSource(ResultColumn source) {
        this.source = source;
    }

    @Override
    public ValueNode putAndsOnTop() throws StandardException {
        NodeFactory nodeFactory = this.getNodeFactory();
        BooleanConstantNode trueNode = (BooleanConstantNode)nodeFactory.getNode(38, Boolean.TRUE, this.getContextManager());
        BinaryComparisonOperatorNode equalsNode = (BinaryComparisonOperatorNode)nodeFactory.getNode(41, this, trueNode, this.getContextManager());
        equalsNode.bindComparisonOperator();
        ValueNode andNode = (ValueNode)nodeFactory.getNode(39, equalsNode, trueNode, this.getContextManager());
        ((AndNode)andNode).postBindFixup();
        return andNode;
    }

    @Override
    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) {
        SanityManager.ASSERT((this.tableNumber >= 0 ? 1 : 0) != 0, (String)"tableNumber is expected to be non-negative");
        referencedTabs.set(this.tableNumber);
        return !this.replacesAggregate && !this.source.isWindowFunction() && (this.source.getExpression() instanceof ColumnReference || this.source.getExpression() instanceof VirtualColumnNode || this.source.getExpression() instanceof ConstantNode);
    }

    public void remapColumnReferences() {
        ValueNode expression = this.source.getExpression();
        if (!(expression instanceof VirtualColumnNode) && !(expression instanceof ColumnReference)) {
            return;
        }
        if (this.scoped && this.origSource != null) {
            if (this.remaps == null) {
                this.remaps = new ArrayList();
            }
            this.remaps.add(new RemapInfo(this.columnNumber, this.tableNumber, this.columnName, this.source));
        } else {
            this.origSource = this.source;
            this.origName = this.columnName;
            this.origColumnNumber = this.columnNumber;
            this.origTableNumber = this.tableNumber;
        }
        this.source = this.getSourceResultColumn();
        this.columnName = this.source.getName();
        this.columnNumber = this.source.getColumnPosition();
        if (this.source.getExpression() instanceof ColumnReference) {
            ColumnReference cr = (ColumnReference)this.source.getExpression();
            this.tableNumber = cr.getTableNumber();
            if (this.tableNumber == -1 && !cr.getGeneratedToReplaceAggregate()) {
                SanityManager.THROWASSERT((String)("tableNumber not expected to be -1, origName = " + this.origName));
            }
        }
    }

    public void unRemapColumnReferences() {
        if (this.origSource == null) {
            return;
        }
        if (this.remaps == null || this.remaps.size() == 0) {
            this.source = this.origSource;
            this.origSource = null;
            this.columnName = this.origName;
            this.origName = null;
            this.tableNumber = this.origTableNumber;
            this.columnNumber = this.origColumnNumber;
        } else {
            RemapInfo rI = (RemapInfo)this.remaps.remove(this.remaps.size() - 1);
            this.source = rI.getSource();
            this.columnName = rI.getColumnName();
            this.tableNumber = rI.getTableNumber();
            this.columnNumber = rI.getColumnNumber();
            rI = null;
            if (this.remaps.size() == 0) {
                this.remaps = null;
            }
        }
    }

    protected boolean hasBeenRemapped() {
        return this.origSource != null;
    }

    @Override
    public ResultColumn getSourceResultColumn() {
        return this.source.getExpression().getSourceResultColumn();
    }

    @Override
    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        ResultColumn sourceRC = this.source;
        if (!this.source.isRedundant()) {
            return this;
        }
        ResultColumn rc = this.source;
        while (rc != null && rc.isRedundant()) {
            ResultColumn nextRC = rc.getExpression().getSourceResultColumn();
            if (nextRC != null && nextRC.isRedundant()) {
                sourceRC = nextRC;
            }
            rc = nextRC;
        }
        if (sourceRC == null) {
            SanityManager.THROWASSERT((String)("sourceRC is expected to be non-null for " + this.columnName));
        }
        if (!sourceRC.isRedundant()) {
            SanityManager.THROWASSERT((String)("sourceRC is expected to be redundant for " + this.columnName));
        }
        if (sourceRC.getExpression() instanceof VirtualColumnNode) {
            VirtualColumnNode vcn = (VirtualColumnNode)sourceRC.getExpression();
            ResultSetNode rsn = vcn.getSourceResultSet();
            if (rsn instanceof FromTable) {
                FromTable ft = (FromTable)rsn;
                this.tableNumber = ft.getTableNumber();
                SanityManager.ASSERT((this.tableNumber != -1 ? 1 : 0) != 0, (String)"tableNumber not expected to be -1");
                ResultColumn ftRC = ft.getResultColumns().getResultColumn(this.columnName);
                SanityManager.ASSERT((ftRC != null ? 1 : 0) != 0, (String)("Failed to find column '" + this.columnName + "' in the " + "RCL for '" + ft.getTableName() + "'."));
                this.columnNumber = ftRC.getExpression() instanceof VirtualColumnNode ? ftRC.getVirtualColumnId() : ftRC.getColumnPosition();
            } else {
                SanityManager.THROWASSERT((String)("rsn expected to be a FromTable, but is a " + rsn.getClass().getName()));
            }
            this.source = sourceRC.getExpression().getSourceResultColumn();
            return this;
        }
        return sourceRC.getExpression().getClone();
    }

    void getTablesReferenced(JBitSet refs) {
        if (refs.size() < this.tableNumber) {
            refs.grow(this.tableNumber);
        }
        if (this.tableNumber != -1) {
            refs.set(this.tableNumber);
        }
    }

    @Override
    public boolean isCloneable() {
        return true;
    }

    @Override
    public boolean constantExpression(PredicateList whereClause) {
        return whereClause.constantColumn(this);
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        int sourceResultSetNumber = this.source.getResultSetNumber();
        if (this.source.isRedundant()) {
            this.source.generateExpression(acb, mb);
            return;
        }
        if (sourceResultSetNumber < 0) {
            SanityManager.THROWASSERT((String)("sourceResultSetNumber expected to be >= 0 for " + this.getTableName() + "." + this.getColumnName()));
        }
        acb.pushColumnReference(mb, sourceResultSetNumber, this.source.getVirtualColumnId());
        mb.cast(this.getTypeCompiler().interfaceName());
    }

    @Override
    public String getSchemaName() {
        return this.tableName != null ? this.tableName.getSchemaName() : null;
    }

    @Override
    protected int getOrderableVariantType() {
        return 1;
    }

    boolean pointsToColumnReference() {
        return this.source.getExpression() instanceof ColumnReference;
    }

    @Override
    public DataTypeDescriptor getTypeServices() {
        if (this.source == null) {
            return super.getTypeServices();
        }
        return this.source.getTypeServices();
    }

    protected ResultSetNode getSourceResultSet(int[] colNum) throws StandardException {
        if (this.source == null) {
            return null;
        }
        ValueNode rcExpr = null;
        ResultColumn rc = this.getSource();
        rcExpr = rc.getExpression();
        colNum[0] = this.getColumnNumber();
        while (rcExpr != null && (rc.isRedundant() || rcExpr instanceof ColumnReference)) {
            if (rcExpr instanceof ColumnReference) {
                colNum[0] = ((ColumnReference)rcExpr).getColumnNumber();
                rc = ((ColumnReference)rcExpr).getSource();
            }
            while (rc.isRedundant()) {
                rcExpr = rc.getExpression();
                if (rcExpr instanceof VirtualColumnNode) {
                    rc = rcExpr.getSourceResultColumn();
                    continue;
                }
                if (rcExpr instanceof ColumnReference) {
                    colNum[0] = ((ColumnReference)rcExpr).getColumnNumber();
                    rc = ((ColumnReference)rcExpr).getSource();
                    continue;
                }
                rcExpr = null;
                break;
            }
            rcExpr = rc.getExpression();
        }
        if (rcExpr != null && rcExpr instanceof VirtualColumnNode) {
            return ((VirtualColumnNode)rcExpr).getSourceResultSet();
        }
        colNum[0] = -1;
        return null;
    }

    @Override
    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (!this.isSameNodeType(o)) {
            return false;
        }
        ColumnReference other = (ColumnReference)o;
        return this.tableNumber == other.tableNumber && this.columnName.equals(other.getColumnName());
    }

    protected void markAsScoped() {
        this.scoped = true;
    }

    protected boolean isScoped() {
        return this.scoped;
    }

    public int hashCode() {
        int h = this.tableName != null ? this.tableName.hashCode() : this.tableNumber;
        return h ^= this.columnName != null ? this.columnName.hashCode() : this.columnNumber;
    }

    public boolean equals(Object other) {
        if (other instanceof ColumnReference) {
            ColumnReference o = (ColumnReference)other;
            if (this.columnName != null ? !this.columnName.equals(o.columnName) : this.columnNumber != o.columnNumber) {
                return false;
            }
            if (this.tableName != null) {
                return this.tableName.equals(o.tableName);
            }
            return this.tableNumber == o.tableNumber;
        }
        return false;
    }

    @Override
    public QueryInfo computeQueryInfo(QueryInfoContext qic) throws StandardException {
        return new ColumnQueryInfo(this, qic);
    }

    @Override
    public ValueNode genExpressionOperands(ResultColumnList outerResultColumns, ResultColumn parentRC, boolean remapToNew) throws StandardException {
        if (parentRC != null) {
            outerResultColumns.addResultColumn(parentRC);
            return this;
        }
        ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, this.toString(), this, this.getContextManager());
        outerResultColumns.addResultColumn(resultColumn);
        if (remapToNew) {
            ColumnReference newCR = (ColumnReference)this.getClone();
            newCR.setSource(resultColumn);
            return newCR;
        }
        return this;
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = v.visit(this);
        if (v instanceof CollectAndEliminateColumnsVisitor && this.source != null && !v.stopTraversal()) {
            this.source = (ResultColumn)this.source.accept(v);
        }
        return returnNode;
    }

    @Override
    public boolean hasExpression() {
        return this.source != null ? this.source.hasExpression() : true;
    }

    @Override
    public String printExplainInfo() {
        return (this.tableName != null ? this.tableName.toString() + "." : "") + this.columnName;
    }

    @Override
    public String ncjGenerateSql() {
        return this.columnName;
    }

    public boolean getFinalRemapDoneForSubqueryPred() {
        return this.finalRemapDoneSubqueryPreds;
    }

    public void setFinalRemapDoneForSubqueryPred() {
        this.finalRemapDoneSubqueryPreds = true;
    }

    @Override
    public int setColocatedWith(Optimizable src, Optimizable tgt, JBitSet srcPCols, JBitSet tgtPCols) throws StandardException {
        String baseTableName = this.getSourceTableName();
        String colName = this.getColumnName();
        int pindex = -1;
        Optimizable opt = src.getBaseTable();
        if (!opt.isBaseTable()) {
            return 0;
        }
        if (opt.getBaseTableName().equals(baseTableName) && (pindex = opt.getTableDescriptor().getDistributionDescriptor().getPartitioningColumnIdx(colName)) != -1) {
            srcPCols.set(pindex);
            return 3;
        }
        opt = tgt.getBaseTable();
        if (!opt.isBaseTable()) {
            return 0;
        }
        if (opt.getBaseTableName().equals(baseTableName) && (pindex = opt.getTableDescriptor().getDistributionDescriptor().getPartitioningColumnIdx(colName)) != -1) {
            tgtPCols.set(pindex);
            return 3;
        }
        return -1;
    }

    @Override
    public String findSourceSchemaName() {
        return this.source != null ? this.source.findSourceSchemaName() : this.getSchemaName();
    }

    @Override
    public String findSourceTableName() {
        return this.source != null ? this.source.findSourceTableName() : this.getTableName();
    }

    @Override
    public String findSourceColumnName() {
        return this.source != null ? this.source.findSourceColumnName() : this.getColumnName();
    }

    private class RemapInfo {
        int colNum;
        int tableNum;
        String colName;
        ResultColumn source;

        RemapInfo(int cNum, int tNum, String cName, ResultColumn rc) {
            this.colNum = cNum;
            this.tableNum = tNum;
            this.colName = cName;
            this.source = rc;
        }

        int getColumnNumber() {
            return this.colNum;
        }

        int getTableNumber() {
            return this.tableNum;
        }

        String getColumnName() {
            return this.colName;
        }

        ResultColumn getSource() {
            return this.source;
        }

        void setColNumber(int cNum) {
            this.colNum = cNum;
        }

        void setTableNumber(int tNum) {
            this.tableNum = tNum;
        }

        void setColName(String cName) {
            this.colName = cName;
        }

        void setSource(ResultColumn rc) {
            this.source = rc;
        }
    }
}

