/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.LocalField;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SqlXmlUtil;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryRelationalOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CharConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.InListOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public class BinaryOperatorNode
extends ValueNode {
    String operator;
    String methodName;
    ValueNode receiver;
    public static final int PLUS = 1;
    public static final int MINUS = 2;
    public static final int TIMES = 3;
    public static final int DIVIDE = 4;
    public static final int CONCATENATE = 5;
    public static final int EQ = 6;
    public static final int NE = 7;
    public static final int GT = 8;
    public static final int GE = 9;
    public static final int LT = 10;
    public static final int LE = 11;
    public static final int AND = 12;
    public static final int OR = 13;
    public static final int LIKE = 14;
    public ValueNode leftOperand;
    public ValueNode rightOperand;
    String leftInterfaceType;
    String rightInterfaceType;
    String resultInterfaceType;
    int operatorType;
    public static final int XMLEXISTS_OP = 0;
    public static final int XMLQUERY_OP = 1;
    static final String[] BinaryOperators = new String[]{"xmlexists", "xmlquery"};
    static final String[] BinaryMethodNames = new String[]{"XMLExists", "XMLQuery"};
    static final String[] BinaryResultTypes = new String[]{"com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue", "com.pivotal.gemfirexd.internal.iapi.types.XMLDataValue"};
    static final String[][] BinaryArgTypes = new String[][]{{"com.pivotal.gemfirexd.internal.iapi.types.StringDataValue", "com.pivotal.gemfirexd.internal.iapi.types.XMLDataValue"}, {"com.pivotal.gemfirexd.internal.iapi.types.StringDataValue", "com.pivotal.gemfirexd.internal.iapi.types.XMLDataValue"}};
    private SqlXmlUtil sqlxUtil;

    @Override
    public void init(Object leftOperand, Object rightOperand, Object operator, Object methodName, Object leftInterfaceType, Object rightInterfaceType) {
        this.leftOperand = (ValueNode)leftOperand;
        this.rightOperand = (ValueNode)rightOperand;
        this.operator = (String)operator;
        this.methodName = (String)methodName;
        this.leftInterfaceType = (String)leftInterfaceType;
        this.rightInterfaceType = (String)rightInterfaceType;
        this.operatorType = -1;
    }

    @Override
    public void init(Object leftOperand, Object rightOperand, Object leftInterfaceType, Object rightInterfaceType) {
        this.leftOperand = (ValueNode)leftOperand;
        this.rightOperand = (ValueNode)rightOperand;
        this.leftInterfaceType = (String)leftInterfaceType;
        this.rightInterfaceType = (String)rightInterfaceType;
        this.operatorType = -1;
    }

    @Override
    public void init(Object leftOperand, Object rightOperand, Object opType) {
        this.leftOperand = (ValueNode)leftOperand;
        this.rightOperand = (ValueNode)rightOperand;
        this.operatorType = (Integer)opType;
        this.operator = BinaryOperators[this.operatorType];
        this.methodName = BinaryMethodNames[this.operatorType];
        this.leftInterfaceType = BinaryArgTypes[this.operatorType][0];
        this.rightInterfaceType = BinaryArgTypes[this.operatorType][1];
        this.resultInterfaceType = BinaryResultTypes[this.operatorType];
    }

    @Override
    public String toString() {
        return "operator: " + this.operator + "\n" + "methodName: " + this.methodName + "\n" + super.toString();
    }

    void setOperator(String operator) {
        this.operator = operator;
        this.operatorType = -1;
    }

    void setMethodName(String methodName) {
        this.methodName = methodName;
        this.operatorType = -1;
    }

    public void setLeftRightInterfaceType(String iType) {
        this.leftInterfaceType = iType;
        this.rightInterfaceType = iType;
        this.operatorType = -1;
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.leftOperand != null) {
            this.printLabel(depth, "leftOperand: ");
            this.leftOperand.treePrint(depth + 1);
        }
        if (this.rightOperand != null) {
            this.printLabel(depth, "rightOperand: ");
            this.rightOperand.treePrint(depth + 1);
        }
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.leftOperand = this.leftOperand.bindExpression(fromList, subqueryList, aggregateVector);
        this.rightOperand = this.rightOperand.bindExpression(fromList, subqueryList, aggregateVector);
        if (this.operatorType == 0 || this.operatorType == 1) {
            return this.bindXMLQuery();
        }
        if (this.leftOperand.requiresTypeFromContext()) {
            if (this.rightOperand.requiresTypeFromContext() && !this.rightOperand.isParameterizedConstantNode() && !this.leftOperand.isParameterizedConstantNode()) {
                throw StandardException.newException("42X35", this.isForAVG() ? "avg" : this.operator);
            }
            if (!this.rightOperand.requiresTypeFromContext()) {
                this.leftOperand.setType(this.rightOperand.getTypeServices());
            }
        }
        if (this.rightOperand.requiresTypeFromContext() && !this.leftOperand.requiresTypeFromContext()) {
            this.rightOperand.setType(this.leftOperand.getTypeServices());
        }
        return this.genSQLJavaSQLTree();
    }

    public ValueNode bindXMLQuery() throws StandardException {
        TypeId leftOperandType = this.leftOperand.getTypeId();
        TypeId rightOperandType = this.rightOperand.getTypeId();
        if (!(this.leftOperand instanceof CharConstantNode)) {
            throw StandardException.newException("42Z75");
        }
        this.sqlxUtil = new SqlXmlUtil();
        this.sqlxUtil.compileXQExpr(((CharConstantNode)this.leftOperand).getString(), this.operatorType == 0 ? "XMLEXISTS" : "XMLQUERY");
        if (rightOperandType != null && !rightOperandType.isXMLTypeId()) {
            throw StandardException.newException("42Z77", rightOperandType.getSQLTypeName());
        }
        if (this.rightOperand.requiresTypeFromContext() && !this.rightOperand.isParameterizedConstantNode()) {
            throw StandardException.newException("42Z70");
        }
        if (this.operatorType == 0) {
            this.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, true));
        } else {
            this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(2009));
        }
        return this.genSQLJavaSQLTree();
    }

    @Override
    public ValueNode genSQLJavaSQLTree() throws StandardException {
        TypeId rightTypeId;
        TypeId leftTypeId = this.leftOperand.getTypeId();
        if (leftTypeId.userType()) {
            this.leftOperand = this.leftOperand.genSQLJavaSQLTree();
        }
        if ((rightTypeId = this.rightOperand.getTypeId()).userType()) {
            this.rightOperand = this.rightOperand.genSQLJavaSQLTree();
        }
        return this;
    }

    @Override
    public ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        this.leftOperand = this.leftOperand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        this.rightOperand = this.rightOperand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        return this;
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        boolean needField;
        String receiverType;
        boolean xmlGen;
        InListOperatorNode ilon;
        if (this instanceof BinaryRelationalOperatorNode && (ilon = ((BinaryRelationalOperatorNode)this).getInListOp()) != null) {
            ilon.generateExpression(acb, mb);
            return;
        }
        boolean bl = xmlGen = this.operatorType == 1 || this.operatorType == 0;
        if (xmlGen) {
            mb.pushNewStart("com.pivotal.gemfirexd.internal.impl.sql.execute.SqlXmlExecutor");
            mb.pushNewComplete(this.addXmlOpMethodParams(acb, mb));
        }
        if (this.leftOperand.getTypeId().typePrecedence() > this.rightOperand.getTypeId().typePrecedence()) {
            this.receiver = this.leftOperand;
            receiverType = this.operatorType == -1 ? this.getReceiverInterfaceName() : this.leftInterfaceType;
            this.leftOperand.generateExpression(acb, mb);
            mb.cast(receiverType);
            mb.dup();
            mb.cast(this.leftInterfaceType);
            this.rightOperand.generateExpression(acb, mb);
            mb.cast(this.rightInterfaceType);
        } else {
            this.receiver = this.rightOperand;
            receiverType = this.operatorType == -1 ? this.getReceiverInterfaceName() : this.rightInterfaceType;
            this.rightOperand.generateExpression(acb, mb);
            mb.cast(receiverType);
            if (!xmlGen) {
                mb.dup();
                mb.cast(this.rightInterfaceType);
            }
            this.leftOperand.generateExpression(acb, mb);
            mb.cast(this.leftInterfaceType);
            mb.swap();
        }
        String resultTypeName = this.operatorType == -1 ? this.getTypeCompiler().interfaceName() : this.resultInterfaceType;
        boolean bl2 = needField = !this.getTypeId().isBooleanTypeId();
        if (needField) {
            int jdbcType;
            LocalField resultField = acb.newFieldDeclaration(2, resultTypeName);
            mb.getField(resultField);
            this.initializeResultField(acb, mb, resultField);
            if (this.isForAVG()) {
                String typeName = this.leftOperand.getTypeId().getSQLTypeName();
                if (typeName.equals("TINYINT") || typeName.equals("SMALLINT") || typeName.equals("INTEGER") || typeName.equals("BIGINT")) {
                    boolean scale = false;
                } else if (typeName.equals("REAL") || typeName.equals("DOUBLE")) {
                    int scale = 127;
                } else {
                    int scale = 4;
                }
                mb.push(this.getTypeServices().getScale());
                mb.callMethod((short)185, receiverType, this.methodName, resultTypeName, 4);
            } else if (this.getTypeServices() != null && ((jdbcType = this.getTypeServices().getJDBCTypeId()) == 3 || jdbcType == 2) && this.operator.equals("/")) {
                mb.push(this.getTypeServices().getScale());
                mb.callMethod((short)185, receiverType, this.methodName, resultTypeName, 4);
            } else if (xmlGen) {
                mb.callMethod((short)182, null, this.methodName, resultTypeName, 3);
            } else {
                mb.callMethod((short)185, receiverType, this.methodName, resultTypeName, 3);
            }
            if (this.getTypeId().variableLength() && this.getTypeId().isNumericTypeId()) {
                mb.dup();
                mb.push(this.getTypeServices().getPrecision());
                mb.push(this.getTypeServices().getScale());
                mb.push(true);
                mb.callMethod((short)185, "com.pivotal.gemfirexd.internal.iapi.types.VariableSizeDataValue", "setWidth", "void", 3);
            }
            mb.putField(resultField);
        } else if (xmlGen) {
            mb.callMethod((short)182, null, this.methodName, resultTypeName, 2);
        } else {
            mb.callMethod((short)185, receiverType, this.methodName, resultTypeName, 2);
        }
    }

    protected void initializeResultField(ExpressionClassBuilder acb, MethodBuilder mb, LocalField resultField) throws StandardException {
    }

    public void setLeftOperand(ValueNode newLeftOperand) {
        this.leftOperand = newLeftOperand;
    }

    public ValueNode getLeftOperand() {
        return this.leftOperand;
    }

    public void setRightOperand(ValueNode newRightOperand) {
        this.rightOperand = newRightOperand;
    }

    public ValueNode getRightOperand() {
        return this.rightOperand;
    }

    @Override
    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        boolean pushable = this.leftOperand.categorize(referencedTabs, simplePredsOnly);
        pushable = this.rightOperand.categorize(referencedTabs, simplePredsOnly) && pushable;
        return pushable;
    }

    @Override
    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.leftOperand = this.leftOperand.remapColumnReferencesToExpressions();
        this.rightOperand = this.rightOperand.remapColumnReferencesToExpressions();
        return this;
    }

    @Override
    public boolean isConstantExpression() {
        return this.leftOperand.isConstantExpression() && this.rightOperand.isConstantExpression();
    }

    @Override
    public boolean constantExpression(PredicateList whereClause) {
        return this.leftOperand.constantExpression(whereClause) && this.rightOperand.constantExpression(whereClause);
    }

    public String getReceiverInterfaceName() throws StandardException {
        SanityManager.ASSERT((this.receiver != null ? 1 : 0) != 0, (String)"can't get receiver interface name until receiver is set");
        return this.receiver.getTypeCompiler().interfaceName();
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        int leftType = this.leftOperand.getOrderableVariantType();
        int rightType = this.rightOperand.getOrderableVariantType();
        return Math.min(leftType, rightType);
    }

    void swapOperands() {
        String tmpInterfaceType = this.leftInterfaceType;
        ValueNode tmpVN = this.leftOperand;
        this.leftOperand = this.rightOperand;
        this.rightOperand = tmpVN;
        this.leftInterfaceType = this.rightInterfaceType;
        this.rightInterfaceType = tmpInterfaceType;
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = v.visit(this);
        if (v.skipChildren(this)) {
            return returnNode;
        }
        if (this.leftOperand != null && !v.stopTraversal()) {
            this.leftOperand = (ValueNode)this.leftOperand.accept(v);
        }
        if (this.rightOperand != null && !v.stopTraversal()) {
            this.rightOperand = (ValueNode)this.rightOperand.accept(v);
        }
        return returnNode;
    }

    @Override
    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (!this.isSameNodeType(o)) {
            return false;
        }
        BinaryOperatorNode other = (BinaryOperatorNode)o;
        return this.methodName.equals(other.methodName) && this.leftOperand.isEquivalent(other.leftOperand) && this.rightOperand.isEquivalent(other.rightOperand);
    }

    private int addXmlOpMethodParams(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        acb.pushThisAsActivation(mb);
        mb.push(this.getCompilerContext().addSavedObject(this.sqlxUtil));
        return 2;
    }

    @Override
    public ValueNode genExpressionOperands(ResultColumnList outerResultColumns, ResultColumn parentRC, boolean remapToNew) throws StandardException {
        if (parentRC != null) {
            parentRC.markExpanded();
        }
        this.leftOperand = this.leftOperand.genExpressionOperands(outerResultColumns, null, remapToNew);
        this.rightOperand = this.rightOperand.genExpressionOperands(outerResultColumns, null, remapToNew);
        return this;
    }

    public String getOperatorString() {
        return this.operator;
    }

    boolean isForAVG() {
        return false;
    }

    @Override
    public String printExplainInfo() {
        return "(" + this.leftOperand.printExplainInfo() + " " + this.operator + " " + this.rightOperand.printExplainInfo() + ")";
    }

    @Override
    public String ncjGenerateSql() {
        String rightSQL = this.rightOperand.ncjGenerateSql();
        String leftSQL = this.leftOperand.ncjGenerateSql();
        if (rightSQL == null || leftSQL == null || rightSQL.equalsIgnoreCase("false") || leftSQL.equalsIgnoreCase("false")) {
            return null;
        }
        if (rightSQL.equalsIgnoreCase("true")) {
            if (leftSQL.equalsIgnoreCase("true")) {
                return null;
            }
            return leftSQL;
        }
        return "(" + leftSQL + " " + this.operator + " " + rightSQL + ")";
    }
}

