/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.CatalogRowFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.PermissionsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;

abstract class PermissionsCatalogRowFactory
extends CatalogRowFactory {
    PermissionsCatalogRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
    }

    DataValueDescriptor getAuthorizationID(String value) {
        return new SQLVarchar(value);
    }

    DataValueDescriptor getNullAuthorizationID() {
        return new SQLVarchar();
    }

    String getAuthorizationID(ExecRow row, int columnPos) throws StandardException {
        return row.getColumn(columnPos).getString();
    }

    abstract ExecIndexRow buildIndexKeyRow(int var1, PermissionsDescriptor var2) throws StandardException;

    abstract int orPermissions(ExecRow var1, PermissionsDescriptor var2, boolean[] var3) throws StandardException;

    abstract int removePermissions(ExecRow var1, PermissionsDescriptor var2, boolean[] var3) throws StandardException;

    abstract void setUUIDOfThePassedDescriptor(ExecRow var1, PermissionsDescriptor var2) throws StandardException;

    public int getLdapGroupColumnNumber() {
        return -1;
    }
}

