/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.CatalogRowFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.GfxdGatewayReceiverDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.SystemColumnImpl;

public class GfxdSysGatewayReceiverRowFactory
extends CatalogRowFactory {
    public static final String TABLENAME_STRING = "GATEWAYRECEIVERS";
    public static final int GATEWAYRECEIVER_COLUMN_COUNT = 9;
    public static final int ID = 1;
    public static final int RUNNING_PORT = 2;
    public static final int START_PORT = 3;
    public static final int END_PORT = 4;
    public static final int SERVER_GROUPS = 5;
    public static final int SOCKET_BUFFER_SIZE = 6;
    public static final int MAX_TIME_BETWEEN_PINGS = 7;
    public static final int BIND_ADDRESS = 8;
    public static final int HOST_NAME_FOR_SENDERS = 9;
    private static final int[][] indexColumnPositions = new int[][]{{1}};
    private static final boolean[] uniqueness = null;
    private static final String[] uuids = new String[]{"r073400e-00b6-fdfc-71ce-000b0a763800", "r073400e-00b6-fbba-75d4-000b0a763800", "r073400e-00b6-00b9-bbde-000b0a763800"};

    GfxdSysGatewayReceiverRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(9, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        UUID uuid = null;
        String id = null;
        String serverGroup = null;
        Integer startPort = null;
        Integer endPort = null;
        Integer runningPort = null;
        Integer maxTimeBetPings = null;
        Integer socketBufferSize = null;
        String bindAdd = null;
        String hostNameForSenders = null;
        if (td != null) {
            GfxdGatewayReceiverDescriptor dsd = (GfxdGatewayReceiverDescriptor)td;
            uuid = dsd.getUUID();
            id = dsd.getId();
            runningPort = dsd.getRunningPort();
            startPort = dsd.getStartPort();
            endPort = dsd.getEndPort();
            serverGroup = dsd.getServerGroup();
            socketBufferSize = dsd.getSocketBufferSize();
            maxTimeBetPings = dsd.getMaxTimeBetweenPings();
            bindAdd = dsd.getBindAddress();
            hostNameForSenders = dsd.getHostNameForSenders();
        }
        ExecRow row = this.getExecutionFactory().getValueRow(9);
        row.setColumn(1, new SQLChar(id));
        row.setColumn(2, new SQLInteger(runningPort));
        row.setColumn(3, new SQLInteger(startPort));
        row.setColumn(4, new SQLInteger(endPort));
        row.setColumn(5, new SQLChar(serverGroup));
        row.setColumn(6, new SQLInteger(socketBufferSize));
        row.setColumn(7, new SQLInteger(maxTimeBetPings));
        row.setColumn(8, new SQLChar(bindAdd));
        row.setColumn(9, new SQLChar(hostNameForSenders));
        return row;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentDesc, DataDictionary dd) throws StandardException {
        SanityManager.ASSERT((row.nColumns() == 9 ? 1 : 0) != 0, (String)"Wrong number of columns for a GATEWAYRECEIVERS row");
        DataValueDescriptor col = row.getColumn(1);
        String id = col.getString();
        UUID uuid = this.getUUIDFactory().recreateUUID(id);
        col = row.getColumn(2);
        Integer runningPort = col.getInt();
        col = row.getColumn(3);
        Integer startPort = col.getInt();
        col = row.getColumn(4);
        Integer endPort = col.getInt();
        col = row.getColumn(5);
        String serverGroups = col.getString();
        col = row.getColumn(6);
        Integer socketBufferSize = col.getInt();
        col = row.getColumn(7);
        Integer maxTimeBetweenPings = col.getInt();
        col = row.getColumn(8);
        String bindAdd = col.getString();
        col = row.getColumn(9);
        String hostNameForSenders = col.getString();
        return new GfxdGatewayReceiverDescriptor(dd, uuid, id, serverGroups, startPort, endPort, runningPort, socketBufferSize, maxTimeBetweenPings, bindAdd, hostNameForSenders);
    }

    @Override
    public SystemColumn[] buildColumnList() {
        return new SystemColumn[]{SystemColumnImpl.getIdentifierColumn("ID", false), SystemColumnImpl.getColumn("RUNNING_PORT", 4, false), SystemColumnImpl.getColumn("START_PORT", 4, false), SystemColumnImpl.getColumn("END_PORT", 4, false), SystemColumnImpl.getColumn("SERVER_GROUPS", 12, false), SystemColumnImpl.getColumn("SOCKET_BUFFER_SIZE", 4, false), SystemColumnImpl.getColumn("MAX_TIME_BETWEEN_PINGS", 4, false), SystemColumnImpl.getColumn("BIND_ADDRESS", 12, false), SystemColumnImpl.getColumn("HOST_NAME_FOR_SENDERS", 12, false)};
    }
}

