/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.monitor;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.PersistentService;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.services.monitor.BaseMonitor;
import com.pivotal.gemfirexd.internal.impl.services.monitor.ModuleInstance;
import com.pivotal.gemfirexd.internal.impl.services.monitor.ProtocolKey;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

final class TopService {
    ProtocolKey key;
    ModuleInstance topModule;
    Hashtable protocolTable;
    Vector moduleInstances;
    BaseMonitor monitor;
    boolean inShutdown;
    PersistentService serviceType;
    Locale serviceLocale;

    TopService(BaseMonitor monitor) {
        this.monitor = monitor;
        this.protocolTable = new Hashtable();
        this.moduleInstances = new Vector(0, 5);
    }

    TopService(BaseMonitor monitor, ProtocolKey key, PersistentService serviceType, Locale serviceLocale) {
        this(monitor);
        this.key = key;
        this.serviceType = serviceType;
        this.serviceLocale = serviceLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTopModule(Object instance) {
        TopService topService = this;
        synchronized (topService) {
            for (int i = 0; i < this.moduleInstances.size(); ++i) {
                ModuleInstance module = (ModuleInstance)this.moduleInstances.elementAt(i);
                if (module.getInstance() != instance) continue;
                this.topModule = module;
                this.notifyAll();
                break;
            }
            if (this.getServiceType() != null) {
                ProtocolKey userKey = new ProtocolKey(this.key.getFactoryInterface(), this.monitor.getServiceName(instance));
                this.addToProtocol(userKey, this.topModule);
            }
        }
    }

    Object getService() {
        return this.topModule.getInstance();
    }

    boolean isPotentialService(ProtocolKey otherKey) {
        String otherCanonicalName;
        if (this.serviceType == null) {
            otherCanonicalName = otherKey.getIdentifier();
        } else {
            try {
                otherCanonicalName = this.serviceType.getCanonicalServiceName(otherKey.getIdentifier());
            }
            catch (StandardException se) {
                return false;
            }
            if (otherCanonicalName == null) {
                return false;
            }
        }
        if (this.topModule != null) {
            return this.topModule.isTypeAndName(this.serviceType, this.key.getFactoryInterface(), otherCanonicalName);
        }
        if (!otherKey.getFactoryInterface().isAssignableFrom(this.key.getFactoryInterface())) {
            return false;
        }
        return this.serviceType.isSameService(this.key.getIdentifier(), otherCanonicalName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isActiveService() {
        TopService topService = this;
        synchronized (topService) {
            return this.topModule != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isActiveService(ProtocolKey otherKey) {
        TopService topService = this;
        synchronized (topService) {
            if (this.inShutdown) {
                return false;
            }
            if (!this.isPotentialService(otherKey)) {
                return false;
            }
            if (this.topModule != null) {
                SanityManager.ASSERT((boolean)this.topModule.isTypeAndName(this.serviceType, this.key.getFactoryInterface(), this.key.getIdentifier()));
                return true;
            }
            while (!this.inShutdown && this.topModule == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException ioe) {
                    return false;
                }
            }
            return !this.inShutdown;
            {
            }
        }
    }

    synchronized Object findModule(ProtocolKey key, boolean findOnly, Properties properties) {
        ModuleInstance module = (ModuleInstance)this.protocolTable.get(key);
        if (module == null) {
            return null;
        }
        Object instance = module.getInstance();
        if (findOnly || BaseMonitor.canSupport(key.getIdentifier(), instance, properties)) {
            return instance;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object bootModule(boolean create, Object service, ProtocolKey key, Properties properties) throws StandardException {
        TopService topService = this;
        synchronized (topService) {
            if (this.inShutdown) {
                throw StandardException.newException("08006.D", this.getKey().getIdentifier());
            }
        }
        Object instance = this.findModule(key, false, properties);
        if (instance != null) {
            return instance;
        }
        if (this.monitor.reportOn) {
            this.monitor.report("Booting Module   " + key.toString() + " create = " + create);
        }
        TopService topService2 = this;
        synchronized (topService2) {
            for (int i = 0; i < this.moduleInstances.size(); ++i) {
                ModuleInstance module = (ModuleInstance)this.moduleInstances.elementAt(i);
                if (!module.isTypeAndName(null, key.getFactoryInterface(), key.getIdentifier())) continue;
                instance = module.getInstance();
                if (!BaseMonitor.canSupport(module.getIdentifier(), instance, properties) || !this.addToProtocol(key, module)) continue;
                if (this.monitor.reportOn) {
                    this.monitor.report("Started Module   " + key.toString());
                    this.monitor.report("  Implementation " + instance.getClass().getName());
                }
                return instance;
            }
        }
        instance = this.monitor.loadInstance(key.getFactoryInterface(), properties, key.getIdentifier());
        if (instance == null) {
            throw Monitor.missingImplementation(key.getFactoryInterface().getName());
        }
        ModuleInstance module = new ModuleInstance(instance, key.getIdentifier(), service, this.topModule == null ? (Object)null : this.topModule.getInstance());
        TopService topService3 = this;
        synchronized (topService3) {
            this.moduleInstances.addElement(module);
            try {
                BaseMonitor.boot(instance, create, properties);
            }
            catch (StandardException se) {
                this.moduleInstances.removeElement(module);
                throw se;
            }
            if (this.addToProtocol(key, module)) {
                if (this.monitor.reportOn) {
                    this.monitor.report("Started Module   " + key.toString());
                    this.monitor.report("  Implementation " + module.getInstance().getClass().getName());
                }
                return module.getInstance();
            }
        }
        TopService.stop(instance);
        this.moduleInstances.removeElement(module);
        return this.findModule(key, true, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shutdown() {
        TopService topService = this;
        synchronized (topService) {
            if (this.inShutdown) {
                return false;
            }
            this.inShutdown = true;
            this.notifyAll();
        }
        while (true) {
            ModuleInstance module;
            TopService topService2 = this;
            synchronized (topService2) {
                if (this.moduleInstances.isEmpty()) {
                    return true;
                }
                module = (ModuleInstance)this.moduleInstances.elementAt(0);
            }
            Object instance = module.getInstance();
            TopService.stop(instance);
            TopService topService3 = this;
            synchronized (topService3) {
                this.moduleInstances.removeElementAt(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addToProtocol(ProtocolKey key, ModuleInstance module) {
        String identifier = module.getIdentifier();
        TopService topService = this;
        synchronized (topService) {
            Object value = this.protocolTable.get(key);
            if (value == null) {
                this.protocolTable.put(key, module);
                return true;
            }
            return value == module;
            {
            }
        }
    }

    boolean inService(Object instance) {
        for (int i = 0; i < this.moduleInstances.size(); ++i) {
            ModuleInstance mi = (ModuleInstance)this.moduleInstances.elementAt(i);
            if (mi.getInstance() != instance) continue;
            return true;
        }
        return false;
    }

    public ProtocolKey getKey() {
        return this.key;
    }

    PersistentService getServiceType() {
        return this.serviceType;
    }

    private static void stop(Object instance) {
        if (instance instanceof ModuleControl) {
            ((ModuleControl)instance).stop();
        }
    }
}

