/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.locks;

import com.pivotal.gemfirexd.internal.iapi.services.locks.Latch;
import com.pivotal.gemfirexd.internal.impl.services.locks.Control;
import com.pivotal.gemfirexd.internal.impl.services.locks.Lock;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;

class LockTableVTI
implements Enumeration {
    private final Iterator outerControl;
    private Control control;
    private ListIterator grantedList;
    private ListIterator waitingList;
    private Latch nextLock;

    LockTableVTI(Map clonedLockTable) {
        this.outerControl = clonedLockTable.values().iterator();
    }

    @Override
    public boolean hasMoreElements() {
        if (this.nextLock != null) {
            return true;
        }
        while (true) {
            if (this.control == null) {
                List waiting;
                if (!this.outerControl.hasNext()) {
                    return false;
                }
                this.control = (Control)this.outerControl.next();
                List granted = this.control.getGranted();
                if (granted != null) {
                    this.grantedList = granted.listIterator();
                }
                if ((waiting = this.control.getWaiting()) != null) {
                    this.waitingList = waiting.listIterator();
                }
                this.nextLock = this.control.getFirstGrant();
                if (this.nextLock == null) {
                    this.nextLock = this.getNextLock(this.control);
                }
            } else {
                this.nextLock = this.getNextLock(this.control);
            }
            if (this.nextLock != null) {
                return true;
            }
            this.control = null;
        }
    }

    private Latch getNextLock(Control control) {
        Lock lock = null;
        if (this.grantedList != null) {
            if (this.grantedList.hasNext()) {
                lock = (Lock)this.grantedList.next();
            } else {
                this.grantedList = null;
            }
        }
        if (lock == null && this.waitingList != null) {
            if (this.waitingList.hasNext()) {
                lock = (Lock)this.waitingList.next();
            } else {
                this.waitingList = null;
            }
        }
        return lock;
    }

    public Object nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        Latch ret = this.nextLock;
        this.nextLock = null;
        return ret;
    }
}

