/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.load;

import com.pivotal.gemfirexd.internal.iapi.services.io.DynamicByteArrayOutputStream;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.load.ControlInfo;
import com.pivotal.gemfirexd.internal.impl.load.ExportResultSetForObject;
import com.pivotal.gemfirexd.internal.impl.load.ExportWriteDataAbstract;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;

abstract class ExportAbstract {
    protected ControlInfo controlFileReader;
    protected ExportResultSetForObject exportResultSetForObject;
    protected ExportWriteDataAbstract exportWriteData;
    protected Connection con;
    protected String entityName;
    protected String schemaName;
    protected String selectStatement;
    protected boolean lobsInExtFile = false;

    ExportAbstract() {
    }

    protected ResultSet resultSetForEntity() throws Exception {
        this.exportResultSetForObject = new ExportResultSetForObject(this.con, this.schemaName, this.entityName, this.selectStatement);
        ResultSet rs = this.exportResultSetForObject.getResultSet();
        return rs;
    }

    private String[] getOneRowAtATime(ResultSet rs, boolean[] isLargeBinary, boolean[] isLargeChar) throws Exception {
        int columnCount = this.exportResultSetForObject.getColumnCount();
        ResultSetMetaData rsm = rs.getMetaData();
        if (rs.next()) {
            String[] rowObjects = new String[columnCount];
            for (int colNum = 0; colNum < columnCount; ++colNum) {
                if (this.lobsInExtFile && (isLargeChar[colNum] || isLargeBinary[colNum])) {
                    String LobExtLocation;
                    if (isLargeBinary[colNum]) {
                        InputStream is = rs.getBinaryStream(colNum + 1);
                        LobExtLocation = this.exportWriteData.writeBinaryColumnToExternalFile(is);
                    } else {
                        Reader ir = rs.getCharacterStream(colNum + 1);
                        LobExtLocation = this.exportWriteData.writeCharColumnToExternalFile(ir);
                    }
                    rowObjects[colNum] = LobExtLocation;
                    continue;
                }
                int jdbcColumnNumber = colNum + 1;
                String columnValue = rsm.getColumnType(jdbcColumnNumber) == 2000 ? ExportAbstract.stringifyObject(rs.getObject(jdbcColumnNumber)) : rs.getString(jdbcColumnNumber);
                rowObjects[colNum] = columnValue;
            }
            return rowObjects;
        }
        rs.close();
        this.exportResultSetForObject.close();
        return null;
    }

    public static String stringifyObject(Object udt) throws Exception {
        DynamicByteArrayOutputStream dbaos = new DynamicByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream((OutputStream)((Object)dbaos));
        oos.writeObject(udt);
        byte[] buffer = dbaos.getByteArray();
        int length = dbaos.getUsed();
        return StringUtil.toHexString(buffer, 0, length);
    }

    protected ControlInfo getControlFileReader() {
        return this.controlFileReader;
    }

    protected abstract ExportWriteDataAbstract getExportWriteData() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAllTheWork() throws Exception {
        ResultSet rs = null;
        try {
            rs = this.resultSetForEntity();
            if (rs != null) {
                ResultSetMetaData rsmeta = rs.getMetaData();
                int ncols = rsmeta.getColumnCount();
                boolean[] isNumeric = new boolean[ncols];
                boolean[] isLargeChar = new boolean[ncols];
                boolean[] isLargeBinary = new boolean[ncols];
                for (int i = 0; i < ncols; ++i) {
                    int ctype = rsmeta.getColumnType(i + 1);
                    isNumeric[i] = ctype == -5 || ctype == 3 || ctype == 8 || ctype == 6 || ctype == 4 || ctype == 2 || ctype == 7 || ctype == 5 || ctype == -6;
                    isLargeChar[i] = ctype == 2005 || ctype == 4001;
                    isLargeBinary[i] = ctype == 2004;
                }
                this.exportWriteData = this.getExportWriteData();
                this.exportWriteData.writeColumnDefinitionOptionally(this.exportResultSetForObject.getColumnDefinition(), this.exportResultSetForObject.getColumnTypes());
                this.exportWriteData.setColumnLengths(this.controlFileReader.getColumnWidths());
                String[] oneRow = this.getOneRowAtATime(rs, isLargeBinary, isLargeChar);
                while (oneRow != null) {
                    this.exportWriteData.writeData(oneRow, isNumeric);
                    oneRow = this.getOneRowAtATime(rs, isLargeBinary, isLargeChar);
                }
            }
        }
        finally {
            if (this.exportWriteData != null) {
                this.exportWriteData.noMoreRows();
            }
            if (rs != null) {
                rs.close();
            }
        }
    }
}

