/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.Resetable;
import com.pivotal.gemfirexd.internal.impl.jdbc.ConnectionChild;
import com.pivotal.gemfirexd.internal.impl.jdbc.PositionedStoreStream;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.sql.SQLException;

public final class UTF8Reader
extends Reader {
    private static final String READER_CLOSED = "Reader closed";
    private static final int MAXIMUM_BUFFER_SIZE = 8192;
    private InputStream in;
    private final PositionedStoreStream positionedIn;
    private long rawStreamPos = 0L;
    private final long utfLen;
    private long utfCount;
    private long readerCharCount;
    private final long maxFieldSize;
    private final char[] buffer;
    private int charactersInBuffer;
    private int readPositionInBuffer;
    private boolean noMoreReads;
    private ConnectionChild parent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UTF8Reader(InputStream in, long maxFieldSize, ConnectionChild parent, Object synchronization) throws IOException, SQLException {
        super(synchronization);
        this.maxFieldSize = maxFieldSize;
        this.parent = parent;
        if (parent != null) {
            parent.setupContextStack(false);
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                this.in = in;
                if (in instanceof PositionedStoreStream) {
                    this.positionedIn = (PositionedStoreStream)in;
                    try {
                        this.positionedIn.resetStream();
                    }
                    catch (StandardException se) {
                        throw Util.newIOException(se);
                    }
                } else {
                    this.positionedIn = null;
                }
                this.utfLen = this.readUnsignedShort();
                if (this.positionedIn != null) {
                    this.rawStreamPos = this.positionedIn.getPosition();
                }
            }
        }
        finally {
            if (parent != null) {
                parent.restoreContextStack();
            }
        }
        int bufferSize = this.calculateBufferSize(this.utfLen, maxFieldSize);
        this.buffer = new char[bufferSize];
        if (this.positionedIn == null) {
            this.in = new BufferedInputStream(in, bufferSize);
        }
    }

    public UTF8Reader(InputStream in, long maxFieldSize, long streamSize, ConnectionChild parent, Object synchronization) {
        super(synchronization);
        this.maxFieldSize = maxFieldSize;
        this.parent = parent;
        this.utfLen = streamSize;
        this.positionedIn = null;
        SanityManager.ASSERT((!(in instanceof Resetable) ? 1 : 0) != 0);
        int bufferSize = this.calculateBufferSize(streamSize, maxFieldSize);
        this.buffer = new char[bufferSize];
        this.in = new BufferedInputStream(in, bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.noMoreReads) {
                throw new IOException(READER_CLOSED);
            }
            if (this.readPositionInBuffer >= this.charactersInBuffer) {
                if (this.fillBuffer()) {
                    return -1;
                }
                this.readPositionInBuffer = 0;
            }
            return this.buffer[this.readPositionInBuffer++];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int remainingInBuffer;
            if (this.noMoreReads) {
                throw new IOException(READER_CLOSED);
            }
            if (this.readPositionInBuffer >= this.charactersInBuffer) {
                if (this.fillBuffer()) {
                    return -1;
                }
                this.readPositionInBuffer = 0;
            }
            if (len > (remainingInBuffer = this.charactersInBuffer - this.readPositionInBuffer)) {
                len = remainingInBuffer;
            }
            System.arraycopy(this.buffer, this.readPositionInBuffer, cbuf, off, len);
            this.readPositionInBuffer += len;
            return len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long len) throws IOException {
        if (len < 0L) {
            throw new IllegalArgumentException("Number of characters to skip must be positive: " + len);
        }
        Object object = this.lock;
        synchronized (object) {
            int remainingInBuffer;
            if (this.noMoreReads) {
                throw new IOException(READER_CLOSED);
            }
            if (this.readPositionInBuffer >= this.charactersInBuffer) {
                if (this.fillBuffer()) {
                    return 0L;
                }
                this.readPositionInBuffer = 0;
            }
            if (len > (long)(remainingInBuffer = this.charactersInBuffer - this.readPositionInBuffer)) {
                len = remainingInBuffer;
            }
            this.readPositionInBuffer = (int)((long)this.readPositionInBuffer + len);
            return len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.closeIn();
            this.parent = null;
            this.noMoreReads = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInto(StringBuilder sb, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int remainingInBuffer;
            if (this.readPositionInBuffer >= this.charactersInBuffer) {
                if (this.fillBuffer()) {
                    return -1;
                }
                this.readPositionInBuffer = 0;
            }
            if (len > (remainingInBuffer = this.charactersInBuffer - this.readPositionInBuffer)) {
                len = remainingInBuffer;
            }
            sb.append(this.buffer, this.readPositionInBuffer, len);
            this.readPositionInBuffer += len;
            return len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readAsciiInto(byte[] abuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int remainingInBuffer;
            if (this.readPositionInBuffer >= this.charactersInBuffer) {
                if (this.fillBuffer()) {
                    return -1;
                }
                this.readPositionInBuffer = 0;
            }
            if (len > (remainingInBuffer = this.charactersInBuffer - this.readPositionInBuffer)) {
                len = remainingInBuffer;
            }
            char[] lbuffer = this.buffer;
            for (int i = 0; i < len; ++i) {
                char c = lbuffer[this.readPositionInBuffer + i];
                int cb = c <= '\u00ff' ? (int)((byte)c) : 63;
                abuf[off + i] = cb;
            }
            this.readPositionInBuffer += len;
            return len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeIn() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.in = null;
            }
        }
    }

    private IOException utfFormatException(String s) {
        this.noMoreReads = true;
        this.closeIn();
        return new UTFDataFormatException(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fillBuffer() throws IOException {
        if (this.in == null) {
            return true;
        }
        this.charactersInBuffer = 0;
        try {
            try {
                int c;
                if (this.parent != null) {
                    this.parent.setupContextStack(false);
                }
                if (this.positionedIn != null) {
                    try {
                        this.positionedIn.reposition(this.rawStreamPos);
                    }
                    catch (StandardException se) {
                        throw Util.generateCsSQLException(se);
                    }
                }
                block13: while (!(this.charactersInBuffer >= this.buffer.length || this.utfCount >= this.utfLen && this.utfLen != 0L || this.maxFieldSize != 0L && this.readerCharCount >= this.maxFieldSize)) {
                    int finalChar;
                    c = this.in.read();
                    if (c == -1) {
                        if (this.utfLen != 0L) throw this.utfFormatException("Reached EOF prematurely, read " + this.utfCount + " out of " + this.utfLen + " bytes");
                        this.closeIn();
                        break;
                    }
                    switch (c >> 4) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            ++this.utfCount;
                            finalChar = c;
                            break;
                        }
                        case 12: 
                        case 13: {
                            this.utfCount += 2L;
                            int char2 = this.in.read();
                            if (char2 == -1) {
                                throw this.utfFormatException("Reached EOF when reading second byte in a two byte character encoding; byte/char position " + this.utfCount + "/" + this.readerCharCount);
                            }
                            if ((char2 & 0xC0) != 128) {
                                throw this.utfFormatException("Second byte in a two bytecharacter encoding invalid: (int)" + char2 + ", byte/char pos " + this.utfCount + "/" + this.readerCharCount);
                            }
                            finalChar = (c & 0x1F) << 6 | char2 & 0x3F;
                            break;
                        }
                        case 14: {
                            this.utfCount += 3L;
                            int char2 = this.in.read();
                            int char3 = this.in.read();
                            if (char2 == -1) throw this.utfFormatException("Reached EOF when reading second/third byte in a three byte character encoding; byte/char position " + this.utfCount + "/" + this.readerCharCount);
                            if (char3 == -1) {
                                throw this.utfFormatException("Reached EOF when reading second/third byte in a three byte character encoding; byte/char position " + this.utfCount + "/" + this.readerCharCount);
                            }
                            if (c == 224 && char2 == 0 && char3 == 0) {
                                if (this.utfLen != 0L) throw this.utfFormatException("Internal error: Derby-specific EOF marker read");
                                this.closeIn();
                                break block13;
                            }
                            if ((char2 & 0xC0) != 128) throw this.utfFormatException("Second/third byte in a three byte character encoding invalid: (int)" + char2 + "/" + char3 + ", byte/char pos " + this.utfCount + "/" + this.readerCharCount);
                            if ((char3 & 0xC0) != 128) {
                                throw this.utfFormatException("Second/third byte in a three byte character encoding invalid: (int)" + char2 + "/" + char3 + ", byte/char pos " + this.utfCount + "/" + this.readerCharCount);
                            }
                            finalChar = (c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0;
                            break;
                        }
                        default: {
                            throw this.utfFormatException("Invalid UTF encoding at byte/char position " + this.utfCount + "/" + this.readerCharCount + ": (int)" + c);
                        }
                    }
                    this.buffer[this.charactersInBuffer++] = (char)finalChar;
                    ++this.readerCharCount;
                }
                if (this.utfLen != 0L && this.utfCount > this.utfLen) {
                    throw this.utfFormatException("Incorrect encoded length in stream, expected " + this.utfLen + ", have " + this.utfCount + " bytes");
                }
                if (this.charactersInBuffer != 0) {
                    if (this.positionedIn != null) {
                        this.rawStreamPos = this.positionedIn.getPosition();
                    }
                    c = 0;
                    return c != 0;
                }
                this.closeIn();
                c = 1;
                return c != 0;
            }
            finally {
                if (this.parent != null) {
                    this.parent.restoreContextStack();
                }
            }
        }
        catch (SQLException sqle) {
            throw Util.newIOException(sqle);
        }
    }

    private final int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException("Reached EOF when readingencoded length bytes");
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    private final int calculateBufferSize(long encodedSize, long maxFieldSize) {
        int bufferSize = 8192;
        if (encodedSize > 0L && encodedSize < (long)bufferSize) {
            bufferSize = (int)encodedSize;
        }
        if (maxFieldSize > 0L && maxFieldSize < (long)bufferSize) {
            bufferSize = (int)maxFieldSize;
        }
        return bufferSize;
    }
}

