/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.drda;

import com.pivotal.gemfirexd.internal.impl.drda.CcsidManager;

final class DRDAString {
    private byte[] buffer = new byte[0];
    private final CcsidManager ccsidManager;
    private boolean modified;
    private String cachedString;

    DRDAString(CcsidManager m) {
        this.ccsidManager = m;
        this.cachedString = null;
    }

    private boolean equalTo(byte[] buf, int offset, int size) {
        int len = this.buffer.length;
        if (len != size) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.buffer[i] == buf[i + offset]) continue;
            return false;
        }
        return true;
    }

    public void setBytes(byte[] src, int offset, int size) {
        if (this.equalTo(src, offset, size)) {
            this.modified = false;
            return;
        }
        if (this.buffer.length != size) {
            this.buffer = new byte[size];
        }
        System.arraycopy(src, offset, this.buffer, 0, size);
        this.modified = true;
        this.cachedString = null;
    }

    public void setString(String s) {
        this.buffer = this.ccsidManager.convertFromUCS2(s);
        this.modified = true;
        this.cachedString = s;
    }

    public boolean wasModified() {
        return this.modified;
    }

    public String toString() {
        if (this.cachedString == null) {
            this.cachedString = this.ccsidManager.convertToUCS2(this.buffer);
        }
        return this.cachedString;
    }

    public int length() {
        return this.buffer.length;
    }

    public byte[] getBytes() {
        return this.buffer;
    }
}

