/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.gemstone.gemfire.internal.offheap.ByteSource;
import com.gemstone.gemfire.internal.shared.ClientSharedData;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.ByteArrayDataOutput;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.LocaleFinder;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DateTimeDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.DateTimeParser;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTimestamp;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;

public final class SQLDate
extends DataType
implements DateTimeDataValue {
    private int encodedDate;
    private String valueString;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLDate.class);
    static final char ISO_SEPARATOR = '-';
    private static final char[] ISO_SEPARATOR_ONLY = new char[]{'-'};
    private static final char IBM_USA_SEPARATOR = '/';
    private static final char[] IBM_USA_SEPARATOR_ONLY = new char[]{'/'};
    private static final char IBM_EUR_SEPARATOR = '.';
    private static final char[] IBM_EUR_SEPARATOR_ONLY = new char[]{'.'};
    private static final char[] END_OF_STRING = new char[]{'\u0000'};
    public static final int DATE_CHARS = 10;

    @Override
    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE + ClassSize.estimateMemoryUsage(this.valueString);
    }

    @Override
    public final int getEncodedTime() {
        return 0;
    }

    @Override
    public final int getNanos() {
        return 0;
    }

    @Override
    public final int getEncodedDate() {
        return this.encodedDate;
    }

    @Override
    public String getString() {
        if (!this.isNull()) {
            if (this.valueString == null) {
                this.valueString = SQLDate.encodedDateToString(this.encodedDate);
            }
            return this.valueString;
        }
        if (this.valueString != null) {
            SanityManager.THROWASSERT((String)("valueString expected to be null, not " + this.valueString));
        }
        return null;
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) {
        if (this.isNull()) {
            return null;
        }
        return new Timestamp(this.getTimeInMillis(cal));
    }

    private long getTimeInMillis(Calendar cal) {
        if (cal == null) {
            cal = ClientSharedData.getDefaultCalendar();
        }
        cal.clear();
        SQLDate.setDateInCalendar(cal, this.encodedDate);
        return cal.getTimeInMillis();
    }

    public static void setDateInCalendar(Calendar cal, int encodedDate) {
        cal.set(SQLDate.getYear(encodedDate), SQLDate.getMonth(encodedDate) - 1, SQLDate.getDay(encodedDate));
    }

    @Override
    public Object getObject() {
        return this.getDate((Calendar)null);
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public String getTypeName() {
        return "DATE";
    }

    @Override
    public int getTypeFormatId() {
        return 298;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.isNull());
        if (this.isNull()) {
            return;
        }
        SanityManager.ASSERT((!this.isNull() ? 1 : 0) != 0, (String)"writeExternal() is not supposed to be called for null values.");
        out.writeInt(this.encodedDate);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        boolean isNull = in.readBoolean();
        if (isNull) {
            this.setToNull();
            return;
        }
        this.encodedDate = in.readInt();
        this.valueString = null;
    }

    @Override
    public void readExternalFromArray(ArrayInputStream in) throws IOException {
        this.encodedDate = in.readInt();
        this.valueString = null;
    }

    @Override
    public DataValueDescriptor getClone() {
        return new SQLDate(this.encodedDate);
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLDate();
    }

    @Override
    public void restoreToNull() {
        this.encodedDate = 0;
        this.valueString = null;
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException, StandardException {
        this.setValue(resultSet.getDate(colNumber), (Calendar)null);
    }

    @Override
    public int compare(DataValueDescriptor other) throws StandardException {
        if (this.typePrecedence() < other.typePrecedence()) {
            return -Integer.signum(other.compare(this));
        }
        boolean thisNull = this.isNull();
        boolean otherNull = other.isNull();
        if (thisNull || otherNull) {
            if (!thisNull) {
                return -1;
            }
            if (!otherNull) {
                return 1;
            }
            return 0;
        }
        int otherVal = 0;
        otherVal = other instanceof SQLDate ? ((SQLDate)other).encodedDate : SQLDate.computeEncodedDate(other.getDate(ClientSharedData.getDefaultCleanCalendar()));
        int comparison = this.encodedDate > otherVal ? 1 : (this.encodedDate < otherVal ? -1 : 0);
        return comparison;
    }

    @Override
    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        if (!orderedNulls && (this.isNull() || other.isNull())) {
            return unknownRV;
        }
        return super.compare(op, other, orderedNulls, unknownRV);
    }

    public SQLDate() {
    }

    public SQLDate(Date value) throws StandardException {
        this.parseDate(value);
    }

    private void parseDate(java.util.Date value) throws StandardException {
        this.encodedDate = SQLDate.computeEncodedDate(value);
    }

    private SQLDate(int encodedDate) {
        this.encodedDate = encodedDate;
    }

    public SQLDate(String dateStr, boolean isJdbcEscape, LocaleFinder localeFinder) throws StandardException {
        this.parseDate(dateStr, isJdbcEscape, localeFinder, null);
    }

    public SQLDate(String dateStr, boolean isJdbcEscape, LocaleFinder localeFinder, Calendar cal) throws StandardException {
        this.parseDate(dateStr, isJdbcEscape, localeFinder, cal);
    }

    private void parseDate(String dateStr, boolean isJdbcEscape, LocaleFinder localeFinder, Calendar cal) throws StandardException {
        boolean validSyntax = true;
        DateTimeParser parser = new DateTimeParser(dateStr);
        int year = 0;
        int month = 0;
        int day = 0;
        StandardException thrownSE = null;
        try {
            switch (parser.nextSeparator()) {
                case '-': {
                    this.encodedDate = SQLTimestamp.parseDateOrTimestamp(parser, false)[0];
                    this.valueString = parser.getTrimmedString();
                    return;
                }
                case '/': {
                    if (isJdbcEscape) {
                        validSyntax = false;
                        break;
                    }
                    month = parser.parseInt(2, true, IBM_USA_SEPARATOR_ONLY, false);
                    day = parser.parseInt(2, true, IBM_USA_SEPARATOR_ONLY, false);
                    year = parser.parseInt(4, false, END_OF_STRING, false);
                    break;
                }
                case '.': {
                    if (isJdbcEscape) {
                        validSyntax = false;
                        break;
                    }
                    day = parser.parseInt(2, true, IBM_EUR_SEPARATOR_ONLY, false);
                    month = parser.parseInt(2, true, IBM_EUR_SEPARATOR_ONLY, false);
                    year = parser.parseInt(4, false, END_OF_STRING, false);
                    break;
                }
                default: {
                    validSyntax = false;
                    break;
                }
            }
        }
        catch (StandardException se) {
            validSyntax = false;
            thrownSE = se;
        }
        if (validSyntax) {
            this.valueString = parser.checkEnd();
            this.encodedDate = SQLDate.computeEncodedDate(year, month, day);
        } else {
            dateStr = StringUtil.trimTrailing(dateStr);
            DateFormat dateFormat = null;
            dateFormat = localeFinder == null ? DateFormat.getDateInstance() : (cal == null ? localeFinder.getDateFormat() : (DateFormat)localeFinder.getDateFormat().clone());
            if (cal != null) {
                dateFormat.setCalendar(cal);
            }
            try {
                this.encodedDate = SQLDate.computeEncodedDate(dateFormat.parse(dateStr), cal);
            }
            catch (ParseException pe) {
                try {
                    this.encodedDate = SQLTimestamp.parseLocalTimestamp(dateStr, localeFinder, cal)[0];
                }
                catch (ParseException pe2) {
                    if (thrownSE != null) {
                        throw thrownSE;
                    }
                    throw StandardException.newException("22007.S.181", dateStr);
                }
            }
            this.valueString = dateStr;
        }
    }

    @Override
    void setObject(Object theValue) throws StandardException {
        this.setValue((Date)theValue);
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        if (theValue instanceof SQLDate) {
            this.restoreToNull();
            this.encodedDate = ((SQLDate)theValue).encodedDate;
        } else {
            GregorianCalendar cal = ClientSharedData.getDefaultCleanCalendar();
            this.setValue(theValue.getDate(cal), (Calendar)cal);
        }
    }

    @Override
    public void setValue(Date value, Calendar cal) throws StandardException {
        this.restoreToNull();
        this.encodedDate = SQLDate.computeEncodedDate(value, cal);
    }

    @Override
    public void setValue(Timestamp value, Calendar cal) throws StandardException {
        this.restoreToNull();
        this.encodedDate = SQLDate.computeEncodedDate(value, cal);
    }

    @Override
    public void setValue(String theValue) throws StandardException {
        this.restoreToNull();
        if (theValue != null) {
            this.parseDate(theValue, false, Misc.getMemStore().getDatabase(), null);
        }
    }

    NumberDataValue nullValueInt() {
        return new SQLInteger();
    }

    @Override
    public NumberDataValue getYear(NumberDataValue result) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLDate.getYear(this.encodedDate), result);
    }

    @Override
    public NumberDataValue getMonth(NumberDataValue result) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLDate.getMonth(this.encodedDate), result);
    }

    @Override
    public NumberDataValue getDate(NumberDataValue result) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLDate.getDay(this.encodedDate), result);
    }

    @Override
    public NumberDataValue getHours(NumberDataValue result) throws StandardException {
        throw StandardException.newException("42X25", (Object)"getHours", (Object)"Date");
    }

    @Override
    public NumberDataValue getMinutes(NumberDataValue result) throws StandardException {
        throw StandardException.newException("42X25", (Object)"getMinutes", (Object)"Date");
    }

    @Override
    public NumberDataValue getSeconds(NumberDataValue result) throws StandardException {
        throw StandardException.newException("42X25", (Object)"getSeconds", (Object)"Date");
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.getDate((Calendar)null).toString();
    }

    public int hashCode() {
        return this.encodedDate;
    }

    @Override
    public int typePrecedence() {
        return 100;
    }

    @Override
    public final boolean isNull() {
        return this.encodedDate == 0;
    }

    @Override
    public Date getDate(Calendar cal) {
        if (this.isNull()) {
            return null;
        }
        return new Date(this.getTimeInMillis(cal));
    }

    static int getYear(int encodedDate) {
        return encodedDate >>> 16;
    }

    static int getMonth(int encodedDate) {
        return encodedDate >>> 8 & 0xFF;
    }

    static int getDay(int encodedDate) {
        return encodedDate & 0xFF;
    }

    static int computeEncodedDate(Calendar cal) throws StandardException {
        return SQLDate.computeEncodedDate(cal.get(1), cal.get(2) + 1, cal.get(5));
    }

    public static int computeEncodedDate(int y, int m, int d) throws StandardException {
        int maxDay = 31;
        switch (m) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                maxDay = 30;
                break;
            }
            case 2: {
                int n = maxDay = y % 4 == 0 && (y % 100 != 0 || y % 400 == 0) ? 29 : 28;
            }
        }
        if (y < 1 || y > 9999 || m < 1 || m > 12 || d < 1 || d > maxDay) {
            throw StandardException.newException("22007.S.180", "Year = " + y + " Month = " + m + " Day = " + d);
        }
        return (y << 16) + (m << 8) + d;
    }

    static void dateToString(int year, int month, int day, StringBuilder sb) {
        String yearStr = Integer.toString(year);
        for (int i = yearStr.length(); i < 4; ++i) {
            sb.append('0');
        }
        sb.append(yearStr);
        sb.append('-');
        String monthStr = Integer.toString(month);
        String dayStr = Integer.toString(day);
        if (monthStr.length() == 1) {
            sb.append('0');
        }
        sb.append(monthStr);
        sb.append('-');
        if (dayStr.length() == 1) {
            sb.append('0');
        }
        sb.append(dayStr);
    }

    static String encodedDateToString(int encodedDate) {
        StringBuilder vstr = new StringBuilder();
        SQLDate.dateToString(SQLDate.getYear(encodedDate), SQLDate.getMonth(encodedDate), SQLDate.getDay(encodedDate), vstr);
        return vstr.toString();
    }

    @Override
    protected String getNationalString(LocaleFinder localeFinder) throws StandardException {
        if (this.isNull()) {
            return this.getString();
        }
        return localeFinder.getDateFormat().format(this.getDate(ClientSharedData.getDefaultCleanCalendar()));
    }

    static NumberDataValue setSource(int value, NumberDataValue source) throws StandardException {
        if (source == null) {
            source = new SQLInteger();
        }
        source.setValue(value);
        return source;
    }

    private static int computeEncodedDate(java.util.Date value) throws StandardException {
        return SQLDate.computeEncodedDate(value, null);
    }

    static int computeEncodedDate(java.util.Date value, Calendar currentCal) throws StandardException {
        if (value == null) {
            return 0;
        }
        if (currentCal == null) {
            currentCal = ClientSharedData.getDefaultCleanCalendar();
        }
        currentCal.setTime(value);
        return SQLDate.computeEncodedDate(currentCal);
    }

    public static DateTimeDataValue computeDateFunction(DataValueDescriptor operand, DataValueFactory dvf) throws StandardException {
        try {
            if (operand.isNull()) {
                return new SQLDate();
            }
            if (operand instanceof SQLDate) {
                return (SQLDate)operand.getClone();
            }
            if (operand instanceof SQLTimestamp) {
                SQLDate retVal = new SQLDate();
                retVal.setValue(operand);
                return retVal;
            }
            if (operand instanceof NumberDataValue) {
                int daysSinceEpoch = operand.getInt();
                if (daysSinceEpoch <= 0 || daysSinceEpoch > 3652059) {
                    throw StandardException.newException("22008.S", (Object)operand.getString(), (Object)"date");
                }
                GregorianCalendar cal = ClientSharedData.getDefaultCleanCalendar();
                cal.set(1970, 0, 1, 12, 0, 0);
                cal.add(5, daysSinceEpoch - 1);
                return new SQLDate(SQLDate.computeEncodedDate(cal.get(1), cal.get(2) + 1, cal.get(5)));
            }
            String str = operand.getString();
            if (str.length() == 7) {
                int year = SQLTimestamp.parseDateTimeInteger(str, 0, 4);
                int dayOfYear = SQLTimestamp.parseDateTimeInteger(str, 4, 3);
                if (dayOfYear < 1 || dayOfYear > 366) {
                    throw StandardException.newException("22008.S", (Object)operand.getString(), (Object)"date");
                }
                GregorianCalendar cal = ClientSharedData.getDefaultCleanCalendar();
                cal.set(year, 0, 1, 2, 0, 0);
                cal.add(6, dayOfYear - 1);
                int y = cal.get(1);
                if (y != year) {
                    throw StandardException.newException("22008.S", (Object)operand.getString(), (Object)"date");
                }
                return new SQLDate(SQLDate.computeEncodedDate(year, cal.get(2) + 1, cal.get(5)));
            }
            return dvf.getDateValue(str, false);
        }
        catch (StandardException se) {
            if ("22007.S.181".startsWith(se.getSQLState())) {
                throw StandardException.newException("22008.S", (Object)operand.getString(), (Object)"date");
            }
            throw se;
        }
    }

    @Override
    public void setInto(PreparedStatement ps, int position) throws SQLException, StandardException {
        ps.setDate(position, this.getDate((Calendar)null));
    }

    @Override
    public DateTimeDataValue timestampAdd(int intervalType, NumberDataValue intervalCount, Date currentDate, DateTimeDataValue resultHolder) throws StandardException {
        return this.toTimestamp().timestampAdd(intervalType, intervalCount, currentDate, resultHolder);
    }

    private SQLTimestamp toTimestamp() throws StandardException {
        return new SQLTimestamp(this.getEncodedDate(), 0, 0);
    }

    @Override
    public NumberDataValue timestampDiff(int intervalType, DateTimeDataValue time1, Date currentDate, NumberDataValue resultHolder) throws StandardException {
        return this.toTimestamp().timestampDiff(intervalType, time1, currentDate, resultHolder);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        if (!this.isNull()) {
            out.writeByte(this.getTypeId());
            out.writeInt(this.encodedDate);
            return;
        }
        this.writeNullDVD(out);
    }

    @Override
    public final void fromDataForOptimizedResultHolder(DataInput dis) throws IOException, ClassNotFoundException {
        this.encodedDate = dis.readInt();
        this.valueString = null;
    }

    @Override
    public final void toDataForOptimizedResultHolder(DataOutput dos) throws IOException {
        assert (!this.isNull());
        dos.writeInt(this.encodedDate);
    }

    @Override
    public int writeBytes(byte[] outBytes, int offset, DataTypeDescriptor dtd) {
        assert (!this.isNull());
        return RowFormatter.writeInt(outBytes, this.encodedDate, offset);
    }

    @Override
    public int readBytes(byte[] inBytes, int offset, int columnWidth) {
        this.valueString = null;
        this.encodedDate = RowFormatter.readInt(inBytes, offset);
        return 4;
    }

    @Override
    public int readBytes(UnsafeWrapper unsafe, long memOffset, int columnWidth, ByteSource bs) {
        this.valueString = null;
        this.encodedDate = RowFormatter.readInt(unsafe, memOffset);
        return 4;
    }

    @Override
    public int computeHashCode(int maxWidth, int hash) {
        assert (!this.isNull());
        return ResolverUtils.addIntToBucketHash((int)this.encodedDate, (int)hash, (int)this.getTypeFormatId());
    }

    static final Date getAsDate(byte[] bytes, int offset, Calendar cal) {
        int encodedDate = RowFormatter.readInt(bytes, offset);
        if (encodedDate == 0) {
            return null;
        }
        cal.clear();
        SQLDate.setDateInCalendar(cal, encodedDate);
        return new Date(cal.getTimeInMillis());
    }

    static final Date getAsDate(UnsafeWrapper unsafe, long memOffset, Calendar cal) {
        int encodedDate = RowFormatter.readInt(unsafe, memOffset);
        if (encodedDate == 0) {
            return null;
        }
        cal.clear();
        SQLDate.setDateInCalendar(cal, encodedDate);
        return new Date(cal.getTimeInMillis());
    }

    static final Timestamp getAsTimeStamp(byte[] bytes, int offset, Calendar cal) {
        int encodedDate = RowFormatter.readInt(bytes, offset);
        if (encodedDate == 0) {
            return null;
        }
        cal.clear();
        SQLDate.setDateInCalendar(cal, encodedDate);
        return new Timestamp(cal.getTimeInMillis());
    }

    static final Timestamp getAsTimeStamp(UnsafeWrapper unsafe, long memOffset, Calendar cal) {
        int encodedDate = RowFormatter.readInt(unsafe, memOffset);
        if (encodedDate == 0) {
            return null;
        }
        cal.clear();
        SQLDate.setDateInCalendar(cal, encodedDate);
        return new Timestamp(cal.getTimeInMillis());
    }

    static String getAsString(byte[] inBytes, int offset) {
        int encodedDate = RowFormatter.readInt(inBytes, offset);
        if (encodedDate == 0) {
            return null;
        }
        char[] str = new char[10];
        SharedUtils.dateTimeToString((char[])str, (int)0, (int)SQLDate.getYear(encodedDate), (int)SQLDate.getMonth(encodedDate), (int)SQLDate.getDay(encodedDate), (int)-1, (int)-1, (int)-1, (int)-1, (int)-1, (boolean)false);
        return ClientSharedUtils.getJdkHelper().newWrappedString(str, 0, 10);
    }

    static String getAsString(UnsafeWrapper unsafe, long memOffset) {
        int encodedDate = RowFormatter.readInt(unsafe, memOffset);
        if (encodedDate == 0) {
            return null;
        }
        char[] str = new char[10];
        SharedUtils.dateTimeToString((char[])str, (int)0, (int)SQLDate.getYear(encodedDate), (int)SQLDate.getMonth(encodedDate), (int)SQLDate.getDay(encodedDate), (int)-1, (int)-1, (int)-1, (int)-1, (int)-1, (boolean)false);
        return ClientSharedUtils.getJdkHelper().newWrappedString(str, 0, 10);
    }

    static void writeAsString(byte[] inBytes, int offset, ByteArrayDataOutput buffer) {
        int encodedDate = RowFormatter.readInt(inBytes, offset);
        if (encodedDate == 0) {
            return;
        }
        int bufferPos = buffer.ensureCapacity(10, buffer.position());
        SharedUtils.dateTimeToChars((byte[])buffer.getData(), (int)bufferPos, (int)SQLDate.getYear(encodedDate), (int)SQLDate.getMonth(encodedDate), (int)SQLDate.getDay(encodedDate), (int)-1, (int)-1, (int)-1, (int)-1, (int)-1, (boolean)false);
        buffer.advance(10);
    }

    static void writeAsString(UnsafeWrapper unsafe, long memOffset, ByteArrayDataOutput buffer) {
        int encodedDate = RowFormatter.readInt(unsafe, memOffset);
        if (encodedDate == 0) {
            return;
        }
        int bufferPos = buffer.ensureCapacity(10, buffer.position());
        SharedUtils.dateTimeToChars((byte[])buffer.getData(), (int)bufferPos, (int)SQLDate.getYear(encodedDate), (int)SQLDate.getMonth(encodedDate), (int)SQLDate.getDay(encodedDate), (int)-1, (int)-1, (int)-1, (int)-1, (int)-1, (boolean)false);
        buffer.advance(10);
    }

    @Override
    public byte getTypeId() {
        return 61;
    }
}

