/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.types.CollatorSQLClob;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.ReaderToUTF8Stream;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.iapi.types.StringDataValue;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.RuleBasedCollator;
import java.util.Calendar;

public class SQLClob
extends SQLVarchar {
    @Override
    public String getTypeName() {
        return "CLOB";
    }

    @Override
    public DataValueDescriptor getClone() {
        try {
            return new SQLClob(this.getString());
        }
        catch (StandardException se) {
            throw GemFireXDRuntimeException.newRuntimeException("Unexpected exception", se);
        }
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLClob();
    }

    @Override
    public StringDataValue getValue(RuleBasedCollator collatorForComparison) {
        if (collatorForComparison == null) {
            return this;
        }
        CollatorSQLClob s = new CollatorSQLClob(collatorForComparison);
        s.copyState(this);
        return s;
    }

    @Override
    public int getTypeFormatId() {
        return 447;
    }

    public SQLClob() {
    }

    public SQLClob(String val) {
        super(val);
    }

    @Override
    public int typePrecedence() {
        return 14;
    }

    @Override
    public int getLengthInBytes(DataTypeDescriptor dtd) throws StandardException {
        char[] data = this.getCharArray(true);
        if (data != null) {
            int maxWidth;
            int strlen;
            int n = strlen = this.rawLength != -1 ? this.rawLength : data.length;
            if (dtd != null && strlen > (maxWidth = dtd.getMaximumWidth())) {
                strlen = maxWidth;
            }
            int utflen = strlen;
            for (int index = 0; index < strlen; ++index) {
                char c = data[index];
                if (c >= '\u0001' && c <= '\u007f') continue;
                if (c > '\u07ff') {
                    utflen += 2;
                    continue;
                }
                ++utflen;
            }
            return utflen;
        }
        return 0;
    }

    @Override
    public boolean getBoolean() throws StandardException {
        throw this.dataTypeConversion("boolean");
    }

    @Override
    public byte getByte() throws StandardException {
        throw this.dataTypeConversion("byte");
    }

    @Override
    public short getShort() throws StandardException {
        throw this.dataTypeConversion("short");
    }

    @Override
    public int getInt() throws StandardException {
        throw this.dataTypeConversion("int");
    }

    @Override
    public long getLong() throws StandardException {
        throw this.dataTypeConversion("long");
    }

    @Override
    public float getFloat() throws StandardException {
        throw this.dataTypeConversion("float");
    }

    @Override
    public double getDouble() throws StandardException {
        throw this.dataTypeConversion("double");
    }

    @Override
    public int typeToBigDecimal() throws StandardException {
        throw this.dataTypeConversion("java.math.BigDecimal");
    }

    @Override
    public byte[] getBytes() throws StandardException {
        throw this.dataTypeConversion("byte[]");
    }

    @Override
    public Date getDate(Calendar cal) throws StandardException {
        throw this.dataTypeConversion("java.sql.Date");
    }

    @Override
    public Time getTime(Calendar cal) throws StandardException {
        throw this.dataTypeConversion("java.sql.Time");
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws StandardException {
        throw this.dataTypeConversion("java.sql.Timestamp");
    }

    @Override
    public final String getTraceString() throws StandardException {
        if (this.isNull()) {
            return "NULL";
        }
        if (this.getStream() != null) {
            return this.getTypeName() + "(" + this.getStream().toString() + ")";
        }
        return this.getTypeName() + "(" + this.getLength() + ")";
    }

    @Override
    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor sourceValue) throws StandardException {
        super.normalize(desiredType, sourceValue);
    }

    @Override
    public void setValue(Time theValue, Calendar cal) throws StandardException {
        this.throwLangSetMismatch("java.sql.Time");
    }

    @Override
    public void setValue(Timestamp theValue, Calendar cal) throws StandardException {
        this.throwLangSetMismatch("java.sql.Timestamp");
    }

    @Override
    public void setValue(Date theValue, Calendar cal) throws StandardException {
        this.throwLangSetMismatch("java.sql.Date");
    }

    @Override
    public void setBigDecimal(Number bigDecimal) throws StandardException {
        this.throwLangSetMismatch("java.math.BigDecimal");
    }

    @Override
    public void setValue(int theValue) throws StandardException {
        this.throwLangSetMismatch("int");
    }

    @Override
    public void setValue(double theValue) throws StandardException {
        this.throwLangSetMismatch("double");
    }

    @Override
    public void setValue(float theValue) throws StandardException {
        this.throwLangSetMismatch("float");
    }

    @Override
    public void setValue(short theValue) throws StandardException {
        this.throwLangSetMismatch("short");
    }

    @Override
    public void setValue(long theValue) throws StandardException {
        this.throwLangSetMismatch("long");
    }

    @Override
    public void setValue(byte theValue) throws StandardException {
        this.throwLangSetMismatch("byte");
    }

    @Override
    public void setValue(boolean theValue) throws StandardException {
        this.throwLangSetMismatch("boolean");
    }

    @Override
    public void setValue(byte[] theValue) throws StandardException {
        this.throwLangSetMismatch("byte[]");
    }

    @Override
    void setObject(Object theValue) throws StandardException {
        Clob vc = (Clob)theValue;
        try {
            long vcl = vc.length();
            if (vcl < 0L || vcl > Integer.MAX_VALUE) {
                throw this.outOfRange();
            }
            this.setValue(new ReaderToUTF8Stream(vc.getCharacterStream(), (int)vcl, 0, "CLOB"), (int)vcl);
        }
        catch (SQLException e) {
            throw this.dataTypeConversion("DAN-438-tmp");
        }
    }

    @Override
    public byte getTypeId() {
        return 88;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SQLClob@0x").append(Integer.toHexString(System.identityHashCode(this)));
        try {
            sb.append(";length=").append(this.getLength());
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        try {
            char[] chars = this.getCharArray(true);
            if (chars != null) {
                sb.append(";hash=").append(ResolverUtils.addCharsToHash((char[])chars, (int)0, (int)chars.length, (int)0));
            } else {
                sb.append(";chars is null");
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return sb.toString();
    }
}

