/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.gemstone.gemfire.internal.offheap.ByteSource;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.HarmonySerialBlob;
import com.pivotal.gemfirexd.internal.iapi.types.RawToBinaryFormatStream;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBinary;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SQLBlob
extends SQLBinary {
    private boolean wrapBytes;

    public SQLBlob() {
    }

    public final void setWrapBytesForSQLBlob(boolean wrapBytes) {
        this.wrapBytes = wrapBytes;
    }

    public SQLBlob(byte[] val) {
        super(val);
    }

    public SQLBlob(Blob val) {
        super(val);
    }

    @Override
    public String getTypeName() {
        return "BLOB";
    }

    @Override
    int getMaxMemoryUsage() {
        return Integer.MAX_VALUE;
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLBlob();
    }

    @Override
    public Object getObject() throws StandardException {
        if (this._blobValue != null) {
            return this._blobValue;
        }
        byte[] bytes = this.getBytes();
        if (bytes == null) {
            return null;
        }
        return this.wrapBytes ? HarmonySerialBlob.wrapBytes(bytes) : new HarmonySerialBlob(bytes);
    }

    @Override
    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        this.setValue(source);
        this.setWidth(desiredType.getMaximumWidth(), 0, true);
    }

    @Override
    public void setWidth(int desiredWidth, int desiredScale, boolean errorOnTrunc) throws StandardException {
        if (this.isNull()) {
            return;
        }
        if (this.isLengthLess()) {
            return;
        }
        int sourceWidth = this.getLength();
        if (sourceWidth > desiredWidth) {
            if (errorOnTrunc) {
                throw StandardException.newException("22001", (Object)this.getTypeName(), (Object)MessageService.getTextMessage("BIN01", String.valueOf(sourceWidth)), (Object)String.valueOf(desiredWidth));
            }
            byte[] shrunkData = new byte[desiredWidth];
            System.arraycopy(this.getBytes(), 0, shrunkData, 0, desiredWidth);
            this.dataValue = shrunkData;
        }
    }

    @Override
    public int getTypeFormatId() {
        return 443;
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException, StandardException {
        Blob blob = resultSet.getBlob(colNumber);
        if (blob == null) {
            this.setToNull();
        } else {
            this.setObject(blob);
        }
    }

    @Override
    public int typePrecedence() {
        return 170;
    }

    @Override
    public void setInto(PreparedStatement ps, int position) throws SQLException, StandardException {
        if (this.isNull()) {
            ps.setBlob(position, (Blob)null);
            return;
        }
        ps.setBytes(position, this.getBytes());
    }

    @Override
    final void setObject(Object theValue) throws StandardException {
        if (theValue instanceof byte[]) {
            this.setValue((byte[])theValue);
            return;
        }
        Blob vb = (Blob)theValue;
        try {
            long vbl = vb.length();
            if (vbl < 0L || vbl > Integer.MAX_VALUE) {
                throw this.outOfRange();
            }
            this.setValue(new RawToBinaryFormatStream(vb.getBinaryStream(), (int)vbl), (int)vbl);
        }
        catch (SQLException e) {
            throw this.dataTypeConversion("DAN-438-tmp");
        }
    }

    private final boolean isLengthLess() {
        return false;
    }

    @Override
    public int readBytes(byte[] inBytes, int offset, int columnWidth) {
        assert (columnWidth == inBytes.length) : "columnWidth=" + columnWidth + ", bytesLength=" + inBytes.length;
        assert (offset == 0);
        this.dataValue = inBytes;
        return columnWidth;
    }

    @Override
    public int readBytes(UnsafeWrapper unsafe, long memOffset, int columnWidth, ByteSource bs) {
        OffHeapByteSource obs = (OffHeapByteSource)bs;
        assert (columnWidth == obs.getLength()) : "columnWidth=" + columnWidth + ", bytesLength=" + obs.getLength();
        assert (memOffset == obs.getUnsafeAddress(0, columnWidth));
        this.dataValue = obs.getRowBytes();
        return columnWidth;
    }

    @Override
    public int writeBytes(byte[] outBytes, int offset, DataTypeDescriptor dtd) {
        throw new AssertionError((Object)"unexpected call, expected getBytes() to be called instead");
    }

    @Override
    public int computeHashCode(int maxWidth, int hash) {
        assert (!this.isNull());
        return ResolverUtils.addBytesToBucketHash((byte[])this.dataValue, (int)hash, (int)this.getTypeFormatId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SQLBlob@0x").append(Integer.toHexString(System.identityHashCode(this)));
        try {
            sb.append(";length=").append(this.getLength());
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        try {
            byte[] bytes = this.getBytes();
            if (bytes != null) {
                sb.append(";hash=").append(ResolverUtils.addBytesToHash((byte[])bytes, (int)0, (int)bytes.length, (int)0));
            } else {
                sb.append(";bytes is null");
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return sb.toString();
    }
}

