/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import java.text.RuleBasedCollator;

public class Like {
    private static final char anyChar = '_';
    private static final char anyString = '%';
    private static final String SUPER_STRING = "\uffff";

    private Like() {
    }

    public static Boolean like(char[] val, int valLength, char[] pat, int patLength, char[] escape, int escapeLength, RuleBasedCollator collator) throws StandardException {
        return Like.like(val, 0, valLength, pat, 0, patLength, escape, escapeLength, collator);
    }

    private static Boolean like(char[] val, int vLoc, int vEnd, char[] pat, int pLoc, int pEnd, char[] escape, int escapeLength, RuleBasedCollator collator) throws StandardException {
        char escChar = ' ';
        boolean haveEsc = true;
        if (val == null) {
            return null;
        }
        if (pat == null) {
            return null;
        }
        if (escape == null) {
            haveEsc = false;
        } else {
            escChar = escape[0];
        }
        while (true) {
            Boolean result;
            if ((result = Like.checkLengths(vLoc, vEnd, pLoc, pat, pEnd)) != null) {
                return result;
            }
            while (!(pat[pLoc] == '_' || pat[pLoc] == '%' || haveEsc && pat[pLoc] == escChar)) {
                if (Like.checkEquality(val, vLoc, pat, pLoc, collator)) {
                    if ((result = Like.checkLengths(++vLoc, vEnd, ++pLoc, pat, pEnd)) == null) continue;
                    return result;
                }
                return Boolean.FALSE;
            }
            if (haveEsc && pat[pLoc] == escChar) {
                if (++pLoc == pEnd) {
                    throw StandardException.newException("22025");
                }
                if (pat[pLoc] != escChar && pat[pLoc] != '_' && pat[pLoc] != '%') {
                    throw StandardException.newException("22025");
                }
                if (Like.checkEquality(val, vLoc, pat, pLoc, collator)) {
                    if ((result = Like.checkLengths(++vLoc, vEnd, ++pLoc, pat, pEnd)) == null) continue;
                    return result;
                }
                return Boolean.FALSE;
            }
            if (pat[pLoc] == '_') {
                if ((result = Like.checkLengths(++vLoc, vEnd, ++pLoc, pat, pEnd)) == null) continue;
                return result;
            }
            if (pat[pLoc] == '%') break;
        }
        if (pLoc + 1 == pEnd) {
            return Boolean.TRUE;
        }
        SanityManager.ASSERT((vLoc != vEnd ? 1 : 0) != 0, (String)"Should have been found already");
        boolean anys = true;
        for (int i = pLoc + 1; i < pEnd; ++i) {
            if (pat[i] == '%') continue;
            anys = false;
            break;
        }
        if (anys) {
            return Boolean.TRUE;
        }
        int vRem = vEnd - vLoc;
        int n = 0;
        int minLen = Like.getMinLen(pat, pLoc + 1, pEnd, haveEsc, escChar);
        for (int i = vRem; i >= minLen; --i) {
            Boolean restResult = Like.like(val, vLoc + n, vLoc + n + i, pat, pLoc + 1, pEnd, escape, escapeLength, collator);
            if (restResult == null) {
                String vStr = new String(val, vLoc + n, i);
                String pStr = new String(pat, pLoc + 1, pEnd - (pLoc + 1));
                SanityManager.THROWASSERT((String)("null result on like(value = " + vStr + ", pat = " + pStr + ")"));
            }
            if (restResult.booleanValue()) {
                return restResult;
            }
            ++n;
        }
        return Boolean.FALSE;
    }

    private static boolean checkEquality(char[] val, int vLoc, char[] pat, int pLoc, RuleBasedCollator collator) {
        if (val[vLoc] == pat[pLoc]) {
            return true;
        }
        if (collator == null) {
            return false;
        }
        String s1 = new String(val, vLoc, 1);
        String s2 = new String(pat, pLoc, 1);
        return collator.compare(s1, s2) == 0;
    }

    static int getMinLen(char[] pattern, int pStart, int pEnd, boolean haveEsc, char escChar) {
        int m = 0;
        int l = pStart;
        while (l < pEnd) {
            if (haveEsc && pattern[l] == escChar) {
                l += 2;
                ++m;
                continue;
            }
            if (pattern[l] == '%') {
                ++l;
                continue;
            }
            ++l;
            ++m;
        }
        return m;
    }

    static Boolean checkLengths(int vLoc, int vEnd, int pLoc, char[] pat, int pEnd) {
        if (vLoc == vEnd) {
            if (pLoc == pEnd) {
                return Boolean.TRUE;
            }
            for (int i = pLoc; i < pEnd; ++i) {
                if (pat[i] == '%') continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (pLoc == pEnd) {
            return Boolean.FALSE;
        }
        return null;
    }

    private static boolean matchSpecial(int[] pat, int patStart, int patEnd, int[] specialInts) {
        if (specialInts.length > patEnd - patStart) {
            return false;
        }
        if (specialInts.length <= patEnd - patStart) {
            for (int index = 0; index < specialInts.length; ++index) {
                if (pat[patStart + index] == specialInts[index]) continue;
                return false;
            }
        }
        return true;
    }

    public static Boolean like(char[] value, int valueLength, char[] pattern, int patternLength, RuleBasedCollator collator) throws StandardException {
        if (value == null || pattern == null) {
            return null;
        }
        return Like.like(value, valueLength, pattern, patternLength, null, 0, collator);
    }

    public static boolean isOptimizable(String pattern) {
        if (pattern == null) {
            return false;
        }
        if (pattern.length() == 0) {
            return true;
        }
        char firstChar = pattern.charAt(0);
        return firstChar != '_' && firstChar != '%';
    }

    public static String greaterEqualStringFromParameter(String pattern, int maxWidth) throws StandardException {
        if (pattern == null) {
            return null;
        }
        return Like.greaterEqualString(pattern, null, maxWidth);
    }

    public static String greaterEqualStringFromParameterWithEsc(String pattern, String escape, int maxWidth) throws StandardException {
        if (pattern == null) {
            return null;
        }
        return Like.greaterEqualString(pattern, escape, maxWidth);
    }

    public static String greaterEqualString(String pattern, String escape, int maxWidth) throws StandardException {
        char escChar;
        int firstAnyChar = pattern.indexOf(95);
        int firstAnyString = pattern.indexOf(37);
        if (escape != null && escape.length() != 0 && pattern.indexOf(escChar = escape.charAt(0)) != -1) {
            return Like.padWithNulls(Like.greaterEqualString(pattern, escChar), maxWidth);
        }
        if (firstAnyChar == -1) {
            if (firstAnyString != -1) {
                pattern = pattern.substring(0, firstAnyString);
            }
        } else {
            pattern = firstAnyString == -1 ? pattern.substring(0, firstAnyChar) : pattern.substring(0, firstAnyChar > firstAnyString ? firstAnyString : firstAnyChar);
        }
        return Like.padWithNulls(pattern, maxWidth);
    }

    private static String greaterEqualString(String pattern, char escChar) throws StandardException {
        int patternLen = pattern.length();
        char[] patternChars = new char[patternLen];
        char[] result = new char[patternLen];
        pattern.getChars(0, patternLen, patternChars, 0);
        int r = 0;
        for (int p = 0; p < patternLen && r < patternLen; ++p) {
            char c = patternChars[p];
            if (c == escChar) {
                if (++p >= patternLen) {
                    throw StandardException.newException("22025");
                }
                result[r++] = patternChars[p];
                continue;
            }
            if (c == '_' || c == '%') {
                return new String(result, 0, r);
            }
            result[r++] = patternChars[p];
        }
        return new String(result, 0, r);
    }

    public static String stripEscapesNoPatternChars(String pattern, char escChar) throws StandardException {
        int patternLen = pattern.length();
        char[] patternChars = new char[patternLen];
        char[] result = new char[patternLen];
        pattern.getChars(0, patternLen, patternChars, 0);
        int r = 0;
        for (int p = 0; p < patternLen && r < patternLen; ++p) {
            char c = pattern.charAt(p);
            if (c == escChar) {
                if (++p >= patternLen) {
                    throw StandardException.newException("22025");
                }
                result[r++] = patternChars[p];
                continue;
            }
            if (c == '_' || c == '%') {
                return null;
            }
            result[r++] = patternChars[p];
        }
        return new String(result, 0, r);
    }

    public static String lessThanStringFromParameter(String pattern, int maxWidth) throws StandardException {
        if (pattern == null) {
            return null;
        }
        return Like.lessThanString(pattern, null, maxWidth);
    }

    public static String lessThanStringFromParameterWithEsc(String pattern, String escape, int maxWidth) throws StandardException {
        if (pattern == null) {
            return null;
        }
        return Like.lessThanString(pattern, escape, maxWidth);
    }

    public static String lessThanString(String pattern, String escape, int maxWidth) throws StandardException {
        char oldLastChar;
        char escChar = escape != null && escape.length() != 0 ? (char)escape.charAt(0) : (char)'\uffffffff';
        StringBuilder upperLimit = new StringBuilder(maxWidth);
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == escChar) {
                if (++i >= pattern.length()) {
                    throw StandardException.newException("22025");
                }
                c = pattern.charAt(i);
            } else if (c == '_' || c == '%') break;
            upperLimit.append(c);
        }
        if (upperLimit.length() == 0) {
            return SUPER_STRING;
        }
        int lastUsableChar = upperLimit.length() - 1;
        char newLastChar = oldLastChar = upperLimit.charAt(lastUsableChar);
        if ((newLastChar = (char)(newLastChar + '\u0001')) < oldLastChar) {
            return SUPER_STRING;
        }
        upperLimit.setCharAt(lastUsableChar, newLastChar);
        if (upperLimit.length() < maxWidth) {
            upperLimit.setLength(maxWidth);
        }
        return upperLimit.toString();
    }

    public static boolean isLikeComparisonNeeded(String pattern) {
        int firstAnyChar = pattern.indexOf(95);
        int firstAnyString = pattern.indexOf(37);
        SanityManager.ASSERT((pattern.length() != 0 ? 1 : 0) != 0, (String)"pattern expected to be non-zero length");
        if (firstAnyChar == -1 && firstAnyString == -1) {
            return false;
        }
        if (firstAnyChar != -1) {
            return true;
        }
        return firstAnyString != pattern.length() - 1;
    }

    private static String padWithNulls(String string, int len) {
        if (string.length() >= len) {
            return string;
        }
        StringBuilder buf = new StringBuilder(len).append(string);
        buf.setLength(len);
        return buf.toString();
    }
}

