/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;

public class HarmonySerialBlob
implements Blob,
Serializable,
Cloneable {
    private static final long serialVersionUID = -8144641928112860441L;
    private byte[] buf;
    private long len;

    public HarmonySerialBlob(byte[] buf) {
        this.buf = new byte[buf.length];
        this.len = buf.length;
        System.arraycopy(buf, 0, this.buf, 0, (int)this.len);
    }

    public HarmonySerialBlob(OffHeapByteSource ohbs) {
        this.buf = ohbs.getRowBytes();
        this.len = this.buf.length;
    }

    private HarmonySerialBlob(byte[] buf, int len) {
        this.buf = buf;
        this.len = len;
    }

    public static HarmonySerialBlob wrapBytes(byte[] buf) {
        return new HarmonySerialBlob(buf, buf.length);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkValidation();
        return new ByteArrayInputStream(this.buf);
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        this.checkValidation();
        if (pos < 1L || pos > this.len + 1L) {
            throw HarmonySerialBlob.makeSQLException("XJ070.S", new Object[]{new Long(pos)});
        }
        if (length < 0) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", new Object[]{new Integer(length)});
        }
        if ((long)length > this.len - pos + 1L) {
            length = (int)(this.len - pos + 1L);
        }
        byte[] copiedArray = new byte[length];
        System.arraycopy(this.buf, (int)pos - 1, copiedArray, 0, length);
        return copiedArray;
    }

    @Override
    public long length() throws SQLException {
        this.checkValidation();
        return this.len;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        this.checkValidation();
        byte[] patternBytes = pattern.getBytes(1L, (int)pattern.length());
        return this.position(patternBytes, start);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        this.checkValidation();
        if (start < 1L || this.len - (start - 1L) < (long)pattern.length) {
            return -1L;
        }
        int i = (int)(start - 1L);
        while ((long)i <= this.len - (long)pattern.length) {
            if (this.match(this.buf, i, pattern)) {
                return i + 1;
            }
            ++i;
        }
        return -1L;
    }

    private boolean match(byte[] bytes, int start, byte[] subBytes) {
        int i = 0;
        while (i < subBytes.length) {
            if (bytes[start++] == subBytes[i++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.checkValidation();
        throw Util.generateCsSQLException("0A000.S", "SerialBlob: setBinaryStream");
    }

    @Override
    public int setBytes(long pos, byte[] theBytes) throws SQLException {
        return this.setBytes(pos, theBytes, 0, theBytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] theBytes, int offset, int length) throws SQLException {
        this.checkValidation();
        if (pos < 1L || length < 0) {
            throw HarmonySerialBlob.makeSQLException("XJ070.S", new Object[]{new Long(pos)});
        }
        if (pos > this.len + 1L) {
            throw HarmonySerialBlob.makeSQLException("XJ076.S", new Object[]{new Long(pos)});
        }
        if (offset < 0 || length < 0 || offset > theBytes.length - length) {
            throw HarmonySerialBlob.makeSQLException("XJ078.S", new Object[]{new Integer(offset)});
        }
        if (pos > this.len - (long)length + 1L) {
            long newLen = (long)length + pos - 1L;
            byte[] newBuf = new byte[(int)newLen];
            System.arraycopy(this.buf, 0, newBuf, 0, (int)this.len);
            this.buf = newBuf;
            this.len = newLen;
        }
        System.arraycopy(theBytes, offset, this.buf, (int)pos - 1, length);
        return length;
    }

    @Override
    public void truncate(long length) throws SQLException {
        this.checkValidation();
        if (length > this.len) {
            throw HarmonySerialBlob.makeSQLException("XJ079.S", new Object[]{new Long(this.len)});
        }
        if (length < this.len) {
            this.buf = this.getBytes(1L, (int)length);
            this.len = length;
        }
    }

    @Override
    public void free() throws SQLException {
        if (this.len != -1L) {
            this.len = -1L;
            this.buf = null;
        }
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.checkValidation();
        if (this.len < 0L) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", new Object[]{new Long(this.len)});
        }
        if (length < 0L) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", new Object[]{new Long(length)});
        }
        if (pos < 1L || pos + length > this.len) {
            throw HarmonySerialBlob.makeSQLException("XJ087.S", new Object[]{new Long(pos), new Long(length)});
        }
        return new ByteArrayInputStream(this.buf, (int)(pos - 1L), (int)length);
    }

    public static SQLException makeSQLException(String messageID, Object[] args) {
        StandardException se = StandardException.newException(messageID, args);
        return new SQLException(se.getMessage(), se.getSQLState());
    }

    private void checkValidation() throws SQLException {
        if (this.len == -1L) {
            throw HarmonySerialBlob.makeSQLException("XJ215.S", null);
        }
    }
}

