/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.BinaryDecimal;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataType;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue;
import java.math.BigInteger;

public final class BigIntegerDecimal
extends BinaryDecimal {
    private static final BigInteger TEN = BigInteger.valueOf(10L);
    private static final BigInteger MAXLONG_PLUS_ONE = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE);
    private static final BigInteger MINLONG_MINUS_ONE = BigInteger.valueOf(Long.MIN_VALUE).subtract(BigInteger.ONE);

    @Override
    public DataValueDescriptor getNewNull() {
        return new BigIntegerDecimal();
    }

    @Override
    public long getLong() throws StandardException {
        if (this.isNull()) {
            return 0L;
        }
        BigInteger bi = new BigInteger(this.data2c);
        boolean rangeOk = false;
        if (bi.compareTo(MAXLONG_PLUS_ONE) < 0 && bi.compareTo(MINLONG_MINUS_ONE) > 0) {
            rangeOk = true;
        }
        for (int i = 0; i < this.sqlScale; ++i) {
            bi = bi.divide(TEN);
            if (rangeOk || bi.compareTo(MAXLONG_PLUS_ONE) >= 0 || bi.compareTo(MINLONG_MINUS_ONE) <= 0) continue;
            rangeOk = true;
        }
        if (!rangeOk) {
            throw StandardException.newException("22003", (Object)"BIGINT", (Object)null);
        }
        return bi.longValue();
    }

    @Override
    public float getFloat() throws StandardException {
        if (this.isNull()) {
            return 0.0f;
        }
        return NumberDataType.normalizeREAL(Float.parseFloat(this.getString()));
    }

    @Override
    public double getDouble() throws StandardException {
        if (this.isNull()) {
            return 0.0;
        }
        return NumberDataType.normalizeDOUBLE(Double.parseDouble(this.getString()));
    }

    @Override
    public boolean getBoolean() {
        if (this.isNull()) {
            return false;
        }
        BigInteger bi = new BigInteger(this.data2c);
        return bi.compareTo(BigInteger.ZERO) != 0;
    }

    @Override
    public void setValue(String theValue) throws StandardException {
        if (theValue == null) {
            this.restoreToNull();
            return;
        }
        theValue = theValue.trim();
        int dot = theValue.indexOf(46);
        int ePosition = theValue.indexOf(101);
        if (ePosition == -1) {
            ePosition = theValue.indexOf(69);
        }
        int scale = 0;
        try {
            if (ePosition != -1) {
                if (dot > ePosition) {
                    throw this.invalidFormat();
                }
                int expOffset = ePosition + 1;
                if (expOffset >= theValue.length()) {
                    throw this.invalidFormat();
                }
                if (theValue.charAt(expOffset) == '+') {
                    if (++expOffset >= theValue.length()) {
                        throw this.invalidFormat();
                    }
                    if (theValue.charAt(expOffset) == '-') {
                        throw this.invalidFormat();
                    }
                }
                String exponent = theValue.substring(expOffset);
                scale = -1 * Integer.parseInt(exponent);
                theValue = theValue.substring(0, ePosition);
            }
            if (dot != -1) {
                String leading = theValue.substring(0, dot);
                scale += theValue.length() - (dot + 1);
                theValue = leading.concat(theValue.substring(dot + 1, theValue.length()));
            }
            if (scale < 0) {
                for (int i = scale; i < 0; ++i) {
                    theValue = theValue.concat("0");
                }
                scale = 0;
            }
            BigInteger bi = new BigInteger(theValue);
            this.data2c = bi.toByteArray();
            this.sqlScale = scale;
        }
        catch (NumberFormatException nfe) {
            throw this.invalidFormat();
        }
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        String unscaled = new BigInteger(this.data2c).toString();
        if (this.sqlScale == 0) {
            return unscaled;
        }
        boolean isNegative = this.isNegative();
        if (this.sqlScale >= unscaled.length() - (isNegative ? 1 : 0)) {
            if (isNegative) {
                unscaled = unscaled.substring(1);
            }
            String val = isNegative ? "-0." : "0.";
            for (int i = this.sqlScale - unscaled.length(); i > 0; --i) {
                val = val.concat("0");
            }
            return val.concat(unscaled);
        }
        String val = unscaled.substring(0, unscaled.length() - this.sqlScale);
        val = val.concat(".");
        return val.concat(unscaled.substring(unscaled.length() - this.sqlScale, unscaled.length()));
    }

    @Override
    public int getDecimalValuePrecision() {
        if (this.isNull()) {
            return 0;
        }
        BigInteger bi = new BigInteger(this.data2c);
        if (BigInteger.ZERO.equals(bi)) {
            return 0;
        }
        int precision = bi.toString().length();
        if (this.isNegative()) {
            --precision;
        }
        if (precision < this.sqlScale) {
            return this.sqlScale;
        }
        return precision;
    }

    @Override
    protected int typeCompare(DataValueDescriptor arg) throws StandardException {
        BigIntegerDecimal obid = this.getBID(arg);
        int tscale = this.getDecimalValueScale();
        int oscale = obid.getDecimalValueScale();
        BigInteger tbi = new BigInteger(this.data2c);
        BigInteger obi = new BigInteger(obid.data2c);
        if (tscale < oscale) {
            tbi = BigIntegerDecimal.rescale(tbi, oscale - tscale);
        } else if (oscale < tscale) {
            obi = BigIntegerDecimal.rescale(obi, tscale - oscale);
        }
        return tbi.compareTo(obi);
    }

    @Override
    public NumberDataValue plusNN(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        BinaryDecimal resultBid = (BinaryDecimal)result;
        if (resultBid == null) {
            resultBid = new BigIntegerDecimal();
        }
        BigIntegerDecimal lbid = this.getBID(left);
        BigIntegerDecimal rbid = this.getBID(right);
        int lscale = lbid.getDecimalValueScale();
        int rscale = rbid.getDecimalValueScale();
        BigInteger bi1 = new BigInteger(lbid.data2c);
        BigInteger bi2 = new BigInteger(rbid.data2c);
        int tscale = lscale;
        if (lscale < rscale) {
            bi1 = BigIntegerDecimal.rescale(bi1, rscale - lscale);
            tscale = rscale;
        } else if (rscale < lscale) {
            bi2 = BigIntegerDecimal.rescale(bi2, lscale - rscale);
        }
        bi1 = bi1.add(bi2);
        resultBid.data2c = bi1.toByteArray();
        resultBid.sqlScale = tscale;
        return resultBid;
    }

    @Override
    public NumberDataValue minus(NumberDataValue result) throws StandardException {
        if (result == null) {
            result = (NumberDataValue)this.getNewNull();
        }
        if (this.isNull()) {
            result.setToNull();
        } else {
            BinaryDecimal rbd = (BinaryDecimal)result;
            BigInteger bi = new BigInteger(this.data2c);
            rbd.data2c = bi.negate().toByteArray();
            rbd.sqlScale = this.sqlScale;
        }
        return result;
    }

    @Override
    public NumberDataValue timesNN(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        BigIntegerDecimal resultBid = (BigIntegerDecimal)result;
        if (resultBid == null) {
            resultBid = new BigIntegerDecimal();
        }
        BigIntegerDecimal lbid = this.getBID(left);
        BigIntegerDecimal rbid = this.getBID(right);
        BigInteger lbi = new BigInteger(lbid.data2c);
        BigInteger rbi = new BigInteger(rbid.data2c);
        rbi = lbi.multiply(rbi);
        resultBid.data2c = rbi.toByteArray();
        resultBid.sqlScale = lbid.getDecimalValueScale() + rbid.getDecimalValueScale();
        return resultBid;
    }

    @Override
    public NumberDataValue divideNN(NumberDataValue left, NumberDataValue right, NumberDataValue result, int scale) throws StandardException {
        BinaryDecimal resultBid = (BinaryDecimal)result;
        if (resultBid == null) {
            resultBid = new BigIntegerDecimal();
        }
        BigIntegerDecimal lbid = this.getBID(left);
        BigIntegerDecimal rbid = this.getBID(right);
        BigInteger lbi = new BigInteger(lbid.data2c);
        BigInteger rbi = new BigInteger(rbid.data2c);
        if (BigInteger.ZERO.equals(rbi)) {
            throw StandardException.newException("22012");
        }
        int lscale = lbid.getDecimalValueScale();
        int rscale = rbid.getDecimalValueScale();
        if (scale >= 0 && lscale < scale + rscale) {
            lbi = BigIntegerDecimal.rescale(lbi, scale + rscale - lscale);
            lscale = scale + rscale;
        }
        rbi = lbi.divide(rbi);
        resultBid.sqlScale = lscale - rscale;
        if (resultBid.sqlScale < 0) {
            rbi = BigIntegerDecimal.rescale(rbi, -resultBid.sqlScale);
            resultBid.sqlScale = 0;
        }
        resultBid.data2c = rbi.toByteArray();
        return resultBid;
    }

    @Override
    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        int desiredScale = desiredType.getScale();
        int desiredPrecision = desiredType.getPrecision();
        this.setFrom(source);
        this.setWidth(desiredPrecision, desiredScale, true);
    }

    @Override
    public void setWidth(int desiredPrecision, int desiredScale, boolean errorOnTrunc) throws StandardException {
        int currentPrecision;
        int futurePrecision;
        if (this.isNull()) {
            return;
        }
        int deltaScale = desiredScale - this.sqlScale;
        if (desiredPrecision != -1 && (futurePrecision = (currentPrecision = this.getDecimalValuePrecision()) + deltaScale) > desiredPrecision) {
            throw StandardException.newException("22003", (Object)("DECIMAL/NUMERIC(" + desiredPrecision + "," + desiredScale + ")"), (Object)null);
        }
        if (deltaScale == 0) {
            return;
        }
        BigInteger bi = new BigInteger(this.data2c);
        bi = BigIntegerDecimal.rescale(bi, deltaScale);
        this.data2c = bi.toByteArray();
        this.sqlScale = desiredScale;
    }

    private BigIntegerDecimal getBID(DataValueDescriptor value) throws StandardException {
        switch (value.typeToBigDecimal()) {
            case 3: {
                return (BigIntegerDecimal)value;
            }
            case 1: {
                BigIntegerDecimal bid = new BigIntegerDecimal();
                bid.setValue(value.getString());
                return bid;
            }
            case -5: {
                BigIntegerDecimal bid = new BigIntegerDecimal();
                bid.setValue(value.getLong());
                return bid;
            }
        }
        SanityManager.THROWASSERT((String)("invalid return from " + value.getClass() + ".typeToBigDecimal() " + value.typeToBigDecimal()));
        return null;
    }

    private static BigInteger rescale(BigInteger bi, int deltaScale) {
        block4: {
            block3: {
                if (deltaScale == 0) {
                    return bi;
                }
                if (deltaScale <= 0) break block3;
                for (int i = 0; i < deltaScale; ++i) {
                    bi = bi.multiply(TEN);
                }
                break block4;
            }
            if (deltaScale >= 0) break block4;
            for (int i = deltaScale; i < 0; ++i) {
                bi = bi.divide(TEN);
            }
        }
        return bi;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.getString();
    }
}

