/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.jmx.Agent;
import com.gemstone.gemfire.admin.jmx.AgentConfig;
import com.gemstone.gemfire.admin.jmx.AgentFactory;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheExistsException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisee;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.GemFireLevel;
import com.gemstone.gemfire.internal.HostStatSampler;
import com.gemstone.gemfire.internal.LogWriterImpl;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CacheServerLauncher;
import com.gemstone.gemfire.internal.cache.ColocationHelper;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionRegionConfig;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.PartitionedRegionException;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.CommonRunTimeException;
import com.gemstone.gemfire.internal.shared.FinalizeObject;
import com.gemstone.gemfire.internal.shared.Jdk6Helper;
import com.gemstone.gemfire.internal.shared.StringPrintWriter;
import com.gemstone.gnu.trove.THashMap;
import com.gemstone.gnu.trove.TLongHashSet;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.internal.GemFireXDVersion;
import com.pivotal.gemfirexd.internal.catalog.ExternalCatalog;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryTimeStatistics;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.SigThreadDumpHandler;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.engine.access.PropertyConglomerate;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemOperation;
import com.pivotal.gemfirexd.internal.engine.db.FabricDatabase;
import com.pivotal.gemfirexd.internal.engine.db.IndexPersistenceStats;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdCacheLoader;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLMessage;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLRegionQueue;
import com.pivotal.gemfirexd.internal.engine.ddl.callbacks.CallbackProcedures;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.DistributedConnectionCloseExecutorFunction;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdDistributionAdvisor;
import com.pivotal.gemfirexd.internal.engine.distributed.QueryCancelFunction;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.fabricservice.FabricServiceImpl;
import com.pivotal.gemfirexd.internal.engine.fabricservice.FabricServiceUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.locks.DefaultGfxdLockable;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdDRWLockService;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockSet;
import com.pivotal.gemfirexd.internal.engine.locks.impl.GfxdReentrantReadWriteLock;
import com.pivotal.gemfirexd.internal.engine.management.GfxdManagementService;
import com.pivotal.gemfirexd.internal.engine.procedure.DistributedProcedureCallFunction;
import com.pivotal.gemfirexd.internal.engine.sql.conn.ConnectionSignaller;
import com.pivotal.gemfirexd.internal.engine.sql.conn.GfxdHeapThresholdListener;
import com.pivotal.gemfirexd.internal.engine.sql.execute.DistributionObserver;
import com.pivotal.gemfirexd.internal.engine.sql.execute.IdentityValueManager;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GfxdObjectSizer;
import com.pivotal.gemfirexd.internal.engine.store.GlobalIndexCacheWithLocalRegion;
import com.pivotal.gemfirexd.internal.hadoop.HadoopGfxdLonerConfig;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.locks.LockFactory;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleSupportable;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.property.PersistentSet;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyFactory;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.store.access.AccessFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.MethodFactory;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.AuthenticationServiceBase;
import com.pivotal.gemfirexd.internal.impl.services.stream.GfxdHeaderPrintWriterImpl;
import com.pivotal.gemfirexd.internal.impl.services.stream.SingleStream;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.GfxdJarResource;
import com.pivotal.gemfirexd.internal.impl.store.raw.xact.TransactionTable;
import com.pivotal.gemfirexd.internal.jdbc.InternalDriver;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.snappy.CallbackFactoryProvider;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class GemFireStore
implements AccessFactory,
ModuleControl,
ModuleSupportable,
PersistentSet {
    public static final String MODULE = "com.pivotal.gemfirexd.internal.engine.store.GemFireStore";
    public static final String IMPLEMENTATIONID = "memstore";
    public static Object[] EXPECTED_STARTUP_EXCEPTIONS;
    public static final String DDL_STMTS_REGION = "_DDL_STMTS_META_REGION";
    private static InternalDistributedMember selfMemId;
    private static GemFireStore bootingInstance;
    private static GemFireStore bootedInstance;
    private final AtomicLong nextConglomId;
    private final ConcurrentHashMap<ContainerKey, MemConglomerate> conglomerates;
    private final ConcurrentHashMap<String, MethodFactory> implhash;
    private GemFireCacheImpl gemFireCache;
    private boolean skipCacheClose;
    private Agent gemFireAgent;
    private FabricDatabase database;
    private GfxdHeapThresholdListener thresholdListener;
    private ObjectSizer gfxdObjectSizer;
    private final ReadWriteLock ddlReplayLock;
    private volatile boolean ddlReplayInProgress;
    private volatile boolean ddlReplayDone;
    private volatile boolean ddlReplayPart1Done;
    private volatile boolean ddlReplayWaiting;
    private final Object ddlReplaySync = new Object();
    private final TLongHashSet ddlIDsProcessedSet;
    private volatile GfxdDDLRegionQueue ddlStmtQueue;
    private GfxdDRWLockService ddlLockService;
    private final LinkedHashMap<ContainerKey, MemConglomerate> uninitializedConglomerates;
    private final ArrayList<MemOperation> ddlReplayPendingOperations;
    private volatile VMKind myKind;
    private final StoreAdvisee advisee;
    private final Properties serviceProperties;
    private final Properties servicePropertiesDefaults;
    private PropertyConglomerate xactProperties;
    private PropertyFactory pf;
    private DiskStoreImpl gfxdDefaultDiskStore;
    private boolean persistingDD;
    private boolean persistIndexes = true;
    private String persistenceDir = null;
    private String hdfsRootDir = null;
    private volatile boolean tableDefaultPartitioned;
    private GfxdJarResource fileHandler;
    private TransactionTable ttab;
    private String dbLocaleStr;
    private volatile LocalRegion identityRegion;
    private boolean isHadoopGfxdLonerMode = false;
    private HadoopGfxdLonerConfig hadoopGfxdLonerConfig = null;
    private volatile boolean isShutdownAll = false;
    private THashMap uuidToIdMap;
    private final StoreStatistics storeStats;
    private final IndexPersistenceStats indexPersistenceStats;
    private ExternalCatalog externalCatalog;
    private String databaseName;
    private boolean snappyStore;
    private final Object indexLoadSync;
    private boolean indexLoadBegin;

    public GemFireStore() {
        GemFireCacheImpl.FactoryStatics.init();
        this.nextConglomId = new AtomicLong(-1L);
        this.conglomerates = new ConcurrentHashMap();
        this.implhash = new ConcurrentHashMap();
        this.ddlReplayLock = new ReentrantReadWriteLock();
        this.ddlReplayInProgress = false;
        this.ddlReplayDone = false;
        this.ddlIDsProcessedSet = new TLongHashSet();
        this.uninitializedConglomerates = new LinkedHashMap();
        this.ddlReplayPendingOperations = new ArrayList();
        this.servicePropertiesDefaults = new Properties();
        this.serviceProperties = new Properties(this.servicePropertiesDefaults);
        this.advisee = new StoreAdvisee();
        this.storeStats = new StoreStatistics();
        this.indexLoadSync = new Object();
        this.indexLoadBegin = false;
        this.indexPersistenceStats = new IndexPersistenceStats();
    }

    @Override
    public void createFinished() throws StandardException {
    }

    @Override
    public MethodFactory findMethodFactoryByImpl(String impltype) throws StandardException {
        Properties conglomProperties;
        MethodFactory factory;
        block5: {
            factory = this.implhash.get(impltype);
            if (factory != null) {
                return factory;
            }
            for (MethodFactory fact : this.implhash.values()) {
                if (!fact.supportsImplementation(impltype)) continue;
                return fact;
            }
            conglomProperties = new Properties(this.serviceProperties);
            conglomProperties.put("gemfirexd.access.Conglomerate.type", impltype);
            try {
                factory = (MethodFactory)Monitor.bootServiceModule(false, this, "com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.MethodFactory", impltype, conglomProperties);
            }
            catch (StandardException se) {
                if (se.getMessageId().equals("XBM02.D")) break block5;
                throw se;
            }
        }
        conglomProperties = null;
        if (factory != null) {
            this.registerAccessMethod(factory);
            return factory;
        }
        return null;
    }

    @Override
    public LockFactory getLockFactory() {
        return null;
    }

    @Override
    public final TransactionController getTransaction(ContextManager cm, long connectionID) throws StandardException {
        return this.getAndNameTransaction(cm, "UserTransaction", connectionID);
    }

    @Override
    public final TransactionController getTransaction(ContextManager cm) throws StandardException {
        return this.getAndNameTransaction(cm, "UserTransaction");
    }

    public final TransactionController getAndNameTransaction(ContextManager cm, String transName, long connectionID) throws StandardException {
        assert (cm != null);
        GemFireTransaction tran = GemFireTransaction.findUserTransaction(cm, transName, connectionID);
        assert (tran != null);
        return tran;
    }

    @Override
    public void registerAccessMethod(MethodFactory factory) {
        this.implhash.put(factory.primaryImplementationType(), factory);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public static GemFireStore getBootingInstance() {
        return bootingInstance;
    }

    public static final GemFireStore getBootedInstance() {
        return bootedInstance;
    }

    public GemFireCacheImpl getGemFireCache() {
        return this.gemFireCache;
    }

    public Agent getGemFireAgent() {
        return this.gemFireAgent;
    }

    public ObjectSizer getObjectSizer() {
        return this.gfxdObjectSizer;
    }

    public long getNextConglomId() {
        return this.nextConglomId.incrementAndGet();
    }

    public MemConglomerate findConglomerate(ContainerKey id) {
        MemConglomerate conglom = this.conglomerates.get(id);
        if (GemFireXDUtils.TraceConglomRead) {
            SanityManager.DEBUG_PRINT((String)"TraceConglomRead", (String)("GemFireStore#findConglomerate: returning conglomerate [" + conglom + "] for ID [" + id + ']'));
        }
        return conglom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConglomerate(ContainerKey id, MemConglomerate conglom) throws StandardException {
        int conglomType;
        MemConglomerate oldConglom;
        if (GemFireXDUtils.TraceConglom) {
            SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)String.format("GemFireStore#addConglomerate: adding conglomerate [%s] with ID [%s]", conglom, id));
        }
        if ((oldConglom = this.conglomerates.putIfAbsent(id, conglom)) != null) {
            throw new GemFireXDRuntimeException(String.format("GemFireStore#addConglomerate: unexpected existing container %s for container [%s]", oldConglom.getGemFireContainer(), conglom.getGemFireContainer()));
        }
        if (this.initialDDLReplayInProgress() && (conglomType = conglom.getType()) != 3 && conglomType != 1) {
            if (GemFireXDUtils.TraceConglom) {
                SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)String.format("GemFireStore#addConglomerate: adding conglomerate [%s] with ID [%s] to uninitialized list", conglom, id));
            }
            LinkedHashMap<ContainerKey, MemConglomerate> linkedHashMap = this.uninitializedConglomerates;
            synchronized (linkedHashMap) {
                this.uninitializedConglomerates.put(id, conglom);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropConglomerate(Transaction xact, ContainerKey id) throws StandardException {
        GemFireContainer container;
        MemConglomerate conglom;
        if (GemFireXDUtils.TraceConglom) {
            SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)String.format("GemFireContainer#dropConglomerate: dropping conglomerate with ID [%s]", id));
        }
        if ((conglom = this.conglomerates.remove(id)) != null && (container = conglom.getGemFireContainer()) != null) {
            if (this.initialDDLReplayInProgress() && container.isGlobalIndex() && !container.isInitialized()) {
                container.preInitializeRegion();
                container.initializeRegion();
            }
            container.drop((GemFireTransaction)xact);
        }
        if (this.initialDDLReplayInProgress()) {
            if (GemFireXDUtils.TraceConglom) {
                SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)String.format("GemFireContainer#dropConglomerate: removing conglomerate [%s] with ID [%s] from uninitialized list", conglom, id));
            }
            LinkedHashMap<ContainerKey, MemConglomerate> linkedHashMap = this.uninitializedConglomerates;
            synchronized (linkedHashMap) {
                this.uninitializedConglomerates.remove(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPendingOperation(MemOperation op, GemFireTransaction tran) throws StandardException, IOException {
        if (this.initialDDLReplayInProgress()) {
            ArrayList<MemOperation> arrayList = this.ddlReplayPendingOperations;
            synchronized (arrayList) {
                this.ddlReplayPendingOperations.add(op);
            }
            return true;
        }
        op.doMe(tran, null, null);
        return false;
    }

    public Region<?, ?> createSchemaRegion(String schemaName, TransactionController tc) throws StandardException {
        Region schemaRegion;
        block5: {
            schemaRegion = null;
            boolean locked = false;
            GemFireTransaction tran = (GemFireTransaction)tc;
            GemFireContainer.GFContainerLocking locking = null;
            if (!tran.skipLocks(schemaName, null)) {
                locking = new GemFireContainer.GFContainerLocking(new DefaultGfxdLockable(schemaName, null), false, null);
                locked = locking.lockContainer(tran, null, true, true);
                schemaRegion = this.gemFireCache.getRegion(schemaName);
                if (schemaRegion != null) {
                    return schemaRegion;
                }
            }
            AttributesFactory af = new AttributesFactory();
            af.setScope(Scope.DISTRIBUTED_NO_ACK);
            af.setDataPolicy(DataPolicy.EMPTY);
            af.setConcurrencyChecksEnabled(false);
            try {
                schemaRegion = this.gemFireCache.createRegion(schemaName, af.create());
            }
            catch (RegionExistsException ex) {
                LogWriterI18n logger = this.gemFireCache.getLoggerI18n();
                if (logger.finerEnabled()) {
                    logger.finer("createSchemaRegion: region for schema '" + schemaName + "' already exists", (Throwable)ex);
                }
                if (!locked) break block5;
                locking.unlockContainer(tran, null);
            }
        }
        return schemaRegion;
    }

    public void dropSchemaRegion(String schemaName, TransactionController tc) throws StandardException {
        Region region;
        boolean locked = false;
        GemFireTransaction tran = (GemFireTransaction)tc;
        GemFireContainer.GFContainerLocking locking = null;
        if (!tran.skipLocks(schemaName, null)) {
            locking = new GemFireContainer.GFContainerLocking(new DefaultGfxdLockable(schemaName, null), false, null);
            locked = locking.lockContainer(tran, null, true, true);
        }
        if ((region = this.gemFireCache.getRegion(schemaName)) == null || region.isDestroyed()) {
            LogWriterI18n logger = this.gemFireCache.getLoggerI18n();
            if (logger.fineEnabled()) {
                logger.fine("dropSchemaRegion: region [/" + schemaName + "] for schema '" + schemaName + "' already destroyed");
            }
            if (locked) {
                locking.unlockContainer(tran, null);
            }
        } else {
            region.localDestroyRegion();
        }
    }

    public GemFireContainer getContainer(ContainerKey id) {
        MemConglomerate conglom = this.findConglomerate(id);
        if (conglom != null) {
            return conglom.getGemFireContainer();
        }
        return null;
    }

    public List<GemFireContainer> getAllContainers() {
        ArrayList<GemFireContainer> containers = new ArrayList<GemFireContainer>();
        for (MemConglomerate conglom : this.conglomerates.values()) {
            if (conglom.getGemFireContainer() == null) continue;
            containers.add(conglom.getGemFireContainer());
        }
        return containers;
    }

    @Override
    @SuppressWarnings(value={"LG_LOST_LOGGER_DUE_TO_WEAK_REFERENCE"})
    public synchronized void boot(boolean create, Properties properties) throws StandardException {
        String persistIndexes;
        String propValue;
        String propName;
        boolean reconnected;
        Properties finalGFXDBootProps;
        String useDebugVersion;
        String disableSharedLibrary;
        Properties dsProps = null;
        String serverGroupsCSV = null;
        boolean hostData = true;
        boolean isLocator = false;
        boolean isAgent = false;
        boolean isAdmin = false;
        int dumpTimeStatsFreq = -1;
        float criticalHeapPercent = -1.0f;
        float evictionHeapPercent = -1.0f;
        float criticalOffHeapPercent = -1.0f;
        float evictionOffHeapPercent = -1.0f;
        this.clearStatics(true);
        GfxdDataSerializable.clearTypes();
        ClientSharedUtils.setCommonRuntimeException((CommonRunTimeException)new GemFireXDRuntimeException());
        FinalizeObject.clearFinalizationQueues();
        this.database = (FabricDatabase)properties.get(FabricDatabase.PROPERTY_NAME);
        if (this.database == null) {
            throw new AssertionError((Object)"Expected non-null database object");
        }
        bootingInstance = this;
        GemFireCacheImpl.setGFXDSystem((boolean)true);
        String propertyFileName = PropertyUtil.isSQLFire ? "sqlfire.properties" : "gemfirexd.properties";
        DistributedSystem.PROPERTY_FILE = PropertyUtil.getSystemProperty(propertyFileName, PropertyUtil.getSystemProperty("gemfirePropertyFile", propertyFileName));
        ResolverUtils.reset();
        if (PropertyUtil.getSystemBoolean("gemfirexd.use-pre1302-hashing", false)) {
            ResolverUtils.setUsePre1302Hashing((boolean)true);
        }
        if ((disableSharedLibrary = PropertyUtil.getSystemProperty("gemfire.disable.nativelibrary")) != null) {
            System.setProperty("gemfire.disable.nativelibrary", disableSharedLibrary);
        }
        if ((useDebugVersion = PropertyUtil.getSystemProperty("gemfire.nativelibrary.usedebugversion")) != null) {
            System.setProperty("gemfire.nativelibrary.usedebugversion", useDebugVersion);
        }
        try {
            finalGFXDBootProps = FabricServiceUtils.preprocessProperties(properties, null, null, false);
        }
        catch (SQLException e) {
            this.database = null;
            bootingInstance = null;
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof StandardException) {
                throw (StandardException)cause;
            }
            throw GemFireXDRuntimeException.newRuntimeException("Error during gemfire store bootup", cause);
        }
        InternalDistributedSystem dsys = InternalDistributedSystem.getConnectedInstance();
        boolean bl = reconnected = dsys != null && dsys.reconnected();
        if (reconnected) {
            Properties props = dsys.getProperties();
            for (Map.Entry<Object, Object> e : props.entrySet()) {
                finalGFXDBootProps.put(e.getKey(), e.getValue());
            }
            dsys.getLogWriter().info("Booting data store with reconnected distributed system: " + dsys);
        }
        Enumeration<?> propNames = finalGFXDBootProps.propertyNames();
        while (propNames.hasMoreElements()) {
            propName = (String)propNames.nextElement();
            propValue = finalGFXDBootProps.getProperty(propName);
            if (propName.equals("gemfirexd.__rt.fabricapi")) {
                if (propValue.equals(GfxdConstants.BT_INDIC.FABRICAGENT.toString())) {
                    isAgent = true;
                }
            } else if (propName.equals("gemfirexd.__rt.admin")) {
                isAdmin = true;
            }
            if (propValue == null) continue;
            this.serviceProperties.setProperty(propName, propValue);
        }
        Properties props = this.serviceProperties;
        hostData = PropertyUtil.getBooleanProperty("host-data", GfxdConstants.GFXD_HOST_DATA, props, true, null);
        serverGroupsCSV = PropertyUtil.findAndGetProperty(props, "server-groups", GfxdConstants.GFXD_SERVER_GROUPS);
        isLocator = PropertyUtil.getBooleanProperty("standalone-locator", GfxdConstants.GFXD_STAND_ALONE_LOCATOR, props, false, null);
        propName = "dump-time-stats-freq";
        propValue = PropertyUtil.findAndGetProperty(props, propName, GfxdConstants.GFXD_PREFIX + propName);
        if (propValue != null) {
            dumpTimeStatsFreq = this.readUnsignedIntegerProperty(propValue, propName);
        }
        if ((propValue = PropertyUtil.findAndGetProperty(props, "sys-disk-dir", GfxdConstants.SYS_PERSISTENT_DIR_PROP)) != null) {
            System.setProperty(GfxdConstants.SYS_PERSISTENT_DIR_PROP, propValue);
            this.persistenceDir = propValue;
        }
        if ((propValue = PropertyUtil.findAndGetProperty(props, "hdfs-root-dir", GfxdConstants.SYS_HDFS_ROOT_DIR_PROP)) != null) {
            System.setProperty(GfxdConstants.SYS_HDFS_ROOT_DIR_PROP, propValue);
            this.hdfsRootDir = propValue;
        }
        if ((propValue = PropertyUtil.findAndGetProperty(props, "critical-heap-percentage", GfxdConstants.GFXD_PREFIX + "critical-heap-percentage")) != null) {
            criticalHeapPercent = Float.parseFloat(propValue);
        }
        if ((propValue = PropertyUtil.findAndGetProperty(props, "eviction-heap-percentage", GfxdConstants.GFXD_PREFIX + "eviction-heap-percentage")) != null) {
            evictionHeapPercent = Float.parseFloat(propValue);
        }
        if ((propValue = PropertyUtil.findAndGetProperty(props, "critical-off-heap-percentage", GfxdConstants.GFXD_PREFIX + "critical-off-heap-percentage")) != null) {
            criticalOffHeapPercent = Float.parseFloat(propValue);
        }
        if ((propValue = PropertyUtil.findAndGetProperty(props, "eviction-off-heap-percentage", GfxdConstants.GFXD_PREFIX + "eviction-off-heap-percentage")) != null) {
            evictionOffHeapPercent = Float.parseFloat(propValue);
        }
        if ((propValue = PropertyUtil.findAndGetProperty(props, "hadoop.gemfirexd.loner.mode", "hadoop.gemfirexd.loner.mode")) != null) {
            this.isHadoopGfxdLonerMode = Boolean.parseBoolean(propValue);
            if (this.isHadoopGfxdLonerMode) {
                this.hadoopGfxdLonerConfig = new HadoopGfxdLonerConfig(finalGFXDBootProps, this);
                System.setProperty("gemfire.disableManagement", "true");
            }
        }
        InternalDistributedSystem.setHadoopGfxdLonerMode((boolean)this.isHadoopGfxdLonerMode);
        this.tableDefaultPartitioned = false;
        String defaultTablePolicy = PropertyUtil.getSystemProperty(GfxdConstants.TABLE_DEFAULT_PARTITIONED_SYSPROP);
        if (defaultTablePolicy == null) {
            defaultTablePolicy = this.serviceProperties.getProperty("table-default-partitioned");
        }
        if (defaultTablePolicy != null) {
            this.tableDefaultPartitioned = "true".equalsIgnoreCase(defaultTablePolicy);
        }
        this.persistIndexes = (persistIndexes = PropertyUtil.findAndGetProperty(finalGFXDBootProps, "persist-indexes", GfxdConstants.GFXD_PERSIST_INDEXES)) == null ? true : Boolean.parseBoolean(persistIndexes);
        if (GemFireXDUtils.TraceFabricServiceBoot) {
            SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)("GemFireStore.boot setting persist-indexes to " + persistIndexes));
        }
        if (isLocator) {
            this.myKind = VMKind.LOCATOR;
        } else if (isAdmin) {
            this.myKind = VMKind.ADMIN;
        } else if (isAgent) {
            this.myKind = VMKind.AGENT;
        } else if (!hostData) {
            this.myKind = VMKind.ACCESSOR;
            finalGFXDBootProps.put("disable-auto-reconnect", "true");
        } else {
            this.myKind = VMKind.DATASTORE;
        }
        try {
            PrintWriter gfxdLogger;
            String persistDD;
            Object[] expectedExceptions;
            dsProps = FabricServiceUtils.filterGemFireProperties(finalGFXDBootProps, "gemfirexd.log");
            String gfxdLogFile = SingleStream.getGFXDLogFile();
            if (gfxdLogFile != null) {
                System.setProperty("gemfire.append-log", "true");
                dsProps.put("log-file", gfxdLogFile);
            }
            if ((expectedExceptions = EXPECTED_STARTUP_EXCEPTIONS) != null) {
                for (Object exObj : expectedExceptions) {
                    String exStr = GemFireXDUtils.getExpectedExceptionString(exObj, false);
                    SanityManager.DEBUG_PRINT((String)"ExpectedEx", (String)exStr);
                    System.out.println(exStr);
                }
            }
            GemFireXDVersion.loadProperties();
            GfxdDataSerializable.initTypes();
            DataType.init();
            Jdk6Helper.init();
            GemFireXDUtils.dumpProperties(dsProps, "distributed member connection properties", "TraceFabricServiceBoot", GemFireXDUtils.TraceFabricServiceBoot, null);
            if (this.myKind.isAgent()) {
                AgentConfig aConf = AgentFactory.defineAgent((Properties)dsProps);
                try {
                    this.gemFireAgent = AgentFactory.getAgent((AgentConfig)aConf);
                    this.gemFireAgent.start();
                    this.gemFireAgent.getLogWriter().info("GemFire Agent successfully created");
                    dsProps.clear();
                }
                catch (AdminException ade) {
                    throw GemFireXDRuntimeException.newRuntimeException("Exception occurred while starting GemFireXD JXM Agent", ade);
                }
            }
            this.persistingDD = (persistDD = this.getBootProperty("persist-dd")) == null ? !(this.myKind.isAccessor() || this.myKind.isAdmin() || this.myKind.isAgent()) : Boolean.parseBoolean(persistDD);
            if ((this.myKind.isAccessor() || this.myKind.isAdmin() || this.myKind.isAgent()) && this.persistingDD) {
                throw new GemFireXDRuntimeException("persist-dd property should be false for clients");
            }
            try {
                CacheFactory c = new CacheFactory(dsProps);
                if (this.persistingDD) {
                    c.setPdxPersistent(true);
                    c.setPdxDiskStore("GFXD-DD-DISKSTORE");
                }
                this.gemFireCache = (GemFireCacheImpl)c.create();
                this.gemFireCache.getLogger().info("GemFire Cache successfully created.");
            }
            catch (CacheExistsException ex) {
                this.gemFireCache = GemFireCacheImpl.getExisting();
                this.gemFireCache.getLogger().info("Found existing GemFire Cache.");
            }
            this.skipCacheClose = false;
            if (criticalHeapPercent > 0.0f) {
                this.gemFireCache.getResourceManager().setCriticalHeapPercentage(criticalHeapPercent);
            }
            if (evictionHeapPercent > 0.0f) {
                this.gemFireCache.getResourceManager().setEvictionHeapPercentage(evictionHeapPercent);
            }
            if (criticalOffHeapPercent > 0.0f) {
                this.gemFireCache.getResourceManager().setCriticalOffHeapPercentage(criticalOffHeapPercent);
            }
            if (evictionOffHeapPercent > 0.0f) {
                this.gemFireCache.getResourceManager().setEvictionOffHeapPercentage(evictionOffHeapPercent);
            }
            dsys = this.gemFireCache.getDistributedSystem();
            LogWriter logger = this.gemFireCache.getLogger();
            selfMemId = this.gemFireCache.getMyId();
            InternalDriver.activeDriver().initialize(this.gemFireCache);
            CacheServerLauncher launcher = CacheServerLauncher.getCurrentInstance();
            if (launcher != null) {
                launcher.printCommandLine(this.gemFireCache.getLoggerI18n());
            }
            if (logger instanceof LogWriterImpl) {
                LogWriterImpl loggerImpl = (LogWriterImpl)logger;
                Logger javaUtilLogger = Logger.getLogger("snappystore");
                javaUtilLogger.addHandler(logger.getHandler());
                Level levelToBeSet = GemFireLevel.create((int)loggerImpl.getLevel());
                javaUtilLogger.setLevel(levelToBeSet);
                javaUtilLogger.setUseParentHandlers(false);
                ClientSharedUtils.setLogger((Logger)javaUtilLogger);
            }
            if ((gfxdLogger = SanityManager.GET_DEBUG_STREAM()) instanceof GfxdHeaderPrintWriterImpl) {
                ((GfxdHeaderPrintWriterImpl)gfxdLogger).setLogWriter(logger);
            }
            GemFireXDUtils.initConstants(this);
            this.thresholdListener = GfxdHeapThresholdListener.createInstance(this.gemFireCache);
            this.gfxdObjectSizer = new GfxdObjectSizer();
            FunctionService.registerFunction((Function)new DistributedConnectionCloseExecutorFunction());
            FunctionService.registerFunction((Function)new DistributedProcedureCallFunction());
            FunctionService.registerFunction((Function)new GfxdPartitionResolver.GlobalIndexLookupFunction());
            FunctionService.registerFunction((Function)new GfxdPartitionResolver.HdfsGlobalIndexLookupFunction());
            FunctionService.registerFunction((Function)new GfxdCacheLoader.GetRowFunction());
            FunctionService.registerFunction((Function)new QueryCancelFunction());
            ConnectionSignaller signaller = ConnectionSignaller.getInstance();
            if (logger.fineEnabled()) {
                logger.fine(signaller.toString() + " started.");
            }
            int maxVMLockWait = GfxdLockSet.initConstants(this);
            this.ddlLockService = GfxdDRWLockService.create("gfxd-ddl-lock-service", (DistributedSystem)dsys, true, true, false, maxVMLockWait, GfxdReentrantReadWriteLock.createTemplate(true), GfxdDDLMessage.getMemberDepartedListener());
            StringPrintWriter spw = new StringPrintWriter();
            Properties appProperties = Monitor.getMonitor().getApplicationProperties();
            spw = (StringPrintWriter)GemFireXDUtils.dumpProperties(appProperties, "file properties", null, true, (PrintWriter)spw);
            if (this.isHadoopGfxdLonerMode) {
                Properties updatedProps = this.hadoopGfxdLonerConfig.removeHadoopProperties(properties);
                spw = (StringPrintWriter)GemFireXDUtils.dumpProperties(updatedProps, "boot connection properties", null, true, (PrintWriter)spw);
            } else {
                spw = (StringPrintWriter)GemFireXDUtils.dumpProperties(properties, "boot connection properties", null, true, (PrintWriter)spw);
            }
            if (logger.configEnabled()) {
                logger.config("GemFire Cache successfully booted with " + SanityManager.lineSeparator + spw.toString());
            }
            GemFireXDUtils.dumpProperties(finalGFXDBootProps, "final values of the gemfirexd boot properties", "TraceFabricServiceBoot", GemFireXDUtils.TraceFabricServiceBoot, null);
            SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)("GemFireStore: booted with persist-indexes=" + this.persistIndexes));
            bootedInstance = this;
            this.dbLocaleStr = this.database.getLocale().toString();
            SortedSet sortedGroups = SharedUtils.toSortedSet((String)serverGroupsCSV, (boolean)false);
            this.advisee.start(sortedGroups, this.gemFireCache, logger);
            if (this.persistingDD) {
                this.gemFireCache.setVMIDRegionPath("/_DDL_STMTS_META_REGION");
            }
            this.skipCacheClose = true;
            this.bootRegions();
            this.skipCacheClose = false;
            if (dumpTimeStatsFreq >= 0) {
                GemFireXDQueryObserverHolder.putInstance(new GemFireXDQueryTimeStatistics(dumpTimeStatsFreq));
            }
            Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.services.property.PropertyFactory", properties);
            Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.impl.services.spark.GfxdSparkServiceImpl", finalGFXDBootProps);
            GemFireCacheImpl.FactoryStatics.initGFXDCallbacks((boolean)true);
            ContextManager cm = ContextService.getFactory().getCurrentContextManager();
            TransactionController tc = this.getAndNameTransaction(cm, "UserTransaction");
            this.pf = (PropertyFactory)Monitor.findServiceModule(this, "com.pivotal.gemfirexd.internal.iapi.services.property.PropertyFactory");
            this.xactProperties = new PropertyConglomerate(tc, create, this.serviceProperties, this.servicePropertiesDefaults, this.pf);
            tc.commit();
            if (expectedExceptions != null) {
                for (Object exObj : expectedExceptions) {
                    String exStr = GemFireXDUtils.getExpectedExceptionString(exObj, true);
                    SanityManager.DEBUG_PRINT((String)"ExpectedEx", (String)exStr);
                    System.out.println(exStr);
                }
            }
            EXPECTED_STARTUP_EXCEPTIONS = null;
            this.storeStats.init((StatisticsFactory)this.gemFireCache.getDistributedSystem());
            this.indexPersistenceStats.init((StatisticsFactory)this.gemFireCache.getDistributedSystem());
            FabricService service = this.myKind.isLocator() ? FabricServiceManager.getFabricLocatorInstance() : (this.myKind.isAgent() ? FabricServiceManager.getFabricAgentInstance() : FabricServiceManager.getFabricServerInstance());
            assert (service instanceof FabricServiceImpl);
            ((FabricServiceImpl)service).notifyRunning();
            this.isShutdownAll = false;
            this.startExecutor();
        }
        catch (RuntimeException ex) {
            if (GemFireXDUtils.TraceFabricServiceBoot) {
                SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)"RuntimeExecption during database boot", (Throwable)ex);
            }
            this.stop();
            throw StandardException.newException("XJ040.C", (Throwable)ex, (Object)"gemfirexd");
        }
        catch (StandardException se) {
            if (GemFireXDUtils.TraceFabricServiceBoot) {
                SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)"Failed to boot database", (Throwable)se);
            }
            this.stop();
            throw se;
        }
        SanityManager.ASSERT((boolean)true);
        SanityManager.ASSERT((boolean)true);
        SanityManager.ASSERT((boolean)true);
        SanityManager.ASSERT((boolean)true);
        SanityManager.ASSERT((boolean)true);
    }

    private void startExecutor() {
        if (this.getMyVMKind() == VMKind.LOCATOR) {
            return;
        }
        Set<DistributedMember> servers = this.getDistributionAdvisor().adviseOperationNodes(CallbackFactoryProvider.getClusterCallbacks().getLeaderGroup());
        for (DistributedMember server : servers) {
            GfxdDistributionAdvisor.GfxdProfile other = GemFireXDUtils.getGfxdProfile(server);
            if (!other.hasSparkURL()) continue;
            if (server.equals(this.getMyId())) continue;
            CallbackFactoryProvider.getClusterCallbacks().launchExecutor(other.getSparkDriverURL(), other.getDistributedMember());
        }
    }

    private int readUnsignedIntegerProperty(String val, String propName) throws NumberFormatException {
        try {
            int intVal = Integer.parseInt(val);
            if (intVal >= 0) {
                return intVal;
            }
            throw new NumberFormatException();
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException("Boot property " + propName + " should be an integer >= 0 but found: " + val);
        }
    }

    public String generatePersistentDirName(String dirPath) {
        String baseDir = this.persistenceDir;
        if (baseDir == null) {
            baseDir = ".";
        }
        if (dirPath != null) {
            String drivePrefix;
            File dirProvided = new File(dirPath);
            boolean isAbsolute = dirProvided.isAbsolute();
            if (!(isAbsolute || dirPath.charAt(0) != '/' && dirPath.charAt(0) != '\\' || (drivePrefix = GemFireXDUtils.getCurrentDrivePrefix()) == null)) {
                isAbsolute = true;
                dirPath = drivePrefix + dirPath;
            }
            if (!isAbsolute) {
                dirPath = new File(baseDir, dirPath).getAbsolutePath();
            }
        } else {
            dirPath = new File(baseDir).getAbsolutePath();
        }
        return dirPath;
    }

    public String generateHdfsStoreDirName(String dirPath) {
        if (dirPath.startsWith("/")) {
            return dirPath;
        }
        String baseDir = this.hdfsRootDir;
        if (baseDir == null) {
            baseDir = ".";
        }
        return baseDir + "/" + dirPath;
    }

    public static InternalDistributedMember getMyId() {
        return selfMemId;
    }

    public VMKind getMyVMKind() {
        return this.myKind;
    }

    private void bootRegions() throws StandardException {
        VMKind vmKind;
        this.renameDiskStoresIfAny();
        AttributesFactory af = new AttributesFactory();
        af.setScope(Scope.LOCAL);
        af.setConcurrencyChecksEnabled(false);
        this.gemFireCache.createRegion("SYS", af.create());
        af.setScope(Scope.DISTRIBUTED_NO_ACK);
        af.setDataPolicy(DataPolicy.EMPTY);
        this.gemFireCache.createRegion("APP", af.create());
        this.gemFireCache.createRegion("SESSION", af.create());
        if (this.persistingDD || this.persistenceDir != null) {
            try {
                DiskStoreFactory dsf = this.gemFireCache.createDiskStoreFactory();
                File file = new File(this.generatePersistentDirName(null)).getAbsoluteFile();
                if (!file.mkdirs() && !file.isDirectory()) {
                    throw new DiskAccessException("Could not create directory for  default disk store : " + file.getAbsolutePath(), (Region)null);
                }
                if (!this.myKind.isStore()) {
                    if (DiskStoreFactory.DEFAULT_MAX_OPLOG_SIZE < 10L) {
                        dsf.setMaxOplogSize(DiskStoreFactory.DEFAULT_MAX_OPLOG_SIZE);
                    } else {
                        dsf.setMaxOplogSize(10L);
                    }
                }
                dsf.setDiskDirs(new File[]{file});
                DiskAccessException dae = null;
                for (int tries = 1; tries <= 10; ++tries) {
                    try {
                        this.gfxdDefaultDiskStore = (DiskStoreImpl)dsf.create("GFXD-DEFAULT-DISKSTORE");
                        dae = null;
                        break;
                    }
                    catch (DiskAccessException e) {
                        LogWriter logger = this.gemFireCache.getLogger();
                        logger.warning("unexpected exception in creating default disk store, retrying", (Throwable)e);
                        if (dae == null) {
                            dae = e;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            this.getAdvisee().getCancelCriterion().checkCancelInProgress((Throwable)ie);
                        }
                        continue;
                    }
                }
                if (dae != null) {
                    throw dae;
                }
                GemFireCacheImpl.setDefaultDiskStoreName((String)"GFXD-DEFAULT-DISKSTORE");
            }
            catch (GemFireException e) {
                LogWriter logger = this.gemFireCache.getLogger();
                logger.warning("Unable to create default disk store.", (Throwable)e);
                throw e;
            }
        }
        this.ddlStmtQueue = new GfxdDDLRegionQueue(DDL_STMTS_REGION, this.gemFireCache, this.persistingDD, this.getBootProperty("sys-disk-dir"), null);
        if (this.isHadoopGfxdLonerMode) {
            this.hadoopGfxdLonerConfig.loadDDLQueueWithDDLsFromHDFS(this.ddlStmtQueue);
        }
        if ((vmKind = this.advisee.getVMKind()).isAccessorOrStore()) {
            try {
                this.fileHandler = new GfxdJarResource(this.persistingDD, this.gemFireCache);
            }
            catch (Exception e) {
                SanityManager.DEBUG_PRINT((String)"warning:TraceFabricServiceBoot", (String)"Unable to create file handler for jar storage", (Throwable)e);
                throw GemFireXDRuntimeException.newRuntimeException(null, e);
            }
        }
        this.uuidToIdMap = new THashMap();
        this.ttab = new TransactionTable();
        if (vmKind.isAccessorOrStore() && !this.isHadoopGfxdLonerMode()) {
            AttributesFactory afact = new AttributesFactory();
            PartitionAttributesFactory pafact = new PartitionAttributesFactory();
            pafact.setTotalNumBuckets(17);
            pafact.setRedundantCopies(0);
            afact.setDataPolicy(DataPolicy.PARTITION);
            if (vmKind.isAccessor()) {
                pafact.setLocalMaxMemory(0);
            }
            afact.setPartitionAttributes(pafact.create());
            afact.setConcurrencyChecksEnabled(GfxdConstants.TABLE_DEFAULT_CONCURRENCY_CHECKS_ENABLED);
            RegionAttributes rattrs = afact.create();
            InternalRegionArguments iargs = new InternalRegionArguments().setDestroyLockFlag(true).setRecreateFlag(false).setKeyRequiresRegionContext(false).setIsUsedForMetaRegion(true);
            try {
                this.identityRegion = (LocalRegion)this.gemFireCache.createVMRegion("__IDENTITYREGION2", rattrs, iargs);
                IdentityValueManager.GetIdentityValueMessage.installBucketListener((PartitionedRegion)this.identityRegion);
            }
            catch (IOException e) {
                throw StandardException.newException("38000", (Throwable)e, (Object)e.toString());
            }
            catch (ClassNotFoundException e) {
                throw StandardException.newException("38000", (Throwable)e, (Object)e.toString());
            }
        }
    }

    private void renameDiskStoresIfAny() {
        String persistDirectory = this.generatePersistentDirName(this.persistenceDir);
        List<File> files = GemFireXDUtils.listFiles("SQLF-DD-DISKSTORE", Arrays.asList(persistDirectory + File.separatorChar + "datadictionary"));
        if (files.size() > 0) {
            GemFireXDUtils.renameFiles(files);
        }
        if ((files = GemFireXDUtils.listFiles("SQLF-DEFAULT-DISKSTORE", Arrays.asList(persistDirectory))).size() > 0) {
            GemFireXDUtils.renameFiles(files);
        }
    }

    public TransactionTable getTransactionTable() {
        return this.ttab;
    }

    public GfxdJarResource getJarFileHandler() {
        return this.fileHandler;
    }

    public THashMap getUUID_IDMap() {
        return this.uuidToIdMap;
    }

    public String getBootProperty(String propName) {
        return this.serviceProperties.getProperty(propName);
    }

    public Map<Object, Object> getBootProperties() {
        return Collections.unmodifiableMap(this.serviceProperties);
    }

    public final boolean initialDDLReplayInProgress() {
        return this.ddlReplayInProgress;
    }

    public final void setInitialDDLReplayInProgress(boolean replayInProgress) {
        this.ddlReplayInProgress = replayInProgress;
    }

    public final boolean initialDDLReplayDone() {
        return this.ddlReplayDone;
    }

    public final void setInitialDDLReplayDone(boolean replayDone) {
        this.ddlReplayDone = replayDone;
    }

    public final boolean initialDDLReplayPart1Done() {
        return this.ddlReplayPart1Done;
    }

    public final void setInitialDDLReplayPart1Done(boolean replayDone) {
        this.ddlReplayPart1Done = replayDone;
    }

    public final boolean initialDDLReplayWaiting() {
        return this.ddlReplayWaiting;
    }

    public final void setInitialDDLReplayWaiting(boolean waiting) {
        this.ddlReplayWaiting = waiting;
    }

    public final Object getInitialDDLReplaySync() {
        return this.ddlReplaySync;
    }

    public void acquireDDLReplayLock(boolean forWrite) {
        if (forWrite) {
            this.ddlReplayLock.writeLock().lock();
        } else {
            this.ddlReplayLock.readLock().lock();
        }
    }

    public void releaseDDLReplayLock(boolean forWrite) {
        if (forWrite) {
            this.ddlReplayLock.writeLock().unlock();
        } else {
            this.ddlReplayLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDDLReplayInitialization(TransactionController tc) throws Exception {
        PartitionedRegion pr;
        DataPolicy dp;
        LocalRegion region;
        GemFireContainer container;
        ArrayList<MemConglomerate> uninitializedCongloms;
        LinkedHashMap<ContainerKey, MemConglomerate> linkedHashMap = this.uninitializedConglomerates;
        synchronized (linkedHashMap) {
            uninitializedCongloms = new ArrayList<MemConglomerate>(this.uninitializedConglomerates.values());
            this.uninitializedConglomerates.clear();
        }
        for (MemConglomerate conglom : uninitializedCongloms) {
            PartitionedRegionDataStore ds;
            container = conglom.getGemFireContainer();
            if (container == null || (region = container.getRegion()) == null || !(dp = region.getDataPolicy()).withPartitioning() || (ds = (pr = (PartitionedRegion)region).getDataStore()) == null) continue;
            PartitionedRegion leaderRegion = ColocationHelper.getLeaderRegion((PartitionedRegion)pr);
            boolean isLeaderPersistent = leaderRegion.getDataPolicy().withPersistence();
            boolean isShadowPRPersistent = false;
            List childRegions = ColocationHelper.getColocatedChildRegions((PartitionedRegion)leaderRegion);
            for (PartitionedRegion childRegion : childRegions) {
                if (!childRegion.isShadowPR() || !childRegion.getDataPolicy().withPersistence()) continue;
                isShadowPRPersistent = true;
                break;
            }
            for (BucketRegion breg : ds.getAllLocalBucketRegions()) {
                GemFireContainer gfcontainer;
                if ((isLeaderPersistent || isShadowPRPersistent) && !breg.getBucketAdvisor().isPrimary() || (gfcontainer = (GemFireContainer)pr.getUserAttribute()).isGlobalIndex()) continue;
                Assert.fail((Object)("unexpected bucket created or selected as primary during DDL replay: " + breg + ", leaderRegion: " + leaderRegion));
            }
        }
        this.getDistributionAdvisor().distributeNodeStatus(true);
        for (MemConglomerate conglom : uninitializedCongloms) {
            container = conglom.getGemFireContainer();
            if (container == null || (region = container.getRegion()) == null) continue;
            if (GemFireXDUtils.TraceConglom) {
                SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)String.format("GemFireContainer#postDDLReplayInitializeRegions: post initialization for conglomerate [%s] region [%s]", conglom, region));
            }
            if ((dp = region.getDataPolicy()).withReplication() || !dp.withStorage()) {
                region.initialized();
                continue;
            }
            if (!dp.withPartitioning()) continue;
            pr = (PartitionedRegion)region;
            this.finishInitialization(pr);
            List childRegions = ColocationHelper.getColocatedChildRegions((PartitionedRegion)pr);
            for (PartitionedRegion childRegion : childRegions) {
                if (!childRegion.isShadowPR()) continue;
                this.finishInitialization(childRegion);
            }
        }
        GemFireTransaction tran = (GemFireTransaction)tc;
        ArrayList<MemOperation> arrayList = this.ddlReplayPendingOperations;
        synchronized (arrayList) {
            for (MemOperation op : this.ddlReplayPendingOperations) {
                op.doMe(tran, null, null);
            }
            this.ddlReplayPendingOperations.clear();
        }
    }

    public void finishInitialization(PartitionedRegion pr) {
        LocalRegion prRoot = PartitionedRegionHelper.getPRRoot((Cache)this.gemFireCache);
        LogWriterI18n logger = this.gemFireCache.getLoggerI18n();
        PartitionedRegion.RegionLock lock = pr.getRegionLock();
        boolean lockAcquired = false;
        try {
            if (logger.fineEnabled()) {
                logger.fine("GemFireContainer#postDDLReplayInitializeRegions: obtaining lock for region " + pr.getFullPath());
            }
            lock.lock();
            lockAcquired = true;
            pr.checkReadiness();
            PartitionRegionConfig prConfig = (PartitionRegionConfig)prRoot.get((Object)pr.getRegionIdentifier());
            pr.updatePRConfig(prConfig, true);
        }
        catch (IllegalStateException ise) {
            if (logger.fineEnabled()) {
                logger.fine("GemFireContainer#postDDLReplayInitializeRegions: unable to obtain lock for region " + pr);
            }
            pr.cleanupFailedInitialization();
            throw new PartitionedRegionException(LocalizedStrings.PartitionedRegion_CAN_NOT_CREATE_PARTITIONEDREGION_FAILED_TO_ACQUIRE_REGIONLOCK.toLocalizedString(), (Throwable)ise);
        }
        finally {
            if (lockAcquired) {
                lock.unlock();
                if (logger.fineEnabled()) {
                    logger.fine("GemFireContainer#postDDLReplayInitializeRegions: released lock for region " + pr.getFullPath());
                }
            }
        }
        if (pr.isDataStore()) {
            pr.getRedundancyProvider().scheduleCreateMissingBuckets();
            pr.getRedundancyProvider().scheduleRedundancyRecovery(null);
        }
        if (pr.isShadowPR()) {
            pr.shadowPRWaitForBucketRecovery();
        }
    }

    public final TLongHashSet getProcessedDDLIDs() {
        return this.ddlIDsProcessedSet;
    }

    @Override
    public Serializable getProperty(String key) throws StandardException {
        return (Serializable)this.serviceProperties.get(key);
    }

    @Override
    public Serializable getPropertyDefault(String key) throws StandardException {
        return (Serializable)this.servicePropertiesDefaults.get(key);
    }

    @Override
    public void setProperty(String key, Serializable value, boolean dbOnlyProperty) throws StandardException {
        this.xactProperties.setProperty(null, key, value, dbOnlyProperty);
    }

    @Override
    public void setPropertyDefault(String key, Serializable value) throws StandardException {
        this.xactProperties.setPropertyDefault(null, key, value);
    }

    @Override
    public boolean propertyDefaultIsVisible(String key) throws StandardException {
        return !this.serviceProperties.containsKey(key);
    }

    @Override
    public Properties getProperties() {
        return (Properties)this.serviceProperties.clone();
    }

    public final GfxdDDLRegionQueue getDDLStmtQueue() throws StandardException {
        GfxdDDLRegionQueue ddlQueue = this.ddlStmtQueue;
        assert (ddlQueue != null);
        if (this.advisee.getVMKind().isAccessorOrStore()) {
            return ddlQueue;
        }
        throw StandardException.newException("38000", null, (Object)("GemFireXD: cannot execute DDL statements on this JVM of type " + this.advisee.getVMKind().toString().toUpperCase()));
    }

    public final GfxdDDLRegionQueue getDDLQueueNoThrow() {
        return this.ddlStmtQueue;
    }

    public final boolean restrictedDDLStmtQueue() {
        return !this.advisee.getVMKind().isAccessorOrStore();
    }

    public final GfxdDRWLockService getDDLLockService() {
        return this.ddlLockService;
    }

    public final FabricDatabase getDatabase() {
        return this.database;
    }

    @Override
    public boolean canSupport(String identifier, Properties startParams) {
        if (startParams == null) {
            return true;
        }
        String impl = startParams.getProperty("gemfirexd.access");
        if (impl == null) {
            return false;
        }
        return this.supportsImplementation(impl);
    }

    public boolean supportsImplementation(String implementationId) {
        return implementationId.equals(IMPLEMENTATIONID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        if (bootingInstance == null) {
            return;
        }
        if (this.externalCatalog != null) {
            this.externalCatalog.stop();
        }
        CallbackFactoryProvider.getClusterCallbacks().stopExecutor();
        GfxdManagementService.handleEvent(3, this);
        FinalizeObject.getServerHolder().invokePendingFinalizers();
        FinalizeObject.clearFinalizationQueues();
        if (this.thresholdListener != null) {
            this.thresholdListener.stop();
        }
        ConnectionSignaller signaller = ConnectionSignaller.signalStop();
        this.advisee.stop(this.gemFireCache);
        Thread stopper = new Thread(new Runnable(){

            @Override
            public void run() {
                GfxdConnectionHolder.getHolder().clear();
            }
        });
        try {
            stopper.join(5000L);
            if (stopper.isAlive()) {
                stopper.interrupt();
                stopper.join(2000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        AuthenticationServiceBase.setIsShuttingDown(true);
        LogWriter logger = null;
        GemFireCacheImpl cache = this.gemFireCache;
        try {
            if (cache != null) {
                logger = cache.getLogger();
                if (signaller != null && logger.fineEnabled()) {
                    logger.fine(signaller.toString() + " stopped.");
                }
                if (logger.infoEnabled()) {
                    logger.info("Disconnecting GemFire distributed system and stopping GemFireStore");
                }
                if (!cache.isClosed() && !this.skipCacheClose) {
                    if (this.isShutdownAll) {
                        cache.shutDownAll();
                    } else if (!cache.forcedDisconnect()) {
                        cache.close();
                        InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
                        if (sys != null) {
                            sys.getLogWriter().info("Disconnecting GemFire distributed system.");
                            sys.disconnect();
                        }
                    }
                }
                this.gemFireCache = null;
                this.gfxdDefaultDiskStore = null;
                this.identityRegion = null;
                this.ddlStmtQueue = null;
            } else {
                cache = GemFireCacheImpl.getInstance();
                if (cache != null && !cache.isClosed() && !cache.forcedDisconnect()) {
                    if (this.isShutdownAll) {
                        cache.shutDownAll();
                    } else {
                        cache.close();
                    }
                }
            }
        }
        catch (Exception e) {
            SanityManager.DEBUG_PRINT((String)"error:TraceFabricServiceBoot", (String)"GemFireStore exception in GemFireCache stop", (Throwable)e);
        }
        LinkedHashMap<ContainerKey, MemConglomerate> e = this.uninitializedConglomerates;
        synchronized (e) {
            this.uninitializedConglomerates.clear();
        }
        this.conglomerates.clear();
        SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)"GemFireStore service stopped successfully, notifying status ... ");
        FabricService service = FabricServiceManager.currentFabricServiceInstance();
        if (service != null) {
            assert (service instanceof FabricServiceImpl);
            ((FabricServiceImpl)service).notifyStop(service.isReconnecting());
        }
        GemFireXDQueryObserverHolder.clearInstance();
        this.clearStatics(false);
        this.serviceProperties.clear();
        this.ddlIDsProcessedSet.clear();
        SanityManager.CLEAR_DEBUG_STREAM(null);
        ClientSharedUtils.clear();
        bootedInstance = null;
        bootingInstance = null;
    }

    public final LocalRegion getIdentityRegion() {
        return this.identityRegion;
    }

    public final String getLocale() {
        return this.dbLocaleStr;
    }

    public final DiskStoreImpl getDefaultDiskStore() {
        return this.gfxdDefaultDiskStore;
    }

    public final boolean isDataDictionaryPersistent() {
        return this.persistingDD;
    }

    public final boolean isPersistIndexes() {
        return this.persistIndexes;
    }

    public final boolean isTableDefaultPartitioned() {
        return this.tableDefaultPartitioned;
    }

    private void clearStatics(boolean forBoot) {
        if (InternalDistributedSystem.getReconnectCount() <= 0) {
            if (forBoot) {
                GfxdConnectionHolder.getHolder().clear();
            }
            GemFireXDUtils.reset(forBoot);
            CallbackProcedures.clearStatics();
            DistributionObserver.clearStatics();
            GemFireCacheImpl.setGFXDSystem((boolean)false);
            selfMemId = null;
            GlobalIndexCacheWithLocalRegion.setCacheToNull();
            this.externalCatalog = null;
        }
    }

    public final StoreAdvisee getAdvisee() {
        return this.advisee;
    }

    public final GfxdDistributionAdvisor getDistributionAdvisor() {
        return this.advisee.getDistributionAdvisor();
    }

    public boolean didIndexRecovery() {
        return true;
    }

    public boolean isHadoopGfxdLonerMode() {
        return this.isHadoopGfxdLonerMode;
    }

    @Override
    public TransactionInfo[] getTransactionInfo() {
        SanityManager.ASSERT((this.ttab != null ? 1 : 0) != 0, (String)"transaction table is null");
        return this.ttab.getTransactionInfo();
    }

    @Override
    public void freeze() throws StandardException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unfreeze() throws StandardException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void backup(String backupDir, boolean wait) throws StandardException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void backupAndEnableLogArchiveMode(String backupDir, boolean deleteOnlineArchivedLogFiles, boolean wait) throws StandardException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disableLogArchiveMode(boolean deleteOnlineArchivedLogFiles) throws StandardException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkpoint() throws StandardException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void waitForPostCommitToFinishWork() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object startXATransaction(ContextManager cm, int format_id, byte[] global_id, byte[] branch_id) throws StandardException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getXAResourceManager() throws StandardException {
        return null;
    }

    @Override
    public void startReplicationMaster(String dbmaster, String host, int port, String replicationMode) throws StandardException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stopReplicationMaster() throws StandardException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void failover(String dbname) throws StandardException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MethodFactory findMethodFactoryByFormat(UUID format) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TransactionController getAndNameTransaction(ContextManager cm, String transName) throws StandardException {
        return this.getAndNameTransaction(cm, transName, -1L);
    }

    public final GfxdHeapThresholdListener thresholdListener() {
        return this.thresholdListener;
    }

    public static void setTestNewIndexFlag(boolean flag) {
        DiskStoreImpl.TEST_NEW_CONTAINER = flag;
    }

    public void setShutdownAllMode() {
        this.isShutdownAll = true;
    }

    public boolean isShutdownAll() {
        return this.isShutdownAll;
    }

    public StoreStatistics getStoreStatistics() {
        return this.storeStats;
    }

    public IndexPersistenceStats getIndexPersistenceStats() {
        return this.indexPersistenceStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initExternalCatalog() {
        try {
            if (this.externalCatalog == null) {
                GemFireStore gemFireStore = this;
                synchronized (gemFireStore) {
                    if (this.externalCatalog == null) {
                        try {
                            this.externalCatalog = (ExternalCatalog)Class.forName("io.snappydata.impl.SnappyHiveCatalog").newInstance();
                        }
                        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                            throw new IllegalStateException("could not instantiate the snappy catalog", e);
                        }
                    }
                }
            }
            if (this.externalCatalog == null) {
                throw new IllegalStateException("could not instantiate snappy catalog");
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public ExternalCatalog getExternalCatalog() {
        return this.externalCatalog;
    }

    public void setDBName(String dbname) {
        if (this.databaseName == null) {
            this.databaseName = dbname;
            if (this.databaseName.equalsIgnoreCase("snappydata")) {
                this.snappyStore = true;
                this.database.setdisableStatementOptimizationToGenericPlan();
            }
        }
        if (!this.isSnappyStore()) {
            try {
                SigThreadDumpHandler.install();
            }
            catch (Throwable t) {
                SanityManager.DEBUG_PRINT((String)"fine:TRACE", (String)("Failed to install thread dump signal handler: " + t.getCause()));
            }
        }
    }

    public boolean isSnappyStore() {
        return this.snappyStore;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markIndexLoadBegin() {
        Object object = this.indexLoadSync;
        synchronized (object) {
            this.indexLoadBegin = true;
            this.indexLoadSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForIndexLoadBegin(long waitMillis) {
        Object object = this.indexLoadSync;
        synchronized (object) {
            if (!this.indexLoadBegin) {
                long endTime;
                if (waitMillis <= 0L) {
                    endTime = Long.MAX_VALUE;
                } else {
                    long startTime = System.currentTimeMillis();
                    endTime = startTime + waitMillis;
                    if (endTime < startTime) {
                        endTime = Long.MAX_VALUE;
                    }
                }
                long loopMillis = 500L;
                while (!this.indexLoadBegin && endTime > System.currentTimeMillis()) {
                    InterruptedException t = null;
                    try {
                        this.indexLoadSync.wait(500L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        t = ie;
                    }
                    Misc.checkIfCacheClosing(t);
                }
                return this.indexLoadBegin;
            }
            return true;
        }
    }

    static {
        selfMemId = null;
        bootingInstance = null;
        bootedInstance = null;
    }

    public static final class StoreStatistics {
        private Statistics stats;
        private int[] memoryAnalytics;
        private int[] statementPlan;
        private int[] statementStats;
        private int[] queryCancellationStats;
        private int[] timeoutCancellationStats;

        public void init(StatisticsFactory factory) {
            try {
                StatisticsTypeFactory tf = StatisticsTypeFactoryImpl.singleton();
                StatisticDescriptor maNumInvocations = tf.createIntCounter("maNumInvocations", "Number of invocations to MemoryAnalytics", "executions");
                StatisticDescriptor maNumInternalInvocations = tf.createIntCounter("maNumInternalInvocations", "Number of invocations to MemoryAnalytics triggered for internal purposes.", "executions");
                StatisticDescriptor maExecuteTime = tf.createLongCounter("maExecuteTime", "Time taken to evaluate MemoryAnalytics size computation.", "nanoseconds");
                StatisticDescriptor maInternalExecuteTime = tf.createLongCounter("maInternalExecuteTime", "Time taken on to evaluate MemoryAnalytics size computation during internal usage.", "nanoseconds");
                StatisticDescriptor spNumCollections = tf.createIntCounter("spNumCollections", "Number of times explain or statement plan invocations happened.", "executions");
                StatisticDescriptor spCollectionsTime = tf.createLongCounter("spCollectionsTime", "Time taken to collect execution plan triggered via explain or statement plan collection.", "nanoseconds");
                StatisticDescriptor spQueryTime = tf.createLongCounter("spQueryTime", "Time taken to execute the query passed into explain or statement plan collection.", "nanoseconds");
                StatisticDescriptor spNumRemoteCollections = tf.createIntCounter("spNumRemoteCollections", "Remote node equivalent of spNumCollections.", "executions");
                StatisticDescriptor spRemoteCollectionsTime = tf.createLongCounter("spRemoteCollectionsTime", "Remote node equivalent of spCollectionsTime.", "nanoseconds");
                StatisticDescriptor spRemoteQueryTime = tf.createLongCounter("spRemoteQueryTime", "Remote node equivalent of spQueryTime.", "nanoseconds");
                StatisticDescriptor ssNumCollections = tf.createIntCounter("ssNumCollections", "Number of statement statistics collections.", "executions");
                StatisticDescriptor ssCollectionsTime = tf.createLongCounter("ssCollectionsTime", "Time taken to collect statement statistics", "nanoseconds");
                StatisticDescriptor qcNumQueriesCancelled = tf.createIntCounter("qcNumQueriesCancelled", "Number of queries cancelled due to CRITICAL_UP heap notification.", "executions");
                StatisticDescriptor qcMemoryUsageComputeTime = tf.createLongCounter("qcMemoryUsageComputeTime", "Time taken to determine highest memory consuming active query & cancel it.", "nanoseconds");
                StatisticDescriptor qtoNumQueriesCancelled = tf.createIntCounter("qtoNumQueriesTimedOut", "Number of queries cancelled due to QueryTimeOut settings during execution.", "operations");
                StatisticsType type = tf.createType("storeStatistics", "GemFireXD Store level common set of statistics", new StatisticDescriptor[]{maNumInvocations, maNumInternalInvocations, maExecuteTime, maInternalExecuteTime, spNumCollections, spCollectionsTime, spQueryTime, spNumRemoteCollections, spRemoteCollectionsTime, spRemoteQueryTime, ssNumCollections, ssCollectionsTime, qcNumQueriesCancelled, qcMemoryUsageComputeTime, qtoNumQueriesCancelled});
                this.memoryAnalytics = new int[]{maNumInvocations.getId(), maExecuteTime.getId(), maNumInternalInvocations.getId(), maInternalExecuteTime.getId()};
                this.statementPlan = new int[]{spNumCollections.getId(), spCollectionsTime.getId(), spQueryTime.getId(), spNumRemoteCollections.getId(), spRemoteCollectionsTime.getId(), spRemoteQueryTime.getId()};
                this.statementStats = new int[]{ssNumCollections.getId(), ssCollectionsTime.getId()};
                this.queryCancellationStats = new int[]{qcNumQueriesCancelled.getId(), qcMemoryUsageComputeTime.getId()};
                this.timeoutCancellationStats = new int[]{qtoNumQueriesCancelled.getId()};
                this.stats = factory.createAtomicStatistics(type, "StoreStatistics");
            }
            catch (Exception e) {
                SanityManager.DEBUG_PRINT((String)"warning:ClassCreate", (String)("Got exception while loading class " + StoreStatistics.class.getName() + "  ex = " + e), (Throwable)e);
                throw new RuntimeException(e);
            }
        }

        public void collectMemoryAnalyticsStats(long executeTime, boolean isInternal) {
            if (!isInternal) {
                this.stats.incInt(this.memoryAnalytics[0], 1);
                this.stats.incLong(this.memoryAnalytics[1], executeTime);
            } else {
                this.stats.incInt(this.memoryAnalytics[2], 1);
                this.stats.incLong(this.memoryAnalytics[3], executeTime);
            }
        }

        public void collectStatementPlanStats(long collectionTime, boolean isRemote) {
            if (!isRemote) {
                this.stats.incInt(this.statementPlan[0], 1);
                this.stats.incLong(this.statementPlan[1], collectionTime);
            } else {
                this.stats.incInt(this.statementPlan[3], 1);
                this.stats.incLong(this.statementPlan[4], collectionTime);
            }
        }

        public void statementPlanQueryTime(long queryTime, boolean isRemote) {
            if (!isRemote) {
                this.stats.incLong(this.statementPlan[1], queryTime);
            } else {
                this.stats.incLong(this.statementPlan[5], queryTime);
            }
        }

        public void collectStatementStatisticsStats(long collectionTime) {
            this.stats.incInt(this.statementStats[0], 1);
            this.stats.incLong(this.statementStats[1], collectionTime);
        }

        public void collectQueryCancelledStats(long memoryEstimateComputeTime) {
            this.stats.incInt(this.queryCancellationStats[0], 1);
            this.stats.incLong(this.queryCancellationStats[1], memoryEstimateComputeTime);
        }

        public void collectQueryTimeOutStats() {
            this.stats.incInt(this.timeoutCancellationStats[0], 1);
        }
    }

    public static final class GfxdStatisticsSampleCollector
    implements HostStatSampler.StatsSamplerCallback {
        private static final GfxdStatisticsSampleCollector _theInstance = new GfxdStatisticsSampleCollector();

        public static final GfxdStatisticsSampleCollector getInstance() {
            return _theInstance;
        }

        public void prepareSamples(boolean prepareOnly) {
            FabricService service = FabricServiceManager.currentFabricServiceInstance();
            if (service != null) {
                assert (service instanceof FabricServiceImpl);
                for (FabricServiceImpl.NetworkInterfaceImpl networkInterfaceImpl : ((FabricServiceImpl)service).getAllNetworkServers()) {
                    networkInterfaceImpl.collectStatisticsSample();
                }
            }
        }
    }

    public static final class StoreAdvisee
    implements DistributionAdvisee {
        private final int serialNumber = DistributionAdvisor.createSerialNumber();
        private volatile GfxdDistributionAdvisor advisor;
        private volatile SortedSet<String> serverGroups;
        private final CancelCriterion stopper = new CancelCriterion(){

            public RuntimeException generateCancelledException(Throwable t) {
                RuntimeException ce;
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                if (cache != null && (ce = cache.getCancelCriterion().generateCancelledException(t)) != null) {
                    return ce;
                }
                if (Monitor.inShutdown()) {
                    return new CacheClosedException(MessageService.getCompleteMessage("XJ015.M", null), t);
                }
                return new CacheClosedException(LocalizedStrings.CacheFactory_A_CACHE_HAS_NOT_YET_BEEN_CREATED.toLocalizedString(), t);
            }

            public String cancelInProgress() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                if (cache == null) {
                    return LocalizedStrings.CacheFactory_A_CACHE_HAS_NOT_YET_BEEN_CREATED.toLocalizedString();
                }
                String cancel = cache.getCancelCriterion().cancelInProgress();
                if (cancel != null) {
                    return cancel;
                }
                if (Monitor.inShutdown()) {
                    return MessageService.getCompleteMessage("XJ015.M", null);
                }
                return null;
            }
        };

        private synchronized void start(SortedSet<String> groups, GemFireCacheImpl cache, LogWriter logger) {
            this.serverGroups = groups;
            this.advisor = GfxdDistributionAdvisor.createGfxdDistributionAdvisor(this, cache);
            cache.setGfxdAdvisee((DistributionAdvisee)this);
            this.advisor.handshake(logger);
        }

        private synchronized void stop(GemFireCacheImpl cache) {
            if (this.advisor != null && this.advisor.isInitialized()) {
                this.advisor.close();
            }
            if (cache != null) {
                cache.setGfxdAdvisee(null);
            }
            this.advisor = null;
        }

        public final VMKind getVMKind() {
            GemFireStore store = GemFireStore.getBootingInstance();
            if (store != null) {
                return store.myKind;
            }
            throw new CacheClosedException("StoreAdvisee#getVMKind: no store found. GemFireXD not booted or closed down.");
        }

        final synchronized void setVMKind(VMKind newKind) {
            GemFireStore store = GemFireStore.getBootingInstance();
            if (store != null) {
                store.myKind = newKind;
            }
            throw new CacheClosedException("StoreAdvisee#setVMKind: no store found. GemFireXD not booted or closed down.");
        }

        final SortedSet<String> getServerGroups() {
            return this.serverGroups;
        }

        final synchronized void setServerGroups(SortedSet<String> groups) {
            this.serverGroups = groups;
        }

        public void fillInProfile(DistributionAdvisor.Profile p) {
            assert (p instanceof GfxdDistributionAdvisor.GfxdProfile);
            GfxdDistributionAdvisor.GfxdProfile profile = (GfxdDistributionAdvisor.GfxdProfile)p;
            profile.setServerGroups(this.serverGroups);
            profile.setVMKind(this.getVMKind());
            profile.setPersistentDD(Misc.getMemStoreBooting().isDataDictionaryPersistent());
            profile.setLocale(Misc.getMemStoreBooting().getLocale());
            profile.serialNumber = this.getSerialNumber();
        }

        public DistributionAdvisor.Profile getProfile() {
            return this.advisor.getMyProfile();
        }

        public InternalDistributedSystem getSystem() {
            return Misc.getDistributedSystem();
        }

        public CancelCriterion getCancelCriterion() {
            return this.stopper;
        }

        public DM getDistributionManager() {
            return this.getSystem().getDistributionManager();
        }

        public GfxdDistributionAdvisor getDistributionAdvisor() {
            return this.advisor;
        }

        public final String getName() {
            return "GemFireXD.StoreAdvisee";
        }

        public final String getFullPath() {
            return this.getName();
        }

        public DistributionAdvisee getParentAdvisee() {
            return null;
        }

        public int getSerialNumber() {
            return this.serialNumber;
        }
    }

    public static class VMKind
    implements InternalDistributedSystem.MemberKind {
        private final String name;
        private final int ordinal;
        private static final VMKind[] values = new VMKind[7];
        public static final VMKind DATASTORE = new VMKind("datastore", 0);
        public static final VMKind ACCESSOR = new VMKind("accessor", 1);
        public static final VMKind LOCATOR = new VMKind("locator", 2);
        public static final VMKind AGENT = new VMKind("agent", 3);
        public static final VMKind ADMIN = new VMKind("admin", 6);

        protected VMKind(String name, int ordinal) {
            if (values[ordinal] != null) {
                throw new IllegalStateException("ordinal " + ordinal + " already assigned");
            }
            this.name = name;
            this.ordinal = ordinal;
            VMKind.values[ordinal] = this;
        }

        public final int ordinal() {
            return this.ordinal;
        }

        public static VMKind fromOrdinal(int ordinal) {
            return values[ordinal];
        }

        public final String toString() {
            return this.name;
        }

        public final boolean isAccessor() {
            return this == ACCESSOR;
        }

        public final boolean isLocator() {
            return this == LOCATOR;
        }

        public final boolean isStore() {
            return this == DATASTORE;
        }

        public final boolean isAccessorOrStore() {
            return this == ACCESSOR || this == DATASTORE;
        }

        public final boolean isAgent() {
            return this == AGENT;
        }

        public final boolean isAdmin() {
            return this == ADMIN;
        }
    }
}

