/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventErrorHandler;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.callbacks.EventErrorLogger;
import com.pivotal.gemfirexd.callbacks.GatewayEventErrorHandler;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.EventImpl;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import java.io.File;

public class EventErrorHandlerWrapper
implements EventErrorHandler {
    public static final String DEFAULT_ERROR_FILE_NAME_FOR_WAN_EVENTS = "failed_gateway_dmls.xml";
    protected EventErrorLogger evLogger;
    private GatewayEventErrorHandler customGatewayHandler;
    private static EventErrorHandler instance;

    public static EventErrorHandler getInstance() {
        if (instance == null) {
            instance = new EventErrorHandlerWrapper();
        }
        return instance;
    }

    private EventErrorHandlerWrapper() {
        String basePath = null;
        GemFireStore store = Misc.getMemStore();
        if (store != null) {
            basePath = store.generatePersistentDirName(null);
        }
        String fileName = basePath + File.separator + DEFAULT_ERROR_FILE_NAME_FOR_WAN_EVENTS;
        this.evLogger = new EventErrorLogger(fileName);
    }

    public void onError(EntryEvent ev, Exception e) {
        block7: {
            EventImpl event;
            LogWriterI18n logger;
            block6: {
                if (ev == null) {
                    return;
                }
                logger = GemFireCacheImpl.getExisting().getLoggerI18n();
                event = this.getEventImpl(ev);
                try {
                    this.evLogger.logError(event, e);
                }
                catch (Exception ex) {
                    if (logger == null || !logger.warningEnabled()) break block6;
                    logger.warning(LocalizedStrings.EVENT_LOGGER_FAILED_0_1_2, new Object[]{ev, e, ex});
                }
            }
            if (this.customGatewayHandler != null) {
                try {
                    this.customGatewayHandler.onError(event, e);
                }
                catch (Exception ex) {
                    if (logger == null || !logger.severeEnabled()) break block7;
                    logger.severe(LocalizedStrings.CUSTOM_EVENT_ERROR_HANDLER_FAILED_0_1_2, new Object[]{ev, e, ex});
                }
            }
        }
    }

    private EventImpl getEventImpl(EntryEvent ev) {
        EntryEventImpl entryEvent = (EntryEventImpl)ev;
        Operation op = entryEvent.getOperation();
        Event.Type type = null;
        if (op.equals(Operation.CREATE)) {
            type = Event.Type.AFTER_INSERT;
        } else if (op.equals(Operation.UPDATE)) {
            type = Event.Type.AFTER_UPDATE;
        } else if (op.equals(Operation.DESTROY)) {
            type = Event.Type.AFTER_DELETE;
        } else if (op.equals(Operation.BULK_DML_OP)) {
            type = Event.Type.BULK_DML;
        }
        EventImpl eventImpl = new EventImpl(entryEvent, type);
        return eventImpl;
    }

    public void setCustomGatewayEventErrorHandler(GatewayEventErrorHandler handler) {
        this.customGatewayHandler = handler;
    }
}

