/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireSelectDistributionActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.SnappyActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.SnappySelectResultSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultDescription;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.GenericResultDescription;
import com.pivotal.gemfirexd.internal.impl.sql.compile.Token;
import java.util.ArrayList;

public class PrepStatementSnappyActivation
extends GemFireSelectDistributionActivation {
    volatile AbstractGemFireResultSet currentRS = null;
    private String sql;
    boolean returnRows;

    public PrepStatementSnappyActivation(ExecPreparedStatement eps, LanguageConnectionContext _lcc, DMLQueryInfo qi, boolean returnRows) throws StandardException {
        super(eps, _lcc, qi);
        this.sql = eps.getSource();
        this.returnRows = returnRows;
        this.connectionID = this.lcc.getConnectionId();
    }

    @Override
    protected SnappySelectResultSet createResultSet(int resultsetNumber) throws StandardException {
        return new SnappySelectResultSet(this, this.returnRows);
    }

    @Override
    protected void executeWithResultSet(AbstractGemFireResultSet rs) throws StandardException {
        String querySql;
        boolean enableStreaming = this.lcc.streamingEnabled();
        GfxdResultCollector<Object> rc = null;
        rc = this.getResultCollector(enableStreaming, rs);
        if (this.getIsPrepStmntQuery() && this.pvs != null) {
            if (this.pvs.getParameterCount() > 0) {
                querySql = this.getModifiedSql();
                if (GemFireXDUtils.TraceQuery) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("PrepStatementSnappyActivation.executeWithResultSet: modified-sql=" + querySql));
                }
            } else {
                if (GemFireXDUtils.TraceQuery) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("PrepStatementSnappyActivation.executeWithResultSet: No dynamic parameters for sql=" + this.sql));
                }
                querySql = this.sql;
            }
        } else {
            throw StandardException.newException("38000", "Not a prepared statement. Sql=" + this.sql + " ,isPrepStmt=" + this.getIsPrepStmntQuery() + " ,pvs=" + this.pvs);
        }
        SnappyActivation.executeOnLeadNode((SnappySelectResultSet)rs, rc, querySql, enableStreaming, this.getConnectionID());
    }

    @Override
    public ResultDescription getResultDescription() {
        if (this.resultDescription == null) {
            this.resultDescription = SnappyActivation.makeResultDescription(this.resultSet);
        }
        return this.resultDescription;
    }

    public void setResultDescription(GenericResultDescription resultDescription) {
        this.resultDescription = resultDescription;
    }

    private String getModifiedSql() throws StandardException {
        String errorMsg = "";
        if (this.preStmt instanceof GenericPreparedStatement) {
            GenericPreparedStatement gps = (GenericPreparedStatement)this.preStmt;
            ArrayList<Token> tokenList = gps.getDynamicTokenList();
            if (tokenList != null) {
                StringBuilder modifiedSqlStr = new StringBuilder(this.sql.length());
                if (tokenList.size() != 0) {
                    if (tokenList.size() == this.pvs.getParameterCount()) {
                        if (GemFireXDUtils.TraceQuery) {
                            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("PrepStatementSnappyActivation.getModifiedSql. Got sql=" + this.sql + " ,#tokens=" + tokenList.size() + " ,#params" + this.pvs.getParameterCount() + " ,pvs=" + this.pvs + " ,tokens=" + tokenList));
                        }
                        int startPos = 0;
                        int i = 0;
                        for (Token v : tokenList) {
                            int beginC = v.beginOffset;
                            String str = this.sql.substring(startPos, beginC);
                            startPos = v.endOffset + 1;
                            modifiedSqlStr.append(str).append(" ").append(this.pvs.getParameter(i++).toString()).append(" ");
                        }
                        int cLen = this.sql.length();
                        if (startPos < cLen) {
                            String str = this.sql.substring(startPos, cLen);
                            modifiedSqlStr.append(str);
                        }
                        return modifiedSqlStr.toString();
                    }
                    errorMsg = "For SQL: " + this.sql + " ,Unequal: #tokens=" + tokenList.size() + " ,#params=" + this.pvs.getParameterCount() + " ,tokens=" + tokenList + " ,params=" + this.pvs;
                } else {
                    errorMsg = "For SQL: " + this.sql + " , 0 tokens." + " #params" + this.pvs.getParameterCount() + " ,params=" + this.pvs;
                }
            } else {
                errorMsg = "For SQL: " + this.sql + " , Null token list." + " #params" + this.pvs.getParameterCount() + " ,params=" + this.pvs;
            }
        } else {
            errorMsg = "Not GenericPreparedStatement SQL: " + this.sql + " ,but " + this.preStmt.getClass().getSimpleName();
        }
        if (GemFireXDUtils.TraceQuery) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("PrepStatementSnappyActivation.getModifiedSql. Error. sql=" + this.sql + " ,pvs=" + this.pvs + " ,error=" + errorMsg));
        }
        throw StandardException.newException("38000", errorMsg);
    }
}

