/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireUpdateActivation;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.util.Collection;

public class GemFireUpdateResultSet
extends AbstractGemFireResultSet {
    protected final GemFireContainer gfContainer;
    private GemFireContainer targetTableContainer;
    protected int numRowsModified;
    private final String targetTableName;

    GemFireUpdateResultSet(AbstractGemFireActivation act) throws StandardException {
        this(act, null);
    }

    GemFireUpdateResultSet(AbstractGemFireActivation act, String targetTableName) throws StandardException {
        super(act);
        this.gfContainer = (GemFireContainer)act.qInfo.getRegion().getUserAttribute();
        this.numRowsModified = 0;
        this.targetTableName = targetTableName;
    }

    @Override
    public void setup(Object results, int numMembers) throws StandardException {
        long beginTime;
        long l = beginTime = this.statisticsTimingOn ? XPLAINUtil.recordTiming(-1L) : 0L;
        if (this.activation.getInsertAsSubselect()) {
            int numUpdates = 0;
            if (results != null) {
                for (Object res : (Collection)results) {
                    if (res == null) continue;
                    numUpdates += ((Integer)res).intValue();
                }
            }
            this.numRowsModified = numUpdates;
        } else {
            int n = this.numRowsModified = results != null ? (Integer)results : 0;
        }
        if (this.statisticsTimingOn) {
            this.nextTime = XPLAINUtil.recordTiming(beginTime);
        }
    }

    @Override
    public final void setNumRowsModified(int numRowsModified) {
        this.numRowsModified = numRowsModified;
    }

    @Override
    protected final void openCore() throws StandardException {
        this.openContainers();
        LocalRegion reg = this.gfContainer.getRegion();
        GfxdIndexManager sqim = (GfxdIndexManager)(reg != null ? reg.getIndexUpdater() : null);
        if (sqim != null) {
            LanguageConnectionContext lcc = this.activation.getLanguageConnectionContext();
            GemFireTransaction tran = (GemFireTransaction)lcc.getTransactionExecute();
            sqim.fireStatementTriggers(2, lcc, tran, this.gfContainer.getActiveTXState(tran));
        }
    }

    private void takeLockOnTargetTable() throws StandardException {
        if (this.targetTableName != null) {
            if (this.targetTableContainer == null) {
                Region targetRegion = Misc.getRegionForTable(this.targetTableName, false);
                if (targetRegion == null) {
                    throw StandardException.newException("42X05", this.targetTableName);
                }
                this.targetTableContainer = (GemFireContainer)targetRegion.getUserAttribute();
            }
            if (this.targetTableContainer != null) {
                this.targetTableContainer.open(this.tran, 8);
            }
        }
    }

    protected void openContainers() throws StandardException {
        this.gfContainer.open(this.tran, 8);
        GemFireUpdateResultSet.openOrCloseFKContainers(this.gfContainer, this.tran, false, true);
        this.takeLockOnTargetTable();
    }

    @Override
    public void finishResultSet(boolean cleanupOnError) throws StandardException {
        GemFireUpdateResultSet.openOrCloseFKContainers(this.gfContainer, this.tran, true, true);
        this.gfContainer.closeForEndTransaction(this.tran, true);
        if (this.targetTableContainer != null) {
            this.targetTableContainer.closeForEndTransaction(this.tran, true);
        }
    }

    @Override
    public final void close(boolean cleanupOnError) throws StandardException {
        if (this.isClosed) {
            return;
        }
        this.closeTime = this.statisticsTimingOn ? XPLAINUtil.recordTiming(-1L) : 0L;
        LocalRegion reg = this.gfContainer.getRegion();
        GfxdIndexManager sqim = (GfxdIndexManager)(reg != null ? reg.getIndexUpdater() : null);
        if (sqim != null) {
            LanguageConnectionContext lcc = this.activation.getLanguageConnectionContext();
            GemFireTransaction tran = (GemFireTransaction)lcc.getTransactionExecute();
            sqim.fireStatementTriggers(this.getAfterTriggerEvent(), lcc, tran, this.gfContainer.getActiveTXState(this.tran));
        }
        super.close(cleanupOnError);
    }

    @Override
    public final int modifiedRowCount() {
        return this.numRowsModified;
    }

    @Override
    public final boolean returnsRows() {
        return false;
    }

    int getAfterTriggerEvent() {
        return 5;
    }

    @Override
    public final void accept(ResultSetStatisticsVisitor visitor) {
        visitor.setNumberOfChildren(0);
        visitor.visit(this);
    }

    @Override
    public long estimateMemoryUsage() throws StandardException {
        return 0L;
    }

    @Override
    public final void flushBatch() throws StandardException {
        if (this.activation instanceof GemFireUpdateActivation) {
            ((GemFireUpdateActivation)this.activation).flushBatch();
            this.checkCancellationFlag();
        }
    }

    @Override
    public boolean hasAutoGeneratedKeysResultSet() {
        return false;
    }
}

