/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.gemstone.gnu.trove.TIntArrayList;
import com.gemstone.gnu.trove.TIntIntHashMap;
import com.gemstone.gnu.trove.TLongArrayList;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraTableInfo;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.TargetResultSet;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongint;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ValueRow;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.ArrayList;

public final class AutogenKeysResultSet
implements ResultSet,
NoPutResultSet {
    private final Activation activation;
    private final TIntIntHashMap columnMap;
    private final TLongArrayList singleUUIDList;
    private final ArrayList<long[]> uuidList;
    private final TIntArrayList singleShortUUIDList;
    private final ArrayList<int[]> shortUUIDList;
    private final int nUUIDs;
    private final int nShortUUIDs;
    private boolean isOpen;
    private int iterPos;
    private int numRows;
    private final ValueRow currentRow;
    static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(AutogenKeysResultSet.class);

    public AutogenKeysResultSet(Activation activation, int[] autoGenColumnPositions, ExtraTableInfo tableInfo) {
        this.activation = activation;
        int numAutoGenKeys = autoGenColumnPositions.length;
        this.columnMap = new TIntIntHashMap(numAutoGenKeys);
        this.currentRow = new ValueRow(numAutoGenKeys);
        int rowPos = 0;
        int numUUIDs = 0;
        int numShortUUIDs = 0;
        for (int pos : autoGenColumnPositions) {
            ColumnDescriptor cd = tableInfo.getAutoGeneratedColumn(pos);
            ++rowPos;
            int typeId = cd.getType().getDVDTypeFormatId();
            if (typeId == 84) {
                this.columnMap.put(rowPos, ++numUUIDs);
                this.currentRow.setColumn(rowPos, new SQLLongint());
                continue;
            }
            if (typeId != 80) {
                SanityManager.THROWASSERT((String)("unexpected type of autogenerated column (expected BIGINT or INT): " + cd));
            }
            this.columnMap.put(rowPos, -(++numShortUUIDs));
            this.currentRow.setColumn(rowPos, new SQLInteger());
        }
        if (numUUIDs > 0) {
            if (numUUIDs == 1) {
                this.singleUUIDList = new TLongArrayList();
                this.uuidList = null;
            } else {
                this.uuidList = new ArrayList();
                this.singleUUIDList = null;
            }
        } else {
            this.singleUUIDList = null;
            this.uuidList = null;
        }
        if (numShortUUIDs > 0) {
            if (numShortUUIDs == 1) {
                this.singleShortUUIDList = new TIntArrayList();
                this.shortUUIDList = null;
            } else {
                this.shortUUIDList = new ArrayList();
                this.singleShortUUIDList = null;
            }
        } else {
            this.singleShortUUIDList = null;
            this.shortUUIDList = null;
        }
        this.nUUIDs = numUUIDs;
        this.nShortUUIDs = numShortUUIDs;
    }

    public void insertRow(ExecRow row, int[] autoGenColumnPositions) throws StandardException {
        int[] shortUUIDs;
        long[] uuids;
        if (this.nUUIDs <= 1) {
            uuids = null;
        } else {
            uuids = new long[this.nUUIDs];
            this.uuidList.add(uuids);
        }
        if (this.nShortUUIDs <= 1) {
            shortUUIDs = null;
        } else {
            shortUUIDs = new int[this.nShortUUIDs];
            this.shortUUIDList.add(shortUUIDs);
        }
        int uuidIndex = 0;
        int shortUUIDIndex = 0;
        for (int pos : autoGenColumnPositions) {
            DataValueDescriptor dvd = row.getColumn(pos);
            int typeId = dvd.getTypeFormatId();
            if (typeId == 84) {
                if (uuids == null) {
                    this.singleUUIDList.add(dvd.getLong());
                    continue;
                }
                uuids[uuidIndex++] = dvd.getLong();
                continue;
            }
            assert (typeId == 80) : "unexpected type of autogenerated column (expected BIGINT or INT) " + typeId + ": " + dvd;
            if (shortUUIDs == null) {
                this.singleShortUUIDList.add(dvd.getInt());
                continue;
            }
            shortUUIDs[shortUUIDIndex++] = dvd.getInt();
        }
        ++this.numRows;
    }

    public long estimateMemoryUsage() {
        long memory = BASE_MEMORY_USAGE;
        if (this.numRows > 0) {
            int rowSize;
            int n = this.nUUIDs > 1 ? 4 * this.nUUIDs + ClassSize.estimateArrayOverhead() : (rowSize = this.nUUIDs == 1 ? 4 : 0);
            memory += (long)(this.numRows * (rowSize += this.nShortUUIDs > 1 ? 2 * this.nShortUUIDs + ClassSize.estimateArrayOverhead() : (this.nShortUUIDs == 1 ? 2 : 0)));
        }
        return memory;
    }

    public int numRows() {
        return this.numRows;
    }

    @Override
    public void openCore() throws StandardException {
        this.isOpen = true;
    }

    @Override
    public void reopenCore() throws StandardException {
        this.isOpen = true;
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isOpen && this.iterPos < this.numRows) {
            long[] uuids = this.uuidList == null ? null : this.uuidList.get(this.iterPos);
            int[] shortUUIDs = this.shortUUIDList == null ? null : this.shortUUIDList.get(this.iterPos);
            for (int colPos = 1; colPos <= this.currentRow.nColumns(); ++colPos) {
                int listPos = this.columnMap.get(colPos);
                if (listPos > 0) {
                    if (this.singleUUIDList != null) {
                        this.currentRow.getColumn(colPos).setValue(this.singleUUIDList.get(this.iterPos));
                        continue;
                    }
                    this.currentRow.getColumn(colPos).setValue(uuids[listPos - 1]);
                    continue;
                }
                if (this.singleShortUUIDList != null) {
                    this.currentRow.getColumn(colPos).setValue(this.singleShortUUIDList.get(this.iterPos));
                    continue;
                }
                this.currentRow.getColumn(colPos).setValue(shortUUIDs[-listPos - 1]);
            }
            ++this.iterPos;
            return this.currentRow;
        }
        return null;
    }

    @Override
    public void markAsTopResultSet() {
    }

    @Override
    public int getPointOfAttachment() {
        return -1;
    }

    @Override
    public int getScanIsolationLevel() {
        return 1;
    }

    @Override
    public void setTargetResultSet(TargetResultSet trs) {
    }

    @Override
    public void setNeedsRowLocation(boolean needsRowLocation) {
    }

    @Override
    public double getEstimatedRowCount() {
        return 0.0;
    }

    @Override
    public int resultSetNumber() {
        return 0;
    }

    @Override
    public void setCurrentRow(ExecRow row) {
        SanityManager.THROWASSERT((String)("setCurrentRow() not expected to be called for " + this.getClass().getName()));
    }

    @Override
    public void clearCurrentRow() {
        for (int pos = 1; pos <= this.currentRow.nColumns(); ++pos) {
            this.currentRow.getColumn(pos).restoreToNull();
        }
    }

    public ExecRow getCurrentRow() throws StandardException {
        SanityManager.ASSERT((boolean)this.isOpen, (String)"resultSet expected to be open");
        return this.currentRow;
    }

    public RowLocation getRowLocation() {
        SanityManager.THROWASSERT((String)("getRowLocation() not expected to be called for " + this.getClass().getName()));
        return null;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        this.isOpen = false;
    }

    @Override
    public void setGfKeysForNCJoin(ArrayList<DataValueDescriptor> keys) throws StandardException {
        throw StandardException.newException("0A000.S", " Currently this method is not implemented or overridden for class " + this.getClass().getSimpleName());
    }

    @Override
    public boolean returnsRows() {
        return true;
    }

    @Override
    public int modifiedRowCount() {
        return 0;
    }

    @Override
    public void open() throws StandardException {
        this.openCore();
    }

    @Override
    public ExecRow getAbsoluteRow(int row) throws StandardException {
        SanityManager.THROWASSERT((String)("getAbsoluteRow() not expected to be called for " + this.getClass().getName()));
        return null;
    }

    @Override
    public ExecRow getRelativeRow(int row) throws StandardException {
        SanityManager.THROWASSERT((String)("getRelativeRow() not expected to be called for " + this.getClass().getName()));
        return null;
    }

    @Override
    public ExecRow setBeforeFirstRow() throws StandardException {
        SanityManager.THROWASSERT((String)("setBeforeFirstRow() not expected to be called for " + this.getClass().getName()));
        return null;
    }

    @Override
    public ExecRow getFirstRow() throws StandardException {
        SanityManager.THROWASSERT((String)("getFirstRow() not expected to be called for " + this.getClass().getName()));
        return null;
    }

    @Override
    public ExecRow getNextRow() throws StandardException {
        return this.getNextRowCore();
    }

    @Override
    public ExecRow getPreviousRow() throws StandardException {
        SanityManager.THROWASSERT((String)("getPreviousRow() not expected to be called for " + this.getClass().getName()));
        return null;
    }

    @Override
    public ExecRow getLastRow() throws StandardException {
        SanityManager.THROWASSERT((String)("getLastRow() not expected to be called for " + this.getClass().getName()));
        return null;
    }

    @Override
    public ExecRow setAfterLastRow() throws StandardException {
        SanityManager.THROWASSERT((String)("getLastRow() not expected to be called for " + this.getClass().getName()));
        return null;
    }

    @Override
    public boolean checkRowPosition(int isType) {
        return false;
    }

    @Override
    public int getRowNumber() {
        return 0;
    }

    @Override
    public void cleanUp(boolean cleanupOnError) throws StandardException {
        this.close(cleanupOnError);
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen;
    }

    @Override
    public void finish() throws StandardException {
        this.close(false);
    }

    @Override
    public long getExecuteTime() {
        return 0L;
    }

    @Override
    public ResultSet getAutoGeneratedKeysResultset() {
        return null;
    }

    @Override
    public Timestamp getBeginExecutionTimestamp() {
        return null;
    }

    @Override
    public Timestamp getEndExecutionTimestamp() {
        return null;
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        return 0L;
    }

    @Override
    public NoPutResultSet[] getSubqueryTrackingArray(int numSubqueries) {
        return null;
    }

    @Override
    public String getCursorName() {
        return null;
    }

    @Override
    public boolean requiresRelocking() {
        SanityManager.THROWASSERT((String)("requiresRelocking() not expected to be called for " + this.getClass().getName()));
        return false;
    }

    @Override
    public ExecRow getNextRowFromRowSource() throws StandardException {
        return null;
    }

    @Override
    public boolean needsToClone() {
        return false;
    }

    @Override
    public FormatableBitSet getValidColumns() {
        return null;
    }

    @Override
    public void closeRowSource() {
    }

    @Override
    public boolean needsRowLocation() {
        return false;
    }

    @Override
    public void rowLocation(RowLocation rl) throws StandardException {
    }

    @Override
    public void positionScanAtRowLocation(RowLocation rl) throws StandardException {
    }

    @Override
    public boolean isForUpdate() {
        return false;
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void updateRow(ExecRow row) throws StandardException {
    }

    @Override
    public void deleteRowDirectly() throws StandardException {
        SanityManager.THROWASSERT((String)("deleteRowDirectly() not expected to be called for " + this.getClass().getName()));
    }

    @Override
    public void markRowAsDeleted() throws StandardException {
    }

    @Override
    public final Activation getActivation() {
        return this.activation;
    }

    @Override
    public final boolean canUpdateInPlace() {
        return false;
    }

    @Override
    public TXState initLocalTXState() {
        SanityManager.THROWASSERT((String)("initLocalTXState() not expected to be called for " + this.getClass().getName()));
        return null;
    }

    @Override
    public void upgradeReadLockToWrite(RowLocation rl, GemFireContainer container) throws StandardException {
        SanityManager.THROWASSERT((String)("upgradeReadLockToWrite() not expected to be called for " + this.getClass().getName()));
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        SanityManager.THROWASSERT((String)("updateRowLocationPostRead() not expected to be called for " + this.getClass().getName()));
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
        SanityManager.THROWASSERT((String)("filteredRowLocationPostRead() not expected to be called for " + this.getClass().getName()));
    }

    @Override
    public boolean supportsMoveToNextKey() {
        return false;
    }

    @Override
    public int getScanKeyGroupID() {
        throw new UnsupportedOperationException("not expected to be invoked");
    }

    @Override
    public boolean hasAutoGeneratedKeysResultSet() {
        return false;
    }

    @Override
    public void flushBatch() {
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        SanityManager.THROWASSERT((String)("accept() not expected to be called for " + this.getClass().getName()));
    }

    @Override
    public UUID getExecutionPlanID() {
        SanityManager.THROWASSERT((String)("getExecutionPlanID() not expected to be called for " + this.getClass().getName()));
        return null;
    }

    @Override
    public void markLocallyExecuted() {
    }

    @Override
    public void resetStatistics() {
    }

    @Override
    public boolean isDistributedResultSet() {
        return false;
    }

    @Override
    public boolean addLockReference(GemFireTransaction tran) {
        return false;
    }

    @Override
    public boolean releaseLocks(GemFireTransaction tran) {
        return false;
    }

    @Override
    public void closeBatch() throws StandardException {
    }

    @Override
    public RowLocation fetch(RowLocation loc, ExecRow destRow, FormatableBitSet validColumns, boolean faultIn, GemFireContainer container) throws StandardException {
        return RowUtil.fetch(loc, destRow, validColumns, faultIn, container, null, null, 0, null);
    }

    @Override
    public PlanUtils.Context getNewPlanContext() {
        return new PlanUtils.Context();
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        PlanUtils.xmlBeginTag(builder, context, this);
        PlanUtils.xmlTermTag(builder, context, "AUTO-GEN-KEYS");
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    @Override
    public void releasePreviousByteSource() {
    }

    @Override
    public void setMaxSortingLimit(long limit) {
    }

    @Override
    public void checkCancellationFlag() throws StandardException {
        Activation act = this.activation;
        if (act != null && act.isQueryCancelled()) {
            act.checkCancellationFlag();
        }
    }

    @Override
    public void forceReOpenCore() throws StandardException {
    }
}

