/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.catalog;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.diag.SortedCSVProcedures;
import com.pivotal.gemfirexd.internal.engine.distributed.message.GfxdFunctionMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.SystemColumnImpl;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINTableDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;

public final class XPLAINDistPropsDescriptor
extends XPLAINTableDescriptor {
    private UUID dist_rs_id;
    private UUID stmt_rs_id;
    private UUID parent_rs_id = null;
    private XPLAINUtil.DIRECTION dist_direction;
    private short dist_level;
    private String dist_object_type;
    private String dist_object_name;
    private String originator;
    private String routing_objects;
    private int no_routing_objects;
    private String pruned_member_list;
    private int no_pruned_member_list;
    private String pruned_server_groups;
    private String prep_stmt_aware_members;
    private String message_flags;
    private String parameter_valueset;
    private short query_retry_count;
    private short member_mapping_retry_count;
    private long routing_object_compute_time;
    private Timestamp begin_scatter_time;
    private long member_mapping_time;
    private long[] replySingleResultStatistics;
    private long scatter_time;
    private InternalDistributedMember target_member;
    private Timestamp construct_time;
    private long ser_deser_time;
    private long process_time;
    private long throttle_time;
    private long local_dataset_size;
    private Timestamp begin_receive_time;
    public List<XPLAINDistPropsDescriptor> memberSentMappedDesc = Collections.emptyList();
    public List<XPLAINDistPropsDescriptor> memberReplyMappedDesc = Collections.emptyList();
    public boolean locallyExecuted;
    static final String TABLENAME_STRING = "SYSXPLAIN_DIST_PROPS";
    public Object replySingleResult;

    public XPLAINDistPropsDescriptor() {
    }

    public XPLAINDistPropsDescriptor(UUID dist_rs_id, UUID stmt_rs_id, XPLAINUtil.DIRECTION dist_direction, short dist_level, String dist_object_type, String originator, Set<Object> routingKeys, long routing_object_compute_time, Set<DistributedMember> prepStmtAwareMembers, ParameterValueSet parameter_valueset) {
        this.dist_rs_id = dist_rs_id;
        this.stmt_rs_id = stmt_rs_id;
        this.parent_rs_id = null;
        this.dist_direction = dist_direction;
        this.dist_level = dist_level;
        this.dist_object_type = dist_object_type;
        this.originator = originator;
        if (routingKeys != null) {
            this.no_routing_objects = routingKeys.size();
            this.routing_objects = this.no_routing_objects > 0 ? SharedUtils.toCSV(routingKeys) : null;
        }
        this.routing_object_compute_time = routing_object_compute_time;
        this.prep_stmt_aware_members = SharedUtils.toCSV(prepStmtAwareMembers);
        this.parameter_valueset = parameter_valueset.toString();
    }

    public XPLAINDistPropsDescriptor(int insert_order, UUID dist_rs_id, UUID stmt_rs_id, UUID parent_rs_id, XPLAINUtil.DIRECTION dist_direction, short dist_level, String dist_object_type, String dist_object_name, String originator, Set<Object> routingKeys, InternalDistributedMember[] pruned_members, Set<String> prepStmtAwareMembers, String messageflags, ParameterValueSet parameter_valueset, short query_retry_count, short member_mapping_retry_count, long routing_object_compute_time, Timestamp begin_scatter_time, long member_mapping_time, long distribution_time, String msg_target_member, Timestamp msg_construct_time, long msg_ser_deser_time, long msg_process_time, int local_dataset_size, Timestamp begin_receive_time) {
        this.dist_rs_id = dist_rs_id;
        this.stmt_rs_id = stmt_rs_id;
        this.parent_rs_id = parent_rs_id;
        this.dist_direction = dist_direction;
        this.dist_level = dist_level;
        this.dist_object_type = dist_object_type;
        this.dist_object_name = dist_object_name;
        this.originator = originator;
        this.routing_objects = routingKeys != null && routingKeys.size() > 0 ? SharedUtils.toCSV(routingKeys) : null;
        this.no_routing_objects = routingKeys.size();
        this.routing_object_compute_time = routing_object_compute_time;
        this.pruned_member_list = GemFireXDUtils.toCSV(pruned_members);
        this.no_pruned_member_list = pruned_members.length;
        this.pruned_server_groups = this.getParticipatingServerGroups(pruned_members);
        this.prep_stmt_aware_members = SharedUtils.toCSV(prepStmtAwareMembers);
        this.parameter_valueset = parameter_valueset.toString();
        this.query_retry_count = query_retry_count;
    }

    public XPLAINDistPropsDescriptor(UUID dist_rs_id, UUID stmt_rs_id, UUID parent_rs_id, XPLAINUtil.DIRECTION dist_direction, short dist_level, String dist_object_type, String originator) {
        this.dist_rs_id = dist_rs_id;
        this.stmt_rs_id = stmt_rs_id;
        this.parent_rs_id = parent_rs_id;
        this.dist_direction = dist_direction;
        this.dist_level = dist_level;
        this.dist_object_type = dist_object_type;
        this.originator = originator;
    }

    private String getParticipatingServerGroups(InternalDistributedMember[] members) {
        String s = null;
        for (InternalDistributedMember m : members) {
            SortedSet<String> g = ServerGroupUtils.getServerGroups((DistributedMember)m);
            s = s == null ? SharedUtils.toCSV(g) : SortedCSVProcedures.groupsIntersection(s, SharedUtils.toCSV(g));
        }
        return s;
    }

    public void setStatementParameters(PreparedStatement ps) throws SQLException {
        int pi = 0;
        ps.setString(++pi, this.dist_rs_id.toString());
        ps.setString(++pi, this.stmt_rs_id.toString());
        ps.setString(++pi, this.parent_rs_id != null ? this.parent_rs_id.toString() : null);
        ps.setString(++pi, this.dist_direction.name());
        ps.setShort(++pi, this.dist_level);
        ps.setString(++pi, this.dist_object_type);
        ps.setString(++pi, this.dist_object_name);
        ps.setString(++pi, this.originator);
        if (this.routing_objects != null) {
            ps.setString(++pi, this.routing_objects);
            ps.setInt(++pi, this.no_routing_objects);
        } else {
            ps.setNull(++pi, 12);
            ps.setNull(++pi, 4);
        }
        if (this.pruned_member_list != null) {
            ps.setString(++pi, this.pruned_member_list);
            ps.setInt(++pi, this.no_pruned_member_list);
        } else {
            ps.setNull(++pi, 12);
            ps.setNull(++pi, 4);
        }
        ps.setString(++pi, this.pruned_server_groups);
        ps.setString(++pi, this.prep_stmt_aware_members);
        ps.setString(++pi, this.message_flags);
        ps.setString(++pi, this.parameter_valueset);
        ps.setShort(++pi, this.query_retry_count);
        ps.setShort(++pi, this.member_mapping_retry_count);
        ps.setLong(++pi, this.routing_object_compute_time);
        ps.setTimestamp(++pi, this.begin_scatter_time);
        ps.setLong(++pi, this.member_mapping_time);
        ps.setLong(++pi, this.scatter_time);
        ps.setString(++pi, this.target_member != null ? this.target_member.toString() : null);
        ps.setTimestamp(++pi, this.construct_time);
        ps.setLong(++pi, this.ser_deser_time);
        ps.setLong(++pi, this.process_time);
        ps.setLong(++pi, this.throttle_time);
        ps.setLong(++pi, this.local_dataset_size);
        ps.setTimestamp(++pi, this.begin_receive_time);
    }

    @Override
    protected void addConstraints(StringBuilder sb) {
    }

    @Override
    protected SystemColumn[] buildColumnList() {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("DIST_RS_ID", false), SystemColumnImpl.getUUIDColumn("STMT_RS_ID", false), SystemColumnImpl.getUUIDColumn("PARENT_DIST_RS_ID", true), SystemColumnImpl.getColumn("DIST_DIRECTION", 1, false, 7), SystemColumnImpl.getColumn("DIST_LEVEL", 5, false), SystemColumnImpl.getColumn("DIST_OBJECT_TYPE", 12, false, 32), SystemColumnImpl.getColumn("DIST_OBJECT_NAME", 12, false, 128), SystemColumnImpl.getColumn("ORIGINATOR", 12, false, 128), SystemColumnImpl.getColumn("ROUTING_OBJECTS", 12, true, 32672), SystemColumnImpl.getColumn("NO_ROUTING_OBJECTS", 4, true), SystemColumnImpl.getColumn("PRUNED_MEMBERS_LIST", 12, true, 32672), SystemColumnImpl.getColumn("NO_PRUNED_MEMBERS", 4, true), SystemColumnImpl.getColumn("PRUNED_SERVER_GROUPS_LIST", 12, true, 32672), SystemColumnImpl.getColumn("PREP_STMT_AWARE_MEMBERS", 12, true, 32672), SystemColumnImpl.getColumn("MESSAGE_FLAGS", 12, true, 32672), SystemColumnImpl.getColumn("PARAMETER_VALUES", 12, true, 32672), SystemColumnImpl.getColumn("QUERY_RETRY_COUNT", 5, true), SystemColumnImpl.getColumn("MEMBER_MAPPING_RETRY_COUNT", 5, true), SystemColumnImpl.getColumn("ROUTING_OBJECT_COMPUTE_TIME", -5, true), SystemColumnImpl.getColumn("BEGIN_SCATTER_TIME", 93, false), SystemColumnImpl.getColumn("MEMBER_MAPPING_TIME", -5, true), SystemColumnImpl.getColumn("SCATTER_TIME", -5, false), SystemColumnImpl.getColumn("TARGET_MEMBER", 12, true, 32672), SystemColumnImpl.getColumn("CONSTRUCT_TIME", 93, true), SystemColumnImpl.getColumn("SER_DESER_TIME", -5, true), SystemColumnImpl.getColumn("PROCESS_TIME", -5, true), SystemColumnImpl.getColumn("THROTTLE_TIME", -5, true), SystemColumnImpl.getColumn("LOCAL_DATASET_SIZE", 4, true), SystemColumnImpl.getColumn("BEGIN_RECEIVE_TIME", 93, false)};
    }

    @Override
    public final String getCatalogName() {
        return TABLENAME_STRING;
    }

    public String toString() {
        return "DistProps@" + System.identityHashCode(this) + " STMT_ID=" + this.stmt_rs_id + " DIST_ID=" + this.dist_rs_id + " DIST_LEVEL=" + this.dist_level + " OBJECT_TYPE=" + this.dist_object_type + " PROCESS_TIME=" + this.process_time + " SER_DESER_TIME=" + this.ser_deser_time + " THROTTLE_TIME=" + this.throttle_time;
    }

    public final void setDistRSID(UUID dist_rs_id) {
        this.dist_rs_id = dist_rs_id;
    }

    public final UUID getRSID() {
        return this.dist_rs_id;
    }

    public final String getDistObjectType() {
        return this.dist_object_type;
    }

    public final void setDistObjectName(String dist_object_name) {
        this.dist_object_name = dist_object_name;
    }

    public final String getDistObjectName() {
        return this.dist_object_name;
    }

    public final void setPrunedMembers(InternalDistributedMember[] pruned_members) {
        this.pruned_member_list = GemFireXDUtils.toCSV(pruned_members);
        this.no_pruned_member_list = pruned_members.length;
        this.pruned_server_groups = this.getParticipatingServerGroups(pruned_members);
    }

    public final void setMessageFlags(String message_flags) {
        this.message_flags = message_flags;
    }

    public final String getMessageFlags() {
        return this.message_flags;
    }

    public final void setQueryRetryCount(short query_retry_count) {
        this.query_retry_count = query_retry_count;
    }

    public final void setBeginScatterTime(Timestamp begin_scatter_time) {
        this.begin_scatter_time = begin_scatter_time;
    }

    public final Timestamp getBeginScatterTime() {
        return this.begin_scatter_time;
    }

    private XPLAINDistPropsDescriptor cloneMe() {
        XPLAINDistPropsDescriptor r = new XPLAINDistPropsDescriptor();
        r.dist_rs_id = null;
        r.stmt_rs_id = this.stmt_rs_id;
        r.parent_rs_id = this.dist_rs_id;
        r.dist_direction = this.dist_direction;
        r.dist_level = this.dist_level;
        r.originator = this.originator;
        return r;
    }

    public final <T> void processMemberSentMessages(ArrayList<GfxdFunctionMessage<T>> membersMsgsSent, GfxdFunctionMessage<T> rootMsg) {
        if (membersMsgsSent == null) {
            return;
        }
        if (this.memberSentMappedDesc == Collections.EMPTY_LIST) {
            this.memberSentMappedDesc = new ArrayList<XPLAINDistPropsDescriptor>();
        }
        long scatter_time = 0L;
        for (GfxdFunctionMessage<T> m : membersMsgsSent) {
            XPLAINDistPropsDescriptor msg = this.cloneMe();
            msg.dist_object_type = "QUERY-SEND";
            msg.dist_object_name = m.getClass().getSimpleName();
            msg.locallyExecuted = m.isLocallyExecuted();
            msg.originator = m.getSender() != null ? m.getSender().toString() : "SELF";
            msg.target_member = msg.getRecipients((DistributionMessage)m, false)[0];
            msg.construct_time = m.getConstructTime();
            msg.ser_deser_time = m.getSerializeDeSerializeTime();
            msg.process_time = m == rootMsg ? m.getRootMessageSendTime() : m.getProcessTime();
            msg.throttle_time = 0L;
            scatter_time += msg.process_time;
            if (msg.construct_time != null && msg.process_time == 0L && msg.ser_deser_time == 0L && msg.throttle_time == 0L) {
                msg.process_time = 1L;
            }
            this.memberSentMappedDesc.add(msg);
        }
        this.scatter_time = scatter_time + this.member_mapping_time;
    }

    public final void processMemberReplyMessages(List<GfxdFunctionMessage.GfxdFunctionReplyMessage> replyMsgs) {
        if (replyMsgs == null) {
            return;
        }
        Timestamp begin_receive_time = null;
        if (this.memberReplyMappedDesc == Collections.EMPTY_LIST) {
            this.memberReplyMappedDesc = new ArrayList<XPLAINDistPropsDescriptor>();
        }
        GemFireCacheImpl c = Misc.getGemFireCacheNoThrow();
        for (GfxdFunctionMessage.GfxdFunctionReplyMessage r : replyMsgs) {
            XPLAINDistPropsDescriptor msg = this.cloneMe();
            Timestamp ct = r.getConstructTime();
            if (begin_receive_time == null || begin_receive_time.before(ct)) {
                begin_receive_time = ct;
            }
            msg.flipdirection();
            if (msg.dist_direction == XPLAINUtil.DIRECTION.IN) {
                msg.dist_object_type = "RESULT-RECEIVE";
                msg.originator = r.getSender().toString();
                msg.target_member = c.getDistributedSystem().getDistributedMember();
            } else {
                msg.dist_object_type = "RESULT-SEND";
                msg.originator = c.getDistributedSystem().getDistributedMember().toString();
                msg.target_member = msg.getRecipients((DistributionMessage)r, false)[0];
            }
            msg.dist_object_name = r.getClass().getSimpleName();
            msg.construct_time = r.getConstructTime();
            msg.ser_deser_time = r.getSerializeDeSerializeTime();
            msg.process_time = r.getProcessTime();
            msg.throttle_time = 0L;
            msg.replySingleResult = r.getSingleResult();
            msg.replySingleResultStatistics = r.getSingleResultStatistics();
            if (msg.construct_time != null && msg.process_time == 0L && msg.ser_deser_time == 0L && msg.throttle_time == 0L) {
                msg.process_time = 1L;
            }
            this.memberReplyMappedDesc.add(msg);
        }
        this.setBeginReceiveTime(begin_receive_time);
    }

    private final void flipdirection() {
        switch (this.dist_direction) {
            case IN: {
                this.dist_direction = XPLAINUtil.DIRECTION.OUT;
                break;
            }
            case OUT: {
                this.dist_direction = XPLAINUtil.DIRECTION.IN;
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)"distribution direction not handled");
            }
        }
    }

    public final void setSerDeSerTime(long ser_deser_time) {
        this.ser_deser_time = ser_deser_time;
    }

    public final void setThrottleTime(long throttle_time) {
        this.throttle_time = throttle_time;
    }

    public final void setLocalDatasetSize(long local_dataset_size) {
        this.local_dataset_size = local_dataset_size;
    }

    public final long getLocalDatasetSize() {
        return this.local_dataset_size;
    }

    public final void setBeginReceiveTime(Timestamp begin_receive_time) {
        this.begin_receive_time = begin_receive_time;
    }

    public final Timestamp getBeginReceiveTime() {
        return this.begin_receive_time;
    }

    public final void setProcessTime(Long process_time) {
        this.process_time = process_time;
    }

    public final long getProcessTime() {
        return this.process_time;
    }

    public final long getSerDeSerTime() {
        return this.ser_deser_time;
    }

    public final long getThrottleTime() {
        return this.throttle_time;
    }

    public final void setMemberMappingRetryCount(short mapping_retry_count) {
        this.member_mapping_retry_count = mapping_retry_count;
    }

    public final void setMemberMappingTime(long member_mapping_time) {
        this.member_mapping_time = member_mapping_time;
    }

    public final String getOriginator() {
        return this.originator;
    }

    public final String getTargetMember() {
        return this.target_member.toString();
    }

    public String getPrunedMemberList() {
        return this.pruned_member_list;
    }

    public long getExecuteTime() {
        return this.ser_deser_time + this.process_time + this.throttle_time;
    }

    public long[] getReplySingleResultStatistics() {
        return this.replySingleResultStatistics;
    }

    @Override
    protected void createIndex(StringBuilder idx, String schemaName) {
        idx.append("create index ").append(schemaName).append(".idx_dist_dist_rs_id on ").append(TABLENAME_STRING).append("(dist_rs_id)");
    }

    public InternalDistributedMember[] getRecipients(DistributionMessage m, boolean getAll) {
        InternalDistributedMember[] recipients;
        if (getAll) {
            int numMembers = this.memberSentMappedDesc.size();
            recipients = new InternalDistributedMember[numMembers];
            for (int i = numMembers - 1; i >= 0; --i) {
                recipients[i] = this.memberSentMappedDesc.get((int)i).target_member;
            }
        } else {
            Object[] mlist = m.getRecipients();
            if (m instanceof GfxdFunctionMessage.GfxdFunctionReplyMessage && (mlist != null && mlist.length > 0 && mlist[0] == null || mlist.length == 0)) {
                recipients = new InternalDistributedMember[]{Misc.getGemFireCache().getMyId()};
            } else if (mlist != null && mlist.length == 1 && mlist[0] != DistributionMessage.ALL_RECIPIENTS) {
                recipients = mlist;
            } else {
                if (!this.locallyExecuted) {
                    SanityManager.THROWASSERT((String)("Only one member is expected as target per message. ALL_RECIPIENTS will already get enumerated at this stage to individual specific member. msg=" + m + " mlist=" + Arrays.toString(mlist)));
                }
                recipients = new InternalDistributedMember[]{Misc.getGemFireCache().getMyId()};
            }
        }
        return recipients;
    }
}

