/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.management.impl;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.AbstractRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.diag.MemoryAnalyticsVTI;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.management.TableMXBean;
import com.pivotal.gemfirexd.internal.engine.management.impl.Cleanable;
import com.pivotal.gemfirexd.internal.engine.management.impl.InternalManagementService;
import com.pivotal.gemfirexd.internal.engine.management.impl.ManagementUtils;
import com.pivotal.gemfirexd.internal.engine.management.impl.TableMBeanDataUpdater;
import com.pivotal.gemfirexd.internal.engine.management.impl.Updatable;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import javax.management.openmbean.TabularData;

public class TableMBeanBridge
implements Cleanable,
Updatable<TableMBeanBridge> {
    private String tableName;
    private String parentSchema;
    private List<String> definition;
    private String partitioningScheme;
    private GemFireContainer container;
    private InternalManagementService.ConnectionWrapperHolder connectionWrapperHolder;
    private MemoryAnalyticsData memoryAnalytics;
    private TableStatsData tableStatsData;
    private TableMXBean.TableMetadata tableMetadata;
    private LogWriter logWriter;
    private int updateToken;
    private PreparedStatement metadataStatement;
    private PreparedStatement indexInfoStatement;
    private MemoryAnalyticsVTI indexMemAnalVTI;
    private static final int INDEX_NAME_INDEX = 3;
    private static final int INDEX_TYPE_INDEX = 7;
    private static final int INDEX_COLUMNS_INDEX = 4;
    private static final int INDEX_UNIQUE_INDEX = 5;

    public TableMBeanBridge(GemFireContainer container, InternalManagementService.ConnectionWrapperHolder connectionHolder) {
        this(container, connectionHolder, new ArrayList<String>());
    }

    public TableMBeanBridge(GemFireContainer container, InternalManagementService.ConnectionWrapperHolder connectionHolder, List<String> definition) {
        this.container = container;
        this.tableName = this.container.getTableName();
        this.parentSchema = this.container.getSchemaName();
        this.definition = definition;
        this.connectionWrapperHolder = connectionHolder;
        this.tableMetadata = ManagementUtils.TABLE_METADATA_NA;
        this.logWriter = Misc.getCacheLogWriter();
        this.partitioningScheme = "NA";
        GfxdPartitionResolver resolver = GemFireXDUtils.getResolver((AbstractRegion)this.container.getRegion());
        if (resolver != null) {
            this.partitioningScheme = resolver.getDDLString();
        }
        this.memoryAnalytics = new MemoryAnalyticsData(0.0, 0.0, 0L);
        this.tableStatsData = new TableStatsData(this.container.getRegion().getName(), resolver != null);
        this.indexMemAnalVTI = new MemoryAnalyticsVTI(true);
    }

    public String getName() {
        return this.tableName;
    }

    public String getParentSchema() {
        return this.parentSchema;
    }

    String getFullName() {
        return this.getParentSchema() + "." + this.getName();
    }

    public String[] getServerGroups() {
        SortedSet<String> serverGroups = ServerGroupUtils.getServerGroupsFromContainer(this.container);
        return serverGroups.toArray(ManagementUtils.EMPTY_STRING_ARRAY);
    }

    public List<String> getDefinition() {
        return this.definition;
    }

    public int getInserts() {
        return this.tableStatsData.getInserts();
    }

    public int getUpdates() {
        return this.tableStatsData.getUpdates();
    }

    public int getDeletes() {
        return this.tableStatsData.getDeletes();
    }

    public double getEntrySize() {
        return this.memoryAnalytics.getEntrySize();
    }

    public double getKeySize() {
        return this.memoryAnalytics.getKeySize();
    }

    public String getPolicy() {
        return this.container.getRegionAttributes().getDataPolicy().toString();
    }

    public String getPartitioningScheme() {
        return this.partitioningScheme;
    }

    public String getColocationScheme() {
        return String.valueOf(this.container.getRegionAttributes().getPartitionAttributes());
    }

    public String getPersistenceScheme() {
        return null;
    }

    public TableMXBean.TableMetadata fetchMetadata() {
        try {
            return this.retrieveMetadata();
        }
        catch (SQLException e) {
            this.logWriter.info("Error occurred while fetching MetaData for " + this.getFullName() + ". Reason: " + e.getMessage());
            if (this.logWriter.fineEnabled()) {
                this.logWriter.fine((Throwable)e);
            }
            return ManagementUtils.TABLE_METADATA_NA;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TableMXBean.TableMetadata retrieveMetadata() throws SQLException {
        if (this.connectionWrapperHolder.hasConnection()) {
            if (this.metadataStatement == null) {
                this.metadataStatement = this.connectionWrapperHolder.getConnection().prepareStatement("<local>SELECT * FROM SYS.SYSTABLES WHERE TABLENAME=? and TABLESCHEMANAME=?");
                this.metadataStatement.setString(1, this.getName());
                this.metadataStatement.setString(2, this.getParentSchema());
            }
            try (ResultSet resultSet = this.metadataStatement.executeQuery();){
                if (!resultSet.next()) return this.tableMetadata;
                if (this.tableMetadata == null || this.tableMetadata == ManagementUtils.TABLE_METADATA_NA) {
                    this.tableMetadata = new TableMXBean.TableMetadata(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getString(5), resultSet.getString(6), resultSet.getString(7), resultSet.getString(8), resultSet.getString(9), resultSet.getString(10), resultSet.getString(11), resultSet.getString(12), resultSet.getString(13), resultSet.getString(14), resultSet.getString(15), resultSet.getString(16), resultSet.getString(17), resultSet.getString(18), resultSet.getString(19), resultSet.getString(20));
                    return this.tableMetadata;
                }
                this.tableMetadata.update(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getString(5), resultSet.getString(6), resultSet.getString(7), resultSet.getString(8), resultSet.getString(9), resultSet.getString(10), resultSet.getString(11), resultSet.getString(12), resultSet.getString(13), resultSet.getString(14), resultSet.getString(15), resultSet.getString(16), resultSet.getString(17), resultSet.getString(18), resultSet.getString(19), resultSet.getString(20));
                return this.tableMetadata;
            }
        } else {
            this.tableMetadata = ManagementUtils.TABLE_METADATA_NA;
        }
        return this.tableMetadata;
    }

    public TabularData showDiskAttributes() {
        return null;
    }

    public MemoryAnalyticsData getMemoryAnalytics() {
        return this.memoryAnalytics;
    }

    public IndexStatsData[] listIndexStats() {
        List<IndexStatsData> indexStatsList = this.buildIndexStats();
        if (indexStatsList != null && !indexStatsList.isEmpty()) {
            return indexStatsList.toArray(new IndexStatsData[0]);
        }
        return new IndexStatsData[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<IndexStatsData> buildIndexStats() {
        ArrayList<IndexStatsData> indexInfoList = new ArrayList<IndexStatsData>();
        try {
            TableMBeanDataUpdater.MemoryAnalyticsHolder memHolder = new TableMBeanDataUpdater.MemoryAnalyticsHolder(this.indexMemAnalVTI);
            this.indexMemAnalVTI.setContainer(this.container);
            memHolder.init();
            while (true) {
                if (!this.indexMemAnalVTI.next()) {
                    return indexInfoList;
                }
                String indexName = this.indexMemAnalVTI.getString(memHolder.indexNameIndex);
                String indexType = this.indexMemAnalVTI.getString(memHolder.indexTypeIndex);
                if (indexName == null) continue;
                IndexStatsData indexInfoData = new IndexStatsData(indexName, indexType, Double.parseDouble(this.indexMemAnalVTI.getString(memHolder.entrySizeIndex)), Double.parseDouble(this.indexMemAnalVTI.getString(memHolder.keySizeIndex)), this.indexMemAnalVTI.getLong(memHolder.numRowsIndex));
                indexInfoList.add(indexInfoData);
            }
        }
        catch (NumberFormatException e) {
            this.logWriter.warning((Throwable)e);
            return indexInfoList;
        }
        catch (SQLException e) {
            Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(null);
            this.logWriter.warning((Throwable)e);
            return indexInfoList;
        }
        catch (Exception e) {
            this.logWriter.warning((Throwable)e);
            return indexInfoList;
        }
    }

    public IndexInfoData[] listIndexInfo() {
        try {
            return this.retrieveIndexInfo();
        }
        catch (SQLException e) {
            this.logWriter.info("Error occurred while fetching index for " + this.getFullName() + ". Reason: " + e.getMessage());
            if (this.logWriter.fineEnabled()) {
                this.logWriter.fine((Throwable)e);
            }
            return new IndexInfoData[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized IndexInfoData[] retrieveIndexInfo() throws SQLException {
        if (this.connectionWrapperHolder.hasConnection()) {
            if (this.indexInfoStatement == null) {
                this.indexInfoStatement = this.connectionWrapperHolder.getConnection().prepareStatement("<local>SELECT * FROM SYS.INDEXES WHERE TABLENAME=? and SCHEMANAME=?");
                this.indexInfoStatement.setString(1, this.getName());
                this.indexInfoStatement.setString(2, this.getParentSchema());
            }
            ArrayList<IndexInfoData> list = new ArrayList<IndexInfoData>();
            try (ResultSet resultSet = this.indexInfoStatement.executeQuery();){
                while (resultSet.next()) {
                    list.add(new IndexInfoData(resultSet.getString(3), resultSet.getString(7), resultSet.getString(4), resultSet.getString(5)));
                }
            }
            return list.toArray(new IndexInfoData[0]);
        }
        return null;
    }

    public int getUpdateToken() {
        return this.updateToken;
    }

    @Override
    public void setUpdateToken(int updateToken) {
        this.updateToken = updateToken;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parentSchema == null ? 0 : this.parentSchema.hashCode());
        result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableMBeanBridge other = (TableMBeanBridge)obj;
        if (this.parentSchema == null ? other.parentSchema != null : !this.parentSchema.equals(other.parentSchema)) {
            return false;
        }
        return !(this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [");
        builder.append(this.parentSchema).append(".");
        builder.append(this.tableName);
        builder.append(", policy=").append(this.tableName).append("]");
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp() {
        block5: {
            try {
                if (this.metadataStatement == null || this.metadataStatement.isClosed()) break block5;
                try {
                    this.metadataStatement.cancel();
                }
                finally {
                    this.metadataStatement.close();
                }
            }
            catch (SQLException e) {
                if (!this.logWriter.fineEnabled()) break block5;
                this.logWriter.fine((Throwable)e);
            }
        }
        this.container = null;
        this.connectionWrapperHolder = null;
    }

    @Override
    public void update() {
        this.tableStatsData.update();
    }

    @Override
    public TableMBeanBridge getSelf() {
        return this;
    }

    public void setDefinition(List<String> newDefinition) {
        this.definition = newDefinition;
    }

    public LocalRegion getRegion() {
        return this.container.getRegion();
    }

    class TableStatsData {
        private String regionName;
        private boolean isPR;
        private String statsTxtId;
        private volatile int inserts;
        private volatile int updates;
        private volatile int deletes;

        TableStatsData(String regionName, boolean isPR) {
            this.regionName = regionName;
            this.isPR = isPR;
            this.statsTxtId = "RegionStats-" + (this.isPR ? "partition-" : "") + this.regionName;
            this.inserts = 0;
            this.updates = 0;
            this.deletes = 0;
        }

        public void update() {
            InternalDistributedSystem system;
            Statistics[] regionPerfStats;
            int i;
            GemFireCacheImpl cache = Misc.getGemFireCacheNoThrow();
            if (cache != null && (i = 0) < (regionPerfStats = (system = cache.getDistributedSystem()).findStatisticsByTextId(this.statsTxtId)).length) {
                this.inserts = regionPerfStats[i].get("creates").intValue();
                this.updates = regionPerfStats[i].get("puts").intValue();
                this.deletes = regionPerfStats[i].get("destroys").intValue();
            }
        }

        public int getInserts() {
            return this.inserts;
        }

        public int getUpdates() {
            if (!this.isPR) {
                return Math.abs(this.updates - this.inserts);
            }
            return this.updates;
        }

        public int getDeletes() {
            return this.deletes;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(TableStatsData.class.getSimpleName());
            builder.append(" [regionName=").append(this.regionName);
            builder.append(", inserts=").append(this.inserts);
            builder.append(", updates=").append(this.updates);
            builder.append(", deletes=").append(this.deletes);
            builder.append("]");
            return builder.toString();
        }
    }

    public static class IndexInfoData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        volatile String indexName;
        volatile String indexType;
        volatile String columnsAndOrder;
        volatile String unique;

        @ConstructorProperties(value={"indexName", "indexType", "columnsAndOrder", "unique"})
        public IndexInfoData(String indexName, String indexType, String columnsAndOrder, String unique) {
            this.indexName = indexName;
            this.indexType = indexType;
            this.columnsAndOrder = columnsAndOrder;
            this.unique = unique;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public String getIndexType() {
            return this.indexType;
        }

        public String getColumnsAndOrder() {
            return this.columnsAndOrder;
        }

        public void setColumnsAndOrder(String columnsAndOrder) {
            this.columnsAndOrder = columnsAndOrder;
        }

        public String getUnique() {
            return this.unique;
        }

        public void setUnique(String unique) {
            this.unique = unique;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(IndexInfoData.class.getSimpleName());
            builder.append("IndexInfoData [indexName=").append(this.indexName);
            builder.append(", indexType=").append(this.indexType);
            builder.append(", columnsAndOrder=").append(this.columnsAndOrder);
            builder.append(", unique=").append(this.unique);
            builder.append("]");
            return builder.toString();
        }
    }

    public static class IndexStatsData
    extends MemoryAnalyticsData
    implements Serializable {
        private static final long serialVersionUID = 7993411515378953750L;
        volatile String indexName;
        volatile String indexType;
        volatile int updateToken;

        @ConstructorProperties(value={"indexName", "indexType", "entrySize", "keySize", "rowCount"})
        public IndexStatsData(String indexName, String indexType, double entrySize, double keySize, long rowCount) {
            super(entrySize, keySize, rowCount);
            this.indexName = indexName;
            this.indexType = indexType;
        }

        public void updateIndexStatsData(String entrySize, String keySize, String entryCount) {
            super.updateMemoryAnalytics(entrySize, keySize, entryCount);
        }

        public void updateIndexStatsData(double entrySize, double keySize, long entryCount) {
            LogWriter logWriter = Misc.getCacheLogWriterNoThrow();
            logWriter.info("Updating new indexInfoData for " + this.indexName + " entrySize=" + entrySize + " keySize=" + keySize + " entryCount=" + entryCount);
            super.updateMemoryAnalytics(entrySize, keySize, entryCount);
        }

        public String getIndexName() {
            return this.indexName;
        }

        public String getIndexType() {
            return this.indexType;
        }

        int getUpdateToken() {
            return this.updateToken;
        }

        void setUpdateToken(int updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(IndexInfoData.class.getSimpleName());
            builder.append("IndexInfoData [indexName=").append(this.indexName);
            builder.append(", indexType=").append(this.indexType);
            builder.append(", entrySize=").append(this.entrySize);
            builder.append(", keySize=").append(this.keySize);
            builder.append(", rowCount=").append(this.rowCount);
            builder.append("]");
            return builder.toString();
        }
    }

    static class MemoryAnalyticsData
    implements Serializable {
        private static final long serialVersionUID = -5803260729108394342L;
        volatile double entrySize;
        volatile double keySize;
        volatile long rowCount;

        public MemoryAnalyticsData(double entrySize, double keySize, long rowCount) {
            this.entrySize = entrySize;
            this.keySize = keySize;
            this.rowCount = rowCount;
        }

        public void updateMemoryAnalytics(String entrySize, String keySize, String rowCount) {
            this.entrySize = Double.valueOf(entrySize);
            this.keySize = Double.valueOf(keySize);
            this.rowCount = Float.valueOf(rowCount).intValue();
        }

        public void updateMemoryAnalytics(double entrySize, double keySize, long rowCount) {
            this.entrySize = entrySize;
            this.keySize = keySize;
            this.rowCount = rowCount;
        }

        public double getEntrySize() {
            return this.entrySize;
        }

        public double getKeySize() {
            return this.keySize;
        }

        public long getRowCount() {
            return this.rowCount;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(MemoryAnalyticsData.class.getSimpleName());
            builder.append(" [entrySize=").append(this.entrySize);
            builder.append(", keySize=").append(this.keySize);
            builder.append(", rowCount=").append(this.rowCount);
            builder.append("]");
            return builder.toString();
        }
    }
}

