/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.management.impl;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.management.DiskBackupStatus;
import com.gemstone.gemfire.management.internal.FederationComponent;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.ManagementConstants;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.management.GfxdMemberMXBean;
import com.pivotal.gemfirexd.internal.engine.management.NetworkServerConnectionStats;
import com.pivotal.gemfirexd.internal.engine.management.NetworkServerNestedConnectionStats;
import com.pivotal.gemfirexd.internal.engine.management.TableMXBean;
import com.pivotal.gemfirexd.internal.engine.management.impl.AggregateMemberMBean;
import com.pivotal.gemfirexd.internal.engine.management.impl.AggregateTableMBean;
import com.pivotal.gemfirexd.internal.engine.management.impl.AggregateTableMBeanBridge;
import com.pivotal.gemfirexd.internal.engine.management.impl.GfxdMemberClusterStatsMonitor;
import com.pivotal.gemfirexd.internal.engine.management.impl.InternalManagementService;
import com.pivotal.gemfirexd.internal.engine.management.impl.ManagementUtils;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.Notification;
import javax.management.ObjectName;

public class GfxdDistributedSystemBridge {
    public SystemManagementService service = null;
    protected LogWriterI18n logger = InternalDistributedSystem.getLoggerI18n();
    private ObjectName thisMemberName;
    private List<String> tableList = Collections.synchronizedList(new ArrayList());
    private GfxdMemberClusterStatsMonitor gfxdMemberClusterStatsMonitor;
    private final Map<ObjectName, AggregateTableMBeanBridge> aggregateTableMBeanBridgeMap;
    private InternalManagementService.ConnectionWrapperHolder connectionWrapperHolder = null;
    private Map<ObjectName, Long> mbeanCounterMap = null;
    private Map<ObjectName, String> members = new ConcurrentHashMap<ObjectName, String>();
    private InternalDistributedMember thisMember;
    Lock lock = new ReentrantLock();

    public GfxdDistributedSystemBridge(SystemManagementService systemManagementService, InternalManagementService.ConnectionWrapperHolder connectionWrapHolder, InternalDistributedMember thisMember) {
        this.connectionWrapperHolder = connectionWrapHolder;
        this.service = systemManagementService;
        this.thisMember = thisMember;
        String memberNameOrId = MBeanJMXAdapter.getMemberNameOrId((DistributedMember)Misc.getGemFireCache().getDistributedSystem().getDistributedMember());
        this.thisMemberName = ManagementUtils.getMemberMBeanName(memberNameOrId, "DEFAULT");
        this.gfxdMemberClusterStatsMonitor = new GfxdMemberClusterStatsMonitor();
        this.aggregateTableMBeanBridgeMap = new HashMap<ObjectName, AggregateTableMBeanBridge>();
        this.mbeanCounterMap = Collections.synchronizedMap(new HashMap());
    }

    public static void addRegion(ObjectName objectName, Object proxyObject, FederationComponent newVal) {
    }

    public void addMemberToSystem(ObjectName objectName, Object proxyObject, FederationComponent newVal) {
        if (objectName.equals(this.thisMemberName)) {
            ObjectName distrObjectName = ManagementUtils.getClusterMBeanName();
            AggregateMemberMBean cluserMXBean = new AggregateMemberMBean(this);
            this.service.registerInternalMBean((Object)cluserMXBean, distrObjectName);
            this.members.put(objectName, this.thisMember.getId());
        } else {
            this.updateMember(objectName, newVal, null);
        }
    }

    public boolean removeMemberFromSystem(ObjectName objectName, GfxdMemberMXBean memberProxy, FederationComponent oldState) {
        if (this.thisMemberName.equals(objectName)) {
            ObjectName distrObjectName = ManagementUtils.getClusterMBeanName();
            this.service.unregisterMBean(distrObjectName);
            this.members.remove(objectName);
        } else {
            this.updateMember(objectName, null, oldState);
        }
        return false;
    }

    public void updateMember(ObjectName objectName, FederationComponent newVal, FederationComponent oldVal) {
        String name;
        if (oldVal != null && newVal == null) {
            this.members.remove(objectName);
        }
        if (oldVal == null && newVal != null && newVal.getValue("Id") != null && (name = (String)newVal.getValue("Id")) != null) {
            this.members.put(objectName, name);
        }
    }

    public String[] getMembers() {
        Iterator<String> memberIterator = this.members.values().iterator();
        HashSet<String> membersList = new HashSet<String>();
        while (memberIterator.hasNext()) {
            membersList.add(memberIterator.next());
        }
        String[] members = new String[membersList.size()];
        if (membersList.size() > 0) {
            return membersList.toArray(members);
        }
        return ManagementConstants.NO_DATA_STRING;
    }

    public void updateMemberDetails(FederationComponent newState, FederationComponent oldState) {
    }

    public void memberDeparted(InternalDistributedMember id, boolean crashed) {
    }

    public void memberJoined(InternalDistributedMember id) {
    }

    public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected) {
    }

    public void sendSystemLevelNotification(Notification notification) {
    }

    public DiskBackupStatus backupAllMembers(String targetDirPath) {
        return null;
    }

    public void enableStatementStats(boolean enableOrDisableStats, boolean enableOrDisableTimeStats) {
        try {
            if (this.connectionWrapperHolder.hasConnection()) {
                EmbedConnection connection = this.connectionWrapperHolder.getConnection();
                CallableStatement globalStatsEnableStatement = connection.prepareCall("CALL SYS.SET_GLOBAL_STATEMENT_STATISTICS(?, ?)");
                globalStatsEnableStatement.setBoolean(1, enableOrDisableStats);
                globalStatsEnableStatement.setBoolean(2, enableOrDisableTimeStats);
                globalStatsEnableStatement.execute();
            } else {
                this.logger.info(LocalizedStrings.DEBUG, (Object)"For cluster does not have connection: ");
            }
        }
        catch (SQLException e) {
            this.logger.info(LocalizedStrings.DEBUG, (Object)("Error occurred while enabling statement stats for cluster. Reason: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTableToSystem(ObjectName objectName, TableMXBean memberProxy, FederationComponent newVal) {
        String fullPath = objectName.getKeyProperty("table");
        ObjectName aggregateTableObjectName = ManagementUtils.getAggrgateTableMBeanName(fullPath);
        try {
            this.lock.lock();
            if (!this.tableList.contains(fullPath)) {
                AggregateTableMBeanBridge bridge = new AggregateTableMBeanBridge(memberProxy.getName(), memberProxy.getParentSchema(), memberProxy.getDefinition());
                AggregateTableMBean mbean = new AggregateTableMBean(bridge);
                this.aggregateTableMBeanBridgeMap.put(aggregateTableObjectName, bridge);
                this.service.registerInternalMBean((Object)mbean, aggregateTableObjectName);
                this.tableList.add(fullPath);
                bridge.update(newVal, null, objectName);
            }
            if (this.mbeanCounterMap.containsKey(aggregateTableObjectName)) {
                Long count;
                Long l = count = this.mbeanCounterMap.get(aggregateTableObjectName);
                Long l2 = count = Long.valueOf(count + 1L);
                this.mbeanCounterMap.put(aggregateTableObjectName, count);
            } else {
                this.mbeanCounterMap.put(aggregateTableObjectName, 1L);
            }
        }
        catch (Exception e) {
            this.logger.warning(LocalizedStrings.DEBUG, (Object)("Exception in aggregate table mbean. Exception " + e));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTableFromSystem(ObjectName objectName, TableMXBean memberProxy, FederationComponent oldVal) {
        String fullPath = objectName.getKeyProperty("table");
        ObjectName aggregateTableObjectName = ManagementUtils.getAggrgateTableMBeanName(fullPath);
        if (this.mbeanCounterMap.containsKey(aggregateTableObjectName)) {
            try {
                Long count;
                this.lock.lock();
                Long l = count = this.mbeanCounterMap.get(aggregateTableObjectName);
                Long l2 = count = Long.valueOf(count - 1L);
                this.mbeanCounterMap.put(aggregateTableObjectName, count);
                if (count == 0L) {
                    this.service.unregisterMBean(aggregateTableObjectName);
                    this.aggregateTableMBeanBridgeMap.remove(aggregateTableObjectName);
                    this.mbeanCounterMap.remove(aggregateTableObjectName);
                    this.tableList.remove(fullPath);
                    this.logger.info(LocalizedStrings.DEBUG, (Object)("Removed  aggregateTableMbean " + aggregateTableObjectName));
                }
            }
            catch (Exception e) {
                this.logger.warning(LocalizedStrings.DEBUG, (Object)("Exception in removing aggregate table mbean. Excpetion " + e));
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void updateTableFromSystem(ObjectName objectName, FederationComponent newValue, FederationComponent oldValue) {
        String fullPath = objectName.getKeyProperty("table");
        ObjectName aggregateTableObjectName = ManagementUtils.getAggrgateTableMBeanName(fullPath);
        AggregateTableMBeanBridge bridge = this.aggregateTableMBeanBridgeMap.get(aggregateTableObjectName);
        if (bridge != null) {
            FederationComponent newProxy = newValue;
            FederationComponent oldProxy = null;
            if (oldValue != null) {
                oldProxy = oldValue;
            }
            bridge.update(newProxy, oldProxy, objectName);
        }
    }

    public int getProcedureCallsCompleted() {
        return this.gfxdMemberClusterStatsMonitor.getProcedureCallsCompleted();
    }

    public int getProcedureCallsInProgress() {
        return this.gfxdMemberClusterStatsMonitor.getProcedureCallsInProgress();
    }

    public NetworkServerConnectionStats getNetworkServerClientConnectionStats() {
        return this.gfxdMemberClusterStatsMonitor.getNetworkServerClientConnectionStats();
    }

    public NetworkServerConnectionStats getNetworkServerPeerConnectionStats() {
        return this.gfxdMemberClusterStatsMonitor.getNetworkServerPeerConnectionStats();
    }

    public NetworkServerNestedConnectionStats getNetworkServerNestedConnectionStats() {
        return this.gfxdMemberClusterStatsMonitor.getNetworkServerNestedConnectionStats();
    }

    public NetworkServerNestedConnectionStats getNetworkServerInternalConnectionStats() {
        return this.gfxdMemberClusterStatsMonitor.getNetworkServerInternalConnectionStats();
    }
}

