/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal;

public class Parser {
    protected String buffer;
    private int i;

    public Parser(String src) {
        this.buffer = src;
        this.i = -1;
    }

    public char prev() {
        return this.buffer.charAt(this.i - 1);
    }

    public boolean prevIs(char c) {
        if (this.i <= 0) {
            return false;
        }
        return this.prev() == c;
    }

    public char curr() {
        return this.buffer.charAt(this.i);
    }

    public char peek() {
        return this.buffer.charAt(this.i + 1);
    }

    public boolean peekIs(Token token) {
        return this.buffer.charAt(this.i + 1) == token.c;
    }

    public char next() {
        return this.buffer.charAt(++this.i);
    }

    public boolean hasNext() {
        return this.i < this.buffer.length() - 1;
    }

    public String next(int count) {
        int y = this.i;
        this.i = this.i + count - 1;
        return this.buffer.substring(y, this.i + 1);
    }

    public void trim(Token token) {
        while (this.peekIs(token)) {
            this.next();
        }
    }

    public int findOffset(Token ... tokens) {
        char check;
        int y = this.i;
        do {
            if (y != this.buffer.length() - 1 || !this.contains(tokens, Token.END.c)) continue;
            ++y;
            break;
        } while (!this.contains(tokens, check = this.buffer.charAt(++y)));
        return y - this.i;
    }

    public String nextUntil(Token ... tokens) {
        this.next();
        int offset = this.findOffset(tokens);
        return this.next(offset);
    }

    public boolean isInts(String chars, boolean allowSequence) {
        for (int i = 0; i < chars.length(); ++i) {
            boolean isSequenceChar;
            char c = chars.charAt(i);
            boolean bl = isSequenceChar = c == ' ' || c == ',';
            if (Character.isDigit(c) && (!isSequenceChar || !allowSequence)) continue;
            return false;
        }
        return true;
    }

    private boolean contains(Token[] arr, char checkFor) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i].c != checkFor) continue;
            return true;
        }
        return false;
    }

    public static enum Token {
        DOT('.'),
        OPEN_BRACKET('['),
        CLOSE_BRACKET(']'),
        OPEN_PARENTHESIS('('),
        CLOSE_PARENTHESIS(')'),
        BLANK(' '),
        TICK('\''),
        END('^');

        private final char c;

        private Token(char c) {
            this.c = c;
        }
    }
}

