/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.expression;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CastNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CurrentDatetimeOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JavaToSQLValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JavaValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.MethodCallNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.NonStaticMethodCallNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SQLToJavaValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StaticClassFieldReferenceNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TernaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnaryOperatorNode;
import java.util.Map;

public final class GfxdExprNodeVirtualIDVisitor
extends VisitorAdaptor {
    private final Map<String, Integer> columnToIndexMap;
    private final StringBuilder canonicalizedExpression;
    private final Visitor childVisitor;
    private final String exprType;

    public GfxdExprNodeVirtualIDVisitor(Map<String, Integer> columnToIndexMap, Visitor childVisitor, String exprType) {
        this.columnToIndexMap = columnToIndexMap;
        this.canonicalizedExpression = new StringBuilder();
        this.childVisitor = childVisitor;
        this.exprType = exprType;
    }

    @Override
    public boolean skipChildren(Visitable node) throws StandardException {
        return node instanceof BinaryOperatorNode || node instanceof TernaryOperatorNode || node instanceof MethodCallNode && !(node instanceof NonStaticMethodCallNode);
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        if (node instanceof ColumnReference) {
            ColumnReference colRef = (ColumnReference)node;
            if (this.columnToIndexMap != null) {
                int virtID = this.columnToIndexMap.get(colRef.getColumnName());
                colRef.getSource().setVirtualColumnId(virtID + 1);
            }
            this.canonicalizedExpression.append(colRef.getColumnName());
            this.acceptChildVisitor(node);
        } else if (node instanceof BinaryOperatorNode) {
            boolean parens;
            BinaryOperatorNode opNode = (BinaryOperatorNode)node;
            boolean bl = parens = this.canonicalizedExpression.length() > 0;
            if (parens) {
                this.canonicalizedExpression.append('(');
            }
            opNode.getLeftOperand().accept(this);
            this.canonicalizedExpression.append(' ').append(opNode.getOperatorString()).append(' ');
            this.acceptChildVisitor(opNode);
            opNode.getRightOperand().accept(this);
            if (parens) {
                this.canonicalizedExpression.append(')');
            }
        } else if (node instanceof UnaryOperatorNode) {
            UnaryOperatorNode opNode = (UnaryOperatorNode)node;
            this.canonicalizedExpression.append(opNode.getOperatorString());
            this.acceptChildVisitor(opNode);
        } else if (node instanceof TernaryOperatorNode) {
            TernaryOperatorNode opNode = (TernaryOperatorNode)node;
            this.canonicalizedExpression.append(opNode.getMethodName()).append('(');
            this.acceptChildVisitor(opNode);
            if (opNode.getReceiver() != null) {
                opNode.getReceiver().accept(this);
                this.canonicalizedExpression.append(',');
            }
            if (opNode.getLeftOperand() != null) {
                opNode.getLeftOperand().accept(this);
                this.canonicalizedExpression.append(',');
            }
            if (opNode.getRightOperand() != null) {
                opNode.getRightOperand().accept(this);
                this.canonicalizedExpression.append(',');
            }
            this.closeParen();
        } else if (node instanceof ConstantNode) {
            this.canonicalizedExpression.append(((ConstantNode)node).getValue());
            this.acceptChildVisitor(node);
        } else if (node instanceof NonStaticMethodCallNode) {
            this.acceptChildVisitor(node);
        } else if (node instanceof MethodCallNode) {
            MethodCallNode opNode = (MethodCallNode)node;
            this.canonicalizedExpression.append(opNode.getMethodName()).append('(');
            this.acceptChildVisitor(node);
            for (JavaValueNode child : opNode.getMethodParms()) {
                if (child == null) continue;
                child.accept(this);
                this.canonicalizedExpression.append(',');
            }
            this.closeParen();
        } else if (node instanceof StaticClassFieldReferenceNode) {
            StaticClassFieldReferenceNode opNode = (StaticClassFieldReferenceNode)node;
            this.canonicalizedExpression.append(opNode.getJavaClassName()).append('.').append(opNode.getFieldName());
            this.acceptChildVisitor(node);
        } else if (node instanceof JavaToSQLValueNode) {
            this.acceptChildVisitor(node);
        } else if (node instanceof SQLToJavaValueNode) {
            this.acceptChildVisitor(node);
        } else if (node instanceof CastNode) {
            this.acceptChildVisitor(node);
        } else if (node instanceof CurrentDatetimeOperatorNode) {
            CurrentDatetimeOperatorNode opNode = (CurrentDatetimeOperatorNode)node;
            this.canonicalizedExpression.append(opNode.getMethodName());
            this.acceptChildVisitor(node);
        } else if (this.childVisitor != null) {
            this.canonicalizedExpression.append(node.toString());
            this.acceptChildVisitor(node);
        } else {
            throw StandardException.newException("42X01", "unknown expression in " + this.exprType + ": " + node + '(' + node.getClass() + ')');
        }
        return node;
    }

    public String getCanonicalizedExpression() {
        return this.canonicalizedExpression.toString();
    }

    private void acceptChildVisitor(Visitable node) throws StandardException {
        if (this.childVisitor != null && !this.childVisitor.skipChildren(node)) {
            this.childVisitor.visit(node);
        }
    }

    private void closeParen() {
        int lastIndex = this.canonicalizedExpression.length() - 1;
        if (this.canonicalizedExpression.charAt(lastIndex) == ',') {
            this.canonicalizedExpression.setCharAt(lastIndex, ')');
        } else {
            this.canonicalizedExpression.append(')');
        }
    }
}

