/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AbstractQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import java.util.Iterator;

public final class TableQueryInfo
extends AbstractQueryInfo {
    private final int tableID;
    private final int[][] pkColumns;
    private final LocalRegion region;
    private final TableDescriptor td;
    private int tableNumberForColocationCriteria;
    private FromBaseTable baseTableNode;

    TableQueryInfo() {
        this.tableID = 0;
        this.pkColumns = null;
        this.region = null;
        this.td = null;
        this.tableNumberForColocationCriteria = -1;
    }

    TableQueryInfo(TableQueryInfo master, QueryInfoContext qic) {
        this.tableID = 0;
        this.pkColumns = null;
        this.region = master.region;
        this.td = master.td;
        this.tableNumberForColocationCriteria = 0;
        qic.addToTableCount(1);
        qic.addToPRTableCount(1);
    }

    public TableQueryInfo(FromBaseTable node, QueryInfoContext qic) throws StandardException {
        if (qic.getRootQueryInfo().isSelect()) {
            this.baseTableNode = node;
        }
        this.tableID = node.getTableNumber();
        this.td = node.getTableDescriptor();
        this.region = node.getRegion(false);
        this.tableNumberForColocationCriteria = qic.getTableCount();
        qic.addToTableCount(1);
        if (this.region.getDataPolicy().withPartitioning()) {
            qic.addToPRTableCount(1);
        }
        int[] pks = GemFireXDUtils.getPrimaryKeyColumns(this.td);
        this.pkColumns = TableQueryInfo.getIndexKeyColumns(pks);
    }

    public static int[][] getIndexKeyColumns(int[] pks) {
        if (pks != null) {
            int[][] idxColumns = new int[pks.length][2];
            idxColumns[0][0] = pks[0];
            idxColumns[0][1] = 1;
            block0: for (int i = 1; i < pks.length; ++i) {
                for (int indx = i - 1; indx > -1; --indx) {
                    int currActualPos = idxColumns[indx][0];
                    int currVirtualPos = idxColumns[indx][1];
                    if (currActualPos < pks[i]) {
                        idxColumns[indx + 1][0] = pks[i];
                        idxColumns[indx + 1][1] = i + 1;
                        continue block0;
                    }
                    idxColumns[indx + 1][0] = currActualPos;
                    idxColumns[indx + 1][1] = currVirtualPos;
                    if (indx != 0) continue;
                    idxColumns[0][0] = pks[i];
                    idxColumns[0][1] = i + 1;
                }
            }
            return idxColumns;
        }
        return null;
    }

    @Override
    public boolean isPrimaryKeyBased() {
        return this.pkColumns != null;
    }

    public int[][] getPrimaryKeyColumns() {
        return this.pkColumns;
    }

    public int getTableNumber() {
        return this.tableID;
    }

    public LocalRegion getRegion() {
        return this.region;
    }

    @Override
    public final String getTableName() {
        return this.td.getName();
    }

    @Override
    public final String getFullTableName() {
        String schemaName = this.getSchemaName();
        return schemaName != null ? schemaName + '.' + this.getTableName() : this.getTableName();
    }

    @Override
    public final String getSchemaName() {
        return this.td.getSchemaName();
    }

    TableDescriptor getTableDescriptor() {
        return this.td;
    }

    public int getNumColumns() {
        return this.td.getNumberOfColumns();
    }

    boolean isPartitionedRegion() {
        return this.region.getDataPolicy().withPartitioning();
    }

    boolean isEmptyDataPolicy() {
        return !this.region.getDataPolicy().withStorage();
    }

    String getMasterTableName() {
        assert (this.region instanceof PartitionedRegion);
        GfxdPartitionResolver rslvr = (GfxdPartitionResolver)((PartitionedRegion)this.region).getPartitionResolver();
        return rslvr.getMasterTable(true);
    }

    public String toString() {
        return "TableQueryInfo: region=" + (this.region != null ? this.region.getFullPath() : "(null)");
    }

    final int getTableNumberforColocationCriteria() {
        return this.tableNumberForColocationCriteria;
    }

    final void setTableNumberforColocationCriteria(int v) {
        this.tableNumberForColocationCriteria = v;
    }

    int getPartitioningColumnCount() {
        if (this.region.getDataPolicy().withPartitioning()) {
            GfxdPartitionResolver rslvr = (GfxdPartitionResolver)((PartitionedRegion)this.region).getPartitionResolver();
            return rslvr.getPartitioningColumnsCount();
        }
        return 0;
    }

    ForeignKeyConstraintDescriptor getForeignKeyConstraintDescriptorIfAny() throws StandardException {
        ForeignKeyConstraintDescriptor fcd = null;
        ConstraintDescriptorList cdl = this.td.getConstraintDescriptorList();
        for (ConstraintDescriptor cd : cdl) {
            if (cd.getConstraintType() != 6) continue;
            fcd = (ForeignKeyConstraintDescriptor)cd;
            break;
        }
        return fcd;
    }

    boolean isCheckTypeConstraintPresent() throws StandardException {
        ConstraintDescriptorList cdl = this.td.getConstraintDescriptorList();
        Iterator itr = cdl.iterator();
        boolean present = false;
        while (itr.hasNext()) {
            ConstraintDescriptor cd = (ConstraintDescriptor)itr.next();
            if (cd.getConstraintType() != 4) continue;
            present = true;
            break;
        }
        return present;
    }

    final FromBaseTable getTableNode() {
        return this.baseTableNode;
    }

    final void setBaseTableNodeAsNull() {
        this.baseTableNode = null;
    }

    @Override
    public boolean isTableVTI() {
        return this.td.getTableType() == 5;
    }

    @Override
    public boolean routeQueryToAllNodes() {
        return this.td.routeQueryToAllNodes();
    }

    public int hashCode() {
        return this.region.hashCode();
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass() == TableQueryInfo.class) {
            return this.region == ((TableQueryInfo)other).region;
        }
        return false;
    }
}

