/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.message;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.GemFireCheckedException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdCallbackArgument;
import com.pivotal.gemfirexd.internal.engine.distributed.message.GetExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.RegionExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public abstract class RegionMultiKeyExecutorMessage
extends RegionExecutorMessage<Object> {
    protected List<Object> membersToKeys = null;
    protected GfxdCallbackArgument commonCallbackArg;
    protected String regionPath;
    protected int prId = -1;
    protected transient PartitionedRegion pr;
    protected transient DistributedMember target = null;
    protected int[] projectionFixedColumns;
    protected int[] projectionVarColumns;
    protected int[] projectionLobColumns;
    protected transient int[] projectionAllColumns;
    protected byte targetFormatOffsetBytes;
    protected transient boolean hasProjection;
    protected transient RowFormatter targetFormat;
    protected static final short IS_PARTITIONED_TABLE = 128;
    protected static final short HAS_CALLBACK_ARG = 256;
    protected static final short HAS_PROJECTION = 512;
    protected static final short UNRESERVED_FLAGS_START = 1024;

    protected RegionMultiKeyExecutorMessage(boolean ignored) {
        super(true);
    }

    protected RegionMultiKeyExecutorMessage(ResultCollector<Object, Object> collector, LocalRegion region, Set<Object> routingObjects, TXStateInterface tx, boolean timeStatsEnabled, RowFormatter targetFormat, int[] projectionFixedColumns, int[] projectionVarColumns, int[] projectionLobColumns, int[] projectionAllColumns) {
        super(collector, region, routingObjects, tx, timeStatsEnabled);
        this.regionPath = region.getFullPath();
        if (region.getPartitionAttributes() != null) {
            this.pr = (PartitionedRegion)region;
            this.prId = this.pr.getPRId();
        }
        boolean bl = this.hasProjection = projectionAllColumns != null;
        if (this.hasProjection) {
            int offsetBytes = targetFormat.getNumOffsetBytes();
            assert (offsetBytes > 0 && offsetBytes <= 4) : offsetBytes;
            this.targetFormat = targetFormat;
            this.projectionFixedColumns = projectionFixedColumns;
            this.projectionVarColumns = projectionVarColumns;
            this.projectionLobColumns = projectionLobColumns;
            this.projectionAllColumns = projectionAllColumns;
            this.targetFormatOffsetBytes = (byte)offsetBytes;
        }
        this.membersToKeys = new ArrayList<Object>();
    }

    protected RegionMultiKeyExecutorMessage(RegionMultiKeyExecutorMessage other) {
        super(other);
        this.membersToKeys = other.membersToKeys;
        this.commonCallbackArg = other.commonCallbackArg;
        this.regionPath = other.regionPath;
        this.pr = other.pr;
        this.prId = other.prId;
        this.targetFormat = other.targetFormat;
        this.projectionFixedColumns = other.projectionFixedColumns;
        this.projectionVarColumns = other.projectionVarColumns;
        this.projectionLobColumns = other.projectionLobColumns;
        this.projectionAllColumns = other.projectionAllColumns;
        this.targetFormatOffsetBytes = other.targetFormatOffsetBytes;
        this.hasProjection = other.hasProjection;
        this.target = other.target;
    }

    @Override
    protected abstract RegionMultiKeyExecutorMessage clone();

    @Override
    protected short computeCompressedShort(short flags) {
        flags = super.computeCompressedShort(flags);
        if (this.prId >= 0) {
            flags = (short)(flags | 0x80);
        }
        if (this.commonCallbackArg != null) {
            flags = (short)(flags | 0x100);
        }
        if (this.hasProjection) {
            flags = (short)(flags | 0x200);
        }
        return flags;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        long begintime = this.timeStatsEnabled ? XPLAINUtil.recordTiming(this.ser_deser_time == 0L ? (this.ser_deser_time = -1L) : -2L) : 0L;
        super.toData(out);
        if (this.prId >= 0) {
            InternalDataSerializer.writeUnsignedVL((long)this.prId, (DataOutput)out);
        } else {
            DataSerializer.writeString((String)this.regionPath, (DataOutput)out);
        }
        InternalDataSerializer.writeObject(this.membersToKeys, (DataOutput)out);
        if (this.commonCallbackArg != null) {
            InternalDataSerializer.writeObject((Object)this.commonCallbackArg, (DataOutput)out);
        }
        if (this.hasProjection) {
            GetExecutorMessage.writeUIntArray(this.projectionFixedColumns, out);
            GetExecutorMessage.writeUIntArray(this.projectionVarColumns, out);
            GetExecutorMessage.writeUIntArray(this.projectionLobColumns, out);
            out.writeByte(this.targetFormatOffsetBytes);
        }
        if (begintime != 0L) {
            this.ser_deser_time = XPLAINUtil.recordTiming(begintime);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.ser_deser_time = this.timeStatsEnabled ? (long)(this.ser_deser_time == 0L ? -1 : -2) : 0L;
        super.fromData(in);
        if ((this.flags & 0x80) != 0) {
            this.prId = (int)InternalDataSerializer.readUnsignedVL((DataInput)in);
        } else {
            this.regionPath = DataSerializer.readString((DataInput)in);
        }
        this.membersToKeys = (List)InternalDataSerializer.readObject((DataInput)in);
        if ((this.flags & 0x100) != 0) {
            this.commonCallbackArg = (GfxdCallbackArgument)DataSerializer.readObject((DataInput)in);
        }
        boolean bl = this.hasProjection = (this.flags & 0x200) != 0;
        if (this.hasProjection) {
            this.projectionFixedColumns = GetExecutorMessage.readIntArray(in);
            this.projectionVarColumns = GetExecutorMessage.readIntArray(in);
            this.projectionLobColumns = GetExecutorMessage.readIntArray(in);
            this.targetFormatOffsetBytes = in.readByte();
        }
        if (this.timeStatsEnabled && this.ser_deser_time == -1L) {
            this.ser_deser_time = XPLAINUtil.recordStdTiming(this.getTimestamp());
        }
    }

    protected String getID() {
        return this.getShortClassName();
    }

    @Override
    protected void appendFields(StringBuilder sb) {
        super.appendFields(sb);
        sb.append(";regionPath=").append(this.regionPath);
        if (this.pr != null) {
            sb.append(";prId=").append(this.prId);
        }
        if (this.commonCallbackArg != null) {
            sb.append(";callbackArg=");
            ArrayUtils.objectString((Object)this.commonCallbackArg, (StringBuilder)sb);
        }
        if (this.hasProjection) {
            if (this.projectionFixedColumns != null) {
                sb.append(";projectionFixedColumns=").append(Arrays.toString(this.projectionFixedColumns));
            }
            if (this.projectionVarColumns != null) {
                sb.append(";projectionVarColumns=").append(Arrays.toString(this.projectionVarColumns));
            }
            if (this.projectionLobColumns != null) {
                sb.append(";projectionLobColumns=").append(Arrays.toString(this.projectionLobColumns));
            }
        }
    }

    @Override
    protected void setIgnoreReplicateIfSetOperators(boolean ignoreReplicate) {
    }

    public final DistributedMember getTarget() {
        return this.target;
    }

    @Override
    protected final void processMessage(DistributionManager dm) throws GemFireCheckedException {
        if (this.region == null) {
            if (this.prId >= 0) {
                this.pr = PartitionedRegion.getPRFromId((int)this.prId);
                if (this.pr == null) {
                    throw new ForceReattemptException(LocalizedStrings.PartitionMessage_0_COULD_NOT_FIND_PARTITIONED_REGION_WITH_ID_1.toLocalizedString(new Object[]{Misc.getGemFireCache().getMyId(), this.prId}));
                }
                this.region = this.pr;
                this.regionPath = this.region.getFullPath();
            } else {
                this.region = Misc.getGemFireCache().getRegionByPathForProcessing(this.regionPath);
                if (this.region == null) {
                    throw new ForceReattemptException(LocalizedStrings.Region_CLOSED_OR_DESTROYED.toLocalizedString(new Object[]{this.regionPath}));
                }
            }
        }
        for (Object key : this.membersToKeys) {
            if (!(key instanceof KeyWithRegionContext)) continue;
            ((KeyWithRegionContext)key).setRegionContext(this.region);
        }
        super.processMessage(dm);
    }

    protected void resetKeysPerMember() {
        if (this.membersToKeys != null) {
            this.membersToKeys.clear();
        }
    }

    public final boolean hasProjection() {
        return this.hasProjection;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return true;
    }

    public List<Object> getKeysPerMember(DistributedMember member) {
        return this.membersToKeys;
    }

    public abstract long estimateMemoryUsage() throws StandardException;
}

