/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.message;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.GemFireCheckedException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.locks.LockingPolicy;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gnu.trove.THashSet;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdListResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.message.BitSetSet;
import com.pivotal.gemfirexd.internal.engine.distributed.message.RegionExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeKey;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.CompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ContainsKeyBulkExecutorMessage
extends RegionExecutorMessage<Object> {
    protected Object[] inKeys;
    protected Object[] inRoutingObjects;
    protected String regionPath;
    protected PartitionedRegion pr;
    protected int prId;
    protected DistributedMember member;
    HashMap<Object, Integer> keysToBucketIds;
    protected static final short IS_PARTITIONED_TABLE = 128;

    public ContainsKeyBulkExecutorMessage() {
        super(true);
        this.inKeys = null;
        this.inRoutingObjects = null;
        this.regionPath = null;
        this.pr = null;
        this.keysToBucketIds = null;
    }

    public ContainsKeyBulkExecutorMessage(LocalRegion region, Object[] keys, Object[] routingObjects, TXStateInterface tx, LanguageConnectionContext lcc) {
        super(new GfxdListResultCollector(null, true), region, (Set<Object>)new THashSet(Arrays.asList(routingObjects)), tx, ContainsKeyBulkExecutorMessage.getTimeStatsSettings(lcc));
        this.inKeys = keys;
        this.inRoutingObjects = routingObjects;
        this.regionPath = region.getFullPath();
        if (region.getPartitionAttributes() != null) {
            this.pr = (PartitionedRegion)region;
            this.prId = this.pr.getPRId();
        }
    }

    public ContainsKeyBulkExecutorMessage(ContainsKeyBulkExecutorMessage other) {
        super(other);
        this.inKeys = other.inKeys;
        this.inRoutingObjects = other.inRoutingObjects;
        this.pr = other.pr;
        this.prId = other.prId;
        this.regionPath = this.region.getFullPath();
        this.routingObjects = other.routingObjects;
        this.membersToBucketIds = other.membersToBucketIds;
        this.keysToBucketIds = other.keysToBucketIds;
        this.member = other.member;
    }

    @Override
    protected ContainsKeyBulkExecutorMessage clone() {
        return new ContainsKeyBulkExecutorMessage(this);
    }

    @Override
    protected void execute() throws GemFireCheckedException {
        boolean doLog = DistributionManager.VERBOSE | GemFireXDUtils.TraceQuery;
        boolean isPR = this.pr != null;
        TXStateInterface tx = this.getTXState();
        int bucketId = 0;
        if (this.keysToBucketIds == null) {
            this.populateKeysToBucketIdsMap(this.bucketBitSet);
        }
        if (doLog) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("ContainsKeyBulkExecutorMessage#execute: region=" + this.regionPath + " keysToBucketIds map for the current member= " + this.keysToBucketIds));
        }
        for (Map.Entry<Object, Integer> entry : this.keysToBucketIds.entrySet()) {
            boolean containsKey;
            Object key = entry.getKey();
            bucketId = entry.getValue();
            if (key instanceof CompactCompositeRegionKey) {
                ((CompactCompositeRegionKey)key).setRegionContext(this.region);
            }
            if (containsKey = GfxdIndexManager.ContainsKeyExecutorMessage.existsKey(this.region, isPR, bucketId, key, tx, null)) continue;
            GemFireContainer.BulkKeyLookupResult oneResult = new GemFireContainer.BulkKeyLookupResult(key, containsKey);
            this.sendResult(oneResult);
        }
        GemFireContainer.BulkKeyLookupResult finalResult = new GemFireContainer.BulkKeyLookupResult(Token.INVALID, true);
        this.lastResult(finalResult);
    }

    @Override
    protected final void processMessage(DistributionManager dm) throws GemFireCheckedException {
        if (this.region == null) {
            if (this.prId >= 0) {
                this.pr = PartitionedRegion.getPRFromId((int)this.prId);
                if (this.pr == null) {
                    throw new ForceReattemptException(LocalizedStrings.PartitionMessage_0_COULD_NOT_FIND_PARTITIONED_REGION_WITH_ID_1.toLocalizedString(new Object[]{Misc.getGemFireCache().getMyId(), this.prId}));
                }
                this.region = this.pr;
                this.regionPath = this.region.getFullPath();
            } else {
                this.region = Misc.getGemFireCache().getRegionByPathForProcessing(this.regionPath);
                if (this.region == null) {
                    throw new ForceReattemptException(LocalizedStrings.Region_CLOSED_OR_DESTROYED.toLocalizedString(new Object[]{this.regionPath}));
                }
            }
        }
        super.processMessage(dm);
    }

    protected String getID() {
        return this.getShortClassName();
    }

    @Override
    protected short computeCompressedShort(short flags) {
        flags = super.computeCompressedShort(flags);
        if (this.prId >= 0) {
            flags = (short)(flags | 0x80);
        }
        return flags;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        long beginTime = this.timeStatsEnabled ? XPLAINUtil.recordTiming(this.ser_deser_time == 0L ? (this.ser_deser_time = -1L) : -2L) : 0L;
        super.toData(out);
        InternalDataSerializer.writeObject(this.keysToBucketIds, (DataOutput)out);
        if (this.prId >= 0) {
            InternalDataSerializer.writeUnsignedVL((long)this.prId, (DataOutput)out);
        } else {
            DataSerializer.writeString((String)this.regionPath, (DataOutput)out);
        }
        if (beginTime != 0L) {
            this.ser_deser_time = XPLAINUtil.recordTiming(beginTime);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.ser_deser_time = this.timeStatsEnabled ? (long)(this.ser_deser_time == 0L ? -1 : -2) : 0L;
        super.fromData(in);
        this.keysToBucketIds = (HashMap)InternalDataSerializer.readObject((DataInput)in);
        if ((this.flags & 0x80) != 0) {
            this.prId = (int)InternalDataSerializer.readUnsignedVL((DataInput)in);
        } else {
            this.regionPath = DataSerializer.readString((DataInput)in);
        }
        if (this.timeStatsEnabled && this.ser_deser_time == -1L) {
            this.ser_deser_time = XPLAINUtil.recordStdTiming(this.getTimestamp());
        }
    }

    public long estimateMemoryUsage() throws StandardException {
        long memory = 0L;
        for (Map.Entry<Object, Integer> m : this.keysToBucketIds.entrySet()) {
            Object o = m.getKey();
            if (o instanceof CompactCompositeRegionKey) {
                memory += ((CompactCompositeRegionKey)o).estimateMemoryUsage();
                continue;
            }
            if (o instanceof CompactCompositeKey) {
                memory += ((CompactCompositeKey)o).estimateMemoryUsage();
                continue;
            }
            if (o instanceof CompositeRegionKey) {
                memory += ((CompositeRegionKey)o).estimateMemoryUsage();
                continue;
            }
            if (!(o instanceof DataValueDescriptor)) continue;
            memory += (long)((DataValueDescriptor)o).estimateMemoryUsage();
        }
        return memory;
    }

    @Override
    protected void setArgsForMember(DistributedMember member, Set<DistributedMember> messageAwareMembers) {
        this.member = member;
        BitSetSet bucketBitSet = (BitSetSet)this.membersToBucketIds.get(this.member);
        if (bucketBitSet != null) {
            this.populateKeysToBucketIdsMap(bucketBitSet);
        }
    }

    private void populateKeysToBucketIdsMap(BitSetSet bucketBitSet) {
        this.keysToBucketIds = new HashMap();
        int bucketId = 0;
        for (int j = 0; j < this.inKeys.length; ++j) {
            if (this.inKeys[j] == null) continue;
            if (this.inRoutingObjects != null) {
                bucketId = PartitionedRegionHelper.getHashKey((PartitionedRegion)this.pr, (Object)this.inRoutingObjects[j]);
            } else {
                if (this.inKeys[j] instanceof CompactCompositeRegionKey) {
                    ((CompactCompositeRegionKey)this.inKeys[j]).setRegionContext(this.region);
                }
                bucketId = PartitionedRegionHelper.getHashKey((PartitionedRegion)this.pr, (Operation)Operation.GET, (Object)this.inKeys[j], null, null);
            }
            if (!bucketBitSet.containsInt(bucketId)) continue;
            this.keysToBucketIds.put(this.inKeys[j], bucketId);
        }
    }

    @Override
    public boolean withSecondaries() {
        return false;
    }

    @Override
    public byte getGfxdID() {
        return 53;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public final boolean canStartRemoteTransaction() {
        return true;
    }

    @Override
    public boolean useTransactionProxy() {
        return this.getLockingPolicy().readOnlyCanStartTX();
    }

    @Override
    protected boolean requiresTXFlushAfterExecution() {
        return this.getLockingPolicy().readOnlyCanStartTX();
    }

    @Override
    public boolean isHA() {
        return true;
    }

    @Override
    protected void setIgnoreReplicateIfSetOperators(boolean ignoreReplicate) {
    }

    @Override
    public final int getMessageProcessorType() {
        return this.pendingTXId == null && this.getLockingPolicy() == LockingPolicy.NONE ? 74 : 78;
    }
}

