/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.diag;

public final class SortedCSVProcedures {
    private SortedCSVProcedures() {
    }

    public static void dummy() {
    }

    public static String intersection(String csv1, String csv2) {
        int csv1Len = csv1.length();
        int csv2Len = csv2.length();
        StringBuilder intersect = new StringBuilder();
        int csv1Start = 0;
        int csv1Cur = 0;
        int csv2Start = 0;
        int csv2Cur = 0;
        while (SortedCSVProcedures.checkEndForIntersect(intersect, csv1, csv1Cur, csv1Len, csv1Start, csv2, csv2Cur, csv2Len) == EndStatus.MIDDLE && SortedCSVProcedures.checkEndForIntersect(intersect, csv2, csv2Cur, csv2Len, csv2Start, csv1, csv1Cur, csv1Len) == EndStatus.MIDDLE) {
            char c2;
            char c1 = csv1.charAt(csv1Cur);
            if (c1 != (c2 = csv2.charAt(csv2Cur))) {
                if (c1 < c2) {
                    if ((csv1Cur = SortedCSVProcedures.moveToStringEnd(csv1, csv1Cur, csv1Len)) == -1) break;
                    csv1Start = csv1Cur;
                    csv2Cur = csv2Start;
                    continue;
                }
                if ((csv2Cur = SortedCSVProcedures.moveToStringEnd(csv2, csv2Cur, csv2Len)) == -1) break;
                csv2Start = csv2Cur;
                csv1Cur = csv1Start;
                continue;
            }
            if (c1 != ',') {
                ++csv1Cur;
                ++csv2Cur;
                continue;
            }
            SortedCSVProcedures.addStringToBuilder(intersect, csv1.substring(csv1Start, csv1Cur));
            csv1Start = ++csv1Cur;
            csv2Start = ++csv2Cur;
        }
        return intersect.toString();
    }

    public static String groupsIntersection(String csv1, String csv2) {
        if (csv1.length() == 0 || csv2.length() == 0) {
            return "";
        }
        return SortedCSVProcedures.intersection(csv1, csv2);
    }

    public static Boolean intersect(String csv1, String csv2) {
        EndStatus status;
        int csv1Len = csv1.length();
        int csv2Len = csv2.length();
        int csv1Start = 0;
        int csv1Cur = 0;
        int csv2Start = 0;
        int csv2Cur = 0;
        while ((status = SortedCSVProcedures.checkEndForIntersect(null, csv1, csv1Cur, csv1Len, csv1Start, csv2, csv2Cur, csv2Len)) == EndStatus.MIDDLE && (status = SortedCSVProcedures.checkEndForIntersect(null, csv2, csv2Cur, csv2Len, csv2Start, csv1, csv1Cur, csv1Len)) == EndStatus.MIDDLE) {
            char c2;
            char c1 = csv1.charAt(csv1Cur);
            if (c1 != (c2 = csv2.charAt(csv2Cur))) {
                if (c1 < c2) {
                    if ((csv1Cur = SortedCSVProcedures.moveToStringEnd(csv1, csv1Cur, csv1Len)) == -1) {
                        return Boolean.FALSE;
                    }
                    csv1Start = csv1Cur;
                    csv2Cur = csv2Start;
                    continue;
                }
                if ((csv2Cur = SortedCSVProcedures.moveToStringEnd(csv2, csv2Cur, csv2Len)) == -1) {
                    return Boolean.FALSE;
                }
                csv2Start = csv2Cur;
                csv1Cur = csv1Start;
                continue;
            }
            if (c1 != ',') {
                ++csv1Cur;
                ++csv2Cur;
                continue;
            }
            return Boolean.TRUE;
        }
        return status == EndStatus.END_WITH_INTERSECTION;
    }

    public static Boolean groupsIntersect(String csv1, String csv2) {
        if (csv1.length() == 0 && csv2.length() == 0) {
            return Boolean.TRUE;
        }
        return SortedCSVProcedures.intersect(csv1, csv2);
    }

    public static String union(String csv1, String csv2) {
        int csv1Len = csv1.length();
        int csv2Len = csv2.length();
        StringBuilder union = new StringBuilder();
        int csv1Start = 0;
        int csv1Cur = 0;
        int csv2Start = 0;
        int csv2Cur = 0;
        while (!SortedCSVProcedures.checkEndForUnion(union, csv1, csv1Cur, csv1Len, csv1Start, csv2, csv2Cur, csv2Len, csv2Start) && !SortedCSVProcedures.checkEndForUnion(union, csv2, csv2Cur, csv2Len, csv2Start, csv1, csv1Cur, csv1Len, csv1Start)) {
            char c2;
            char c1 = csv1.charAt(csv1Cur);
            if (c1 != (c2 = csv2.charAt(csv2Cur))) {
                if (c1 < c2) {
                    if ((csv1Cur = SortedCSVProcedures.moveToStringEnd(csv1, csv1Cur, csv1Len)) == -1) {
                        SortedCSVProcedures.addStringToBuilder(union, csv1.substring(csv1Start));
                        SortedCSVProcedures.addStringToBuilder(union, csv2.substring(csv2Start));
                        break;
                    }
                    SortedCSVProcedures.addStringToBuilder(union, csv1.substring(csv1Start, csv1Cur - 1));
                    csv1Start = csv1Cur;
                    csv2Cur = csv2Start;
                    continue;
                }
                if ((csv2Cur = SortedCSVProcedures.moveToStringEnd(csv2, csv2Cur, csv2Len)) == -1) {
                    SortedCSVProcedures.addStringToBuilder(union, csv2.substring(csv2Start));
                    SortedCSVProcedures.addStringToBuilder(union, csv1.substring(csv1Start));
                    break;
                }
                SortedCSVProcedures.addStringToBuilder(union, csv2.substring(csv2Start, csv2Cur - 1));
                csv2Start = csv2Cur;
                csv1Cur = csv1Start;
                continue;
            }
            if (c1 != ',') {
                ++csv1Cur;
                ++csv2Cur;
                continue;
            }
            SortedCSVProcedures.addStringToBuilder(union, csv1.substring(csv1Start, csv1Cur));
            csv1Start = ++csv1Cur;
            csv2Start = ++csv2Cur;
        }
        return union.toString();
    }

    public static String groupsUnion(String csv1, String csv2) {
        if (csv1.length() == 0 || csv2.length() == 0) {
            return "";
        }
        return SortedCSVProcedures.union(csv1, csv2);
    }

    private static EndStatus checkEndForIntersect(StringBuilder intersect, String csv1, int pos1, int len1, int start1, String csv2, int pos2, int len2) {
        if (pos1 < len1) {
            return EndStatus.MIDDLE;
        }
        if (pos2 < len2 && csv2.charAt(pos2) != ',' || start1 == len1) {
            return EndStatus.END;
        }
        if (intersect != null) {
            SortedCSVProcedures.addStringToBuilder(intersect, csv1.substring(start1));
        }
        return EndStatus.END_WITH_INTERSECTION;
    }

    private static int moveToStringEnd(String csv, int pos, int len) {
        while (csv.charAt(pos++) != ',') {
            if (pos < len) continue;
            return -1;
        }
        return pos;
    }

    private static boolean checkEndForUnion(StringBuilder union, String csv1, int pos1, int len1, int start1, String csv2, int pos2, int len2, int start2) {
        if (pos1 < len1) {
            return false;
        }
        if (pos2 < len2 && csv2.charAt(pos2) != ',') {
            SortedCSVProcedures.addStringToBuilder(union, csv1.substring(start1));
        }
        SortedCSVProcedures.addStringToBuilder(union, csv2.substring(start2));
        return true;
    }

    private static void addStringToBuilder(StringBuilder sb, String s) {
        if (sb.length() > 0) {
            sb.append(',');
        }
        sb.append(s);
    }

    private static enum EndStatus {
        MIDDLE,
        END,
        END_WITH_INTERSECTION;

    }
}

