/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.diag;

import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.internal.engine.GfxdVTITemplate;
import com.pivotal.gemfirexd.internal.engine.fabricservice.FabricServiceImpl;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;

public class SessionsVTI
extends GfxdVTITemplate {
    Iterator<SessionInfo> iter = null;
    SessionInfo current = null;
    public static final String MEMBERID = "ID";
    public static final String SESSIONID = "SESSION_ID";
    public static final String USERID = "USER_ID";
    public static final String SERVER_BIND_PORT = "SERVER_BIND_PORT";
    public static final String CLIENT_BIND_ADDRESS = "CLIENT_BIND_ADDRESS";
    public static final String CLIENT_BIND_PORT = "CLIENT_BIND_PORT";
    public static final String SOCKET_CONNECTION_STATUS = "SOCKET_CONNECTION_STATUS";
    public static final String SESSION_STATUS = "SESSION_STATUS";
    public static final String SESSION_BEGIN_TIME = "SESSION_BEGIN_TIME";
    public static final String SESSION_INFO = "SESSION_INFO";
    public static final String CURRENT_STATEMENT_UUID = "CURRENT_STATEMENT_UUID";
    public static final String CURRENT_STATEMENT = "CURRENT_STATEMENT";
    public static final String CURRENT_STATEMENT_STATUS = "CURRENT_STATEMENT_STATUS";
    public static final String CURRENT_STATEMENT_ELAPSED_TIME = "CURRENT_STATEMENT_ELAPSED_TIME";
    public static final String CURRENT_STATEMENT_ACCESS_FREQUENCY = "CURRENT_STATEMENT_ACCESS_FREQUENCY";
    public static final String CURRENT_STATEMENT_MEMORY_USAGE = "CURRENT_STATEMENT_MEMORY_USAGE";
    public static final String HOSTNAME = "HOSTNAME";
    public static final String SERVER_LISTENING_PORT = "SERVER_LISTENING_PORT";
    public static final String NETWORK_INTERFACE_INFO = "NETWORK_INTERFACE_INFO";
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("ID", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("SESSION_ID", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("HOSTNAME", 12, false, 64), EmbedResultSetMetaData.getResultColumnDescriptor("SERVER_LISTENING_PORT", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("USER_ID", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("CLIENT_BIND_ADDRESS", 12, false, 64), EmbedResultSetMetaData.getResultColumnDescriptor("CLIENT_BIND_PORT", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("SOCKET_CONNECTION_STATUS", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("SESSION_STATUS", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("SESSION_BEGIN_TIME", 93, false), EmbedResultSetMetaData.getResultColumnDescriptor("SESSION_INFO", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("CURRENT_STATEMENT_UUID", 12, true, 1024), EmbedResultSetMetaData.getResultColumnDescriptor("CURRENT_STATEMENT", 12, true, 1024), EmbedResultSetMetaData.getResultColumnDescriptor("CURRENT_STATEMENT_STATUS", 12, true, 32), EmbedResultSetMetaData.getResultColumnDescriptor("CURRENT_STATEMENT_ELAPSED_TIME", -5, true), EmbedResultSetMetaData.getResultColumnDescriptor("CURRENT_STATEMENT_ACCESS_FREQUENCY", -5, true), EmbedResultSetMetaData.getResultColumnDescriptor("CURRENT_STATEMENT_MEMORY_USAGE", -5, true), EmbedResultSetMetaData.getResultColumnDescriptor("NETWORK_INTERFACE_INFO", 12, false, 256)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    @Override
    public boolean next() throws SQLException {
        FabricService service;
        if (this.iter == null && (service = FabricServiceManager.currentFabricServiceInstance()) != null) {
            ArrayList<SessionInfo> sessions = new ArrayList<SessionInfo>();
            assert (service instanceof FabricServiceImpl);
            for (FabricServiceImpl.NetworkInterfaceImpl networkInterfaceImpl : ((FabricServiceImpl)service).getAllNetworkServers()) {
                sessions.add(networkInterfaceImpl.getSessionInfo());
            }
            this.iter = sessions.iterator();
        }
        if (this.current != null && this.current.moveNext()) {
            return true;
        }
        while (this.iter.hasNext()) {
            this.current = this.iter.next();
            if (!this.current.moveNext()) continue;
            return true;
        }
        this.iter = null;
        return false;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return metadata;
    }

    @Override
    protected Object getObjectForColumn(int columnNumber) throws SQLException {
        Object res;
        ResultColumnDescriptor desc = columnInfo[columnNumber - 1];
        String columnName = desc.getName();
        if (MEMBERID.equals(columnName)) {
            res = this.current.memberid;
        } else if (SESSIONID.equals(columnName)) {
            res = this.current.current().connNum;
        } else if (USERID.equals(columnName)) {
            res = this.current.current().userId;
        } else if (CLIENT_BIND_ADDRESS.equals(columnName)) {
            res = this.current.current().clientBindAddress;
        } else if (CLIENT_BIND_PORT.equals(columnName)) {
            res = this.current.current().clientBindPort;
        } else if (SOCKET_CONNECTION_STATUS.equals(columnName)) {
            res = this.current.current().isConnected ? "CONNECTED" : (this.current.current().hadConnectedOnce ? "DISCONNECTED" : "NOTCONNECTED");
        } else if (SESSION_STATUS.equals(columnName)) {
            res = this.current.current().isActive ? "ACTIVE" : "QUEUED";
        } else if (SESSION_INFO.equals(columnName)) {
            SessionInfo.ClientSession s = this.current.current();
            StringBuilder sb = new StringBuilder();
            sb.append("failover=").append(s.failover).append(SanityManager.lineSeparator);
            if (s.skipLocks) {
                sb.append(";skipLocks=true").append(SanityManager.lineSeparator);
            }
            sb.append(";disableStreaming=").append(s.disableStreaming).append(SanityManager.lineSeparator);
            sb.append(";skipListeners=").append(s.skipListeners).append(SanityManager.lineSeparator);
            sb.append(";disableTXBatching=").append(s.disableTXBatching).append(SanityManager.lineSeparator);
            sb.append(";syncCommits=").append(s.syncCommits).append(SanityManager.lineSeparator);
            sb.append(";skipConstraintChecks=").append(s.skipConstraintChecks).append(SanityManager.lineSeparator);
            sb.append(";queryHDFS=").append(s.queryHDFS).append(SanityManager.lineSeparator);
            res = sb.toString();
        } else {
            res = CURRENT_STATEMENT_UUID.equals(columnName) ? this.current.current().currentStatementUUID : (CURRENT_STATEMENT.equals(columnName) ? this.current.current().currentStatement : (CURRENT_STATEMENT_STATUS.equals(columnName) ? this.current.current().currentStatementStatus : (CURRENT_STATEMENT_ELAPSED_TIME.equals(columnName) ? Long.valueOf(this.current.current().currentStatementElapsedTime) : (CURRENT_STATEMENT_ACCESS_FREQUENCY.equals(columnName) ? Long.valueOf(this.current.current().currentStatementAccessFrequency) : (CURRENT_STATEMENT_MEMORY_USAGE.equals(columnName) ? Long.valueOf(this.current.current().currentStatementEstimatedMemUsage) : (HOSTNAME.equals(columnName) ? this.current.hostname : (SERVER_LISTENING_PORT.equals(columnName) ? Integer.valueOf(this.current.serverListeningPort) : (NETWORK_INTERFACE_INFO.equals(columnName) ? this.current.networkInterfaceInfo : null))))))));
        }
        return res;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        ResultColumnDescriptor desc = columnInfo[columnIndex - 1];
        String columnName = desc.getName();
        if (!SESSION_BEGIN_TIME.equals(columnName)) {
            return super.getTimestamp(columnIndex);
        }
        Timestamp res = this.current.current().connectionBeginTimeStamp;
        return res;
    }

    public static final class SessionInfo {
        public String memberid;
        public String hostname;
        public int serverListeningPort;
        public String networkInterfaceInfo;
        Iterator<ClientSession> iter = null;
        private ClientSession current;
        private ArrayList<ClientSession> sessions = new ArrayList();

        public final void addClientSession(ClientSession session) {
            this.sessions.add(session);
        }

        public final boolean moveNext() {
            if (this.iter == null) {
                this.iter = this.sessions.iterator();
            }
            if (this.iter.hasNext()) {
                this.current = this.iter.next();
                return true;
            }
            this.current = null;
            return false;
        }

        public final ClientSession current() {
            return this.current;
        }

        public static final class ClientSession {
            public boolean isActive;
            public String clientBindAddress;
            public int clientBindPort;
            public boolean hadConnectedOnce;
            public boolean isConnected;
            public int connNum;
            public String userId;
            public boolean failover;
            public boolean disableStreaming;
            public boolean skipListeners;
            public boolean queryHDFS;
            public boolean routeQuery;
            public boolean skipConstraintChecks;
            public boolean syncCommits;
            public boolean disableTXBatching;
            public boolean skipLocks;
            public Timestamp connectionBeginTimeStamp;
            public String currentStatementUUID;
            public String currentStatement;
            public String currentStatementStatus;
            public long currentStatementElapsedTime;
            public long currentStatementAccessFrequency;
            public long currentStatementEstimatedMemUsage;
        }
    }
}

