/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InitialImageFlowControl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.Oplog;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.persistence.DiskRegionView;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionVector;
import com.gemstone.gemfire.internal.shared.Version;
import com.gemstone.gnu.trove.TLongHashSet;
import com.gemstone.gnu.trove.TObjectIntHashMap;
import com.gemstone.gnu.trove.TObjectIntProcedure;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.ddl.DDLConflatable;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLRegionQueue;
import com.pivotal.gemfirexd.internal.engine.ddl.catalog.messages.GfxdSystemProcedureMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdReadWriteLock;
import com.pivotal.gemfirexd.internal.engine.locks.impl.GfxdReentrantReadWriteLock;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.GfxdDataDictionary;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GfxdDDLRegion
extends DistributedRegion {
    private final GfxdDDLRegionQueue queue;
    private final GfxdReadWriteLock conflationLock;
    private final Object preInitSync;
    private boolean preInitDone;
    public static final int DDL_REGION_UUID_RECORD_INTERVAL = 4;
    private final transient TLongHashSet olderIndexes;
    private TLongHashSet conflatedDDLIds = new TLongHashSet();

    private GfxdDDLRegion(GfxdDDLRegionQueue queue, String regionName, RegionAttributes<Long, RegionValue> attrs, LocalRegion parentRegion, GemFireCacheImpl cache, InternalRegionArguments internalRegionArgs) {
        super(regionName, attrs, parentRegion, cache, internalRegionArgs);
        this.queue = queue;
        this.conflationLock = new GfxdReentrantReadWriteLock("GfxdDDLRegion.Conflation", false);
        this.preInitSync = new Object();
        this.preInitDone = false;
        this.olderIndexes = new TLongHashSet();
    }

    public static GfxdDDLRegion createInstance(GfxdDDLRegionQueue queue, GemFireCacheImpl cache, String regionName, CacheListener<Long, RegionValue> listener, boolean persistDD, String persistentDir) throws TimeoutException, RegionExistsException, IOException, ClassNotFoundException {
        assert (regionName != null) : "expected the regionName to be non-null";
        AttributesFactory afact = new AttributesFactory();
        afact.setScope(Scope.DISTRIBUTED_ACK);
        afact.setInitialCapacity(1000);
        afact.setConcurrencyChecksEnabled(false);
        if (persistDD) {
            persistentDir = persistentDir == null || persistentDir.length() == 0 ? "." + File.separatorChar + "datadictionary" : persistentDir + File.separatorChar + "datadictionary";
            DiskStoreFactory dsf = cache.createDiskStoreFactory();
            File[] diskDirs = new File[]{new File(persistentDir)};
            if (!diskDirs[0].mkdirs() && !diskDirs[0].isDirectory()) {
                throw new DiskAccessException("Could not create directory for persistence of system tables: " + diskDirs[0].getAbsolutePath(), (Region)null);
            }
            dsf.setDiskDirs(diskDirs);
            if (DiskStoreFactory.DEFAULT_MAX_OPLOG_SIZE < 10L) {
                dsf.setMaxOplogSize(DiskStoreFactory.DEFAULT_MAX_OPLOG_SIZE);
            } else {
                dsf.setMaxOplogSize(10L);
            }
            dsf.setSyncWrites(true);
            DiskStoreImpl dsImpl = (DiskStoreImpl)dsf.create("GFXD-DD-DISKSTORE");
            dsImpl.setUsedForInternalUse();
            afact.setDiskSynchronous(true);
            afact.setDiskStoreName("GFXD-DD-DISKSTORE");
            afact.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
            afact.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)1, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        } else {
            afact.setDataPolicy(DataPolicy.REPLICATE);
        }
        if (listener != null) {
            afact.addCacheListener(listener);
        }
        InternalRegionArguments internalRegionArgs = new InternalRegionArguments().setDestroyLockFlag(true).setRecreateFlag(false).setSnapshotInputStream(null).setImageTarget(null).setIsUsedForMetaRegion(true).setIsUsedForPartitionedRegionAdmin(false).setUUIDRecordInterval(4);
        GfxdDDLRegion region = new GfxdDDLRegion(queue, regionName, (RegionAttributes<Long, RegionValue>)afact.create(), null, cache, internalRegionArgs);
        return (GfxdDDLRegion)cache.createVMRegion(regionName, afact.create(), internalRegionArgs.setInternalMetaRegion((LocalRegion)region));
    }

    protected void preGetInitialImage() {
        DiskStoreImpl dsi;
        if (GemFireXDUtils.TracePersistIndex) {
            GfxdIndexManager.traceIndex("GfxdDDLRegion::preGetInitialImage called", new Object[0]);
        }
        if ((dsi = this.getDiskStore()) == null) {
            this.endPreInit();
            return;
        }
        boolean usingPre11Schema = false;
        for (Oplog oplog : dsi.getPersistentOplogSet((DiskRegionView)this.getDiskRegion()).getAllOplogs()) {
            Version version = oplog.getDataVersionIfOld();
            if (version == null || Version.SQLF_1099.compareTo(version) <= 0) continue;
            usingPre11Schema = true;
            break;
        }
        if (usingPre11Schema) {
            TObjectIntHashMap pre11TableSchemaVer = new TObjectIntHashMap();
            Pattern addDropColSearch = Pattern.compile("\\s+(ADD|DROP)\\s+(\\w+)", 42);
            for (RegionEntry entry : this.entries.regionEntries()) {
                Object[] params;
                String key;
                GfxdSystemProcedureMessage msg;
                if (entry.isDestroyedOrRemoved()) continue;
                Object value = ((RegionValue)entry.getValue((RegionEntryContext)this)).getValue();
                if (value instanceof DDLConflatable) {
                    String fullTableName;
                    DDLConflatable ddl = (DDLConflatable)value;
                    if (GemFireXDUtils.TracePersistIndex) {
                        GfxdIndexManager.traceIndex("GfxdDDLRegion::preGetInitialImage ddl: " + ddl + " is index: " + ddl.isCreateIndex(), new Object[0]);
                    }
                    if (ddl.isCreateTable()) {
                        fullTableName = ddl.getRegionToConflate();
                        if (pre11TableSchemaVer.containsKey((Object)fullTableName)) continue;
                        pre11TableSchemaVer.put((Object)fullTableName, 1);
                        continue;
                    }
                    if (ddl.isAlterTable()) {
                        String alterToken;
                        String alterText = ddl.getValueToConflate();
                        Matcher match = addDropColSearch.matcher(alterText);
                        if (!match.find() || (alterToken = match.group(2)) != null && !alterToken.equalsIgnoreCase("COLUMN") && (alterToken.equalsIgnoreCase("CONSTRAINT") || alterToken.equalsIgnoreCase("PRIMARY") || alterToken.equalsIgnoreCase("UNIQUE") || alterToken.equalsIgnoreCase("FOREIGN") || alterToken.equalsIgnoreCase("CHECK"))) continue;
                        fullTableName = ddl.getRegionToConflate();
                        int schemaVersion = pre11TableSchemaVer.get((Object)fullTableName);
                        if (schemaVersion > 0) {
                            pre11TableSchemaVer.put((Object)fullTableName, schemaVersion + 1);
                            continue;
                        }
                        pre11TableSchemaVer.put((Object)fullTableName, 2);
                        continue;
                    }
                    if (!ddl.isCreateIndex()) continue;
                    String indexName = ddl.getKeyToConflate();
                    if (GemFireXDUtils.TracePersistIndex) {
                        GfxdIndexManager.traceIndex("GfxdDDLRegion::preGetInitialImage usingPre11Schema adding index: " + indexName + " with ddlId: " + ddl.getId() + " to older indexes list", new Object[0]);
                    }
                    this.olderIndexes.add(ddl.getId());
                    continue;
                }
                if (!(value instanceof GfxdSystemProcedureMessage) || (msg = (GfxdSystemProcedureMessage)value).getSysProcMethod() != GfxdSystemProcedureMessage.SysProcMethod.setDatabaseProperty || (key = (String)(params = msg.getParameters())[0]) == null || !key.startsWith("PRE11_RECOVERY_SCHEMA_VERSION_")) continue;
                pre11TableSchemaVer.clear();
                break;
            }
            if (pre11TableSchemaVer.size() > 0) {
                pre11TableSchemaVer.forEachEntry(new TObjectIntProcedure(){

                    public boolean execute(Object table, int schemaVersion) {
                        LogWriter logger = GfxdDDLRegion.this.getLogWriterI18n().convertToLogWriter();
                        if (logger.infoEnabled()) {
                            logger.info("DDL recovery: persisting schema version for pre 1.1 data to " + schemaVersion + " for table " + table);
                        }
                        GfxdSystemProcedureMessage msg = new GfxdSystemProcedureMessage(GfxdSystemProcedureMessage.SysProcMethod.setDatabaseProperty, new Object[]{"PRE11_RECOVERY_SCHEMA_VERSION_" + table, Integer.toString(schemaVersion)}, null, 1L, 1L, null);
                        EntryEventImpl event = GfxdDDLRegion.this.newUpdateEntryEvent(GfxdDDLRegion.this.newUUID(true), new RegionValue(msg, 1L), null);
                        event.setSkipDistributionOps();
                        GfxdDDLRegion.this.validatedPut(event, CachePerfStats.getStatTime());
                        return true;
                    }
                });
            }
        } else {
            if (GemFireXDUtils.TracePersistIndex) {
                GfxdIndexManager.traceIndex("GfxdDDLRegion::preGetInitialImage not using pre11 schema", new Object[0]);
            }
            for (RegionEntry entry : this.entries.regionEntries()) {
                DDLConflatable ddl;
                Object value;
                if (entry.isDestroyedOrRemoved() || !(entry.getKeyCopy() instanceof Long) || !((value = ((RegionValue)entry.getValue((RegionEntryContext)this)).getValue()) instanceof DDLConflatable) || !(ddl = (DDLConflatable)value).isCreateIndex()) continue;
                String indexName = ddl.getKeyToConflate();
                if (GemFireXDUtils.TracePersistIndex) {
                    GfxdIndexManager.traceIndex("GfxdDDLRegion::preGetInitialImage adding index: " + indexName + " to older indexes list", new Object[0]);
                }
                this.olderIndexes.add(ddl.getId());
            }
        }
        this.endPreInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endPreInit() {
        Object object = this.preInitSync;
        synchronized (object) {
            this.preInitDone = true;
            this.preInitSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForPreInit(long waitMillis) throws InterruptedException {
        Object object = this.preInitSync;
        synchronized (object) {
            if (!this.preInitDone) {
                if (waitMillis <= 0L) {
                    waitMillis = Integer.MAX_VALUE;
                }
                this.preInitSync.wait(waitMillis);
                return this.preInitDone;
            }
            return true;
        }
    }

    public TLongHashSet getOlderIndexes() {
        return this.olderIndexes;
    }

    protected void checkIfReplicatedAndLocalDestroy(EntryEventImpl event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean chunkEntries(InternalDistributedMember sender, int CHUNK_SIZE_IN_BYTES, boolean includeValues, RegionVersionVector versionVector, HashSet unfinishedKeys, boolean unfinishedKeysOnly, InitialImageFlowControl flowControl, TObjectIntProcedure proc) throws IOException {
        if (GemFireXDUtils.TraceConflation) {
            SanityManager.DEBUG_PRINT((String)"TraceConflation", (String)("GfxdDDLRegion#chunkEntries: starting wait on conflation and DD read lock with chunkSize=" + CHUNK_SIZE_IN_BYTES));
        }
        GfxdDataDictionary dd = Misc.getMemStore().getDatabase().getDataDictionary();
        boolean lockedForConflation = false;
        if (dd != null) {
            dd.lockForReadingRT(null);
        }
        try {
            this.lockForConflation(false);
            lockedForConflation = true;
            if (GemFireXDUtils.TraceConflation) {
                SanityManager.DEBUG_PRINT((String)"TraceConflation", (String)("GfxdDDLRegion#chunkEntries: done wait on conflation and DD read lock with chunkSize=" + CHUNK_SIZE_IN_BYTES));
            }
            boolean bl = super.chunkEntries(sender, CHUNK_SIZE_IN_BYTES, includeValues, versionVector, unfinishedKeys, unfinishedKeysOnly, flowControl, proc);
            return bl;
        }
        finally {
            if (lockedForConflation) {
                this.unlockForConflation(false);
            }
            if (dd != null) {
                dd.unlockAfterReading(null);
            }
            if (GemFireXDUtils.TraceConflation) {
                SanityManager.DEBUG_PRINT((String)"TraceConflation", (String)("GfxdDDLRegion#chunkEntries: done with getting entries with chunkSize=" + CHUNK_SIZE_IN_BYTES));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean virtualPut(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) throws TimeoutException, CacheWriterException {
        Object key;
        boolean isRemote;
        if (GemFireXDUtils.TraceDDLQueue) {
            SanityManager.DEBUG_PRINT((String)"TraceDDLQueue", (String)("GfxdDDLRegion#virtualPut: putting new event " + event));
        }
        boolean result = super.virtualPut(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed);
        Operation op = event.getOperation();
        boolean bl = isRemote = event.isOriginRemote() || op.isNetSearch();
        if (isRemote && (key = event.getKey()) instanceof Long) {
            Long ddlQueueId = (Long)key;
            RegionValue regionVal = (RegionValue)event.getNewValue();
            if (op.isCreate() || !result) {
                if (GemFireXDUtils.TraceDDLQueue) {
                    SanityManager.DEBUG_PRINT((String)"TraceDDLQueue", (String)("GfxdDDLRegion#virtualPut: adding event to queue " + event));
                }
                GfxdDDLRegionQueue.QueueValue qVal = new GfxdDDLRegionQueue.QueueValue(ddlQueueId, regionVal);
                GemFireStore memStore = Misc.getMemStore();
                memStore.acquireDDLReplayLock(false);
                this.queue.lockQueue(true);
                try {
                    if (this.queue.isInitialized()) {
                        ArrayList<GfxdDDLRegionQueue.QueueValue> conflatedItems = new ArrayList<GfxdDDLRegionQueue.QueueValue>(5);
                        this.queue.addToQueue(qVal, true, conflatedItems);
                        this.doConflate(conflatedItems, ddlQueueId);
                    } else {
                        this.queue.addToQueue(qVal, false, null);
                    }
                }
                finally {
                    this.queue.unlockQueue(true);
                    memStore.releaseDDLReplayLock(false);
                }
            }
        }
        return result;
    }

    protected void distributeUpdate(EntryEventImpl event, long lastModified) {
        if (!event.getSkipDistributionOps()) {
            super.distributeUpdate(event, lastModified);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void basicDestroy(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws EntryNotFoundException, CacheWriterException, TimeoutException {
        Object key;
        if (GemFireXDUtils.TraceDDLQueue) {
            SanityManager.DEBUG_PRINT((String)"TraceDDLQueue", (String)("GfxdDDLRegion#basicDestroy: destroying for event " + event));
        }
        super.basicDestroy(event, cacheWrite, expectedOldValue);
        if ((event.isOriginRemote() || event.getOperation().isNetSearch()) && (key = event.getKey()) instanceof Long) {
            RegionValue val = (RegionValue)event.getOldValue();
            this.queue.lockQueue(true);
            try {
                this.queue.removeFromQueue(new GfxdDDLRegionQueue.QueueValue((Long)key, val));
            }
            finally {
                this.queue.unlockQueue(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doConflate(List<GfxdDDLRegionQueue.QueueValue> conflateItems, Long currentKey) {
        if (conflateItems != null && conflateItems.size() > 0) {
            boolean doLog = GemFireXDUtils.TraceConflation | DistributionManager.VERBOSE;
            this.lockForConflation(true);
            try {
                for (GfxdDDLRegionQueue.QueueValue val : conflateItems) {
                    if (doLog) {
                        SanityManager.DEBUG_PRINT((String)"TraceConflation", (String)("GfxdDDLRegion: conflating entry {key=" + val.getKey() + ", value=" + val.getValue() + "} from region for key " + currentKey));
                    }
                    this.conflatedDDLIds.add(val.getKey().longValue());
                    try {
                        this.localDestroy(val.getKey());
                    }
                    catch (EntryNotFoundException ex) {
                        if (!doLog) continue;
                        SanityManager.DEBUG_PRINT((String)"TraceConflation", (String)("GfxdDDLRegion#doConflate: got EntryNotFoundException for key " + val.getKey() + " in region"));
                    }
                }
            }
            finally {
                this.unlockForConflation(true);
            }
        }
    }

    public TLongHashSet getConflatedDDLIds() {
        return this.conflatedDDLIds;
    }

    final void lockForConflation(boolean exclusive) {
        GfxdDDLRegion.acquireLock(this.conflationLock, exclusive, this);
    }

    final void unlockForConflation(boolean exclusive) {
        GfxdDDLRegion.releaseLock(this.conflationLock, exclusive);
    }

    final GfxdDDLRegionQueue getDDLQueue() {
        return this.queue;
    }

    static final void acquireLock(GfxdReadWriteLock rwLock, boolean exclusive, GfxdDDLRegion region) {
        Thread owner = Thread.currentThread();
        if (exclusive) {
            rwLock.attemptWriteLock(-1L, owner);
        } else {
            rwLock.attemptReadLock(-1L, owner);
        }
    }

    static final void releaseLock(GfxdReadWriteLock rwLock, boolean exclusive) {
        if (exclusive) {
            rwLock.releaseWriteLock(Thread.currentThread());
        } else {
            rwLock.releaseReadLock();
        }
    }

    public static final class RegionValue
    extends GfxdDataSerializable {
        private Object value;
        long sequenceId;

        public RegionValue() {
        }

        RegionValue(Object value, long sequenceId) {
            this.value = value;
            this.sequenceId = sequenceId;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public byte getGfxdID() {
            return 80;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject((Object)this.value, (DataOutput)out);
            out.writeLong(this.sequenceId);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.value = DataSerializer.readObject((DataInput)in);
            this.sequenceId = in.readLong();
        }

        public String toString() {
            return this.value + " [sequence: " + this.sequenceId + "]";
        }
    }
}

