/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.operations;

import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreImpl;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemOperation;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.IOException;

public class HDFSStoreDropOperation
extends MemOperation {
    private String storeName;

    protected HDFSStoreDropOperation(String storeName) {
        super(null);
        this.storeName = storeName;
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        this.storeName = SharedUtils.SQLToUpperCase((String)this.storeName);
        HDFSStoreImpl store = Misc.getGemFireCache().findHDFSStore(this.storeName);
        try {
            if (store != null) {
                Misc.getGemFireCache().removeHDFSStore(store);
            }
        }
        catch (Exception e) {
            SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)"DropHDFSStore :: got Exception", (Throwable)e);
        }
        SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("HDFSStoreDropOperation :: removed HDFSStore " + this.storeName + "."));
    }

    @Override
    public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        throw new UnsupportedOperationException("HDFSStoreDropOperation: undo unimplemented; require GFE HDFSStore rename support");
    }
}

