/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.Formatable;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyFactory;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.AccessFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RawStoreFactory;
import java.io.Serializable;
import java.util.Properties;

public final class PropertyConglomerate {
    protected final Properties serviceProperties;
    protected final Properties servicePropertiesDefaults;
    private final PropertyFactory pf;

    public PropertyConglomerate(TransactionController tc, boolean create, Properties serviceProperties, Properties servicePropertiesDefaults, PropertyFactory pf) throws StandardException {
        this.pf = pf;
        this.serviceProperties = serviceProperties;
        this.servicePropertiesDefaults = servicePropertiesDefaults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyDefault(TransactionController tc, String key, Serializable value) throws StandardException {
        Serializable valueToSave = null;
        if (this.propertyDefaultIsVisible(key)) {
            valueToSave = this.validateApplyAndMap(tc, key, value, false);
        } else {
            PropertyConglomerate propertyConglomerate = this;
            synchronized (propertyConglomerate) {
                this.validate(key, value, this.servicePropertiesDefaults);
                valueToSave = this.map(key, value, this.servicePropertiesDefaults);
            }
        }
        this.savePropertyDefault(tc, key, valueToSave);
    }

    public final boolean propertyDefaultIsVisible(String key) throws StandardException {
        return !this.serviceProperties.containsKey(key);
    }

    void saveProperty(TransactionController tc, String key, Serializable value) throws StandardException {
        this.saveServiceProperty(this.serviceProperties, key, value);
    }

    private void saveServiceProperty(Properties props, String key, Serializable value) {
        if (value != null) {
            props.put(key, value);
        } else {
            props.remove(key);
        }
    }

    void savePropertyDefault(TransactionController tc, String key, Serializable value) throws StandardException {
        this.saveServiceProperty(this.servicePropertiesDefaults, key, value);
    }

    private Serializable validateApplyAndMap(TransactionController tc, String key, Serializable value, boolean dbOnlyProperty) throws StandardException {
        Serializable mappedValue = this.pf.doValidateApplyAndMap(tc, key, value, this.serviceProperties, dbOnlyProperty);
        if (mappedValue == null) {
            return value;
        }
        return mappedValue;
    }

    private Serializable map(String key, Serializable value, Properties set) throws StandardException {
        return this.pf.doMap(key, value, set);
    }

    private void validate(String key, Serializable value, Properties set) throws StandardException {
        this.pf.validateSingleProperty(key, value, set);
    }

    private boolean bootPasswordChange(TransactionController tc, String key, Serializable value) throws StandardException {
        if (key.equals("bootPassword")) {
            AccessFactory af = ((TransactionManager)tc).getAccessManager();
            RawStoreFactory rsf = (RawStoreFactory)Monitor.findServiceModule(af, "com.pivotal.gemfirexd.internal.iapi.store.raw.RawStoreFactory");
            this.serviceProperties.remove("bootPassword");
            value = rsf.changeBootPassword(this.serviceProperties, value);
            this.serviceProperties.put("encryptedBootPassword", value);
            return true;
        }
        return false;
    }

    public void setProperty(TransactionController tc, String key, Serializable value, boolean dbOnlyProperty) throws StandardException {
        if (value != null && !(value instanceof Formatable) && !value.getClass().getName().startsWith("java.")) {
            SanityManager.THROWASSERT((String)("Non-formattable, non-java class - " + value.getClass().getName()));
        }
        Serializable valueToValidateAndApply = value;
        if (value == null) {
            valueToValidateAndApply = this.getPropertyDefault(key);
        }
        Serializable valueToSave = this.validateApplyAndMap(tc, key, valueToValidateAndApply, dbOnlyProperty);
        if (this.bootPasswordChange(tc, key, value)) {
            return;
        }
        if (value == null) {
            this.saveProperty(tc, key, null);
        } else {
            this.saveProperty(tc, key, valueToSave);
        }
    }

    public final Serializable getProperty(String key) throws StandardException {
        return (Serializable)this.serviceProperties.get(key);
    }

    public final Serializable getPropertyDefault(String key) throws StandardException {
        return (Serializable)this.servicePropertiesDefaults.get(key);
    }

    public final Properties getProperties() {
        return (Properties)this.serviceProperties.clone();
    }
}

