/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access;

import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextImpl;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;

public final class GemFireTransactionContext
extends ContextImpl {
    private final GemFireTransaction transaction;
    private boolean abortAll;

    GemFireTransactionContext(ContextManager cm, String context_id, GemFireTransaction theTransaction, boolean abortAll) throws StandardException {
        super(cm, context_id);
        assert (theTransaction != null);
        this.abortAll = abortAll;
        this.transaction = theTransaction;
    }

    @Override
    public void cleanupOnError(Throwable error) throws StandardException {
        SanityManager.ASSERT((this.getContextManager() != null ? 1 : 0) != 0);
        boolean destroy = false;
        if (error instanceof StandardException) {
            StandardException se = (StandardException)error;
            if (se.getSeverity() < 30000) {
                return;
            }
            if (se.getSeverity() >= 40000) {
                destroy = true;
            }
        } else {
            destroy = true;
        }
        LanguageConnectionContext lcc = this.transaction.getLanguageConnectionContext();
        if (lcc == null || lcc.getParentOfNestedTransactionExecute() == null) {
            this.transaction.abort();
        }
        if (destroy) {
            this.transaction.clean();
            this.popMe();
        }
    }

    public GemFireTransaction getTransaction() {
        return this.transaction;
    }

    void reset(String contextId, boolean abortAll) {
        this.myIdName = contextId;
        this.abortAll = abortAll;
    }
}

