/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.diag;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import com.pivotal.gemfirexd.internal.vti.VTICosting;
import com.pivotal.gemfirexd.internal.vti.VTIEnvironment;
import com.pivotal.gemfirexd.internal.vti.VTITemplate;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;

public final class ErrorMessages
extends VTITemplate
implements VTICosting,
PrivilegedAction {
    private Properties p;
    private Enumeration keys;
    private String k;
    private String SQLState;
    private String message;
    private int severity;
    private int msgFile;
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("SQL_STATE", 12, true, 5), EmbedResultSetMetaData.getResultColumnDescriptor("MESSAGE", 12, true, 32672), EmbedResultSetMetaData.getResultColumnDescriptor("SEVERITY", 4, true)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    public ErrorMessages() throws IOException {
        this.loadProperties();
    }

    @Override
    public boolean next() {
        boolean retCode = true;
        if (!this.keys.hasMoreElements()) {
            this.close();
            retCode = false;
            return retCode;
        }
        this.k = (String)this.keys.nextElement();
        if (this.notAnException()) {
            retCode = this.next();
        }
        if (retCode) {
            this.SQLState = StandardException.getSQLStateFromIdentifier(this.k);
            this.message = MessageService.getTextMessage(this.k);
            this.message = StringUtil.truncate(this.message, 32672);
        }
        return retCode;
    }

    @Override
    public void close() {
        this.p = null;
        this.k = null;
        this.keys = null;
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return metadata;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        switch (columnIndex) {
            case 1: {
                return this.SQLState;
            }
            case 2: {
                return this.message;
            }
        }
        return super.getString(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        switch (columnIndex) {
            case 3: {
                return this.severity;
            }
        }
        return super.getInt(columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() throws IOException {
        this.p = new Properties();
        for (int i = 0; i < 50; ++i) {
            this.msgFile = i;
            InputStream is = (InputStream)AccessController.doPrivileged(this);
            if (is == null) continue;
            try {
                this.p.load(is);
                continue;
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.keys = this.p.keys();
    }

    private boolean notAnException() {
        if (this.k.length() < 5) {
            return true;
        }
        int tempSeverity = StandardException.getSeverityFromIdentifier(this.k);
        if (tempSeverity < 1) {
            return true;
        }
        this.severity = tempSeverity;
        return false;
    }

    @Override
    public double getEstimatedRowCount(VTIEnvironment vtiEnvironment) {
        return 1000.0;
    }

    @Override
    public double getEstimatedCostPerInstantiation(VTIEnvironment vtiEnvironment) {
        return 5000.0;
    }

    @Override
    public boolean supportsMultipleInstantiations(VTIEnvironment vtiEnvironment) {
        return true;
    }

    public final Object run() {
        InputStream msg = this.getClass().getResourceAsStream("/com/pivotal/gemfirexd/internal/loc/m" + this.msgFile + "_en.properties");
        this.msgFile = 0;
        return msg;
    }
}

