/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.catalog.types;

import com.pivotal.gemfirexd.internal.catalog.TypeDescriptor;
import com.pivotal.gemfirexd.internal.catalog.types.BaseTypeIdImpl;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class RowMultiSetImpl
extends BaseTypeIdImpl {
    private String[] _columnNames;
    private TypeDescriptor[] _types;

    public RowMultiSetImpl() {
    }

    public RowMultiSetImpl(String[] columnNames, TypeDescriptor[] types) {
        this._columnNames = columnNames;
        this._types = types;
        if (columnNames == null || types == null || columnNames.length != types.length) {
            throw new IllegalArgumentException("Bad args: columnNames = " + columnNames + ". types = " + types);
        }
    }

    public String[] getColumnNames() {
        return this._columnNames;
    }

    public TypeDescriptor[] getTypes() {
        return this._types;
    }

    @Override
    public String getSQLTypeName() {
        StringBuilder buffer = new StringBuilder();
        int count = this._columnNames.length;
        buffer.append("TABLE ( ");
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append('\"');
            buffer.append(this._columnNames[i]);
            buffer.append('\"');
            buffer.append(' ');
            buffer.append(this._types[i].getSQLstring());
        }
        buffer.append(" )");
        return buffer.toString();
    }

    @Override
    public int getJDBCTypeId() {
        return 1111;
    }

    @Override
    public int getTypeFormatId() {
        return 469;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        int count = in.readInt();
        this._columnNames = new String[count];
        this._types = new TypeDescriptor[count];
        for (i = 0; i < count; ++i) {
            this._columnNames[i] = in.readUTF();
        }
        for (i = 0; i < count; ++i) {
            this._types[i] = (TypeDescriptor)in.readObject();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        int count = this._columnNames.length;
        out.writeInt(count);
        for (i = 0; i < count; ++i) {
            out.writeUTF(this._columnNames[i]);
        }
        for (i = 0; i < count; ++i) {
            out.writeObject(this._types[i]);
        }
    }
}

