/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.callbacks.impl;

import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.TimestampedEntryEventImpl;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.callbacks.TableMetaData;
import com.pivotal.gemfirexd.callbacks.impl.GatewayConflictResolverWrapper;
import com.pivotal.gemfirexd.callbacks.impl.GatewayEvent;
import com.pivotal.gemfirexd.internal.engine.ddl.EventImpl;
import java.sql.ResultSet;

public class GatewayEventImpl
implements GatewayEvent {
    private TimestampedEntryEventImpl entryEvent;
    private EventImpl eventImpl;
    private GatewayEvent.GatewayEventType type;

    public GatewayEventImpl(TimestampedEntryEventImpl entryEvent) {
        this.entryEvent = entryEvent;
        Event.Type eventType = null;
        Operation op = entryEvent.getOperation();
        if (op.equals(Operation.CREATE)) {
            eventType = Event.Type.AFTER_INSERT;
            this.type = GatewayEvent.GatewayEventType.INSERT;
        } else if (op.equals(Operation.UPDATE)) {
            eventType = Event.Type.AFTER_UPDATE;
            this.type = GatewayEvent.GatewayEventType.UPDATE;
        } else if (op.equals(Operation.DESTROY)) {
            eventType = Event.Type.AFTER_DELETE;
            this.type = GatewayEvent.GatewayEventType.DELETE;
        } else {
            throw new AssertionError((Object)("Unexpected operation type " + op + " for gateway event: " + entryEvent));
        }
        this.eventImpl = new EventImpl((EntryEventImpl)entryEvent, eventType);
    }

    public TimestampedEntryEventImpl getEntryEvent() {
        return this.entryEvent;
    }

    public EventImpl getEventImpl() {
        return this.eventImpl;
    }

    @Override
    public int getNewDistributedSystemID() {
        return this.entryEvent.getNewDistributedSystemID();
    }

    @Override
    public int getOldDistributedSystemID() {
        return this.entryEvent.getOldDistributedSystemID();
    }

    @Override
    public long getNewTimestamp() {
        return this.entryEvent.getNewTimestamp();
    }

    @Override
    public long getOldTimestamp() {
        return this.entryEvent.getOldTimestamp();
    }

    @Override
    public GatewayEvent.GatewayEventType getType() {
        return this.type;
    }

    @Override
    public ResultSet getNewRow() {
        return this.eventImpl.getNewRowsAsResultSet();
    }

    @Override
    public int[] getModifiedColumns() {
        return this.eventImpl.getModifiedColumns();
    }

    @Override
    public ResultSet getOldRow() {
        return this.eventImpl.getOldRowAsResultSet();
    }

    @Override
    public TableMetaData getTableMetaData() {
        return this.eventImpl.getResultSetMetaData();
    }

    @Override
    public String getSchemaName() {
        return this.eventImpl.getSchemaName();
    }

    @Override
    public String getTableName() {
        return this.eventImpl.getTableName();
    }

    @Override
    public ResultSet getPrimaryKeys() {
        return this.eventImpl.getPrimaryKeysAsResultSet();
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    public String toString() {
        return this.entryEvent.toString() + ",GatewayEventType=" + (Object)((Object)this.type);
    }

    public static void dummy() {
        GatewayConflictResolverWrapper.dummy();
    }
}

