/* SQLParser.java */
/* Generated By:JavaCC: Do not edit this line. SQLParser.java */
/*

   Derby - File com.pivotal.gemfirexd.internal.impl.sql.compile.sqlgrammar.jj

   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to you under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

*/
/*
 * Fixes and additions for GemFireXD extensions, and to work with
 * GemFireXD distributed data platform.
 *
 * Portions Copyright (c) 2010-2015 Pivotal Software, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You
 * may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License. See accompanying
 * LICENSE file.
 */

package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.sql.Statement;
import com.pivotal.gemfirexd.internal.iapi.sql.StatementType;

/* aggregates */
import com.pivotal.gemfirexd.internal.impl.sql.compile.CountAggregateDefinition;
import com.pivotal.gemfirexd.internal.impl.sql.compile.MaxMinAggregateDefinition;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SumAvgAggregateDefinition;

import com.pivotal.gemfirexd.internal.impl.sql.compile.AggregateNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CallStatementNode;
import  com.pivotal.gemfirexd.internal.impl.sql.compile.CharConstantNode;
import  com.pivotal.gemfirexd.internal.impl.sql.compile.CastNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnDefinitionNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CursorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromSubquery;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.HasNodeVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JavaToSQLValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JoinNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.MethodCallNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ReplaceAggregatesWithCRVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrderByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrderByColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SelectNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TernaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ParameterNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PrivilegeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstraintDefinitionNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DMLModStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RoutineDesignator;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableElementList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableElementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TablePrivilegesNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TransactionStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TriggerReferencingStruct;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnionNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.IntersectOrExceptNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UntypedNullConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UpdateNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UserTypeConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNodeList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CurrentDatetimeOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AlterTableNode;

import com.pivotal.gemfirexd.internal.impl.sql.compile.ParseException;
import com.pivotal.gemfirexd.internal.impl.sql.compile.Token;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TokenMgrError;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SQLParserConstants;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CharStream;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TablePrivilegeInfo;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TriggerDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ViewDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;

import com.pivotal.gemfirexd.internal.iapi.sql.conn.Authorizer;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionContext;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;

import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.TypeCompiler;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;

import com.pivotal.gemfirexd.internal.iapi.types.DateTimeDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeUtilities;
import com.pivotal.gemfirexd.internal.iapi.types.StringDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.TypeCompilerFactory;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;

import com.pivotal.gemfirexd.internal.iapi.reference.Property;
import com.pivotal.gemfirexd.internal.iapi.reference.SQLState;
import com.pivotal.gemfirexd.internal.iapi.reference.JDBC30Translation;
import com.pivotal.gemfirexd.internal.iapi.reference.JDBC40Translation;
import com.pivotal.gemfirexd.internal.iapi.reference.Limits;

import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.C_NodeTypes;

import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;

import com.pivotal.gemfirexd.internal.iapi.sql.compile.NodeFactory;

import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;

import com.pivotal.gemfirexd.internal.catalog.AliasInfo;
import com.pivotal.gemfirexd.internal.catalog.TypeDescriptor;
import com.pivotal.gemfirexd.internal.catalog.types.RoutineAliasInfo;

import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableProperties;
//import com.pivotal.gemfirexd.internal.iapi.services.io.StoredFormatIds;
import com.pivotal.gemfirexd.internal.shared.common.StoredFormatIds;
import com.pivotal.gemfirexd.internal.iapi.util.ReuseFactory;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;

import java.sql.Types;
import java.util.List;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.lang.Character;
import java.lang.UnsupportedOperationException;

// GemStone changes BEGIN
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.Iterator;


import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.DataPolicy;

import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;

import com.pivotal.gemfirexd.Constants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.ddl.EvictionTableAttribute;
import com.pivotal.gemfirexd.internal.engine.ddl.InitSizeTableAttribute;
import com.pivotal.gemfirexd.internal.engine.ddl.ServerGroupsTableAttribute;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdEvictionCriteria;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdAttributesMutator;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdRangePartitionResolver;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionByExpressionResolver;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdListPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.engine.sql.compile.DistributionDefinitionNode;
import com.pivotal.gemfirexd.internal.engine.sql.compile.ParameterizedConstantNode;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.engine.procedure.coordinate.DistributedProcedureCallNode;
import com.pivotal.gemfirexd.internal.engine.procedure.coordinate.ProcedureProcessorNode;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
// GemStone changes END

public class SQLParser implements SQLParserConstants {
        private static final String[] SAVEPOINT_CLAUSE_NAMES = {"UNIQUE", "ON ROLLBACK RETAIN LOCKS", "ON ROLLBACK RETAIN CURSORS"};
        private static final String[] ROUTINE_CLAUSE_NAMES =
                {null, "SPECIFIC", "RESULT SET", "LANGUAGE", "EXTERNAL NAME", "PARAMETER STYLE", "SQL", "ON NULL INPUT"};
        /**
	   Clauses required for Java routines. Numbers correspond
	   to offsets in ROUTINE_CLAUSE_NAMES.
	   3 - "LANGUAGE"
	   4 - "EXTERNAL NAME"
	   5 - "PARAMETER STYLE"
	*/
        private static final int[] JAVA_ROUTINE_CLAUSES = {3,4,5};
        private static final String[] TEMPORARY_TABLE_CLAUSE_NAMES = {"NOT LOGGED", "ON COMMIT", "ON ROLLBACK"};
        /* The default length of a char or bit if the length is omitted */
        private static final int        DEFAULT_STRING_COLUMN_LENGTH = 1;

        // Defines for ON or USING clauses
        private static final int        ON_OR_USING_CLAUSE_SIZE = 2;
        private static final int        ON_CLAUSE = 0;
        private static final int        USING_CLAUSE = 1;

        // Defines for optional table clauses
        private static final int        OPTIONAL_TABLE_CLAUSES_SIZE = 3;
        private static final int        OPTIONAL_TABLE_CLAUSES_TABLE_PROPERTIES = 0;
        private static final int        OPTIONAL_TABLE_CLAUSES_DERIVED_RCL = 1;
        private static final int        OPTIONAL_TABLE_CLAUSES_CORRELATION_NAME = 2;

        // Define for UTF8 max
        private static final int        MAX_UTF8_LENGTH = 65535;

    // Constants for set operator types
    private static final int NO_SET_OP = 0;
    private static final int UNION_OP = 1;
    private static final int UNION_ALL_OP = 2;
    private static final int EXCEPT_OP = 3;
    private static final int EXCEPT_ALL_OP = 4;
    private static final int INTERSECT_OP = 5;
    private static final int INTERSECT_ALL_OP = 6;

        private Object[]                                        paramDefaults;
        private String                                          statementSQLText;
        private NodeFactory                                     nodeFactory;
        private ContextManager                          cm;
        private CompilerContext                         compilerContext;

        /* The number of the next ? parameter */
        private int                     parameterNumber;

        /* The list of ? parameters */
        private Vector<ValueNode>  parameterList;

        /* Remember if the last identifier or keyword was a
	 * delimited identifier.  This is used for remembering
	 * if the xxx in SERIALIZE(xxx) was a delimited identifier
	 * because we need to know whether or not we can convert
	 * xxx to upper case if we try to resolve it as a class
	 * alias at bind time.
	 */
        private Boolean lastTokenDelimitedIdentifier = Boolean.FALSE;
        private Boolean nextToLastTokenDelimitedIdentifier = Boolean.FALSE;


        /*
	** Remember the last token we got that was an identifier
	*/
        private Token   lastIdentifierToken;
        private Token   nextToLastIdentifierToken;

        static final String SINGLEQUOTES = "\'\'";
        static final String DOUBLEQUOTES = "\"\"";

// GemStone changes BEGIN
    static final String DEFAULT_INDEX_TYPE = GfxdConstants.LOCAL_SORTEDMAP_INDEX_TYPE; //   "BTREE";
    private boolean isPartitionOrColocateWithDefined = false;
    private boolean gfxdSubactivationNeeded = false;
    private ArrayDeque<List<Integer>> subqueryParamCount = null;
    private ArrayDeque<List<ConstantNode>> subqueryParams = null;
    /* The number of the next constant in DML */
    private int         constantNumber = 0;
    String prevDiskStore = null;
    String prevHDFSStore = null;
    String prevPersistenceModeSet = null;
    private Token lookAhead;
    private int expirationFlag = 0;    // 1, 2, 3, 4 depending on expiration choice (non-repeating but not mutually exclusive)
    private int evictionChoice = 0;    // 0 for no eviction, 1 for some eviction clause (clauses are mutually exclusive)
// GemStone Changes END

        //the following 2 booleans are used to make sure only null or not null is
        //defined for a column while creating a table or altering a table. Defining
        //both at the same time will be an error case.
        //Also used to check if NULL is specified twice or NOT NULL specified twice
        boolean explicitNotNull = false;
        boolean explicitNull = false;

        //this vector keeps a list of explicitly nullable columns, so that if they
        //get used in the table level primary key constraint, it will result in an
        //exception.	
        Vector explicitlyNullableColumnsList = new Vector();


        final void setCompilerContext(CompilerContext cc) {
                this.compilerContext = cc;
                this.cm = cc.getContextManager();
        }
// GemStone changes BEGIN

    // Helper function to add a key/value to a Map object but
    // throw exception if key already set
    // Used to disallow multiple uses of same keyword/value setting
    final void addToMapAllowOnce(Map map, Object key, Object value) throws StandardException
    {
      if (map.put(key, value) != null)
          {
             // TODO : LANG_DUPLICATE_PROPERTY is not exactly correct, should make
             // new SQLCODE as grammar does not explicitly disallow multiple uses
             // of optional unordered key/value pairs
                 throw StandardException.newException(SQLState.LANG_DUPLICATE_PROPERTY, key);
          }
        }

        final void setGfxdSubactivationFlag(boolean flag) {
                this.gfxdSubactivationNeeded = flag;
        }

        final void setGFAttributes(Properties properties,
                                   AttributesFactory afact,
                                   PartitionAttributesFactory pafact,
                                   DistributionDefinitionNode distributionNode,
                                   boolean[] repPartPersFlags,
                                   boolean isQueryExpressionCase,
                                   TableName tableName,
                                   ServerGroupsTableAttribute serverGroups,
                                   InitSizeTableAttribute initSize) throws StandardException
        {

          String concFlag = System.getProperty(GfxdConstants.TEST_FLAG_ENABLE_CONCURRENCY_CHECKS);
          boolean concChecksFlag = false;
          // [sjigyasu] If test flag is not provided (or is provided and set to true),
          // concChecksFlag becomes true and makes concurrency checks enabled for persistent partitioned tables.
          // If test flag is provided and is set to false, concurrency checks flag is NOT set to true for
          // partitioned tables.
          concChecksFlag = (concFlag == null) || (concFlag != null && (Boolean.valueOf(concFlag) == Boolean.TRUE));

          if (repPartPersFlags[0] && repPartPersFlags[1])
          {
            throw StandardException.newException(SQLState.LANG_INVALID_TABLE_TYPE_DEFINITION);
          }

          if ((!repPartPersFlags[5] && repPartPersFlags[6])) {
            throw StandardException
              .newException(SQLState.EVICTION_BY_CRITERIA_NOT_SUPPORTED_WITH_NON_HDFS_TABLE);
          }
      if ((repPartPersFlags[4] && repPartPersFlags[5])) {
        throw StandardException
          .newException(SQLState.LRU_EVICTION_NOT_SUPPORTED_FOR_HDFS_TABLE);
      }

          RegionAttributes attrs;
          distributionNode.setPersistence(false);
          //TODO:ASIF: TEST HOOK CODE , NEEDS TO BE REMOVED AFTER QA IS OK WITH IT 
          boolean testFlagOffHeap = Boolean.getBoolean("gemfirexd.TEST_FLAG_OFFHEAP_ENABLE");
          String offHeapMemorySize = System.getProperty("gemfire."+DistributionConfig.OFF_HEAP_MEMORY_SIZE_NAME);
          if(offHeapMemorySize == null || offHeapMemorySize.trim().equals("")) {
            offHeapMemorySize = Misc.getGemFireCache().getDistributedSystem().getConfig().getOffHeapMemorySize();
          }
          if ( !(GfxdConstants.SYS_TABLENAME_STRING.equals(tableName.getTableName()) || tableName.getTableName().startsWith("SYS")
           || !testFlagOffHeap  || (offHeapMemorySize == null  || offHeapMemorySize.trim().equals("")) )) {
         afact.setEnableOffHeapMemory(true);
      }

      // set LRU_HEAP eviction for custom EVICTION BY CRITERIA
      if (repPartPersFlags[6] && repPartPersFlags[2]) {
        afact.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(
            ObjectSizer.DEFAULT, EvictionAction.OVERFLOW_TO_DISK));
      }

          //////////////////////////////////////////////
          if (getLanguageConnectionContext().isDefaultPersistent() && !repPartPersFlags[2]) {
            repPartPersFlags[2] = true;
                  afact.setDiskStoreName(GfxdConstants.GFXD_DEFAULT_DISKSTORE_NAME);
          }
          if (repPartPersFlags[1] && repPartPersFlags[2]) {
            afact.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
            distributionNode.setPersistence(true);
            // [sjigyasu] Create versioned region entries for persistent partitioned tables
            if(concChecksFlag) {
                afact.setConcurrencyChecksEnabled(true);
            }
          }
        if (repPartPersFlags[0]) {
          if (repPartPersFlags[2]) {
            // Catch the exception from Gemfire data policy code if
            // This region was already set to PARTITIONED by use of clauses in CREATE TABLE DDL.
            try {
              afact.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
            }
            catch (IllegalArgumentException e)
            {
              throw StandardException.newException(SQLState.LANG_INVALID_TABLE_TYPE_DEFINITION);
            }
            distributionNode.setPersistence(true);
            }
          else {
            // Catch the exception from Gemfire data policy code if
            // This region was already set to PARTITIONED by use of clauses in CREATE TABLE DDL.
            try {
              afact.setDataPolicy(DataPolicy.REPLICATE);
            }
            catch (IllegalArgumentException e)
            {
              throw StandardException.newException(SQLState.LANG_INVALID_TABLE_TYPE_DEFINITION);
            }
            }
            afact.setScope(Scope.DISTRIBUTED_ACK);
            attrs = getAttributesFromFactory(afact);
          }
          //LOCAL clause in create table
          else if (repPartPersFlags[3]) {
          afact.setDataPolicy(DataPolicy.NORMAL);
          afact.setScope(Scope.LOCAL);
          attrs = getAttributesFromFactory(afact);
          }
          // No explicit policy defined. The table can be replicated or
          // partitioned depending on system/boot property.
          else if (!Misc.getMemStore().isTableDefaultPartitioned()
                   && (pafact == null || pafact.create()
                       .getPartitionResolver() == null)) {
            // See if persistence is enabled.
            if (repPartPersFlags[2]) {
              // Catch the exception from Gemfire data policy code if
              // This region was already set to PARTITIONED by use of clauses in CREATE TABLE DDL.
              try {
                afact.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
              }
              catch (IllegalArgumentException e)
              {
                throw StandardException.newException(SQLState.LANG_INVALID_TABLE_TYPE_DEFINITION);
              }
              distributionNode.setPersistence(true);
            }
            else {
              // Catch the exception from Gemfire data policy code if
              // This region was already set to PARTITIONED by use of clauses in CREATE TABLE DDL.
              try {
                afact.setDataPolicy(DataPolicy.REPLICATE);
              }
              catch (IllegalArgumentException e)
              {
                throw StandardException.newException(SQLState.LANG_INVALID_TABLE_TYPE_DEFINITION);
              }
            }
            afact.setScope(Scope.DISTRIBUTED_ACK);
            attrs = getAttributesFromFactory(afact);
          }
          else {
            //HDFS store is set
            if (repPartPersFlags[5]) {
              if (repPartPersFlags[2]) {
                        afact.setDataPolicy(DataPolicy.HDFS_PERSISTENT_PARTITION);
                        distributionNode.setPersistence(true);
                // [sjigyasu] Create versioned region entries for persistent partitioned tables
                if (concChecksFlag) {
                        afact.setConcurrencyChecksEnabled(true);
                }
              }
              else {
                        afact.setDataPolicy(DataPolicy.HDFS_PARTITION);
              }
            } else {
              // See if persistence is enabled.
              if (repPartPersFlags[2]) {
                        afact.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                        distributionNode.setPersistence(true);
                    // [sjigyasu] Create versioned region entries for persistent partitioned tables
                    if (concChecksFlag) {
                        afact.setConcurrencyChecksEnabled(true);
                }
              }
            }
            GfxdPartitionResolver resolver;
            if (!repPartPersFlags[1]) {
             // Create a default partitioned table when neither
                 // REPLICATE nor partitioning has been explicitly specified
                 resolver = new GfxdPartitionByExpressionResolver();
                 TableName colocatedTable =
                   distributionNode.getColocatedTable();
                 if (colocatedTable != null) {
                   resolver.setMasterTable(
                     colocatedTable.getFullTableNameAsRegionPath());
                 }
                 pafact.setPartitionResolver(resolver);
                 afact.setPartitionAttributes(getPartitionAttributesFromFactory(pafact));
                 attrs = getAttributesFromFactory(afact);
           }
           else {
                 afact.setPartitionAttributes(getPartitionAttributesFromFactory(pafact));
                 attrs = getAttributesFromFactory(afact);

                 PartitionAttributes pattrs = attrs.getPartitionAttributes();
                 resolver = (GfxdPartitionResolver)pattrs.getPartitionResolver();
           }
         }


         properties.put(GfxdConstants.REGION_ATTRIBUTES_KEY, attrs);
         String schemaName = tableName.getSchemaName();
         if (schemaName == null || schemaName.length() == 0) {
           schemaName = getLanguageConnectionContext().
            getDefaultSchema().getSchemaName();
         }
         properties.put(GfxdConstants.PROPERTY_SCHEMA_NAME, schemaName);
         properties.put(GfxdConstants.PROPERTY_TABLE_NAME,
         tableName.getTableName());
         if (serverGroups != null) {
           distributionNode.setServerGroups(
           serverGroups.getServerGroupSet());
         }
         if (initSize != null) {
           properties.put(GfxdConstants.REGION_INITSIZE_KEY, initSize);
         }
         distributionNode.setTableProperties(properties);
        }
// GemStone changes END
        /**
	  *	Get the NodeFactory for this database.
	  *
	  *	@return	The NodeFactory for this database.
	  * @exception StandardException		Thrown on error
	  */
        private final NodeFactory       getNodeFactory()        throws StandardException
        {
                if ( nodeFactory == null )
                {
                        nodeFactory = getCompilerContext().getNodeFactory();
                }

                return  nodeFactory;
        }

        private final CompilerContext getCompilerContext()
        {
                return compilerContext;
        }

        private DataTypeDescriptor getDataTypeServices(int type, int precision, int scale,
                        int length)
        throws StandardException
        {
                return new DataTypeDescriptor(
                                        TypeId.getBuiltInTypeId(type),
                                        precision,
                                        scale,
                                        true, /* assume nullable for now, change it if not nullable */
                                        length
                                );
        }

        private DataTypeDescriptor getJavaClassDataTypeDescriptor(TableName typeName)
        throws StandardException
        {
                return new DataTypeDescriptor
            (
                TypeId.getUserDefinedTypeId( typeName.getSchemaName(), typeName.getTableName(), null ),
                true
            );
        }
        private LanguageConnectionContext getLanguageConnectionContext()
        {
                return (LanguageConnectionContext) getContextManager().getContext(
                                                                                LanguageConnectionContext.CONTEXT_ID);
        }

        /**
		Utility method for checking that the underlying database has been
		upgraded to the required level to use this functionality. Used to
		disallow SQL statements that would leave on-disk formats that would
		not be understood by a engine that matches the current upgrade level
		of the database. Throws an exception if the database is not a the required level.
		<P>
		Typically used for CREATE statements at the parser level. Called usually just
		before the node is created, or can be called in just a partial syntax fragment
		
		@param version Data Dictionary major version (DataDictionary.DD_ constant)
		@param feature SQL Feature name, for error text.
	*/
        private void checkVersion(int version, String feature) throws StandardException
        {
                getLanguageConnectionContext().getDataDictionary().checkVersion(
                                version, feature);
        }

    /**
		Utility method for checking that the underlying database uses SQL standard
		permission checking (GRANT/REVOKE).

		@param command "GRANT", "REVOKE", "CREATE/DROP/SET ROLE" or CURRENT_ROLE
    */
        private void checkSqlStandardAccess( String command) throws StandardException
        {
                if( getLanguageConnectionContext().usesSqlAuthorization())
                        return;

                throw StandardException.newException(SQLState.LANG_GRANT_REVOKE_WITH_LEGACY_ACCESS,
                                                                                        command,
                                                                                        com.pivotal.gemfirexd.Property.SQL_AUTHORIZATION,
                                                                                        "TRUE");
        }


        /**
		Check that the current mode supports internal extensions.

		@param feature Description of feature for exception.

		@exception StandardException current mode does not support statement
	*/
        private void checkInternalFeature(String feature) throws StandardException
        {
                CompilerContext cc = getCompilerContext();
                if ((cc.getReliability() & CompilerContext.INTERNAL_SQL_ILLEGAL) != 0)
                        throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR, feature);
        }

        /**
	 * check if the type length is ok for the given type.
	 */
        private void checkTypeLimits(int type, int length)
                throws StandardException
        {
        boolean valid = true;


        switch (type) {
                case Types.BINARY:
                case Types.CHAR:
                        if (length  > Limits.DB2_CHAR_MAXWIDTH)
                                valid = false;
                        break;

                case Types.VARBINARY:
                case Types.VARCHAR:
                        if (length  > Limits.DB2_VARCHAR_MAXWIDTH)
                                valid = false;

                        break;
                default:
                        break;
        }
        if (!valid)  // If these limits are too big 
                {
                        // Do not construct an illegal DTD just to report this error
                        // Make a string on the fly which describes the data type
                        String errString = Util.typeName(type) + "(" + length + ")";

            throw StandardException.newException(SQLState.LANG_DB2_LENGTH_PRECISION_SCALE_VIOLATION, errString);
                }
        }



        // Get the current ContextManager
        private final ContextManager getContextManager()
        {
                return cm;
        }

        /*
	** Compress 2 adjacent (single or double) quotes into a single (s or d) quote when
	** found in the middle of a String.
	** NOTE:  """" or '''' will be compressed into "" or ''.
	** 		  This function assumes that the leading and trailing quote from a
	** 		  string or delimited identifier have already been removed.
	*/
        private static String compressQuotes(String source, String quotes)
        {
        String  result = source;
        int     index;

        /* Find the first occurrence of adjacent quotes. */
        //GemStone changes BEGIN
        /*originally 
         * now that token.image in UCode_CharStream.GetImage(..) trims off first and last 
         * characters of a string (quotes enclosing string), need to adjust here accordingly.
         * index = result.indexOf(quotes, 1);
         */
        index = result.indexOf(quotes, 0);

        /* Replace each occurrence with a single quote and begin the
         * search for the next occurrence from where we left off.
         */
        while (index != -1 && index != source.length())
        {
            //GemStone changes BEGIN
            /*originally 
             * result = result.substring(0, index + 1) + result.substring(index + 2);
             */
             result = result.substring(0, index + 0) + result.substring(index + 1);
            //GemStone changes END

             index = result.indexOf(quotes, index + 1);
        }

        return result;
        }

        private static void verifyImageLength(String image) throws StandardException
                {
                // beetle 2758.  For right now throw an error for literals > 64K
                if (image.length() > MAX_UTF8_LENGTH)
                        {
                       throw StandardException.newException(SQLState.LANG_INVALID_LITERAL_LENGTH);
                        }
                }

        /*
	** Converts a delimited id to a canonical form.
	** Post process delimited identifiers to eliminate leading and
	** trailing " and convert all occurrences of "" to ".
	*/
        private static String normalizeDelimitedID(String str)
        {
                str = compressQuotes(str, DOUBLEQUOTES);
                return str;
        }
        private static boolean isDATETIME(int val)
        {
                if (val == DATE || val == TIME || val == TIMESTAMP)
                        return true;
                else
                        return false;
        }

        /*
	 * Generate a multiplicative operator node, if necessary.
	 *
	 * If there are two operands, generate the multiplicative operator
	 * that corresponds to the multiplicativeOperator parameter.  If there
	 * is no left operand, just return the right operand.
	 *
	 * @param leftOperand	The left operand, null if no operator
	 * @param rightOperand	The right operand
	 * @param multiplicativeOperator	An identifier from BinaryOperatorNode
	 *									telling what operator to generate.
	 *
	 * @return	The multiplicative operator, or the right operand if there is
	 *			no operator.
	 *
	 * @exception StandardException		Thrown on error
	 */

        ValueNode multOp(ValueNode leftOperand,
                                                        ValueNode rightOperand,
                                                        int multiplicativeOperator)
                                        throws StandardException
        {
                if (leftOperand == null)
                {
                        return rightOperand;
                }

                switch (multiplicativeOperator)
                {
                  case BinaryOperatorNode.TIMES:
                        return (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.BINARY_TIMES_OPERATOR_NODE,
                                                                        leftOperand,
                                                                        rightOperand,
                                                                        getContextManager());

                  case BinaryOperatorNode.DIVIDE:
                        return (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.BINARY_DIVIDE_OPERATOR_NODE,
                                                                        leftOperand,
                                                                        rightOperand,
                                                                        getContextManager());
                  case BinaryOperatorNode.CONCATENATE:
                        return (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.CONCATENATION_OPERATOR_NODE,
                                                                        leftOperand,
                                                                        rightOperand,
                                                                        getContextManager());

                  default:
                        if (SanityManager.DEBUG)
                        SanityManager.THROWASSERT("Unexpected multiplicative operator " +
                                                                                multiplicativeOperator);
                        return null;
                }
        }

        /**
	 * Set up and like the parameters to the descriptors.
	 * Set all the ParameterNodes to point to the array of
	 * parameter descriptors.
	 * 
	 *	@exception	StandardException
	 */
         private void setUpAndLinkParameters()
                        throws StandardException
         {
        CompilerContext cc = getCompilerContext();
                cc.setParameterList(parameterList);
                /* Link the untyped parameters to the array of parameter descriptors */

                DataTypeDescriptor[] descriptors = cc.getParameterTypes();
                List<TypeCompiler> origTCs = cc.getOriginalParameterTypeCompilers();
                TypeCompilerFactory tcf = cc.getTypeCompilerFactory();

                ParameterNode                           newNode;
                ParameterNode                           oldNode;
                int                                                     paramCount;

                /*
		** Iterate through the list of untyped parameter nodes, set each one
		** to point to the array of parameter descriptors.
		*/
                paramCount = -1;
                int plSize = parameterList.size();
                for (int index = 0; index < plSize; index++)
                {
                        paramCount++;

                        //GemStone changes BEGIN
                        /*(original code) 
			newNode = (ParameterNode) parameterList.elementAt(index);
			newNode.setDescriptors(descriptors );*/
                        Object o = parameterList.elementAt(index);
                        if(o instanceof ParameterizedConstantNode) {
                        ParameterizedConstantNode pcn = (ParameterizedConstantNode)o;
                          pcn.setDescriptors(descriptors);
                          origTCs.set(pcn.getConstantNumber(), tcf.getTypeCompiler(pcn.getTypeServices().getTypeId()));

                        }
                        else {
                          // don't allow Parameters in a statement.
                          if (!cc.isPreparedStatement()) {
                            throw StandardException.newException(
                              SQLState.LANG_MISSING_PARMS,
                              index + 1, this.statementSQLText);
                          }

                          assert (o instanceof ParameterNode);
                          ((ParameterNode) o).setDescriptors(descriptors);
                        }
                        //GemStone changes END
                }
        }

        /**
	 *  Initializes the list of unnamed parameters, i.e., "?" parameters
	 *
	 *	Usually, this routine just gets an empty list for the unnamed parameters.
	 *
	 *
	 */
        void    initUnnamedParameterList()
        {
                parameterList = new Vector<ValueNode>();
        }

        /**
	 * Makes a new unnamed ParameterNode and chains it onto parameterList.
	 *
	 *	@return	new unnamed parameter.
	 *
	 *	@exception	StandardException
	 */
        ParameterNode   makeParameterNode(  )
                                        throws StandardException
        {
                ParameterNode   parm;
                DataValueDescriptor sdv = null;

                if ((paramDefaults != null) && (parameterNumber < paramDefaults.length))
                {
                        sdv = (DataValueDescriptor) paramDefaults[parameterNumber];
                }
//		GemStone changes begin
                Integer paramInteger = ReuseFactory.getInteger(parameterNumber);

                parm = (ParameterNode) nodeFactory.getNode(
                                                                C_NodeTypes.PARAMETER_NODE,
                                                                paramInteger,
                                                                sdv,
                                                                getContextManager());


                if(this.subqueryParamCount != null && !this.subqueryParamCount.isEmpty())
                {
                  // List<Integer> params = this.subqueryParamCount.peek();
                   //params.add(paramInteger);
                   //Bug 42697
                  Iterator<List<Integer>> itr = this.subqueryParamCount.iterator();
                  while( itr.hasNext()) {
                    itr.next().add(paramInteger);
                  }

                }

//		GemStone changes end
                parameterNumber++;
                parameterList.addElement(parm);
                getCompilerContext().addDynamicTokenToList(getToken(0));
                return parm;
        }

        /**
	 * Looks up an unnamed parameter given its parameter number.
	 *
	 *	@param	paramNumber		Number of parameter in unnamed
	 *							parameter list.
	 *
	 *	@return	corresponding unnamed parameter.
	 *
	 */
        ParameterNode   lookupUnnamedParameter( int paramNumber )
        {
                ParameterNode           unnamedParameter;

                unnamedParameter = (ParameterNode) parameterList.elementAt( paramNumber );
                return unnamedParameter;
        }

        /**
	 * Translate a String containing a number into the appropriate type
	 * of Numeric node.
	 *
	 * @exception StandardException		Thrown on error
	 */
        NumericConstantNode getNumericNode(String num, boolean intsOnly)
        throws StandardException
        {
                ContextManager cm = getContextManager();

                // first, see if it might be an integer
                try
                {
                        return (NumericConstantNode) nodeFactory.getNode(
                                                                                C_NodeTypes.INT_CONSTANT_NODE,
// GemStone changes BEGIN
                                                                                // changed to use Integer.valueOf()
                                                                                Integer.valueOf(num),
// GemStone changes END
                                                                                cm);
                }
                catch (NumberFormatException nfe)
                {
                        // we catch because we want to continue on below
                }

                // next, see if it might be a long
                try
                {
                        return (NumericConstantNode) nodeFactory.getNode(
                                                                                C_NodeTypes.LONGINT_CONSTANT_NODE,
// GemStone changes BEGIN
                                                                                // changed to use Long.valueOf()
                                                                                Long.valueOf(num),
// GemStone changes END
                                                                                cm);
                }
                catch (NumberFormatException nfe)
                {
                        if (intsOnly) {
                                throw nfe;
                            }
                            // else we want to continue on below
                }

                return (NumericConstantNode) nodeFactory.getNode(
                                                                        C_NodeTypes.DECIMAL_CONSTANT_NODE,
                                                                        num,
                                                                        cm);
        }
        /**
	 * Determine whether the current token represents one of
	 * the built-in aliases.
	 *
	 * @return	TRUE iff the current token names a built-in alias
	 */
        private boolean isBuiltInAlias()
        {
                boolean retval = false;

                switch (token.kind)
                {
                  case UCASE:
                  case LCASE:
                  case SQRT:
                  case LOCATE:
                  case ABS:
                  case ABSVAL:
                  case SUBSTR:
                  case MOD:
                        retval = true;
                        break;

                  default:
                        retval = false;
                        break;
                }


                return retval;
        }


        /**
	 * Determine whether the next sequence of tokens represents one of
	 * the common (built-in) datatypes.
	 *
	 * @param checkFollowingToken true if additonal token for NATIONAL
	 *        or LONG should be checked
	 * @return	TRUE iff the next set of tokens names a common datatype
	 */
        boolean commonDatatypeName(boolean checkFollowingToken)
        {
            return commonDatatypeName(1, checkFollowingToken);
        }

        /**
	 * Determine whether the next sequence of tokens represents 
	 * a datatype (could be a common datatype or a schema qualified UDT name).
	 *
	 * @return	TRUE iff the next set of tokens names a datatype
	 */
        boolean dataTypeCheck(int start)
        {
        if ( commonDatatypeName( start, false ) ) { return true; }

        boolean retval = true;

                switch (getToken(start).kind)
                {
                  case COMMA:
                  case LEFT_PAREN:
                  case RIGHT_PAREN:
                        retval = false;
            break;
        }

        return retval;
    }

        /**
	 * Determine whether a sequence of tokens represents one of
	 * the common (built-in) datatypes.
	 *
	 * @param checkFollowingToken true if additonal token for NATIONAL
	 *        or LONG should be checked
	 * @param start starting token index of the sequence
	 * @return	TRUE iff the next set of tokens names a common datatype
	 */
        boolean commonDatatypeName(int start, boolean checkFollowingToken)
        {
                boolean retval = false;

                switch (getToken(start).kind)
                {
                  case CHARACTER:
                  case CHAR:
                  case VARCHAR:
                  case NVARCHAR:
                  case NCHAR:
                  case BIT:
                  case NUMERIC:
                  case DECIMAL:
                  case DEC:
                  case INTEGER:
                  case INT:
                  case SMALLINT:
                  case LONGINT:
                  case FLOAT:
                  case REAL:
                  case DATE:
                  case TIME:
                  case TIMESTAMP:
                  case BOOLEAN:
                  case DOUBLE:
                  case BLOB:
                  case CLOB:
                  case CLOB_STRING:
                  case JSON:
                  case NCLOB:
                  case BINARY: // LARGE OBJECT
                  case XML:
                        retval = true;
                        break;

                  case LONG:
                        if (checkFollowingToken == true)
                        {
                                switch (getToken(start+1).kind)
                                {
                                  case VARCHAR:
                                  case NVARCHAR:
                                  case BINARY:
                                  case VARBINARY:
                                  case BIT:
                                        retval = true;
                                        break;
                                }
                                break;
                        }
                        else
                        {
                                retval = true;
                                break;
                        }

                  case NATIONAL:
                        if (checkFollowingToken == true)
                        {
                                switch (getToken(start+1).kind)
                                {
                                  case CHAR:
                                  case CHARACTER:
                                        retval = true;
                                        break;
                                }
                                break;
                        }
                        else
                        {
                                retval = true;
                                break;
                        }
                }

                return retval;
        }

        /**
	 * Get a DELETE node given the pieces.
	 *
	 *
	 *	@exception	StandardException
	 */
         private StatementNode getDeleteNode(FromTable fromTable,
                                                                                 TableName tableName,
                                                                                 ValueNode whereClause)
                throws StandardException
        {
                FromList   fromList = (FromList) nodeFactory.getNode(
                                                                C_NodeTypes.FROM_LIST,
                                                                getContextManager());

                fromList.addFromTable(fromTable);

                SelectNode resultSet = (SelectNode) nodeFactory.getNode(
                                                                                C_NodeTypes.SELECT_NODE,
                                                                                null,
                                                                                null,   /* AGGREGATE list */
                                                                                fromList, /* FROM list */
                                                                                whereClause, /* WHERE clause */
                                                                                null, /* GROUP BY list */
                                                                                null, /* having clause */
                                        Boolean.valueOf(true), /* Dml op */
                                                                                getContextManager());

                StatementNode retval =
                        (StatementNode) nodeFactory.getNode(
                                                        C_NodeTypes.DELETE_NODE,
                                                        tableName,
                                                        resultSet,
                                                        getContextManager());

                setUpAndLinkParameters();

                return retval;
        }

        /**
	 * Get an UPDATE node given the pieces.
	 *
	 *
	 *	@exception	StandardException
	 */
         private StatementNode getUpdateNode(FromTable fromTable,
                                                                                 TableName tableName,
                                                                                 ResultColumnList setClause,
                                                                                 ValueNode whereClause)
                throws StandardException
        {
                FromList   fromList = (FromList) nodeFactory.getNode(
                                                                C_NodeTypes.FROM_LIST,
                                                                getContextManager());

                fromList.addFromTable(fromTable);

                SelectNode resultSet = (SelectNode) nodeFactory.getNode(
                                                                                C_NodeTypes.SELECT_NODE,
                                                                                setClause,
                                                                                null,   /* AGGREGATE list */
                                                                                fromList, /* FROM list */
                                                                                whereClause, /* WHERE clause */
                                                                                null, /* GROUP BY list */
                                                                                null, /* having clause */
                                                                                Boolean.valueOf(true), /* Dml op */
                                                                                getContextManager());

                StatementNode retval =
                        (StatementNode) nodeFactory.getNode(
                                                        C_NodeTypes.UPDATE_NODE,
                                                        tableName,
                                                        resultSet,
                                                        getContextManager());

                setUpAndLinkParameters();

                return retval;
        }

    /**
     * Generate a trim operator node
     * @param trimSpec one of Leading, Trailing or Both.
     * @param trimChar the character to trim. Can be null in which case it defaults
     * to ' '.
     * @param trimSource expression to be trimmed.
     */
    private ValueNode getTrimOperatorNode(Integer trimSpec, ValueNode trimChar,
        ValueNode trimSource, ContextManager cm) throws StandardException
    {
        if (trimChar == null)
        {
                trimChar = (CharConstantNode) nodeFactory.getNode(
                                                        C_NodeTypes.CHAR_CONSTANT_NODE,
                                                        " ",
                                                        getContextManager());
        }
        return (ValueNode) nodeFactory.getNode(
                                                        C_NodeTypes.TRIM_OPERATOR_NODE,
                                                        trimSource, // receiver
                                                        trimChar,   // leftOperand.
                                                        null,
                                                        ReuseFactory.getInteger(TernaryOperatorNode.TRIM),
                                                        trimSpec,
                                                        cm == null ? getContextManager() : cm);
    }

    private boolean ansiTrimSpecFollows()
    {
        return (getToken(2).kind == LEADING || getToken(2).kind == TRAILING
                || getToken(2).kind == BOTH);
    }

        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of a remainingPredicate() rule.
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			remainingPredicate()
	 */
        private boolean remainingPredicateFollows()
        {
                boolean retval = false;

                switch (getToken(1).kind)
                {
                  case EQUALS_OPERATOR:
                  case NOT_EQUALS_OPERATOR:
                  case NOT_EQUALS_OPERATOR2: // !=
                  case LESS_THAN_OPERATOR:
                  case GREATER_THAN_OPERATOR:
                  case LESS_THAN_OR_EQUALS_OPERATOR:
                  case GREATER_THAN_OR_EQUALS_OPERATOR:
                  case IN:
                  case LIKE:
                  case BETWEEN:
                        retval = true;
                        break;

                  case NOT:
                        switch (getToken(2).kind)
                        {
                          case IN:
                          case LIKE:
                          case BETWEEN:
                                retval = true;
                        }
                        break;
                }

                return retval;
        }


        /**
	 * Determine whether the next token is a DROP
	 *
	 * @return	TRUE iff the next token is DROP
	 */
        private boolean dropFollows()
        {
                if (getToken(1).kind == DROP)
                { return true; }
                else { return false; }
        }

        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of a escapedValueFunction().
	 *
	 * We check only for the punctuation here, because identifiers are
	 * very hard to check for in semantic lookahead.
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			escapedValueFunction()
	 */
        private boolean escapedValueFunctionFollows()
        {
                if (getToken(1).kind != LEFT_BRACE)
                {
                        return false;
                }

                return getToken(2).kind == FN;
        }


    /**
       List of JDBC escape functions that map directly onto
       a function in the SYSFUN schema.
    */
        private static final String[] ESCAPED_SYSFUN_FUNCTIONS =
        {"ACOS", "ASIN", "ATAN", "COS", "SIN", "TAN", "PI",
         "DEGREES", "RADIANS", "EXP", "LOG", "LOG10", "CEILING", "FLOOR",
         "SIGN", "RAND", "COT", "DSID" };

    /**
       Convert a JDBC escaped function name to a function
       name in the SYSFUN schema. Returns null if no such
       function exists.
    */
        private String getEscapedSYSFUN(String name)
        {
            name = StringUtil.SQLToUpperCase(name);

            for (int i = 0; i < ESCAPED_SYSFUN_FUNCTIONS.length; i++)
            {
                if (ESCAPED_SYSFUN_FUNCTIONS[i].equals(name))
                    return name;
            }
            return null;
        }

        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of a columnInvocation() rule.  columnInvocations start with
	 * [ [ id . ] id . ] id . id (
	 *
	 * We check only for the punctuation here, because identifiers are
	 * very hard to check for in semantic lookahead.
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			columnInvocation()
	 */
        private boolean columnMethodInvocationFollows()
        {
                int tokKind;

                // First token must not be a built-in function name that can be
                // followed immediately by a PERIOD. There are only a few of
                // these - most built-in functions have a LEFT_PAREN following
                // the function name.

                // if we run out of token, it's probably a syntax error,  
                // in fact
                tokKind = getToken(1).kind;
                if ( tokKind == EOF ) { return false; }

                // disambiguate from named parameter reference
                if ( getToken(1).image.charAt(0) == '?' ) { return false; }

                if (tokKind == CURRENT_DATE ||
                        tokKind == CURRENT_TIME ||
                        tokKind == CURRENT_TIMESTAMP ||
                        tokKind == CURRENT && (isDATETIME(getToken(2).kind)) )
                {
                        return false;
                }

                // Second token must be a PERIOD
                if (getToken(2).kind != PERIOD)
                {
                        return false;
                }

                // We have established that we start with " id . "
                tokKind = getToken(4).kind;
                if (tokKind == LEFT_PAREN)
                {
                        // id.id(
                        return true;
                }

                // Not id.id(, so 4th token must be PERIOD
                if (tokKind != PERIOD)
                {
                        return false;
                }

                tokKind = getToken(6).kind;
                if (tokKind == LEFT_PAREN)
                {
                        // id.id.id(
                        return true;
                }

                // Not id.id.id(, so 6th token must be PERIOD
                if (tokKind != PERIOD)
                {
                        return false;
                }

                tokKind = getToken(8).kind;
                if (tokKind == LEFT_PAREN)
                {
                        // id.id.id.id(
                        return true;
                }

                return false;
        }

        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of an aggregateNode()() rule.  aggregateNodes() start with one
	 * of the built-in aggregate names, or with an identifier followed
	 * by "( DISTINCT". A non-distinct user-defined aggregate invocation
	 * is treated as a staticMethodInvocationAlias() by the parser,
	 * and the binding phase figures out what it really is by looking
	 * at the data dictionary.
	 *
	 * We check only for the punctuation here, because identifiers are
	 * very hard to check for in semantic lookahead.
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			aggregateNode()
	 */
        private boolean aggregateFollows()
        {
                boolean retval = false;

                switch (getToken(1).kind)
                {
                  case MAX:
                  case AVG:
                  case MIN:
                  case SUM:
                        // This is a built-in aggregate
                        retval = true;
                        break;

                  case COUNT:
                        // COUNT is not a reserved word
                        // This may eclipse use of COUNT as a function or a procedure that is probably what we want
                        if (getToken(2).kind == LEFT_PAREN)
                                retval = true;
                  default:
                        // Not a built-in aggregate - assume the first token is an
                        // identifier, and see whether it is followed by " ( DISTINCT "
                        if (getToken(2).kind == LEFT_PAREN && getToken(3).kind == DISTINCT)
                                retval = true;
                        break;
                }

                return retval;
        }

        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of a miscBuiltins().
	 *
	 * We check only for the punctuation here, because identifiers are
	 * very hard to check for in semantic lookahead.
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			aggregateNode()
	 */
        private boolean miscBuiltinFollows()
        {
                boolean retval = false;
                int tokKind = getToken(1).kind;

                if (getToken(0).kind == CALL)
                        retval = true;

                switch (tokKind)
                {
                  case GET_CURRENT_CONNECTION:
                  case CURRENT_DATE:
                  case CURRENT_TIME:
                  case CURRENT_TIMESTAMP:
                        retval = true;
                        break;

                  case CURRENT:
                        if (isDATETIME(getToken(2).kind))
                                retval = true;
                        break;

                  case CAST:
                  case LEFT_PAREN:
                        retval = false;
                        break;

                  default:
                    if (getToken(2).kind == LEFT_PAREN)
                                retval = true;
                        break;
                }

                return retval;
        }

        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of a subquery. A subquery can begin with an arbitrary number of
	 * left parentheses, followed by either SELECT or VALUES.
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			subquery.
	 */
        private boolean subqueryFollows()
        {
                int tokKind;
                boolean retval = false;

                for (int i = 1; true; i++)
                {
                        tokKind = getToken(i).kind;
                        if (tokKind == LEFT_PAREN)
                        {
                                // A subquery can start with an arbitrary number of left
                                // parentheses.
                                continue;
                        }
                        else if (tokKind == SELECT || tokKind == VALUES)
                        {
                                // If the first token we find after all the left parentheses
                                // is SELECT or VALUES, it's a subquery.
                                retval = true;
                                break;
                        }
                        else
                        {
                                // If the first token we find after all the left parentheses
                                // is neither SELECT nor VALUES, it's not a subquery.
                                break;
                        }
                }

                return retval;
        }

    /**
     * Determine if we are seeing an offsetClause or the identifier OFFSET
     * (Derby does not make it a reserved word).  "n" must be an integer
     * literal or a dynamic parameter specification.
     *
     * @return true if it is an offsetClause.
     */
    private boolean seeingOffsetClause()
    {
        int nesting = 0;

        // Token number, i == 1: OFFSET
        int i = 2;

        int tokKind = getToken(i).kind;

        // check for integer literal or ? followed by ROW(S)
        if (tokKind == PLUS_SIGN ||
            tokKind == MINUS_SIGN) {

            tokKind = getToken(++i).kind;

            // GemStone changes BEGIN
            /*(original code) if (tokKind == EXACT_NUMERIC) {*/
            if (tokKind == EXACT_NUMERIC || tokKind == QUESTION_MARK) {
            // GemStone changes END

                tokKind = getToken(++i).kind;

                return (tokKind == ROW ||
                        tokKind == ROWS);
            }
        // GemStone changes BEGIN
        /*(original code) } else if (tokKind == EXACT_NUMERIC) {*/
        } else if (tokKind == EXACT_NUMERIC || tokKind == QUESTION_MARK) {
        // GemStone changes END

            tokKind = getToken(++i).kind;

            return (tokKind == ROW ||
                    tokKind == ROWS);
        }

        return false;
    }




        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of a rowValueConstructorList. A rowValueConstructorList is a comma-
	 * separated list of expressions enclosed in parentheses. This presents
	 * special problems, because an expression be nested within an
	 * arbitrary number of parentheses. To determine whether a left
	 * parenthesis introduces a rowValueConstructorList or an expression,
	 * we need to find the closing parenthesis, and determine whether
	 * the next token is a comma.
	 *
	 * For example, the following is a rowValueConstructorList:
	 *
	 *		(((1)), 2)
	 *
	 * and the following is just an expression:
	 *
	 *		(((1)))
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			subquery.
	 */
        private boolean rowValueConstructorListFollows()
        {
                int nesting;
                boolean retval = false;

                // A rowValueConstructorList starts with a left parenthesis
                if (getToken(1).kind == LEFT_PAREN)
                {
                        // Keep track of the nesting of parens while looking ahead
                        nesting = 1;
                        for (int i = 2; true; i++)
                        {
                                int tokKind = getToken(i).kind;

                                // Special case for NULL/DEFAULT because they are not allowed in
                                // a parenthesized expression, so (null)/(default) must be seen
                                // as a rowValueConstructorList with one element.
                                if (i == 2 && (tokKind == NULL || tokKind == _DEFAULT))
                                {
                                        retval = true;
                                        break;
                                }

                                // There must be a COMMA at nesting level 1 (i.e. outside of
                                // the first expression) for it to be a rowValueConstructorList
                                if (nesting == 1 && tokKind == COMMA)
                                {
                                        retval = true;
                                        break;
                                }

                                // If we run out of tokens before finding the last closing
                                // parenthesis, it's not a rowValueConstructorList (it's
                                // probably a syntax error, in fact)
                                if (tokKind == EOF)
                                {
                                        break;
                                }

                                // Increase the nesting for each (, and decrease it for each )
                                if (tokKind == LEFT_PAREN)
                                {
                                        nesting++;
                                }
                                else if (tokKind == RIGHT_PAREN)
                                {
                                        nesting--;
                                }

                                // Don't look any farther than the last closing parenthesis
                                if (nesting == 0)
                                {
                                        break;
                                }
                        }
                }

                return retval;
        }

        /**
	 * Determine whether the next token is the beginning of a propertyList(). 
	 * A properties list is the comment "--gemfirexd-properties" followed by a 
	 * dot-separated list, followed by an =, followed by a value all on that 
	 * comment line. This means that the comment should start with the word
	 * "gemfirexd-properties".
	 *
	 * @return	TRUE iff the next token is gemfirexd-properties 
	 */
        private boolean derbyPropertiesListFollows()
        {
                return
                        getToken(1).kind == GEMFIREXDDASHPROPERTIES;
        }

        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of a newInvocation(). A newInvocation() begins with the word "new"
	 * followed by a dot-separated list of identifiers, followed
	 * by a left parenthesis.
	 *
	 * @param startToken	Token to look for new at
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			newInvocation().
	 */
        private boolean newInvocationFollows(int startToken)
        {
                boolean retval = false;

                // newInvocation() starts with the word "new"
                if (getToken(startToken).kind == NEW)
                {
                        // Look at every other token. Ignore the identifiers, because
                        // they are hard to test for.
                        for (int i = 2 + startToken; true; i += 2)
                        {
                                int tokKind = getToken(i).kind;

                                // If we find a left parenthesis without any intervening
                                // cruft, we have found a newInvocation()
                                if (tokKind == LEFT_PAREN)
                                {
                                        retval = true;
                                        break;
                                }
                                else if (tokKind != PERIOD)
                                {
                                        // Anything other than a PERIOD is "cruft"
                                        break;
                                }
                        }
                }

                return retval;
        }
        /**
	 * Determine whether the next sequence of tokens is a class name
	 *
	 * @return	TRUE iff the next set of tokens is the java class name
	 */
        boolean javaClassFollows()
        {
                boolean retval = false;

                // Look at every other token. Ignore the identifiers, because
                // they are hard to test for.
                for (int i = 2; true; i += 2)
                {
                        int tokKind = getToken(i).kind;

                        // If we find a '::' without any intervening
                        // cruft, we have found a javaClass
                        if (tokKind == DOUBLE_COLON)
                        {
                                retval = true;
                                break;
                        }
                        else if (tokKind != PERIOD)
                        {
                                // Anything other than a PERIOD is "cruft"
                                break;
                        }
                }

                return retval;
        }

        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of a FROM newInvocation(). A FROM newInvocation() begins with the words "from new"
	 * followed by a dot-separated list of identifiers, followed
	 * by a left parenthesis.
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			FROM newInvocation().
	 */
        private boolean fromNewInvocationFollows()
        {
                boolean retval = false;

                // FROM newInvocation() starts with the words "from new"
                return (getToken(1).kind == FROM && newInvocationFollows(2));
        }

        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of a joinedTableExpression(). A joinedTableExpression() begins
	 * with one of:
	 *
	 *	JOIN
	 *	INNER JOIN
	 *	LEFT OUTER JOIN
	 *	RIGHT OUTER JOIN
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			joinedTableExpression().
	 */
        private boolean joinedTableExpressionFollows()
        {
                boolean retval = false;

                int tokKind1 = getToken(1).kind;
                int tokKind2 = getToken(2).kind;

                if (tokKind1 == JOIN)
                {
                        retval = true;
                }
                else if (tokKind1 == INNER && tokKind2 == JOIN)
                {
                        retval = true;
                }
                else if ((tokKind1 == LEFT || tokKind1 == RIGHT) && tokKind2 == OUTER)
                {
                        if (getToken(3).kind == JOIN)
                        {
                                retval = true;
                        }
                }
                else if ((tokKind1 == LEFT || tokKind1 == RIGHT) && tokKind2 == JOIN)
                {
                        retval = true;
                }

                return retval;
        }

        /**
	 * Translate a token for the name of a built-in aggregate to a String
	 * containing an aggregate name.
	 */
        private static String aggName(Token token)
        {
                String  retval = null;

                switch (token.kind)
                {
                  case MAX:
                        retval = "MAX";
                        break;

                  case AVG:
                    retval = "AVG";
                        break;

                  case MIN:
                    retval = "MIN";
                        break;

                  case SUM:
                    retval = "SUM";
                        break;

                  case COUNT:
                    retval = "COUNT";
                        break;

                  default:
                        if (SanityManager.DEBUG)
                        {
                                SanityManager.THROWASSERT("Unexpected token type in aggName: " +
                                                                                        token.kind);
                        }
                        break;
                }

                return retval;
        }

        /**
	 * Translate a token for the name of a built-in aggregate to an
	 * aggregate definition class.
	 */
        private static Class aggClass(Token token)
        {
                Class   retval = null;

                switch (token.kind)
                {
                  case MAX:
                  case MIN:
                        retval = MaxMinAggregateDefinition.class;
                        break;

                  case AVG:
                  case SUM:
                        retval = SumAvgAggregateDefinition.class;
                        break;

                  case COUNT:
                    retval = CountAggregateDefinition.class;
                        break;

                  default:
                        if (SanityManager.DEBUG)
                        {
                                SanityManager.THROWASSERT("Unexpected token type in aggClass: "
                                                                                        + token.kind);
                        }
                        break;
                }

                return retval;
        }

        /**
	 * Determine whether the next sequence of tokens can be the beginning
	 * of another element in a PROPERTY list. These elements are of the
	 * form:
	 *
	 *		COMMA dot.separated.list = ...
	 *
	 * Look for the COMMA, the dots in the dot-separated list, and the =
	 *
	 * @return	TRUE iff the next set of tokens is the beginning of a
	 *			another element in a PROPERTY list.
	 */
        private boolean anotherPropertyFollows()
        {
                boolean retval = false;

                // Element must start with COMMA
                if (getToken(1).kind == COMMA)
                {
                        // Rest of element is dot-separated list with = at end
                        int i = 3;
                        int tokKind;
                        do
                        {
                                tokKind = getToken(i).kind;

                                // If we've found nothing but PERIODs until the EQUALS_OPERATOR
                                // it is the beginning of another property list element.
                                if (tokKind == EQUALS_OPERATOR)
                                {
                                        retval = true;
                                        break;
                                }

                                i += 2;
                        } while (tokKind == PERIOD);
                }

                return retval;
        }

        /**
	 * Get one of the several types of create alias nodes.
	 *
	 * @param aliasName	The name of the alias
	 * @param fullStaticMethodName	The full path/method name
	 * @param aliasSpecificInfo	 Information specific to the type of alias being created.
	 * @param aliasType	The type of alias to create
	 * @param delimitedIdentifier	Whether or not to treat the class name
	 *								as a delimited identifier if trying to
	 *								resolve it as a class alias.
	 *
	 * @return	A CreateAliasNode matching the given parameters
	 *
	 * @exception StandardException		Thrown on error
	 */
        StatementNode
        getCreateAliasNode(
                Object aliasName,
                String fullStaticMethodName,
                Object aliasSpecificInfo,
                char aliasType,
                Boolean delimitedIdentifier)
                throws StandardException
        {

                StatementNode aliasNode = (StatementNode) getNodeFactory().getCreateAliasNode
                        (
                                aliasName,
                                fullStaticMethodName,
                                aliasSpecificInfo,
                                aliasType,
                                delimitedIdentifier,
                                getContextManager()
                        );

                return aliasNode;
        }

        /**
		Create a node for the drop alias/procedure call.
	*/
        StatementNode
        dropAliasNode(Object aliasName, char type
// GemStone changes BEGIN
                                        ,Boolean onlyIfExists
// GemStone changes END
                                        ) throws StandardException
        {

                StatementNode stmt = (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.DROP_ALIAS_NODE,
                                                                aliasName,
// GemStone changes BEGIN
                                                                // changed to use valueOf()
                                                                Character.valueOf(type),
                                                                onlyIfExists,
// GemStone changes END
                                                                getContextManager());

                return stmt;
        }

    /**
     * Get a substring node from
     *      - the string
     *      - the start position
     *      - the length
     *      - a boolean values for specifying the kind of substring function
     * @exception StandardException  Thrown on error
     */
    ValueNode getSubstringNode( ValueNode stringValue, ValueNode startPosition,
                         ValueNode length, Boolean boolVal ) throws StandardException
    {
        return (ValueNode) nodeFactory.getNode(
                                                C_NodeTypes.SUBSTRING_OPERATOR_NODE,
                                                stringValue,
                                                startPosition,
                                                length,
                                                ReuseFactory.getInteger(TernaryOperatorNode.SUBSTRING),
                                                null,
                                                    getContextManager());
    }

    final public TableName
    qualifiedName(int id_length_limit) throws ParseException, StandardException
    {
        return qualifiedName( C_NodeTypes.TABLE_NAME, id_length_limit);
    }

    private void initStatement( String statementSQLText, Object[] paramDefaults)
        throws StandardException
    {
        /* Do per-statement initialization here */
        parameterNumber = 0;
       this.statementSQLText = statementSQLText;
        this.paramDefaults = paramDefaults;
        nodeFactory = getNodeFactory();
        initUnnamedParameterList();
        this.isPartitionOrColocateWithDefined = false;
        //GemStone changes BEGIN
        this.constantNumber = 0;
        this.prevDiskStore = null;
        this.prevHDFSStore = null;
        this.prevPersistenceModeSet = null;
        this.expirationFlag = 0;    // 1, 2, 3, 4 depending on expiration choice (non-repeating but not mutually exclusive)
        this.evictionChoice = 0;    // 0 for no eviction, 1 for some eviction clause (clauses are mutually exclusive)
        //GemStone changes END
    } // End of initStatement

    private void checkIdentifierLengthLimit( String identifier, int identifier_length_limit)
        throws StandardException
    {
        if (identifier.length() > identifier_length_limit)
                throw StandardException.newException(SQLState.LANG_IDENTIFIER_TOO_LONG, identifier, String.valueOf(identifier_length_limit));
    }

    private ValueNode getJdbcIntervalNode( int intervalType) throws StandardException
    {
        return (ValueNode) nodeFactory.getNode( C_NodeTypes.INT_CONSTANT_NODE,
                                                ReuseFactory.getInteger( intervalType),
                                                getContextManager());
    }

    /**
        Check to see if the required claues have been added
        to a procedure or function defintion.
        
        @param required int array of require clauses
        @param  clauses the array of declared clauses.
    */
    void checkRequiredRoutineClause(int[] required, Object[] clauses)
        throws StandardException
    {
        for (int i = 0; i < required.length; i++)
        {
            int re = required[i];
            if (clauses[re] == null)
            {
                throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR,
                                 ROUTINE_CLAUSE_NAMES[re]);
                    }
                }
    }

        boolean isPrivilegeKeywordExceptTrigger(int tokenKind) {
                return (tokenKind == SELECT ||
                                tokenKind == DELETE ||
                                tokenKind == INSERT ||
                                tokenKind == UPDATE ||
                                tokenKind == REFERENCES ||
                                tokenKind == EXECUTE ||
                                tokenKind == ALTER ||
                                tokenKind == ALL);
        }

        // GemStone changes BEGIN

        /**
	 * Determine whether the next sequence of tokens is a class name
	 *
	 * @return	TRUE iff the next set of tokens is the java class name
	 */
        boolean javaClassFollowsProcedureCall()
        {
                boolean retval = false;

                // Look at every other token. Ignore the identifiers, because
                // they are hard to test for.
                for (int i = 2; true; i += 2)
                {
                        int tokKind = getToken(i).kind;

                        // If we find a '::' without any intervening
                        // cruft, we have found a javaClass
                        if (tokKind == DOUBLE_COLON || tokKind == PERIOD || tokKind == DOLLAR)
                        {
                                retval = true;
                                break;
                        }
                        else
                        {
                                break;
                        }
                }

                return retval;
        }

        private int getIntValue(ValueNode v) throws StandardException {
                Object o = v.getConstantValueAsObject();
                try {
                  int i = Integer.parseInt(o.toString());
                  return i;
                } catch (Exception e) {
                        throw StandardException.newException
                          (SQLState.LANG_FORMAT_EXCEPTION, TypeId.INTEGER_NAME, (String)null);
                }
        }

        private long getLongValue(ValueNode v) throws StandardException {
                Object o = v.getConstantValueAsObject();
                try {
                  long l = Long.parseLong(o.toString());
                  return l;
                } catch (Exception e) {
                        throw StandardException.newException
                          (SQLState.LANG_FORMAT_EXCEPTION, TypeId.LONGINT_NAME, (String)null);
                }
        }

        private Object infinityDateObj = null;
        private Object infinityTimeObj = null;
        private Object infinityTimestampObj = null;

        //@TODO Neeraj: This needs to be looked into again for a better way of doing this.
        private Object getNullOrDateTypeObj(String betweenNodeType)
            throws StandardException {
          if (betweenNodeType.equalsIgnoreCase("date")) {
            if (this.infinityDateObj == null) {
              this.infinityDateObj = getLanguageConnectionContext().
                  getDataValueFactory().getDateValue(
                      GfxdConstants.INFINITY_DATE_STR, true);
            }
            return this.infinityDateObj;
          }
          else if (betweenNodeType.equalsIgnoreCase("time")) {
            if (this.infinityTimeObj == null) {
              this.infinityTimeObj = getLanguageConnectionContext().
                  getDataValueFactory().getTimeValue(
                      GfxdConstants.INFINITY_TIME_STR, true);
            }
            return this.infinityTimeObj;
          }
          else if (betweenNodeType.equalsIgnoreCase("timestamp")) {
            if (this.infinityTimestampObj == null) {
              this.infinityTimestampObj = getLanguageConnectionContext().
                  getDataValueFactory().getTimestampValue(
                      GfxdConstants.INFINITY_TIMESTAMP_STR, true);
            }
            return this.infinityTimestampObj;
          }
          else {
            return null;
          }
        }

        private RegionAttributes getAttributesFromFactory(
            AttributesFactory afact) throws StandardException {
          try {
            // set the default capacity for GemFireXD to avoid too many rehashes
            // during initialization
            afact.setInitialCapacity(GemFireXDUtils.getDefaultInitialCapacity());
            //afact.setConcurrencyChecksEnabled(GfxdConstants
            //    .TABLE_DEFAULT_CONCURRENCY_CHECKS_ENABLED);
            return afact.create();
          } catch (IllegalStateException ex) {
            String msg;
        if(ex.getMessage().contains(LocalizedStrings.HDFSSTORE_IS_USED_IN_NONHDFS_REGION.toLocalizedString())){
          msg = ex.getClass().getName()
              + ": "
              + LocalizedStrings.HDFSSTORE_IS_USED_IN_REPLICATED_TABLE.toLocalizedString();
          throw StandardException.newException(
                SQLState.HDFS_STORE_NOT_SUPPORTED_FOR_REPLICATE_TABLE, new UnsupportedOperationException(ex), msg);
        }
        throw StandardException.newException(
                SQLState.LANG_UNEXPECTED_USER_EXCEPTION, ex, ex.toString());
          }
        }

        private PartitionAttributes getPartitionAttributesFromFactory(
            PartitionAttributesFactory pafact) throws StandardException {
          try {
            return pafact.create();
          } catch (IllegalStateException ex) {
            throw StandardException.newException(
                SQLState.LANG_UNEXPECTED_USER_EXCEPTION, ex, ex.toString());
          }
        }

/*
 * <A NAME="Statement">Statement</A>
 */
  final public StatementNode Statement(String statementSQLText, Object[] paramDefaults) throws ParseException, StandardException {StatementNode   statementNode;

        initStatement(statementSQLText, paramDefaults);
    statementNode = StatementPart(null);
    switch (jj_nt.kind) {
    case SEMICOLON:{
      jj_consume_token(SEMICOLON);
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    jj_consume_token(0);
{if ("" != null) return statementNode;}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode proceduralStatement(Token[] tokenHolder) throws ParseException, StandardException {StatementNode statementNode;
        tokenHolder[0] = getToken(1);
        //GemStone changes BEGIN
        //getCompilerContext().setPreparedStatement();
        getCompilerContext().allowOptimizeLiteral(false);
        //GemStone changes END

    switch (jj_nt.kind) {
    case INSERT:
    case PUT:{
      statementNode = insertStatement();
      break;
      }
    case UPDATE:{
      statementNode = preparableUpdateStatement();
      break;
      }
    case DELETE:{
      statementNode = preparableDeleteStatement();
      break;
      }
    case SELECT:
    case VALUES:
    case LEFT_PAREN:{
      statementNode = preparableSelectStatement(true);
      break;
      }
    case CALL:
    case LEFT_BRACE:
    case QUESTION_MARK:{
      statementNode = callStatement();
      break;
      }
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return statementNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="StatementPart">StatementPart</A>
 * 
 * @param tokenHolder returns the token that starts
 * the statement.  If null, ignored.
 */
  final public StatementNode StatementPart(Token[] tokenHolder) throws ParseException, StandardException {StatementNode   statementNode;
        //before starting new statements, initialize this variables. Otherwise, the left
        //over values from previously failed sql will affect the next sql. 
        explicitNotNull = false;
        explicitNull = false;
        explicitlyNullableColumnsList = new Vector();
//	Gemstone changes begin	 
        subqueryParamCount = null;
//	Gemstone changes end
        /*
	** Grab the token preceding this production
	*/
        if (tokenHolder != null)
        {
                tokenHolder[0] = getToken(1);
        }
    switch (jj_nt.kind) {
    case LOCK:
    case RENAME:{
      switch (jj_nt.kind) {
      case RENAME:{
        statementNode = spsRenameStatement();
        break;
        }
      case LOCK:{
        // statementNode = SQLTransactionStatement() |
                statementNode = lockStatement();
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return statementNode;}
      break;
      }
    default:
      jj_la1[6] = jj_gen;
      if (jj_2_4(1)) {
        switch (jj_nt.kind) {
        case CREATE:{
          statementNode = createStatements();
          break;
          }
        case DROP:{
          statementNode = dropStatements();
          break;
          }
        case ALTER:{
          statementNode = spsAlterStatement();
          break;
          }
        case DECLARE:{
          statementNode = globalTemporaryTableDeclaration();
          break;
          }
        case DELETE:
        case INSERT:
        case ROLLBACK:
        case SELECT:
        case UPDATE:
        case VALUES:
        case RELEASE:
        case SAVEPOINT:
        case CALL:
        case PUT:
        case LEFT_BRACE:
        case LEFT_PAREN:
        case QUESTION_MARK:{
          statementNode = preparableSQLDataStatement();
          break;
          }
        default:
          jj_la1[3] = jj_gen;
          if (jj_2_1(1)) {
            statementNode = spsSetStatement();
          } else {
            switch (jj_nt.kind) {
            case TRUNCATE:{
              statementNode = truncateTableStatement();
              break;
              }
            default:
              jj_la1[4] = jj_gen;
              if (jj_2_2(1)) {
                statementNode = grantStatement();
              } else if (jj_2_3(1)) {
                statementNode = revokeStatement();
              } else {
                switch (jj_nt.kind) {
                case EXECUTE:{
                  statementNode = execStatement();
                  break;
                  }
                case EXPLAIN:{
                  statementNode = explainStatement();
                  break;
                  }
                default:
                  jj_la1[5] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
            }
          }
        }
{if ("" != null) return statementNode;}
      } else {
        switch (jj_nt.kind) {
        case LESS_THAN_OPERATOR:{
          statementNode = extractEscape(tokenHolder);
{if ("" != null) return statementNode;}
          break;
          }
        default:
          jj_la1[7] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

//Gemstone changes Begin
/*
 * <A NAME="extractEscape">extractEscape</A>
 */
  final public StatementNode extractEscape(Token[] tokenHolder) throws ParseException, StandardException {StatementNode statementNode;
    jj_consume_token(LESS_THAN_OPERATOR);
CompilerContext cc=getCompilerContext();
    switch (jj_nt.kind) {
    case COHORT:{
      jj_consume_token(COHORT);
cc.setCohortFlag(true);
      break;
      }
    case GLOBAL:{
      jj_consume_token(GLOBAL);
cc.setGlobalScope();
      break;
      }
    case LOCAL:{
      jj_consume_token(LOCAL);
cc.setLocalScope();
      break;
      }
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(GREATER_THAN_OPERATOR);
    statementNode = StatementPart(tokenHolder);
{if ("" != null) return statementNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="nvlFunction">nvlFunction</A>
 */
  final public ValueNode nvlFunction(String nvl) throws ParseException, StandardException {ValueNodeList expressionList = (ValueNodeList) nodeFactory.getNode(
        C_NodeTypes.VALUE_NODE_LIST,
        getContextManager());
    jj_consume_token(LEFT_PAREN);
    coalesceExpression(expressionList);
    jj_consume_token(COMMA);
    coalesceExpression(expressionList);
    jj_consume_token(RIGHT_PAREN);
{if ("" != null) return (ValueNode)nodeFactory.getNode(
                C_NodeTypes.COALESCE_FUNCTION_NODE,
                nvl,
                expressionList,
                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="decodeFunction">decodeFunction</A>
 */
  final public ValueNode decodeFunction() throws ParseException, StandardException {ValueNode leftExpr;
        ValueNode expr;
    jj_consume_token(LEFT_PAREN);
    leftExpr = additiveExpression(null, 0, false);
    expr = decodeWhenThenExpression(leftExpr);
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="decodeCaseExpression">decodeCaseExpression</A>
 */
  final public ValueNode decodeCaseExpression(ValueNode leftExpr) throws ParseException, StandardException {ValueNode expr;
        ValueNode thenExpr;
    switch (jj_nt.kind) {
    case RIGHT_PAREN:{
      jj_consume_token(RIGHT_PAREN);
ValueNode value = (ValueNode) nodeFactory.getNode(
                                                                                C_NodeTypes.CAST_NODE,
                                                                                (ValueNode)nodeFactory.getNode(C_NodeTypes
                                                                                        .UNTYPED_NULL_CONSTANT_NODE,
                                                                                        getContextManager()),
                                                                                DataTypeDescriptor.getBuiltInDataTypeDescriptor(
                                                                                        Types.CHAR, 1),
                                                                                getContextManager());
                ((CastNode)value).setForExternallyGeneratedCASTnode();
                {if ("" != null) return value;}
      break;
      }
    case COMMA:{
      jj_consume_token(COMMA);
      expr = thenElseExpression();
      switch (jj_nt.kind) {
      case RIGHT_PAREN:{
        jj_consume_token(RIGHT_PAREN);
{if ("" != null) return expr;}
        break;
        }
      case COMMA:{
        thenExpr = decodeThenExpression(leftExpr,
                                (ValueNode)nodeFactory.getNode(
                                                                C_NodeTypes.BINARY_EQUALS_OPERATOR_NODE,
                                                                leftExpr,
                                                                expr,
                                                                getContextManager()));
{if ("" != null) return thenExpr;}
        break;
        }
      default:
        jj_la1[9] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="decodeWhenThenExpression">decodeWhenThenExpression</A>
 */
  final public ValueNode decodeWhenThenExpression(ValueNode leftExpr) throws ParseException, StandardException {ValueNode expr;
        ValueNode thenExpr;
        ValueNode elseExpr;
    jj_consume_token(COMMA);
    expr = additiveExpression(leftExpr, BinaryOperatorNode.EQ, false);
    thenExpr = decodeThenExpression(leftExpr, expr);
{if ("" != null) return thenExpr;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="decodeThenExpression">decodeThenExpression</A>
 */
  final public ValueNode decodeThenExpression(ValueNode leftExpr, ValueNode expr) throws ParseException, StandardException {ValueNode thenExpr;
        ValueNode elseExpr;
    jj_consume_token(COMMA);
    thenExpr = thenElseExpression();
    elseExpr = decodeCaseExpression(leftExpr);
ContextManager cm = getContextManager();
                ValueNodeList thenElseList = (ValueNodeList)nodeFactory.getNode(
                        C_NodeTypes.VALUE_NODE_LIST, cm);
                thenElseList.addElement(thenExpr); // then
                thenElseList.addElement(elseExpr); // else

                {if ("" != null) return ((ValueNode)nodeFactory.getNode(C_NodeTypes.CONDITIONAL_NODE,
                                                                                                expr,
                                                                                                thenElseList,
                                                                                                Boolean.FALSE,
                                                                                                cm));}
    throw new Error("Missing return statement in function");
  }

// GemStone changes END
/*
 * <A NAME="createStatements">spsCreateStatement</A>
 */
  final public StatementNode createStatements() throws ParseException, StandardException {StatementNode statementNode;
        Token beginToken;
        int tokKind;
        //GemStone changes BEGIN
        //[sb] disabling globally literal optimization for 'create view/trigger' etc.
        CompilerContext cc = getCompilerContext();
        cc.allowOptimizeLiteral(false);
        //cc.setPreparedStatement();
        //GemStone changes END

    beginToken = jj_consume_token(CREATE);
cc.markAsDDLForSnappyUse(true);
    switch (jj_nt.kind) {
    case SCHEMA:
    case VIEW:
    case SYNONYM:
    case ROLE:
    case TRIGGER:
    case ALIAS:
    case ASYNCLISTENER:
    case DISKSTORE:
    case HDFSSTORE:
    case GATEWAYSENDER:
    case GATEWAYRECEIVER:{
      switch (jj_nt.kind) {
      case SCHEMA:{
        statementNode = schemaDefinition();
        break;
        }
      case VIEW:{
        statementNode = viewDefinition(beginToken);
        break;
        }
      case TRIGGER:{
        statementNode = triggerDefinition();
        break;
        }
      case SYNONYM:{
        statementNode = synonymDefinition();
        break;
        }
      case ROLE:{
        statementNode = roleDefinition();
        break;
        }
      case ALIAS:{
        //Gemstone changes Begin
                    statementNode = aliasDefinition();
        break;
        }
      case DISKSTORE:{
        statementNode = diskStoreDefinition();
        break;
        }
      case HDFSSTORE:{
        statementNode = hdfsStoreDefinition();
        break;
        }
      case GATEWAYSENDER:{
        statementNode = gatewaySenderDefinition();
        break;
        }
      case ASYNCLISTENER:{
        statementNode = asyncEventListenerDefinition();
        break;
        }
      case GATEWAYRECEIVER:{
        statementNode = gatewayReceiverDefinition();
        break;
        }
      default:
        jj_la1[11] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }

      break;
      }
    case TABLE:{
      statementNode = tableDefinition();

      break;
      }
    case PROCEDURE:{
      statementNode = procedureDefinition();
      break;
      }
    case FUNCTION:{
      statementNode = functionDefinition();
      break;
      }
    case TYPE:{
      statementNode = udtDefinition();
      break;
      }
    case GLOBAL:
    case UNIQUE:
    case INDEX:{
      statementNode = indexDefinition();

      break;
      }
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return statementNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="dropStatements">spsDropStatement</A>
 */
  final public StatementNode dropStatements() throws ParseException, StandardException {StatementNode statementNode;
    jj_consume_token(DROP);
    switch (jj_nt.kind) {
    case SCHEMA:{
      statementNode = dropSchemaStatement();
      break;
      }
    case TABLE:{
      statementNode = dropTableStatement();
      break;
      }
    case INDEX:{
      statementNode = dropIndexStatement();
      break;
      }
    case FUNCTION:
    case PROCEDURE:
    case SYNONYM:
    case TYPE:
    case ALIAS:{
      statementNode = dropAliasStatement();
      break;
      }
    case VIEW:{
      statementNode = dropViewStatement();
      break;
      }
    case TRIGGER:{
      statementNode = dropTriggerStatement();
      break;
      }
    case ROLE:{
      statementNode = dropRoleStatement();
      break;
      }
    case DISKSTORE:{
      statementNode = dropDiskStoreStatement();
      break;
      }
    case HDFSSTORE:{
      statementNode = dropHDFSStoreStatement();
      break;
      }
    case ASYNCLISTENER:{
      statementNode = dropAsyncEventListenerStatement();
      break;
      }
    case GATEWAYSENDER:{
      statementNode = dropGatewaySenderStatement();
      break;
      }
    case GATEWAYRECEIVER:{
      statementNode = dropGatewayReceiverStatement();
      break;
      }
    default:
      jj_la1[13] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return statementNode;}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode alterHdfsStoreStatement() throws ParseException, StandardException {StatementNode           node;
        String              storeName;
    Map otherAttribs = new HashMap();
    jj_consume_token(HDFSSTORE);
    storeName = identifier(Limits.MAX_IDENTIFIER_LENGTH,true);
    label_1:
    while (true) {
      switch (jj_nt.kind) {
      case SET:{
        ;
        break;
        }
      default:
        jj_la1[14] = jj_gen;
        break label_1;
      }
      jj_consume_token(SET);
      populateAlterHDFSAttributes(otherAttribs);
    }
{if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                               C_NodeTypes.ALTER_HDFS_STORE_NODE,
                                                               storeName,
                                                               otherAttribs,
                                                               getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public void populateAlterHDFSAttributes(Map otherAttribs) throws ParseException, StandardException {Token tok;
        ValueNode val;
        Token bool ;
        BigDecimal interval = new BigDecimal("1");
    switch (jj_nt.kind) {
    case BATCHSIZE:
    case MAXINPUTFILESIZE:
    case MININPUTFILECOUNT:
    case MAXINPUTFILECOUNT:
    case MINORCOMPACTIONTHREADS:
    case MAJORCOMPACTIONTHREADS:
    case MAXWRITEONLYFILESIZE:{
      switch (jj_nt.kind) {
      case BATCHSIZE:{
        tok = jj_consume_token(BATCHSIZE);
        break;
        }
      case MAXINPUTFILESIZE:{
        tok = jj_consume_token(MAXINPUTFILESIZE);
        break;
        }
      case MININPUTFILECOUNT:{
        tok = jj_consume_token(MININPUTFILECOUNT);
        break;
        }
      case MAXINPUTFILECOUNT:{
        tok = jj_consume_token(MAXINPUTFILECOUNT);
        break;
        }
      case MINORCOMPACTIONTHREADS:{
        tok = jj_consume_token(MINORCOMPACTIONTHREADS);
        break;
        }
      case MAJORCOMPACTIONTHREADS:{
        tok = jj_consume_token(MAJORCOMPACTIONTHREADS);
        break;
        }
      case MAXWRITEONLYFILESIZE:{
        tok = jj_consume_token(MAXWRITEONLYFILESIZE);
        break;
        }
      default:
        jj_la1[15] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      val = intLiteral();
if (getIntValue(val) < 0)
             {
                {if (true) throw StandardException.newException(SQLState.LANG_INVALID_COLUMN_LENGTH,
                "Value " + getIntValue(val) + " is negative");}
             }
             addToMapAllowOnce(otherAttribs, tok.image, val);
      break;
      }
    case MAJORCOMPACTIONINTERVAL:
    case PURGEINTERVAL:{
      switch (jj_nt.kind) {
      case MAJORCOMPACTIONINTERVAL:{
        tok = jj_consume_token(MAJORCOMPACTIONINTERVAL);
        break;
        }
      case PURGEINTERVAL:{
        tok = jj_consume_token(PURGEINTERVAL);
        break;
        }
      default:
        jj_la1[16] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      val = getIntervalInMins();
if (getIntValue(val) < 1)
         {
            {if (true) throw StandardException.newException(SQLState.LANG_INVALID_COLUMN_LENGTH,
               "Value in minutes " + getIntValue(val) + " is less than 1");}
         }
         addToMapAllowOnce(otherAttribs, tok.image, val);
      break;
      }
    case WRITEONLYFILEROLLOVERINTERVAL:{
      tok = jj_consume_token(WRITEONLYFILEROLLOVERINTERVAL);
      val = getIntervalInSecs();
if (getIntValue(val) < 1)
         {
            {if (true) throw StandardException.newException(SQLState.LANG_INVALID_COLUMN_LENGTH,
               "Value in seconds " + getIntValue(val) + " is less than 1");}
         }
         addToMapAllowOnce(otherAttribs, tok.image, val);
      break;
      }
    case BATCHTIMEINTERVAL:{
      tok = jj_consume_token(BATCHTIMEINTERVAL);
      val = getIntervalInMillis();
if (getIntValue(val) < 1)
         {
            {if (true) throw StandardException.newException(SQLState.LANG_INVALID_COLUMN_LENGTH,
               "Value in milliseconds " + getIntValue(val) + " is less than 1");}
         }
         addToMapAllowOnce(otherAttribs, tok.image, val);
      break;
      }
    case MINORCOMPACT:
    case MAJORCOMPACT:{
      switch (jj_nt.kind) {
      case MINORCOMPACT:{
        tok = jj_consume_token(MINORCOMPACT);
        break;
        }
      case MAJORCOMPACT:{
        tok = jj_consume_token(MAJORCOMPACT);
        break;
        }
      default:
        jj_la1[17] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      bool = booleanLiteral();
addToMapAllowOnce(otherAttribs, tok.image, bool.image);
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * <A NAME="spsAlterStatement">spsAlterStatement</A>
 */
  final public StatementNode spsAlterStatement() throws ParseException, StandardException {StatementNode statementNode;
    jj_consume_token(ALTER);
    switch (jj_nt.kind) {
    case TABLE:{
      statementNode = alterTableStatement();
      break;
      }
    case HDFSSTORE:{
      statementNode = alterHdfsStoreStatement();
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return statementNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="spsSetStatement">spsSetStatement</A>
 */
  final public StatementNode spsSetStatement() throws ParseException, StandardException {StatementNode statementNode;
        CompilerContext cc = getCompilerContext();
  cc.markAsDDLForSnappyUse(true);
    if (getToken(1).kind == SET && getToken(2).kind != CURRENT) {
      jj_consume_token(SET);
      if (jj_2_5(1)) {
        statementNode = setIsolationStatement();
      } else if (jj_2_6(1)) {
        statementNode = setSchemaStatement();
      } else {
        switch (jj_nt.kind) {
        case MESSAGE_LOCALE:{
          statementNode = setMessageLocaleStatement();
          break;
          }
        case ROLE:{
          statementNode = setRoleStatement();
          break;
          }
        default:
          jj_la1[20] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
{if ("" != null) return statementNode;}
    } else if (getToken(1).kind == SET && getToken(2).kind == CURRENT) {
      jj_consume_token(SET);
      if (jj_2_7(1)) {
        statementNode = setSchemaStatement();
      } else if (jj_2_8(1)) {
        statementNode = setIsolationStatement();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return statementNode;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="preparableSQLDataStatement">preparableSQLDataStatement</A>
 *
 * preparableSQLDataStatement differs from
 * directSQLDataStatement in that it
 * supports positioned update and delete
 * and a preparable select (with FOR UPDATE)
 * instead of a direct select (without FOR UPDATE)
 */
  final public StatementNode preparableSQLDataStatement() throws ParseException, StandardException {StatementNode   dmlStatement;
        CompilerContext cc = getCompilerContext();
    switch (jj_nt.kind) {
    case DELETE:{
      /*
      	** RESOLVE: Ignoring temporary table declarations for now.
      	*/
              dmlStatement = preparableDeleteStatement();
cc.popDML(0);
                {if ("" != null) return dmlStatement;}
      break;
      }
    case SELECT:
    case VALUES:
    case LEFT_PAREN:{
      dmlStatement = preparableSelectStatement(true);
{if ("" != null) return dmlStatement;}
      break;
      }
    case INSERT:
    case PUT:{
      dmlStatement = insertStatement();
cc.popDML(0);
                {if ("" != null) return dmlStatement;}
      break;
      }
    case UPDATE:{
      dmlStatement = preparableUpdateStatement();
cc.popDML(0);
                {if ("" != null) return dmlStatement;}
      break;
      }
    case CALL:
    case LEFT_BRACE:
    case QUESTION_MARK:{
      dmlStatement = callStatement();
{if ("" != null) return dmlStatement;}
      break;
      }
    case ROLLBACK:
    case RELEASE:
    case SAVEPOINT:{
      dmlStatement = savepointStatement();
{if ("" != null) return dmlStatement;}
      break;
      }
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="preparableDeleteStatement">preparableDeleteStatement</A>
 *
 *	This may be a search or positioned delete statement.
 */
  final public StatementNode preparableDeleteStatement() throws ParseException, StandardException {StatementNode qtn;
    jj_consume_token(DELETE);
getCompilerContext().pushDML(0);
    qtn = deleteBody();
{if ("" != null) return qtn;}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode deleteBody() throws ParseException, StandardException {JavaToSQLValueNode      javaToSQLNode = null;
        String                          correlationName = null;
        TableName  tableName = null;
        ValueNode  whereClause = null;
        FromTable  fromTable = null;
        QueryTreeNode retval;
        Properties targetProperties = null;
        Token      whereToken = null;
    if (fromNewInvocationFollows()) {
      jj_consume_token(FROM);
      javaToSQLNode = newInvocation();
      switch (jj_nt.kind) {
      case WHERE:{
        whereToken = jj_consume_token(WHERE);
        whereClause = whereClause(whereToken);
        break;
        }
      default:
        jj_la1[22] = jj_gen;
        ;
      }
fromTable =  (FromTable) nodeFactory.getNode(
                                                                        C_NodeTypes.FROM_VTI,
                                                                        javaToSQLNode.getJavaValueNode(),
                                                                        (String) null,
                                                                        null,
                                                                        (Properties) null,
                                                                        getContextManager());

                {if ("" != null) return getDeleteNode(fromTable, tableName, whereClause);}
    } else {
      switch (jj_nt.kind) {
      case FROM:{
        jj_consume_token(FROM);
        tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
        if ((getToken(1).kind != EOF)
                          // GemStone changes BEGIN
                          && getToken(1).kind != SEMICOLON
                          // GemStone changes END
                                && (getToken(1).kind != WHERE) && !derbyPropertiesListFollows()) {
          switch (jj_nt.kind) {
          case AS:{
            jj_consume_token(AS);
            break;
            }
          default:
            jj_la1[23] = jj_gen;
            ;
          }
          correlationName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
        } else {
          ;
        }
        switch (jj_nt.kind) {
        case GEMFIREXDDASHPROPERTIES:{
          targetProperties = propertyList(false);
          jj_consume_token(CHECK_PROPERTIES);
          break;
          }
        default:
          jj_la1[24] = jj_gen;
          ;
        }
        switch (jj_nt.kind) {
        case WHERE:{
          whereToken = jj_consume_token(WHERE);
          if ((getToken(1).kind == CURRENT) &&
                                                   (getToken(2).kind == OF)) {
            fromTable = currentOfClause(correlationName);
          } else if (jj_2_9(1)) {
            whereClause = whereClause(whereToken);
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[25] = jj_gen;
          ;
        }
/* Fabricate a ResultSetNode (SelectNode) under the DeleteNode.
		 * For a searched delete,
		 * The FromList is simply the table that we are deleting from.
		 * (NOTE - we mark the table as the one that we are deleting from.)
		 * For a positioned delete,
		 * the FromList is a CurrentOfNode holding the cursor name.
		 * The select list will be null for now.  We will generate it at
	 	 * bind time, in keeping with the design decision that the parser's
	  	 * output should look like the language.
		 */
                if (fromTable == null)
                        fromTable = (FromTable) nodeFactory.getNode(
                                                                                C_NodeTypes.FROM_BASE_TABLE,
                                                                                tableName,
                                                                                correlationName,
                                                                                ReuseFactory.getInteger(
                                                                                                FromBaseTable.DELETE),
                                                                                null,
                                                                                getContextManager());

                /* Update the FromTable with any properties, if non-null */
                if (targetProperties != null)
                {
                        if (SanityManager.DEBUG)
                        {
                                if (((FromBaseTable) fromTable).getProperties() != null)
                                {
                                        SanityManager.THROWASSERT(
                                                "Overwriting existing properties");
                                }
                        }
                        ((FromBaseTable) fromTable).setTableProperties(targetProperties);
                }

// GemStone changes BEGIN
                if (getLanguageConnectionContext().getDataDictionary()
                        .getBuiltinVTIClass(tableName.getSchemaName(),
                        tableName.getTableName()) != null)
                {
                   // We do not allow users to DELETE from the built-inVTIs
                   {if (true) throw StandardException.newException(SQLState.LANG_UPDATE_SYSTEM_TABLE_ATTEMPTED,
                                                tableName);}
                }
// GemStone changes END
                {if ("" != null) return getDeleteNode(fromTable, tableName, whereClause);}
        break;
        }
      default:
        jj_la1[26] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="currentOfClause">currentOfClause</A>
 */
  final public FromTable currentOfClause(String correlationName) throws ParseException, StandardException {String cursorName = null;
    jj_consume_token(CURRENT);
    jj_consume_token(OF);
    cursorName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
// Gemstone changes BEGIN
                // GemFireXD does not support WHERE CURRENT OF for DELETE or UPDATE
                // Block here instead of in Delete/UpdateNode
                if (!getLanguageConnectionContext().ignoreWhereCurrentOfUnsupportedException()) {
                   {if (true) throw StandardException.newException(SQLState.NOT_IMPLEMENTED, "update where current of");}
                }
                // Gemstone changes END

                {if ("" != null) return (FromTable) nodeFactory.getNode(
                                                                C_NodeTypes.CURRENT_OF_NODE,
                                                                correlationName,
                                                                cursorName,
                                                                null,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="preparableSelectStatement">preparableSelectStatement</A>
 *
 *
 *	The preparable select statement is a superset of
 *	the directSelectStatementMultipleRows in that it
 *	allows both the preparable single row select statement
 *	(a query expression that returns one row, although it
 *	is also handled like a cursor) and the preparable
 *	multiple row select statement, which allows not only
 *	an order by clause but also a for update clause.
 */
  final public CursorNode preparableSelectStatement(boolean checkParams) throws ParseException, StandardException {ResultSetNode     queryExpression;
        Vector  updateColumns = new Vector();
        int               forUpdateState = CursorNode.UNSPECIFIED;
        int                               isolationLevel = ExecutionContext.UNSPECIFIED_ISOLATION_LEVEL;
        CursorNode                retval;
        OrderByList orderCols = null;
    ValueNode offset = null;
    ValueNode fetchFirst = null;
    queryExpression = queryExpression(null, NO_SET_OP);
    switch (jj_nt.kind) {
    case ORDER:{
      orderCols = orderByClause();
      break;
      }
    default:
      jj_la1[27] = jj_gen;
      ;
    }
    switch (jj_nt.kind) {
    case OFFSET:{
      offset = offsetClause();
      break;
      }
    default:
      jj_la1[28] = jj_gen;
      ;
    }
    switch (jj_nt.kind) {
    case FETCH:{
      fetchFirst = fetchFirstClause();
      break;
      }
    default:
      jj_la1[29] = jj_gen;
      ;
    }
    switch (jj_nt.kind) {
    case FOR:{
      jj_consume_token(FOR);
      forUpdateState = forUpdateClause(updateColumns);
      break;
      }
    default:
      jj_la1[30] = jj_gen;
      ;
    }
    switch (jj_nt.kind) {
    case WITH:{
      isolationLevel = atIsolationLevel();
      break;
      }
    default:
      jj_la1[31] = jj_gen;
      ;
    }
// Note: if order by is specified, the for update clause
                // must be READ ONLY or empty, and the cursor
                // is implicitly READ_ONLY.

                retval = (CursorNode) nodeFactory.getNode(
                                C_NodeTypes.CURSOR_NODE,
                                "SELECT",
                                queryExpression,
                                null,
                                orderCols,
                offset,
                fetchFirst,
                                ReuseFactory.getInteger(forUpdateState),
                                (forUpdateState == CursorNode.READ_ONLY ? null : updateColumns ),
                                getContextManager());

                if (checkParams)
                {
                        setUpAndLinkParameters();
                }

                /* Set the isolation levels for the scans if specified */
                if (isolationLevel != ExecutionContext.UNSPECIFIED_ISOLATION_LEVEL)
                {
                        getCompilerContext().setScanIsolationLevel(isolationLevel);
                }

                {if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="insertStatement">insertStatement</A>
 */
  final public StatementNode insertStatement() throws ParseException, StandardException {StatementNode   insertNode;
        QueryTreeNode   targetTable;
        getCompilerContext().pushDML(0);
        boolean isPutDML;
    switch (jj_nt.kind) {
    case INSERT:{
      jj_consume_token(INSERT);
      jj_consume_token(INTO);
      targetTable = targetTable();
isPutDML = false;
      insertNode = insertColumnsAndSource(targetTable, isPutDML);
setUpAndLinkParameters();

                {if ("" != null) return insertNode;}
      break;
      }
    case PUT:{
      jj_consume_token(PUT);
      jj_consume_token(INTO);
      targetTable = targetTable();
isPutDML = true;
      insertNode = insertColumnsAndSource(targetTable, isPutDML);
setUpAndLinkParameters();

               {if ("" != null) return insertNode;}
      break;
      }
    default:
      jj_la1[32] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public QueryTreeNode targetTable() throws ParseException, StandardException {JavaToSQLValueNode      javaToSQLNode = null;
        String                          correlationName = null;
        TableName                       tableName;
    if (newInvocationFollows(1)) {
      javaToSQLNode = newInvocation();
{if ("" != null) return nodeFactory.getNode(
                                                                C_NodeTypes.FROM_VTI,
                                                                javaToSQLNode.getJavaValueNode(),
                                                                correlationName,
                                                                null,
                                                                (Properties) null,
                                                                getContextManager());}
    } else if (jj_2_10(1)) {
      tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
// GemStone changes BEGIN
                if (getLanguageConnectionContext().getDataDictionary()
                        .getBuiltinVTIClass(tableName.getSchemaName(),
                        tableName.getTableName()) != null)
                {
                   // We do not allow users to INSERT to the built-inVTIs
                   {if (true) throw StandardException.newException(SQLState.LANG_UPDATE_SYSTEM_TABLE_ATTEMPTED,
                                                tableName);}
                }
// GemStone changes END
                {if ("" != null) return tableName;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="preparableUpdateStatement">preparableUpdateStatement</A>
 */
  final public StatementNode preparableUpdateStatement() throws ParseException, StandardException {StatementNode qtn;
        getCompilerContext().pushDML(0);
    jj_consume_token(UPDATE);
    qtn = updateBody();
{if ("" != null) return qtn;}
    throw new Error("Missing return statement in function");
  }

  final public boolean tableOrIndex() throws ParseException {
    switch (jj_nt.kind) {
    case TABLE:{
      jj_consume_token(TABLE);
{if ("" != null) return true;}
      break;
      }
    case INDEX:{
      jj_consume_token(INDEX);
{if ("" != null) return false;}
      break;
      }
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public StatementNode updateBody() throws ParseException, StandardException {ResultColumnList        columnList;
        String                          correlationName = null;
        JavaToSQLValueNode      javaToSQLNode = null;
        TableName  tableName = null;
        ValueNode  whereClause = null;
        FromTable  fromTable = null;
        Properties targetProperties = null;
        Token      whereToken = null;
    if (newInvocationFollows(1)) {
      javaToSQLNode = newInvocation();
      jj_consume_token(SET);
      columnList = setClauseList();
      switch (jj_nt.kind) {
      case WHERE:{
        whereToken = jj_consume_token(WHERE);
        whereClause = whereClause(whereToken);
        break;
        }
      default:
        jj_la1[34] = jj_gen;
        ;
      }
fromTable =  (FromTable) nodeFactory.getNode(
                                                                        C_NodeTypes.FROM_VTI,
                                                                        javaToSQLNode.getJavaValueNode(),
                                                                        (String) null,
                                                                        null,
                                                                        (Properties) null,
                                                                        getContextManager());

                {if ("" != null) return getUpdateNode(fromTable, tableName, columnList, whereClause);}
    } else if (jj_2_12(1)) {
      tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
      if ((getToken(1).kind != SET) && !derbyPropertiesListFollows()) {
        switch (jj_nt.kind) {
        case AS:{
          jj_consume_token(AS);
          break;
          }
        default:
          jj_la1[35] = jj_gen;
          ;
        }
        correlationName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
      } else {
        ;
      }
      switch (jj_nt.kind) {
      case GEMFIREXDDASHPROPERTIES:{
        targetProperties = propertyList(false);
        jj_consume_token(CHECK_PROPERTIES);
        break;
        }
      default:
        jj_la1[36] = jj_gen;
        ;
      }
      jj_consume_token(SET);
      columnList = setClauseList();
      switch (jj_nt.kind) {
      case WHERE:{
        whereToken = jj_consume_token(WHERE);
        if (jj_2_11(1)) {
          whereClause = whereClause(whereToken);
        } else {
          switch (jj_nt.kind) {
          case CURRENT:{
            fromTable = currentOfClause(correlationName);
            break;
            }
          default:
            jj_la1[37] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[38] = jj_gen;
        ;
      }
/* Fabricate a ResultSetNode (SelectNode) under the UpdateNode.
		 * For a searched update,
		 * The FromList is simply the table that we are updating.
		 * For a positioned update,
		 * the FromList is a CurrentOfNode holding the cursor name.
		 * (NOTE - we mark the table as the one that we are updating.)
		 * The select list is the columns in the SET clause.  At bind time,
	 	 * we will prepend the CurrentRowLocation() in keeping with the design 
		 * decision that the parser's output should look like the language.
		 */
                if (fromTable == null)
// GemStone changes BEGIN
                {
                        // check for update on VTIs
                        if (getLanguageConnectionContext().getDataDictionary()
                                .getBuiltinVTIClass(tableName.getSchemaName(),
                                tableName.getTableName()) != null) {
                           // We do not allow users to UPDATE the built-inVTIs
                           {if (true) throw StandardException.newException(SQLState.LANG_UPDATE_SYSTEM_TABLE_ATTEMPTED,
                                                tableName);}
                        }
                        else {
// GemStone changes END
                        fromTable = (FromTable) nodeFactory.getNode(
                                                                                C_NodeTypes.FROM_BASE_TABLE,
                                                                                tableName,
                                                                                correlationName,
                                                                                ReuseFactory.getInteger(
                                                                                                                FromBaseTable.UPDATE),
                                                                                null,
                                                                                getContextManager());
// GemStone changes BEGIN
                        }
                }
// GemStone changes END

                /* Update the FromTable with any properties, if non-null */
                if (targetProperties != null)
                {
                        if (SanityManager.DEBUG)
                        {
                                if (((FromBaseTable) fromTable).getProperties() != null)
                                {
                                        SanityManager.THROWASSERT(
                                                "Overwriting existing properties");
                                }
                        }
                        ((FromBaseTable) fromTable).setTableProperties(targetProperties);
                }
                {if ("" != null) return getUpdateNode(fromTable, tableName, columnList, whereClause);}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="callStatement">callStatement</A>
 */
  final public StatementNode callStatement() throws ParseException, StandardException {StatementNode retval;
    switch (jj_nt.kind) {
    case CALL:
    case QUESTION_MARK:{
      retval = bareCallStatement();
      break;
      }
    case LEFT_BRACE:{
      jj_consume_token(LEFT_BRACE);
      retval = bareCallStatement();
      jj_consume_token(RIGHT_BRACE);
      break;
      }
    default:
      jj_la1[39] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="bareCallStatement">baseCallStatement</A>
 */
  final public StatementNode bareCallStatement() throws ParseException, StandardException {ParameterNode           returnParam;

        ValueNode                       value;

        ResultSetNode           resultSetNode;
//Gemstone changes Begin	

    boolean coordinateNode=false;
    FromList fromList = (FromList) nodeFactory.getNode(
                                                                        C_NodeTypes.FROM_LIST,
                                                                        getNodeFactory().doJoinOrderOptimization(),
                                                                        getContextManager());
    FromTable tableReference;
        Token               whereToken=null;
    ValueNode           whereClause=null;
    Boolean             all=Boolean.FALSE;
    Boolean             nowait=Boolean.FALSE;
    ServerGroupsTableAttribute serverGroups =
                new ServerGroupsTableAttribute();
        String javaClassName=null;
        String aliasName=null;

        //[sb] disabling by indicating 'call <... >' as PS type.
        getCompilerContext().allowOptimizeLiteral(false);
        //getCompilerContext().setPreparedStatement();
 //Gemstone changes End   	

    switch (jj_nt.kind) {
    case CALL:{
      jj_consume_token(CALL);
      value = primaryExpression(true);
      switch (jj_nt.kind) {
      case WITH:{
        jj_consume_token(WITH);
        jj_consume_token(RESULT);
        jj_consume_token(PROCESSOR);
coordinateNode=true;
        if (javaClassFollowsProcedureCall()) {
          javaClassName = javaClass();
          switch (jj_nt.kind) {
          case DOUBLE_COLON:{
            jj_consume_token(DOUBLE_COLON);
            break;
            }
          default:
            jj_la1[40] = jj_gen;
            ;
          }
        } else if (jj_2_13(1)) {
          aliasName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[41] = jj_gen;
        ;
      }
      switch (jj_nt.kind) {
      case ON:{
        jj_consume_token(ON);
coordinateNode=true;
        switch (jj_nt.kind) {
        case TABLE:{
          jj_consume_token(TABLE);
          tableReference = tableReferenceTypes(false);
fromList.addFromTable(tableReference);
          switch (jj_nt.kind) {
          case WHERE:{
            whereToken = jj_consume_token(WHERE);
            whereClause = whereClause(whereToken);
            break;
            }
          default:
            jj_la1[42] = jj_gen;
            ;
          }
          break;
          }
        case ALL:{
          jj_consume_token(ALL);
all=Boolean.TRUE;
          break;
          }
        case SERVER:{
          serverGroupDefinition(serverGroups);
          break;
          }
        default:
          jj_la1[43] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        ;
      }
      switch (jj_nt.kind) {
      case NOWAIT:{
        jj_consume_token(NOWAIT);
nowait = Boolean.TRUE;
        break;
        }
      default:
        jj_la1[45] = jj_gen;
        ;
      }
if (! (value instanceof JavaToSQLValueNode) ||
                        ! (((JavaToSQLValueNode) value).getJavaValueNode() instanceof MethodCallNode))
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_INVALID_CALL_STATEMENT);}
                }

                //Gemstone changes Begin
        if(coordinateNode) {

              ProcedureProcessorNode processorNode=
                      (ProcedureProcessorNode)nodeFactory.getNode(C_NodeTypes.PROCEDURE_PROCESSOR_NODE,
                      javaClassName,
                      aliasName,
                      getContextManager());
              JavaValueNode jvn=((JavaToSQLValueNode) value).getJavaValueNode();
              assert jvn instanceof StaticMethodCallNode;
              StaticMethodCallNode callNode=(StaticMethodCallNode)jvn;
              DistributedProcedureCallNode distributedCallNode=
                (DistributedProcedureCallNode)nodeFactory.getNode(
                                                C_NodeTypes.DISTRIBUTED_PROCEDURE_CALL_NODE,
                                                                                                jvn,
                                                                                                processorNode,
                                                                                                fromList,
                                                                                                whereClause,
                                                                                                all,
                                                                                                serverGroups,
                                                                                                nowait,
                                                                                                getContextManager());
             value=(ValueNode) nodeFactory.getNode(
                                                           C_NodeTypes.JAVA_TO_SQL_VALUE_NODE,
                                                                distributedCallNode,
                                                                getContextManager());
        }
                StatementNode callStatement =
                                                                        (StatementNode) nodeFactory.getNode(
                                                                                                C_NodeTypes.CALL_STATEMENT_NODE,
                                                                                                value,
                                                                                                getContextManager());

//Gemstone changes End
                setUpAndLinkParameters();

                {if ("" != null) return callStatement;}
      break;
      }
    case QUESTION_MARK:{
      returnParam = dynamicParameterSpecification();
getCompilerContext().setReturnParameterFlag(); //bug4450

      jj_consume_token(EQUALS_OPERATOR);
      jj_consume_token(CALL);
      resultSetNode = rowValueConstructor(null);
// validate that we have something that is an appropriate call statement
                ResultColumnList rcl = resultSetNode.getResultColumns();

                // we can have only 1 return value/column
                if (rcl == null || rcl.size() > 1)
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_INVALID_CALL_STATEMENT);}
                }

                // we must have a method call node
                value = ((ResultColumn) rcl.elementAt(0)).getExpression();
                if (! (value instanceof JavaToSQLValueNode) ||
                        ! (((JavaToSQLValueNode) value).getJavaValueNode() instanceof MethodCallNode))
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_INVALID_CALL_STATEMENT);}
                }

                // wrap the row result set in a cursor node
                StatementNode cursorNode =
                                        (StatementNode) nodeFactory.getNode(
                                                C_NodeTypes.CURSOR_NODE,
                                                "SELECT",
                                                resultSetNode,
                                                null,
                                                null,
                        null,
                        null,
                                                ReuseFactory.getInteger(CursorNode.READ_ONLY),
                                                null,
                                                getContextManager());

                // set the 0th param to be a RETURN param
                returnParam.setReturnOutputParam(value);

                setUpAndLinkParameters();

                {if ("" != null) return cursorNode;}
      break;
      }
    default:
      jj_la1[46] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="primaryExpression">primaryExpression</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode primaryExpression(boolean inSelectClause) throws ParseException, StandardException {ValueNode                       value = null;
    if (getToken(2).kind == PERIOD &&
                    getToken(4).kind == LEFT_PAREN) {
      value = routineInvocation();
{if ("" != null) return value;}
    } else if (jj_2_14(1)) {
      value = primaryExpressionXX(inSelectClause);
{if ("" != null) return value;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/* 
 * <A NAME="savepointStatement">savepointStatement</A>

	savepointStatementClauses contains the UNIQUE, ON ROLLBACK RETAIN LOCKS, ON ROLLBACK RETAIN CURSORS clauses.

	0 - Boolean - UNIQUE clause
	1 - Boolean - ON ROLLBACK RETAIN LOCKS clause
	2 - Boolean - ON ROLLBACK RETAIN CURSORS clause
 */
  final public StatementNode savepointStatement() throws ParseException, StandardException {String                  savepointName = null;
        int                     savepointStatementType;
        Object[] savepointStatementClauses = new Object[3];
    switch (jj_nt.kind) {
    case SAVEPOINT:{
      jj_consume_token(SAVEPOINT);
      savepointName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
      label_2:
      while (true) {
        savepointStatementClause(savepointStatementClauses);
        switch (jj_nt.kind) {
        case ON:
        case UNIQUE:{
          ;
          break;
          }
        default:
          jj_la1[47] = jj_gen;
          break label_2;
        }
      }
//ON ROLLBACK RETAIN CURSORS is mandatory
                if (savepointStatementClauses[2] == null)
                                {if (true) throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR, "MISSING ON ROLLBACK RETAIN CURSORS");}
                savepointStatementType = 1;
      break;
      }
    case ROLLBACK:{
      jj_consume_token(ROLLBACK);
      switch (jj_nt.kind) {
      case WORK:{
        jj_consume_token(WORK);
        break;
        }
      default:
        jj_la1[48] = jj_gen;
        ;
      }
      jj_consume_token(TO);
      jj_consume_token(SAVEPOINT);
      if (jj_2_15(1)) {
        savepointName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
      } else {
        ;
      }
savepointStatementType = 2;
      break;
      }
    case RELEASE:{
      jj_consume_token(RELEASE);
      switch (jj_nt.kind) {
      case TO:{
        jj_consume_token(TO);
        break;
        }
      default:
        jj_la1[49] = jj_gen;
        ;
      }
      jj_consume_token(SAVEPOINT);
      savepointName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
savepointStatementType = 3;
      break;
      }
    default:
      jj_la1[50] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.SAVEPOINT_NODE,
                                                                savepointName,
                                                                ReuseFactory.getInteger(savepointStatementType),
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public void savepointStatementClause(Object[] savepointStatementClauses) throws ParseException, StandardException {int clausePosition = -1;
    switch (jj_nt.kind) {
    case UNIQUE:{
      jj_consume_token(UNIQUE);
clausePosition = 0;
      break;
      }
    case ON:{
      jj_consume_token(ON);
      jj_consume_token(ROLLBACK);
      jj_consume_token(RETAIN);
      clausePosition = LocksOrCursors();
      break;
      }
    default:
      jj_la1[51] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (clausePosition != -1) {
                        // check for repeated clause
                        if (savepointStatementClauses[clausePosition] != null) {

                                String which = SAVEPOINT_CLAUSE_NAMES[clausePosition];
                                {if (true) throw StandardException.newException(SQLState.LANG_DB2_MULTIPLE_ELEMENTS, which);}
                        }

                        savepointStatementClauses[clausePosition] = Boolean.TRUE;
                }
  }

/*
 * <A NAME="LocksOrCursors">LocksOrCursors</A>
 */
  final public int LocksOrCursors() throws ParseException {
    switch (jj_nt.kind) {
    case LOCKS:{
      jj_consume_token(LOCKS);
{if ("" != null) return (1);}
      break;
      }
    case CURSORS:{
      jj_consume_token(CURSORS);
{if ("" != null) return (2);}
      break;
      }
    default:
      jj_la1[52] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/* 
 * <A NAME="globalTemporaryTableDeclaration">globalTemporaryTableDeclaration</A>

	declareTableClauses contains the NOT LOGGED, on commit and on rollback clauses.

	0 - Boolean - NOT LOGGED clause
	1 - Boolean - on commit behavior
	2 - Boolean - on rollback behavior
 */
  final public StatementNode globalTemporaryTableDeclaration() throws ParseException, StandardException {TableName                       tableName;
        TableElementList tableElementList;
        Object[] declareTableClauses = new Object[3];
    jj_consume_token(DECLARE);
    jj_consume_token(GLOBAL);
    jj_consume_token(TEMPORARY);
    jj_consume_token(TABLE);
    tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    tableElementList = tableElementList();
    label_3:
    while (true) {
      declareTableClause(declareTableClauses);
      if (jj_2_16(1)) {
        ;
      } else {
        break label_3;
      }
    }
// NOT LOGGED is mandatory
                if (declareTableClauses[0] == null)
                                {if (true) throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR, "MISSING NOT LOGGED");}
                // if ON COMMIT behavior not explicitly specified in DECLARE command, resort to default ON COMMIT DELETE ROWS
                if (declareTableClauses[1] == null)
                                declareTableClauses[1] = Boolean.TRUE;
                // if ON ROLLBACK behavior not explicitly specified in DECLARE command, resort to default ON ROLLBACK DELETE ROWS
                if (declareTableClauses[2] == null)
                                declareTableClauses[2] = Boolean.TRUE;
                {if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.CREATE_TABLE_NODE,
                                                                tableName,
                                                                tableElementList,
                                                                (Properties)null,
                                                                (Boolean) declareTableClauses[1],
                                                                (Boolean) declareTableClauses[2],
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public void declareTableClause(Object[] declareTableClauses) throws ParseException, StandardException {int clausePosition = -1;
        Object clauseValue = null;
    switch (jj_nt.kind) {
    case NOT:{
      jj_consume_token(NOT);
      jj_consume_token(LOGGED);
clauseValue = Boolean.TRUE; clausePosition = 0;
      break;
      }
    default:
      jj_la1[53] = jj_gen;
      if (getToken(1).kind == ON && getToken(2).kind == COMMIT) {
        jj_consume_token(ON);
        jj_consume_token(COMMIT);
        clauseValue = onCommit();
        jj_consume_token(ROWS);
clausePosition = 1;
      } else if (getToken(1).kind == ON && getToken(2).kind == ROLLBACK) {
        jj_consume_token(ON);
        jj_consume_token(ROLLBACK);
        jj_consume_token(DELETE);
        jj_consume_token(ROWS);
clauseValue = Boolean.TRUE; clausePosition = 2;
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
if (clausePosition != -1) {
                        // check for repeated clause
                        if (declareTableClauses[clausePosition] != null) {

                                String which = TEMPORARY_TABLE_CLAUSE_NAMES[clausePosition];
                                {if (true) throw StandardException.newException(SQLState.LANG_DB2_MULTIPLE_ELEMENTS, which);}
                        }

                        declareTableClauses[clausePosition] = clauseValue;
                }
  }

/*
 * <A NAME="onCommit">onCommit</A>
 */
  final public Boolean onCommit() throws ParseException {
    switch (jj_nt.kind) {
    case PRESERVE:{
      jj_consume_token(PRESERVE);
{if ("" != null) return (Boolean.FALSE);}
      break;
      }
    case DELETE:{
      jj_consume_token(DELETE);
{if ("" != null) return (Boolean.TRUE);}
      break;
      }
    default:
      jj_la1[54] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="tableElementList">tableElementList</A>
 */
  final public TableElementList tableElementList() throws ParseException, StandardException {TableElementList        tableElementList =
                                        (TableElementList) nodeFactory.getNode(
                                                                        C_NodeTypes.TABLE_ELEMENT_LIST,
                                                                        getContextManager());
    jj_consume_token(LEFT_PAREN);
    tableElement(tableElementList);
    label_4:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[55] = jj_gen;
        break label_4;
      }
      jj_consume_token(COMMA);
      tableElement(tableElementList);
    }
    jj_consume_token(RIGHT_PAREN);
{if ("" != null) return tableElementList;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="tableElement">tableElement</A>
 */
  final public void tableElement(TableElementList tableElementList) throws ParseException, StandardException {TableElementNode        tableElement;
        //initialize following two booleans for every new table element so that the
        //values from previous tableElement doesn't impact the next tableElement
        explicitNotNull = false;
        explicitNull = false;
    if (jj_2_17(1)) {
      tableElement = columnDefinition(tableElementList);
tableElementList.addTableElement(tableElement);
    } else {
      switch (jj_nt.kind) {
      case CHECK:
      case CONSTRAINT:
      case FOREIGN:
      case PRIMARY:
      case UNIQUE:{
        tableElement = tableConstraintDefinition();
tableElementList.addTableElement(tableElement);
        break;
        }
      default:
        jj_la1[56] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/*
 * <A NAME="columnDefinition">columnDefinition</A>
 */
  final public TableElementNode columnDefinition(TableElementList tableElementList) throws ParseException, StandardException {DataTypeDescriptor[]    typeDescriptor = new DataTypeDescriptor[1];
        ValueNode                       defaultNode = null;
        String                          columnName;
// GemStone changes BEGIN
        long[]                          autoIncrementInfo = new long[7];
        /* (original code)
	long[]				autoIncrementInfo = new long[4];
	*/
// GemStone changes END

    /*
    	** RESOLVE: We are ignoring domains and collation.
    	*/
    
            /* identifier() used to be columnName() */
            columnName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
    typeDescriptor[0] = dataTypeDDL();
    switch (jj_nt.kind) {
    case CHECK:
    case CONSTRAINT:
    case _DEFAULT:
    case NOT:
    case NULL:
    case PRIMARY:
    case REFERENCES:
    case UNIQUE:
    case WITH:
    case GENERATED:{
      defaultNode = defaultAndConstraints(typeDescriptor, tableElementList, columnName, autoIncrementInfo);
      break;
      }
    default:
      jj_la1[57] = jj_gen;
      ;
    }
// Only pass autoincrement info for autoincrement columns
                if (autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_IS_AUTOINCREMENT_INDEX] == 0)
                {
                        autoIncrementInfo = null;
                }

                {if ("" != null) return (TableElementNode) nodeFactory.getNode(
                                                                C_NodeTypes.COLUMN_DEFINITION_NODE,
                                                                columnName,
                                                                defaultNode,
                                                                typeDescriptor[0],
                                                                autoIncrementInfo,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="defaultAndConstraints">defaultAndConstraints</A>
 */
  final public ValueNode defaultAndConstraints(DataTypeDescriptor[] typeDescriptor,
                                          TableElementList tableElementList,
                                          String columnName,
                                          long[] autoIncrementInfo) throws ParseException, StandardException {ValueNode               defaultNode = null;
    switch (jj_nt.kind) {
    case CHECK:
    case CONSTRAINT:
    case NOT:
    case NULL:
    case PRIMARY:
    case REFERENCES:
    case UNIQUE:{
      columnConstraintDefinition(typeDescriptor, tableElementList, columnName);
      label_5:
      while (true) {
        switch (jj_nt.kind) {
        case CHECK:
        case CONSTRAINT:
        case NOT:
        case NULL:
        case PRIMARY:
        case REFERENCES:
        case UNIQUE:{
          ;
          break;
          }
        default:
          jj_la1[58] = jj_gen;
          break label_5;
        }
        columnConstraintDefinition(typeDescriptor, tableElementList, columnName);
      }
      switch (jj_nt.kind) {
      case _DEFAULT:
      case WITH:
      case GENERATED:{
        defaultNode = defaultClause(autoIncrementInfo, columnName);
        label_6:
        while (true) {
          switch (jj_nt.kind) {
          case CHECK:
          case CONSTRAINT:
          case NOT:
          case NULL:
          case PRIMARY:
          case REFERENCES:
          case UNIQUE:{
            ;
            break;
            }
          default:
            jj_la1[59] = jj_gen;
            break label_6;
          }
          columnConstraintDefinition(typeDescriptor, tableElementList, columnName);
        }
        break;
        }
      default:
        jj_la1[60] = jj_gen;
        ;
      }
{if ("" != null) return defaultNode;}
      break;
      }
    case _DEFAULT:
    case WITH:
    case GENERATED:{
      defaultNode = defaultClause(autoIncrementInfo, columnName);
      label_7:
      while (true) {
        switch (jj_nt.kind) {
        case CHECK:
        case CONSTRAINT:
        case NOT:
        case NULL:
        case PRIMARY:
        case REFERENCES:
        case UNIQUE:{
          ;
          break;
          }
        default:
          jj_la1[61] = jj_gen;
          break label_7;
        }
        columnConstraintDefinition(typeDescriptor, tableElementList, columnName);
      }
{if ("" != null) return defaultNode;}
      break;
      }
    default:
      jj_la1[62] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="dataTypeDDL">dataTypeDDL</A>
 */
  final public DataTypeDescriptor dataTypeDDL() throws ParseException, StandardException {DataTypeDescriptor      typeDescriptor;
    if (commonDatatypeName(false)) {
      typeDescriptor = dataTypeCommon();
{if ("" != null) return typeDescriptor;}
    } else if (getToken(1).kind != GENERATED) {
      typeDescriptor = javaType();
{if ("" != null) return typeDescriptor;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
   Returns  a dataTypeDDL() as a catalog type, ie.
   the Java interface TypeDescriptor.
*/
  final public TypeDescriptor catalogType() throws ParseException, StandardException {DataTypeDescriptor      typeDescriptor;
    typeDescriptor = dataTypeDDL();
{if ("" != null) return typeDescriptor.getCatalogType();}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="dataTypeCast">dataTypeCast</A>
 */
  final public DataTypeDescriptor dataTypeCast() throws ParseException, StandardException {DataTypeDescriptor      typeDescriptor;
    if (commonDatatypeName(true)) {
      typeDescriptor = dataTypeCommon();
{if ("" != null) return typeDescriptor;}
    } else if (jj_2_18(1)) {
      typeDescriptor = javaType();
{if ("" != null) return typeDescriptor;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="dataTypeCommon">dataTypeCommon</A>
 */
  final public DataTypeDescriptor dataTypeCommon() throws ParseException, StandardException {DataTypeDescriptor      typeDescriptor;
        boolean checkCS = false;
    if (jj_2_19(1)) {
      if (getToken(2).kind != LARGE) {

      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      typeDescriptor = characterStringType();
    } else if (jj_2_20(1)) {
      if (getToken(3).kind != LARGE) {

      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      typeDescriptor = nationalCharacterStringType();
    } else if (jj_2_21(1)) {
      typeDescriptor = numericType();
    } else {
      switch (jj_nt.kind) {
      case DATE:
      case TIME:
      case TIMESTAMP:{
        typeDescriptor = datetimeType();
        break;
        }
      case BOOLEAN:{
        jj_consume_token(BOOLEAN);
checkInternalFeature(TypeId.BOOLEAN_NAME);
        typeDescriptor = new DataTypeDescriptor(TypeId.BOOLEAN_ID, true);
        break;
        }
      case LONG:{
        typeDescriptor = longType();
        break;
        }
      case BINARY:
      case CHAR:
      case CHARACTER:
      case NATIONAL:
      case BLOB:
      case CLOB:
      case NCLOB:
      case JSON:
      case CLOB_STRING:{
        typeDescriptor = LOBType();
        break;
        }
      case XML:{
        typeDescriptor = XMLType();
        break;
        }
      default:
        jj_la1[63] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return typeDescriptor;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="characterStringType">characterStringType</A>
 */
  final public DataTypeDescriptor characterStringType() throws ParseException, StandardException {int                                     length = DEFAULT_STRING_COLUMN_LENGTH;
        Token                           varyingToken = null;
        int type;
    switch (jj_nt.kind) {
    case VARCHAR:{
      jj_consume_token(VARCHAR);
      length = charLength();
type = Types.VARCHAR;
      break;
      }
    case CHAR:
    case CHARACTER:{
      charOrCharacter();
      switch (jj_nt.kind) {
      case VARYING:{
        // Length is optional for CHARACTER, not for plain CHARACTER VARYING
                        varyingToken = jj_consume_token(VARYING);
        length = charLength();
        break;
        }
      default:
        jj_la1[65] = jj_gen;
        switch (jj_nt.kind) {
        case LEFT_PAREN:{
          length = charLength();
          break;
          }
        default:
          jj_la1[64] = jj_gen;
          ;
        }
      }
// If the user says CHARACTER VARYING, it's really VARCHAR
                type = (varyingToken == null ? Types.CHAR : Types.VARCHAR);
      break;
      }
    default:
      jj_la1[66] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_nt.kind) {
    case FOR:{
      type = forBitData(type);
      break;
      }
    default:
      jj_la1[67] = jj_gen;
      ;
    }
checkTypeLimits(type,length);
                DataTypeDescriptor charDTD = DataTypeDescriptor.getBuiltInDataTypeDescriptor(type, length);
                {if ("" != null) return charDTD;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="charOrCharacter">charOrCharacter</A>
 */
  final public void charOrCharacter() throws ParseException {
    switch (jj_nt.kind) {
    case CHAR:{
      jj_consume_token(CHAR);
      break;
      }
    case CHARACTER:{
      jj_consume_token(CHARACTER);
      break;
      }
    default:
      jj_la1[68] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * <A NAME="charType">charType</A>
 */
  final public int charLength() throws ParseException, StandardException {int length;
    jj_consume_token(LEFT_PAREN);
    length = length();
    jj_consume_token(RIGHT_PAREN);
{if ("" != null) return length;}
    throw new Error("Missing return statement in function");
  }

/*
** <A NAME="forBitData">forBitData</A>
*/
  final public 
int forBitData(int charType) throws ParseException {
    jj_consume_token(FOR);
    jj_consume_token(BIT);
    jj_consume_token(DATA);
if (charType == Types.CHAR)
                        charType = Types.BINARY;
                else if (charType == Types.VARCHAR)
                        charType = Types.VARBINARY;
                else if (charType == Types.LONGVARCHAR)
                        charType = Types.LONGVARBINARY;

                {if ("" != null) return charType;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="nationalCharacterStringType">nationalCharacterStringType</A>
 */
  final public DataTypeDescriptor nationalCharacterStringType() throws ParseException, StandardException {DataTypeDescriptor      dataTypeDescriptor;
        int                                     length = DEFAULT_STRING_COLUMN_LENGTH;
        String                          type = null;
        Token                           varyingToken = null;
    switch (jj_nt.kind) {
    case NATIONAL:{
      jj_consume_token(NATIONAL);
      charOrCharacter();
      switch (jj_nt.kind) {
      case VARYING:{
        // Length is optional for NATIONAL CHARACTER , not for NATIONAL CHARACTER VARYING
                        varyingToken = jj_consume_token(VARYING);
        length = charLength();
        break;
        }
      default:
        jj_la1[70] = jj_gen;
        switch (jj_nt.kind) {
        case LEFT_PAREN:{
          length = charLength();
          break;
          }
        default:
          jj_la1[69] = jj_gen;
          ;
        }
      }
// If the user says NATIONAL CHARACTER VARYING, it's really NATIONALVARCHAR
                type = (varyingToken == null ? TypeId.NATIONAL_CHAR_NAME :
                                TypeId.NATIONAL_VARCHAR_NAME);
      break;
      }
    case NCHAR:{
      jj_consume_token(NCHAR);
      switch (jj_nt.kind) {
      case VARYING:{
        // Length is optional for NCHAR, not for NCHAR VARYING
                        varyingToken = jj_consume_token(VARYING);
        length = charLength();
        break;
        }
      default:
        jj_la1[72] = jj_gen;
        switch (jj_nt.kind) {
        case LEFT_PAREN:{
          length = charLength();
          break;
          }
        default:
          jj_la1[71] = jj_gen;
          ;
        }
      }
// If the user says NCHAR VARYING, it's really NATIONALVARCHAR
                type = (varyingToken == null ? TypeId.NATIONAL_CHAR_NAME :
                                TypeId.NATIONAL_VARCHAR_NAME);
      break;
      }
    case NVARCHAR:{
      jj_consume_token(NVARCHAR);
      length = charLength();
type = TypeId.NATIONAL_VARCHAR_NAME;
      break;
      }
    default:
      jj_la1[73] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
// need to re-enable according to SQL standard
                {if (true) throw StandardException.newException(SQLState.NOT_IMPLEMENTED, type);}
                // return DataTypeDescriptor.getBuiltInDataTypeDescriptor(type, length);

    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="LOBType">lobType</A>
 */
  final public DataTypeDescriptor LOBType() throws ParseException, StandardException {int     length = 2147483647; // default to 2GB-1 if no length specified
        String  type;
    switch (jj_nt.kind) {
    case BLOB:{
      jj_consume_token(BLOB);
      switch (jj_nt.kind) {
      case LEFT_PAREN:{
        length = lengthAndModifier();
        break;
        }
      default:
        jj_la1[74] = jj_gen;
        ;
      }
type = TypeId.BLOB_NAME;
      break;
      }
    case CLOB:{
      jj_consume_token(CLOB);
      switch (jj_nt.kind) {
      case LEFT_PAREN:{
        length = lengthAndModifier();
        break;
        }
      default:
        jj_la1[75] = jj_gen;
        ;
      }
type = TypeId.CLOB_NAME;
      break;
      }
    case CLOB_STRING:{
      jj_consume_token(CLOB_STRING);
      switch (jj_nt.kind) {
      case LEFT_PAREN:{
        length = lengthAndModifier();
        break;
        }
      default:
        jj_la1[76] = jj_gen;
        ;
      }
type = TypeId.CLOB_NAME;
      break;
      }
    case JSON:{
      jj_consume_token(JSON);
      switch (jj_nt.kind) {
      case LEFT_PAREN:{
        length = lengthAndModifier();
        break;
        }
      default:
        jj_la1[77] = jj_gen;
        ;
      }
type = TypeId.JSON_NAME;
      break;
      }
    case NCLOB:{
      jj_consume_token(NCLOB);
      length = lengthAndModifier();
type = TypeId.NCLOB_NAME;
                        // need to re-enable according to SQL standard
                        {if (true) throw StandardException.newException(SQLState.NOT_IMPLEMENTED, type);}
      break;
      }
    case BINARY:{
      jj_consume_token(BINARY);
      jj_consume_token(LARGE);
      jj_consume_token(OBJECT);
      switch (jj_nt.kind) {
      case LEFT_PAREN:{
        length = lengthAndModifier();
        break;
        }
      default:
        jj_la1[78] = jj_gen;
        ;
      }
type = TypeId.BLOB_NAME;
      break;
      }
    case CHAR:
    case CHARACTER:{
      charOrCharacter();
      jj_consume_token(LARGE);
      jj_consume_token(OBJECT);
      switch (jj_nt.kind) {
      case LEFT_PAREN:{
        length = lengthAndModifier();
        break;
        }
      default:
        jj_la1[79] = jj_gen;
        ;
      }
type = TypeId.CLOB_NAME;
      break;
      }
    case NATIONAL:{
      jj_consume_token(NATIONAL);
      jj_consume_token(CHARACTER);
      jj_consume_token(LARGE);
      jj_consume_token(OBJECT);
      length = lengthAndModifier();
type = TypeId.NCLOB_NAME;
                        // need to re-enable according to SQL standard
                        {if (true) throw StandardException.newException(SQLState.NOT_IMPLEMENTED, type);}
      break;
      }
    default:
      jj_la1[80] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
DataTypeDescriptor dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(type, length);

                {if ("" != null) return dtd;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="numericType">numericType</A>
 */
  final public DataTypeDescriptor numericType() throws ParseException, StandardException {DataTypeDescriptor      typeDescriptor;
    switch (jj_nt.kind) {
    case DEC:
    case DECIMAL:
    case INT:
    case INTEGER:
    case NUMERIC:
    case SMALLINT:
    case LONGINT:{
      typeDescriptor = exactNumericType();
{if ("" != null) return typeDescriptor;}
      break;
      }
    default:
      jj_la1[81] = jj_gen;
      if (jj_2_22(1)) {
        typeDescriptor = approximateNumericType();
{if ("" != null) return typeDescriptor;}
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="exactNumericType">exactNumericType</A>
 */
  final public DataTypeDescriptor exactNumericType() throws ParseException, StandardException {int precision = TypeCompiler.DEFAULT_DECIMAL_PRECISION;
        int scale = TypeCompiler.DEFAULT_DECIMAL_SCALE;
        int type = Types.DECIMAL;
        String typeStr = "DECIMAL";
        int maxWidth;
        DataTypeDescriptor dtd =  null;
    switch (jj_nt.kind) {
    case DEC:
    case DECIMAL:
    case NUMERIC:{
      switch (jj_nt.kind) {
      case NUMERIC:{
        jj_consume_token(NUMERIC);
type = Types.NUMERIC;
                typeStr = "NUMERIC";
        break;
        }
      case DECIMAL:{
        jj_consume_token(DECIMAL);
        break;
        }
      case DEC:{
        jj_consume_token(DEC);
        break;
        }
      default:
        jj_la1[82] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_nt.kind) {
      case LEFT_PAREN:{
        jj_consume_token(LEFT_PAREN);
boolean existing = getCompilerContext().switchOptimizeLiteral(false);
        precision = precision();
        switch (jj_nt.kind) {
        case COMMA:{
          jj_consume_token(COMMA);
          scale = scale();
          break;
          }
        default:
          jj_la1[83] = jj_gen;
          ;
        }
        jj_consume_token(RIGHT_PAREN);
getCompilerContext().switchOptimizeLiteral(existing);
        break;
        }
      default:
        jj_la1[84] = jj_gen;
        ;
      }
if ((precision <= 0) ||
                        (precision > TypeCompiler.MAX_DECIMAL_PRECISION_SCALE))
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_INVALID_PRECISION,
                                typeStr, String.valueOf(precision));}
                }
                else if ((scale < 0) ||
                                 (scale > TypeCompiler.MAX_DECIMAL_PRECISION_SCALE))
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_INVALID_DECIMAL_SCALE,
                                typeStr, String.valueOf(scale));}
                }
                else if (scale > precision)
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_INVALID_DECIMAL_PRECISION_SCALE,
                                String.valueOf(scale),
                                String.valueOf(precision));}
                }
                /*
		** If we have a decimal point, need to count it
		** towards maxwidth.  Max width needs to account
		** for the possible leading '0' and '-' and the
		** decimal point.  e.g., DEC(1,1) has a maxwidth
		** of 4 (to handle "-0.1").
		*/
                maxWidth = DataTypeUtilities.computeMaxWidth( precision, scale);
                {if ("" != null) return getDataTypeServices(type, precision, scale, maxWidth);}
      break;
      }
    case INT:
    case INTEGER:
    case SMALLINT:
    case LONGINT:{
      dtd = exactIntegerType();
{if ("" != null) return dtd;}
      break;
      }
    default:
      jj_la1[85] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="exactNumericType">exactNumericType</A>
 */
  final public DataTypeDescriptor exactIntegerType() throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case INT:
    case INTEGER:{
      switch (jj_nt.kind) {
      case INTEGER:{
        jj_consume_token(INTEGER);
        break;
        }
      case INT:{
        jj_consume_token(INT);
        break;
        }
      default:
        jj_la1[86] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return DataTypeDescriptor.getBuiltInDataTypeDescriptor(Types.INTEGER);}
      break;
      }
    case SMALLINT:{
      jj_consume_token(SMALLINT);
{if ("" != null) return DataTypeDescriptor.getBuiltInDataTypeDescriptor(Types.SMALLINT);}
      break;
      }
    case LONGINT:{
      jj_consume_token(LONGINT);
{if ("" != null) return DataTypeDescriptor.getBuiltInDataTypeDescriptor(Types.BIGINT);}
      break;
      }
    default:
      jj_la1[87] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="approximateNumericType">approximateNumericType</A>
 */
  final public DataTypeDescriptor approximateNumericType() throws ParseException, StandardException {int type = 0, scale = 0, width = 0;
        int prec = -1;
        DataTypeDescriptor dts = null;
    switch (jj_nt.kind) {
    case FLOAT:{
      jj_consume_token(FLOAT);
      switch (jj_nt.kind) {
      case LEFT_PAREN:{
        jj_consume_token(LEFT_PAREN);
        prec = precision();
        jj_consume_token(RIGHT_PAREN);
        break;
        }
      default:
        jj_la1[88] = jj_gen;
        ;
      }
/*
			When not specified, default is DOUBLE_PRECISION
		 */
                if (prec == -1)
                        prec = TypeId.DOUBLE_PRECISION;

                if (prec > 0 && prec <= TypeId.REAL_PRECISION)
                {
                        type = Types.REAL;
                        prec = TypeId.REAL_PRECISION;
                        scale = TypeId.REAL_SCALE;
                        width = TypeId.REAL_MAXWIDTH;
                }
                else if (prec > TypeId.REAL_PRECISION &&
                                 prec <= TypeId.DOUBLE_PRECISION)
                {
                        type = Types.DOUBLE;
                        prec = TypeId.DOUBLE_PRECISION;
                        scale = TypeId.DOUBLE_SCALE;
                        width = TypeId.DOUBLE_MAXWIDTH;
                }
                else
                        {if (true) throw StandardException.newException(SQLState.LANG_INVALID_PRECISION, "FLOAT", String.valueOf(prec));}

                /*
			REMIND: this is a slight hack, in that exacting reading of
			the InformationSchema requires that the type the user typed
			in be visible to them in the InformationSchema views. But
			most implementations use synonyms or mappings at some point,
			and this is one of those places, for us.
		 */
                {if ("" != null) return getDataTypeServices(type, prec, scale, width);}
      break;
      }
    case REAL:{
      jj_consume_token(REAL);
{if ("" != null) return DataTypeDescriptor.getBuiltInDataTypeDescriptor(Types.REAL);}
      break;
      }
    default:
      jj_la1[89] = jj_gen;
      if (jj_2_23(1)) {
        dts = doubleType();
{if ("" != null) return dts;}
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="doubleType">doubleType</A>
 */
  final public DataTypeDescriptor doubleType() throws ParseException, StandardException {
    if (getToken(2).kind == PRECISION) {
      jj_consume_token(DOUBLE);
      jj_consume_token(PRECISION);
    } else {
      switch (jj_nt.kind) {
      case DOUBLE:{
        jj_consume_token(DOUBLE);
        break;
        }
      default:
        jj_la1[90] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return DataTypeDescriptor.getBuiltInDataTypeDescriptor(Types.DOUBLE);}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="longType">longType</A>
 */
  final public DataTypeDescriptor longType() throws ParseException, StandardException {DataTypeDescriptor      dataTypeDescriptor;
    jj_consume_token(LONG);
    dataTypeDescriptor = longSubType();
{if ("" != null) return dataTypeDescriptor;}
    throw new Error("Missing return statement in function");
  }

  final public DataTypeDescriptor longSubType() throws ParseException, StandardException {int lvcType = Types.LONGVARCHAR;
    switch (jj_nt.kind) {
    case VARCHAR:{
      jj_consume_token(VARCHAR);
      switch (jj_nt.kind) {
      case FOR:{
        lvcType = forBitData(lvcType);
        break;
        }
      default:
        jj_la1[91] = jj_gen;
        ;
      }
{if ("" != null) return DataTypeDescriptor.getBuiltInDataTypeDescriptor(lvcType);}
      break;
      }
    case NVARCHAR:{
      jj_consume_token(NVARCHAR);
// need to re-enable according to SQL standard
                {if (true) throw StandardException.newException(SQLState.NOT_IMPLEMENTED, TypeId.NATIONAL_LONGVARCHAR_NAME);}
                // return DataTypeDescriptor.getBuiltInDataTypeDescriptor(TypeId.NATIONAL_LONGVARCHAR_NAME);

      break;
      }
    default:
      jj_la1[92] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="XMLType">XMLType</A>
 */
  final public DataTypeDescriptor XMLType() throws ParseException, StandardException {DataTypeDescriptor value;
    jj_consume_token(XML);
checkVersion(DataDictionary.DD_VERSION_DERBY_10_1, "XML");
                {if ("" != null) return DataTypeDescriptor.getBuiltInDataTypeDescriptor(
                        JDBC40Translation.SQLXML);}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="xmlDocOrContent">xmlDocOrContent</A>
 *
 * Parse the XML keywords DOCUMENT and CONTENT.  We don't
 * support CONTENT yet, so we throw an appropriate error
 * if we see it.
 *
 */
  final public void xmlDocOrContent() throws ParseException, StandardException {
    if ((getToken(1).kind != DOCUMENT) &&
                    (getToken(1).kind != CONTENT)) {
{if (true) throw StandardException.newException(
                        SQLState.LANG_XML_KEYWORD_MISSING, "DOCUMENT",
                        ReuseFactory.getInteger(getToken(1).beginLine),
                        ReuseFactory.getInteger(getToken(1).beginColumn));}
    } else if (getToken(1).kind == CONTENT) {
      jj_consume_token(CONTENT);
{if (true) throw StandardException.newException(
                        SQLState.LANG_UNSUPPORTED_XML_FEATURE, "CONTENT");}
    } else if (getToken(1).kind == DOCUMENT) {
      jj_consume_token(DOCUMENT);
{if ("" != null) return;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * <A NAME="javaType">javaType</A>
 */
  final public DataTypeDescriptor javaType() throws ParseException, StandardException {TableName       typeName;
    typeName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
{if ("" != null) return getJavaClassDataTypeDescriptor(typeName);}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME = "javaDSL">javaDSL</A>
 *
 * A Java dot-separated list.
 */
  final public String javaDSL() throws ParseException {String dotSeparatedList;
    dotSeparatedList = caseSensitiveIdentifierPlusReservedWords();
    label_8:
    while (true) {
      switch (jj_nt.kind) {
      case PERIOD:
      case DOLLAR:{
        ;
        break;
        }
      default:
        jj_la1[93] = jj_gen;
        break label_8;
      }
      dotSeparatedList = javaDSLNameExtender(dotSeparatedList);
    }
{if ("" != null) return dotSeparatedList;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="javaClassName">javaClassName</A>
 */
  final public String javaClassName() throws ParseException {String javaClassName;
    javaClassName = javaDSL();
{if ("" != null) return javaClassName;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="javaDSLNameExtender">javaDSLNameExtender</A>
 */
  final public String javaDSLNameExtender(String dotSeparatedList) throws ParseException {String  extender;
    switch (jj_nt.kind) {
    case PERIOD:{
      jj_consume_token(PERIOD);
      extender = caseSensitiveIdentifierPlusReservedWords();
{if ("" != null) return dotSeparatedList + "." + extender;}
      break;
      }
    case DOLLAR:{
      jj_consume_token(DOLLAR);
      extender = caseSensitiveIdentifierPlusReservedWords();
{if ("" != null) return dotSeparatedList + "$" + extender;}
      break;
      }
    default:
      jj_la1[94] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="length">lengthAndModifier</A>
 */
  final public int lengthAndModifier() throws ParseException, StandardException {Token   tok;
        Token   tokmod = null;
    jj_consume_token(LEFT_PAREN);
    switch (jj_nt.kind) {
    case LENGTH_MODIFIER:{
      tok = jj_consume_token(LENGTH_MODIFIER);
      break;
      }
    case EXACT_NUMERIC:{
      tok = jj_consume_token(EXACT_NUMERIC);
      switch (jj_nt.kind) {
      case IDENTIFIER:{
        tokmod = jj_consume_token(IDENTIFIER);
        break;
        }
      default:
        jj_la1[95] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[96] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RIGHT_PAREN);
String s = tok.image + (tokmod==null ? "" : tokmod.image); // colapse cases;
                try
                {
                        char modifier = s.charAt(s.length()-1);
                        String number = s.substring(0, s.length()-1); // in case of ending w. letter
                        long mul;
                        switch (modifier) {
                        case 'G':
                        case 'g':
                                mul =1073741824L;       //1 Giga
                                break;
                        case 'M':
                        case 'm':
                                mul=1048576L;           // 1 Mega
                                break;
                        case 'K':
                        case 'k':
                                mul=1024L;              // 1 Kilo
                                break;
                        default:
                                mul=1;
                                number = s; // no letter in end, need whole string
                                break;
                        }
                        long    specifiedLength = Long.parseLong(number) * mul;

                        // match DB2 limits of 1 to 2147483647
                        if ((specifiedLength > 0L) &&
                (specifiedLength <= Limits.DB2_LOB_MAXWIDTH))
            {
                                {if ("" != null) return (int)specifiedLength;}
            }

                        // DB2 allows 2G or 2048M or 2097152k that calculate out to 
            // 2147483648, but sets the length to be one less.
                        if (mul != 1 && specifiedLength == 2147483648L)
                                {if ("" != null) return Limits.DB2_LOB_MAXWIDTH;}

                }
                catch (NumberFormatException nfe)
                {
                }

                {if (true) throw StandardException.newException(
            SQLState.LANG_INVALID_COLUMN_LENGTH, s);}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="length">length</A>
 */
  final public int length() throws ParseException, StandardException {Token   tok;
        int     retval;
    tok = jj_consume_token(EXACT_NUMERIC);
try
                {
                        retval = Integer.parseInt(tok.image);

                        if (retval > 0)
                                {if ("" != null) return retval;}
                }
                catch (NumberFormatException nfe)
                {
                }
                {if (true) throw StandardException.newException(SQLState.LANG_INVALID_COLUMN_LENGTH, tok.image);}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="exactNumber">exactNumber</A>
*/
  final public long exactNumber() throws ParseException, StandardException {Token longToken;
        String sign = "";
    switch (jj_nt.kind) {
    case PLUS_SIGN:
    case MINUS_SIGN:{
      sign = sign();
      break;
      }
    default:
      jj_la1[97] = jj_gen;
      ;
    }
    longToken = jj_consume_token(EXACT_NUMERIC);
try
                {
                        /*
			 * Note that it's important to re-concatenate
			 * the - sign (if present) into the number
			 * before converting it to a long value so
			 * that we can successfully handle any value
			 * in the range Long.MIN_VALUE ... Long.MAX_VALUE.
			 * Unfortunately, we can't simply do:
			 *     return Long.parseLong(sign+longToken.image);
			 * because Long.parseLong() doesn't accept a
			 * leading + sign.
			 */

                        if (sign.equals("-"))
                        {
                                {if ("" != null) return Long.parseLong("-"+longToken.image);}
                        }
                        else
                        {
                                {if ("" != null) return Long.parseLong(longToken.image);}
                        }
                }
                catch (NumberFormatException nfe)
                {
                        {if (true) throw
                        StandardException.newException(
                                   SQLState.LANG_INVALID_INTEGER_LITERAL, longToken.image);}
                }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="precision">precision</A>
 */
  final public int precision() throws ParseException, StandardException {int uintValue;
    uintValue = uint_value();
{if ("" != null) return uintValue;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="uint_value">uint_value</A>
 */
  final public int uint_value() throws ParseException, StandardException {Token uintToken;
    /*
    		because the parser won't match to UINT, we use EXACT_NUMERIC.
    	 */
            uintToken = jj_consume_token(EXACT_NUMERIC);
try {
                        {if ("" != null) return Integer.parseInt(uintToken.image);}
                } catch (NumberFormatException nfe) {
                        {if (true) throw StandardException.newException(SQLState.LANG_INVALID_INTEGER_LITERAL, uintToken.image);}
                }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="scale">scale</A>
 */
  final public int scale() throws ParseException, StandardException {int uintValue;
    uintValue = uint_value();
{if ("" != null) return uintValue;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="datetimeType">datetimeType</A>
 */
  final public DataTypeDescriptor datetimeType() throws ParseException, StandardException {Token tzTok = null;
        int prec = -1; // know the value back is positive and in range

    switch (jj_nt.kind) {
    case DATE:{
      jj_consume_token(DATE);
{if ("" != null) return DataTypeDescriptor.getBuiltInDataTypeDescriptor(Types.DATE);}
      break;
      }
    case TIME:{
      jj_consume_token(TIME);
/*
			We do not try to set up a precision for time/timestamp
			values because this field gets mapped to the precision
			field in the JDBC driver that is for the number of
			decimal digits in the value.  Precision for time is
			actually the scale of the seconds value.

			If/when precision for times is supported, we may need
			to migrate the system catalog information to fill in
			the default values appropriately (the default for
			time is 0, fortunately; but for timestamp it is
			actually 9 due to java.sql.Timestamp's precision).
		 */
                {if ("" != null) return DataTypeDescriptor.getBuiltInDataTypeDescriptor(Types.TIME);}
      break;
      }
    case TIMESTAMP:{
      jj_consume_token(TIMESTAMP);
{if ("" != null) return DataTypeDescriptor.getBuiltInDataTypeDescriptor(Types.TIMESTAMP);}
      break;
      }
    default:
      jj_la1[98] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="timePrecision">timePrecision</A>
 */
  final public 
void qualifiedNameList(Vector list, int id_length_limit) throws ParseException, StandardException {
    qualifiedNameElement(list, id_length_limit);
    label_9:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[99] = jj_gen;
        break label_9;
      }
      jj_consume_token(COMMA);
      qualifiedNameElement(list, id_length_limit);
    }
  }

  final public void qualifiedNameElement(Vector list, int id_length_limit) throws ParseException, StandardException {TableName qualifiedName = null;
    qualifiedName = qualifiedName(id_length_limit);
list.addElement(qualifiedName);
  }

/*
 * <A NAME="qualifiedName">qualifiedName</A>
 */
  final public TableName qualifiedName(int nodeType, int id_length_limit) throws ParseException, StandardException {//String	catalogName = null;
        String  schemaName = null;
        String  qualifiedId;
        String  firstName = null;
        String  secondName = null;
    firstName = identifier(Limits.MAX_IDENTIFIER_LENGTH, false);
    if (getToken(1).kind == PERIOD &&
                                                                    getToken(2).kind != ASTERISK) {
      jj_consume_token(PERIOD);
      secondName = identifier(Limits.MAX_IDENTIFIER_LENGTH, false);
    } else {
      ;
    }
if (secondName == null)
                {
                        qualifiedId = firstName;
                }
                else
                {
                        schemaName = firstName;
                        qualifiedId = secondName;
                }

                //limit the qualifiedId to the id length limit passed to this method
                checkIdentifierLengthLimit(qualifiedId, id_length_limit);
                if (schemaName != null)
                        checkIdentifierLengthLimit(schemaName, Limits.MAX_IDENTIFIER_LENGTH);

                {if ("" != null) return (TableName) nodeFactory.getNode(
                                                                nodeType,
                                                                schemaName,
                                                                qualifiedId,
// GemStone changes BEGIN
                                                                // changed to use Integer.valueOf()
                                                                Integer.valueOf(lastIdentifierToken.beginOffset),
                                                                Integer.valueOf(lastIdentifierToken.endOffset),
// GemStone changes END
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="queryExpression">queryExpression</A>
 *
 * We have to be carefull to get the associativity correct. According to the SQL spec
 *   <non-join query expression> ::=
 *     <non-join query term>
 *    | <query expression body> UNION [ ALL ] <query term>
 *    | <query expression body> EXCEPT [ ALL ] <query term>
 * Meaning that
 *   t1 UNION ALL t2 UNION t3
 * is equivalent to
 *   (t1 UNION ALL t2) UNION t3
 * However recursive descent parsers want recursion to be on the right, so this kind of associativity is unnatural
 * for our parser. The queryExpression method must know whether it is being called as the right hand side of a
 * set operator to produce a query tree with the correct associativity.
 */
  final public ResultSetNode queryExpression(ResultSetNode leftSide, int operatorType) throws ParseException, StandardException {ResultSetNode   term;
        getCompilerContext().pushDML(0);
    term = nonJoinQueryTerm(leftSide, operatorType);
    switch (jj_nt.kind) {
    case EXCEPT:
    case UNION:{
      term = unionOrExcept(term);
      break;
      }
    default:
      jj_la1[100] = jj_gen;
      ;
    }
getCompilerContext().popDML(0);
                {if ("" != null) return term;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="unionOrExcept">unionOrExcept</A>
 */
  final public ResultSetNode unionOrExcept(ResultSetNode term) throws ParseException, StandardException {ResultSetNode   expression;
        Token                   tok = null;
    switch (jj_nt.kind) {
    case UNION:{
      jj_consume_token(UNION);
      switch (jj_nt.kind) {
      case ALL:
      case DISTINCT:{
        switch (jj_nt.kind) {
        case ALL:{
          tok = jj_consume_token(ALL);
          break;
          }
        case DISTINCT:{
          jj_consume_token(DISTINCT);
          break;
          }
        default:
          jj_la1[101] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[102] = jj_gen;
        ;
      }
      expression = queryExpression(term,
                                                                      (tok != null) ? UNION_ALL_OP : UNION_OP);
{if ("" != null) return expression;}
      break;
      }
    case EXCEPT:{
      jj_consume_token(EXCEPT);
      switch (jj_nt.kind) {
      case ALL:
      case DISTINCT:{
        switch (jj_nt.kind) {
        case ALL:{
          tok = jj_consume_token(ALL);
          break;
          }
        case DISTINCT:{
          jj_consume_token(DISTINCT);
          break;
          }
        default:
          jj_la1[103] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[104] = jj_gen;
        ;
      }
      expression = queryExpression(term,
                                                                      (tok != null) ? EXCEPT_ALL_OP : EXCEPT_OP);
{if ("" != null) return expression;}
      break;
      }
    default:
      jj_la1[105] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="nonJoinQueryTerm">nonJoinQueryTerm</A>
 *
 * Be careful with the associativity of INTERSECT. According to the SQL spec
 *   t1 INTERSECT t2 INTERSECT ALL t3
 * is equivalent to
 *   (t1 INTERSECT t2) INTERSECT ALL t3
 * which is not the same as
 *   t1 INTERSECT (t2 INTERSECT ALL t3)
 * See the comment on queryExpression.
 */
  final public ResultSetNode nonJoinQueryTerm(ResultSetNode leftSide, int operatorType) throws ParseException, StandardException {ResultSetNode   term;
    term = nonJoinQueryPrimary();
    switch (jj_nt.kind) {
    case INTERSECT:{
      term = intersect(term);
      break;
      }
    default:
      jj_la1[106] = jj_gen;
      ;
    }
switch( operatorType)
        {
        case NO_SET_OP:
            {if ("" != null) return term;}

        case UNION_OP:
            {if ("" != null) return (ResultSetNode) nodeFactory.getNode(
                C_NodeTypes.UNION_NODE,
                leftSide,
                term,
                Boolean.FALSE,
                Boolean.FALSE,
                null,
                getContextManager());}

        case UNION_ALL_OP:
            {if ("" != null) return (ResultSetNode) nodeFactory.getNode(
                C_NodeTypes.UNION_NODE,
                leftSide,
                term,
                Boolean.TRUE,
                Boolean.FALSE,
                null,
                getContextManager());}

        case EXCEPT_OP:
            {if ("" != null) return (ResultSetNode) nodeFactory.getNode(
                C_NodeTypes.INTERSECT_OR_EXCEPT_NODE,
                ReuseFactory.getInteger( IntersectOrExceptNode.EXCEPT_OP),
                leftSide,
                term,
                Boolean.FALSE,
                null,
                getContextManager());}

        case EXCEPT_ALL_OP:
            {if ("" != null) return (ResultSetNode) nodeFactory.getNode(
                C_NodeTypes.INTERSECT_OR_EXCEPT_NODE,
                ReuseFactory.getInteger( IntersectOrExceptNode.EXCEPT_OP),
                leftSide,
                term,
                Boolean.TRUE,
                null,
                getContextManager());}

        case INTERSECT_OP:
            {if ("" != null) return (ResultSetNode) nodeFactory.getNode(
                C_NodeTypes.INTERSECT_OR_EXCEPT_NODE,
                ReuseFactory.getInteger( IntersectOrExceptNode.INTERSECT_OP),
                leftSide,
                term,
                Boolean.FALSE,
                null,
                getContextManager());}

        case INTERSECT_ALL_OP:
            {if ("" != null) return (ResultSetNode) nodeFactory.getNode(
                C_NodeTypes.INTERSECT_OR_EXCEPT_NODE,
                ReuseFactory.getInteger( IntersectOrExceptNode.INTERSECT_OP),
                leftSide,
                term,
                Boolean.TRUE,
                null,
                getContextManager());}


        default:
            if (SanityManager.DEBUG)
            {
                SanityManager.THROWASSERT( "Invalid set operator type: " + operatorType);
            }
            {if ("" != null) return null;}
        }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="intersect">intersect</A>
 */
  final public ResultSetNode intersect(ResultSetNode term) throws ParseException, StandardException {ResultSetNode   expression;
        Token                   tok = null;
    jj_consume_token(INTERSECT);
    switch (jj_nt.kind) {
    case ALL:
    case DISTINCT:{
      switch (jj_nt.kind) {
      case ALL:{
        tok = jj_consume_token(ALL);
        break;
        }
      case DISTINCT:{
        jj_consume_token(DISTINCT);
        break;
        }
      default:
        jj_la1[107] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[108] = jj_gen;
      ;
    }
    expression = nonJoinQueryTerm(term, (tok != null) ? INTERSECT_ALL_OP : INTERSECT_OP);
{if ("" != null) return expression;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="nonJoinQueryPrimary">nonJoinQueryPrimary</A>
 */
  final public ResultSetNode nonJoinQueryPrimary() throws ParseException, StandardException {ResultSetNode   primary;
    switch (jj_nt.kind) {
    case SELECT:
    case VALUES:{
      primary = simpleTable();
{if ("" != null) return primary;}
      break;
      }
    case LEFT_PAREN:{
      jj_consume_token(LEFT_PAREN);
      primary = queryExpression(null, NO_SET_OP);
      jj_consume_token(RIGHT_PAREN);
{if ("" != null) return primary;}
      break;
      }
    default:
      jj_la1[109] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="simpleTable">simpleTable</A>
 */
  final public ResultSetNode simpleTable() throws ParseException, StandardException {ResultSetNode   resultSetNode;
    switch (jj_nt.kind) {
    case SELECT:{
      resultSetNode = querySpecification();
{if ("" != null) return resultSetNode;}
      break;
      }
    case VALUES:{
      resultSetNode = tableValueConstructor();
{if ("" != null) return resultSetNode;}
      break;
      }
    default:
      jj_la1[110] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="querySpecification">querySpecification</A>
 */
  final public ResultSetNode querySpecification() throws ParseException, StandardException {ResultColumnList        selectList;
        SelectNode                      selectNode;
        boolean isDistinct = false;
    jj_consume_token(SELECT);
    if (jj_2_24(1)) {
      isDistinct = setQuantifier();
    } else {
      ;
    }
    selectList = selectList();
    selectNode = tableExpression(selectList);
if (isDistinct) selectNode.makeDistinct();
                {if ("" != null) return selectNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="setQuantifier">setQuantifier</A>
 */
  final public boolean setQuantifier() throws ParseException {
    if (getToken(1).kind == DISTINCT &&
                            !(
                                    getToken(2).kind == PERIOD ||
                                    getToken(2).kind == DOUBLE_COLON
                            )) {
      jj_consume_token(DISTINCT);
{if ("" != null) return true;}
    } else if (getToken(1).kind == ALL &&
                            !(
                                    getToken(2).kind == PERIOD ||
                                    getToken(2).kind == DOUBLE_COLON
                            )) {
      jj_consume_token(ALL);
{if ("" != null) return false;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="selectList">selectList</A>
 */
  final public ResultColumnList selectList() throws ParseException, StandardException {ResultColumn    allResultColumn;
        ResultColumnList        resultColumns = (ResultColumnList) nodeFactory.getNode(
                                                                        C_NodeTypes.RESULT_COLUMN_LIST,
                                                                        getContextManager());
    switch (jj_nt.kind) {
    case ASTERISK:{
      jj_consume_token(ASTERISK);
allResultColumn = (ResultColumn) nodeFactory.getNode(
                                                                                C_NodeTypes.ALL_RESULT_COLUMN,
                                                                                null,
                                                                                getContextManager());
                /* Add the new AllResultColumn to the end of the list */
                resultColumns.addResultColumn(allResultColumn);
                {if ("" != null) return resultColumns;}
      break;
      }
    default:
      jj_la1[111] = jj_gen;
      if (jj_2_25(1)) {
        selectColumnList(resultColumns);
{if ("" != null) return resultColumns;}
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public void selectColumnList(ResultColumnList resultColumns) throws ParseException, StandardException {
    selectSublist(resultColumns);
    label_10:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[112] = jj_gen;
        break label_10;
      }
      jj_consume_token(COMMA);
      selectSublist(resultColumns);
    }
  }

/*
 * <A NAME="selectSublist">selectSublist</A>
 */
  final public void selectSublist(ResultColumnList resultColumns) throws ParseException, StandardException {ResultColumn    resultColumn;
        ResultColumn    allResultColumn;
        TableName       tableName;
    String          columnName = null;
    if (getToken(2).kind == PERIOD &&
                            (
                                    getToken(3).kind == ASTERISK ||
                                    (getToken(4).kind == PERIOD && getToken(5).kind == ASTERISK)
                            )) {
      tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
      jj_consume_token(PERIOD);
      jj_consume_token(ASTERISK);
allResultColumn = (ResultColumn) nodeFactory.getNode(
                                                                                C_NodeTypes.ALL_RESULT_COLUMN,
                                                                                tableName,
                                                                                getContextManager());
                /* Add the new AllResultColumn to the end of the list */
                resultColumns.addResultColumn(allResultColumn);
    } else if (getToken(1).kind == ROW_NUMBER &&
                            getToken(2).kind == LEFT_PAREN &&
                            getToken(3).kind == RIGHT_PAREN) {
      jj_consume_token(ROW_NUMBER);
      jj_consume_token(LEFT_PAREN);
      jj_consume_token(RIGHT_PAREN);
      jj_consume_token(OVER);
      jj_consume_token(LEFT_PAREN);
      jj_consume_token(RIGHT_PAREN);
      if (jj_2_26(1)) {
        columnName = asClause();
      } else {
        ;
      }
/*
			 * If there is no AS clause, use the windowfunction name as the result column name.
			 */
                        WindowNode windowNode = (WindowNode) nodeFactory.getNode(
                                                                                        C_NodeTypes.WINDOW_NODE,
                                                                                        null,  // name
                                                                                        null,  // partition definition list
                                                                                        null,  // order by list
                                                                                        null,  // frame definition
                                                                                        getContextManager());
                        ValueNode expression = (ValueNode) nodeFactory.getNode(
                                                                                        C_NodeTypes.ROW_NUMBER_COLUMN_NODE,
                                                                                        windowNode,
                                                                                        getContextManager());
            // Set the column name in the valuenode
            ((ResultColumn) expression).setName(columnName);
                        resultColumn = (ResultColumn) nodeFactory.getNode(
                                                                                        C_NodeTypes.RESULT_COLUMN,
                                                                                        columnName,
                                                                                        expression,
                                                                                        getContextManager());
                        /* Add the new ResultColumn to the end of the list */
                        resultColumns.addResultColumn(resultColumn);
    } else if (jj_2_27(1)) {
      resultColumn = derivedColumn(resultColumns);
/* Add the new ResultColumn to the end of the list */
                resultColumns.addResultColumn(resultColumn);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * <A NAME="derivedColumn">derivedColumn</A>
 */
  final public ResultColumn derivedColumn(ResultColumnList resultColumns) throws ParseException, StandardException {ValueNode       columnExpression;
        String          columnName = null;
    //true to additiveExpression ensures that for the derived columns, we will not allow boolean values inside (), 
            //eg (2 > 1) should be disallowed in the select clause
            columnExpression = additiveExpression(null, 0, true);
    if (jj_2_28(1)) {
      columnName = asClause();
    } else {
      ;
    }
/*
		** If there is no AS clause, and the expression is a simple
		** column, use the name of the column as the result column
		** name.
		*/
                if ((columnName == null) && (columnExpression instanceof ColumnReference))
                {
                        columnName = ((ColumnReference) columnExpression).columnName;
                }

                {if ("" != null) return (ResultColumn) nodeFactory.getNode(
                                                C_NodeTypes.RESULT_COLUMN,
                                                columnName,
                                                columnExpression,
                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="asClause">asClause</A>
 */
  final public String asClause() throws ParseException, StandardException {String  columnName;
    switch (jj_nt.kind) {
    case AS:{
      jj_consume_token(AS);
      break;
      }
    default:
      jj_la1[113] = jj_gen;
      ;
    }
    columnName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
{if ("" != null) return columnName;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="valueExpression">valueExpression</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode valueExpression(boolean inSelectClause) throws ParseException, StandardException {ValueNode       leftOperand;
    leftOperand = orExpression(null, inSelectClause);
    label_11:
    while (true) {
      switch (jj_nt.kind) {
      case OR:{
        ;
        break;
        }
      default:
        jj_la1[114] = jj_gen;
        break label_11;
      }
      jj_consume_token(OR);
      leftOperand = orExpression(leftOperand, inSelectClause);
    }
{if ("" != null) return leftOperand;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="orExpression">orExpression</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode orExpression(ValueNode farLeftOperand, boolean inSelectClause) throws ParseException, StandardException {ValueNode       leftOperand;
    leftOperand = andExpression(null, inSelectClause);
    label_12:
    while (true) {
      switch (jj_nt.kind) {
      case AND:{
        ;
        break;
        }
      default:
        jj_la1[115] = jj_gen;
        break label_12;
      }
      jj_consume_token(AND);
      leftOperand = andExpression(leftOperand, inSelectClause);
    }
if (farLeftOperand == null)
                {
                        {if ("" != null) return leftOperand;}
                }
                else
                {
                        {if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                                C_NodeTypes.OR_NODE,
                                                                                farLeftOperand,
                                                                                leftOperand,
                                                                                getContextManager());}
                }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="andExpression">andExpression</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode andExpression(ValueNode farLeftOperand, boolean inSelectClause) throws ParseException, StandardException {Token           tok = null;
        ValueNode       test;
    if (getToken(1).kind == NOT && !(getToken(2).kind == PERIOD ||
                            getToken(2).kind == DOUBLE_COLON)) {
      tok = jj_consume_token(NOT);
    } else {
      ;
    }
    test = isSearchCondition(inSelectClause);
/* Put the NOT on top of test */
                if (tok != null)
                {
                        test = (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.NOT_NODE,
                                                                        test,
                                                                        getContextManager());
                }

                if (farLeftOperand != null)
                {
                        test = (ValueNode) nodeFactory.getNode(
                                                                                C_NodeTypes.AND_NODE,
                                                                                farLeftOperand,
                                                                                test,
                                                                                getContextManager());
                }
                {if ("" != null) return test;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="isSearchCondition">isSearchCondition</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode isSearchCondition(boolean inSelectClause) throws ParseException, StandardException {ValueNode       result;
        ValueNode       booleanPrimary;
        Token           isToken = null;
        Token           notToken = null;
        Token           truthValue = null;
    booleanPrimary = booleanPrimary(inSelectClause);
    switch (jj_nt.kind) {
    case IS:{
      isToken = jj_consume_token(IS);
      switch (jj_nt.kind) {
      case NOT:{
        notToken = jj_consume_token(NOT);
        break;
        }
      default:
        jj_la1[116] = jj_gen;
        ;
      }
      jj_consume_token(NULL);
      break;
      }
    default:
      jj_la1[117] = jj_gen;
      ;
    }
if ( isToken != null )
                {
                                result = (ValueNode) nodeFactory.getNode(
                                                                                        C_NodeTypes.IS_NULL_NODE,
                                                                                        booleanPrimary,
                                                                                        getContextManager());

                                /* Put the NOT on top of the tree */
                                if (notToken != null)
                                {
                                        result = (ValueNode) nodeFactory.getNode(
                                                                                        C_NodeTypes.NOT_NODE,
                                                                                        result,
                                                                                        getContextManager());
                                }
                }
                else { result = booleanPrimary; }

                {if ("" != null) return result;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="booleanPrimary">booleanPrimary</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode booleanPrimary(boolean inSelectClause) throws ParseException, StandardException {ValueNode       primary;
        ValueNode       searchCondition;
    primary = predicate(inSelectClause);
{if ("" != null) return  primary;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="predicate">predicate</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode predicate(boolean inSelectClause) throws ParseException, StandardException {ValueNode       value;
    if (jj_2_29(1)) {
      value = additiveExpression(null, 0, inSelectClause);
    } else {
      switch (jj_nt.kind) {
      case EXISTS:{
        value = existsExpression();
        break;
        }
      default:
        jj_la1[118] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    label_13:
    while (true) {
      if (remainingPredicateFollows()) {
        ;
      } else {
        break label_13;
      }
      value = remainingPredicate(value, inSelectClause);
    }
{if ("" != null) return value;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="remainingPredicates">remainingPredicates</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode remainingPredicate(ValueNode value, boolean inSelectClause) throws ParseException, StandardException {Token tok = null;
    switch (jj_nt.kind) {
    case LESS_THAN_OPERATOR:
    case LESS_THAN_OR_EQUALS_OPERATOR:
    case EQUALS_OPERATOR:
    case NOT_EQUALS_OPERATOR:
    case NOT_EQUALS_OPERATOR2:
    case GREATER_THAN_OPERATOR:
    case GREATER_THAN_OR_EQUALS_OPERATOR:{
      value = remainingNonNegatablePredicate(value, inSelectClause);
{if ("" != null) return value;}
      break;
      }
    case BETWEEN:
    case IN:
    case LIKE:
    case NOT:{
      switch (jj_nt.kind) {
      case NOT:{
        tok = jj_consume_token(NOT);
        break;
        }
      default:
        jj_la1[119] = jj_gen;
        ;
      }
      value = remainingNegatablePredicate(value, inSelectClause);
/* Put the NOT on top of the tree */
                if (tok != null)
                {
                        value = (ValueNode) nodeFactory.getNode(
                                                                                C_NodeTypes.NOT_NODE,
                                                                                value,
                                                                                getContextManager());
                }

                {if ("" != null) return value;}
      break;
      }
    default:
      jj_la1[120] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="remainingNonNegatablePredicate">remainingNonNegatablePredicate</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode remainingNonNegatablePredicate(ValueNode leftOperand, boolean inSelectClause) throws ParseException, StandardException {int                     operator;
        String          javaClassName;
        Token           tok = null;
        ValueNode       tree = null;
        ValueNode       likePattern;
        ValueNode       betweenLeft;
        ValueNode       betweenRight;
    operator = compOp();
    if ((getToken(1).kind == ALL || getToken(1).kind == ANY ||
                            getToken(1).kind == SOME) && getToken(2).kind == LEFT_PAREN) {
      operator = quantifier(operator);
      jj_consume_token(LEFT_PAREN);
      leftOperand = tableSubquery(operator, leftOperand);
      jj_consume_token(RIGHT_PAREN);
    } else if (jj_2_30(1)) {
      leftOperand = additiveExpression(leftOperand, operator, inSelectClause);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return leftOperand;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="remainingNegatablePredicate">remainingNegatablePredicate</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode remainingNegatablePredicate(ValueNode leftOperand, boolean inSelectClause) throws ParseException, StandardException {ValueNode       tree = null;
        ValueNode       likePattern;
        ValueNode       betweenLeft;
        ValueNode       betweenRight;
        ValueNode       escapeValue = null;
    switch (jj_nt.kind) {
    case IN:{
      jj_consume_token(IN);
      tree = inPredicateValue(leftOperand);
{if ("" != null) return tree;}
      break;
      }
    case LIKE:{
      jj_consume_token(LIKE);
      likePattern = additiveExpression(null, 0, inSelectClause);
      switch (jj_nt.kind) {
      case ESCAPE:
      case LEFT_BRACE:{
        switch (jj_nt.kind) {
        case ESCAPE:{
          jj_consume_token(ESCAPE);
          escapeValue = additiveExpression(null, 0, inSelectClause);
          break;
          }
        case LEFT_BRACE:{
          jj_consume_token(LEFT_BRACE);
          jj_consume_token(ESCAPE);
          escapeValue = additiveExpression(null, 0, inSelectClause);
          jj_consume_token(RIGHT_BRACE);
          break;
          }
        default:
          jj_la1[121] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[122] = jj_gen;
        ;
      }
tree = (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.LIKE_OPERATOR_NODE,
                                                                leftOperand,
                                                                likePattern,
                                                                escapeValue,
                                                                getContextManager());

                {if ("" != null) return tree;}
      break;
      }
    case BETWEEN:{
      // GemStone changes BEGIN
              tree = betweenPredicateValue(leftOperand, inSelectClause);
{if ("" != null) return tree;}
      break;
      }
    default:
      jj_la1[123] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="betweenPredicateValue">betweenPredicateValue</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode betweenPredicateValue(ValueNode leftOperand, boolean inSelectClause) throws ParseException, StandardException {ValueNode       tree = null;
        ValueNode       betweenLeft;
        ValueNode       betweenRight;
    jj_consume_token(BETWEEN);
    betweenLeft = specificationForRange();
    jj_consume_token(AND);
    betweenRight = specificationForRange();
ValueNodeList betweenList = (ValueNodeList) nodeFactory.getNode(
                                                                                                        C_NodeTypes.VALUE_NODE_LIST,
                                                                                                        getContextManager());
                if (betweenLeft == null) {
                        if (betweenRight == null) {
                                // TODO what exception to throw ....
                                {if (true) throw StandardException.newException(SQLState.LANG_COLUMN_OUT_OF_RANGE,
                                                                                                "Both values in range specification cannot be null");}
                        } else {
                                int betweenRightNodeType = betweenRight.getNodeType();
                                //betweenRight.toString();
                                String typename = ((ConstantNode)betweenRight).getValue().getTypeName();

                                Object nullOrDateTimeTimestampObj = getNullOrDateTypeObj(typename);
                                betweenLeft = (ValueNode) nodeFactory.getNode(betweenRightNodeType,
                                                                  nullOrDateTimeTimestampObj,
                                                                  getContextManager());
                                if (betweenLeft instanceof UserTypeConstantNode) {
                                        ((UserTypeConstantNode)betweenLeft).setInfinity(true);
                                }
                        }
                } else if (betweenRight == null) {
                            int betweenLeftNodeType = betweenLeft.getNodeType();
                            String typename = ((ConstantNode)betweenLeft).getValue().getTypeName();
                            Object nullOrDateTimeTimestampObj = getNullOrDateTypeObj(typename);
                                betweenRight = (ValueNode) nodeFactory.getNode(betweenLeftNodeType,
                                                                  nullOrDateTimeTimestampObj,
                                                                  getContextManager());
                                if (betweenRight instanceof UserTypeConstantNode) {
                                        ((UserTypeConstantNode)betweenRight).setInfinity(true);
                                }
                }
 // GemStone changes END
                betweenList.addElement(betweenLeft);
                betweenList.addElement(betweenRight);
                tree = (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.BETWEEN_OPERATOR_NODE,
                                                                leftOperand,
                                                                betweenList,
                                                                getContextManager());

                {if ("" != null) return tree;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="compOp">compOp</A>
 */
  final public int compOp() throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case EQUALS_OPERATOR:{
      jj_consume_token(EQUALS_OPERATOR);
{if ("" != null) return BinaryOperatorNode.EQ;}
      break;
      }
    case NOT_EQUALS_OPERATOR:{
      jj_consume_token(NOT_EQUALS_OPERATOR);
{if ("" != null) return BinaryOperatorNode.NE;}
      break;
      }
    case NOT_EQUALS_OPERATOR2:{
      jj_consume_token(NOT_EQUALS_OPERATOR2);
{if ("" != null) return BinaryOperatorNode.NE;}
      break;
      }
    case LESS_THAN_OPERATOR:{
      jj_consume_token(LESS_THAN_OPERATOR);
{if ("" != null) return BinaryOperatorNode.LT;}
      break;
      }
    case GREATER_THAN_OPERATOR:{
      jj_consume_token(GREATER_THAN_OPERATOR);
{if ("" != null) return BinaryOperatorNode.GT;}
      break;
      }
    case LESS_THAN_OR_EQUALS_OPERATOR:{
      jj_consume_token(LESS_THAN_OR_EQUALS_OPERATOR);
{if ("" != null) return BinaryOperatorNode.LE;}
      break;
      }
    case GREATER_THAN_OR_EQUALS_OPERATOR:{
      jj_consume_token(GREATER_THAN_OR_EQUALS_OPERATOR);
{if ("" != null) return BinaryOperatorNode.GE;}
      break;
      }
    default:
      jj_la1[124] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="additiveExpression">additiveExpression</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode additiveExpression(ValueNode farLeftOperand, int compOp, boolean inSelectClause) throws ParseException, StandardException {ValueNode       leftOperand;
        int                     operator;
        int                     nodeType;
    leftOperand = multiplicativeExpression(null, 0, inSelectClause);
    label_14:
    while (true) {
      switch (jj_nt.kind) {
      case PLUS_SIGN:
      case MINUS_SIGN:{
        ;
        break;
        }
      default:
        jj_la1[125] = jj_gen;
        break label_14;
      }
      operator = additiveOperator();
      leftOperand = multiplicativeExpression(leftOperand, operator, inSelectClause);
    }
if (farLeftOperand == null)
                        {if ("" != null) return leftOperand;}

                switch (compOp)
                {
                  case BinaryOperatorNode.EQ:
                        nodeType = C_NodeTypes.BINARY_EQUALS_OPERATOR_NODE;
                        break;

                  case BinaryOperatorNode.NE:
                        nodeType = C_NodeTypes.BINARY_NOT_EQUALS_OPERATOR_NODE;
                        break;

                  case BinaryOperatorNode.LT:
                        nodeType = C_NodeTypes.BINARY_LESS_THAN_OPERATOR_NODE;
                        break;

                  case BinaryOperatorNode.GT:
                        nodeType = C_NodeTypes.BINARY_GREATER_THAN_OPERATOR_NODE;
                        break;

                  case BinaryOperatorNode.LE:
                        nodeType = C_NodeTypes.BINARY_LESS_EQUALS_OPERATOR_NODE;
                        break;

                  case BinaryOperatorNode.GE:
                        nodeType = C_NodeTypes.BINARY_GREATER_EQUALS_OPERATOR_NODE;
                        break;

                  default:
                        if (SanityManager.DEBUG)
                        SanityManager.THROWASSERT("Unknown comparison operator " + compOp);
                        nodeType = 0;
                        break;
                }

                {if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                        nodeType,
                                                        farLeftOperand,
                                                        leftOperand,
                                                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="additiveOperator">additiveOperator</A>
 */
  final public int additiveOperator() throws ParseException, StandardException {Token tok;
    switch (jj_nt.kind) {
    case PLUS_SIGN:{
      tok = jj_consume_token(PLUS_SIGN);
{if ("" != null) return BinaryOperatorNode.PLUS;}
      break;
      }
    case MINUS_SIGN:{
      tok = jj_consume_token(MINUS_SIGN);
{if ("" != null) return BinaryOperatorNode.MINUS;}
      break;
      }
    default:
      jj_la1[126] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="multiplicativeExpression">multiplicativeExpression</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode multiplicativeExpression(ValueNode farLeftOperand, int additiveOperator, boolean inSelectClause) throws ParseException, StandardException {ValueNode       leftOperand;
        int                     multOp;
    leftOperand = unaryExpression(null, 0, inSelectClause);
    label_15:
    while (true) {
      switch (jj_nt.kind) {
      case ASTERISK:
      case SOLIDUS:
      case CONCATENATION_OPERATOR:{
        ;
        break;
        }
      default:
        jj_la1[127] = jj_gen;
        break label_15;
      }
      multOp = multiplicativeOperator();
      leftOperand = unaryExpression(leftOperand, multOp, inSelectClause);
    }
if (farLeftOperand == null)
                        {if ("" != null) return leftOperand;}

                switch (additiveOperator)
                {
                  case BinaryOperatorNode.PLUS:
                        {if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.BINARY_PLUS_OPERATOR_NODE,
                                                                        farLeftOperand,
                                                                        leftOperand,
                                                                        getContextManager()
                                                                        );}

                  case BinaryOperatorNode.MINUS:
                        {if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.BINARY_MINUS_OPERATOR_NODE,
                                                                        farLeftOperand,
                                                                        leftOperand,
                                                                        getContextManager()
                                                                        );}

                  default:
                        if (SanityManager.DEBUG)
                        SanityManager.THROWASSERT(
                                        "Unexpected operator value of " + additiveOperator);
                        {if ("" != null) return null;}
                }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="multiplicativeOperator">multiplicativeOperator</A>
 */
  final public int multiplicativeOperator() throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case ASTERISK:{
      jj_consume_token(ASTERISK);
{if ("" != null) return BinaryOperatorNode.TIMES;}
      break;
      }
    case SOLIDUS:{
      jj_consume_token(SOLIDUS);
{if ("" != null) return BinaryOperatorNode.DIVIDE;}
      break;
      }
    case CONCATENATION_OPERATOR:{
      jj_consume_token(CONCATENATION_OPERATOR);
{if ("" != null) return BinaryOperatorNode.CONCATENATE;}
      break;
      }
    default:
      jj_la1[128] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="unaryExpression">unaryExpression</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode unaryExpression(ValueNode farLeftOperand, int multiplicativeOperator, boolean inSelectClause) throws ParseException, StandardException {ValueNode       value;
        String          sign = null;
        int                     tokKind1;
        int                     tokKind2;
    if (( (tokKind1 = getToken(1).kind) == PLUS_SIGN ||
                                               tokKind1 == MINUS_SIGN )
                                            &&
                                            ( (tokKind2 = getToken(2).kind) != EXACT_NUMERIC &&
                                               tokKind2 != APPROXIMATE_NUMERIC)) {
      sign = sign();
    } else {
      ;
    }
    value = primaryExpression(inSelectClause);
if ("-".equals(sign))
                {
                        value = (ValueNode) nodeFactory.getNode(
                                                                                C_NodeTypes.UNARY_MINUS_OPERATOR_NODE,
                                                                                value,
                                                                                getContextManager());
                }
                else if ("+".equals(sign))
                {
                        value = (ValueNode) nodeFactory.getNode(
                                                                                C_NodeTypes.UNARY_PLUS_OPERATOR_NODE,
                                                                                value,
                                                                                getContextManager());
                }
                else if (SanityManager.DEBUG)
                {
                        if (sign != null)
                        {
                                SanityManager.THROWASSERT("Unknown unary operator '"
                                                                                        + sign
                                                                                        + "'");
                        }
                }

                {if ("" != null) return multOp(farLeftOperand, value, multiplicativeOperator);}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="sign">sign</A>
 */
  final public String sign() throws ParseException {Token   s;
    switch (jj_nt.kind) {
    case PLUS_SIGN:{
      s = jj_consume_token(PLUS_SIGN);
{if ("" != null) return s.image;}
      break;
      }
    case MINUS_SIGN:{
      s = jj_consume_token(MINUS_SIGN);
{if ("" != null) return s.image;}
      break;
      }
    default:
      jj_la1[129] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="primaryExpressionXX">primaryExpressionXX</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode primaryExpressionXX(boolean inSelectClause) throws ParseException, StandardException {ValueNode       value;
    value = primary(inSelectClause);
    label_16:
    while (true) {
      if (jj_2_31(1)) {
        ;
      } else {
        break label_16;
      }
      value = nonStaticMethodCallOrFieldAccess(value);
    }
{if ("" != null) return value;}
    throw new Error("Missing return statement in function");
  }

  final public ValueNode nonStaticMethodCallOrFieldAccess(ValueNode receiver) throws ParseException, StandardException {ValueNode value;
    value = nonStaticMethodInvocation(receiver);
{if ("" != null) return value;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="nonStaticMethodInvocation">nonStaticMethodInvocation</A>
 */
  final public ValueNode nonStaticMethodInvocation(ValueNode receiver) throws ParseException, StandardException {Vector                                  parameterList = new Vector();
        MethodCallNode                  methodNode;
        ParameterNode                   parameterNode;
    if (getToken(3).kind == LEFT_PAREN) {
      switch (jj_nt.kind) {
      case FIELD_REFERENCE:{
        jj_consume_token(FIELD_REFERENCE);
        break;
        }
      case PERIOD:{
        jj_consume_token(PERIOD);
        break;
        }
      default:
        jj_la1[130] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      methodNode = methodName(receiver);
      methodCallParameterList(parameterList);
/*
		** ? parameters are not allowed for the receiver --
		** unless the receiver is standing in for a named parameter,
		** whose type is therefore known.
		*/
                if (receiver instanceof ParameterNode)
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_PARAMETER_RECEIVER,
                                                                                                methodNode.getMethodName());}
                }

                methodNode.addParms(parameterList);

                /*
		** Assume this is being returned to the SQL domain.  If it turns
		** out that this is being returned to the Java domain, we will
		** get rid of this node.
		*/
                {if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.JAVA_TO_SQL_VALUE_NODE,
                                                                methodNode,
                                                                getContextManager());}
    } else {
      switch (jj_nt.kind) {
      case PERIOD:{
        jj_consume_token(PERIOD);
        methodNode = methodName(receiver);
/*
		** ? parameters are not allowed for the receiver --
		** unless the receiver is standing in for a named parameter,
		** whose type is therefore known.
		*/
                if (receiver instanceof ParameterNode)
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_PARAMETER_RECEIVER,
                                                                                                methodNode.getMethodName());}
                }

                methodNode.addParms(parameterList);

                /*
		** Assume this is being returned to the SQL domain.  If it turns
		** out that this is being returned to the Java domain, we will
		** get rid of this node.
		*/
                {if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.JAVA_TO_SQL_VALUE_NODE,
                                                                methodNode,
                                                                getContextManager());}
        break;
        }
      default:
        jj_la1[131] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="methodName">methodName</A>
 */
  final public MethodCallNode methodName(ValueNode receiver) throws ParseException, StandardException {String  methodName;
    /*
    	** NOTE: allowing a delimited identifier as a method name is necessary,
    	** because Java is case-sensitive.  But this also allows identifiers that
    	** do not match Java syntax.  This will probably not cause a problem
    	** in later phases, like binding and code generation.
    	*/
            methodName = caseSensitiveIdentifierPlusReservedWords();
{if ("" != null) return (MethodCallNode) nodeFactory.getNode(
                                                                                C_NodeTypes.NON_STATIC_METHOD_CALL_NODE,
                                                                                methodName,
                                                                                receiver,
                                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="staticMethodName">staticMethodName</A>
 */
  final public MethodCallNode staticMethodName(String javaClassName) throws ParseException, StandardException {String  methodName;
    /*
    	** NOTE: allowing a delimited identifier as a method name is necessary,
    	** because Java is case-sensitive.  But this also allows identifiers that
    	** do not match Java syntax.  This will probably not cause a problem
    	** in later phases, like binding and code generation.
    	*/
            methodName = caseSensitiveIdentifierPlusReservedWords();
{if ("" != null) return (MethodCallNode) nodeFactory.getNode(
                                                                C_NodeTypes.STATIC_METHOD_CALL_NODE,
                                                                methodName,
                                                                javaClassName,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="methodParameter">methodParameter</A>
 */
  final public void methodParameter(Vector parameterList) throws ParseException, StandardException {ValueNode       parameter;
    if (jj_2_32(1)) {
      parameter = additiveExpression(null,0, false);
parameterList.addElement(parameter);
    } else {
      switch (jj_nt.kind) {
      case NULL:{
        parameter = nullSpecification();
parameterList.addElement(parameter);
        break;
        }
      default:
        jj_la1[132] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/*
 * <A NAME="primary">primary</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode primary(boolean inSelectClause) throws ParseException, StandardException {String          javaClassName;
        ValueNode       value;
    if (javaClassFollows()) {
      value = staticClassReference();
{if ("" != null) return value;}
    } else if (jj_2_33(1)) {
      value = valueExpressionPrimary(inSelectClause);
{if ("" != null) return value;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="staticClassReference">staticClassReference</A>
 */
  final public ValueNode staticClassReference() throws ParseException, StandardException {String          javaClassName;
        ValueNode value;
    javaClassName = javaClass();
    jj_consume_token(DOUBLE_COLON);
    value = staticClassReferenceType(javaClassName);
{if ("" != null) return value;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="staticClassReferenceType">staticClassReferenceType</A>
 */
  final public ValueNode staticClassReferenceType(String javaClassName) throws ParseException, StandardException {ValueNode value;
    if ((getToken(2).kind == LEFT_PAREN)) {
      value = staticMethodInvocation(javaClassName);
{if ("" != null) return value;}
    } else if (jj_2_34(1)) {
      value = staticClassFieldReference(javaClassName);
{if ("" != null) return value;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="staticClassFieldReference">staticClassFieldReference</A>
 */
  final public ValueNode staticClassFieldReference(String javaClassName) throws ParseException, StandardException {String          fieldName = null;
    fieldName = caseSensitiveIdentifierPlusReservedWords();
{if ("" != null) return  (ValueNode) nodeFactory.getNode(
                                        C_NodeTypes.JAVA_TO_SQL_VALUE_NODE,
                                        nodeFactory.getNode(
                                                                C_NodeTypes.STATIC_CLASS_FIELD_REFERENCE_NODE,
                                                                javaClassName,
                                                                fieldName,
                                                                nextToLastTokenDelimitedIdentifier,
                                                                getContextManager()),
                                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="nonSecondDatetimeField">nonSecondDatetimeField</A>
 */
  final public int nonSecondDatetimeField() throws ParseException {
    switch (jj_nt.kind) {
    case YEAR:{
      jj_consume_token(YEAR);
{if ("" != null) return DateTimeDataValue.YEAR_FIELD;}
      break;
      }
    case MONTH:{
      jj_consume_token(MONTH);
{if ("" != null) return DateTimeDataValue.MONTH_FIELD;}
      break;
      }
    case DAY:{
      jj_consume_token(DAY);
{if ("" != null) return DateTimeDataValue.DAY_FIELD;}
      break;
      }
    case HOUR:{
      jj_consume_token(HOUR);
{if ("" != null) return DateTimeDataValue.HOUR_FIELD;}
      break;
      }
    case MINUTE:{
      jj_consume_token(MINUTE);
{if ("" != null) return DateTimeDataValue.MINUTE_FIELD;}
      break;
      }
    default:
      jj_la1[133] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ValueNode escapedValueFunction() throws ParseException, StandardException {ValueNode       value;
    ValueNode   str1;
    ValueNode   str2;
        ValueNode       startPosition;
    ValueNode   length = null;
    if (jj_2_35(1)) {
      value = miscBuiltinsCore(true /* is JDBC escape */);
{if ("" != null) return value;}
    } else {
      switch (jj_nt.kind) {
      case SUBSTRING:{
        jj_consume_token(SUBSTRING);
        jj_consume_token(LEFT_PAREN);
        value = additiveExpression(null, 0, false);
        jj_consume_token(COMMA);
        startPosition = additiveExpression(null, 0, false);
        switch (jj_nt.kind) {
        case COMMA:{
          jj_consume_token(COMMA);
          length = additiveExpression(null, 0, false);
          break;
          }
        default:
          jj_la1[134] = jj_gen;
          ;
        }
        jj_consume_token(RIGHT_PAREN);
{if ("" != null) return getSubstringNode(value, startPosition, length, Boolean.FALSE);}
        break;
        }
      case CURDATE:{
        jj_consume_token(CURDATE);
        jj_consume_token(LEFT_PAREN);
        jj_consume_token(RIGHT_PAREN);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.CURRENT_DATETIME_OPERATOR_NODE,
                                                                ReuseFactory.getInteger(
                                                                        CurrentDatetimeOperatorNode.CURRENT_DATE),
                                                                getContextManager());}
        break;
        }
      case CURTIME:{
        jj_consume_token(CURTIME);
        jj_consume_token(LEFT_PAREN);
        jj_consume_token(RIGHT_PAREN);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                        C_NodeTypes.CURRENT_DATETIME_OPERATOR_NODE,
                                                        ReuseFactory.getInteger(
                                                                CurrentDatetimeOperatorNode.CURRENT_TIME),
                                                        getContextManager());}
        break;
        }
      case CONCAT:{
        jj_consume_token(CONCAT);
        jj_consume_token(LEFT_PAREN);
        str1 = additiveExpression(null,0, false);
        jj_consume_token(COMMA);
        str2 = additiveExpression(null,0, false);
        jj_consume_token(RIGHT_PAREN);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                            C_NodeTypes.CONCATENATION_OPERATOR_NODE,
                            str1,
                            str2,
                            getContextManager());}
        break;
        }
      case CURRENT_USER:
      case SESSION_USER:
      case USER:{
        /* Method versions of USER special registers
        	 * are ODBC remnants.  Only supported
        	 * when escaped.
        	 */
                value = userNode();
        jj_consume_token(LEFT_PAREN);
        jj_consume_token(RIGHT_PAREN);
{if ("" != null) return value;}
        break;
        }
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:{
        value = timestampArithmeticFuncion();
{if ("" != null) return value;}
        break;
        }
      default:
        jj_la1[135] = jj_gen;
        if (getEscapedSYSFUN(getToken(1).image) != null) {
          value = escapedSYSFUNFunction();
{if ("" != null) return value;}
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="numericValueFunction">numericValueFunction</A>
 */
  final public ValueNode escapedSYSFUNFunction() throws ParseException, StandardException {Vector      parameterList = new Vector();
        Token tok;
    tok = jj_consume_token(IDENTIFIER);
    methodCallParameterList(parameterList);
String sysFunName = getEscapedSYSFUN(tok.image);

            TableName functionName = (TableName) nodeFactory.getNode(
                                                                C_NodeTypes.TABLE_NAME,
                                                                SchemaDescriptor.IBM_SYSTEM_FUN_SCHEMA_NAME,
                                                                sysFunName,
// GemStone changes BEGIN
                                                                // changed to use Integer.valueOf()
                                                                Integer.valueOf(0),
                                                                Integer.valueOf(0),
// GemStone changes END
                                                                getContextManager());

                MethodCallNode methodNode = (MethodCallNode) nodeFactory.getNode(
                                                                C_NodeTypes.STATIC_METHOD_CALL_NODE,
                                                                functionName,
                                                                null,
                                                                getContextManager());

                methodNode.addParms(parameterList);

                /*
		** Assume this is being returned to the SQL domain.  If it turns
		** out that this is being returned to the Java domain, we will
		** get rid of this node.
		*/
                {if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.JAVA_TO_SQL_VALUE_NODE,
                                                                methodNode,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="timestampArithmeticFuncion">timestampArithmeticFuncion</A>
 */
  final public ValueNode timestampArithmeticFuncion() throws ParseException, StandardException {ValueNode intervalType;
    ValueNode tstamp1;
    ValueNode tstamp2;
    ValueNode count;
    switch (jj_nt.kind) {
    case TIMESTAMPADD:{
      jj_consume_token(TIMESTAMPADD);
      jj_consume_token(LEFT_PAREN);
      intervalType = jdbcIntervalType();
      jj_consume_token(COMMA);
      count = additiveExpression(null,0,false);
      jj_consume_token(COMMA);
      tstamp1 = additiveExpression(null,0,false);
      jj_consume_token(RIGHT_PAREN);
{if ("" != null) return (ValueNode) nodeFactory.getNode( C_NodeTypes.TIMESTAMP_ADD_FN_NODE,
                                                tstamp1,
                                                intervalType,
                                                count,
                                                ReuseFactory.getInteger( TernaryOperatorNode.TIMESTAMPADD),
                                                null,
                                                getContextManager());}
      break;
      }
    case TIMESTAMPDIFF:{
      jj_consume_token(TIMESTAMPDIFF);
      jj_consume_token(LEFT_PAREN);
      intervalType = jdbcIntervalType();
      jj_consume_token(COMMA);
      tstamp1 = additiveExpression(null,0,false);
      jj_consume_token(COMMA);
      tstamp2 = additiveExpression(null,0,false);
      jj_consume_token(RIGHT_PAREN);
{if ("" != null) return (ValueNode) nodeFactory.getNode( C_NodeTypes.TIMESTAMP_DIFF_FN_NODE,
                                                tstamp2,
                                                intervalType,
                                                tstamp1,
                                                ReuseFactory.getInteger( TernaryOperatorNode.TIMESTAMPDIFF),
                                                null,
                                                getContextManager());}
      break;
      }
    default:
      jj_la1[136] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="jdbcIntervalType">jdbcIntervalType</A>
 */
  final public ValueNode jdbcIntervalType() throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case SQL_TSI_FRAC_SECOND:{
      jj_consume_token(SQL_TSI_FRAC_SECOND);
{if ("" != null) return getJdbcIntervalNode( DateTimeDataValue.FRAC_SECOND_INTERVAL);}
      break;
      }
    case SQL_TSI_SECOND:{
      jj_consume_token(SQL_TSI_SECOND);
{if ("" != null) return getJdbcIntervalNode( DateTimeDataValue.SECOND_INTERVAL);}
      break;
      }
    case SQL_TSI_MINUTE:{
      jj_consume_token(SQL_TSI_MINUTE);
{if ("" != null) return getJdbcIntervalNode( DateTimeDataValue.MINUTE_INTERVAL);}
      break;
      }
    case SQL_TSI_HOUR:{
      jj_consume_token(SQL_TSI_HOUR);
{if ("" != null) return getJdbcIntervalNode( DateTimeDataValue.HOUR_INTERVAL);}
      break;
      }
    case SQL_TSI_DAY:{
      jj_consume_token(SQL_TSI_DAY);
{if ("" != null) return getJdbcIntervalNode( DateTimeDataValue.DAY_INTERVAL);}
      break;
      }
    case SQL_TSI_WEEK:{
      jj_consume_token(SQL_TSI_WEEK);
{if ("" != null) return getJdbcIntervalNode( DateTimeDataValue.WEEK_INTERVAL);}
      break;
      }
    case SQL_TSI_MONTH:{
      jj_consume_token(SQL_TSI_MONTH);
{if ("" != null) return getJdbcIntervalNode( DateTimeDataValue.MONTH_INTERVAL);}
      break;
      }
    case SQL_TSI_QUARTER:{
      jj_consume_token(SQL_TSI_QUARTER);
{if ("" != null) return getJdbcIntervalNode( DateTimeDataValue.QUARTER_INTERVAL);}
      break;
      }
    case SQL_TSI_YEAR:{
      jj_consume_token(SQL_TSI_YEAR);
{if ("" != null) return getJdbcIntervalNode( DateTimeDataValue.YEAR_INTERVAL);}
      break;
      }
    default:
      jj_la1[137] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="numericValueFunction">numericValueFunction</A>
 */
  final public ValueNode numericValueFunction() throws ParseException, StandardException {ValueNode       value;
        int                     field;
    switch (jj_nt.kind) {
    case ABS:{
      jj_consume_token(ABS);
      value = absFunction();
{if ("" != null) return value;}
      break;
      }
    case ABSVAL:{
      jj_consume_token(ABSVAL);
      value = absFunction();
{if ("" != null) return value;}
      break;
      }
    case SQRT:{
      jj_consume_token(SQRT);
      jj_consume_token(LEFT_PAREN);
      value = additiveExpression(null,0,false);
      jj_consume_token(RIGHT_PAREN);
{if ("" != null) return (ValueNode)nodeFactory.getNode(
                C_NodeTypes.SQRT_OPERATOR_NODE,
                value,
                getContextManager());}
      break;
      }
    case MOD:{
      jj_consume_token(MOD);
      value = modFunction();
{if ("" != null) return value;}
      break;
      }
    case IDENTITY_VAL_LOCAL:{
      jj_consume_token(IDENTITY_VAL_LOCAL);
      jj_consume_token(LEFT_PAREN);
      jj_consume_token(RIGHT_PAREN);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                C_NodeTypes.IDENTITY_VAL_NODE,
                                                getContextManager());}
      break;
      }
    default:
      jj_la1[138] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="coalesceFunction">coalesceFunction</A>
 */
  final public ValueNode coalesceFunction(String coalesceOrValue) throws ParseException, StandardException {ValueNodeList expressionList = (ValueNodeList) nodeFactory.getNode(
        C_NodeTypes.VALUE_NODE_LIST,
        getContextManager());
    jj_consume_token(LEFT_PAREN);
    coalesceExpression(expressionList);
    label_17:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[139] = jj_gen;
        break label_17;
      }
      jj_consume_token(COMMA);
      coalesceExpression(expressionList);
    }
    jj_consume_token(RIGHT_PAREN);
{if ("" != null) return (ValueNode)nodeFactory.getNode(
                C_NodeTypes.COALESCE_FUNCTION_NODE,
                coalesceOrValue,
                expressionList,
                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="coalesceExpression">coalesceExpression</A>
 */
  final public void coalesceExpression(ValueNodeList expressionList) throws ParseException, StandardException {ValueNode       expression;
    expression = additiveExpression(null,0,false);
expressionList.addElement(expression);
  }

/*
 * <A NAME="absFunction">absFunction</A>
 */
  final public ValueNode absFunction() throws ParseException, StandardException {ValueNode value;
    jj_consume_token(LEFT_PAREN);
    value = additiveExpression(null,0, false);
    jj_consume_token(RIGHT_PAREN);
{if ("" != null) return (ValueNode)nodeFactory.getNode(
                C_NodeTypes.ABSOLUTE_OPERATOR_NODE,
                value,
                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="modFunction">modFunction</A>
 */
  final public ValueNode modFunction() throws ParseException, StandardException {ValueNode int1;
        ValueNode int2;
    jj_consume_token(LEFT_PAREN);
    int1 = additiveExpression(null,0,false);
    jj_consume_token(COMMA);
    int2 = additiveExpression(null,0,false);
    jj_consume_token(RIGHT_PAREN);
{if ("" != null) return (ValueNode)nodeFactory.getNode(
                C_NodeTypes.MOD_OPERATOR_NODE,
                int1, int2,
                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="datetimeField">datetimeField</A>
 */
  final public int datetimeField() throws ParseException {int field;
    switch (jj_nt.kind) {
    case HOUR:
    case MINUTE:
    case YEAR:
    case DAY:
    case MONTH:{
      field = nonSecondDatetimeField();
{if ("" != null) return field;}
      break;
      }
    case SECOND:{
      jj_consume_token(SECOND);
{if ("" != null) return DateTimeDataValue.SECOND_FIELD;}
      break;
      }
    default:
      jj_la1[140] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ValueNode characterValueFunction() throws ParseException, StandardException {ValueNode       value = null;
        ValueNode       str1;
        ValueNode       str2;
        Token           upperTok = null;
        Token           lowerTok = null;
        ValueNode       startPosition;
    ValueNode   length = null;
    switch (jj_nt.kind) {
    case SUBSTR:{
      jj_consume_token(SUBSTR);
      jj_consume_token(LEFT_PAREN);
      value = additiveExpression(null,0,false);
      jj_consume_token(COMMA);
      startPosition = additiveExpression(null,0,false);
      switch (jj_nt.kind) {
      case COMMA:{
        jj_consume_token(COMMA);
        length = additiveExpression(null,0,false);
        break;
        }
      default:
        jj_la1[141] = jj_gen;
        ;
      }
      jj_consume_token(RIGHT_PAREN);
{if ("" != null) return getSubstringNode( value, startPosition, length, Boolean.FALSE );}
      break;
      }
    case LOWER:
    case UPPER:{
      switch (jj_nt.kind) {
      case UPPER:{
        upperTok = jj_consume_token(UPPER);
        break;
        }
      case LOWER:{
        lowerTok = jj_consume_token(LOWER);
        break;
        }
      default:
        jj_la1[142] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(LEFT_PAREN);
      value = additiveExpression(null,0,false);
      jj_consume_token(RIGHT_PAREN);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                        C_NodeTypes.SIMPLE_STRING_OPERATOR_NODE,
                                        value,
                                        (upperTok != null) ? "upper" : "lower",
                                        getContextManager());}
      break;
      }
    case LCASE:
    case UCASE:{
      switch (jj_nt.kind) {
      case UCASE:{
        upperTok = jj_consume_token(UCASE);
        break;
        }
      case LCASE:{
        lowerTok = jj_consume_token(LCASE);
        break;
        }
      default:
        jj_la1[143] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(LEFT_PAREN);
      value = additiveExpression(null,0,false);
      jj_consume_token(RIGHT_PAREN);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                        C_NodeTypes.SIMPLE_STRING_OPERATOR_NODE,
                                        value,
                                        (upperTok != null) ? "upper" : "lower",
                                        getContextManager());}
      break;
      }
    case TRIM:
    case LTRIM:
    case RTRIM:{
      value = trimFunction();
{if ("" != null) return value;}
      break;
      }
    case LOCATE:{
      jj_consume_token(LOCATE);
      jj_consume_token(LEFT_PAREN);
      str1 = additiveExpression(null,0,false);
      jj_consume_token(COMMA);
      str2 = additiveExpression(null,0,false);
      switch (jj_nt.kind) {
      case COMMA:{
        jj_consume_token(COMMA);
        value = additiveExpression(null,0,false);
        break;
        }
      default:
        jj_la1[144] = jj_gen;
        ;
      }
      jj_consume_token(RIGHT_PAREN);
// if start is missing, start is equal to 1
        {if ("" != null) return (ValueNode) nodeFactory.getNode(
                            C_NodeTypes.LOCATE_FUNCTION_NODE,
                            str1,
                            str2,
                            (value == null) ? getNodeFactory().getNode(
                                        C_NodeTypes.INT_CONSTANT_NODE,
                                        ReuseFactory.getInteger(1),
                                        getContextManager() )
                                                                                        : value,
                            ReuseFactory.getInteger(TernaryOperatorNode.LOCATE),
                            null,
                            getContextManager());}
      break;
      }
    default:
      jj_la1[145] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ValueNode trimFunction() throws ParseException, StandardException {ValueNode       source;
        Integer         trimType;
        ValueNode       ansiTrimNode;
    switch (jj_nt.kind) {
    case LTRIM:
    case RTRIM:{
      trimType = trimType();
      jj_consume_token(LEFT_PAREN);
      source = additiveExpression(null,0,false);
      jj_consume_token(RIGHT_PAREN);
{if ("" != null) return getTrimOperatorNode(trimType, null, source, null);}
      break;
      }
    case TRIM:{
      jj_consume_token(TRIM);
      ansiTrimNode = ansiTrim();
{if ("" != null) return ansiTrimNode;}
      break;
      }
    default:
      jj_la1[146] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ValueNode ansiTrim() throws ParseException, StandardException {Integer trimSpec = ReuseFactory.getInteger(StringDataValue.BOTH);
    ValueNode trimChar = null;
    ValueNode trimSource = null;
    if (ansiTrimSpecFollows()) {
      jj_consume_token(LEFT_PAREN);
      trimSpec = ansiTrimSpec();
      if (jj_2_36(2147483647)) {
        jj_consume_token(FROM);
        trimSource = additiveExpression(null,0,false);
        jj_consume_token(RIGHT_PAREN);
{if ("" != null) return getTrimOperatorNode(trimSpec, trimChar, trimSource, null);}
      } else if (jj_2_37(1)) {
        // LEADING <char> FROM <source>
                 trimChar = additiveExpression(null,0,false);
        jj_consume_token(FROM);
        trimSource = additiveExpression(null,0,false);
        jj_consume_token(RIGHT_PAREN);
{if ("" != null) return getTrimOperatorNode(trimSpec, trimChar, trimSource, null);}
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else if (!ansiTrimSpecFollows()) {
      jj_consume_token(LEFT_PAREN);
      trimChar = additiveExpression(null,0,false);
      switch (jj_nt.kind) {
      case FROM:{
        jj_consume_token(FROM);
        trimSource = additiveExpression(null,0,false);
        jj_consume_token(RIGHT_PAREN);
{if ("" != null) return getTrimOperatorNode(trimSpec, trimChar, trimSource, null);}
        break;
        }
      case RIGHT_PAREN:{
        jj_consume_token(RIGHT_PAREN);
// expr was trim(e)-- we assigned e to trimChar but it is really the trimSource
            {if ("" != null) return getTrimOperatorNode(trimSpec, null, trimChar, null);}
        break;
        }
      default:
        jj_la1[147] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Integer ansiTrimSpec() throws ParseException {
    switch (jj_nt.kind) {
    case TRAILING:{
      jj_consume_token(TRAILING);
{if ("" != null) return ReuseFactory.getInteger(StringDataValue.TRAILING);}
      break;
      }
    case LEADING:{
      jj_consume_token(LEADING);
{if ("" != null) return ReuseFactory.getInteger(StringDataValue.LEADING);}
      break;
      }
    case BOTH:{
      jj_consume_token(BOTH);
{if ("" != null) return ReuseFactory.getInteger(StringDataValue.BOTH);}
      break;
      }
    default:
      jj_la1[148] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Integer trimType() throws ParseException {
    switch (jj_nt.kind) {
    case RTRIM:{
      jj_consume_token(RTRIM);
{if ("" != null) return ReuseFactory.getInteger(StringDataValue.TRAILING);}
      break;
      }
    case LTRIM:{
      jj_consume_token(LTRIM);
{if ("" != null) return ReuseFactory.getInteger(StringDataValue.LEADING);}
      break;
      }
    default:
      jj_la1[149] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="valueExpressionPrimary">valueExpressionPrimary</A>
 * 
 * @param inSelectClause will be true if this method got called while parsing the select or values clause
 * If in select or values clause, we do not want to allow boolean values.
 */
  final public ValueNode valueExpressionPrimary(boolean inSelectClause) throws ParseException, StandardException {ValueNode       value;
        int                     tokKind;
    if (escapedValueFunctionFollows()) {
      jj_consume_token(LEFT_BRACE);
      jj_consume_token(FN);
      value = escapedValueFunction();
      jj_consume_token(RIGHT_BRACE);
{if ("" != null) return value;}
    } else if (getToken(2).kind == SCHEMA || getToken(2).kind == SQLID) {
      jj_consume_token(CURRENT);
      switch (jj_nt.kind) {
      case SCHEMA:{
        jj_consume_token(SCHEMA);
        break;
        }
      case SQLID:{
        jj_consume_token(SQLID);
        break;
        }
      default:
        jj_la1[150] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                C_NodeTypes.CURRENT_SCHEMA_NODE,
                                                getContextManager());}
    } else if (getToken(2).kind == ISOLATION) {
      jj_consume_token(CURRENT);
      jj_consume_token(ISOLATION);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                C_NodeTypes.CURRENT_ISOLATION_NODE,
                                                getContextManager());}
    } else {
      switch (jj_nt.kind) {
      case CASE:
      case CURRENT_USER:
      case FALSE:
      case NULLIF:
      case SESSION_USER:
      case TRUE:
      case USER:
      case CURRENT_ROLE:
      case LEFT_BRACE:
      case PLUS_SIGN:
      case MINUS_SIGN:
      case QUESTION_MARK:
      case EXACT_NUMERIC:
      case STRING:
      case HEX_STRING:
      case APPROXIMATE_NUMERIC:{
        /* Omitted "case_expression" */
                value = valueSpecification();
{if ("" != null) return value;}
        break;
        }
      default:
        jj_la1[151] = jj_gen;
        if (newInvocationFollows(1)) {
          value = newInvocation();
{if ("" != null) return value;}
        } else if (aggregateFollows()) {
          value = aggregateNode();
{if ("" != null) return value;}
        } else if (miscBuiltinFollows()) {
          value = miscBuiltins();
{if ("" != null) return value;}
        } else if (jj_2_39(1)) {
          value = columnReference();
{if ("" != null) return value;}
        } else {
          switch (jj_nt.kind) {
          case LEFT_PAREN:{
            jj_consume_token(LEFT_PAREN);
            if (getToken(1).kind == SELECT || getToken(1).kind == VALUES) {
              value = subquery(SubqueryNode.EXPRESSION_SUBQUERY, null);
            } else if (inSelectClause) {
              value = additiveExpression(null,0, inSelectClause);
            } else if (jj_2_38(1)) {
              //following will happen if we are not coming here for select/values clause
                              value = valueExpression(inSelectClause);
            } else {
              jj_consume_token(-1);
              throw new ParseException();
            }
            jj_consume_token(RIGHT_PAREN);
{if ("" != null) return value;}
            break;
            }
          case CAST:{
            value = castSpecification();
{if ("" != null) return value;}
            break;
            }
          default:
            jj_la1[152] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="miscBuiltins">miscBuiltins</A>
 */
  final public ValueNode miscBuiltins() throws ParseException, StandardException {ValueNode value;
    if (// GemStone changes BEGIN
                 ( ((lookAhead = getToken(1)).kind == GET_CURRENT_CONNECTION ||
                    lookAhead.kind == ABS ||
                    lookAhead.kind == ABSVAL ||
                    lookAhead.kind == SQRT ||
                    lookAhead.kind == MOD ||
                    lookAhead.kind == COALESCE ||
                    lookAhead.kind == VALUE ||
                    lookAhead.kind == NVL ||
                    lookAhead.kind == DECODE ||
                    lookAhead.kind == IDENTITY_VAL_LOCAL ||
                    lookAhead.kind == SUBSTRING ||
                    lookAhead.kind == SUBSTR ||
                    lookAhead.kind == UPPER ||
                    lookAhead.kind == LOWER ||
                    lookAhead.kind == UCASE ||
                    lookAhead.kind == LCASE ||
                    lookAhead.kind == LTRIM ||
                    lookAhead.kind == RTRIM ||
                    lookAhead.kind == TRIM ||
                    lookAhead.kind == DATE ||
                    lookAhead.kind == TIME ||
                    lookAhead.kind == TIMESTAMP ||
                            lookAhead.kind == DOUBLE ||
                            lookAhead.kind == CHAR ||
                            lookAhead.kind == VARCHAR ||
                            lookAhead.kind == INTEGER ||
                            lookAhead.kind == INT ||
                            lookAhead.kind == SMALLINT ||
                            lookAhead.kind == LONGINT ||
                    lookAhead.kind == YEAR ||
                    lookAhead.kind == MONTH ||
                    lookAhead.kind == DAY ||
                    lookAhead.kind == HOUR ||
                    lookAhead.kind == MINUTE ||
                    lookAhead.kind == SECOND ||
                    lookAhead.kind == LENGTH ||
                    lookAhead.kind == LOCATE ||
                    lookAhead.kind == XMLPARSE ||
                    lookAhead.kind == XMLSERIALIZE ||
                    lookAhead.kind == XMLEXISTS ||
                    lookAhead.kind == XMLQUERY) &&
                    /* (original code)
                 ( (getToken(1).kind == GET_CURRENT_CONNECTION ||
                    getToken(1).kind == ABS ||
                    getToken(1).kind == ABSVAL ||
                    getToken(1).kind == SQRT ||
                    getToken(1).kind == MOD ||
                    getToken(1).kind == COALESCE ||
                    getToken(1).kind == VALUE ||
                    getToken(1).kind == IDENTITY_VAL_LOCAL ||
                    getToken(1).kind == SUBSTRING ||
                    getToken(1).kind == SUBSTR ||
                    getToken(1).kind == UPPER ||
                    getToken(1).kind == LOWER ||
                    getToken(1).kind == UCASE ||
                    getToken(1).kind == LCASE ||
                    getToken(1).kind == LTRIM ||
                    getToken(1).kind == RTRIM ||
                    getToken(1).kind == TRIM ||
                    getToken(1).kind == DATE ||
                    getToken(1).kind == TIME ||
                    getToken(1).kind == TIMESTAMP ||
    		getToken(1).kind == DOUBLE ||
    		getToken(1).kind == CHAR ||
    		getToken(1).kind == VARCHAR ||
    		getToken(1).kind == INTEGER ||
    		getToken(1).kind == INT || 
    		getToken(1).kind == SMALLINT ||
    		getToken(1).kind == LONGINT ||
                    getToken(1).kind == YEAR ||
                    getToken(1).kind == MONTH ||
                    getToken(1).kind == DAY ||
                    getToken(1).kind == HOUR ||
                    getToken(1).kind == MINUTE ||
                    getToken(1).kind == SECOND ||
                    getToken(1).kind == LENGTH ||
                    getToken(1).kind == LOCATE ||
                    getToken(1).kind == XMLPARSE ||
                    getToken(1).kind == XMLSERIALIZE ||
                    getToken(1).kind == XMLEXISTS ||
                    getToken(1).kind == XMLQUERY ) &&
                    */
    // GemStone changes END
                  getToken(2).kind == LEFT_PAREN
                  )) {
      /* miscBuiltins() are composed of the core
      	 * system, string and numeric functions,
      	 * date functions
      	 * and static method calls.
      	 */
              value = miscBuiltinsCore(false /* not JDBC escape */);
{if ("" != null) return value;}
    } else if (jj_2_40(1)) {
      value = datetimeValueFunction();
{if ("" != null) return value;}
    } else if (jj_2_41(1)) {
      /* This is where we build a node for static method aliases */
              value = routineInvocation();
{if ("" != null) return value;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ValueNode miscBuiltinsCore(boolean isJDBCEscape) throws ParseException, StandardException {ValueNode value;
    switch (jj_nt.kind) {
    case GET_CURRENT_CONNECTION:{
      jj_consume_token(GET_CURRENT_CONNECTION);
      jj_consume_token(LEFT_PAREN);
      jj_consume_token(RIGHT_PAREN);
checkInternalFeature("GETCURRENTCONNECTION()");
                {if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.JAVA_TO_SQL_VALUE_NODE,
                                                                nodeFactory.getNode(
                                                                        C_NodeTypes.GET_CURRENT_CONNECTION_NODE,
                                                                        getContextManager()),
                                                                getContextManager());}
      break;
      }
    case ABS:
    case ABSVAL:
    case IDENTITY_VAL_LOCAL:
    case MOD:
    case SQRT:{
      value = numericValueFunction();
{if ("" != null) return value;}
      break;
      }
    case LOWER:
    case TRIM:
    case UPPER:
    case LTRIM:
    case RTRIM:
    case SUBSTR:
    case LCASE:
    case LOCATE:
    case UCASE:{
      value = characterValueFunction();
{if ("" != null) return value;}
      break;
      }
    default:
      jj_la1[153] = jj_gen;
      if (jj_2_42(1)) {
        value = dataTypeScalarFunction();
{if ("" != null) return value;}
      } else {
        switch (jj_nt.kind) {
        case COALESCE:{
          jj_consume_token(COALESCE);
          value = coalesceFunction("COALESCE");
{if ("" != null) return value;}
          break;
          }
        case VALUE:{
          jj_consume_token(VALUE);
          value = coalesceFunction("VALUE");
{if ("" != null) return value;}
          break;
          }
        case NVL:{
          jj_consume_token(NVL);
          value = nvlFunction("NVL");
{if ("" != null) return value;}
          break;
          }
        case DECODE:{
          jj_consume_token(DECODE);
          value = decodeFunction();
{if ("" != null) return value;}
          break;
          }
        case LENGTH:{
          jj_consume_token(LENGTH);
          jj_consume_token(LEFT_PAREN);
          value = additiveExpression(null,0, false);
          jj_consume_token(RIGHT_PAREN);
ContextManager  localCM = getContextManager();
                if( isJDBCEscape)
                        {if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.CHAR_LENGTH_OPERATOR_NODE,
                                                                getTrimOperatorNode(
                                                                        ReuseFactory.getInteger(StringDataValue.TRAILING),
                                                                        null,
                                                                        value,
                                                                        localCM),
                                                                localCM);}
                {if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                        C_NodeTypes.DB2_LENGTH_OPERATOR_NODE,
                                                        value,
                                                        localCM);}
          break;
          }
        case XMLEXISTS:
        case XMLPARSE:
        case XMLQUERY:
        case XMLSERIALIZE:{
          value = xmlFunction();
{if ("" != null) return value;}
          break;
          }
        default:
          jj_la1[154] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="dataTypeScalarFunction">dataTypeScalarFunction</A>
 */
  final public ValueNode dataTypeScalarFunction() throws ParseException, StandardException {DataTypeDescriptor dts;
        ValueNode value;           //converted result
        ValueNode operand;
        int charType;
        int length = -1;
    switch (jj_nt.kind) {
    case HOUR:
    case MINUTE:
    case SECOND:
    case YEAR:
    case DATE:
    case DAY:
    case MONTH:
    case TIME:
    case TIMESTAMP:{
      //Note: When you add a new data type function, in addition to adding it 
              // here, you need to add it to miscBuiltins()
              value = dateTimeScalarFunction();
{if ("" != null) return value;}
      break;
      }
    default:
      jj_la1[156] = jj_gen;
      if (jj_2_43(1)) {
        dts = numericFunctionType();
        jj_consume_token(LEFT_PAREN);
        operand = additiveExpression(null,0, false);
        jj_consume_token(RIGHT_PAREN);
value = (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.CAST_NODE,
                                                                        operand,
                                                                        dts,
                                                                        getContextManager());
                        ((CastNode) value).setForDataTypeFunction(true);
                        ((CastNode) value).setForExternallyGeneratedCASTnode();

                        {if ("" != null) return value;}
      } else {
        switch (jj_nt.kind) {
        case CHAR:
        case VARCHAR:{
          charType = charOrVarchar();
          jj_consume_token(LEFT_PAREN);
          operand = additiveExpression(null,0, false);
          switch (jj_nt.kind) {
          case COMMA:{
            jj_consume_token(COMMA);
            length = length();
            break;
            }
          default:
            jj_la1[155] = jj_gen;
            ;
          }
          jj_consume_token(RIGHT_PAREN);
// Always check db2 limits for this function. It's new
                checkTypeLimits(charType,length);
                value = (ValueNode) nodeFactory.getNode(
                                                                                                C_NodeTypes.CAST_NODE,
                                                                                                operand,
// GemStone changes BEGIN
                                                                                                // changed to use Integer.valueOf()
                                                                                                Integer.valueOf(charType),
                                                                                                Integer.valueOf(length),
// GemStone changes END
                                                                                                getContextManager());

                ((CastNode) value).setForDataTypeFunction(true);
                ((CastNode) value).setForExternallyGeneratedCASTnode();
                {if ("" != null) return value;}
          break;
          }
        default:
          jj_la1[157] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="xmlFunction">xmlFunction</A>
 *
 * This method parses the built-in functions used with
 * the XML datatype.
 *
 */
  final public ValueNode xmlFunction() throws ParseException, StandardException {ValueNode value;
        checkVersion(DataDictionary.DD_VERSION_DERBY_10_1, "XML");

        // We only allow XML operations if the classpath has all
        // of the required external classes (namley, JAXP and Xalan).
        com.pivotal.gemfirexd.internal.iapi.types.XML.checkXMLRequirements();
    switch (jj_nt.kind) {
    case XMLPARSE:{
      jj_consume_token(XMLPARSE);
      jj_consume_token(LEFT_PAREN);
      xmlDocOrContent();
      value = xmlParseValue();
      jj_consume_token(RIGHT_PAREN);
{if ("" != null) return value;}
      break;
      }
    case XMLSERIALIZE:{
      jj_consume_token(XMLSERIALIZE);
      jj_consume_token(LEFT_PAREN);
      value = xmlSerializeValue();
      jj_consume_token(RIGHT_PAREN);
{if ("" != null) return value;}
      break;
      }
    case XMLEXISTS:{
      jj_consume_token(XMLEXISTS);
      jj_consume_token(LEFT_PAREN);
      value = xmlQueryValue(true);
      jj_consume_token(RIGHT_PAREN);
{if ("" != null) return value;}
      break;
      }
    case XMLQUERY:{
      jj_consume_token(XMLQUERY);
      jj_consume_token(LEFT_PAREN);
      value = xmlQueryValue(false);
      jj_consume_token(RIGHT_PAREN);
{if ("" != null) return value;}
      break;
      }
    default:
      jj_la1[158] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="xmlParseValue">xmlParseValue</A>
 *
 * Syntax is as follows:
 *
 *     XMLPARSE( DOCUMENT <string-value-expression> PRESERVE WHITESPACE )
 *
 * The result of this operation will be an XML value, which can either
 * be used transiently or else can be stored persistently in a table that
 * has an XML column.  For example:
 *
 * ij> CREATE TABLE x_table (id INT, xdoc XML);
 * 0 rows inserted/updated/deleted
 * ij> INSERT INTO x_table VALUES (1, XMLPARSE(DOCUMENT '<simp> doc </simp>'
 * PRESERVE WHITESPACE));
 * 1 row inserted/updated/deleted
 *
 * We only allow XML documents (as opposed to XML content) to be
 * parsed into XML values.  Note that we require the "PRESERVE WHITESPACE"
 * keyword to be explicit; this is because the SQL/XML (2003) spec says that
 * if no whitespace option is given, the default is "STRIP WHITESPACE", which
 * we don't support (yet).
 *
 * By the time we get to this method, the "DOCUMENT" keyword has already
 * been parsed.
 *
 */
  final public ValueNode xmlParseValue() throws ParseException, StandardException {ValueNode value;
        boolean wsOption;
    value = additiveExpression(null,0,false);
    wsOption = xmlPreserveWhitespace();
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                        C_NodeTypes.XML_PARSE_OPERATOR_NODE,
                                        value,
                                        ReuseFactory.getInteger(UnaryOperatorNode.XMLPARSE_OP),
                                        new Object[] {(wsOption ? Boolean.TRUE : Boolean.FALSE)},
                                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="xmlPreserveWhitespace">xmlPreserveWhitespace</A>
 *
 * For now, we only support the PRESERVE WHITESPACE option.
 *
 */
  final public boolean xmlPreserveWhitespace() throws ParseException, StandardException {
    if ((getToken(1).kind != STRIP) &&
                    (getToken(1).kind != PRESERVE)) {
{if (true) throw StandardException.newException(
                        SQLState.LANG_XML_KEYWORD_MISSING, "PRESERVE WHITESPACE",
                        ReuseFactory.getInteger(getToken(1).beginLine),
                        ReuseFactory.getInteger(getToken(1).beginColumn));}
    } else {
      switch (jj_nt.kind) {
      case STRIP:{
        jj_consume_token(STRIP);
        jj_consume_token(WHITESPACE);
// don't preserve whitespace.
                {if (true) throw StandardException.newException(
                        SQLState.LANG_UNSUPPORTED_XML_FEATURE, "STRIP WHITESPACE");}
        break;
        }
      case PRESERVE:{
        jj_consume_token(PRESERVE);
        jj_consume_token(WHITESPACE);
// must preserve whitespace.
                {if ("" != null) return true;}
        break;
        }
      default:
        jj_la1[159] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="xmlSerializeValue">xmlSerializeValue</A>
 *
 * Syntax is as follows:
 *
 *   XMLSERIALIZE( <xml-value-expression> AS <string-data-type> )
 *
 * The result of this operation will be a string value with the type specified
 * by the user.  For example:
 *
 * ij> SELECT id, XMLSERIALIZE(xdoc AS varchar(30)) FROM x_table;
 * ID         |2
 * ------------------------------------------
 * 1          |<simp> doc </simp>
 *
 */
  final public ValueNode xmlSerializeValue() throws ParseException, StandardException {ValueNode value;
        DataTypeDescriptor targetType;
boolean existing = getCompilerContext().switchOptimizeLiteral(false);
    // GemStone changes END
            value = additiveExpression(null,0,false);
    targetType = xmlSerializeTargetType();
// GemStone changes BEGIN
                getCompilerContext().switchOptimizeLiteral(existing);
// GemStone changes END
                {if ("" != null) return (ValueNode) nodeFactory.getNode(
                                        C_NodeTypes.XML_SERIALIZE_OPERATOR_NODE,
                                        value,
                                        ReuseFactory.getInteger(UnaryOperatorNode.XMLSERIALIZE_OP),
                                        new Object[] {targetType},
                                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="xmlSerializeTargetType">xmlSerializeTargetType</A>
 *
 * Parse the target type of an XMLSERIALIZE operation.
 *
 */
  final public DataTypeDescriptor xmlSerializeTargetType() throws ParseException, StandardException {DataTypeDescriptor targetType;
    if ((getToken(1).kind != AS)) {
{if (true) throw StandardException.newException(
                        SQLState.LANG_XML_KEYWORD_MISSING, "AS",
                        ReuseFactory.getInteger(getToken(1).beginLine),
                        ReuseFactory.getInteger(getToken(1).beginColumn));}
    } else {
      switch (jj_nt.kind) {
      case AS:{
        jj_consume_token(AS);
        targetType = dataTypeDDL();
{if ("" != null) return targetType;}
        break;
        }
      default:
        jj_la1[160] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="xmlQueryValue">xmlQueryValue</A>
 *
 * This method is used for parsing the XMLEXISTS and XMLQUERY operators
 * (which operator depends on the received boolean parameter).
 *
 * For XMLEXISTS, the syntax is as follows:
 *
 *   XMLEXISTS( <xpath-expression> PASSING BY REF <xml-value-expression> )
 *
 * The result of this operation will be a boolean true/false/unknown value:
 *   -- Unknown if either <xquery-expression> or <xml-value-expression> is null;
 *   -- True if evaluation of the given query expression against the
 *      given xml-value returns at least one node.
 *   -- False otherwise.
 *
 * For example:
 *
 * ij> SELECT id FROM x_table WHERE XMLEXISTS('/simple' PASSING BY REF xdoc);
 * ID
 * -----------
 * 1
 *
 * ====
 *
 * For XMLQUERY, the syntax is as follows:
 *
 *   XMLQUERY( <xquery-expression>
 *      PASSING BY REF <xml-value-expression>
 *      [ RETURNING SEQUENCE [ BY REF ] ]
 *      EMPTY ON EMPTY
 *   )
 *
 * The result of this operation will be an XMLDataValue.
 *
 * For example:
 *
 * ij> SELECT XMLSERIALIZE(
 *       XMLQUERY('/simple' PASSING BY REF xdoc EMPTY ON EMPTY) AS CHAR(100));
 * ID
 * -----------
 * <simp> doc </simp>
 *
 */
  final public ValueNode xmlQueryValue(boolean existsOnly) throws ParseException, StandardException {// The query expression (currently must be an expression
        // supported by Xalan--i.e. XPath only).
        ValueNode xqueryExpr = null;

        // Context item for the query; not required by SQL/XML spec,
        // but required by Derby for now.
        ValueNode xmlValue = null;

        // User-specified default passing mechanism.  Since Derby only
        // supports one type of passing mechanism--BY REF--this value
        // isn't currently used.
        short defaultPassingMech = -1;
boolean existing = getCompilerContext().switchOptimizeLiteral(false);
    // GemStone changes END
            xqueryExpr = additiveExpression(null, 0, false);
getCompilerContext().switchOptimizeLiteral(existing);
    jj_consume_token(PASSING);
    defaultPassingMech = xmlPassingMechanism();
    xmlValue = xqVarList();
    if (!existsOnly) {
      if (jj_2_45(1)) {
        xqReturningClause();
        if (jj_2_44(1)) {
          xmlPassingMechanism();
        } else {
          ;
        }
      } else {
        ;
      }
      xqEmptyHandlingClause();

    } else if (existsOnly) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
ValueNode vNode = (ValueNode) nodeFactory.getNode(
                        (existsOnly
                                ? C_NodeTypes.XML_EXISTS_OPERATOR_NODE
                                : C_NodeTypes.XML_QUERY_OPERATOR_NODE),
                        xqueryExpr,
                        xmlValue,
                        (existsOnly
                                ? ReuseFactory.getInteger(BinaryOperatorNode.XMLEXISTS_OP)
                                : ReuseFactory.getInteger(BinaryOperatorNode.XMLQUERY_OP)),
                        getContextManager());

                {if ("" != null) return vNode;}
    throw new Error("Missing return statement in function");
  }

/**
 * <A NAME="xqVarList">xqVarList</A>
 *
 * Parse a list of XML query variables, which can include at most one
 * XML value to be used as the "context item" for the query.  If
 * such a context item was found, return that item; for all other
 * variable declarations we currently throw a "not supported" error
 * because Xalan doesn't allowing binding of variables.
 */
  final public 
ValueNode xqVarList() throws ParseException, StandardException {// Placeholder for the XML context item as we parse the
        // argument list.
        ValueNode [] xmlValue = new ValueNode [] { (ValueNode)null };
    xqVariable(xmlValue);
    label_18:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[161] = jj_gen;
        break label_18;
      }
      jj_consume_token(COMMA);
      xqVariable(xmlValue);
    }
{if ("" != null) return xmlValue[0];}
    throw new Error("Missing return statement in function");
  }

/**
 * <A NAME="xqVariable">xqVariable</A>
 *
 * Parse an XML query variable.  If the argument is an XML value
 * to be used as the "context item" for a query, then store the
 * value in the first slot of the received ValueNode array;
 * otherwise, throw a "not supported" errror (for now).
 */
  final public 
void xqVariable(ValueNode [] xmlVal) throws ParseException, StandardException {ValueNode curVal;
        String varName = null;
        short passingMech = -1;
    curVal = additiveExpression(null,0, false);
    if (getToken(1).kind == AS) {
      jj_consume_token(AS);
      varName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
/* From XQuery 1.0: "The <identifier> I contained in XQV
			 * shall be an XML 1.1 NCName."  From XML 1.1:
			 *
			 *   [4] NCName ::= (Letter | '_') (NCNameChar)*
			 *   [5] NCNameChar ::= Letter | Digit | '.' | '-' | '_' |
			 *                    CombiningChar | Extender
			 *
			 * Since Derby's definition of an "identifier" is a subset
			 * of NCName, we just use Derby's definition.  This means
			 * that some valid NCNames won't be recognized by Derby--
			 * but since the ones we _do_ recognize are all still valid
			 * NCNames, we're not breaking any rules.
			 */

                        /* All of that said, since we use Xalan as the underlying
			 * query engine and Xalan doesn't support variable binding,
			 * there's no point in letting the user specify variables
			 * right now.  So we disallow it.  In the future we'll have
			 * to add logic here to store the variables and pass them
			 * to the correct operator for binding/execution.
			 */
                        {if (true) throw StandardException.newException(
                                SQLState.LANG_UNSUPPORTED_XML_FEATURE, "PASSING ... AS");}
    } else {
      ;
    }
    if (jj_2_46(1)) {
      passingMech = xmlPassingMechanism();
    } else {
      ;
    }
if (varName == null)
                        {
                                /* We get here if we just parsed an XML context item.
				 * That said, if we already have one (xmlVal[0] is not
				 * null) then we can't allow second one, per SQL/XML[2006]
				 * (6.17: Syntax Rules:5.b.i): "XMQ shall contain exactly
				 * one <XML query context item> XQCI."
				 */
                                if (xmlVal[0] != null)
                                {
                                        {if (true) throw StandardException.newException(
                                                SQLState.LANG_MULTIPLE_XML_CONTEXT_ITEMS);}
                                }

                                xmlVal[0] = curVal;

                                /* Note: It's possible that a passing mechanism was
				 * specified for the context item; if so its value is
				 * stored in passingMech.  However, we don't actually
			 	 * store that passing mechanism anywhere because we
				 * (currently) only support BY REF, so we know what
			 	 * it has to be.  If we add support for other passing
			 	 * mechanisms (namely, BY VALUE) in the future, we'll
			 	 * have to store the passing mechanism provided by
			 	 * the user and process it at compilation/execution
				 * time.
				 */
                        }

  }

/*
 * <A NAME="xmlPassingMechanism">xmlPassingMechanism</A>
 *
 * For now, we only support the BY REF option because
 * that gives us better performance (allows us to avoid
 * performing potentially deep copies of XML nodes).  This
 * means that if the same XML value is passed BY REF into
 * two different XML arguments for a single operator, then
 * every node in the first XML argument must have an
 * identical node in the second XML argument, and the
 * ids for both nodes must be the same.  That said,
 * since we don't support variable binding yet, this
 * becomes a non-issue because we can't pass XML values.
 * In the future, though, we may choose to support the
 * passing/binding of variables (the only reason we
 * don't now is because Xalan doesn't support it) and
 * if we do, BY REF should provide better performance
 * due to lack of deep copying.
 */
  final public short xmlPassingMechanism() throws ParseException, StandardException {
    if (getToken(2).kind == REF) {
      jj_consume_token(BY);
      jj_consume_token(REF);
// pass the XML value by reference
                {if ("" != null) return com.pivotal.gemfirexd.internal.iapi.types.XML.XQ_PASS_BY_REF;}
    } else {
      switch (jj_nt.kind) {
      case BY:{
        jj_consume_token(BY);
        jj_consume_token(VALUE);
// pass a 'copy' of the XML value.
                {if (true) throw StandardException.newException(
                        SQLState.LANG_UNSUPPORTED_XML_FEATURE, "BY VALUE");}
        break;
        }
      default:
        jj_la1[162] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="xqReturningClause">xqReturningClause</A>
 *
 * For now we only support "RETURNING SEQUENCE".  The reason
 * is that this applies to the XMLQUERY operator and the
 * results of evaluating a query expression in Xalan against
 * an XML value can be an arbritary sequence of items--including
 * atomic values.  For simplicity we just return the values
 * as they are, without doing any further work.  SQL/XML[2006]
 * says that if we supported RETURNING CONTENT then we'd have
 * to construct an XQuery document from the results--but we don't
 * do that extra work for now, so we just say that we return
 * SEQUENCE.
 *
 * NOTE: This means that we may not be able to store the results
 * of an XMLQUERY operation into a Derby XML column.  Right now
 * an XML column can only hold valid DOCUMENT nodes, which we
 * we define as an XML value whose serialized form can be parsed
 * by a JAXP DocumentBuilder (because that's what Derby's XMLPARSE
 * operator uses and the result is always a Document node).
 * Internally this means that we can only store a sequence if it
 * contains exactly one org.w3c.dom.Node that is an instance of
 * org.w3c.dom.Document.  If the result of an XMLQUERY operation
 * does not fit this criteria then it will *not* be storable into
 * Derby XML columns.
 */
  final public short xqReturningClause() throws ParseException, StandardException {
    if (getToken(2).kind == SEQUENCE) {
      jj_consume_token(RETURNING);
      jj_consume_token(SEQUENCE);
// XMLQUERY should return result as a sequence.
          // NOTE: since Derby XML columns only allow DOCUMENT(UNTYPED),
          // the result of an XMLQUERY operator that returns SEQUENCE
          // might not be storable into an XML column.
                {if ("" != null) return com.pivotal.gemfirexd.internal.iapi.types.XML.XQ_RETURN_SEQUENCE;}
    } else {
      switch (jj_nt.kind) {
      case RETURNING:{
        jj_consume_token(RETURNING);
        jj_consume_token(CONTENT);
// XMLQUERY should return 'content'.
                {if (true) throw StandardException.newException(
                        SQLState.LANG_UNSUPPORTED_XML_FEATURE, "RETURNING CONTENT");}
        break;
        }
      default:
        jj_la1[163] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="xqEmptyHandlingClause">xqEmptyHandlingClause</A>
 *
 * Defines what the behavior should be when an XMLQUERY operator
 * results in an empty sequence.  For now we just return the
 * empty sequence.
 */
  final public short xqEmptyHandlingClause() throws ParseException, StandardException {
    if (getToken(1).kind == EMPTY) {
      jj_consume_token(EMPTY);
      jj_consume_token(ON);
      jj_consume_token(EMPTY);
// XMLQUERY should return an empty sequence when result of
          // the query is an empty sequence (i.e. when there are no
          // results).
                {if ("" != null) return com.pivotal.gemfirexd.internal.iapi.types.XML.XQ_EMPTY_ON_EMPTY;}
    } else {
      switch (jj_nt.kind) {
      case NULL:{
        jj_consume_token(NULL);
        jj_consume_token(ON);
        jj_consume_token(EMPTY);
// XMLQUERY should return a null XML value when result of
          // the query is an empty sequence (i.e. when there are no
          // results).
                {if (true) throw StandardException.newException(
                        SQLState.LANG_UNSUPPORTED_XML_FEATURE, "NULL ON EMPTY");}
        break;
        }
      default:
        jj_la1[164] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="numericFunctionType">numericFunctionType</A>
 */
  final public DataTypeDescriptor numericFunctionType() throws ParseException, StandardException {DataTypeDescriptor dts;
    if (jj_2_47(1)) {
      dts = doubleType();
{if ("" != null) return dts;}
    } else {
      switch (jj_nt.kind) {
      case INT:
      case INTEGER:
      case SMALLINT:
      case LONGINT:{
        dts = exactIntegerType();
{if ("" != null) return dts;}
        break;
        }
      default:
        jj_la1[165] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="dateTimeScalarFunction">dateTimeScalarFunction</A>
 */
  final public ValueNode dateTimeScalarFunction() throws ParseException, StandardException {ValueNode       value;
        ValueNode       timestampNode;
        int             field;
    switch (jj_nt.kind) {
    case TIME:{
      jj_consume_token(TIME);
      jj_consume_token(LEFT_PAREN);
      value = additiveExpression(null,0, false);
      jj_consume_token(RIGHT_PAREN);
ValueNode castValue = (ValueNode) nodeFactory.getNode(
                                                        C_NodeTypes.CAST_NODE,
                                                        value,
                                                        DataTypeDescriptor.getBuiltInDataTypeDescriptor( Types.TIME),
                                                        getContextManager());
                ((CastNode) castValue).setForExternallyGeneratedCASTnode();
                {if ("" != null) return castValue;}
      break;
      }
    case DATE:{
      jj_consume_token(DATE);
      jj_consume_token(LEFT_PAREN);
      value = additiveExpression(null,0, false);
      jj_consume_token(RIGHT_PAREN);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                        C_NodeTypes.UNARY_DATE_TIMESTAMP_OPERATOR_NODE,
                                                        value,
                                                        DataTypeDescriptor.getBuiltInDataTypeDescriptor( Types.DATE),
                                                        getContextManager());}
      break;
      }
    case TIMESTAMP:{
      jj_consume_token(TIMESTAMP);
      jj_consume_token(LEFT_PAREN);
      value = additiveExpression(null,0, false);
      timestampNode = timestampFunctionCompletion(value);
{if ("" != null) return timestampNode;}
      break;
      }
    case HOUR:
    case MINUTE:
    case SECOND:
    case YEAR:
    case DAY:
    case MONTH:{
      field = datetimeField();
      jj_consume_token(LEFT_PAREN);
      value = additiveExpression(null,0, false);
      jj_consume_token(RIGHT_PAREN);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.EXTRACT_OPERATOR_NODE,
                                                                ReuseFactory.getInteger(field),
                                                                value,
                                                                getContextManager());}
      break;
      }
    default:
      jj_la1[166] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="timestampFunctionCompletion">timestampFunctionCompletion</A>
 */
  final public ValueNode timestampFunctionCompletion(ValueNode firstArg) throws ParseException, StandardException {ValueNode timeValue;
    switch (jj_nt.kind) {
    case RIGHT_PAREN:{
      jj_consume_token(RIGHT_PAREN);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                        C_NodeTypes.UNARY_DATE_TIMESTAMP_OPERATOR_NODE,
                                                        firstArg,
                                                        DataTypeDescriptor.getBuiltInDataTypeDescriptor( Types.TIMESTAMP),
                                                        getContextManager());}
      break;
      }
    case COMMA:{
      jj_consume_token(COMMA);
      timeValue = additiveExpression(null,0, false);
      jj_consume_token(RIGHT_PAREN);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                        C_NodeTypes.TIMESTAMP_OPERATOR_NODE,
                                                        firstArg,
                                                        timeValue,
                                                        getContextManager());}
      break;
      }
    default:
      jj_la1[167] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="booleanLiteral">booleanLiteral</A>
 */
  final public Token booleanLiteral() throws ParseException {Token tok;
    switch (jj_nt.kind) {
    case TRUE:{
      tok = jj_consume_token(TRUE);
{if ("" != null) return tok;}
      break;
      }
    case FALSE:{
      tok = jj_consume_token(FALSE);
{if ("" != null) return tok;}
      break;
      }
    default:
      jj_la1[168] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="generalValueSpecification">generalValueSpecification</A>
 */
  final public ValueNode generalValueSpecification() throws ParseException, StandardException {ValueNode       parm;
    switch (jj_nt.kind) {
    case QUESTION_MARK:{
      parm = dynamicParameterSpecification();
{if ("" != null) return parm;}
      break;
      }
    case CURRENT_USER:
    case SESSION_USER:
    case USER:{
      parm = userNode();
{if ("" != null) return parm;}
      break;
      }
    case CURRENT_ROLE:{
      parm = currentRoleNode();
{if ("" != null) return parm;}
      break;
      }
    default:
      jj_la1[169] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ValueNode userNode() throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case USER:{
      jj_consume_token(USER);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.USER_NODE,
                                                                getContextManager());}
      break;
      }
    case CURRENT_USER:{
      jj_consume_token(CURRENT_USER);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                C_NodeTypes.CURRENT_USER_NODE,
                                                getContextManager());}
      break;
      }
    case SESSION_USER:{
      jj_consume_token(SESSION_USER);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                C_NodeTypes.SESSION_USER_NODE,
                                                getContextManager());}
      break;
      }
    default:
      jj_la1[170] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="currentRoleNode">currentRoleNode</A>
 */
  final public ValueNode currentRoleNode() throws ParseException, StandardException {
    jj_consume_token(CURRENT_ROLE);
{if (true) throw StandardException.newException
            (SQLState.NOT_IMPLEMENTED, "ROLES");}
                checkVersion( DataDictionary.DD_VERSION_DERBY_10_4, "ROLES");
                checkSqlStandardAccess("CURRENT_ROLE");
                {if ("" != null) return (ValueNode) nodeFactory.getNode(
                        C_NodeTypes.CURRENT_ROLE_NODE,
                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="newInvocation">newInvocation</A>
 */
  final public JavaToSQLValueNode newInvocation() throws ParseException, StandardException {QueryTreeNode   newNode;
        Vector  parameterList = new Vector();
        String  javaClassName;
    jj_consume_token(NEW);
    javaClassName = javaClassName();
    methodCallParameterList(parameterList);
if (!javaClassName.startsWith("com.pivotal.gemfirexd.internal.diag.") && !javaClassName.startsWith("com.pivotal.gemfirexd.internal.catalog.") && !javaClassName.startsWith("com.ibm.db2j."))
                {
                        checkInternalFeature(javaClassName);
                }
                newNode =  nodeFactory.getNode(C_NodeTypes.NEW_INVOCATION_NODE,
                                                                           javaClassName,
                                                                           parameterList,
                                                                           lastTokenDelimitedIdentifier,
                                                                           getContextManager());

                /*
		** Assume this is being returned to the SQL domain.  If it turns
		** out that this is being returned to the Java domain, we will
		** get rid of this node.
		*/
                {if ("" != null) return (JavaToSQLValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.JAVA_TO_SQL_VALUE_NODE,
                                                                newNode,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="vtiTableConstruct">vtiTableConstruct</A>
 *
 * Parse a TABLE() constructor that corresponds to an internal
 * VTI invocation.  For example:
 *
 *    TABLE ( <qualifiedName> (arg1, arg2, ...) )
 *
 * where <qualifiedName> is a table name that Derby will map internally
 * to a VTI (ex. "SYSCS_DIAG.SPACE_TABLE").  The list of arguments
 * will then be passed to the VTI when it is invoked (DERBY-2152).
 *
 * An example query where this might occur is as follows:
 *
 *   SELECT * FROM TABLE(SYSCS_DIAG.SPACE_TABLE('APP', 'T1')) x
 *
 * in which case SYSCS_DIAG.SPACE_TABLE will be mapped (internally)
 * to the "com.pivotal.gemfirexd.internal.diag.SpaceTable" diagnostic VTI.  Thus
 * the equivalent call prior to DERBY-2152 would have been:
 *
 *   SELECT * FROM NEW com.pivotal.gemfirexd.internal.diag.SpaceTable('APP', 'T1')) x
 *
 * Note that this latter syntax is still supported.
 */
  final public JavaToSQLValueNode vtiTableConstruct() throws ParseException, StandardException {NewInvocationNode newNode = null;
    QueryTreeNode invocationNode = null;
    Vector parameterList = new Vector();
    TableName vtiTableName = null;
    TableDescriptor td;
    MethodCallNode      methodNode;
    jj_consume_token(TABLE);
    jj_consume_token(LEFT_PAREN);
    vtiTableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    methodCallParameterList(parameterList);
    jj_consume_token(RIGHT_PAREN);
/* The fact that we pass a NULL table descriptor to the
        * following call is an indication that we are mapping to a
        * VTI table function (i.e. one that accepts arguments).
        * Since we have the table name we do not need to pass in a
        * TableDescriptor--we'll just create one from the table
        * name. See NewInvocationNode for more.
        */
        newNode = (NewInvocationNode) nodeFactory.getNode
        (
            C_NodeTypes.NEW_INVOCATION_NODE,
            vtiTableName,  // TableName
            null,          // TableDescriptor
            parameterList,
            lastTokenDelimitedIdentifier,
            getContextManager());

        if ( newNode.isBuiltinVTI() ) { invocationNode = newNode; }
        else
        {
            methodNode = (MethodCallNode) nodeFactory.getNode(
                C_NodeTypes.STATIC_METHOD_CALL_NODE,
                vtiTableName,
                null,
                getContextManager());
            methodNode.addParms(parameterList);

            invocationNode = methodNode;
        }


        /*
        ** Assume this is being returned to the SQL domain.  If it turns
        ** out that this is being returned to the Java domain, we will
        ** get rid of this node.
        */
        {if ("" != null) return (JavaToSQLValueNode) nodeFactory.getNode(
                    C_NodeTypes.JAVA_TO_SQL_VALUE_NODE,
                    invocationNode,
                    getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="staticMethodInvocation">staticMethodInvocation</A>
 */
  final public ValueNode staticMethodInvocation(String javaClassName) throws ParseException, StandardException {Vector  parameterList = new Vector();
        MethodCallNode  methodNode;
    methodNode = staticMethodName(javaClassName);
    methodCallParameterList(parameterList);
methodNode.addParms(parameterList);

                /*
		** Assume this is being returned to the SQL domain.  If it turns
		** out that this is being returned to the Java domain, we will
		** get rid of this node.
		*/
                {if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.JAVA_TO_SQL_VALUE_NODE,
                                                                methodNode,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/**
 * <A NAME="methodCallParameterList">methodCallParameterList</A>
*/
  final public 
void methodCallParameterList(Vector parameterList) throws ParseException, StandardException {
    jj_consume_token(LEFT_PAREN);
    if (jj_2_48(1)) {
      methodParameter(parameterList);
      label_19:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[171] = jj_gen;
          break label_19;
        }
        jj_consume_token(COMMA);
        methodParameter(parameterList);
      }
    } else {
      ;
    }
    jj_consume_token(RIGHT_PAREN);
  }

/*
 * <A NAME="routineInvocation">routineInvocation</A>
 */
  final public ValueNode routineInvocation() throws ParseException, StandardException {Vector  parameterList = new Vector();
        TableName       routineName;
        MethodCallNode  methodNode;
    routineName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    methodCallParameterList(parameterList);
methodNode = (MethodCallNode) nodeFactory.getNode(
                                                                C_NodeTypes.STATIC_METHOD_CALL_NODE,
                                                                routineName,
                                                                null,
                                                                getContextManager());

                methodNode.addParms(parameterList);

                /*
		** Assume this is being returned to the SQL domain.  If it turns
		** out that this is being returned to the Java domain, we will
		** get rid of this node.
		*/
                {if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.JAVA_TO_SQL_VALUE_NODE,
                                                                methodNode,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="javaClass">javaClass</A>
 */
  final public 
String javaClass() throws ParseException, StandardException {String javaClassName;
    javaClassName = javaClassName();
{if ("" != null) return javaClassName;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="columnMethodInvocation">columnMethodInvocation</A>
 */
  final public ValueNode columnMethodInvocation() throws ParseException, StandardException {ValueNode       columnReference;
        ValueNode       methodNode;
    columnReference = columnNameForInvocation();
    methodNode = nonStaticMethodInvocation(columnReference);
{if ("" != null) return methodNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="columnNameForInvocation">columnNameForInvocation</A>
 */
  final public ValueNode columnNameForInvocation() throws ParseException, StandardException {String firstName;
        String secondName = null;
        String thirdName = null;
        String          columnName = null;
        String          tableName = null;
        String          schemaName = null;
        TableName       tabName = null;
        ValueNode       retval;
    firstName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
    if (getToken(1).kind == PERIOD &&
                                            getToken(3).kind == PERIOD) {
      jj_consume_token(PERIOD);
      secondName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
      if (getToken(1).kind == PERIOD &&
                                                      getToken(3).kind == PERIOD) {
        jj_consume_token(PERIOD);
        thirdName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
      } else {
        ;
      }
    } else {
      ;
    }
// Figure out what each identifier stands for
                if (thirdName == null)
                {
                        if (secondName == null)
                        {
                                // There's only one identifier, so it must be a column name
                                columnName = firstName;
                        }
                        else
                        {
                                // There are two identifiers, so they are table and column names
                                tableName = firstName;
                                columnName = secondName;
                        }
                }
                else
                {
                        // There are three identifiers,
                        // so they are schema, table, and column names
                        schemaName = firstName;
                        tableName = secondName;
                        columnName = thirdName;
                }

                if (tableName != null)
                {
                        // There is a table name, so get a TableName node
                        tabName =
                                (TableName) nodeFactory.getNode(
                                                        C_NodeTypes.TABLE_NAME,
                                                        schemaName,
                                                        tableName,
// GemStone changes BEGIN
                                                        // changed to use Integer.valueOf()
                                                        Integer.valueOf(nextToLastIdentifierToken.beginOffset),
                                                        Integer.valueOf(nextToLastIdentifierToken.endOffset),
// GemStone changes END
                                                        getContextManager());
                }

                // Get the column reference
                retval = (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.COLUMN_REFERENCE,
                                                                        columnName,
                                                                        tabName,
// GemStone changes BEGIN
                                                                        // changed to use Integer.valueOf()
                                                                        Integer.valueOf(lastIdentifierToken.beginOffset),
                                                                        Integer.valueOf(lastIdentifierToken.endOffset),
// GemStone changes END
                                                                        getContextManager());

                {if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="columnReference">columnReference</A>
 */
  final public ColumnReference columnReference() throws ParseException, StandardException {String          firstName;
        String          secondName = null;
        String          thirdName = null;
        String          columnName = null;
        String          tableName = null;
        String          schemaName = null;
        TableName       tabName = null;
    firstName = identifier(Limits.MAX_IDENTIFIER_LENGTH, false);
    if (getToken(1).kind == PERIOD &&
                                            getToken(3).kind != LEFT_PAREN) {
      jj_consume_token(PERIOD);
      secondName = identifier(Limits.MAX_IDENTIFIER_LENGTH, false);
      if (getToken(1).kind == PERIOD &&
                                                      getToken(3).kind != LEFT_PAREN) {
        jj_consume_token(PERIOD);
        thirdName = identifier(Limits.MAX_IDENTIFIER_LENGTH, false);
      } else {
        ;
      }
    } else {
      ;
    }
// Figure out what each name stands for
                if (thirdName == null)
                {
                        if (secondName == null)
                        {
                                // Only one name, must be column name
                                columnName = firstName;
                        }
                        else
                        {
                                // Two names: table.column
                                tableName = firstName;
                                columnName = secondName;
                        }
                }
                else
                {
                        // Three names: schema.table.column
                        schemaName = firstName;
                        tableName = secondName;
                        columnName = thirdName;
                }

                checkIdentifierLengthLimit(columnName, Limits.MAX_IDENTIFIER_LENGTH);
                if (schemaName != null)
                        checkIdentifierLengthLimit(schemaName, Limits.MAX_IDENTIFIER_LENGTH);
                if (tableName != null)
                        checkIdentifierLengthLimit(tableName, Limits.MAX_IDENTIFIER_LENGTH);

                if (tableName != null)
                {
                        tabName = (TableName) nodeFactory.getNode(
                                                        C_NodeTypes.TABLE_NAME,
                                                        schemaName,
                                                        tableName,
// GemStone changes BEGIN
                                                        // changed to use Integer.valueOf()
                                                        Integer.valueOf(nextToLastIdentifierToken.beginOffset),
                                                        Integer.valueOf(nextToLastIdentifierToken.endOffset),
// GemStone changes END
                                                        getContextManager());
                }

                {if ("" != null) return (ColumnReference) nodeFactory.getNode(
                                                                C_NodeTypes.COLUMN_REFERENCE,
                                                                columnName,
                                                                tabName,
// GemStone changes BEGIN
                                                                // changed to use Integer.valueOf()
                                                                Integer.valueOf(lastIdentifierToken.beginOffset),
                                                                Integer.valueOf(lastIdentifierToken.endOffset),
// GemStone changes END
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
void
columnReference() throws StandardException :
{}
{
	/*
	**
	** I re-wrote the above rule because it caused a grammar ambiguitity.
	** The problem is that we are parsing a dot-separated list of identifiers,
	** and the grammar doesn't know what the identifiers stand for, but the
	** syntax assumed that it did.  For example, in schema.table.column,
	** the grammar doesn't know when it parses the first identifier whether
	** it will be a catalog name, schema name, table name, or column name.
	**
	** I think this problem could be solved by increasing the lookahead.
	** I will try that solution next.  I like that solution better because,
	** if it works, it will be easier for the grammar to figure out what
	** each identifier stands for.
	**

	[ <MODULE> <PERIOD> <IDENTIFIER> |
	  [ [ [ <IDENTIFIER> <PERIOD> ] <IDENTIFIER> <PERIOD> ] <IDENTIFIER> <PERIOD> ]
	]
	<IDENTIFIER>
}
*/
  final public 
OrderByList orderByClause() throws ParseException, StandardException {OrderByList orderCols;
    jj_consume_token(ORDER);
    jj_consume_token(BY);
    orderCols = sortSpecificationList();
{if ("" != null) return orderCols;}
    throw new Error("Missing return statement in function");
  }

  final public int atIsolationLevel() throws ParseException, StandardException {int isolationLevel;
    jj_consume_token(WITH);
    isolationLevel = isolationLevelDB2Abbrev();
{if ("" != null) return isolationLevel;}
    throw new Error("Missing return statement in function");
  }

  final public OrderByList sortSpecificationList() throws ParseException, StandardException {OrderByList orderCols = (OrderByList) nodeFactory.getNode(
                                                                                        C_NodeTypes.ORDER_BY_LIST,
                                                                                        getContextManager());
    sortSpecification(orderCols);
    label_20:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[172] = jj_gen;
        break label_20;
      }
      jj_consume_token(COMMA);
      sortSpecification(orderCols);
    }
{if ("" != null) return orderCols;}
    throw new Error("Missing return statement in function");
  }

  final public void sortSpecification(OrderByList orderCols) throws ParseException, StandardException {OrderByColumn orderCol;
    orderCol = sortKey();
    switch (jj_nt.kind) {
    case ASC:
    case DESC:{
      orderingSpecification(orderCol);
      break;
      }
    default:
      jj_la1[173] = jj_gen;
      ;
    }
    if (jj_2_49(1)) {
      nullOrdering(orderCol);
    } else {
      ;
    }
orderCols.addOrderByColumn(orderCol);
  }

  final public OrderByColumn sortKey() throws ParseException, StandardException {ValueNode columnExpression;
boolean existing = getCompilerContext().switchOptimizeLiteral(false);
    // GemStone changes END
            columnExpression = additiveExpression(null,0,true);
// GemStone changes BEGIN
    getCompilerContext().switchOptimizeLiteral(existing);
    // GemStone changes END
                {if ("" != null) return (OrderByColumn) nodeFactory.getNode(
                                                                C_NodeTypes.ORDER_BY_COLUMN,
                                                                columnExpression,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public void orderingSpecification(OrderByColumn orderCol) throws ParseException {
    switch (jj_nt.kind) {
    case ASC:{
      jj_consume_token(ASC);
      break;
      }
    case DESC:{
      jj_consume_token(DESC);
orderCol.setDescending();
      break;
      }
    default:
      jj_la1[174] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * The data type comparison functions need to know whether NULL values
 * should sort higher than non-NULL values, or lower. The answer to this
 * depends on whether the user specified ASCending or DESCending, and on
 * whether the user specified NULLS FIRST, or NULLS LAST, as follows:
 *
 * +===============+========+========+
 * | ORDER BY says | ASC    | DESC   |
 * +===============+========+========+
 * | NULLS FIRST   | less   | greater|
 * +===============+========+========+
 * | NULLS LAST    | greater| less   |
 * +===============+========+========+
 */
  final public void nullOrdering(OrderByColumn orderCol) throws ParseException {
    if (getToken(2).kind == LAST) {
      jj_consume_token(NULLS);
      jj_consume_token(LAST);
if (! orderCol.isAscending())
                orderCol.setNullsOrderedLow();
    } else {
      switch (jj_nt.kind) {
      case NULLS:{
        jj_consume_token(NULLS);
        jj_consume_token(FIRST);
if (orderCol.isAscending())
                orderCol.setNullsOrderedLow();
        break;
        }
      default:
        jj_la1[175] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/*
 * <A NAME="offsetClause">offsetClause</A>
 */
  final public ValueNode offsetClause() throws ParseException, StandardException {ValueNode result = null;
    jj_consume_token(OFFSET);
    switch (jj_nt.kind) {
    case PLUS_SIGN:
    case MINUS_SIGN:
    case EXACT_NUMERIC:{
      result = intLiteral();
      break;
      }
    case QUESTION_MARK:{
      result = dynamicParameterSpecification();
      break;
      }
    default:
      jj_la1[176] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_nt.kind) {
    case ROW:{
      jj_consume_token(ROW);
      break;
      }
    case ROWS:{
      jj_consume_token(ROWS);
      break;
      }
    default:
      jj_la1[177] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return result;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="fetchFirstClause">fetchFirstClause</A>
 */
  final public ValueNode fetchFirstClause() throws ParseException, StandardException {// The default number of rows to fetch if the literal is omitted is 1:
    ValueNode result = getNumericNode("1", true);
    jj_consume_token(FETCH);
    switch (jj_nt.kind) {
    case FIRST:{
      jj_consume_token(FIRST);
      break;
      }
    case NEXT:{
      jj_consume_token(NEXT);
      break;
      }
    default:
      jj_la1[178] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_nt.kind) {
    case PLUS_SIGN:
    case MINUS_SIGN:
    case QUESTION_MARK:
    case EXACT_NUMERIC:{
      switch (jj_nt.kind) {
      case PLUS_SIGN:
      case MINUS_SIGN:
      case EXACT_NUMERIC:{
boolean existing = getCompilerContext().switchOptimizeLiteral(false);
        result = intLiteral();
getCompilerContext().switchOptimizeLiteral(existing);
        break;
        }
      case QUESTION_MARK:{
        result = dynamicParameterSpecification();
        break;
        }
      default:
        jj_la1[179] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[180] = jj_gen;
      ;
    }
    switch (jj_nt.kind) {
    case ROW:{
      jj_consume_token(ROW);
      break;
      }
    case ROWS:{
      jj_consume_token(ROWS);
      break;
      }
    default:
      jj_la1[181] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ONLY);
{if ("" != null) return result;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="forUpdateClause">forUpdateClause</A>
 */
  final public int forUpdateClause(Vector columnList) throws ParseException, StandardException {int     retval;
    switch (jj_nt.kind) {
    case UPDATE:{
      jj_consume_token(UPDATE);
      switch (jj_nt.kind) {
      case OF:{
        jj_consume_token(OF);
        forUpdateColumnList(columnList);
        break;
        }
      default:
        jj_la1[182] = jj_gen;
        ;
      }
{if ("" != null) return CursorNode.UPDATE;}
      break;
      }
    case READ:{
      jj_consume_token(READ);
      jj_consume_token(ONLY);
{if ("" != null) return CursorNode.READ_ONLY;}
      break;
      }
    case FETCH:{
      jj_consume_token(FETCH);
      jj_consume_token(ONLY);
{if ("" != null) return CursorNode.READ_ONLY;}
      break;
      }
    default:
      jj_la1[183] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="forUpdateColumnList">forUpdateColumnList</A>
 */
  final public void forUpdateColumnList(Vector columnList) throws ParseException, StandardException {
    forUpdateColumn(columnList);
    label_21:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[184] = jj_gen;
        break label_21;
      }
      jj_consume_token(COMMA);
      forUpdateColumn(columnList);
    }
  }

/*
 * <A NAME="forUpdateColumn">forUpdateColumn</A>
 */
  final public void forUpdateColumn(Vector columnList) throws ParseException, StandardException {String           columnName;
    /* identifier() used to be columnName() */
            columnName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
columnList.addElement(columnName);
  }

/*
 * <A NAME="setClauseList">setClauseList</A>
 */
  final public ResultColumnList setClauseList() throws ParseException, StandardException {ResultColumnList        columnList = (ResultColumnList) nodeFactory.getNode(
                                                                                                C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                                getContextManager());
    setClause(columnList);
    label_22:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[185] = jj_gen;
        break label_22;
      }
      jj_consume_token(COMMA);
      setClause(columnList);
    }
{if ("" != null) return columnList;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="setClause">setClause</A>
 */
  final public void setClause(ResultColumnList columnList) throws ParseException, StandardException {ResultColumn resultColumn;
        ColumnReference  columnName;
        ValueNode        valueNode;
    /* identifier() used to be objectColumn() */
            /*
    		SQL92 only wants identifiers here (column names)
    		but JBuilder expects table.column, so we allow the
    		general form.
    	 */
            columnName = columnReference();
    jj_consume_token(EQUALS_OPERATOR);
    valueNode = updateSource(columnName.getColumnName());
resultColumn = (ResultColumn) nodeFactory.getNode(
                                                                                C_NodeTypes.RESULT_COLUMN,
                                                                                columnName,
                                                                                valueNode,
                                                                                getContextManager());
                columnList.addResultColumn(resultColumn);
  }

/*
 * <A NAME="updateSource">updateSource</A>
 */
  final public ValueNode updateSource(String columnName) throws ParseException, StandardException {ValueNode       valueNode;
    if (jj_2_50(1)) {
      valueNode = additiveExpression(null,0, false);
{if ("" != null) return valueNode;}
    } else {
      switch (jj_nt.kind) {
      case NULL:{
        valueNode = nullSpecification();
{if ("" != null) return valueNode;}
        break;
        }
      case _DEFAULT:{
        jj_consume_token(_DEFAULT);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.DEFAULT_NODE,
                                                                columnName,
                                                                getContextManager());}
        break;
        }
      default:
        jj_la1[186] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="nullSpecification">nullSpecification</A>
 */
  final public ValueNode nullSpecification() throws ParseException, StandardException {
    jj_consume_token(NULL);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.UNTYPED_NULL_CONSTANT_NODE,
                                                                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

// Gemstone Changes BEGIN
/*
 * <A NAME="specificationForRange">specificationForRange</A>
 */
  final public ValueNode specificationForRange() throws ParseException, StandardException {ValueNode node;
    if (getToken(1).kind == INFINITY || getToken(2).kind == INFINITY) {
      switch (jj_nt.kind) {
      case INFINITY:
      case PLUS_SIGN:{
        switch (jj_nt.kind) {
        case PLUS_SIGN:{
          jj_consume_token(PLUS_SIGN);
          break;
          }
        default:
          jj_la1[187] = jj_gen;
          ;
        }
        jj_consume_token(INFINITY);
        break;
        }
      case MINUS_SIGN:{
        jj_consume_token(MINUS_SIGN);
        jj_consume_token(INFINITY);
        break;
        }
      default:
        jj_la1[188] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return null;}
    } else if (jj_2_51(1)) {
      node = additiveExpression(null, 0, false);
{if ("" != null) return node;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// Gemstone Changes END

/*
 * <A NAME="insertColumnsAndSource">insertColumnsAndSource</A>
 */
  final public StatementNode insertColumnsAndSource(QueryTreeNode targetTable, boolean isPutDML) throws ParseException, StandardException {Properties                      targetProperties = null;
        ResultSetNode   queryExpression;
        ResultColumnList        columnList = null;
    if (getToken(1).kind == LEFT_PAREN && ! subqueryFollows()) {
      jj_consume_token(LEFT_PAREN);
      columnList = insertColumnList();
      jj_consume_token(RIGHT_PAREN);
    } else {
      ;
    }
    switch (jj_nt.kind) {
    case GEMFIREXDDASHPROPERTIES:{
      targetProperties = propertyList(false);
      jj_consume_token(CHECK_PROPERTIES);
      break;
      }
    default:
      jj_la1[189] = jj_gen;
      ;
    }
    queryExpression = queryExpression(null, NO_SET_OP);
{if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                        C_NodeTypes.INSERT_NODE,
                                                        targetTable,
                                                        columnList,
                                                        queryExpression,
                                                        targetProperties,
                                                        isPutDML,
                                                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="insertColumnList">insertColumnList</A>
 */
  final public ResultColumnList insertColumnList() throws ParseException, StandardException {ResultColumnList        columnList = (ResultColumnList) nodeFactory.getNode(
                                                                                                C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                                getContextManager());
    columnQualifiedNameList(columnList);
{if ("" != null) return columnList;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="columnQualifiedNameList">columnQualifiedNameList</A>
 */
  final public void columnQualifiedNameList(ResultColumnList columnList) throws ParseException, StandardException {
    columnQualifiedNameItem(columnList);
    label_23:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[190] = jj_gen;
        break label_23;
      }
      jj_consume_token(COMMA);
      columnQualifiedNameItem(columnList);
    }
  }

/*
 * <A NAME="columnQualifiedNameItem">columnQualifiedNameItem</A>
 */
  final public void columnQualifiedNameItem(ResultColumnList columnList) throws ParseException, StandardException {ColumnReference         columnRef;
        ResultColumn    resultColumn;
    /*
    		SQL92 only wants identifiers here (column names)
    		but JBuilder expects table.column, so we allow the
    		general form.
    	 */
            columnRef = columnReference();
/*
		** Store the column names for the result columns in the
		** result column list.  We don't know yet what valueNodes
		** should be hooked up to each result column, so set that
		** to null for now.
		*/
                resultColumn = (ResultColumn) nodeFactory.getNode(
                                                                                C_NodeTypes.RESULT_COLUMN,
                                                                                columnRef,
                                                                                null,
                                                                                getContextManager());
                columnList.addResultColumn(resultColumn);
  }

/*
 * <A NAME="rowValueConstructor">rowValueConstructor</A>
 */
  final public ResultSetNode rowValueConstructor(ResultSetNode leftRSN) throws ParseException, StandardException {ResultColumnList        resultColumns = (ResultColumnList) nodeFactory.getNode(
                                                                                                C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                                getContextManager());
        ResultSetNode           newRSN;
    if (rowValueConstructorListFollows()) {
      jj_consume_token(LEFT_PAREN);
      rowValueConstructorList(resultColumns);
      jj_consume_token(RIGHT_PAREN);
/* If leftRSN is null, simply return the newRSN, else generate and
		 * return a UNION ALL above the 2 RSNs, after verifying that the size()
		 * of both RSNs RCLs is the same.
		 */
                newRSN = (ResultSetNode) nodeFactory.getNode(
                                                                C_NodeTypes.ROW_RESULT_SET_NODE,
                                                                resultColumns,
                                                                null,
                                                                getContextManager());
                if (leftRSN != null)
                {
                        if (leftRSN.getResultColumns().size() !=
                                newRSN.getResultColumns().size())
                        {
                                {if (true) throw StandardException.newException(SQLState.LANG_ROW_VALUE_CONSTRUCTOR_UNMATCHED_COLUMNS);}
                        }

                        newRSN = (ResultSetNode) nodeFactory.getNode(
                                                                        C_NodeTypes.UNION_NODE,
                                                                        leftRSN,
                                                                        newRSN,
                                                                        Boolean.TRUE,
                                                                        Boolean.TRUE,
                                                                        null,
                                                                        getContextManager());
                }
                {if ("" != null) return newRSN;}
    } else {
      rowValueConstructorElement(resultColumns);
/* If leftRSN is null, simply return the newRSN, else generate and
		 * return a UNION ALL above the 2 RSNs, after verifying that the size()
		 * of both RSNs RCLs is the same.
		 */
                newRSN = (ResultSetNode) nodeFactory.getNode(
                                                                C_NodeTypes.ROW_RESULT_SET_NODE,
                                                                resultColumns,
                                                                null,
                                                                getContextManager());
                if (leftRSN != null)
                {
                        if (leftRSN.getResultColumns().size() !=
                                newRSN.getResultColumns().size())
                        {
                                {if (true) throw StandardException.newException(SQLState.LANG_ROW_VALUE_CONSTRUCTOR_UNMATCHED_COLUMNS);}
                        }

                        newRSN = (ResultSetNode) nodeFactory.getNode(
                                                                        C_NodeTypes.UNION_NODE,
                                                                        leftRSN,
                                                                        newRSN,
                                                                        Boolean.TRUE,
                                                                        Boolean.TRUE,
                                                                        null,
                                                                        getContextManager());
                }
                {if ("" != null) return newRSN;}
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="rowValueConstructorElement">rowValueConstructorElement</A>
 */
  final public void rowValueConstructorElement(ResultColumnList resultColumns) throws ParseException, StandardException {ValueNode       value;
    if (jj_2_52(1)) {
      value = additiveExpression(null, 0, true);
resultColumns.addResultColumn(
                        (ResultColumn) nodeFactory.getNode(
                                                        C_NodeTypes.RESULT_COLUMN,
                                                        null,
                                                        value,
                                                        getContextManager())
                                );
    } else {
      switch (jj_nt.kind) {
      case NULL:{
        value = nullSpecification();
resultColumns.addResultColumn(
                        (ResultColumn) nodeFactory.getNode(
                                                        C_NodeTypes.RESULT_COLUMN,
                                                        null,
                                                        value,
                                                        getContextManager())
                                );
        break;
        }
      case _DEFAULT:{
        jj_consume_token(_DEFAULT);
resultColumns.addResultColumn(
                        (ResultColumn) nodeFactory.getNode(
                                                        C_NodeTypes.RESULT_COLUMN,
                                                        null,
                                                        (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.DEFAULT_NODE,
                                                                null,
                                                                getContextManager()),
                                                        getContextManager())
                                );
        break;
        }
      default:
        jj_la1[191] = jj_gen;
{if (true) throw StandardException.newException(SQLState.LANG_EMPTY_VALUES_CLAUSE);}
      }
    }
  }

/*
 * <A NAME="rowValueConstructorList">rowValueConstructorList</A>
 */
  final public void rowValueConstructorList(ResultColumnList resultColumns) throws ParseException, StandardException {
    rowValueConstructorElement(resultColumns);
    label_24:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[192] = jj_gen;
        break label_24;
      }
      jj_consume_token(COMMA);
      rowValueConstructorElement(resultColumns);
    }
  }

/*
 * <A NAME="tableSubquery">tableSubquery</A>
 */
  final public SubqueryNode tableSubquery(int subqueryType, ValueNode leftOperand) throws ParseException, StandardException {SubqueryNode    subqueryNode;
    subqueryNode = subquery(subqueryType, leftOperand);
{if ("" != null) return subqueryNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="subquery">subquery</A>
 */
  final public SubqueryNode subquery(int subqueryType, ValueNode leftOperand) throws ParseException, StandardException {ResultSetNode   queryExpression;
        SubqueryNode    subqueryNode;
         // GemStone changes BEGIN
    ValueNode offset = null;
    ValueNode fetchFirst = null;

          int startIndex = token.endOffset+1;
          if(this.subqueryParamCount == null)
          {
                CompilerContext cc = getCompilerContext();
            this.subqueryParamCount = new ArrayDeque<List<Integer>>();
            this.subqueryParams= new ArrayDeque<List<ConstantNode>>();

          }
          this.subqueryParamCount.push(new ArrayList<Integer>(5));
          this.subqueryParams.push(new ArrayList<ConstantNode>(5));

         // GemStone changes END

    queryExpression = queryExpression(null, NO_SET_OP);
if(queryExpression instanceof SelectNode)
       {
          ((SelectNode)queryExpression).setParentSubQueryNodeFlag();

       }
    switch (jj_nt.kind) {
    case OFFSET:{
      offset = offsetClause();
      break;
      }
    default:
      jj_la1[193] = jj_gen;
      ;
    }
    switch (jj_nt.kind) {
    case FETCH:{
      fetchFirst = fetchFirstClause();
      break;
      }
    default:
      jj_la1[194] = jj_gen;
      ;
    }
// GemStone changes BEGIN
                int endIndex = this.token.endOffset+1;
                CompilerContext cc = getCompilerContext();
                List<Integer > params = this.subqueryParamCount.pop();
                List<ConstantNode> paramsIndex = this.subqueryParams != null? this.subqueryParams.pop():null;
          // GemStone changes END      
                subqueryNode = (SubqueryNode) nodeFactory.getNode(
                                                                                C_NodeTypes.SUBQUERY_NODE,
                                                                                queryExpression,
                                                                                offset,
                                                                                fetchFirst,
                                                                                ReuseFactory.getInteger(subqueryType),
                                                                                leftOperand,
                                                                                getContextManager());
        // GemStone changes BEGIN
            String subqueryTxt = statementSQLText.substring(startIndex, endIndex);

            int adjustment = startIndex;
            if(paramsIndex != null) {
            StringBuilder builder = new StringBuilder(subqueryTxt);
              for(ConstantNode cn:paramsIndex) {
                 int begin = cn.getBeginOffset() - adjustment;
                 int end = cn.getEndOffset()-adjustment;
                 builder.replace(begin,end,"<?>");
                 adjustment += end-begin -"<?>".length();

              }
              subqueryTxt = builder.toString();
            }
                subqueryNode.setSubqueryString(subqueryTxt);

                subqueryNode.setGfxdSubactivationFlag( this.gfxdSubactivationNeeded);
                subqueryNode.setParams( params);
                subqueryNode.setIsPreparedStatement(cc.isPreparedStatement());
                subqueryNode.setIsOptimizeLiteralAllowed(cc.isOptimizeLiteralAllowed());
        // GemStone changes END
                {if ("" != null) return subqueryNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="inPredicateValue">inPredicateValue</A>
 */
  final public ValueNode inPredicateValue(ValueNode leftOperand) throws ParseException, StandardException {ValueNode               retval;
        int                             tokKind;
    switch (jj_nt.kind) {
    case ARRAY:{
      jj_consume_token(ARRAY);
      retval = inArrayPredicateValue(leftOperand);
{if ("" != null) return retval;}
      break;
      }
    case LEFT_PAREN:{
      jj_consume_token(LEFT_PAREN);
      if (subqueryFollows()) {
        retval = tableSubquery(SubqueryNode.IN_SUBQUERY, leftOperand);
      } else if (jj_2_53(1)) {
        retval = inValueList(leftOperand);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(RIGHT_PAREN);
{if ("" != null) return retval;}
      break;
      }
    default:
      jj_la1[195] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="inArrayPredicateValue">inArrayPredicateValue</A>
 */
  final public ValueNode inArrayPredicateValue(ValueNode leftOperand) throws ParseException, StandardException {ValueNode               retval;
        int                             tokKind;
    jj_consume_token(LEFT_PAREN);
    retval = inSingleArrayValue(leftOperand);
    jj_consume_token(RIGHT_PAREN);
{if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="inValueList">inValueList</A>
 */
  final public ValueNode inValueList(ValueNode leftOperand) throws ParseException, StandardException {ValueNodeList   inList = (ValueNodeList) nodeFactory.getNode(
                                                                                        C_NodeTypes.VALUE_NODE_LIST,
                                                                                        getContextManager());
    inElement(inList);
    label_25:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[196] = jj_gen;
        break label_25;
      }
      jj_consume_token(COMMA);
      inElement(inList);
    }
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.IN_LIST_OPERATOR_NODE,
                                                                leftOperand,
                                                                inList,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="inSingleArrayValue">inSingleArrayValue</A>
 */
  final public ValueNode inSingleArrayValue(ValueNode leftOperand) throws ParseException, StandardException {ValueNodeList   inList = (ValueNodeList) nodeFactory.getNode(
                                                                                        C_NodeTypes.VALUE_NODE_LIST,
                                                                                        getContextManager());
    inElement(inList);
InListOperatorNode inListNode = (InListOperatorNode) nodeFactory.getNode(
                                                                C_NodeTypes.IN_LIST_OPERATOR_NODE,
                                                                leftOperand,
                                                                inList,
                                                                getContextManager());
                inListNode.setRightOperandArray();
                {if ("" != null) return (ValueNode)inListNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="inElement">inElement</A>
 */
  final public void inElement(ValueNodeList inList) throws ParseException, StandardException {ValueNode valueNode;
    valueNode = additiveExpression(null, 0, false);
inList.addElement(valueNode);
  }

/*
 * <A NAME="quantifier">quantifier</A>
 */
  final public int quantifier(int opType) throws ParseException, StandardException {int retval = 0;
    switch (jj_nt.kind) {
    case ALL:{
      jj_consume_token(ALL);
switch (opType)
                {
                        case BinaryOperatorNode.EQ:
                                retval = SubqueryNode.EQ_ALL_SUBQUERY;
                                break;

                        case BinaryOperatorNode.NE:
                                retval = SubqueryNode.NE_ALL_SUBQUERY;
                                break;

                        case BinaryOperatorNode.LE:
                                retval = SubqueryNode.LE_ALL_SUBQUERY;
                                break;

                        case BinaryOperatorNode.LT:
                                retval = SubqueryNode.LT_ALL_SUBQUERY;
                                break;

                        case BinaryOperatorNode.GE:
                                retval = SubqueryNode.GE_ALL_SUBQUERY;
                                break;

                        case BinaryOperatorNode.GT:
                                retval = SubqueryNode.GT_ALL_SUBQUERY;
                                break;

                        default:
                                if (SanityManager.DEBUG)
                                SanityManager.THROWASSERT(
                                                "Invalid value for opType (" + opType +
                                                ") passed to quantifier()");
                }
                {if ("" != null) return retval;}
      break;
      }
    case ANY:
    case SOME:{
      some();
switch (opType)
                {
                        case BinaryOperatorNode.EQ:
                                retval = SubqueryNode.EQ_ANY_SUBQUERY;
                                break;

                        case BinaryOperatorNode.NE:
                                retval = SubqueryNode.NE_ANY_SUBQUERY;
                                break;

                        case BinaryOperatorNode.LE:
                                retval = SubqueryNode.LE_ANY_SUBQUERY;
                                break;

                        case BinaryOperatorNode.LT:
                                retval = SubqueryNode.LT_ANY_SUBQUERY;
                                break;

                        case BinaryOperatorNode.GE:
                                retval = SubqueryNode.GE_ANY_SUBQUERY;
                                break;

                        case BinaryOperatorNode.GT:
                                retval = SubqueryNode.GT_ANY_SUBQUERY;
                                break;

                        default:
                                if (SanityManager.DEBUG)
                                SanityManager.THROWASSERT(
                                                "Invalid value for opType (" + opType +
                                                ") passed to quantifier()");
                }
                {if ("" != null) return retval;}
      break;
      }
    default:
      jj_la1[197] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="some">some</A>
 */
  final public void some() throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case SOME:{
      jj_consume_token(SOME);
      break;
      }
    case ANY:{
      jj_consume_token(ANY);
      break;
      }
    default:
      jj_la1[198] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * <A NAME="existsExpression">existsExpression</A>
 */
  final public SubqueryNode existsExpression() throws ParseException, StandardException {SubqueryNode    subqueryNode;
    jj_consume_token(EXISTS);
    jj_consume_token(LEFT_PAREN);
    subqueryNode = tableSubquery(SubqueryNode.EXISTS_SUBQUERY, null);
    jj_consume_token(RIGHT_PAREN);
{if ("" != null) return subqueryNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="tableExpression">tableExpression</A>
 */
  final public SelectNode tableExpression(ResultColumnList selectList) throws ParseException, StandardException {SelectNode      selectNode;
        FromList        fromList;
        ValueNode       whereClause = null;
        GroupByList     groupByList = null;
        ValueNode       havingClause = null;
        Token           whereToken;
    fromList = fromClause();
    switch (jj_nt.kind) {
    case WHERE:{
      whereToken = jj_consume_token(WHERE);
      whereClause = whereClause(whereToken);
      break;
      }
    default:
      jj_la1[199] = jj_gen;
      ;
    }
    switch (jj_nt.kind) {
    case GROUP:{
      groupByList = groupByClause();
      break;
      }
    default:
      jj_la1[200] = jj_gen;
      ;
    }
    switch (jj_nt.kind) {
    case HAVING:{
      havingClause = havingClause();
      break;
      }
    default:
      jj_la1[201] = jj_gen;
      ;
    }
// fix for HAVING without GROUP BY, makes sure we get one
                // aggregate operator by adding a count(*), this fixes beetle 5853, 5890
                if (havingClause != null && groupByList == null) {
                        ValueNode vn = (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.AGGREGATE_NODE,
                                                                null,
                                                                com.pivotal.gemfirexd.internal.impl.sql.compile.CountAggregateDefinition.class,
                                                                Boolean.FALSE, // distinct Boolean.TRUE?
                Boolean.TRUE,
                                                                Boolean.FALSE,
                                                                "COUNT(*)",
                                                                getContextManager());
                        AggregateNode n = (AggregateNode) vn;
                        n.replaceAggregatesWithColumnReferences(selectList, 0);
                }

                selectNode = (SelectNode) nodeFactory.getNode(
                                                        C_NodeTypes.SELECT_NODE,
                                                        selectList,
                                                        null,           /* AGGREGATE list */
                                                        fromList,
                                                        whereClause,
                                                        groupByList,
                                                        havingClause,
                            Boolean.valueOf(false), /* Dml op */
                                                        getContextManager());

                {if ("" != null) return selectNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="fromClause">fromClause</A>
 */
  final public FromList fromClause() throws ParseException, StandardException {FromList fromList = (FromList) nodeFactory.getNode(
                                                                        C_NodeTypes.FROM_LIST,
                                                                        getNodeFactory().doJoinOrderOptimization(),
                                                                        getContextManager());
        int     tokKind;
        Token   beginToken;
        Token   endToken;
    jj_consume_token(FROM);
beginToken = getToken(1);
    switch (jj_nt.kind) {
    case GEMFIREXDDASHPROPERTIES:{
      fromListProperties(fromList);
      break;
      }
    default:
      jj_la1[202] = jj_gen;
      ;
    }
    dummyTableReferenceRule(fromList);
    label_26:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[203] = jj_gen;
        break label_26;
      }
      jj_consume_token(COMMA);
      dummyTableReferenceRule(fromList);
    }
endToken = getToken(0);
fromList.setBeginOffset( beginToken.beginOffset);
                fromList.setEndOffset( endToken.endOffset);
                {if ("" != null) return fromList;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="fromListProperties">fromListProperties</A>
 */
  final public void fromListProperties(FromList fromList) throws ParseException, StandardException {Properties properties;
    properties = propertyList(true);
    jj_consume_token(CHECK_PROPERTIES);
fromList.setProperties(properties);
  }

/* This rule created simply as a way to add the result of tableReference()
 * to the fromList.
 */
  final public void dummyTableReferenceRule(FromList fromList) throws ParseException, StandardException {FromTable tableReference;
    if (getToken(1).kind == TABLE &&
                                    getToken(2).kind == LEFT_PAREN &&
                                    (
                                            getToken(3).kind == SELECT ||
                                            getToken(3).kind == VALUES
                                    )) {
      jj_consume_token(TABLE);
      tableReference = tableReferenceTypes(false);
fromList.addFromTable(tableReference);
    } else if (jj_2_54(1)) {
      tableReference = tableReferenceTypes(false);
fromList.addFromTable(tableReference);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public FromTable tableReferenceTypes(boolean nestedInParens) throws ParseException, StandardException {FromTable tableReference;
    if (jj_2_55(1)) {
      tableReference = tableReference(nestedInParens);
{if ("" != null) return tableReference ;}
    } else {
      switch (jj_nt.kind) {
      case LEFT_BRACE:{
        jj_consume_token(LEFT_BRACE);
        jj_consume_token(OJ);
        tableReference = tableReference(nestedInParens);
        jj_consume_token(RIGHT_BRACE);
{if ("" != null) return tableReference;}
        break;
        }
      default:
        jj_la1[204] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public Object[] optionalTableClauses() throws ParseException, StandardException {Object[]                         otc = null;
        Properties                      tableProperties = null;
        ResultColumnList        derivedRCL = null;
        String                          correlationName = null;
    switch (jj_nt.kind) {
    case GEMFIREXDDASHPROPERTIES:{
      otc = optionalTableProperties();
otc[OPTIONAL_TABLE_CLAUSES_DERIVED_RCL] = derivedRCL;
                otc[OPTIONAL_TABLE_CLAUSES_CORRELATION_NAME] = correlationName;
                {if ("" != null) return otc;}
      break;
      }
    default:
      jj_la1[208] = jj_gen;
      if (jj_2_56(1)) {
        switch (jj_nt.kind) {
        case AS:{
          jj_consume_token(AS);
          break;
          }
        default:
          jj_la1[205] = jj_gen;
          ;
        }
        correlationName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
        switch (jj_nt.kind) {
        case LEFT_PAREN:{
          jj_consume_token(LEFT_PAREN);
          derivedRCL = derivedColumnList();
          jj_consume_token(RIGHT_PAREN);
          break;
          }
        default:
          jj_la1[206] = jj_gen;
          ;
        }
        switch (jj_nt.kind) {
        case GEMFIREXDDASHPROPERTIES:{
          tableProperties = propertyList(true);
          jj_consume_token(CHECK_PROPERTIES);
          break;
          }
        default:
          jj_la1[207] = jj_gen;
          ;
        }
      } else {
        ;
      }
otc = new Object[OPTIONAL_TABLE_CLAUSES_SIZE];
                otc[OPTIONAL_TABLE_CLAUSES_TABLE_PROPERTIES] = tableProperties;
                otc[OPTIONAL_TABLE_CLAUSES_DERIVED_RCL] = derivedRCL;
                otc[OPTIONAL_TABLE_CLAUSES_CORRELATION_NAME] = correlationName;
                {if ("" != null) return otc;}
    }
    throw new Error("Missing return statement in function");
  }

  final public Object[] optionalTableProperties() throws ParseException, StandardException {Object[]                        otc = null;
        Properties                      tableProperties = null;
    tableProperties = propertyList(true);
    jj_consume_token(CHECK_PROPERTIES);
otc = new Object[OPTIONAL_TABLE_CLAUSES_SIZE];
                otc[OPTIONAL_TABLE_CLAUSES_TABLE_PROPERTIES] = tableProperties;
                {if ("" != null) return otc;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="tableReference">tableReference</A>
 */
  final public FromTable tableReference(boolean nestedInParens) throws ParseException, StandardException {JavaToSQLValueNode      javaToSQLNode = null;
        TableName                       tableName;
        String                          correlationName = null;
        ResultColumnList        derivedRCL = null;
        FromTable                       fromTable;
        TableOperatorNode       joinTable = null;
        FromTable                       tableReference;
        Object[]                        optionalTableClauses = new Object[OPTIONAL_TABLE_CLAUSES_SIZE];
        Properties                      tableProperties = null;
        ResultSetNode           derivedTable;
    if (jj_2_57(1)) {
      if (newInvocationFollows(1)) {
        javaToSQLNode = newInvocation();
      } else {
        switch (jj_nt.kind) {
        case TABLE:{
          javaToSQLNode = vtiTableConstruct();
          break;
          }
        default:
          jj_la1[209] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch (jj_nt.kind) {
      case AS:{
        jj_consume_token(AS);
        break;
        }
      default:
        jj_la1[210] = jj_gen;
        ;
      }
      correlationName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
      switch (jj_nt.kind) {
      case LEFT_PAREN:{
        jj_consume_token(LEFT_PAREN);
        derivedRCL = derivedColumnList();
        jj_consume_token(RIGHT_PAREN);
        break;
        }
      default:
        jj_la1[211] = jj_gen;
        ;
      }
      switch (jj_nt.kind) {
      case GEMFIREXDDASHPROPERTIES:{
        optionalTableClauses = optionalTableProperties();
        break;
        }
      default:
        jj_la1[212] = jj_gen;
        ;
      }
      label_27:
      while (true) {
        if (joinedTableExpressionFollows()) {
          ;
        } else {
          break label_27;
        }
        joinTable = joinedTableExpression((joinTable != null) ?
                                                                                        joinTable :
                                                                                        (FromTable) nodeFactory.getNode(
                                                                                                C_NodeTypes.FROM_VTI,
                                                                                                javaToSQLNode.getJavaValueNode(),
                                                                                                correlationName,
                                                                                                derivedRCL,
                                                                                                ((optionalTableClauses != null) ?
                                                                                                        (Properties) optionalTableClauses[OPTIONAL_TABLE_CLAUSES_TABLE_PROPERTIES] :
                                                                                                        (Properties) null),
                                                                                                getContextManager()),
                                                                                nestedInParens);
      }
/* Build a derived table if not a join expression */
                if (joinTable == null)
                {
                        fromTable = (FromTable) nodeFactory.getNode(
                                                                C_NodeTypes.FROM_VTI,
                                                                javaToSQLNode.getJavaValueNode(),
                                                                correlationName,
                                                                derivedRCL,
                                                                ((optionalTableClauses != null) ?
                                                                        (Properties) optionalTableClauses[OPTIONAL_TABLE_CLAUSES_TABLE_PROPERTIES] :
                                                                        (Properties) null),
                                                                getContextManager());
                }
                else
                {
                        fromTable = joinTable;
                }

                {if ("" != null) return fromTable;}
    } else if (jj_2_58(1)) {
      /* identifier() used to be correlationName() */
              tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
      optionalTableClauses = optionalTableClauses();
      label_28:
      while (true) {
        if (joinedTableExpressionFollows()) {
          ;
        } else {
          break label_28;
        }
        joinTable = joinedTableExpression((joinTable != null) ?
                                                                                        joinTable :
                                                                                        (FromTable) nodeFactory.getNode(
                                                                                                        C_NodeTypes.FROM_BASE_TABLE,
                                                                                                        tableName,
                                                                                                        (String) optionalTableClauses[OPTIONAL_TABLE_CLAUSES_CORRELATION_NAME],
                                                                                                        (ResultColumnList) optionalTableClauses[OPTIONAL_TABLE_CLAUSES_DERIVED_RCL],
                                                                                                        (Properties) optionalTableClauses[OPTIONAL_TABLE_CLAUSES_TABLE_PROPERTIES],
                                                                                                        getContextManager()),
                                                                                nestedInParens);
      }
/* Build a from table if not a join expression */
                if (joinTable == null)
                {
                        fromTable = (FromTable) nodeFactory.getNode(
                                                                                        C_NodeTypes.FROM_BASE_TABLE,
                                                                                        tableName,
                                                                                                (String) optionalTableClauses[OPTIONAL_TABLE_CLAUSES_CORRELATION_NAME],
                                                                                                (ResultColumnList) optionalTableClauses[OPTIONAL_TABLE_CLAUSES_DERIVED_RCL],
                                                                                                (Properties) optionalTableClauses[OPTIONAL_TABLE_CLAUSES_TABLE_PROPERTIES],
                                                                                        getContextManager());
                }
                else
                {
                        fromTable = joinTable;
                }
                {if ("" != null) return fromTable;}
    } else if (getToken(1).kind == LEFT_PAREN &&
                                    (
                                            getToken(2).kind == SELECT ||
                                            getToken(2).kind == VALUES
                                    )) {
      derivedTable = derivedTable();
      switch (jj_nt.kind) {
      case AS:{
        jj_consume_token(AS);
        break;
        }
      default:
        jj_la1[213] = jj_gen;
        ;
      }
      correlationName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
      switch (jj_nt.kind) {
      case LEFT_PAREN:{
        jj_consume_token(LEFT_PAREN);
        derivedRCL = derivedColumnList();
        jj_consume_token(RIGHT_PAREN);
        break;
        }
      default:
        jj_la1[214] = jj_gen;
        ;
      }
      switch (jj_nt.kind) {
      case GEMFIREXDDASHPROPERTIES:{
        optionalTableClauses = optionalTableProperties();
        break;
        }
      default:
        jj_la1[215] = jj_gen;
        ;
      }
      label_29:
      while (true) {
        if (joinedTableExpressionFollows()) {
          ;
        } else {
          break label_29;
        }
        joinTable = joinedTableExpression((joinTable != null) ?
                                                                                        joinTable :
                                                                                        (FromTable) nodeFactory.getNode(
                                                                                                                C_NodeTypes.FROM_SUBQUERY,
                                                                                                                derivedTable,
                                                                                                                correlationName,
                                                                                                                derivedRCL,
                                                                                                                ((optionalTableClauses != null) ?
                                                                                                                        (Properties) optionalTableClauses[OPTIONAL_TABLE_CLAUSES_TABLE_PROPERTIES] :
                                                                                                                        (Properties) null),
                                                                                                                getContextManager()),
                                                                                nestedInParens);
      }
/* Build a derived table if not a join expression */
                if (joinTable == null)
                {
                        fromTable = (FromTable) nodeFactory.getNode(
                                                                                        C_NodeTypes.FROM_SUBQUERY,
                                                                                        derivedTable,
                                                                                        correlationName,
                                                                                        derivedRCL,
                                                                                        ((optionalTableClauses != null) ?
                                                                                                (Properties) optionalTableClauses[OPTIONAL_TABLE_CLAUSES_TABLE_PROPERTIES] :
                                                                                                (Properties) null),
                                                                                        getContextManager());
                }
                else
                {
                        fromTable = joinTable;
                }

                {if ("" != null) return fromTable;}
    } else {
      switch (jj_nt.kind) {
      case LEFT_PAREN:{
        jj_consume_token(LEFT_PAREN);
        tableReference = tableReferenceTypes(true);
        jj_consume_token(RIGHT_PAREN);
        label_30:
        while (true) {
          if (joinedTableExpressionFollows()) {
            ;
          } else {
            break label_30;
          }
          joinTable = joinedTableExpression((joinTable != null) ?
                                                                                          joinTable :
                                                                                          tableReference,
                                                                                  nestedInParens);
        }
if (joinTable == null)
                {
                        fromTable = tableReference;
                }
                else
                {
                        fromTable = joinTable;
                }

                {if ("" != null) return fromTable;}
        break;
        }
      default:
        jj_la1[216] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="derivedColumnList">derivedColumnList</A>
 */
  final public ResultColumnList derivedColumnList() throws ParseException, StandardException {ResultColumnList        resultColumns =
                                                                        (ResultColumnList) nodeFactory.getNode(
                                                                                        C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                        getContextManager());
    columnNameList(resultColumns);
{if ("" != null) return resultColumns;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="columnNameList">columnNameList</A>
 */
  final public void columnNameList(ResultColumnList columnList) throws ParseException, StandardException {
    columnNameItem(columnList);
    label_31:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[217] = jj_gen;
        break label_31;
      }
      jj_consume_token(COMMA);
      columnNameItem(columnList);
    }
  }

/*
 * <A NAME="columnNameItem">columnNameItem</A>
 */
  final public void columnNameItem(ResultColumnList columnList) throws ParseException, StandardException {String          columnName;
        ResultColumn    resultColumn;
    /* identifier() used to be columnName() */
            columnName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
/*
		** Store the column names for the result columns in the
		** result column list.  We don't know yet what valueNodes
		** should be hooked up to each result column, so set that
		** to null for now.
		*/
                resultColumn = (ResultColumn) nodeFactory.getNode(
                                                                        C_NodeTypes.RESULT_COLUMN,
                                                                        columnName,
                                                                        null,
                                                                        getContextManager());
                columnList.addResultColumn(resultColumn);
  }

/*
 * <A NAME="indexColumnList">indexColumnList</A>
 */
// GemStone changes BEGIN
  final public void indexColumnList(Vector columnList, boolean globalHash) throws ParseException, StandardException {
    indexColumnItem(columnList, globalHash);
    label_32:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[218] = jj_gen;
        break label_32;
      }
      jj_consume_token(COMMA);
      indexColumnItem(columnList, globalHash);
    }
  }

/*
void
indexColumnList(Vector columnList) throws StandardException :
{}
{
	indexColumnItem(columnList) ( <COMMA> indexColumnItem(columnList) ) *
}
*/
// GemStone changes END

/*
 * <A NAME="indexColumnItem">indexColumnItem</A>
 */
  final public void
// GemStone changes BEGIN
 indexColumnItem(Vector columnList, boolean globalHash) throws ParseException, StandardException {String          columnName;
    /* identifier never ends with a space; appending a space meaning desc */
    // GemStone changes BEGIN
    // GLOBAL HASH index does not allow ASC or DESC as keys are not ordered
            columnName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
    switch (jj_nt.kind) {
    case ASC:
    case DESC:{
      switch (jj_nt.kind) {
      case ASC:{
        jj_consume_token(ASC);
if (globalHash) {if (true) throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR, "ASC");}
        break;
        }
      case DESC:{
        jj_consume_token(DESC);
if (globalHash) {if (true) throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR, "DESC");}
                          else columnName = columnName + ' ';
        break;
        }
      default:
        jj_la1[219] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[220] = jj_gen;
      ;
    }
/*
		** Store the column names for the index columns in the
		** index column list.
		*/
                columnList.addElement(columnName);
  }

/*
 * <A NAME="derivedTable">derivedTable</A>
 */
  final public ResultSetNode derivedTable() throws ParseException, StandardException {SubqueryNode tableSubquery;
    jj_consume_token(LEFT_PAREN);
    tableSubquery = tableSubquery(SubqueryNode.FROM_SUBQUERY, null);
    jj_consume_token(RIGHT_PAREN);
{if ("" != null) return tableSubquery.getResultSet();}
    throw new Error("Missing return statement in function");
  }

  final public TableOperatorNode joinedTableExpression(ResultSetNode leftRSN, boolean nestedInParens) throws ParseException, StandardException {TableOperatorNode joinNode;
    joinNode = qualifiedJoin(leftRSN, nestedInParens);
{if ("" != null) return joinNode;}
    throw new Error("Missing return statement in function");
  }

  final public TableOperatorNode qualifiedJoin(ResultSetNode leftRSN, boolean nestedInParens) throws ParseException, StandardException {int                                     joinType = JoinNode.INNERJOIN;
        ResultSetNode           rightRSN;
        TableOperatorNode       ton = null;
        Object[]                        onOrUsingClause = null;
        ResultColumnList        usingClause = null;
        ValueNode                       onClause;
    switch (jj_nt.kind) {
    case INNER:
    case LEFT:
    case RIGHT:{
      joinType = joinType();
      break;
      }
    default:
      jj_la1[221] = jj_gen;
      ;
    }
    jj_consume_token(JOIN);
    rightRSN = tableReferenceTypes(nestedInParens);
    onOrUsingClause = joinSpecification(leftRSN, rightRSN);
/* If NATURAL OR UNION is specified, then no joinSpecification()
		 * is required, otherwise it is required.
		 */

                /* RESOLVE - Since we don't support NATURAL or UNION joins yet,
		 * onOrUsingClause must be non-null.  (Change error message if and
		 * when grammar changes.)
		 */

                /* Figure out whether an ON or USING clause was used */
                onClause = (ValueNode) onOrUsingClause[ON_CLAUSE];
                usingClause = (ResultColumnList) onOrUsingClause[USING_CLAUSE];

                if (onClause == null && usingClause == null)
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_MISSING_JOIN_SPECIFICATION,
                                                        JoinNode.joinTypeToString(joinType));}
                }

                switch(joinType)
                {
                        case JoinNode.INNERJOIN:
                                ton = (TableOperatorNode) nodeFactory.getNode(
                                                                        C_NodeTypes.JOIN_NODE,
                                                                        leftRSN,
                                                                        rightRSN,
                                                                        onClause,
                                                                        usingClause,
                                                                        null,
                                                                        null,
                                                                        null,
                                                                        getContextManager());
                                break;

                        case JoinNode.LEFTOUTERJOIN:
                                ton = (TableOperatorNode) nodeFactory.getNode(
                                                                                C_NodeTypes.HALF_OUTER_JOIN_NODE,
                                                                                leftRSN,
                                                                                rightRSN,
                                                                                onClause,
                                                                                usingClause,
                                                                                Boolean.FALSE,
                                                                                null,
                                                                                getContextManager());
                                break;

                        case JoinNode.RIGHTOUTERJOIN:
                                ton = (TableOperatorNode) nodeFactory.getNode(
                                                                                C_NodeTypes.HALF_OUTER_JOIN_NODE,
                                                                                leftRSN,
                                                                                rightRSN,
                                                                                onClause,
                                                                                usingClause,
                                                                                Boolean.TRUE,
                                                                                null,
                                                                                getContextManager());
                                break;


                        default:
                                if (SanityManager.DEBUG)
                                {
                                        SanityManager.ASSERT(false, "Unexpected joinType");
                                }
                                {if ("" != null) return null;}
                }

                /* Mark whether or not we are nested within parens */
                ton.setNestedInParens(nestedInParens);
                {if ("" != null) return ton;}
    throw new Error("Missing return statement in function");
  }

  final public int joinType() throws ParseException, StandardException {int joinType;
    switch (jj_nt.kind) {
    case INNER:{
      jj_consume_token(INNER);
{if ("" != null) return JoinNode.INNERJOIN;}
      break;
      }
    case LEFT:
    case RIGHT:{
      joinType = outerJoinType();
      switch (jj_nt.kind) {
      case OUTER:{
        jj_consume_token(OUTER);
        break;
        }
      default:
        jj_la1[222] = jj_gen;
        ;
      }
{if ("" != null) return joinType;}
      break;
      }
    default:
      jj_la1[223] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public int outerJoinType() throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case LEFT:{
      jj_consume_token(LEFT);
{if ("" != null) return JoinNode.LEFTOUTERJOIN;}
      break;
      }
    case RIGHT:{
      jj_consume_token(RIGHT);
{if ("" != null) return JoinNode.RIGHTOUTERJOIN;}
      break;
      }
    default:
      jj_la1[224] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Object[] joinSpecification(ResultSetNode leftRSN, ResultSetNode rightRSN) throws ParseException, StandardException {Object[]                        onOrUsingClause = new Object[ON_OR_USING_CLAUSE_SIZE];
        ResultColumnList        usingClause = null;
        ValueNode                       joinClause = null;
    joinClause = joinCondition();
onOrUsingClause[ON_CLAUSE] = joinClause;
                onOrUsingClause[USING_CLAUSE] = usingClause;
                {if ("" != null) return onOrUsingClause;}
    throw new Error("Missing return statement in function");
  }

  final public ValueNode joinCondition() throws ParseException, StandardException {ValueNode joinClause;
    jj_consume_token(ON);
    joinClause = valueExpression(false);
{if ("" != null) return joinClause;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="tableValueConstructor">tableValueConstructor</A>
 */
  final public ResultSetNode tableValueConstructor() throws ParseException, StandardException {ResultSetNode   resultSetNode;
    jj_consume_token(VALUES);
    resultSetNode = tableValueConstructorList();
{if ("" != null) return resultSetNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="tableValueConstructorList">tableValueConstructorList</A>
 */
  final public ResultSetNode tableValueConstructorList() throws ParseException, StandardException {ResultSetNode   resultSetNode;
    resultSetNode = rowValueConstructor(null);
    label_33:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[225] = jj_gen;
        break label_33;
      }
      jj_consume_token(COMMA);
      resultSetNode = rowValueConstructor(resultSetNode);
    }
if (resultSetNode instanceof UnionNode)
                {
                        ((UnionNode) resultSetNode).markTopTableConstructor();
                }

                {if ("" != null) return resultSetNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="explicitTable">explicitTable</A>
 */

/*
 * <A NAME="datetimeValueFunction">datetimeValueFunction</A>
 */
  final public ValueNode datetimeValueFunction() throws ParseException, StandardException {int prec = -1; // can't be negative, if used

    if ((getToken(1).kind == CURRENT && getToken(2).kind == DATE)) {
      jj_consume_token(CURRENT);
      jj_consume_token(DATE);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.CURRENT_DATETIME_OPERATOR_NODE,
                                                                ReuseFactory.getInteger(
                                                                        CurrentDatetimeOperatorNode.CURRENT_DATE),
                                                                getContextManager());}
    } else {
      switch (jj_nt.kind) {
      case CURRENT_DATE:{
        jj_consume_token(CURRENT_DATE);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.CURRENT_DATETIME_OPERATOR_NODE,
                                                                ReuseFactory.getInteger(
                                                                        CurrentDatetimeOperatorNode.CURRENT_DATE),
                                                                getContextManager());}
        break;
        }
      default:
        jj_la1[226] = jj_gen;
        if ((getToken(1).kind == CURRENT && getToken(2).kind == TIME)) {
          jj_consume_token(CURRENT);
          jj_consume_token(TIME);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                        C_NodeTypes.CURRENT_DATETIME_OPERATOR_NODE,
                                                        ReuseFactory.getInteger(
                                                                CurrentDatetimeOperatorNode.CURRENT_TIME),
                                                        getContextManager());}
        } else {
          switch (jj_nt.kind) {
          case CURRENT_TIME:{
            jj_consume_token(CURRENT_TIME);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                        C_NodeTypes.CURRENT_DATETIME_OPERATOR_NODE,
                                                        ReuseFactory.getInteger(
                                                                CurrentDatetimeOperatorNode.CURRENT_TIME),
                                                        getContextManager());}
            break;
            }
          default:
            jj_la1[227] = jj_gen;
            if ((getToken(1).kind == CURRENT && getToken(2).kind == TIMESTAMP)) {
              jj_consume_token(CURRENT);
              jj_consume_token(TIMESTAMP);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                        C_NodeTypes.CURRENT_DATETIME_OPERATOR_NODE,
                                                        ReuseFactory.getInteger(
                                                                CurrentDatetimeOperatorNode.CURRENT_TIMESTAMP),
                                                        getContextManager());}
            } else {
              switch (jj_nt.kind) {
              case CURRENT_TIMESTAMP:{
                jj_consume_token(CURRENT_TIMESTAMP);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                        C_NodeTypes.CURRENT_DATETIME_OPERATOR_NODE,
                                                        ReuseFactory.getInteger(
                                                                CurrentDatetimeOperatorNode.CURRENT_TIMESTAMP),
                                                        getContextManager());}
                break;
                }
              default:
                jj_la1[228] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
** Note that set function and aggregate are used
** interchangeably in the parser.  The tree has
** aggregate nodes.
*/
  final public ValueNode aggregateNode() throws ParseException, StandardException {ValueNode agg;
    switch (jj_nt.kind) {
    case COUNT:{
      jj_consume_token(COUNT);
      jj_consume_token(LEFT_PAREN);
      switch (jj_nt.kind) {
      case ASTERISK:{
        jj_consume_token(ASTERISK);
agg = (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.AGGREGATE_NODE,
                                                                null,
                                                                CountAggregateDefinition.class,
                                                                Boolean.FALSE,
                Boolean.TRUE, //isCountStar
                                                                Boolean.FALSE,
                                                                "COUNT(*)",
                                                                getContextManager());
        break;
        }
      default:
        jj_la1[229] = jj_gen;
        if (jj_2_59(1)) {
          agg = aggregateExpression("COUNT", CountAggregateDefinition.class);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(RIGHT_PAREN);
{if ("" != null) return agg;}
      break;
      }
    case AVG:
    case MAX:
    case MIN:
    case SUM:{
      agg = generalAggregate();
{if ("" != null) return agg;}
      break;
      }
    default:
      jj_la1[230] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ValueNode aggregateExpression(String aggName, Class aggClass) throws ParseException, StandardException {boolean         distinct = false;
        ValueNode       value;
    if (jj_2_60(1)) {
      distinct = setQuantifier();
    } else {
      ;
    }
    value = additiveExpression(null, 0, false);
//GemStone changes BEGIN
      // splitting AVG to SUM(expr)/COUNT(expr).

           if(!"AVG".equals(aggName)) {

      //GemStone changes END

             {if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.AGGREGATE_NODE,
                                                                value,
                                                                aggClass,
                                                                distinct ? Boolean.TRUE : Boolean.FALSE,
                Boolean.FALSE,
                Boolean.FALSE,
                                                                aggName,
                                                                getContextManager());}
      //GemStone changes BEGIN

       }
       else {
           Token tmptoken = Token.newToken(SUM);
           tmptoken.kind = SUM;
           ValueNode sumnode = (ValueNode) nodeFactory.getNode(
                                                C_NodeTypes.AGGREGATE_NODE,
                                                value,
                                                aggClass(tmptoken),
                                                distinct ? Boolean.TRUE : Boolean.FALSE,
                                                Boolean.FALSE,
                                                Boolean.TRUE,
                                                aggName(tmptoken),
                                                getContextManager());

           tmptoken.kind = COUNT;
           ValueNode countnode = (ValueNode) nodeFactory.getNode(
                                                C_NodeTypes.AGGREGATE_NODE,
                                                value,
                                                aggClass(tmptoken),
                                                distinct ? Boolean.TRUE : Boolean.FALSE,
                                                Boolean.FALSE,
                                                Boolean.FALSE,
                                                aggName(tmptoken),
                                                 getContextManager());
           CompilerContext context = getCompilerContext();
           if(context.createQueryInfo())
           {
                                ValueNode expr =  (ValueNode) nodeFactory.getNode(
                                C_NodeTypes.BINARY_DIVIDE_OPERATOR_NODE,
                                sumnode,
                                countnode,Boolean.TRUE,
                                getContextManager());
                                {if ("" != null) return expr;}
           }else
           {


           ValueNode expr =  (ValueNode) nodeFactory.getNode(
                                C_NodeTypes.BINARY_DIVIDE_OPERATOR_NODE,
                                sumnode,
                                countnode,
                                getContextManager());
                                {if ("" != null) return expr;}
         }

       }
      //GemStone changes END

    throw new Error("Missing return statement in function");
  }

  final public ValueNode generalAggregate() throws ParseException, StandardException {Token                   aggToken;
        String                  methodAliasString;
        ValueNode       aggExpr;
        ValueNode               value;
    aggToken = builtInAggregateType();
    jj_consume_token(LEFT_PAREN);
    aggExpr = aggregateExpression(aggName(aggToken), aggClass(aggToken));
    jj_consume_token(RIGHT_PAREN);
{if ("" != null) return aggExpr;}
    throw new Error("Missing return statement in function");
  }

/*
** All built in aggregates are pretty similar to user
** defined aggregates, except we know what to map to
** without looking up the class name.
**
** NOTE: COUNT is omitted here because the COUNT aggregate is
** factored into a different rule, to distinguish between
** COUNT(*) and COUNT(<expression>).
*/
  final public Token builtInAggregateType() throws ParseException, StandardException {Token   retval;
    switch (jj_nt.kind) {
    case MAX:{
      retval = jj_consume_token(MAX);
      break;
      }
    case AVG:{
      retval = jj_consume_token(AVG);
      break;
      }
    case MIN:{
      retval = jj_consume_token(MIN);
      break;
      }
    case SUM:{
      retval = jj_consume_token(SUM);
      break;
      }
    default:
      jj_la1[231] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return retval;}
    throw new Error("Missing return statement in function");
  }

  final public ValueNode castSpecification() throws ParseException, StandardException {DataTypeDescriptor dts;
        ValueNode                treeTop;
        ValueNode                value;
        int                              charType;
        int                              length = -1;
    jj_consume_token(CAST);
    jj_consume_token(LEFT_PAREN);
boolean existing = getCompilerContext().switchOptimizeLiteral(false);
    value = castOperand();
    jj_consume_token(AS);
    dts = dataTypeCast();
    jj_consume_token(RIGHT_PAREN);
getCompilerContext().switchOptimizeLiteral(existing);
treeTop = (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.CAST_NODE,
                                                                        value,
                                                                        dts,
                                                                        getContextManager());
                ((CastNode) treeTop).setForExternallyGeneratedCASTnode();

                /* We need to generate a SQL->Java conversion tree above us if
		 * the dataTypeCast is a user type.
		 */
                if (dts.getTypeId().userType())
                {
                        treeTop = (ValueNode) nodeFactory.getNode(
                                                        C_NodeTypes.JAVA_TO_SQL_VALUE_NODE,
                                                        nodeFactory.getNode(
                                                                                        C_NodeTypes.SQL_TO_JAVA_VALUE_NODE,
                                                                                        treeTop,
                                                                                        getContextManager()),
                                                        getContextManager());
                }

                {if ("" != null) return treeTop;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="charOrVarchar">charOrVarchar</A>
 */
  final public int charOrVarchar() throws ParseException {
    switch (jj_nt.kind) {
    case CHAR:{
      jj_consume_token(CHAR);
{if ("" != null) return Types.CHAR;}
      break;
      }
    case VARCHAR:{
      jj_consume_token(VARCHAR);
{if ("" != null) return Types.VARCHAR;}
      break;
      }
    default:
      jj_la1[232] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ValueNode castOperand() throws ParseException, StandardException {ValueNode value;
    if (jj_2_61(1)) {
      value = additiveExpression(null, 0, false);
{if ("" != null) return value;}
    } else {
      switch (jj_nt.kind) {
      case NULL:{
        jj_consume_token(NULL);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.UNTYPED_NULL_CONSTANT_NODE,
                                                                        getContextManager());}
        break;
        }
      default:
        jj_la1[233] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="dynamicParameterSpecification">dynamicParameterSpecification</A>
 */
  final public ParameterNode dynamicParameterSpecification() throws ParseException, StandardException {
    jj_consume_token(QUESTION_MARK);
{if ("" != null) return makeParameterNode( );}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="whereClause">whereClause</A>
 */
  final public ValueNode whereClause(Token beginToken) throws ParseException, StandardException {ValueNode       value;
        Token           endToken;
    /* valueExpression() was searchCondition() */
            value = valueExpression(false);
endToken = getToken(0);

                value.setBeginOffset( beginToken.endOffset + 1 );
                value.setEndOffset( endToken.endOffset );

                {if ("" != null) return value;}
    throw new Error("Missing return statement in function");
  }

  final public GroupByList groupByClause() throws ParseException, StandardException {GroupByList groupingCols;
    jj_consume_token(GROUP);
    jj_consume_token(BY);
    groupingCols = groupingColumnReferenceList();
{if ("" != null) return groupingCols;}
    throw new Error("Missing return statement in function");
  }

  final public GroupByList groupingColumnReferenceList() throws ParseException, StandardException {// GemStone changes BEGIN
  // disable constants in order by clauses.
  boolean existing = getCompilerContext().switchOptimizeLiteral(false);
  // GemStone changes END
        GroupByList groupingCols = (GroupByList) nodeFactory.getNode(
                                                                        C_NodeTypes.GROUP_BY_LIST,
                                                                        getContextManager());
    groupingColumnReference(groupingCols);
    label_34:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[234] = jj_gen;
        break label_34;
      }
      jj_consume_token(COMMA);
      groupingColumnReference(groupingCols);
    }
// GemStone changes BEGIN
    getCompilerContext().switchOptimizeLiteral(existing);
    // GemStone changes END
                {if ("" != null) return groupingCols;}
    throw new Error("Missing return statement in function");
  }

  final public void groupingColumnReference(GroupByList groupingCols) throws ParseException, StandardException {ValueNode columnExpression;
    columnExpression = additiveExpression(null, 0, false);
if (columnExpression.isParameterNode())
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR, "?");}
                }
                if (columnExpression instanceof AggregateNode)
                {
                        AggregateNode agNode = (AggregateNode)columnExpression;
                        {if (true) throw StandardException.newException(
                                SQLState.LANG_AGGREGATE_IN_GROUPBY_LIST,
                                agNode.getAggregateName());}
                }
                groupingCols.addGroupByColumn(
                        (GroupByColumn) nodeFactory.getNode(
                                                        C_NodeTypes.GROUP_BY_COLUMN,
                                                        columnExpression,
                                                        getContextManager()));
  }

  final public ValueNode havingClause() throws ParseException, StandardException {ValueNode value;
    jj_consume_token(HAVING);
    value = valueExpression(false);
{if ("" != null) return value;}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode schemaDefinition() throws ParseException, StandardException {String  schemaName = null;
// GemStone changes BEGIN
        ServerGroupsTableAttribute defaultServerGroups =
                new ServerGroupsTableAttribute();
// GemStone changes END
        String  authName = null;
    jj_consume_token(SCHEMA);
    if (jj_2_62(1)) {
      schemaName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
      switch (jj_nt.kind) {
      case AUTHORIZATION:{
        jj_consume_token(AUTHORIZATION);
        authName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
        break;
        }
      default:
        jj_la1[235] = jj_gen;
        ;
      }
      switch (jj_nt.kind) {
      case _DEFAULT:{
        jj_consume_token(_DEFAULT);
        serverGroupDefinition(defaultServerGroups);
        break;
        }
      default:
        jj_la1[236] = jj_gen;
        ;
      }
if (authName != null)
                                checkVersion( DataDictionary.DD_VERSION_DERBY_10_2, "AUTHORIZATION");

                        if (schemaName.startsWith("SYS"))
                                {if (true) throw StandardException.newException(SQLState.INVALID_SCHEMA_SYS, schemaName);}

                        {if ("" != null) return (StatementNode) nodeFactory.getNode(
                                        C_NodeTypes.CREATE_SCHEMA_NODE,
                                        schemaName,
                                        authName,
                                        defaultServerGroups, // GemStone addition
                                        getContextManager()
                                        );}
    } else {
      switch (jj_nt.kind) {
      case AUTHORIZATION:{
        jj_consume_token(AUTHORIZATION);
        authName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
        switch (jj_nt.kind) {
        case _DEFAULT:{
          jj_consume_token(_DEFAULT);
          serverGroupDefinition(defaultServerGroups);
          break;
          }
        default:
          jj_la1[237] = jj_gen;
          ;
        }
checkVersion( DataDictionary.DD_VERSION_DERBY_10_2, "AUTHORIZATION");
                        if (authName.startsWith("SYS"))
                                {if (true) throw StandardException.newException(SQLState.INVALID_SCHEMA_SYS, authName);}

                        {if ("" != null) return (StatementNode) nodeFactory.getNode(
                                        C_NodeTypes.CREATE_SCHEMA_NODE,
                                        authName,
                                        authName,
                    defaultServerGroups, // GemStone addition
                                        getContextManager()
                                        );}
        break;
        }
      default:
        jj_la1[238] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="roleDefinition">roleDefinition</A>
 */
  final public StatementNode roleDefinition() throws ParseException, StandardException {String  roleName = null;
    jj_consume_token(ROLE);
    roleName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
{if (true) throw StandardException.newException
            (SQLState.NOT_IMPLEMENTED, "ROLES");}
                checkVersion( DataDictionary.DD_VERSION_DERBY_10_4, "ROLES");
                checkSqlStandardAccess("CREATE ROLE");

                // Reserve namespace for system roles
                if (roleName.startsWith("SYS")) {
                        {if (true) throw StandardException.newException
                            (SQLState.INVALID_ROLE_SYS, roleName);}
                }

                {if ("" != null) return (StatementNode) nodeFactory.getNode(
                        C_NodeTypes.CREATE_ROLE_NODE,
                        roleName,
                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="tableDefinition">tableDefinition</A>
 */
  final public StatementNode tableDefinition() throws ParseException, StandardException {char                            lockGranularity = TableDescriptor.DEFAULT_LOCK_GRANULARITY;
        Properties                      properties = null;
        TableName                       tableName;
        TableElementList        tableElementList;
        ResultColumnList        resultColumns = null;
        ResultSetNode           queryExpression;
        Token asClauseToken, withDataToken, columnListToken = null;
        boolean                         withData = true;
        // GemStone changes BEGIN
    AttributesFactory afact = new AttributesFactory();
    PartitionAttributesFactory pafact = new PartitionAttributesFactory();
    boolean isReplicate = false;
    boolean isQueryExpressionCase = false;
    ServerGroupsTableAttribute serverGroups = new ServerGroupsTableAttribute();
    InitSizeTableAttribute initSize = null;
    // index 0 = replicated or not, index 1 = partitioned or not,
    // index 2 Persistent or not and index 3 = normal/local
    // index 4 = eviction attributes set or not
    // index 5 = HDFS store set or not
    // index 6 = whether EVICTION BY CRITERIA has been set
    boolean[] repPartPersFlags = new boolean[] { false, false, false, false,
        false, false, false };
    DistributionDefinitionNode distributionNode =
        (DistributionDefinitionNode) nodeFactory.getNode(C_NodeTypes.DISTRIBUTION_DEFINTION_NODE,
                                                         Integer.valueOf(DistributionDescriptor.NONE),
                                                         getContextManager());
     CompilerContext cc = getCompilerContext();
    // GemStone changes END 

    jj_consume_token(TABLE);
    tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
cc.setForcedDDLrouting(true);
    if (getToken(1).kind == LEFT_PAREN &&
                               getToken(3).kind != COMMA &&
                               getToken(3).kind != RIGHT_PAREN) {
      tableElementList = tableElementList();
      fabricTableAttributes(afact, pafact, serverGroups, initSize,
                    repPartPersFlags, tableName, distributionNode);
      switch (jj_nt.kind) {
      case GEMFIREXDDASHPROPERTIES:{
        properties = propertyList(false);
        jj_consume_token(CHECK_PROPERTIES);
        break;
        }
      default:
        jj_la1[239] = jj_gen;
        ;
      }
// GemStone changes BEGIN
                                tableElementList.addTableElement(distributionNode);
                                if (properties == null) {
                          properties = new Properties();
                    }
                                setGFAttributes(properties,
                                   afact,
                                   pafact,
                                   distributionNode,
                                   repPartPersFlags,
                                   isQueryExpressionCase,
                                   tableName,
                                   serverGroups,
                                   initSize);
                                // GemStone changes END
                                {if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                                C_NodeTypes.CREATE_TABLE_NODE,
                                                                                tableName,
                                                                                tableElementList,
                                                                                properties,
// GemStone changes BEGIN
                                                                                // changed to use valueOf()
                                                                                Character.valueOf(lockGranularity),
// GemStone changes END
                                                                                getContextManager());}
    } else {
      switch (jj_nt.kind) {
      case AS:
      case LEFT_PAREN:{
        switch (jj_nt.kind) {
        case LEFT_PAREN:{
          columnListToken = jj_consume_token(LEFT_PAREN);
          resultColumns = tableColumnList();
          jj_consume_token(RIGHT_PAREN);
          break;
          }
        default:
          jj_la1[240] = jj_gen;
          ;
        }
        asClauseToken = jj_consume_token(AS);
        queryExpression = queryExpression(null, NO_SET_OP);
        jj_consume_token(WITH);
        switch (jj_nt.kind) {
        case NO:{
          jj_consume_token(NO);
withData = false;
          break;
          }
        default:
          jj_la1[241] = jj_gen;
          ;
        }
        withDataToken = jj_consume_token(DATA);
// Raise error if WITH DATA is specified
                                // (until it is implemented)
                                if (withData) {
                                        {if (true) throw StandardException.newException(
                                                SQLState.NOT_IMPLEMENTED, "WITH DATA");}
                                }
                                /* Parameters not allowed in create table */
                                HasNodeVisitor visitor =
                                        new HasNodeVisitor(ParameterNode.class);
                                queryExpression.accept(visitor);
                                if (visitor.hasNode())
                                {
                                        {if (true) throw StandardException.newException(
                                                SQLState.LANG_NO_PARAMS_IN_TABLES);}
                                }
                                // GemStone changes BEGIN
//			if (queryExpression instanceof SelectNode)
//			{
//			  throw StandardException.newException(SQLState.NOT_IMPLEMENTED,
//                "create table as query expression not supported yet");
//			}
            fabricTableAttributes(afact, pafact, serverGroups, initSize,
              repPartPersFlags, tableName, distributionNode);
              if (properties == null) {
                          properties = new Properties();
                    }
                                setGFAttributes(properties,
                                   afact,
                                   pafact,
                                   distributionNode,
                                   repPartPersFlags,
                                   isQueryExpressionCase,
                                   tableName,
                                   serverGroups,
                                   initSize);
                    queryExpression.setDistributionDefinition(distributionNode);
            // GemStone changes END
                int textToBeReplacedBegin;
                if (columnListToken != null) {
                  textToBeReplacedBegin = columnListToken.beginOffset;
                }  else {
                  textToBeReplacedBegin = asClauseToken.beginOffset;
                }
                                {if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                                C_NodeTypes.CREATE_TABLE_NODE,
                                                                                tableName,
                                                                                resultColumns,
                                                                                queryExpression,
                                                                                textToBeReplacedBegin,
                                                                                withDataToken.endOffset,
                                                                                statementSQLText,
                                                                                getContextManager());}
        break;
        }
      default:
        jj_la1[242] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

// GemStone changes BEGIN ---
  final public 
StatementNode gatewaySenderDefinition() throws ParseException, StandardException {String id = null;
    Integer remoteDsId = null;
    Map attrs = new HashMap();
    ServerGroupsTableAttribute serverGroups = new ServerGroupsTableAttribute();
    jj_consume_token(GATEWAYSENDER);
    id = identifier(Limits.MAX_IDENTIFIER_LENGTH,true);
    jj_consume_token(LEFT_PAREN);
    jj_consume_token(REMOTEDSID);
    remoteDsId = simpleValueSpecification_int();
    label_35:
    while (true) {
      switch (jj_nt.kind) {
      case SOCKETBUFFERSIZE:
      case MANUALSTART:
      case SOCKETREADTIMEOUT:
      case ENABLEBATCHCONFLATION:
      case BATCHSIZE:
      case BATCHTIMEINTERVAL:
      case ENABLEPERSISTENCE:
      case DISKSTORENAME:
      case MAXQUEUEMEMORY:
      case DISKSYNCHRONOUS:
      case ALERTTHRESHOLD:
      case ISPARALLEL:{
        ;
        break;
        }
      default:
        jj_la1[243] = jj_gen;
        break label_35;
      }
      populateGatewaySenderAttributes(attrs);
    }
    jj_consume_token(RIGHT_PAREN);
    serverGroupDefinition(serverGroups);
{if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.CREATE_GATEWAY_SENDER_NODE,
                                                                id,
                                                                remoteDsId,
                                                                serverGroups,
                                attrs,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public void populateGatewaySenderAttributes(Map attrs) throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case SOCKETBUFFERSIZE:{
      jj_consume_token(SOCKETBUFFERSIZE);
addToMapAllowOnce(attrs, CreateGatewaySenderNode.SOCKETBUFFERSIZE, simpleValueSpecification_int());
      break;
      }
    case MANUALSTART:{
      jj_consume_token(MANUALSTART);
      switch (jj_nt.kind) {
      case TRUE:{
        jj_consume_token(TRUE);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.MANUALSTART, Boolean.TRUE);
        break;
        }
      case FALSE:{
        jj_consume_token(FALSE);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.MANUALSTART, Boolean.FALSE);
        break;
        }
      default:
        jj_la1[244] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case SOCKETREADTIMEOUT:{
      jj_consume_token(SOCKETREADTIMEOUT);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.SOCKETREADTIMEOUT, simpleValueSpecification_int());
      break;
      }
    case ENABLEBATCHCONFLATION:{
      jj_consume_token(ENABLEBATCHCONFLATION);
      switch (jj_nt.kind) {
      case TRUE:{
        jj_consume_token(TRUE);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.ENABLEBATCHCONFLATION, Boolean.TRUE);
        break;
        }
      case FALSE:{
        jj_consume_token(FALSE);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.ENABLEBATCHCONFLATION, Boolean.FALSE);
        break;
        }
      default:
        jj_la1[245] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case BATCHSIZE:{
      jj_consume_token(BATCHSIZE);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.BATCHSIZE, simpleValueSpecification_int());
      break;
      }
    case BATCHTIMEINTERVAL:{
      jj_consume_token(BATCHTIMEINTERVAL);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.BATCHTIMEINTERVAL, simpleValueSpecification_int());
      break;
      }
    case ENABLEPERSISTENCE:{
      jj_consume_token(ENABLEPERSISTENCE);
      switch (jj_nt.kind) {
      case TRUE:{
        jj_consume_token(TRUE);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.ENABLEPERSISTENCE, Boolean.TRUE);
        break;
        }
      case FALSE:{
        jj_consume_token(FALSE);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.ENABLEPERSISTENCE, Boolean.FALSE);
        break;
        }
      default:
        jj_la1[246] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case DISKSYNCHRONOUS:{
      jj_consume_token(DISKSYNCHRONOUS);
      switch (jj_nt.kind) {
      case TRUE:{
        jj_consume_token(TRUE);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.DISKSYNCHRONOUS, Boolean.TRUE);
        break;
        }
      case FALSE:{
        jj_consume_token(FALSE);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.DISKSYNCHRONOUS, Boolean.FALSE);
        break;
        }
      default:
        jj_la1[247] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case DISKSTORENAME:{
      jj_consume_token(DISKSTORENAME);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.DISKSTORENAME, identifier(Limits.MAX_IDENTIFIER_LENGTH,true));
      break;
      }
    case MAXQUEUEMEMORY:{
      jj_consume_token(MAXQUEUEMEMORY);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.MAXQUEUEMEMORY, simpleValueSpecification_int());
      break;
      }
    case ALERTTHRESHOLD:{
      jj_consume_token(ALERTTHRESHOLD);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.ALERTTHRESHOLD, simpleValueSpecification_int());
      break;
      }
    case ISPARALLEL:{
      jj_consume_token(ISPARALLEL);
      switch (jj_nt.kind) {
      case TRUE:{
        jj_consume_token(TRUE);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.ISPARALLEL, Boolean.TRUE);
        break;
        }
      case FALSE:{
        jj_consume_token(FALSE);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.ISPARALLEL, Boolean.FALSE);
        break;
        }
      default:
        jj_la1[248] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[249] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public StatementNode asyncEventListenerDefinition() throws ParseException, StandardException {String id = null;
    Map attrs = new HashMap();
    String listenerClass = null ;
    String initParams = null;
    ServerGroupsTableAttribute serverGroups = new ServerGroupsTableAttribute();
    jj_consume_token(ASYNCLISTENER);
    id = identifier(Limits.MAX_IDENTIFIER_LENGTH,true);
    jj_consume_token(LEFT_PAREN);
    jj_consume_token(LISTENERCLASS);
    listenerClass = string();
    jj_consume_token(INITPARAMS);
    initParams = string();
    label_36:
    while (true) {
      switch (jj_nt.kind) {
      case MANUALSTART:
      case ENABLEBATCHCONFLATION:
      case BATCHSIZE:
      case BATCHTIMEINTERVAL:
      case ENABLEPERSISTENCE:
      case DISKSTORENAME:
      case MAXQUEUEMEMORY:
      case DISKSYNCHRONOUS:
      case ALERTTHRESHOLD:
      case ISPARALLEL:{
        ;
        break;
        }
      default:
        jj_la1[250] = jj_gen;
        break label_36;
      }
      populateAsyncEventListenerAttributes(attrs);
    }
    jj_consume_token(RIGHT_PAREN);
    serverGroupDefinition(serverGroups);
{if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.CREATE_ASYNC_EVENT_LISTENER_NODE,
                                                                id,
                                                                listenerClass,
                                                                initParams,
                                                                serverGroups,
                                attrs,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public void populateAsyncEventListenerAttributes(Map attrs) throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case MANUALSTART:{
      jj_consume_token(MANUALSTART);
      switch (jj_nt.kind) {
      case TRUE:{
        jj_consume_token(TRUE);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.MANUALSTART, Boolean.TRUE);
        break;
        }
      case FALSE:{
        jj_consume_token(FALSE);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.MANUALSTART, Boolean.FALSE);
        break;
        }
      default:
        jj_la1[251] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case ENABLEBATCHCONFLATION:{
      jj_consume_token(ENABLEBATCHCONFLATION);
      switch (jj_nt.kind) {
      case TRUE:{
        jj_consume_token(TRUE);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.ENABLEBATCHCONFLATION, Boolean.TRUE);
        break;
        }
      case FALSE:{
        jj_consume_token(FALSE);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.ENABLEBATCHCONFLATION, Boolean.FALSE);
        break;
        }
      default:
        jj_la1[252] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case BATCHSIZE:{
      jj_consume_token(BATCHSIZE);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.BATCHSIZE, simpleValueSpecification_int());
      break;
      }
    case BATCHTIMEINTERVAL:{
      jj_consume_token(BATCHTIMEINTERVAL);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.BATCHTIMEINTERVAL, simpleValueSpecification_int());
      break;
      }
    case ENABLEPERSISTENCE:{
      jj_consume_token(ENABLEPERSISTENCE);
      switch (jj_nt.kind) {
      case TRUE:{
        jj_consume_token(TRUE);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.ENABLEPERSISTENCE, Boolean.TRUE);
        break;
        }
      case FALSE:{
        jj_consume_token(FALSE);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.ENABLEPERSISTENCE, Boolean.FALSE);
        break;
        }
      default:
        jj_la1[253] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case DISKSYNCHRONOUS:{
      jj_consume_token(DISKSYNCHRONOUS);
      switch (jj_nt.kind) {
      case TRUE:{
        jj_consume_token(TRUE);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.DISKSYNCHRONOUS, Boolean.TRUE);
        break;
        }
      case FALSE:{
        jj_consume_token(FALSE);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.DISKSYNCHRONOUS, Boolean.FALSE);
        break;
        }
      default:
        jj_la1[254] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case DISKSTORENAME:{
      jj_consume_token(DISKSTORENAME);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.DISKSTORENAME, identifier(Limits.MAX_IDENTIFIER_LENGTH,true));
      break;
      }
    case MAXQUEUEMEMORY:{
      jj_consume_token(MAXQUEUEMEMORY);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.MAXQUEUEMEMORY, simpleValueSpecification_int());
      break;
      }
    case ALERTTHRESHOLD:{
      jj_consume_token(ALERTTHRESHOLD);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.ALERTTHRESHOLD, simpleValueSpecification_int());
      break;
      }
    case ISPARALLEL:{
      jj_consume_token(ISPARALLEL);
      switch (jj_nt.kind) {
      case TRUE:{
        jj_consume_token(TRUE);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.ISPARALLEL, Boolean.TRUE);
        break;
        }
      case FALSE:{
        jj_consume_token(FALSE);
addToMapAllowOnce(attrs,CreateGatewaySenderNode.ISPARALLEL, Boolean.FALSE);
        break;
        }
      default:
        jj_la1[255] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[256] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public StatementNode dropAsyncEventListenerStatement() throws ParseException, StandardException {String id = null;
// GemStone changes BEGIN
        Boolean onlyIfExists = Boolean.FALSE;
// GemStone changes END

    jj_consume_token(ASYNCLISTENER);
    switch (jj_nt.kind) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
onlyIfExists = Boolean.TRUE;
      break;
      }
    default:
      jj_la1[257] = jj_gen;
      ;
    }
    // GemStone changes END
       id = identifier(Limits.MAX_IDENTIFIER_LENGTH,true);
{if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.DROP_ASYNC_EVENT_LISTENER_NODE,
                                                                id,
// GemStone changes BEGIN								
                                                                onlyIfExists,
// GemStone changes END								
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode dropGatewaySenderStatement() throws ParseException, StandardException {String id = null;
// GemStone changes BEGIN
        Boolean onlyIfExists = Boolean.FALSE;
// GemStone changes END

    jj_consume_token(GATEWAYSENDER);
    switch (jj_nt.kind) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
onlyIfExists = Boolean.TRUE;
      break;
      }
    default:
      jj_la1[258] = jj_gen;
      ;
    }
    // GemStone changes END
    
       id = identifier(Limits.MAX_IDENTIFIER_LENGTH,true);
{if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.DROP_GATEWAY_SENDER_NODE,
                                                                id,
// GemStone changes BEGIN								
                                                                onlyIfExists,
// GemStone changes END								
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode dropGatewayReceiverStatement() throws ParseException, StandardException {String id  = null;
// GemStone changes BEGIN
        Boolean onlyIfExists = Boolean.FALSE;
// GemStone changes END

    jj_consume_token(GATEWAYRECEIVER);
    switch (jj_nt.kind) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
onlyIfExists = Boolean.TRUE;
      break;
      }
    default:
      jj_la1[259] = jj_gen;
      ;
    }
    // GemStone changes END
    
       id = identifier(Limits.MAX_IDENTIFIER_LENGTH,true);
{if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.DROP_GATEWAY_RECEIVER_NODE,
                                                                id,
// GemStone changes BEGIN								
                                                                onlyIfExists,
// GemStone changes END								
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode gatewayReceiverDefinition() throws ParseException, StandardException {Map attrs = new HashMap();
        ServerGroupsTableAttribute serverGroups = new ServerGroupsTableAttribute();
        String id  = null;
    jj_consume_token(GATEWAYRECEIVER);
    id = identifier(Limits.MAX_IDENTIFIER_LENGTH,true);
    switch (jj_nt.kind) {
    case LEFT_PAREN:{
      jj_consume_token(LEFT_PAREN);
      label_37:
      while (true) {
        switch (jj_nt.kind) {
        case SOCKETBUFFERSIZE:
        case STARTPORT:
        case ENDPORT:
        case MAXTIMEBETWEENPINGS:
        case BINDADDRESS:
        case HOSTNAMEFORSENDERS:{
          ;
          break;
          }
        default:
          jj_la1[260] = jj_gen;
          break label_37;
        }
        populateGatewarReceiverAttributes(attrs);
      }
      jj_consume_token(RIGHT_PAREN);
      break;
      }
    default:
      jj_la1[261] = jj_gen;
      ;
    }
    switch (jj_nt.kind) {
    case SERVER:{
      serverGroupDefinition(serverGroups);
      break;
      }
    default:
      jj_la1[262] = jj_gen;
      ;
    }
{if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.CREATE_GATEWAY_RECEIVER_NODE,
                                                                attrs,id, serverGroups,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public void populateGatewarReceiverAttributes(Map attrs) throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case STARTPORT:{
      jj_consume_token(STARTPORT);
addToMapAllowOnce(attrs,CreateGatewayReceiverNode.STARTPORT, simpleValueSpecification_int());
      break;
      }
    case ENDPORT:{
      jj_consume_token(ENDPORT);
addToMapAllowOnce(attrs,CreateGatewayReceiverNode.ENDPORT, simpleValueSpecification_int());
      break;
      }
    case SOCKETBUFFERSIZE:{
      jj_consume_token(SOCKETBUFFERSIZE);
addToMapAllowOnce(attrs,CreateGatewayReceiverNode.SOCKETBUFFERSIZE, simpleValueSpecification_int());
      break;
      }
    case MAXTIMEBETWEENPINGS:{
      jj_consume_token(MAXTIMEBETWEENPINGS);
addToMapAllowOnce(attrs,CreateGatewayReceiverNode.MAXTIMEBETWEENPINGS, simpleValueSpecification_int());
      break;
      }
    case BINDADDRESS:{
      jj_consume_token(BINDADDRESS);
addToMapAllowOnce(attrs,CreateGatewayReceiverNode.BINDADDRESS, stringLiteral().getString());
      break;
      }
    case HOSTNAMEFORSENDERS:{
      jj_consume_token(HOSTNAMEFORSENDERS);
addToMapAllowOnce(attrs,CreateGatewayReceiverNode.HOSTNAMEFORSENDERS, stringLiteral().getString());
      break;
      }
    default:
      jj_la1[263] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public StatementNode hdfsStoreDefinition() throws ParseException, StandardException {String hdfsStoreName = null;
       String nameNode = null;
       String homeDir = null;
       Map otherAttribs = new HashMap();
       CharConstantNode strNode = null;
    jj_consume_token(HDFSSTORE);
    hdfsStoreName = identifier(Limits.MAX_IDENTIFIER_LENGTH,true);
    jj_consume_token(NAMENODE);
    strNode = stringLiteral();
if (strNode != null)
        {
           nameNode = strNode.getString();
        }
    label_38:
    while (true) {
      switch (jj_nt.kind) {
      case HOMEDIR:
      case BLOCKCACHESIZE:
      case CLIENTCONFIGFILE:
      case BATCHSIZE:
      case DISPATCHERTHREADS:
      case BATCHTIMEINTERVAL:
      case DISKSTORENAME:
      case MAXQUEUEMEMORY:
      case QUEUEPERSISTENT:
      case DISKSYNCHRONOUS:
      case MINORCOMPACT:
      case MAJORCOMPACT:
      case MAXINPUTFILESIZE:
      case MININPUTFILECOUNT:
      case MAXINPUTFILECOUNT:
      case MINORCOMPACTIONTHREADS:
      case MAJORCOMPACTIONINTERVAL:
      case MAJORCOMPACTIONTHREADS:
      case PURGEINTERVAL:
      case MAXWRITEONLYFILESIZE:
      case WRITEONLYFILEROLLOVERINTERVAL:{
        ;
        break;
        }
      default:
        jj_la1[264] = jj_gen;
        break label_38;
      }
      populateHDFSAttributes(otherAttribs);
    }
{if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                               C_NodeTypes.CREATE_HDFS_STORE_NODE,
                                                               hdfsStoreName,
                                                               nameNode,
                                                               otherAttribs,
                                                               getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public void populateHDFSAttributes(Map otherAttribs) throws ParseException, StandardException {Token tok;
        ValueNode val;
        Token bool ;
        String name = null;
        CharConstantNode strNode = null;
        String str = null;
        BigDecimal interval = new BigDecimal("1");
    switch (jj_nt.kind) {
    case BLOCKCACHESIZE:
    case BATCHSIZE:
    case DISPATCHERTHREADS:
    case MAXQUEUEMEMORY:
    case MAXINPUTFILESIZE:
    case MININPUTFILECOUNT:
    case MAXINPUTFILECOUNT:
    case MINORCOMPACTIONTHREADS:
    case MAJORCOMPACTIONTHREADS:
    case MAXWRITEONLYFILESIZE:{
      switch (jj_nt.kind) {
      case BATCHSIZE:{
        tok = jj_consume_token(BATCHSIZE);
        break;
        }
      case DISPATCHERTHREADS:{
        tok = jj_consume_token(DISPATCHERTHREADS);
        break;
        }
      case MAXQUEUEMEMORY:{
        tok = jj_consume_token(MAXQUEUEMEMORY);
        break;
        }
      case MAXINPUTFILESIZE:{
        tok = jj_consume_token(MAXINPUTFILESIZE);
        break;
        }
      case MININPUTFILECOUNT:{
        tok = jj_consume_token(MININPUTFILECOUNT);
        break;
        }
      case MAXINPUTFILECOUNT:{
        tok = jj_consume_token(MAXINPUTFILECOUNT);
        break;
        }
      case MINORCOMPACTIONTHREADS:{
        tok = jj_consume_token(MINORCOMPACTIONTHREADS);
        break;
        }
      case MAJORCOMPACTIONTHREADS:{
        tok = jj_consume_token(MAJORCOMPACTIONTHREADS);
        break;
        }
      case BLOCKCACHESIZE:{
        tok = jj_consume_token(BLOCKCACHESIZE);
        break;
        }
      case MAXWRITEONLYFILESIZE:{
        tok = jj_consume_token(MAXWRITEONLYFILESIZE);
        break;
        }
      default:
        jj_la1[265] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      val = intLiteral();
if (getIntValue(val) < 0)
             {
                {if (true) throw StandardException.newException(SQLState.LANG_INVALID_COLUMN_LENGTH,
                "Value " + getIntValue(val) + " is negative");}
             }
             addToMapAllowOnce(otherAttribs, tok.image, val);
      break;
      }
    case MAJORCOMPACTIONINTERVAL:
    case PURGEINTERVAL:{
      switch (jj_nt.kind) {
      case MAJORCOMPACTIONINTERVAL:{
        tok = jj_consume_token(MAJORCOMPACTIONINTERVAL);
        break;
        }
      case PURGEINTERVAL:{
        tok = jj_consume_token(PURGEINTERVAL);
        break;
        }
      default:
        jj_la1[266] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      val = getIntervalInMins();
if (getIntValue(val) < 1)
         {
            {if (true) throw StandardException.newException(SQLState.LANG_INVALID_COLUMN_LENGTH,
               "Value in minutes " + getIntValue(val) + " is less than 1");}
         }
         addToMapAllowOnce(otherAttribs, tok.image, val);
      break;
      }
    case WRITEONLYFILEROLLOVERINTERVAL:{
      tok = jj_consume_token(WRITEONLYFILEROLLOVERINTERVAL);
      val = getIntervalInSecs();
if (getIntValue(val) < 1)
         {
            {if (true) throw StandardException.newException(SQLState.LANG_INVALID_COLUMN_LENGTH,
               "Value in seconds " + getIntValue(val) + " is less than 1");}
         }
         addToMapAllowOnce(otherAttribs, tok.image, val);
      break;
      }
    case BATCHTIMEINTERVAL:{
      tok = jj_consume_token(BATCHTIMEINTERVAL);
      val = getIntervalInMillis();
if (getIntValue(val) < 1)
         {
            {if (true) throw StandardException.newException(SQLState.LANG_INVALID_COLUMN_LENGTH,
               "Value in milliseconds " + getIntValue(val) + " is less than 1");}
         }
         addToMapAllowOnce(otherAttribs, tok.image, val);
      break;
      }
    case QUEUEPERSISTENT:
    case DISKSYNCHRONOUS:
    case MINORCOMPACT:
    case MAJORCOMPACT:{
      switch (jj_nt.kind) {
      case QUEUEPERSISTENT:{
        tok = jj_consume_token(QUEUEPERSISTENT);
        break;
        }
      case DISKSYNCHRONOUS:{
        tok = jj_consume_token(DISKSYNCHRONOUS);
        break;
        }
      case MINORCOMPACT:{
        tok = jj_consume_token(MINORCOMPACT);
        break;
        }
      case MAJORCOMPACT:{
        tok = jj_consume_token(MAJORCOMPACT);
        break;
        }
      default:
        jj_la1[267] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      bool = booleanLiteral();
addToMapAllowOnce(otherAttribs, tok.image, bool.image);
      break;
      }
    case DISKSTORENAME:{
      tok = jj_consume_token(DISKSTORENAME);
      name = identifier(Limits.MAX_IDENTIFIER_LENGTH,true);
addToMapAllowOnce(otherAttribs, tok.image, name);
      break;
      }
    case HOMEDIR:
    case CLIENTCONFIGFILE:{
      switch (jj_nt.kind) {
      case HOMEDIR:{
        tok = jj_consume_token(HOMEDIR);
        break;
        }
      case CLIENTCONFIGFILE:{
        tok = jj_consume_token(CLIENTCONFIGFILE);
        break;
        }
      default:
        jj_la1[268] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      strNode = stringLiteral();
if (strNode != null)
         {
            str = strNode.getString();
            addToMapAllowOnce(otherAttribs, tok.image, str);
         }
      break;
      }
    default:
      jj_la1[269] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * <A NAME="diskStoreDefinition">diskStoreDefinition</A>
 */
  final public StatementNode diskStoreDefinition() throws ParseException, StandardException {String diskStoreName;
        List<String> dirPaths  = new ArrayList<String >();
        List<Integer> dirSizes  = new ArrayList<Integer >();
        Map otherAttribs = new HashMap();
    jj_consume_token(DISKSTORE);
    diskStoreName = identifier(Limits.MAX_IDENTIFIER_LENGTH,true);
    label_39:
    while (true) {
      switch (jj_nt.kind) {
      case COMPACTIONTHRESHOLD:
      case AUTOCOMPACT:
      case ALLOWFORCECOMPACTION:
      case TIMEINTERVAL:
      case WRITEBUFFERSIZE:
      case QUEUESIZE:
      case MAXLOGSIZE:
      case LEFT_PAREN:
      case STRING:{
        ;
        break;
        }
      default:
        jj_la1[270] = jj_gen;
        break label_39;
      }
      populateDiskAttributes(dirPaths,dirSizes, otherAttribs);
    }
{if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.CREATE_DISK_STORE_NODE,
                                                                diskStoreName,
                                                                dirPaths,
                                                                dirSizes,
                                                                otherAttribs,getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public void populateDiskAttributes(List<String> dirPaths, List<Integer> dirSizes,
       Map otherAttribs) throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case COMPACTIONTHRESHOLD:
    case AUTOCOMPACT:
    case ALLOWFORCECOMPACTION:
    case TIMEINTERVAL:
    case WRITEBUFFERSIZE:
    case QUEUESIZE:
    case MAXLOGSIZE:{
      diskStoreAttribs(otherAttribs);
      break;
      }
    case LEFT_PAREN:
    case STRING:{
      switch (jj_nt.kind) {
      case LEFT_PAREN:{
        jj_consume_token(LEFT_PAREN);
        dirPathsAndSizes(dirPaths, dirSizes);
        label_40:
        while (true) {
          switch (jj_nt.kind) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[271] = jj_gen;
            break label_40;
          }
          jj_consume_token(COMMA);
          dirPathsAndSizes(dirPaths, dirSizes);
        }
        jj_consume_token(RIGHT_PAREN);
        break;
        }
      case STRING:{
        dirPathsAndSizes(dirPaths, dirSizes);
        break;
        }
      default:
        jj_la1[272] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[273] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void dirPathsAndSizes(List<String> dirlist, List<Integer> dirSizes) throws ParseException, StandardException {int val = -1;
        String dirname;
        File file;
        CharConstantNode strNode = null;
    strNode = stringLiteral();
dirname = strNode.getString();
                // If string is zero-length, throw exception
                if (dirname.length() == 0)
                {
                          {if (true) throw StandardException.newException(SQLState.NOT_IMPLEMENTED,
                  "Directory name is invalid");}
                }
    switch (jj_nt.kind) {
    case FALSE:
    case TRUE:
    case LEFT_BRACE:
    case PLUS_SIGN:
    case MINUS_SIGN:
    case EXACT_NUMERIC:
    case STRING:
    case HEX_STRING:
    case APPROXIMATE_NUMERIC:{
      val = simpleValueSpecification_int();
      break;
      }
    default:
      jj_la1[274] = jj_gen;
      ;
    }
if (val == 0)
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR,
                        "Directory size should be greater than zero");}
                }
dirlist.add(dirname);
                  dirSizes.add(Integer.valueOf(val));
  }

  final public StatementNode dropHDFSStoreStatement() throws ParseException, StandardException {String id  = null;
        Boolean onlyIfExists = Boolean.FALSE;
    jj_consume_token(HDFSSTORE);
    switch (jj_nt.kind) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
onlyIfExists = Boolean.TRUE;
      break;
      }
    default:
      jj_la1[275] = jj_gen;
      ;
    }
    id = identifier(Limits.MAX_IDENTIFIER_LENGTH,true);
{if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.DROP_HDFS_STORE_NODE,
                                                                id,
                                                                onlyIfExists,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode dropDiskStoreStatement() throws ParseException, StandardException {String id  = null;
// GemStone changes BEGIN
        Boolean onlyIfExists = Boolean.FALSE;
// GemStone changes END

    jj_consume_token(DISKSTORE);
    switch (jj_nt.kind) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
onlyIfExists = Boolean.TRUE;
      break;
      }
    default:
      jj_la1[276] = jj_gen;
      ;
    }
    // GemStone changes END
       id = identifier(Limits.MAX_IDENTIFIER_LENGTH,true);
{if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.DROP_DISK_STORE_NODE,
                                                                id,
// GemStone changes BEGIN								
                                                                onlyIfExists,
// GemStone changes END								
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public void fabricTableAttributes(AttributesFactory afact,
    PartitionAttributesFactory pafact,
    ServerGroupsTableAttribute serverGroups,
    InitSizeTableAttribute initSize, boolean[] repPartPersFlags,
    TableName tableName,
    DistributionDefinitionNode distributionNode) throws ParseException, StandardException {
    label_41:
    while (true) {
      switch (jj_nt.kind) {
      case BUCKETS:
      case EVICTION:
      case EXPIRE:
      case INITSIZE:
      case LOCAL:
      case MAXPARTSIZE:
      case PARTITION:
      case PERSISTENT:
      case RECOVERYDELAY:
      case REDUNDANCY:
      case REPLICATE:
      case SERVER:
      case STARTUPRECOVERYDELAY:
      case ASYNCLISTENER:
      case HDFSSTORE:
      case GATEWAYSENDER:
      case OFFHEAP:
      case ENABLE:
      case CONCURRENCY:{
        ;
        break;
        }
      default:
        jj_la1[277] = jj_gen;
        break label_41;
      }
      fabricTableAttribute(afact, pafact, serverGroups,
                     initSize, repPartPersFlags, tableName, distributionNode);
    }
  }

  final public void fabricTableAttribute(AttributesFactory afact,
    PartitionAttributesFactory pafact,
    ServerGroupsTableAttribute serverGroups, InitSizeTableAttribute initSize,
    boolean[] repPartPersFlags, TableName tableName,
    DistributionDefinitionNode distributionNode) throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case BUCKETS:
    case LOCAL:
    case MAXPARTSIZE:
    case PARTITION:
    case RECOVERYDELAY:
    case REDUNDANCY:
    case REPLICATE:
    case STARTUPRECOVERYDELAY:{
      regionTypeDefinition(afact, pafact, repPartPersFlags, tableName, distributionNode);
      break;
      }
    case SERVER:{
      serverGroupDefinition(serverGroups);
      break;
      }
    case INITSIZE:{
      initSizeDefinition(initSize);
      break;
      }
    case EVICTION:{
      jj_consume_token(EVICTION);
      jj_consume_token(BY);
      switch (jj_nt.kind) {
      case LRUCOUNT:
      case LRUHEAPPERCENT:
      case LRUMEMSIZE:{
        evictionDefinition(afact, repPartPersFlags);
        break;
        }
      case CRITERIA:{
        customEvictionDefinition(afact, repPartPersFlags);
        break;
        }
      default:
        jj_la1[278] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case EXPIRE:{
      expirationDefinition(afact);
      break;
      }
    case PERSISTENT:{
      persistenceDiskDefinition(afact, repPartPersFlags);
      break;
      }
    case HDFSSTORE:{
      persistenceHDFSDefinition(afact, repPartPersFlags);
      break;
      }
    case ASYNCLISTENER:
    case GATEWAYSENDER:{
      gatewaySenderRegionDefinition(afact);
      break;
      }
    case CONCURRENCY:{
      concurrencyLevelDefinition(afact);
      break;
      }
    case OFFHEAP:{
      memScaleDefinition(afact);
      break;
      }
    case ENABLE:{
      concurrencyChecksDefinition(afact);
      break;
      }
    default:
      jj_la1[279] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void regionTypeDefinition(AttributesFactory afact,
    PartitionAttributesFactory pafact, boolean[] repPartPersFlags,
    TableName tableName, DistributionDefinitionNode distributionNode) throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case BUCKETS:
    case MAXPARTSIZE:
    case PARTITION:
    case RECOVERYDELAY:
    case REDUNDANCY:
    case REPLICATE:
    case STARTUPRECOVERYDELAY:{
      switch (jj_nt.kind) {
      case BUCKETS:
      case MAXPARTSIZE:
      case PARTITION:
      case RECOVERYDELAY:
      case REDUNDANCY:
      case STARTUPRECOVERYDELAY:{
        partitionClauseAndColocationDefinition(afact, pafact, repPartPersFlags,
                  tableName, distributionNode);
        break;
        }
      case REPLICATE:{
        replicatedDefinition(repPartPersFlags, distributionNode);
        break;
        }
      default:
        jj_la1[280] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case LOCAL:{
      jj_consume_token(LOCAL);
repPartPersFlags[3] = true;
      distributionNode.setPolicy(DistributionDescriptor.LOCAL);
      break;
      }
    default:
      jj_la1[281] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void replicatedDefinition(boolean[] repPartPersFlags,
         DistributionDefinitionNode distributionNode) throws ParseException, StandardException {
    jj_consume_token(REPLICATE);
repPartPersFlags[0] = true;
                distributionNode.setPolicy(DistributionDescriptor.REPLICATE);
  }

  final public void partitionClauseAndColocationDefinition(AttributesFactory afact,
    PartitionAttributesFactory pafact, boolean[] repPartPersFlags,
    TableName tableName, DistributionDefinitionNode distributionNode) throws ParseException, StandardException {PartitionResolver prslvr = null;
        TableName colocatedTable = null;
    switch (jj_nt.kind) {
    case PARTITION:{
      prslvr = partitioningClause(distributionNode, repPartPersFlags);
      switch (jj_nt.kind) {
      case COLOCATE:{
        colocatedTable = otherTablesColocationDefinition(distributionNode);
if (colocatedTable != null) {
          String tablePath = colocatedTable.getFullTableNameAsRegionPath();
          // check that colocated table should be partitioned too
          final Region<?, ?> masterRegion = Misc.getGemFireCache()
              .getRegionByPath(tablePath, false);
          if (masterRegion == null) {
            {if (true) throw StandardException.newException(SQLState.LANG_TABLE_NOT_FOUND,
                colocatedTable.getFullTableName());}
          }
          else if (!masterRegion.getAttributes().getDataPolicy().withPartitioning()) {
            {if (true) throw StandardException.newException(SQLState.TABLE_NOT_PARTITIONED,
                colocatedTable.toString(), "colocation with '"
                + tableName.toString() + "'");}
          }
          pafact.setColocatedWith(tablePath);
          if (prslvr != null) {
            ((GfxdPartitionResolver)prslvr).setMasterTable(tablePath);
          }
        }
        break;
        }
      default:
        jj_la1[282] = jj_gen;
        ;
      }
pafact.setPartitionResolver(prslvr);
      break;
      }
    case BUCKETS:
    case MAXPARTSIZE:
    case RECOVERYDELAY:
    case REDUNDANCY:
    case STARTUPRECOVERYDELAY:{
      label_42:
      while (true) {
        redundancyAndMaxPartSizeDefinition(pafact, distributionNode);
        switch (jj_nt.kind) {
        case BUCKETS:
        case MAXPARTSIZE:
        case RECOVERYDELAY:
        case REDUNDANCY:
        case STARTUPRECOVERYDELAY:{
          ;
          break;
          }
        default:
          jj_la1[283] = jj_gen;
          break label_42;
        }
      }
afact.setDataPolicy(DataPolicy.PARTITION);
      break;
      }
    default:
      jj_la1[284] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public PartitionResolver partitioningClause(DistributionDefinitionNode distributionNode, boolean[] repPartPersFlags) throws ParseException, StandardException {PartitionResolver tmpprslvr = null;
    jj_consume_token(PARTITION);
    jj_consume_token(BY);
    switch (jj_nt.kind) {
    case RANGE:{
      jj_consume_token(RANGE);
      tmpprslvr = partitionRangeDefinition(distributionNode);
      break;
      }
    case LIST:{
      jj_consume_token(LIST);
      tmpprslvr = partitionListDefinition(distributionNode);
      break;
      }
    case COLUMN:
    case PRIMARY:{
      tmpprslvr = partitionPKeyOrColumnDefinition(distributionNode);
      break;
      }
    case LEFT_PAREN:{
      tmpprslvr = partitionExpressionDefinition(distributionNode);
      break;
      }
    default:
      jj_la1[285] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (repPartPersFlags[1] == true)
        {
          // We already have a partition by clause, throw error
          {if (true) throw StandardException.newException(SQLState.LANG_DUPLICATE_PROPERTY, "partitioning clause");}
        }
        repPartPersFlags[1] = true;
        {if ("" != null) return tmpprslvr;}
    throw new Error("Missing return statement in function");
  }

  final public PartitionResolver partitionExpressionDefinition(DistributionDefinitionNode distributionNode) throws ParseException, StandardException {ValueNode exprNode = null;
    distributionNode.setPolicy(DistributionDescriptor.PARTITIONBYEXPRESSION);
    PartitionResolver prslvr = null;
    jj_consume_token(LEFT_PAREN);
    exprNode = additiveExpression(null, 0 ,false);
    jj_consume_token(RIGHT_PAREN);
prslvr = new GfxdPartitionByExpressionResolver(
            exprNode);
        {if ("" != null) return prslvr;}
    throw new Error("Missing return statement in function");
  }

  final public PartitionResolver partitionRangeDefinition(DistributionDefinitionNode distributionNode) throws ParseException, StandardException {ColumnReference columnName;
        ValueNode range;
        ValueNodeList ranges;
        distributionNode.setPolicy(DistributionDescriptor.PARTITIONBYRANGE);
        PartitionResolver prslvr = null;
    jj_consume_token(LEFT_PAREN);
    columnName = columnReference();
    jj_consume_token(RIGHT_PAREN);
distributionNode.addColumnReference(columnName);
    jj_consume_token(LEFT_PAREN);
    jj_consume_token(VALUES);
    range = betweenPredicateValue(columnName, false);
ContextManager cm = getContextManager();
                ranges = (ValueNodeList) nodeFactory.getNode(
                        C_NodeTypes.VALUE_NODE_LIST, cm);

                ranges.addValueNode(range);
                distributionNode.addValueNodeList(((BetweenOperatorNode)range).getRightOperandList());
    label_43:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[286] = jj_gen;
        break label_43;
      }
      jj_consume_token(COMMA);
      jj_consume_token(VALUES);
      range = betweenPredicateValue(columnName, false);
ranges.addValueNode(range);
                        distributionNode.addValueNodeList(((BetweenOperatorNode)range).getRightOperandList());
    }
    jj_consume_token(RIGHT_PAREN);
prslvr = new GfxdRangePartitionResolver(
                        columnName, ranges);
                {if ("" != null) return prslvr;}
    throw new Error("Missing return statement in function");
  }

  final public PartitionResolver partitionListDefinition(DistributionDefinitionNode distributionNode) throws ParseException, StandardException {ColumnReference columnName;
        ValueNode value;
        ValueNodeList valueList;
        ArrayList listOfValueLists;
        ContextManager cm = getContextManager();
        distributionNode.setPolicy(DistributionDescriptor.PARTITIONBYLIST);
        PartitionResolver prslvr = null;
    jj_consume_token(LEFT_PAREN);
    columnName = columnReference();
    jj_consume_token(RIGHT_PAREN);
    jj_consume_token(LEFT_PAREN);
    jj_consume_token(VALUES);
    jj_consume_token(LEFT_PAREN);
    value = additiveExpression(null, 0, false);
distributionNode.addColumnReference(columnName);


      valueList = (ValueNodeList) nodeFactory.getNode(
                        C_NodeTypes.VALUE_NODE_LIST, cm);
      valueList.addValueNode(value);
      listOfValueLists = new ArrayList();
    label_44:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[287] = jj_gen;
        break label_44;
      }
      jj_consume_token(COMMA);
      value = additiveExpression(null, 0, false);
valueList.addValueNode(value);
    }
distributionNode.addValueNodeList(valueList);
                listOfValueLists.add(valueList);
    jj_consume_token(RIGHT_PAREN);
    switch (jj_nt.kind) {
    case COMMA:{
      label_45:
      while (true) {
        jj_consume_token(COMMA);
        jj_consume_token(VALUES);
        jj_consume_token(LEFT_PAREN);
        value = additiveExpression(null, 0, false);
valueList = (ValueNodeList) nodeFactory.getNode(
                        C_NodeTypes.VALUE_NODE_LIST, cm);
            valueList.addValueNode(value);
        label_46:
        while (true) {
          switch (jj_nt.kind) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[288] = jj_gen;
            break label_46;
          }
          jj_consume_token(COMMA);
          value = additiveExpression(null, 0, false);
valueList.addValueNode(value);
        }
distributionNode.addValueNodeList(valueList);
                listOfValueLists.add(valueList);
        jj_consume_token(RIGHT_PAREN);
        switch (jj_nt.kind) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[289] = jj_gen;
          break label_45;
        }
      }
      break;
      }
    default:
      jj_la1[290] = jj_gen;
      ;
    }
    jj_consume_token(RIGHT_PAREN);
prslvr = new GfxdListPartitionResolver(
                        columnName, listOfValueLists);
                {if ("" != null) return prslvr;}
    throw new Error("Missing return statement in function");
  }

  final public PartitionResolver partitionPKeyOrColumnDefinition(DistributionDefinitionNode distributionNode) throws ParseException, StandardException {ColumnReference column_name;
        List colNames;
        GfxdPartitionByExpressionResolver prslvr = null;
    switch (jj_nt.kind) {
    case PRIMARY:{
      jj_consume_token(PRIMARY);
      jj_consume_token(KEY);
distributionNode.setPolicy(DistributionDescriptor.PARTITIONBYPRIMARYKEY);
                prslvr = new GfxdPartitionByExpressionResolver();
                prslvr.setPartitionByPrimaryKey();
                {if ("" != null) return prslvr;}
      break;
      }
    case COLUMN:{
      jj_consume_token(COLUMN);
      jj_consume_token(LEFT_PAREN);
      column_name = columnReference();
colNames = new ArrayList();
        colNames.add(column_name);
        distributionNode.addColumnReference(column_name);
      label_47:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[291] = jj_gen;
          break label_47;
        }
        jj_consume_token(COMMA);
        column_name = columnReference();
colNames.add(column_name);
        distributionNode.addColumnReference(column_name);
      }
      jj_consume_token(RIGHT_PAREN);
distributionNode.setPolicy(DistributionDescriptor.PARTITIONBYEXPRESSION);
        prslvr = new GfxdPartitionByExpressionResolver(colNames.toArray());
        {if ("" != null) return prslvr;}
      break;
      }
    default:
      jj_la1[292] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TableName otherTablesColocationDefinition(DistributionDefinitionNode distributionNode) throws ParseException, StandardException {ColumnReference column_name;
        TableName table_name = null;
    jj_consume_token(COLOCATE);
    jj_consume_token(WITH);
    jj_consume_token(LEFT_PAREN);
    table_name = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    jj_consume_token(RIGHT_PAREN);
distributionNode.setColocatedTable(table_name);
        {if ("" != null) return table_name;}
    throw new Error("Missing return statement in function");
  }

  final public void redundancyAndMaxPartSizeDefinition(PartitionAttributesFactory pafact,
    DistributionDefinitionNode distributionNode) throws ParseException, StandardException {int redundancy;
        int numBuckets;
        long recoveryDelay;
        long startupRecoveryDelay;
        int maxPartSize;
    switch (jj_nt.kind) {
    case REDUNDANCY:{
      jj_consume_token(REDUNDANCY);
      redundancy = simpleValueSpecification_int();
pafact.setRedundantCopies(redundancy);
                pafact.setRecoveryDelay(GemFireXDUtils.getDefaultRecoveryDelay());
                pafact.setStartupRecoveryDelay(
                        GemFireXDUtils.getDefaultStartupRecoveryDelay());
                distributionNode.setRedundancy(redundancy);
      break;
      }
    case BUCKETS:{
      jj_consume_token(BUCKETS);
      numBuckets = simpleValueSpecification_int();
if (numBuckets >= Short.MAX_VALUE)
            {
              {if (true) throw StandardException.newException(SQLState.LANG_INVALID_COLUMN_LENGTH,
                " bucket numbers should be less than: " + Short.MAX_VALUE);}
            }
            pafact.setTotalNumBuckets(numBuckets);
      break;
      }
    case RECOVERYDELAY:{
      jj_consume_token(RECOVERYDELAY);
      recoveryDelay = simpleValueSpecification_long();
pafact.setRecoveryDelay(recoveryDelay);
      break;
      }
    case STARTUPRECOVERYDELAY:{
      jj_consume_token(STARTUPRECOVERYDELAY);
      startupRecoveryDelay = simpleValueSpecification_long();
pafact.setStartupRecoveryDelay(startupRecoveryDelay);
      break;
      }
    case MAXPARTSIZE:{
      jj_consume_token(MAXPARTSIZE);
      maxPartSize = simpleValueSpecification_int();
pafact.setLocalMaxMemory(maxPartSize);
                distributionNode.setMaxPartSize(maxPartSize);
      break;
      }
    default:
      jj_la1[293] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void serverGroupDefinition(ServerGroupsTableAttribute serverGroups) throws ParseException, StandardException {String serverGroup;
    jj_consume_token(SERVER);
    jj_consume_token(GROUPS);
    jj_consume_token(LEFT_PAREN);
    serverGroup = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
serverGroups.addServerGroup(StringUtil.SQLToUpperCase(serverGroup));
    label_48:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[294] = jj_gen;
        break label_48;
      }
      jj_consume_token(COMMA);
      serverGroup = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
serverGroups.addServerGroup(StringUtil.SQLToUpperCase(serverGroup));
    }
    jj_consume_token(RIGHT_PAREN);
  }

  final public void initSizeDefinition(InitSizeTableAttribute initSize) throws ParseException, StandardException {int val;
    jj_consume_token(INITSIZE);
    val = simpleValueSpecification_int();
initSize = new InitSizeTableAttribute(val);
  }

/*
void
loaderDefinition(AttributesFactory afact, TableName tableName) throws StandardException :
{
	List loaderParamsList = new ArrayList();
	ValueNode param;
	Object tmp;
	String loaderStr;
}
{
	<LOADER> <LEFT_PAREN> 
	  loaderStr = javaClassName()
	  // TODO BELOW COMMA IS JUST FOR TESTING
	  [ param = simpleValueSpecification()
	  {
	  	tmp = ((ConstantNode)param).getValue().getObject();
	  	
	  	if (tmp != null) {
	        loaderParamsList.add(tmp);
	    }
	  }
	  (
	    <COMMA> param = simpleValueSpecification()
	    {
	      tmp = ((ConstantNode)param).getValue().getObject();
	      if (tmp != null) {
	        loaderParamsList.add(tmp);
	      }
	    }
	  )*
	  ]
	  <RIGHT_PAREN>
	  {
	  	  try {
	  	  // TODO Remove comments after testing
	  	  Method instanceGetter = ClassLoadUtil.methodFromName(loaderStr);
	  	  RowLoader ldr = (RowLoader)instanceGetter.invoke(null);
	  	  ldr.init(loaderParamsList.toArray());
	  	  String schemaName = Misc.getSchemaName(tableName.getSchemaName(),
	  	    getLanguageConnectionContext());
	  	  GfxdCacheLoader gemfireCacheLdr = new GfxdCacheLoader(schemaName,
	  	                          tableName.getTableName(), ldr);

	  	  afact.setCacheLoader(gemfireCacheLdr);
	  	  } catch (Exception e) {
	  	  	throw StandardException.newException
			  (SQLState.AM_NO_FACTORY_FOR_IMPLEMENTATION, e);
	  	  }
	  	} 
}
*/
  final public 
void evictionDefinition(AttributesFactory afact, boolean[] repPartPersFlags) throws ParseException, StandardException {/*if(!Misc.isServer()) {
      return;
    }*/
        int valnode;
        int timeInterval = -1;
        EvictionTableAttribute evictAttr = new EvictionTableAttribute();
        EvictionAction evctAction = null;
    switch (jj_nt.kind) {
    case LRUMEMSIZE:{
      jj_consume_token(LRUMEMSIZE);
      valnode = simpleValueSpecification_int();
// I'd rather use the attributesFactory to determine if eviction was
            // already specified, but it's read-only, and may not have all
            // valid info to be created into a regionAttributes class.
            // So, use a simple global flag.
            if (evictionChoice != 0)
            {
                 // Throw error, we already have an eviction clause
                         {if (true) throw StandardException.newException(SQLState.LANG_DUPLICATE_PROPERTY, "EVICTION");}
            }
            // LRUMEMSIZE cannot be zero. If it is, hosting the data of this region
            // throws an exception at connect time. Stop it here.
            if (valnode == 0)
            {
                {if (true) throw StandardException.newException(SQLState.LANG_INVALID_COLUMN_LENGTH,
                "LRUMEMSIZE cannot be zero");}
            }
            evictAttr.setType(EvictionTableAttribute.ID_MEMSIZE);
            evictAttr.setValue(valnode);
            evictionChoice = 1;
      break;
      }
    case LRUHEAPPERCENT:{
      jj_consume_token(LRUHEAPPERCENT);
if (evictionChoice != 0)
            {
                 // Throw error, we already have an eviction clause
                         {if (true) throw StandardException.newException(SQLState.LANG_DUPLICATE_PROPERTY, "EVICTION");}
            }
            evictAttr.setType(EvictionTableAttribute.ID_HEAPPERCENT);
            evictionChoice = 1;
      break;
      }
    case LRUCOUNT:{
      jj_consume_token(LRUCOUNT);
      valnode = simpleValueSpecification_int();
if (evictionChoice != 0)
            {
                 // Throw error, we already have an eviction clause
                         {if (true) throw StandardException.newException(SQLState.LANG_DUPLICATE_PROPERTY, "EVICTION");}
            }
            evictAttr.setType(EvictionTableAttribute.ID_COUNT);
            evictAttr.setValue(valnode);
            evictionChoice = 1;
      break;
      }
    default:
      jj_la1[295] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_nt.kind) {
    case EVICTACTION:{
      evctAction = evictionActionDefinition(afact);
      break;
      }
    default:
      jj_la1[296] = jj_gen;
      ;
    }
repPartPersFlags[4] = true;
            evictAttr.setEvictionAction(evctAction);
            evictAttr.setEvictionAttributes(afact);
  }

  final public EvictionAction evictionActionDefinition(AttributesFactory afact) throws ParseException, StandardException {EvictionAction evctAction;
        CharConstantNode strNode = null;
    jj_consume_token(EVICTACTION);
    switch (jj_nt.kind) {
    case DESTROY:{
      jj_consume_token(DESTROY);
// TODO : this is incompatible with REPLICATE region
            // but not currently throwing syntax error, Gemfire layer
            // throws IllegalStateException.
                evctAction = EvictionAction.LOCAL_DESTROY;
      break;
      }
    case OVERFLOW:{
      jj_consume_token(OVERFLOW);
evctAction = EvictionAction.OVERFLOW_TO_DISK;
      label_49:
      while (true) {
        switch (jj_nt.kind) {
        case ASYNCHRONOUS:
        case SYNCHRONOUS:
        case STRING:{
          ;
          break;
          }
        default:
          jj_la1[297] = jj_gen;
          break label_49;
        }
        switch (jj_nt.kind) {
        case STRING:{
          strNode = stringLiteral();
          break;
          }
        case ASYNCHRONOUS:
        case SYNCHRONOUS:{
          syncOrAsyncAttribute(afact);
          break;
          }
        default:
          jj_la1[298] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
if (strNode != null)
                {
                  //check if an explicit disk store is already set, if yes throw exception		  
                  if( prevDiskStore != null )
                  {
              {if (true) throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR, "Disk Store '"+ prevDiskStore
              +"' already set");}
                  }
                  prevDiskStore = strNode.getString();
                  afact.setDiskStoreName(StringUtil.SQLToUpperCase(prevDiskStore));
                }
                else
                {
                  afact.setDiskStoreName(GfxdConstants.GFXD_DEFAULT_DISKSTORE_NAME);
                }
      break;
      }
    default:
      jj_la1[299] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return evctAction;}
    throw new Error("Missing return statement in function");
  }

  final public void customEvictionDefinition(AttributesFactory afact,
    boolean[] repPartPersFlags) throws ParseException, StandardException {ValueNode predNode;
    Token tok, leftParenToken, rightParenToken;
    long startMillis = 0;
    long intervalMillis = 0;
    java.sql.Timestamp startTime = null;
    BigDecimal[] interval = new BigDecimal[1];
    jj_consume_token(CRITERIA);
    leftParenToken = jj_consume_token(LEFT_PAREN);
    predNode = whereClause(leftParenToken);
    rightParenToken = jj_consume_token(RIGHT_PAREN);
    switch (jj_nt.kind) {
    case EVICTION:{
      jj_consume_token(EVICTION);
      startTime = evictionFrequency(interval);
      break;
      }
    case EVICT:{
      jj_consume_token(EVICT);
      jj_consume_token(INCOMING);
      break;
      }
    default:
      jj_la1[300] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (interval[0] != null) {
            if (startTime != null) {
              startMillis = startTime.getTime();
            }
            intervalMillis = interval[0].longValue() * 1000L;
          }
          if (!Misc.getMemStoreBooting().isHadoopGfxdLonerMode()) {
                afact.setCustomEvictionAttributes(new GfxdEvictionCriteria(predNode,
                  statementSQLText, leftParenToken.endOffset + 1,
                rightParenToken.beginOffset), startMillis, intervalMillis);
                repPartPersFlags[6] = true;
          }
  }

  final public java.sql.Timestamp evictionFrequency(BigDecimal[] interval) throws ParseException, StandardException {ValueNode startTime = null;
        Token tok;
    jj_consume_token(FREQUENCY);
    tok = jj_consume_token(EXACT_NUMERIC);
try {
            interval[0] = new BigDecimal(tok.image);
          } catch (NumberFormatException nfe) {
            {if (true) throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR,
                nfe, nfe.toString());}
         }
    switch (jj_nt.kind) {
    case DAYS:{
      jj_consume_token(DAYS);
interval[0] = interval[0].multiply(new BigDecimal(3600L*24L));
      break;
      }
    case HOURS:{
      jj_consume_token(HOURS);
interval[0] = interval[0].multiply(new BigDecimal(3600L));
      break;
      }
    case MINUTES:{
      jj_consume_token(MINUTES);
interval[0] = interval[0].multiply(new BigDecimal(60L));
      break;
      }
    case SECONDS:{
      jj_consume_token(SECONDS);
      break;
      }
    default:
      jj_la1[301] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_nt.kind) {
    case START:{
      jj_consume_token(START);
      startTime = escapedDateTimeLiteral();
      break;
      }
    default:
      jj_la1[302] = jj_gen;
      ;
    }
if (startTime != null) {
            {if ("" != null) return ((DateTimeDataValue)startTime.getConstantValueAsObject())
                .getTimestamp(java.util.Calendar.getInstance(
                    java.util.TimeZone.getTimeZone("GMT")));}
          }
          else {
            {if ("" != null) return null;}
          }
    throw new Error("Missing return statement in function");
  }

  final public NumericConstantNode getIntervalInMins() throws ParseException, StandardException {BigDecimal interval = null;
interval = new BigDecimal(getLongValue(getIntervalInMillis()));
    interval = interval.divide(new BigDecimal(1000L*60L));
    {if ("" != null) return getNumericNode(String.valueOf(interval.longValue()), true);}
    throw new Error("Missing return statement in function");
  }

  final public NumericConstantNode getIntervalInSecs() throws ParseException, StandardException {BigDecimal interval = null;
interval = new BigDecimal(getLongValue(getIntervalInMillis()));
    interval = interval.divide(new BigDecimal(1000L));
    {if ("" != null) return getNumericNode(String.valueOf(interval.longValue()), true);}
    throw new Error("Missing return statement in function");
  }

  final public NumericConstantNode getIntervalInMillis() throws ParseException, StandardException {BigDecimal interval = null;
interval = new BigDecimal(getIntValue(intLiteral()));
    switch (jj_nt.kind) {
    case DAYS:{
      jj_consume_token(DAYS);
interval = interval.multiply(new BigDecimal(1000L*60L*60L*24L));
      break;
      }
    case HOURS:{
      jj_consume_token(HOURS);
interval = interval.multiply(new BigDecimal(1000L*60L*60L));
      break;
      }
    case MINUTES:{
      jj_consume_token(MINUTES);
interval = interval.multiply(new BigDecimal(1000L*60L));
      break;
      }
    case SECONDS:{
      jj_consume_token(SECONDS);
interval = interval.multiply(new BigDecimal(1000L));
      break;
      }
    case MILLISECONDS:{
      jj_consume_token(MILLISECONDS);
      break;
      }
    default:
      jj_la1[303] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return getNumericNode(String.valueOf(interval), true);}
    throw new Error("Missing return statement in function");
  }

  final public void syncOrAsyncAttribute(AttributesFactory afact) throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case SYNCHRONOUS:{
if(this.prevPersistenceModeSet != null)
   {
      {if (true) throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR, "Disk persistence mode already set to "
      + (this.prevPersistenceModeSet.equals("true")?"Synchronous":"Asynchronous"));}
   }
      jj_consume_token(SYNCHRONOUS);
this.prevPersistenceModeSet ="true";
                afact.setDiskSynchronous(true);
      break;
      }
    case ASYNCHRONOUS:{
if(this.prevPersistenceModeSet != null)
     {
        {if (true) throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR, "Disk persistence mode already set to "
        + (this.prevPersistenceModeSet.equals("true")?"Synchronous":"Asynchronous"));}
     }
      jj_consume_token(ASYNCHRONOUS);
this.prevPersistenceModeSet ="false";
                afact.setDiskSynchronous(false);
      break;
      }
    default:
      jj_la1[304] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void diskStoreAttribs(Map otherAttribs) throws ParseException, StandardException {Token tok;
        ValueNode val;
        Token bool ;
    switch (jj_nt.kind) {
    case COMPACTIONTHRESHOLD:
    case TIMEINTERVAL:
    case WRITEBUFFERSIZE:
    case QUEUESIZE:
    case MAXLOGSIZE:{
      switch (jj_nt.kind) {
      case MAXLOGSIZE:{
        tok = jj_consume_token(MAXLOGSIZE);
        break;
        }
      case COMPACTIONTHRESHOLD:{
        tok = jj_consume_token(COMPACTIONTHRESHOLD);
        break;
        }
      case TIMEINTERVAL:{
        tok = jj_consume_token(TIMEINTERVAL);
        break;
        }
      case WRITEBUFFERSIZE:{
        tok = jj_consume_token(WRITEBUFFERSIZE);
        break;
        }
      case QUEUESIZE:{
        tok = jj_consume_token(QUEUESIZE);
        break;
        }
      default:
        jj_la1[305] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      val = intLiteral();
if (getIntValue(val) < 0)
          {
             {if (true) throw StandardException.newException(SQLState.LANG_INVALID_COLUMN_LENGTH,
                "Value "+getIntValue(val)+" is negative");}
          }
          addToMapAllowOnce(otherAttribs,tok.image,val);
      break;
      }
    case AUTOCOMPACT:
    case ALLOWFORCECOMPACTION:{
      switch (jj_nt.kind) {
      case AUTOCOMPACT:{
        tok = jj_consume_token(AUTOCOMPACT);
        break;
        }
      case ALLOWFORCECOMPACTION:{
        tok = jj_consume_token(ALLOWFORCECOMPACTION);
        break;
        }
      default:
        jj_la1[306] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      bool = booleanLiteral();
addToMapAllowOnce(otherAttribs,tok.image,bool.image);
      break;
      }
    default:
      jj_la1[307] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void autoCompaction(Map otherAttribs) throws ParseException, StandardException {Token tok1;
        Token tok2;
    tok1 = jj_consume_token(AUTOCOMPACT);
    tok2 = booleanLiteral();
addToMapAllowOnce(otherAttribs,tok1.image,tok2.image);
  }

  final public void expirationDefinition(AttributesFactory afact) throws ParseException, StandardException {int expirationKind;
        ExpirationAttributes[] exprAttrs = new ExpirationAttributes[1];
    expirationKind = expirationKindDefinition(exprAttrs);
switch (expirationKind) {
                    // Only allow these to be set once - if already set, throw error
                    // using a static flag instead of creating attributes from factory
                    // because all valid settings for attributes in the factory
                    // may not currently exist (DDL clauses for CREATE TABLE can appear
                    // in any order). We need to catch these errors outside of Gemfire
                    // layer in order to throw an understandable SQL error.
                        case GfxdAttributesMutator.EXPIRE_REGION_TIMETOLIVE:
                            if (expirationFlag == 1)
                            {
                                         {if (true) throw StandardException.newException(SQLState.LANG_DUPLICATE_PROPERTY, "TABLE TIME TO LIVE");}
                            }
                                afact.setRegionTimeToLive(exprAttrs[0]);
                                expirationFlag = 1;
                                break;
                        case GfxdAttributesMutator.EXPIRE_REGION_IDLETIME:
                            if (expirationFlag == 2)
                            {
                                         {if (true) throw StandardException.newException(SQLState.LANG_DUPLICATE_PROPERTY, "TABLE IDLETIME");}
                            }
                                afact.setRegionIdleTimeout(exprAttrs[0]);
                                expirationFlag = 2;
                                break;
                        case GfxdAttributesMutator.EXPIRE_ENTRY_TIMETOLIVE:
                            if (expirationFlag == 3)
                            {
                                         {if (true) throw StandardException.newException(SQLState.LANG_DUPLICATE_PROPERTY, "ENTRY TIME TO LIVE");}
                            }
                                afact.setEntryTimeToLive(exprAttrs[0]);
                                expirationFlag = 3;
                                break;
                        case GfxdAttributesMutator.EXPIRE_ENTRY_IDLETIME:
                            if (expirationFlag == 4)
                            {
                                         {if (true) throw StandardException.newException(SQLState.LANG_DUPLICATE_PROPERTY, "ENTRY IDLETIME");}
                            }
                                afact.setEntryIdleTimeout(exprAttrs[0]);
                                expirationFlag = 4;
                                break;
                }
  }

  final public int expirationKindDefinition(ExpirationAttributes[] exprAttrs) throws ParseException, StandardException {int expirationKind;
        int duration;
        ExpirationAttributes exprAttr;
        ExpirationAction action;
    jj_consume_token(EXPIRE);
    switch (jj_nt.kind) {
    case TABLE:{
      jj_consume_token(TABLE);
      jj_consume_token(WITH);
      switch (jj_nt.kind) {
      case TIMETOLIVE:{
        jj_consume_token(TIMETOLIVE);
        duration = simpleValueSpecification_int();
        action = expirationActionDefinition();
expirationKind = GfxdAttributesMutator.EXPIRE_REGION_TIMETOLIVE;
        break;
        }
      case IDLETIME:{
        jj_consume_token(IDLETIME);
        duration = simpleValueSpecification_int();
        action = expirationActionDefinition();
expirationKind = GfxdAttributesMutator.EXPIRE_REGION_IDLETIME;
        break;
        }
      default:
        jj_la1[308] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case ENTRY:{
      jj_consume_token(ENTRY);
      jj_consume_token(WITH);
      switch (jj_nt.kind) {
      case TIMETOLIVE:{
        jj_consume_token(TIMETOLIVE);
        duration = simpleValueSpecification_int();
        action = expirationActionDefinition();
expirationKind = GfxdAttributesMutator.EXPIRE_ENTRY_TIMETOLIVE;
        break;
        }
      case IDLETIME:{
        jj_consume_token(IDLETIME);
        duration = simpleValueSpecification_int();
        action = expirationActionDefinition();
expirationKind = GfxdAttributesMutator.EXPIRE_ENTRY_IDLETIME;
        break;
        }
      default:
        jj_la1[309] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[310] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
exprAttrs[0] = new ExpirationAttributes(duration, action);
                {if ("" != null) return expirationKind;}
    throw new Error("Missing return statement in function");
  }

  final public ExpirationAction expirationActionDefinition() throws ParseException, StandardException {ExpirationAction action;
    jj_consume_token(ACTION);
    jj_consume_token(DESTROY);
action = ExpirationAction.DESTROY;
{if ("" != null) return action;}
    throw new Error("Missing return statement in function");
  }

  final public void persistenceDiskDefinition(AttributesFactory afact, boolean[] repPartPersFlags) throws ParseException, StandardException {CharConstantNode strNode = null;
    jj_consume_token(PERSISTENT);
    label_50:
    while (true) {
      switch (jj_nt.kind) {
      case ASYNCHRONOUS:
      case SYNCHRONOUS:
      case STRING:{
        ;
        break;
        }
      default:
        jj_la1[311] = jj_gen;
        break label_50;
      }
      switch (jj_nt.kind) {
      case STRING:{
        strNode = stringLiteral();
        break;
        }
      case ASYNCHRONOUS:
      case SYNCHRONOUS:{
        syncOrAsyncAttribute(afact);
        break;
        }
      default:
        jj_la1[312] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
repPartPersFlags[2] = true;
                if (strNode != null)
                {
                  if (prevDiskStore != null)
                  {
                    {if (true) throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR,
                      "Disk Store '"+ prevDiskStore + "' already set");}
                  }
                  prevDiskStore = strNode.getString();
                  afact.setDiskStoreName(StringUtil.SQLToUpperCase(prevDiskStore));
                }
                else
                {
                  afact.setDiskStoreName(GfxdConstants.GFXD_DEFAULT_DISKSTORE_NAME);
                }
  }

  final public void persistenceHDFSDefinition(AttributesFactory afact, boolean[] repPartPersFlags) throws ParseException, StandardException {String hdfsStoreName, prevHDFSStore = null;
    jj_consume_token(HDFSSTORE);
    jj_consume_token(LEFT_PAREN);
    hdfsStoreName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
    jj_consume_token(RIGHT_PAREN);
repPartPersFlags[5] = true;
                if (hdfsStoreName != null) {
                  if (prevHDFSStore != null) {
                    {if (true) throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR,
                      "HDFS Store '"+ prevHDFSStore +"' already set");}
                  }
                  prevHDFSStore = hdfsStoreName;
                  afact.setHDFSStoreName(hdfsStoreName);
                }
    switch (jj_nt.kind) {
    case WRITEONLY:{
      jj_consume_token(WRITEONLY);
afact.setHDFSWriteOnly(true);
      break;
      }
    default:
      jj_la1[313] = jj_gen;
      ;
    }
  }

  final public void gatewaySenderRegionDefinition(AttributesFactory afact) throws ParseException, StandardException {String gatewayId;
   CharConstantNode strNode = null;
   boolean isAsyncListener;
    switch (jj_nt.kind) {
    case GATEWAYSENDER:{
      jj_consume_token(GATEWAYSENDER);
isAsyncListener = false;
      break;
      }
    case ASYNCLISTENER:{
      jj_consume_token(ASYNCLISTENER);
isAsyncListener = true;
      break;
      }
    default:
      jj_la1[314] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LEFT_PAREN);
    gatewayId = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
afact.setEnableGateway(true);
          if (isAsyncListener) {
            afact.addAsyncEventQueueId(gatewayId);
          }
          else {
            afact.addGatewaySenderId(gatewayId);
          }
    label_51:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[315] = jj_gen;
        break label_51;
      }
      jj_consume_token(COMMA);
      gatewayId = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
if (isAsyncListener) {
              afact.addAsyncEventQueueId(gatewayId);
            }
            else {
              afact.addGatewaySenderId(gatewayId);
            }
    }
    jj_consume_token(RIGHT_PAREN);
  }

  final public void concurrencyLevelDefinition(AttributesFactory afact) throws ParseException, StandardException {int level;
    jj_consume_token(CONCURRENCY);
    jj_consume_token(LEVEL);
    level = simpleValueSpecification_int();
afact.setConcurrencyLevel(level);
  }

  final public void memScaleDefinition(AttributesFactory afact) throws ParseException, StandardException {
    jj_consume_token(OFFHEAP);
if (!ServerGroupUtils.isDataStore()) {
                afact.setEnableOffHeapMemory(false);
          }
          else {
                afact.setEnableOffHeapMemory(true);
          }
  }

  final public void concurrencyChecksDefinition(AttributesFactory afact) throws ParseException, StandardException {
    jj_consume_token(ENABLE);
    jj_consume_token(CONCURRENCY);
    jj_consume_token(CHECKS);
afact.setConcurrencyChecksEnabled(true);
  }

// GemStone changes END
  final public 
ResultColumnList tableColumnList() throws ParseException, StandardException {ResultColumnList resultColumns = (ResultColumnList) nodeFactory.getNode(
                                                                                        C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                        getContextManager());
    columnNameList(resultColumns);
{if ("" != null) return resultColumns;}
    throw new Error("Missing return statement in function");
  }

/*
 * This method is called when a comment starting with --gemfirexd-properties is found.
 * Such a comment is a special directive to Derby and allows a sql to pass optimizer
 * overrides. Derby looks for propertyName=value [,propertyName=value]* after
 * --gemfirexd-properties and returns these properties in a Properties object as a return 
 * value of this method.
 * The param propertiesUseAllowed true indicates that users are allowed to 
 * specify optimizer overrides in the given context. 
 * False means optimizer overrides in the given context are allowed internally 
 * only eg impl/load/import.java specifies property insertMode=replace/bulkInsert
 * in the insert statement. This same property will not be acceptable from an 
 * insert statement from a user sql.
 */
  final public Properties propertyList(boolean propertiesUseAllowed) throws ParseException, StandardException {Properties properties = new FormatableProperties();
        StringTokenizer commaSeparatedProperties;
        StringTokenizer equalOperatorSeparatedProperty;
    jj_consume_token(GEMFIREXDDASHPROPERTIES);
//first use StringTokenizer to get tokens which are delimited by ,s
                commaSeparatedProperties = new StringTokenizer(getToken(1).image,",");
                while (commaSeparatedProperties.hasMoreTokens()) {
                        //Now verify that tokens delimited by ,s follow propertyName=value pattern
                        String currentProperty = commaSeparatedProperties.nextToken();
                        equalOperatorSeparatedProperty = new StringTokenizer(currentProperty,"=", true);
                        if (equalOperatorSeparatedProperty.countTokens() != 3)
                                {if (true) throw StandardException.newException(SQLState.PROPERTY_SYNTAX_INVALID);}
                        else {
                                String key = equalOperatorSeparatedProperty.nextToken().trim();
                                if (!equalOperatorSeparatedProperty.nextToken().equals("="))
                                        {if (true) throw StandardException.newException(SQLState.PROPERTY_SYNTAX_INVALID);}
                                String value = equalOperatorSeparatedProperty.nextToken().trim();
                                verifyImageLength(value);
                                /* Trim off the leading and trailing ', and compress all '' to ' */
                                if (value.startsWith("'") && value.endsWith("'"))
                                        value = compressQuotes(value.substring(1, value.length() - 1), SINGLEQUOTES);
                                /* Trim off the leading and trailing ", and compress all "" to " */
                                else if (value.startsWith("\"") && value.endsWith("\""))
                                        value = compressQuotes(value.substring(1, value.length() - 1), DOUBLEQUOTES);
                                // GemStone changes BEGIN
                                // don't alter the value to upperCase as sizerHints are enumerations.
                                // and statementAlias is user defined.
                                else if (key.equals(Constants.QueryHints.sizerHints.name())
                                      || key.equals(Constants.QueryHints.statementAlias.name()))
                                {
                                        value = value.trim();
                                }
                                // GemStone changes END
                                else
                                        value = value.toUpperCase();
                                // Do not allow user to specify multiple values for the same key
                                if (properties.put(key, value) != null)
                                {
                                        {if (true) throw StandardException.newException(SQLState.LANG_DUPLICATE_PROPERTY, key);}
                                }
                }
        }
        //if this property override is supported in internal mode only, then do that verification here.
        if (!propertiesUseAllowed)
                checkInternalFeature("GEMFIREXD-PROPERTIES");
        {if ("" != null) return properties;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="DB2lockGranularityClause">DB2lockGranularityClause</A>
 */
  final public char DB2lockGranularityClause() throws ParseException, StandardException {char lockGranularity;
    jj_consume_token(LOCKSIZE);
    lockGranularity = lockGranularity();
{if ("" != null) return lockGranularity;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="lockGranularity">lockGranularity</A>
 */
  final public char lockGranularity() throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case TABLE:{
      jj_consume_token(TABLE);
{if ("" != null) return TableDescriptor.TABLE_LOCK_GRANULARITY;}
      break;
      }
    case ROW:{
      jj_consume_token(ROW);
{if ("" != null) return TableDescriptor.ROW_LOCK_GRANULARITY;}
      break;
      }
    default:
      jj_la1[316] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="indexDefinition">indexDefinition</A>
 */
  final public StatementNode indexDefinition() throws ParseException, StandardException {Boolean         unique = Boolean.FALSE;
// GemStone changes BEGIN
        boolean         globalHash = false;
// GemStone changes END
        Properties      properties = null;
        TableName       indexName;
        TableName       tableName;
        Vector  indexColumnList = new Vector();
    switch (jj_nt.kind) {
    case GLOBAL:
    case UNIQUE:{
      switch (jj_nt.kind) {
      case UNIQUE:{
        unique = unique();
        break;
        }
      case GLOBAL:{
        jj_consume_token(GLOBAL);
        jj_consume_token(HASH);
globalHash = true;
        break;
        }
      default:
        jj_la1[317] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[318] = jj_gen;
      ;
    }
    jj_consume_token(INDEX);
    indexName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    jj_consume_token(ON);
    tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    jj_consume_token(LEFT_PAREN);
    indexColumnList(indexColumnList, globalHash);
    jj_consume_token(RIGHT_PAREN);
    switch (jj_nt.kind) {
    case GEMFIREXDDASHPROPERTIES:{
      properties = propertyList(true);
      jj_consume_token(CHECK_PROPERTIES);
      break;
      }
    default:
      jj_la1[319] = jj_gen;
      ;
    }
/* User allowed to specify schema name on table and index.
		 * If no schema name specified for index, then it "inherits" 
		 * its schema name from the table.
		 * If index has a schema name and table does not, then
		 * table "inherits" its schema name from the index.
		 * If schema names are specified for both objects, then the
		 * schema names must be the same.
		 */
                if (indexName.getSchemaName() == null)
                {
                        indexName.setSchemaName(tableName.getSchemaName());
                }
                else if (tableName.getSchemaName() == null)
                {
                        tableName.setSchemaName(indexName.getSchemaName());
                }
                else
                {
                        /* schema name specified for both */
                        if (! (indexName.getSchemaName().equals(
                                                tableName.getSchemaName())))
                        {
                                {if (true) throw StandardException.newException(SQLState.LANG_INDEX_AND_TABLE_IN_DIFFERENT_SCHEMAS,
                                                        indexName,
                                                        tableName);}
                        }
                }
                {if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.CREATE_INDEX_NODE,
                                                                unique,
// GemStone changes BEGIN
                                                                globalHash ? GfxdConstants.GLOBAL_HASH_INDEX_TYPE
                                                                  : DEFAULT_INDEX_TYPE,
                                                                /* DEFAULT_INDEX_TYPE, */
// GemStone changes END
                                                                indexName,
                                                                tableName,
                                                                indexColumnList,
                                                                properties,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="unique">unique</A>
 */
  final public Boolean unique() throws ParseException, StandardException {
    jj_consume_token(UNIQUE);
{if ("" != null) return Boolean.TRUE;}
    throw new Error("Missing return statement in function");
  }

/**
	CREATE PROCEDURE

	procedureElements contains the description of the procedure.
	(CREATE FUNCTIONS shares this lyout), see functionDefinition

	0 - Object[] 3 element array for parameters
	1 - TableName - specific name
	2 - Integer - dynamic result set count
	3 - String language (always java) - ignore
	4 - String external name (also passed directly to create alias node - ignore
	5 - Short parameter style (always java) - ignore 
	6 - Short - SQL allowed.
	7 - Boolean - CALLED ON NULL INPUT (always TRUE for procedures)
	8 - TypeDescriptor - return type (always NULL for procedures)
*/
  final public 
StatementNode procedureDefinition() throws ParseException, StandardException {TableName procedureName;
        Object[] procedureElements = new Object[9];
    jj_consume_token(PROCEDURE);
    procedureName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    procedureElements[0] = procedureParameterList();
    label_52:
    while (true) {
      routineElement(true, false, procedureElements);
      switch (jj_nt.kind) {
      case EXTERNAL:
      case NO:
      case CALLED:
      case CONTAINS:
      case DYNAMIC:
      case LANGUAGE:
      case MODIFIES:
      case RETURNS:
      case PARAMETER:
      case READS:
      case RESULT:
      case SPECIFIC:{
        ;
        break;
        }
      default:
        jj_la1[320] = jj_gen;
        break label_52;
      }
    }
checkRequiredRoutineClause(JAVA_ROUTINE_CLAUSES, procedureElements);

                        {if ("" != null) return getCreateAliasNode(
                                                        procedureName,
                                                        (String) procedureElements[4],
                                                        procedureElements,
                                                        AliasInfo.ALIAS_TYPE_PROCEDURE_AS_CHAR,
                                                        Boolean.FALSE);}
    throw new Error("Missing return statement in function");
  }

  final public void routineElement(boolean isProcedure, boolean isTableFunction, Object[] routineElements) throws ParseException, StandardException {int drs;
        int clausePosition = -1;
        Object clauseValue = null;
    switch (jj_nt.kind) {
    case SPECIFIC:{
      jj_consume_token(SPECIFIC);
      clauseValue = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
clausePosition = 1; {if (true) throw StandardException.newException(SQLState.NOT_IMPLEMENTED, "SPECIFIC identifier");}
      break;
      }
    case DYNAMIC:
    case RESULT:{
      switch (jj_nt.kind) {
      case DYNAMIC:{
        jj_consume_token(DYNAMIC);
        break;
        }
      default:
        jj_la1[321] = jj_gen;
        ;
      }
      jj_consume_token(RESULT);
      jj_consume_token(SETS);
      drs = uint_value();
if (!isProcedure)
                                {if (true) throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR, "RESULT SETS");}
                        clauseValue = ReuseFactory.getInteger(drs); clausePosition = 2;
      break;
      }
    case LANGUAGE:{
      jj_consume_token(LANGUAGE);
      jj_consume_token(JAVA);
clauseValue = "JAVA"; clausePosition = 3;
      break;
      }
    case EXTERNAL:{
      jj_consume_token(EXTERNAL);
      jj_consume_token(NAME);
      clauseValue = string();
clausePosition = 4;
      break;
      }
    case PARAMETER:{
      jj_consume_token(PARAMETER);
      jj_consume_token(STYLE);
      clauseValue = parameterStyle(isTableFunction);
clausePosition = 5;
      break;
      }
    case NO:{
      jj_consume_token(NO);
      jj_consume_token(SQL);
clauseValue = ReuseFactory.getShort(RoutineAliasInfo.NO_SQL); clausePosition = 6;
      break;
      }
    case CONTAINS:{
      jj_consume_token(CONTAINS);
      jj_consume_token(SQL);
clauseValue = ReuseFactory.getShort(RoutineAliasInfo.CONTAINS_SQL); clausePosition = 6;
      break;
      }
    case READS:{
      jj_consume_token(READS);
      jj_consume_token(SQL);
      jj_consume_token(DATA);
clauseValue = ReuseFactory.getShort(RoutineAliasInfo.READS_SQL_DATA); clausePosition = 6;
      break;
      }
    case MODIFIES:{
      jj_consume_token(MODIFIES);
      jj_consume_token(SQL);
      jj_consume_token(DATA);
if (!isProcedure)
                                {if (true) throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR, "MODIFIES SQL DATA");}
                        clauseValue = ReuseFactory.getShort(RoutineAliasInfo.MODIFIES_SQL_DATA); clausePosition = 6;
      break;
      }
    case CALLED:
    case RETURNS:{
      clauseValue = calledOnNullInput(isProcedure);
clausePosition = 7;
      break;
      }
    default:
      jj_la1[322] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (clausePosition != -1) {
                        // check for repeated clause
                        if (routineElements[clausePosition] != null) {

                                String which = ROUTINE_CLAUSE_NAMES[clausePosition];
                                {if (true) throw StandardException.newException(SQLState.LANG_DB2_MULTIPLE_ELEMENTS, which);}
                        }

                        routineElements[clausePosition] = clauseValue;
                }
  }

  final public Boolean calledOnNullInput(boolean isProcedure) throws ParseException, StandardException {Boolean calledOnNull;
    switch (jj_nt.kind) {
    case CALLED:{
      jj_consume_token(CALLED);
calledOnNull = Boolean.TRUE;
      break;
      }
    case RETURNS:{
      jj_consume_token(RETURNS);
      jj_consume_token(NULL);
if (isProcedure)
                     {if (true) throw StandardException.newException(SQLState.LANG_SYNTAX_ERROR,
                             "RETURNS NULL ON NULL INPUT");}

                   calledOnNull = Boolean.FALSE;
      break;
      }
    default:
      jj_la1[323] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ON);
    jj_consume_token(NULL);
    jj_consume_token(INPUT);
{if ("" != null) return calledOnNull;}
    throw new Error("Missing return statement in function");
  }

  final public Short parameterStyle(boolean isTableFunction) throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case JAVA:{
      jj_consume_token(JAVA);
if ( isTableFunction )
              { {if (true) throw StandardException.newException( SQLState.LANG_MUST_BE_DJRS );} }

              {if ("" != null) return ReuseFactory.getShort(RoutineAliasInfo.PS_JAVA);}
      break;
      }
    case DERBY_JDBC_RESULT_SET:{
      jj_consume_token(DERBY_JDBC_RESULT_SET);
if ( !isTableFunction )
              { {if (true) throw StandardException.newException( SQLState.LANG_NO_DJRS );} }

              {if ("" != null) return ReuseFactory.getShort(RoutineAliasInfo.PS_DERBY_JDBC_RESULT_SET);}
      break;
      }
    default:
      jj_la1[324] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Object[] procedureParameterList() throws ParseException, StandardException {Vector[] list = new Vector[3];
        list[0] = new Vector(); // name
        list[1] = new Vector(); // type
        list[2] = new Vector(); // in/out

    jj_consume_token(LEFT_PAREN);
    if (jj_2_63(1)) {
      procedureParameterDefinition(list);
      label_53:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[325] = jj_gen;
          break label_53;
        }
        jj_consume_token(COMMA);
        procedureParameterDefinition(list);
      }
    } else {
      ;
    }
    jj_consume_token(RIGHT_PAREN);
{if ("" != null) return list;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="Definition">procedureParameterDefinition</A>
 */
  final public void procedureParameterDefinition(Vector[] list) throws ParseException, StandardException {DataTypeDescriptor      typeDescriptor;
        String                          parameterName = "";
        Integer                         inout;
    inout = inoutParameter();
    if (dataTypeCheck(2)) {
      parameterName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
    } else {
      ;
    }
    typeDescriptor = dataTypeDDL();
list[0].addElement(parameterName);
                list[1].addElement(typeDescriptor.getCatalogType());
                list[2].addElement(inout);
  }

  final public Integer inoutParameter() throws ParseException {int mode = JDBC30Translation.PARAMETER_MODE_IN;
    switch (jj_nt.kind) {
    case IN:
    case INOUT:
    case OUT:{
      switch (jj_nt.kind) {
      case IN:{
        jj_consume_token(IN);

        break;
        }
      case OUT:{
        jj_consume_token(OUT);
mode = JDBC30Translation.PARAMETER_MODE_OUT;
        break;
        }
      case INOUT:{
        jj_consume_token(INOUT);
mode = JDBC30Translation.PARAMETER_MODE_IN_OUT;
        break;
        }
      default:
        jj_la1[326] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[327] = jj_gen;
      ;
    }
{if ("" != null) return ReuseFactory.getInteger(mode);}
    throw new Error("Missing return statement in function");
  }

/**
	CREATE FUNCTION

	functionElements contains the description of the function.

	0 - Object[] 3 element array for parameters
	1 - TableName - specific name
	2 - Integer - dynamic result set count - always 0
	3 - String language (always java) - required to be set
	4 - String external name (also passed directly to create alias node - ignore
	5 - Short parameter style (always java) - required to be set 
	6 - Short - SQL allowed.
	7 - Boolean - CALLED ON NULL INPUT
	8 - TypeDescriptor - return type
*/
  final public 
StatementNode functionDefinition() throws ParseException, StandardException {TableName functionName;
        TypeDescriptor  returnType;
        Object[] functionElements = new Object[9];
    jj_consume_token(FUNCTION);
    functionName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    functionElements[0] = functionParameterList();
    jj_consume_token(RETURNS);
    returnType = functionReturnDataType();
    label_54:
    while (true) {
      routineElement(false, returnType.isRowMultiSet(), functionElements);
      switch (jj_nt.kind) {
      case EXTERNAL:
      case NO:
      case CALLED:
      case CONTAINS:
      case DYNAMIC:
      case LANGUAGE:
      case MODIFIES:
      case RETURNS:
      case PARAMETER:
      case READS:
      case RESULT:
      case SPECIFIC:{
        ;
        break;
        }
      default:
        jj_la1[328] = jj_gen;
        break label_54;
      }
    }
functionElements[8] = returnType;
                    checkRequiredRoutineClause(JAVA_ROUTINE_CLAUSES, functionElements);

                        {if ("" != null) return getCreateAliasNode(
                                                        functionName,
                                                        (String) functionElements[4],
                                                        functionElements,
                                                        AliasInfo.ALIAS_TYPE_FUNCTION_AS_CHAR,
                                                        Boolean.FALSE);}
    throw new Error("Missing return statement in function");
  }

  final public Object[] functionParameterList() throws ParseException, StandardException {Vector[] list = new Vector[3];
        list[0] = new Vector(); // name
        list[1] = new Vector(); // type
        list[2] = new Vector(); // in/out - ALWAYS IN

    jj_consume_token(LEFT_PAREN);
    if (jj_2_64(1)) {
      functionParameterDefinition(list);
      label_55:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[329] = jj_gen;
          break label_55;
        }
        jj_consume_token(COMMA);
        functionParameterDefinition(list);
      }
    } else {
      ;
    }
    jj_consume_token(RIGHT_PAREN);
{if ("" != null) return list;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="Definition">functionParameterDefinition</A>
 */
  final public void functionParameterDefinition(Vector[] list) throws ParseException, StandardException {DataTypeDescriptor      typeDescriptor;
        String                          parameterName = "";
    if (dataTypeCheck(2)) {
      parameterName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
    } else {
      ;
    }
    typeDescriptor = dataTypeDDL();
list[0].addElement(parameterName);
                list[1].addElement(typeDescriptor.getCatalogType());
                list[2].addElement(ReuseFactory.getInteger(JDBC30Translation.PARAMETER_MODE_IN));
  }

/*
 * <A NAME="functionReturnDataType">functionReturnDataType</A>
 */
  final public TypeDescriptor functionReturnDataType() throws ParseException, StandardException {TypeDescriptor      typeDescriptor;
    if (jj_2_65(1)) {
      typeDescriptor = catalogType();
    } else {
      switch (jj_nt.kind) {
      case TABLE:{
        typeDescriptor = functionTableType();
        break;
        }
      default:
        jj_la1[330] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return typeDescriptor;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="functionTableType">functionTableType</A>
 */
  final public TypeDescriptor functionTableType() throws ParseException, StandardException {ArrayList                       names = new ArrayList();
        ArrayList                         types = new ArrayList();
        String[]                          nameArray;
        TypeDescriptor[]        typeArray;
        int                                     columnCount;
    jj_consume_token(TABLE);
    jj_consume_token(LEFT_PAREN);
    functionTableReturnColumn(names, types);
    label_56:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[331] = jj_gen;
        break label_56;
      }
      jj_consume_token(COMMA);
      functionTableReturnColumn(names, types);
    }
    jj_consume_token(RIGHT_PAREN);
checkVersion( DataDictionary.DD_VERSION_DERBY_10_4, "CREATE FUNCTION...RETURNS TABLE");

                columnCount = names.size();
                nameArray = new String[ columnCount ];
                names.toArray( nameArray );
                typeArray = new TypeDescriptor[ columnCount ];
                types.toArray( typeArray );

                //
                // We do not allow XML as a column datatype because
                // Derby does not yet support the streaming JDBC4
                // interfaces to XML values.
                //
                for ( int i = 0; i < columnCount; i++ )
                {
                    if ( typeArray[ i ].getJDBCTypeId() == JDBC40Translation.SQLXML )
                    { {if (true) throw StandardException.newException( SQLState.LANG_XML_NOT_ALLOWED_DJRS );} }
                }

                {if ("" != null) return DataTypeDescriptor.getRowMultiSet( nameArray, typeArray );}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="functionTableReturnColumn">functionTableReturnColumn</A>
 */
  final public void functionTableReturnColumn(ArrayList names,
    ArrayList types) throws ParseException, StandardException {String                          name;
        DataTypeDescriptor      typeDescriptor;
    name = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
    typeDescriptor = dataTypeDDL();
names.add( name );
                types.add( typeDescriptor.getCatalogType() );
  }

/**
	CREATE TYPE
*/
  final public 
StatementNode udtDefinition() throws ParseException, StandardException {TableName udtName;
        String externalName;
    jj_consume_token(TYPE);
    udtName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    jj_consume_token(EXTERNAL);
    jj_consume_token(NAME);
    externalName = string();
    jj_consume_token(LANGUAGE);
    jj_consume_token(JAVA);
checkVersion(DataDictionary.DD_VERSION_DERBY_10_4, "CREATE TYPE");
                        {if ("" != null) return getCreateAliasNode(
                                                        udtName,
                                                        externalName,
                                                        null,
                                                        AliasInfo.ALIAS_TYPE_UDT_AS_CHAR,
                                                        Boolean.FALSE);}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode viewDefinition(Token beginToken) throws ParseException, StandardException {int                                     checkOptionType;
        ResultColumnList        resultColumns = null;
        ResultSetNode           queryExpression;
        TableName                       tableName;
        Token                           checkTok = null;
        Token                           endToken;
    jj_consume_token(VIEW);
    tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    switch (jj_nt.kind) {
    case LEFT_PAREN:{
      jj_consume_token(LEFT_PAREN);
      resultColumns = viewColumnList();
      jj_consume_token(RIGHT_PAREN);
      break;
      }
    default:
      jj_la1[332] = jj_gen;
      ;
    }
    jj_consume_token(AS);
    queryExpression = queryExpression(null, NO_SET_OP);
checkOptionType = ViewDescriptor.NO_CHECK_OPTION;
                endToken = getToken(0);
                /* Parameters not allowed in create view */
                HasNodeVisitor visitor = new HasNodeVisitor(ParameterNode.class);
                queryExpression.accept(visitor);
                if (visitor.hasNode())
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_NO_PARAMS_IN_VIEWS);}
                }

                {if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.CREATE_VIEW_NODE,
                                                                tableName,
                                                                resultColumns,
                                                                queryExpression,
                                                                ReuseFactory.getInteger(checkOptionType),
                                                                StringUtil.slice(statementSQLText,
                                                                                                beginToken.beginOffset,
                                                                                                endToken.endOffset,false),
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public ResultColumnList viewColumnList() throws ParseException, StandardException {ResultColumnList        resultColumns = (ResultColumnList) nodeFactory.getNode(
                                                                                        C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                        getContextManager());
    columnNameList(resultColumns);
{if ("" != null) return resultColumns;}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode triggerDefinition() throws ParseException, StandardException {Boolean                         isBefore;
        Boolean                         isRow = Boolean.FALSE;  // STATEMENT implicit by default
        TableName                       tableName;
        TableName                       triggerName;
        Token[]                         tokenHolder = new Token[1];
        Token                           beginToken;
        Token                           checkTok = null;
        Token                           endToken;
        int                                     actionBegin;
        int                                     actionEnd;
        int                                     triggerEvent;
        QueryTreeNode           actionNode;
        ResultColumnList        triggerColumns = (ResultColumnList) nodeFactory.getNode(
                                                                                        C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                        getContextManager());
        Vector                          refClause = null;
    jj_consume_token(TRIGGER);
    triggerName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    isBefore = beforeOrAfter();
    triggerEvent = triggerEvent(triggerColumns);
    jj_consume_token(ON);
    tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    switch (jj_nt.kind) {
    case REFERENCING:{
      refClause = triggerReferencingClause();
      break;
      }
    default:
      jj_la1[333] = jj_gen;
      ;
    }
    switch (jj_nt.kind) {
    case FOR:{
      jj_consume_token(FOR);
      jj_consume_token(EACH);
      isRow = rowOrStatement();
      break;
      }
    default:
      jj_la1[334] = jj_gen;
      ;
    }
    switch (jj_nt.kind) {
    case MODE:{
      jj_consume_token(MODE);
      jj_consume_token(DB2SQL);
      break;
      }
    default:
      jj_la1[335] = jj_gen;
      ;
    }
    //we are not top level statement
                    actionNode = proceduralStatement(tokenHolder);
//Gemstone changes BEGIN
      if (!isRow)
      {
        {if (true) throw StandardException.newException(SQLState.NOT_IMPLEMENTED,
          "Statement triggers not supported yet");}
      }
      //Gemstone changes END
                actionEnd = getToken(0).endOffset;
                actionBegin = tokenHolder[0].beginOffset;

                // No DML in action node for BEFORE triggers.
                if (isBefore.booleanValue() && (actionNode instanceof DMLModStatementNode)) {
                                {if (true) throw StandardException.newException(
                                        SQLState.LANG_UNSUPPORTED_TRIGGER_STMT,
                                        ((StatementNode) actionNode).statementToString(), "BEFORE");}
                                        }


                // no params in trigger action
                HasNodeVisitor visitor = new HasNodeVisitor(ParameterNode.class);
                actionNode.accept(visitor);
                if (visitor.hasNode())
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_NO_PARAMS_IN_TRIGGER_ACTION);}
                }

                {if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.CREATE_TRIGGER_NODE,
                                                                triggerName,
                                                                tableName,
                                                                ReuseFactory.getInteger(triggerEvent),
                                                                triggerColumns,
                                                                isBefore,
                                                                isRow,
                                                                Boolean.TRUE,                           // enabled
                                                                refClause,                      // referencing clause
                                                                null,// when clause node
                                                                null,           // when clause text
                                                                ReuseFactory.getInteger(0),
                                                                                        // when clause begin offset
                                                                actionNode,
                                                                StringUtil.slice(statementSQLText,
                                                                        actionBegin,
                                                                        actionEnd,false),
                                                                ReuseFactory.getInteger(actionBegin),
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode synonymDefinition() throws ParseException, StandardException {TableName synonymName;
        TableName targetName;
    jj_consume_token(SYNONYM);
    synonymName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    jj_consume_token(FOR);
    targetName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
checkVersion(DataDictionary.DD_VERSION_DERBY_10_1,
                             "CREATE SYNONYM");

                {if ("" != null) return  (StatementNode) getNodeFactory().getCreateAliasNode
                        (
                                synonymName,
                                targetName,
                                null,
                                AliasInfo.ALIAS_TYPE_SYNONYM_AS_CHAR,
                                Boolean.FALSE,
                                getContextManager()
                        );}
    throw new Error("Missing return statement in function");
  }

//Gemstone changes Begin
  final public 
StatementNode aliasDefinition() throws ParseException, StandardException {TableName aliasName;
        String targetName;
    jj_consume_token(ALIAS);
    aliasName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    jj_consume_token(FOR);
    targetName = string();
checkVersion(DataDictionary.DD_VERSION_DERBY_10_1,
                             "CREATE ALIAS");

                {if ("" != null) return  (StatementNode) getNodeFactory().getCreateAliasNode
                        (
                                aliasName,
                                targetName,
                                null,
                                AliasInfo.ALIAS_TYPE_RESULT_PROCESSOR_AS_CHAR,
                                Boolean.FALSE,
                                getContextManager()
                        );}
    throw new Error("Missing return statement in function");
  }

//Gemstone changes End
  final public 
Boolean beforeOrAfter() throws ParseException {
    switch (jj_nt.kind) {
    case NO:{
      jj_consume_token(NO);
      jj_consume_token(CASCADE);
      jj_consume_token(BEFORE);
{if ("" != null) return Boolean.TRUE;}
      break;
      }
    case AFTER:{
      jj_consume_token(AFTER);
{if ("" != null) return Boolean.FALSE;}
      break;
      }
    default:
      jj_la1[336] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public int triggerEvent(ResultColumnList rcl) throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case INSERT:{
      jj_consume_token(INSERT);
{if ("" != null) return TriggerDescriptor.TRIGGER_EVENT_INSERT;}
      break;
      }
    case DELETE:{
      jj_consume_token(DELETE);
{if ("" != null) return TriggerDescriptor.TRIGGER_EVENT_DELETE;}
      break;
      }
    case UPDATE:{
      jj_consume_token(UPDATE);
      switch (jj_nt.kind) {
      case OF:{
        jj_consume_token(OF);
        columnNameList(rcl);
        break;
        }
      default:
        jj_la1[337] = jj_gen;
        ;
      }
{if ("" != null) return TriggerDescriptor.TRIGGER_EVENT_UPDATE;}
      break;
      }
    default:
      jj_la1[338] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Boolean rowOrStatement() throws ParseException {
    switch (jj_nt.kind) {
    case ROW:{
      token = jj_consume_token(ROW);
{if ("" != null) return Boolean.TRUE;}
      break;
      }
    case STATEMENT:{
      token = jj_consume_token(STATEMENT);
{if ("" != null) return Boolean.FALSE;}
      break;
      }
    default:
      jj_la1[339] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Vector triggerReferencingClause() throws ParseException, StandardException {Vector vector = new Vector();
    jj_consume_token(REFERENCING);
    triggerReferencingExpression(vector);
    label_57:
    while (true) {
      switch (jj_nt.kind) {
      case NEW:
      case NEW_TABLE:
      case OLD:
      case OLD_TABLE:{
        ;
        break;
        }
      default:
        jj_la1[340] = jj_gen;
        break label_57;
      }
      triggerReferencingExpression(vector);
    }
{if ("" != null) return vector;}
    throw new Error("Missing return statement in function");
  }

  final public void triggerReferencingExpression(Vector vector) throws ParseException, StandardException {String  identifier;
        boolean isNew = true;
        boolean isRow = true;
    switch (jj_nt.kind) {
    case NEW:{
      jj_consume_token(NEW);
      switch (jj_nt.kind) {
      case TABLE:
      case ROW:{
        switch (jj_nt.kind) {
        case ROW:{
          jj_consume_token(ROW);
          break;
          }
        case TABLE:{
          jj_consume_token(TABLE);
isRow = false;
          break;
          }
        default:
          jj_la1[341] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[342] = jj_gen;
        ;
      }
      break;
      }
    case OLD:{
      jj_consume_token(OLD);
isNew = false;
      switch (jj_nt.kind) {
      case TABLE:
      case ROW:{
        switch (jj_nt.kind) {
        case ROW:{
          jj_consume_token(ROW);
          break;
          }
        case TABLE:{
          jj_consume_token(TABLE);
isRow = false;
          break;
          }
        default:
          jj_la1[343] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[344] = jj_gen;
        ;
      }
      break;
      }
    case NEW_TABLE:{
      jj_consume_token(NEW_TABLE);
isRow = false;
      break;
      }
    case OLD_TABLE:{
      jj_consume_token(OLD_TABLE);
isNew = false; isRow = false;
      break;
      }
    default:
      jj_la1[345] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(AS);
    identifier = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
vector.addElement(new TriggerReferencingStruct(isRow, isNew, identifier));
  }

/*
 * <A NAME="defaultClause">defaultClause</A>
 */
  final public ValueNode defaultClause(long[] autoIncrementInfo, String columnName) throws ParseException, StandardException {ValueNode       value;
        Token           beginToken;
        Token           endToken;
    switch (jj_nt.kind) {
    case _DEFAULT:
    case WITH:{
      switch (jj_nt.kind) {
      case WITH:{
        jj_consume_token(WITH);
        break;
        }
      default:
        jj_la1[346] = jj_gen;
        ;
      }
      beginToken = jj_consume_token(_DEFAULT);
      value = defaultOption(beginToken, autoIncrementInfo, columnName);
{if ("" != null) return value;}
      break;
      }
    case GENERATED:{
      value = generatedColumnOption(autoIncrementInfo,
                      columnName /* GemStoneAddition */);
{if ("" != null) return value;}
      break;
      }
    default:
      jj_la1[347] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="defaultNullOnlyClause">defaultNullOnlyClause</A>
 */
  final public ValueNode defaultNullOnlyClause() throws ParseException, StandardException {
    jj_consume_token(_DEFAULT);
    jj_consume_token(NULL);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.UNTYPED_NULL_CONSTANT_NODE,
                                                                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="generatedColumnOption">generatedColumnOption</A>
 */

//ToCleanUp
//A specific class not such long[] should exists for autoIncrementInfo ...
  final public 
ValueNode
// GemStone changes BEGIN
 generatedColumnOption(long[] autoIncrementInfo, String columnName) throws ParseException, StandardException {ValueNode       value = null;
autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_START_INDEX] = 1;
        autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_INC_INDEX] = 1;
        autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_IS_AUTOINCREMENT_INDEX] = 1;
        autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_CREATE_MODIFY] = ColumnDefinitionNode.CREATE_AUTOINCREMENT;
// GemStone changes BEGIN
        autoIncrementInfo[QueryTreeNode.HAS_AUTOINCREMENT_INC] = 0;
// GemStone changes END

    jj_consume_token(GENERATED);
    switch (jj_nt.kind) {
    case ALWAYS:{
      jj_consume_token(ALWAYS);
value = null;
      break;
      }
    case BY:{
      jj_consume_token(BY);
      jj_consume_token(_DEFAULT);
checkVersion(DataDictionary.DD_VERSION_DERBY_10_1,
                             "GENERATED BY DEFAULT");
                value = (ValueNode) nodeFactory.getNode(C_NodeTypes.DEFAULT_NODE,
                                                        getContextManager()) ;
                // GemStone changes BEGIN
                autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_IS_GENERATED_BY_DEFAULT] = 1;
            // GemStone changes END

      break;
      }
    default:
      jj_la1[348] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(AS);
    jj_consume_token(IDENTITY);
    switch (jj_nt.kind) {
    case LEFT_PAREN:{
      jj_consume_token(LEFT_PAREN);
      autoIncrementBeginEnd(autoIncrementInfo);
      jj_consume_token(RIGHT_PAREN);
      break;
      }
    default:
      jj_la1[349] = jj_gen;
      ;
    }
{if ("" != null) return value;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="autoIncrementBeginEnd">autoIncrementBeginEnd</A>
 */
  final public void autoIncrementBeginEnd(long[] autoIncrementInfo) throws ParseException, StandardException {long            autoIncrementInitial = 1;
        long            autoIncrementIncrement = 1;
    switch (jj_nt.kind) {
    case INCREMENT:{
      jj_consume_token(INCREMENT);
      jj_consume_token(BY);
      autoIncrementIncrement = exactNumber();
autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_INC_INDEX] = autoIncrementIncrement;
                autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_CREATE_MODIFY] = ColumnDefinitionNode.CREATE_AUTOINCREMENT;
// GemStone changes BEGIN
                autoIncrementInfo[QueryTreeNode.HAS_AUTOINCREMENT_INC] = 1;
                // GemFireXD does not currently support these clauses on a GENERATED ALWAYS column
                if (autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_IS_GENERATED_BY_DEFAULT] == 0)
        {
                {if (true) throw StandardException.newException(SQLState.NOT_IMPLEMENTED, "INCREMENT BY/START WITH not supported on GENERATED ALWAYS columns");}
        }

// GemStone changes END
                {if ("" != null) return;}
      break;
      }
    case START:{
      jj_consume_token(START);
      jj_consume_token(WITH);
      autoIncrementInitial = exactNumber();
      switch (jj_nt.kind) {
      case COMMA:{
        jj_consume_token(COMMA);
        jj_consume_token(INCREMENT);
        jj_consume_token(BY);
        autoIncrementIncrement = exactNumber();
autoIncrementInfo[QueryTreeNode.HAS_AUTOINCREMENT_INC] = 1;
        break;
        }
      default:
        jj_la1[350] = jj_gen;
        ;
      }
// GemFireXD does not currently support these clauses on a GENERATED ALWAYS column
        if (autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_IS_GENERATED_BY_DEFAULT] == 0)
        {
                {if (true) throw StandardException.newException(SQLState.NOT_IMPLEMENTED, "INCREMENT BY/START WITH not supported on GENERATED ALWAYS columns");}
        }
                autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_START_INDEX] = autoIncrementInitial;
                autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_INC_INDEX] = autoIncrementIncrement;
                autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_CREATE_MODIFY] = ColumnDefinitionNode.CREATE_AUTOINCREMENT;
                {if ("" != null) return;}
      break;
      }
    default:
      jj_la1[351] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * <A NAME="defaultOption">defaultOption</A>
 */
  final public ValueNode defaultOption(Token beginToken, long[] autoIncrementInfo,
        String columnName) throws ParseException, StandardException {Token           endToken;
        Token           errorTok = null;
        Token           initialTok = null;
        ValueNode       value;
    if (getToken(1).kind == NULL && !(getToken(2).kind == PERIOD ||
                            getToken(2).kind == DOUBLE_COLON)) {
      jj_consume_token(NULL);
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.UNTYPED_NULL_CONSTANT_NODE,
                                                                        getContextManager());}
    } else if (jj_2_66(1)) {
      value = DB2DefaultOption(columnName);
endToken = getToken(0);
                value.setBeginOffset( beginToken.beginOffset );
                value.setEndOffset( endToken.endOffset );
                value = (ValueNode) nodeFactory.getNode(
                                                                C_NodeTypes.DEFAULT_NODE,
                                                                value,
                                                                StringUtil.slice(statementSQLText,
                                                                        beginToken.beginOffset + 7,
                                                                        endToken.endOffset,true),
                                                                getContextManager()
                                                        );
                {if ("" != null) return value;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="DB2DefaultOption">DB2DefaultOption</A>
 */
  final public ValueNode DB2DefaultOption(String columnName) throws ParseException, StandardException {ValueNode       value;
    if (getToken(2).kind == SCHEMA || getToken(2).kind == SQLID) {
      jj_consume_token(CURRENT);
      switch (jj_nt.kind) {
      case SCHEMA:{
        jj_consume_token(SCHEMA);
        break;
        }
      case SQLID:{
        jj_consume_token(SQLID);
        break;
        }
      default:
        jj_la1[352] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                C_NodeTypes.CURRENT_SCHEMA_NODE,
                                                getContextManager());}
    } else {
      switch (jj_nt.kind) {
      case CURRENT_USER:
      case SESSION_USER:
      case USER:{
        /* Revert DB2 restriction: DERBY-3013. Accept standard SQL CURRENT_USER,
        	 * SESSION_USER in addition to USER.
        	 */
                value = userNode();
{if ("" != null) return value;}
        break;
        }
      case CURRENT_ROLE:{
        value = currentRoleNode();
{if ("" != null) return value;}
        break;
        }
      default:
        jj_la1[353] = jj_gen;
        if (getToken(1).kind == DATE ||
                        getToken(1).kind == TIME ||
                        getToken(1).kind == TIMESTAMP) {
          value = miscBuiltins();
// these functions are allowed as valid <cast-function> defaults.
          // Once "BLOB" is allowed as a cast-function (5281), a case should be
          // added for that, as well.
                {if ("" != null) return value;}
        } else if (getToken(2).kind == LEFT_PAREN ||
                               (getToken(4).kind == LEFT_PAREN &&
                                getToken(2).kind != COMMA)) {
          // Check against comma: see Derby-331 
                          // Before adding this, the following was erroneously
                          // flagged as invalid: 
                          //	   create table foo(.., b int default 0, unique (a))
                  value = miscBuiltins();
// If we have a function (as indicated by an open paren,
                // which can be either the 2nd token (w/ normal function name)
                // or the 4th token (w/ qualified function name)), then
                // it's not valid.  Catch it here and throw an "invalid
                // default" error (42894) instead of letting it go as
                // a syntax error (this matches DB2 UDB behavior).
                {if (true) throw StandardException.newException(
                        SQLState.LANG_DB2_INVALID_DEFAULT_VALUE,
                        columnName);}
        } else if (jj_2_67(1)) {
          value = datetimeValueFunction();
{if ("" != null) return value;}
        } else {
          switch (jj_nt.kind) {
          case FALSE:
          case TRUE:
          case LEFT_BRACE:
          case PLUS_SIGN:
          case MINUS_SIGN:
          case EXACT_NUMERIC:
          case STRING:
          case HEX_STRING:
          case APPROXIMATE_NUMERIC:{
            // Only (valid) thing left is literals (i.e. actual constants).
                    value = literal();
{if ("" != null) return value;}
            break;
            }
          default:
            jj_la1[354] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

//GemStone changes BEGIN
/*
* <A NAME="optimizedliteral">optimizedliteral</A>
*/
// [sb] indirection added to wrap constants with parameterized consts. 
  final public ValueNode optimizedliteral() throws ParseException, StandardException {ValueNode constantNode = null;
 Token beginToken;
  Token endToken;
beginToken = getToken(1);
    constantNode = literal();
endToken = getToken(0);
CompilerContext cc = getCompilerContext();
      if (!cc.isOptimizeLiteralAllowed()) {
        {if ("" != null) return constantNode;}
      }

      if (!cc.canOptimizeLiteral()) {
        {if ("" != null) return constantNode;}
      }

      if (Misc.getMemStore().getDatabase()
          .disableStatementOptimizationToGenericPlan()) {
        {if ("" != null) return constantNode;}
      }
      ConstantNode origNode = (ConstantNode)constantNode;
      origNode.setBeginOffset(beginToken.beginOffset);
      origNode.setEndOffset(endToken.endOffset+1);
      //temporarily disable following types untill handled properly.
      switch(beginToken.kind) {
        case HEX_STRING:
          {if ("" != null) return constantNode;}
      }

      Integer constantInteger = ReuseFactory.getInteger(constantNumber);

     constantNode = (ValueNode) nodeFactory.getNode(
                           C_NodeTypes.PARAMETERIZED_CONSTANT_NODE,
                           constantInteger,
                           constantNode,
                           getContextManager());

      constantNode.setBeginOffset( beginToken.beginOffset );
      constantNode.setEndOffset  ( endToken.endOffset+1 );

      if(this.subqueryParamCount != null && !this.subqueryParamCount.isEmpty())
      {
         Iterator<List<Integer>> itr = this.subqueryParamCount.iterator();
         while( itr.hasNext()) {
           itr.next().add(constantInteger);
        }

        Iterator<List<ConstantNode>> itr1 = this.subqueryParams.iterator();
         while( itr1.hasNext()) {
           itr1.next().add(origNode);
        }

      }
      parameterList.addElement(constantNode);
      constantNumber++;

     {if ("" != null) return constantNode;}
    throw new Error("Missing return statement in function");
  }

//GemStone changes END


/*
 * <A NAME="literal">literal</A>
 */
  final public ValueNode literal() throws ParseException, StandardException {String  sign = "";
        Token   tok;
        String  datetimeString;
        String  bitString;
        ValueNode               constantNode;
    switch (jj_nt.kind) {
    case PLUS_SIGN:
    case MINUS_SIGN:
    case EXACT_NUMERIC:
    case APPROXIMATE_NUMERIC:{
      switch (jj_nt.kind) {
      case PLUS_SIGN:
      case MINUS_SIGN:{
        sign = sign();
        break;
        }
      default:
        jj_la1[355] = jj_gen;
        ;
      }
      constantNode = numericLiteral(sign);
{if ("" != null) return constantNode;}
      break;
      }
    case STRING:{
      constantNode = stringLiteral();
{if ("" != null) return  constantNode;}
      break;
      }
    case HEX_STRING:{
      constantNode = hexLiteral();
{if ("" != null) return  constantNode;}
      break;
      }
    case LEFT_BRACE:{
      constantNode = dateTimeLiteral();
{if ("" != null) return constantNode;}
      break;
      }
    case FALSE:
    case TRUE:{
      tok = booleanLiteral();
checkInternalFeature(tok.image);
                {if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.BOOLEAN_CONSTANT_NODE,
                                                                        StringUtil.SQLEqualsIgnoreCase(tok.image, "true") ?
                                                                                Boolean.TRUE : Boolean.FALSE,
                                                                        getContextManager());}
      break;
      }
    default:
      jj_la1[356] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="int">intLiteral</A>
 */
  final public NumericConstantNode intLiteral() throws ParseException, StandardException {Token   tok;
    String sign = null;
    NumericConstantNode result;
    switch (jj_nt.kind) {
    case PLUS_SIGN:
    case MINUS_SIGN:{
      sign = sign();
      break;
      }
    default:
      jj_la1[357] = jj_gen;
      ;
    }
    tok = jj_consume_token(EXACT_NUMERIC);
/*
        ** The various java parse utilities can't handle leading +,
        ** so only concatenate leading -.
        */

        String num = tok.image;

        if (sign != null && sign.equals("-"))
            num = sign.concat(num);

        try {
            result = getNumericNode(num, true);
        } catch (NumberFormatException e) {
            {if (true) throw StandardException.newException(
                SQLState.LANG_INTEGER_LITERAL_EXPECTED);}
        }

        {if ("" != null) return result;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="numericLiteral">numericLiteral</A>
 */
  final public ValueNode numericLiteral(String sign) throws ParseException, StandardException {Token   tok;
    switch (jj_nt.kind) {
    case EXACT_NUMERIC:{
      tok = jj_consume_token(EXACT_NUMERIC);
/*
		** The various java parse utilities can't handle leading +,
		** so only concatenate leading -.
		*/

                String num = tok.image;

                if (sign.equals("-"))
                        num = sign.concat(num);

                {if ("" != null) return getNumericNode(num, false);}
      break;
      }
    case APPROXIMATE_NUMERIC:{
      tok = jj_consume_token(APPROXIMATE_NUMERIC);
StringBuilder doubleImage;
                String doubleString;
                int ePosn, dotPosn; // Position of letter e and '.' in value
                Double          doubleValue;

                doubleImage = new StringBuilder(sign);
                doubleImage.append(tok.image);
                doubleString = doubleImage.toString();

                ePosn = doubleString.indexOf('E');
                if (ePosn == -1)
                        ePosn = doubleString.indexOf('e');
                if (SanityManager.DEBUG)
                        SanityManager.ASSERT(ePosn != -1, "no E or e in approximate numeric");

                // there is a limit on the length of a floatingpoint literal in DB2
                if (doubleString.length() > Limits.DB2_MAX_FLOATINGPOINT_LITERAL_LENGTH)
                        {if (true) throw StandardException.newException(SQLState.LANG_DB2_TOO_LONG_FLOATING_POINT_LITERAL, doubleString, TypeId.DOUBLE_NAME);}
                // if there is no '.' before the e, put one in
                dotPosn = doubleString.substring(0,ePosn).indexOf('.');
                if (dotPosn == -1) {
                        doubleImage.insert(ePosn,'.');
                        doubleString = doubleImage.toString();
                        ePosn++;
                }

                try
                {
                        doubleValue = Double.valueOf(doubleString);

                }
                catch (NumberFormatException nfe)
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_FORMAT_EXCEPTION, TypeId.DOUBLE_NAME, (String)null);}
                }

                double dv = doubleValue.doubleValue();

                // When the value is 0 it's possible rounded, try to detect it by checking if the mantissa is 0.0
                //   "proof of correctness": any nonzero value (mantissa) with less than 30 characters will not be
                //                           rounded to 0.0 by a float/real. This correctly detects the case when
                //                           the radix/exponent being "too small" (1e-900) giving a value rounded to zero.
                if ( (dv == 0.0d) && (Double.parseDouble(doubleString.substring(0, ePosn-1)) != 0.0d) )
                {
                        {if (true) throw StandardException.newException(SQLState.LANG_OUTSIDE_RANGE_FOR_DATATYPE, TypeId.DOUBLE_NAME);}
                }

                if (Double.isNaN(dv) || Double.isInfinite(dv))
                        {if (true) throw StandardException.newException(SQLState.LANG_OUTSIDE_RANGE_FOR_DATATYPE, TypeId.DOUBLE_NAME);}

                {if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.DOUBLE_CONSTANT_NODE,
                                                                        doubleValue,
                                                                        getContextManager());}
      break;
      }
    default:
      jj_la1[358] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="dateTimeLiteral">dateTimeLiteral</A>
 */
  final public ValueNode dateTimeLiteral() throws ParseException, StandardException {ValueNode       constantNode;
    jj_consume_token(LEFT_BRACE);
    constantNode = escapedDateTimeLiteral();
    jj_consume_token(RIGHT_BRACE);
{if ("" != null) return constantNode;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="escapedDateTimeLiteral">escapedDateTimeLiteral</A>
 */
  final public ValueNode escapedDateTimeLiteral() throws ParseException, StandardException {ValueNode constantNode;
    switch (jj_nt.kind) {
    case D:{
      jj_consume_token(D);
      constantNode = bareDateLiteral();
{if ("" != null) return constantNode;}
      break;
      }
    case T:{
      jj_consume_token(T);
      constantNode = bareTimeLiteral();
{if ("" != null) return constantNode;}
      break;
      }
    case TS:{
      jj_consume_token(TS);
      constantNode = bareTimestampLiteral();
{if ("" != null) return constantNode;}
      break;
      }
    default:
      jj_la1[359] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="bareDateLiteral">bareDateLiteral</A>
 */
  final public ValueNode bareDateLiteral() throws ParseException, StandardException {String dateString;
    dateString = string();
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                C_NodeTypes.USERTYPE_CONSTANT_NODE,
                                                getLanguageConnectionContext().getDataValueFactory().getDateValue(dateString, true),
                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="bareTimeLiteral">bareTimeLiteral</A>
 */
  final public ValueNode bareTimeLiteral() throws ParseException, StandardException {String timeString;
    timeString = string();
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                C_NodeTypes.USERTYPE_CONSTANT_NODE,
                                                getLanguageConnectionContext().getDataValueFactory().getTimeValue(timeString, true),
                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="bareTimestampLiteral">bareTimestampLiteral</A>
 */
  final public ValueNode bareTimestampLiteral() throws ParseException, StandardException {String timestampString;
    timestampString = string();
{if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                C_NodeTypes.USERTYPE_CONSTANT_NODE,
                                                getLanguageConnectionContext().getDataValueFactory().getTimestampValue(timestampString, true),
                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="string">string</A>
 */
  final public String string() throws ParseException, StandardException {Token   tok;
    tok = jj_consume_token(STRING);
verifyImageLength(tok.image);
                /* Trim off the leading and trailing ', and compress all '' to ' */
                //GemStone changes BEGIN
        {if ("" != null) return compressQuotes(tok.image,
                              SINGLEQUOTES);}
                //originally return compressQuotes(tok.image.substring(1, tok.image.length() - 1),
                //					  SINGLEQUOTES);
        //GemStone changes END

    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="stringLiteral">stringLiteral</A>
 */
  final public CharConstantNode stringLiteral() throws ParseException, StandardException {Token   tok;
        String  string;
    tok = jj_consume_token(STRING);
//there is a maximum limit on the length of the string
                if (tok.image.length() > Limits.DB2_MAX_CHARACTER_LITERAL_LENGTH)//-2 is for the beginning and ending quote
                        {if (true) throw StandardException.newException(SQLState.LANG_DB2_STRING_CONSTANT_TOO_LONG, StringUtil.formatForPrint(tok.image));}
        //GemStone changes BEGIN
                string = compressQuotes(tok.image, SINGLEQUOTES); //originally tok.image.substring(1, tok.image.length() - 1), SINGLEQUOTES);
        //GemStone changes END
                /* Trim quotes from string. */
                {if ("" != null) return (CharConstantNode) nodeFactory.getNode(
                                                                C_NodeTypes.CHAR_CONSTANT_NODE,
                                                                string,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="hexLiteral">hexLiteral</A>
 */
  final public ValueNode hexLiteral() throws ParseException, StandardException {Token   tok;
    tok = jj_consume_token(HEX_STRING);
String hexLiteral = tok.image;

                //there is a maximum limit on the length of the hex constant
                if (hexLiteral.length()-3 > Limits.DB2_MAX_HEX_LITERAL_LENGTH)//-3 is for X' at the beginning and ' at the end
                        {if (true) throw StandardException.newException(SQLState.LANG_DB2_STRING_CONSTANT_TOO_LONG, StringUtil.formatForPrint(hexLiteral));}
                if ((hexLiteral.length()-3)%2 == 1)
                        {if (true) throw StandardException.newException(SQLState.LANG_DB2_INVALID_HEXADECIMAL_CONSTANT, StringUtil.formatForPrint(hexLiteral));}

                int bitLength = ((hexLiteral.length() - 3) / 2);
                {if ("" != null) return (ValueNode)
                                nodeFactory.getNode(C_NodeTypes.VARBIT_CONSTANT_NODE,
                                                                        hexLiteral.substring(2, hexLiteral.length() - 1), ReuseFactory.getInteger(bitLength),
                                                                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public TableName constraintNameDefinition() throws ParseException, StandardException {TableName constraintName;
    jj_consume_token(CONSTRAINT);
    constraintName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
{if ("" != null) return constraintName;}
    throw new Error("Missing return statement in function");
  }

/*
 * DB2 requires column check constraints to refer to only that column. Derby
 * doesn't care if check constraints are column level or table level. For DB2 compatibility
 * check that column check constraints only refer to that column.
 */
  final public ConstraintDefinitionNode checkConstraintDefinition(TableName constraintName, String columnName) throws ParseException, StandardException {Token           beginToken;
        Token           endToken;
        ValueNode       value;
        ResultColumnList rclList = null;
    jj_consume_token(CHECK);
    beginToken = jj_consume_token(LEFT_PAREN);
    value = valueExpression(false);
    endToken = jj_consume_token(RIGHT_PAREN);
if (columnName != null)
                {
                        /* Column check constraint */
                        rclList = (ResultColumnList) nodeFactory.getNode(
                                                                        C_NodeTypes.RESULT_COLUMN_LIST,
                                                                        getContextManager());
                        rclList.addElement((ResultColumn) nodeFactory.getNode(
                                                                        C_NodeTypes.RESULT_COLUMN,
                                                                        columnName,
                                                                        null,
                                                                        getContextManager()));
                }

                value.setBeginOffset( beginToken.beginOffset );
                value.setEndOffset( endToken.endOffset );
                {if ("" != null) return (ConstraintDefinitionNode) nodeFactory.getNode(
                                        C_NodeTypes.CONSTRAINT_DEFINITION_NODE,
                                        constraintName,
                                        ReuseFactory.getInteger(DataDictionary.CHECK_CONSTRAINT),
                                        rclList,
                                        null,
                                        value,
                                        StringUtil.slice(statementSQLText,
                                                beginToken.beginOffset,
                                                endToken.endOffset,true),
                                        getContextManager()
                                        );}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="spsRenameStatement">spsRenameStatement</A>
 */
  final public StatementNode spsRenameStatement() throws ParseException, StandardException {StatementNode qtn;
    jj_consume_token(RENAME);
    switch (jj_nt.kind) {
    case TABLE:{
      qtn = renameTableStatement();
      break;
      }
    case INDEX:{
      qtn = renameIndexStatement();
      break;
      }
    case COLUMN:{
      qtn = renameColumnStatement();
      break;
      }
    default:
      jj_la1[360] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return qtn;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="renameTableStatement">renameTableStatement</A>
 */
  final public StatementNode renameTableStatement() throws ParseException, StandardException {StatementNode qtn;
        TableName tableName;
        String newTableName;
    jj_consume_token(TABLE);
    tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    jj_consume_token(TO);
    newTableName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
{if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.RENAME_NODE,
                                                                tableName,
                                                                null,
                                                                newTableName,
                                                                Boolean.FALSE,
                                                                ReuseFactory.getInteger(StatementType.RENAME_TABLE),
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="renameIndexStatement">renameIndexStatement</A>
 */
 // GemStone changes BEGIN
  final public StatementNode renameIndexStatement() throws ParseException, StandardException {TableName oldIndexName;
        String  newIndexName;
    jj_consume_token(INDEX);
    oldIndexName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    jj_consume_token(TO);
    newIndexName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
StatementNode qtn = (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.RENAME_NODE,
                                                                null,
                                                                oldIndexName,
                                                                newIndexName,
                                                                Boolean.FALSE,
ReuseFactory.getInteger(StatementType.RENAME_INDEX),
                                                                getContextManager());

                {if ("" != null) return qtn;}
    throw new Error("Missing return statement in function");
  }

// GemStone changes END
  final public StatementNode renameColumnStatement() throws ParseException, StandardException {String newColumnName;
        ColumnReference oldColumnReference;
    jj_consume_token(COLUMN);
    oldColumnReference = columnReference();
    jj_consume_token(TO);
    newColumnName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
if (oldColumnReference.getTableNameNode() == null)
                        {if (true) throw StandardException.newException(
                                SQLState.LANG_OBJECT_DOES_NOT_EXIST,
                                "RENAME COLUMN",
                                oldColumnReference.getColumnName());}
                {if ("" != null) return (StatementNode) nodeFactory.getNode(
                        C_NodeTypes.RENAME_NODE,
                        oldColumnReference.getTableNameNode(),
                        oldColumnReference.getColumnName(),
                        newColumnName,
                        Boolean.FALSE,
                        ReuseFactory.getInteger(StatementType.RENAME_COLUMN),
                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode lockStatement() throws ParseException, StandardException {Boolean                                         exclusiveMode;
        TableName                                       tableName;
    jj_consume_token(LOCK);
    jj_consume_token(TABLE);
    tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    jj_consume_token(IN);
    exclusiveMode = lockMode();
    jj_consume_token(MODE);
{if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.LOCK_TABLE_NODE,
                                                                tableName,
                                                                exclusiveMode,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public Boolean lockMode() throws ParseException {
    switch (jj_nt.kind) {
    case EXCLUSIVE:{
      jj_consume_token(EXCLUSIVE);
{if ("" != null) return Boolean.TRUE;}
      break;
      }
    case SHARE:{
      jj_consume_token(SHARE);
{if ("" != null) return Boolean.FALSE;}
      break;
      }
    default:
      jj_la1[361] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public StatementNode execStatement() throws ParseException, StandardException {TableName       stmtName;
    jj_consume_token(EXECUTE);
    jj_consume_token(STATEMENT);
    stmtName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
{if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.EXEC_SPS_NODE,
                                                                stmtName,
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

// GemStone changes BEGIN
  final public StatementNode explainStatement() throws ParseException, StandardException {//StatementNode userQuery = null;
  String userQuery = null;
  Token explainToken = null;
  XPLAINUtil.XMLForms xmlform = XPLAINUtil.XMLForms.none;
  boolean withQueryResult = false;
  ArrayList<ArrayList<Object>> listOfValueList = null;
  CompilerContext cc = getCompilerContext();
  int parameterOffset = -1;
  CharConstantNode embedXSLFileName = null;
    jj_consume_token(EXPLAIN);
cc.setPreparedStatement();
                explainToken = token;
    if (getToken(1).kind == AS && (getToken(2).kind == XML || getToken(2).kind == XMLFRAGMENTS)) {
      jj_consume_token(AS);
      switch (jj_nt.kind) {
      case XML:{
        jj_consume_token(XML);
explainToken = token;
                           xmlform = XPLAINUtil.XMLForms.asXML;
        if (getToken(1).kind == EMBED && getToken(2).kind == STRING) {
          jj_consume_token(EMBED);
          embedXSLFileName = stringLiteral();
explainToken = token;
        } else {
          ;
        }
        break;
        }
      case XMLFRAGMENTS:{
        jj_consume_token(XMLFRAGMENTS);
explainToken = token;
                                xmlform = XPLAINUtil.XMLForms.asXMLFragments;
        break;
        }
      default:
        jj_la1[362] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    switch (jj_nt.kind) {
    case DELETE:
    case INSERT:
    case ROLLBACK:
    case SELECT:
    case UPDATE:
    case VALUES:
    case RELEASE:
    case SAVEPOINT:
    case CALL:
    case PUT:
    case LEFT_BRACE:
    case LEFT_PAREN:
    case QUESTION_MARK:{
      preparableSQLDataStatement();
      switch (jj_nt.kind) {
      case PARAMETER:{
        jj_consume_token(PARAMETER);
parameterOffset = token.beginOffset;
        listOfValueList = multipleValueListSpecification();
        break;
        }
      default:
        jj_la1[363] = jj_gen;
        ;
      }
      break;
      }
    case UUID_LITERAL:{
      jj_consume_token(UUID_LITERAL);
userQuery = token.image.trim();
      break;
      }
    default:
      jj_la1[364] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
int beginIdx = explainToken.endOffset + 1;

       if (parameterOffset > 0) {
          userQuery = statementSQLText.substring(beginIdx, parameterOffset);
       }
       else {
          userQuery = statementSQLText.substring(beginIdx);
       }

       {if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                  C_NodeTypes.EXPLAIN_NODE,
                                                  userQuery,
                                                  listOfValueList,
                                                  xmlform,
                                                  embedXSLFileName,
                                                  getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public ArrayList<ArrayList<Object>> multipleValueListSpecification() throws ParseException, StandardException {ArrayList<Object> valueList;
  ArrayList listOfValueList;
    jj_consume_token(VALUES);
    valueList = singleValueListSpecification();
listOfValueList = new ArrayList();
        listOfValueList.add(valueList);
    switch (jj_nt.kind) {
    case COMMA:{
      jj_consume_token(COMMA);
      label_58:
      while (true) {
        valueList = singleValueListSpecification();
listOfValueList.add(valueList);
        switch (jj_nt.kind) {
        case LEFT_PAREN:{
          ;
          break;
          }
        default:
          jj_la1[365] = jj_gen;
          break label_58;
        }
      }
      break;
      }
    default:
      jj_la1[366] = jj_gen;
      ;
    }
{if ("" != null) return listOfValueList;}
    throw new Error("Missing return statement in function");
  }

  final public ArrayList<Object> singleValueListSpecification() throws ParseException, StandardException {ValueNode value;
  ArrayList<Object> valueList = new ArrayList<Object>();
    jj_consume_token(LEFT_PAREN);
    value = additiveExpression(null, 0, false);
Object o = value.getConstantValueAsObject();
              if (o == null) {
                 StandardException.newException(SQLState.LANG_NO_NON_CONSTANT_PARAMETER_ALLOWED, value);
              }
              valueList.add(o);
    label_59:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[367] = jj_gen;
        break label_59;
      }
      jj_consume_token(COMMA);
      additiveExpression(null, 0, false);
o = value.getConstantValueAsObject();
                      if (o == null) {
                         StandardException.newException(SQLState.LANG_NO_NON_CONSTANT_PARAMETER_ALLOWED, value);
                      }
                      valueList.add(o);
    }
    jj_consume_token(RIGHT_PAREN);
{if ("" != null) return valueList;}
    throw new Error("Missing return statement in function");
  }

// GemStone changes END
  final public 
TransactionStatementNode setIsolationStatement() throws ParseException, StandardException {TransactionStatementNode tranNode;
    setIsolationHeader();
    switch (jj_nt.kind) {
    case TO:
    case EQUALS_OPERATOR:{
      switch (jj_nt.kind) {
      case EQUALS_OPERATOR:{
        jj_consume_token(EQUALS_OPERATOR);
        break;
        }
      case TO:{
        jj_consume_token(TO);
        break;
        }
      default:
        jj_la1[368] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[369] = jj_gen;
      ;
    }
    tranNode = transactionMode();
{if ("" != null) return tranNode;}
    throw new Error("Missing return statement in function");
  }

  final public void setIsolationHeader() throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case ISOLATION:{
      jj_consume_token(ISOLATION);
      break;
      }
    default:
      jj_la1[370] = jj_gen;
      if (getToken(1).kind == CURRENT && getToken(2).kind == ISOLATION) {
        jj_consume_token(CURRENT);
        jj_consume_token(ISOLATION);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public TransactionStatementNode transactionMode() throws ParseException, StandardException {int isolationLevel;
    isolationLevel = isolationLevelDB2OrReset();
{if ("" != null) return (TransactionStatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.SET_TRANSACTION_ISOLATION_NODE,
                                                                ReuseFactory.getInteger(isolationLevel),
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public int isolationLevelDB2OrReset() throws ParseException {int isolationLevel;
    switch (jj_nt.kind) {
    case RESET:{
      jj_consume_token(RESET);
{if ("" != null) return ExecutionContext.UNSPECIFIED_ISOLATION_LEVEL;}
      break;
      }
    default:
      jj_la1[371] = jj_gen;
      if (jj_2_68(1)) {
        isolationLevel = isolationLevelDB2();
{if ("" != null) return isolationLevel;}
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public int isolationLevelDB2() throws ParseException {int isolationLevel;
    switch (jj_nt.kind) {
    case CS:
    case RR:
    case RS:
    case UR:{
      isolationLevel = isolationLevelDB2Abbrev();
{if ("" != null) return isolationLevel;}
      break;
      }
    case SERIALIZABLE:{
      jj_consume_token(SERIALIZABLE);
{if ("" != null) return ExecutionContext.SERIALIZABLE_ISOLATION_LEVEL;}
      break;
      }
    case REPEATABLE:{
      jj_consume_token(REPEATABLE);
      jj_consume_token(READ);
{if ("" != null) return ExecutionContext.REPEATABLE_READ_ISOLATION_LEVEL;}
      break;
      }
    case CURSOR:{
      jj_consume_token(CURSOR);
      jj_consume_token(STABILITY);
{if ("" != null) return ExecutionContext.READ_COMMITTED_ISOLATION_LEVEL;}
      break;
      }
    case DIRTY:{
      jj_consume_token(DIRTY);
      jj_consume_token(READ);
{if ("" != null) return ExecutionContext.READ_UNCOMMITTED_ISOLATION_LEVEL;}
      break;
      }
    default:
      jj_la1[372] = jj_gen;
      if (getToken(1).kind == READ && getToken(2).kind == COMMITTED) {
        jj_consume_token(READ);
        jj_consume_token(COMMITTED);
{if ("" != null) return ExecutionContext.READ_COMMITTED_ISOLATION_LEVEL;}
      } else if (getToken(1).kind == READ && getToken(2).kind == UNCOMMITTED) {
        jj_consume_token(READ);
        jj_consume_token(UNCOMMITTED);
{if ("" != null) return ExecutionContext.READ_UNCOMMITTED_ISOLATION_LEVEL;}
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public int isolationLevelDB2Abbrev() throws ParseException {
    switch (jj_nt.kind) {
    case RR:{
      jj_consume_token(RR);
{if ("" != null) return ExecutionContext.SERIALIZABLE_ISOLATION_LEVEL;}
      break;
      }
    case RS:{
      jj_consume_token(RS);
{if ("" != null) return ExecutionContext.REPEATABLE_READ_ISOLATION_LEVEL;}
      break;
      }
    case CS:{
      jj_consume_token(CS);
{if ("" != null) return ExecutionContext.READ_COMMITTED_ISOLATION_LEVEL;}
      break;
      }
    case UR:{
      jj_consume_token(UR);
{if ("" != null) return ExecutionContext.READ_UNCOMMITTED_ISOLATION_LEVEL;}
      break;
      }
    default:
      jj_la1[373] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public int isolationLevel() throws ParseException {int isolationLevel;
    jj_consume_token(ISOLATION);
    jj_consume_token(LEVEL);
    isolationLevel = levelOfIsolation();
{if ("" != null) return isolationLevel;}
    throw new Error("Missing return statement in function");
  }

  final public int levelOfIsolation() throws ParseException {
    switch (jj_nt.kind) {
    case READ:{
      jj_consume_token(READ);
{if ("" != null) return levelOfIsolationRead();}
      break;
      }
    case REPEATABLE:{
      jj_consume_token(REPEATABLE);
      jj_consume_token(READ);
{if ("" != null) return ExecutionContext.REPEATABLE_READ_ISOLATION_LEVEL;}
      break;
      }
    case SERIALIZABLE:{
      jj_consume_token(SERIALIZABLE);
{if ("" != null) return ExecutionContext.SERIALIZABLE_ISOLATION_LEVEL;}
      break;
      }
    default:
      jj_la1[374] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public int levelOfIsolationRead() throws ParseException {
    switch (jj_nt.kind) {
    case UNCOMMITTED:{
      jj_consume_token(UNCOMMITTED);
{if ("" != null) return ExecutionContext.READ_UNCOMMITTED_ISOLATION_LEVEL;}
      break;
      }
    case COMMITTED:{
      jj_consume_token(COMMITTED);
{if ("" != null) return ExecutionContext.READ_COMMITTED_ISOLATION_LEVEL;}
      break;
      }
    default:
      jj_la1[375] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="simpleValueSpecification">simpleValueSpecification</A>
 */
  final public ValueNode simpleValueSpecification() throws ParseException, StandardException {ValueNode       value;
    value = literal();
{if ("" != null) return value;}
    throw new Error("Missing return statement in function");
  }

// GemStone changes BEGIN
  final public int simpleValueSpecification_int() throws ParseException, StandardException {ValueNode       value;
    value = literal();
// Negative numbers are always illegal for all tokens that require int values
            // But sometimes zero is legal
            // Throw errors here for negative numbers
            if (getIntValue(value) < 0)
            {
               {if (true) throw StandardException.newException(SQLState.LANG_INVALID_COLUMN_LENGTH,
                "Value "+getIntValue(value)+" is negative");}
            }
                {if ("" != null) return getIntValue(value);}
    throw new Error("Missing return statement in function");
  }

  final public long simpleValueSpecification_long() throws ParseException, StandardException {ValueNode       value;
    value = literal();
// A negative number is valid for this value
            // Currently only used for RECOVERYDELAY and STARTUPRECOVERYDELAY
            // in CREATE TABLE partitioning. If another value needs this
            // and cannot take negative numbers, please make another function
                {if ("" != null) return getLongValue(value);}
    throw new Error("Missing return statement in function");
  }

// GemStone changes END

/*
 * <A NAME="setRoleStatement">setRoleStatement</A>
 */
  final public StatementNode setRoleStatement() throws ParseException, StandardException {StatementNode role;
    jj_consume_token(ROLE);
    role = setRoleSpecification();
if (parameterList != null && parameterList.size() > 0)
                {
                        setUpAndLinkParameters();
                        // set the type of parameter node, it should be a varchar
                        // max Limits.MAX_IDENTIFIER_LENGTH - non nullable
                        ParameterNode p = (ParameterNode)parameterList.elementAt(0);
                        p.setType(new DataTypeDescriptor
                                          (TypeId.getBuiltInTypeId(Types.VARCHAR),
                                           false,
                                           Limits.MAX_IDENTIFIER_LENGTH));
                }
                {if ("" != null) return role;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="setRoleSpecification">setRoleSpecification</A>
 */
  final public StatementNode setRoleSpecification() throws ParseException, StandardException {String roleName = null;
        boolean quiesceCompilerUnreachableStatement = true;
        if (quiesceCompilerUnreachableStatement) {
                throw StandardException.newException
                        (SQLState.NOT_IMPLEMENTED, "ROLES");
        }
        checkVersion( DataDictionary.DD_VERSION_DERBY_10_4, "ROLES");
        checkSqlStandardAccess("SET ROLE");
    switch (jj_nt.kind) {
    case NONE:{
      jj_consume_token(NONE);
{if ("" != null) return (StatementNode) nodeFactory.getNode
                        (C_NodeTypes.SET_ROLE_NODE,
                         roleName,
                         null,
                         getContextManager());}
      break;
      }
    default:
      jj_la1[376] = jj_gen;
      if (jj_2_69(1)) {
        roleName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
{if ("" != null) return (StatementNode) nodeFactory.getNode
                        (C_NodeTypes.SET_ROLE_NODE,
                         roleName,
                         null,
                         getContextManager());}
      } else {
        switch (jj_nt.kind) {
        case QUESTION_MARK:{
          dynamicParameterSpecification();
{if ("" != null) return (StatementNode) nodeFactory.getNode
                        (C_NodeTypes.SET_ROLE_NODE,
                         null,
                         ReuseFactory.getInteger(StatementType.SET_ROLE_DYNAMIC),
                         getContextManager());}
          break;
          }
        case STRING:{
          roleName = string();
checkIdentifierLengthLimit(roleName, Limits.MAX_IDENTIFIER_LENGTH);
                {if ("" != null) return (StatementNode) nodeFactory.getNode(
                        C_NodeTypes.SET_ROLE_NODE,
                        roleName,
                        null,
                        getContextManager());}
          break;
          }
        default:
          jj_la1[377] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public StatementNode setSchemaStatement() throws ParseException, StandardException {StatementNode setSchema;
    setSchemaHeader();
    switch (jj_nt.kind) {
    case EQUALS_OPERATOR:{
      jj_consume_token(EQUALS_OPERATOR);
      break;
      }
    default:
      jj_la1[378] = jj_gen;
      ;
    }
    setSchema = setSchemaValues();
if (parameterList != null && parameterList.size() > 0)
                {
                        setUpAndLinkParameters();
                        // set the type of parameter node, it should be a varchar max Limits.MAX_IDENTIFIER_LENGTH - non nullable
                        ParameterNode p = (ParameterNode)parameterList.elementAt(0);
                        p.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(Types.VARCHAR), false, Limits.MAX_IDENTIFIER_LENGTH));
                }
                {if ("" != null) return setSchema;}
    throw new Error("Missing return statement in function");
  }

  final public void setSchemaHeader() throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case SCHEMA:{
      jj_consume_token(SCHEMA);
      break;
      }
    default:
      jj_la1[380] = jj_gen;
      if (getToken(1).kind == CURRENT && ( getToken(2).kind == SCHEMA ||  getToken(2).kind == SQLID )) {
        jj_consume_token(CURRENT);
        switch (jj_nt.kind) {
        case SCHEMA:{
          jj_consume_token(SCHEMA);
          break;
          }
        case SQLID:{
          jj_consume_token(SQLID);
          break;
          }
        default:
          jj_la1[379] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public StatementNode setSchemaValues() throws ParseException, StandardException {String schemaName;
    if (jj_2_70(1)) {
      schemaName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
{if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.SET_SCHEMA_NODE,
                                                                schemaName,
                                                                null,
                                                                getContextManager());}
    } else {
      switch (jj_nt.kind) {
      case USER:{
        jj_consume_token(USER);
{if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.SET_SCHEMA_NODE,
                                                                null,
                                                                ReuseFactory.getInteger(StatementType.SET_SCHEMA_USER),
                                                                getContextManager());}
        break;
        }
      case QUESTION_MARK:{
        dynamicParameterSpecification();
{if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.SET_SCHEMA_NODE,
                                                                null,
                                                                ReuseFactory.getInteger(StatementType.SET_SCHEMA_DYNAMIC),
                                                                getContextManager());}
        break;
        }
      case STRING:{
        schemaName = string();
/* Max length for schema name is Limits.MAX_IDENTIFIER_LENGTH */
                checkIdentifierLengthLimit(schemaName, Limits.MAX_IDENTIFIER_LENGTH);
                {if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.SET_SCHEMA_NODE,
                                                                schemaName,
                                                                null,
                                                                getContextManager());}
        break;
        }
      default:
        jj_la1[381] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

// Set the locale for messages coming from the database system. This
// is for support only, so we can get messages in our preferred language
// (usually English). I didn't want to create all the execution wiring
// to do this, so this command executes in the parser
  final public StatementNode setMessageLocaleStatement() throws ParseException, StandardException {String messageLocale;
    jj_consume_token(MESSAGE_LOCALE);
    messageLocale = string();
getContextManager().setMessageLocale(messageLocale);

                {if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                                        C_NodeTypes.NOP_STATEMENT_NODE,
                                                                                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="valueSpecification">valueSpecification</A>
 */
  final public ValueNode valueSpecification() throws ParseException, StandardException {ValueNode          value;
        ValueNode          leftExpression;
        ValueNode          rightExpression;
    switch (jj_nt.kind) {
    case FALSE:
    case TRUE:
    case LEFT_BRACE:
    case PLUS_SIGN:
    case MINUS_SIGN:
    case EXACT_NUMERIC:
    case STRING:
    case HEX_STRING:
    case APPROXIMATE_NUMERIC:{
      //GemStone changes BEGIN
              /*originally value = literal() */
              value = optimizedliteral();
{if ("" != null) return value;}
      break;
      }
    case CURRENT_USER:
    case SESSION_USER:
    case USER:
    case CURRENT_ROLE:
    case QUESTION_MARK:{
      value = generalValueSpecification();
{if ("" != null) return value;}
      break;
      }
    case NULLIF:{
      jj_consume_token(NULLIF);
      jj_consume_token(LEFT_PAREN);
      leftExpression = additiveExpression(null, 0, false);
      jj_consume_token(COMMA);
      rightExpression = additiveExpression(null, 0, false);
      jj_consume_token(RIGHT_PAREN);
// "NULLIF(L, R)" is the same as "L=R ? untyped NULL : L"
                // An impl assumption here is that Derby can promote CHAR to any comparable datatypes such as numeric
                ContextManager cm = getContextManager();
                ValueNodeList thenElseList = (ValueNodeList) nodeFactory.getNode(C_NodeTypes.VALUE_NODE_LIST, cm);

                //Use untyped null for then clause at this point. At the bind time, we will cast it to the datatype of L 
                thenElseList.addElement((ValueNode) nodeFactory.getNode(
                                                                        C_NodeTypes.UNTYPED_NULL_CONSTANT_NODE,
                                                                        cm));
                thenElseList.addElement(leftExpression);

                {if ("" != null) return (ValueNode) nodeFactory.getNode(
                                                                                        C_NodeTypes.CONDITIONAL_NODE,
                                                                                        (ValueNode) nodeFactory.getNode(
                                                                                                                C_NodeTypes.BINARY_EQUALS_OPERATOR_NODE,
                                                                                                                leftExpression,
                                                                                                                rightExpression,
                                                                                                                cm),
                                                                                        thenElseList,
                                                                                        Boolean.TRUE,//this node is for nullif 
                                                                                        cm);}
      break;
      }
    case CASE:{
      jj_consume_token(CASE);
      value = whenThenExpression();
{if ("" != null) return value;}
      break;
      }
    default:
      jj_la1[382] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="caseExpression">caseExpression</A>
 */
  final public ValueNode caseExpression() throws ParseException, StandardException {ValueNode          expr;
    switch (jj_nt.kind) {
    case END:{
      jj_consume_token(END);
ValueNode value = (ValueNode) nodeFactory.getNode(
                                                                                C_NodeTypes.CAST_NODE,
                                                                                (ValueNode) nodeFactory.getNode(C_NodeTypes.UNTYPED_NULL_CONSTANT_NODE,
                                                                                                                                                getContextManager()),
                                                                                DataTypeDescriptor.getBuiltInDataTypeDescriptor(Types.CHAR, 1),
                                                                                getContextManager());
                ((CastNode) value).setForExternallyGeneratedCASTnode();
                {if ("" != null) return value;}
      break;
      }
    case ELSE:{
      jj_consume_token(ELSE);
      expr = thenElseExpression();
      jj_consume_token(END);
{if ("" != null) return expr;}
      break;
      }
    case WHEN:{
      expr = whenThenExpression();
{if ("" != null) return expr;}
      break;
      }
    default:
      jj_la1[383] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="whenThenExpression">whenThenExpression</A>
 */
  final public ValueNode whenThenExpression() throws ParseException, StandardException {ValueNode          expr;
        ValueNode          thenExpr;
        ValueNode          elseExpr;
    jj_consume_token(WHEN);
    expr = orExpression(null, false);
    label_60:
    while (true) {
      switch (jj_nt.kind) {
      case OR:{
        ;
        break;
        }
      default:
        jj_la1[384] = jj_gen;
        break label_60;
      }
      jj_consume_token(OR);
      expr = orExpression(expr, false);
    }
    jj_consume_token(THEN);
    thenExpr = thenElseExpression();
    elseExpr = caseExpression();
ContextManager cm = getContextManager();
                ValueNodeList thenElseList = (ValueNodeList) nodeFactory.getNode(C_NodeTypes.VALUE_NODE_LIST, cm);
                thenElseList.addElement(thenExpr); // then
                thenElseList.addElement(elseExpr); // else

                {if ("" != null) return((ValueNode) nodeFactory.getNode(C_NodeTypes.CONDITIONAL_NODE,
                                                                                                expr,
                                                                                                thenElseList,
                                                                                                Boolean.FALSE,
                                                                                                cm));}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="thenElseExpression">thenElseExpression</A>
 */
  final public ValueNode thenElseExpression() throws ParseException, StandardException {ValueNode          expr;
        CompilerContext cc = getCompilerContext();
    if (getToken(1).kind == NULL) {
      jj_consume_token(NULL);
ValueNode value = (ValueNode) nodeFactory.getNode(
                                                                                C_NodeTypes.CAST_NODE,
                                                                                (ValueNode) nodeFactory.getNode(C_NodeTypes.UNTYPED_NULL_CONSTANT_NODE,
                                                                                                                                                getContextManager()),
                                                                                DataTypeDescriptor.getBuiltInDataTypeDescriptor(Types.CHAR, 1),
                                                                                getContextManager());
                ((CastNode) value).setForExternallyGeneratedCASTnode();
                {if ("" != null) return value;}
    } else if (jj_2_71(1)) {
cc.setConvertCharConstToVarchar(true);
      expr = additiveExpression(null, 0, false);
cc.setConvertCharConstToVarchar(false);
{if ("" != null) return expr;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TableElementNode tableConstraintDefinition() throws ParseException, StandardException {Properties properties = null;
        ConstraintDefinitionNode tcdn;
        TableName               constraintName = null;
        //initialize following two booleans before handling table level constraints
        explicitNotNull = false;
        explicitNull = false;
    switch (jj_nt.kind) {
    case CONSTRAINT:{
      constraintName = constraintNameDefinition();
      break;
      }
    default:
      jj_la1[385] = jj_gen;
      ;
    }
    tcdn = tableConstraint(constraintName);
    switch (jj_nt.kind) {
    case GEMFIREXDDASHPROPERTIES:{
      properties = propertyList(false);
      jj_consume_token(CHECK_PROPERTIES);
      break;
      }
    default:
      jj_la1[386] = jj_gen;
      ;
    }
if (properties != null)
                {
                        tcdn.setProperties(properties);
                }
                {if ("" != null) return tcdn;}
    throw new Error("Missing return statement in function");
  }

  final public ConstraintDefinitionNode tableConstraint(TableName constraintName) throws ParseException, StandardException {ConstraintDefinitionNode tcdn;
    switch (jj_nt.kind) {
    case PRIMARY:
    case UNIQUE:{
      tcdn = uniqueConstraintDefinition(constraintName);
{if ("" != null) return tcdn;}
      break;
      }
    case FOREIGN:{
      tcdn = referentialConstraintDefinition(constraintName);
{if ("" != null) return tcdn;}
      break;
      }
    case CHECK:{
      tcdn = checkConstraintDefinition(constraintName, null);
{if ("" != null) return tcdn;}
      break;
      }
    default:
      jj_la1[387] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ConstraintDefinitionNode uniqueConstraintDefinition(TableName constraintName) throws ParseException, StandardException {int constraintType;
        ResultColumnList uniqueColumnList;
    //for table level constraint, parameter will be null
            constraintType = uniqueSpecification(null);
    jj_consume_token(LEFT_PAREN);
    uniqueColumnList = uniqueColumnList();
    jj_consume_token(RIGHT_PAREN);
//go through the unique columns list and if any of the columns in the
                //list is explicitly defined null, throw an exception for this. Columns
                //for which no nullability is defined are by default nullable. But in
                //case of create table, there nullability changes automatically to 
                //non-nullable if primary key is defined on it. But if user explicitly
                //defines the nullability, then defining a primary key on it in create
                //table will result in an exception.
                if (constraintType ==  DataDictionary.PRIMARYKEY_CONSTRAINT)
                {
                        for (int index = 0; index < uniqueColumnList.size(); index++)
                        {
                                String primaryKeyColumnName = ((ResultColumn) uniqueColumnList.elementAt(index)).getName();
                                if (explicitlyNullableColumnsList.contains(primaryKeyColumnName))
                                {
                                        String errorState = SQLState.LANG_DB2_ADD_UNIQUE_OR_PRIMARY_KEY_ON_NULL_COLS;
                                        {if (true) throw StandardException.newException(errorState, primaryKeyColumnName);}
                                }
                        }
                }
                {if ("" != null) return (ConstraintDefinitionNode) nodeFactory.getNode(
                                                C_NodeTypes.CONSTRAINT_DEFINITION_NODE,
                                                constraintName,
                                                ReuseFactory.getInteger(constraintType),
                                                uniqueColumnList,
                                                null,
                                                null,
                                                null,
                                                getContextManager()
                                                );}
    throw new Error("Missing return statement in function");
  }

//the second parameter to the following method will always be null for a table level
//constraint but not for a column level constraint
  final public int uniqueSpecification(String columnName) throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case UNIQUE:{
      jj_consume_token(UNIQUE);
{if ("" != null) return DataDictionary.UNIQUE_CONSTRAINT;}
      break;
      }
    case PRIMARY:{
      jj_consume_token(PRIMARY);
      jj_consume_token(KEY);
//explicitNull can be true only if it's column level constraint and
                //that column has null constraint defined on it. In that case, defining
                //a column-level constraint of primary key on it will result in an error.
                if (explicitNull)
                {
                        String errorState = SQLState.LANG_DB2_ADD_UNIQUE_OR_PRIMARY_KEY_ON_NULL_COLS;
                        {if (true) throw StandardException.newException(errorState, columnName);}
                }
                {if ("" != null) return DataDictionary.PRIMARYKEY_CONSTRAINT;}
      break;
      }
    default:
      jj_la1[388] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ResultColumnList uniqueColumnList() throws ParseException, StandardException {ResultColumnList        resultColumns = (ResultColumnList) nodeFactory.getNode(
                                                                                        C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                        getContextManager());
    columnNameList(resultColumns);
{if ("" != null) return resultColumns;}
    throw new Error("Missing return statement in function");
  }

  final public ConstraintDefinitionNode referentialConstraintDefinition(TableName constraintName) throws ParseException, StandardException {ResultColumnList fkRcl = (ResultColumnList) nodeFactory.getNode(
                                                                                C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                getContextManager());
        ResultColumnList refRcl = (ResultColumnList) nodeFactory.getNode(
                                                                                C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                getContextManager());
        TableName referencedTable;
        int[] refActions = {StatementType.RA_NOACTION,
                            StatementType.RA_NOACTION}; //default values

    jj_consume_token(FOREIGN);
    jj_consume_token(KEY);
    jj_consume_token(LEFT_PAREN);
    columnNameList(fkRcl);
    jj_consume_token(RIGHT_PAREN);
    referencedTable = referencesSpecification(refRcl, refActions);
{if ("" != null) return (ConstraintDefinitionNode) nodeFactory.getNode(
                                                C_NodeTypes.FK_CONSTRAINT_DEFINITION_NODE,
                                                constraintName,
                                                referencedTable,
                                                fkRcl,
                                                refRcl,
                                                refActions,
                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public TableName referencesSpecification(ResultColumnList rcl, int[] refActions) throws ParseException, StandardException {TableName tableName = null;
    jj_consume_token(REFERENCES);
    tableName = referencedTableAndColumns(rcl);
    switch (jj_nt.kind) {
    case ON:{
      jj_consume_token(ON);
      referentialTriggeredAction(refActions);
      break;
      }
    default:
      jj_la1[389] = jj_gen;
      ;
    }
{if ("" != null) return tableName;}
    throw new Error("Missing return statement in function");
  }

  final public TableName referencedTableAndColumns(ResultColumnList rcl) throws ParseException, StandardException {TableName       tableName = null;
    tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    switch (jj_nt.kind) {
    case LEFT_PAREN:{
      jj_consume_token(LEFT_PAREN);
      columnNameList(rcl);
      jj_consume_token(RIGHT_PAREN);
      break;
      }
    default:
      jj_la1[390] = jj_gen;
      ;
    }
{if ("" != null) return tableName;}
    throw new Error("Missing return statement in function");
  }

  final public void referentialTriggeredAction(int [] refActions) throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case UPDATE:{
      refActions[1] = updateRule();
      switch (jj_nt.kind) {
      case ON:{
        jj_consume_token(ON);
        refActions[0] = deleteRule();
        break;
        }
      default:
        jj_la1[391] = jj_gen;
        ;
      }
      break;
      }
    case DELETE:{
      refActions[0] = deleteRule();
      switch (jj_nt.kind) {
      case ON:{
        jj_consume_token(ON);
        refActions[1] = updateRule();
        break;
        }
      default:
        jj_la1[392] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[393] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public int updateRule() throws ParseException {int action;
    jj_consume_token(UPDATE);
    action = updateReferentialAction();
{if ("" != null) return action;}
    throw new Error("Missing return statement in function");
  }

  final public int
// GemStone changes BEGIN
 deleteRule() throws ParseException, StandardException {int action;
    jj_consume_token(DELETE);
    action = deleteReferentialAction();
{if ("" != null) return action;}
    throw new Error("Missing return statement in function");
  }

  final public int updateReferentialAction() throws ParseException {
    switch (jj_nt.kind) {
    case RESTRICT:{
      jj_consume_token(RESTRICT);
{if ("" != null) return StatementType.RA_RESTRICT;}
      break;
      }
    case NO:{
      jj_consume_token(NO);
      jj_consume_token(ACTION);
{if ("" != null) return StatementType.RA_NOACTION;}
      break;
      }
    default:
      jj_la1[394] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public int
// GemStone changes BEGIN
 deleteReferentialAction() throws ParseException, StandardException {
    switch (jj_nt.kind) {
    case CASCADE:{
      jj_consume_token(CASCADE);
{if (true) throw StandardException.newException(SQLState.NOT_IMPLEMENTED, "cascade delete");}
      break;
      }
    case RESTRICT:{
      jj_consume_token(RESTRICT);
{if ("" != null) return StatementType.RA_RESTRICT;}
      break;
      }
    case NO:{
      jj_consume_token(NO);
      jj_consume_token(ACTION);
{if ("" != null) return StatementType.RA_NOACTION;}
      break;
      }
    case SET:{
      jj_consume_token(SET);
      switch (jj_nt.kind) {
      case NULL:{
        jj_consume_token(NULL);
{if ("" != null) return StatementType.RA_SETNULL;}
        break;
        }
      case _DEFAULT:{
        jj_consume_token(_DEFAULT);
{if ("" != null) return StatementType.RA_SETDEFAULT;}
        break;
        }
      default:
        jj_la1[395] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[396] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="columnConstraintDefinition">columnConstraintDefinition</A>
 */
  final public void columnConstraintDefinition(DataTypeDescriptor[] dataTypeDescriptor,
                                                   TableElementList tableElementList,
                                                   String columnName) throws ParseException, StandardException {int constraintType;
        TableElementNode tcdn;
        TableName constraintName = null;
    switch (jj_nt.kind) {
    case CONSTRAINT:{
      constraintName = constraintNameDefinition();
      break;
      }
    default:
      jj_la1[397] = jj_gen;
      ;
    }
    tcdn = columnConstraint(constraintName, dataTypeDescriptor, columnName);
/* NOT NULL constraints are handled by marking the dataTypeDescriptor
		 * as being non-nullable.
		 */
                if (tcdn == null)
                {
                        {if ("" != null) return;}
                }

                /* All other constraints, whether column or table will be added as
		 * table constraints.  We do this to facilitate the handling of
		 * multiple column constraints on the same column.
		 */
                tableElementList.addTableElement(tcdn);
  }

/*
 * <A NAME="columnConstraint">columnConstraint</A>
 */
  final public ConstraintDefinitionNode columnConstraint(TableName constraintName,
                                 DataTypeDescriptor[] dataTypeDescriptor,
                                 String columnName) throws ParseException, StandardException {int constraintType;
        Properties properties = null;
        ConstraintDefinitionNode tcdn;
        ResultColumnList refRcl = (ResultColumnList) nodeFactory.getNode(
                                                                                C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                getContextManager());
        TableName referencedTable;
        int[] refActions = {StatementType.RA_NOACTION,
                            StatementType.RA_NOACTION} ; //default: NO ACTION

    switch (jj_nt.kind) {
    case NOT:{
      jj_consume_token(NOT);
      jj_consume_token(NULL);
//If NOT NULL specified more than once, throw syntax error
            if (explicitNotNull)
            {
                         {if (true) throw StandardException.newException(SQLState.LANG_DUPLICATE_PROPERTY, "NOT NULL");}
            }
                //if column is explicitly defined not nullable, set following flag
                explicitNotNull = true;
                //if both null and not null constraints are defined for a column,
                //throw an exception
                if (explicitNull)
                   {if (true) throw StandardException.newException(SQLState.LANG_ADDING_COLUMN_WITH_NULL_AND_NOT_NULL_CONSTRAINT, columnName);}
                dataTypeDescriptor[0] = dataTypeDescriptor[0].getNullabilityType(false);
                {if ("" != null) return null;}
      break;
      }
    case NULL:{
      jj_consume_token(NULL);
//If NULL specified more than once, throw syntax error
            if (explicitNull)
            {
                         {if (true) throw StandardException.newException(SQLState.LANG_DUPLICATE_PROPERTY, "NULL");}
            }
                //if column is explicitly defined nullable, set following flag
                explicitNull = true;
                //if both null and not null constraints are defined for a column,
                //throw an exception
                if (explicitNotNull)
                   {if (true) throw StandardException.newException(SQLState.LANG_ADDING_COLUMN_WITH_NULL_AND_NOT_NULL_CONSTRAINT, columnName);}
                dataTypeDescriptor[0] = dataTypeDescriptor[0].getNullabilityType(true);
                //Add to explicitlyNullable column vector, checked if PK is added on this column
                explicitlyNullableColumnsList.add(columnName);
                {if ("" != null) return null;}
      break;
      }
    case PRIMARY:
    case UNIQUE:{
      //GemStone changes END
              //pass the columnname as the second parameter. It will be used to throw an
              //exception if null constraint is defined for this column-level primary 
              //key constraint
              constraintType = uniqueSpecification(columnName);
      switch (jj_nt.kind) {
      case GEMFIREXDDASHPROPERTIES:{
        properties = propertyList(false);
        jj_consume_token(CHECK_PROPERTIES);
        break;
        }
      default:
        jj_la1[398] = jj_gen;
        ;
      }
ResultColumnList uniqueColumnList =
                                                                                (ResultColumnList) nodeFactory.getNode(
                                                                                                C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                                getContextManager());
                uniqueColumnList.addElement(
                        (ResultColumn) nodeFactory.getNode(
                                                        C_NodeTypes.RESULT_COLUMN,
                                                        columnName,
                                                        null,
                                                        getContextManager()));

                {if ("" != null) return (ConstraintDefinitionNode) nodeFactory.getNode(
                                                C_NodeTypes.CONSTRAINT_DEFINITION_NODE,
                                                constraintName,
                                                ReuseFactory.getInteger(constraintType),
                                                uniqueColumnList,
                                                properties,
                                                null,
                                                null,
                                                getContextManager()
                                                );}
      break;
      }
    case REFERENCES:{
      referencedTable = referencesSpecification(refRcl, refActions);
      switch (jj_nt.kind) {
      case GEMFIREXDDASHPROPERTIES:{
        properties = propertyList(false);
        jj_consume_token(CHECK_PROPERTIES);
        break;
        }
      default:
        jj_la1[399] = jj_gen;
        ;
      }
ResultColumnList fkRcl = (ResultColumnList) nodeFactory.getNode(
                                                                                        C_NodeTypes.RESULT_COLUMN_LIST,
                                                                                        getContextManager());
                fkRcl.addElement(
                                        (ResultColumn) nodeFactory.getNode(
                                                                        C_NodeTypes.RESULT_COLUMN,
                                                                        columnName,
                                                                        null,
                                                                        getContextManager())
                                );
                tcdn = (ConstraintDefinitionNode) nodeFactory.getNode(
                                                C_NodeTypes.FK_CONSTRAINT_DEFINITION_NODE,
                                                constraintName,
                                                referencedTable,
                                                fkRcl,
                                                refRcl,
                                                refActions,
                                                getContextManager());
                if (properties != null)
                {
                        tcdn.setProperties(properties);
                }
                {if ("" != null) return tcdn;}
      break;
      }
    case CHECK:{
      tcdn = checkConstraintDefinition(constraintName, columnName);
{if ("" != null) return tcdn;}
      break;
      }
    default:
      jj_la1[400] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="dropRoleStatement">dropRoleStatement</A>
 */
  final public StatementNode dropRoleStatement() throws ParseException, StandardException {String roleName;
    jj_consume_token(ROLE);
    roleName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
{if (true) throw StandardException.newException
            (SQLState.NOT_IMPLEMENTED, "ROLES");}
                checkVersion( DataDictionary.DD_VERSION_DERBY_10_4, "ROLES");
                checkSqlStandardAccess("DROP ROLE");

                {if ("" != null) return (StatementNode) nodeFactory.getNode(
                        C_NodeTypes.DROP_ROLE_NODE,
                        roleName,
                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode dropSchemaStatement() throws ParseException, StandardException {String schemaName;
        // GemStone changes BEGIN
        Boolean onlyIfExists = Boolean.FALSE;
        // GemStone changes END

    jj_consume_token(SCHEMA);
    switch (jj_nt.kind) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
onlyIfExists = Boolean.TRUE;
      break;
      }
    default:
      jj_la1[401] = jj_gen;
      ;
    }
    schemaName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
    jj_consume_token(RESTRICT);
StatementNode stmt =  (StatementNode) nodeFactory.getNode(
                                                        C_NodeTypes.DROP_SCHEMA_NODE,
                                                        schemaName,
// GemStone changes BEGIN
                                                        onlyIfExists,
                                                        // changed to use Integer.valueOf()
                                                        Integer.valueOf(StatementType.DROP_RESTRICT),
// GemStone changes END
                                                        getContextManager());

                {if ("" != null) return stmt;}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode alterTableStatement() throws ParseException, StandardException {StatementNode           node;
        TableName                       tableName;
    jj_consume_token(TABLE);
    tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    node = alterTableBody(tableName);
{if ("" != null) return node;}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode alterTableBody(TableName tableName) throws ParseException, StandardException {StatementNode qtn;
        char                            lockGranularity = '\0';
        String               newTableName;
        TableElementList        tableElementList =
                                                                        (TableElementList) nodeFactory.getNode(
                                                                                                C_NodeTypes.TABLE_ELEMENT_LIST,
                                                                                                getContextManager());
        Token                           tok = null;
        int[]                           changeType = new int[1];
        int[]                           behavior = new int[1];
        boolean[]                       sequential = new boolean[1];
        boolean[]           isSet = new boolean[1];
// GemStone changes BEGIN
        GfxdAttributesMutator mutator = new GfxdAttributesMutator();
// GemStone changes END

    switch (jj_nt.kind) {
    case COMPRESS:{
      jj_consume_token(COMPRESS);
      switch (jj_nt.kind) {
      case SEQUENTIAL:{
        tok = jj_consume_token(SEQUENTIAL);
        break;
        }
      default:
        jj_la1[402] = jj_gen;
        ;
      }
checkInternalFeature("COMPRESS");
                {if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                        C_NodeTypes.ALTER_TABLE_NODE,
                                                        tableName,
// GemStone changes BEGIN
                                                        // changed to use valueOf()
                                                        Boolean.valueOf(tok != null),
                                                        /* (original code)
							new Boolean(tok != null),
							*/
// GemStone changes END
                                                        getContextManager());}
      break;
      }
    case ADD:
    case ALTER:
    case DROP:
    case SET:{
      // GemStone changes BEGIN
              lockGranularity = alterTableAction(tableName, tableElementList, mutator,
                      changeType, isSet, behavior, sequential);
{if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                        C_NodeTypes.ALTER_TABLE_NODE,
                                                        tableName,
                                                        tableElementList,
// GemStone changes BEGIN
                                                        mutator,
                                                        // changed to use valueOf()
                                                        Character.valueOf(lockGranularity),
// GemStone changes END
                                                        changeType,
                                                        // GemStone changes BEGIN
                                                        isSet,
                                                        // GemStone changes END		
                                                        behavior,
                                                        sequential,
                                                        getContextManager());}
      break;
      }
    default:
      jj_la1[403] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="alterTableRenameTableStatement">alterTableRenameTableStatement</A>
 */
/*
StatementNode
alterTableRenameTableStatement(TableName tableName) throws StandardException :
{
	String newTableName;
}
{
	<TO> newTableName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true)
	{
		return (StatementNode) nodeFactory.getNode(
							C_NodeTypes.RENAME_NODE,
							tableName,
							null,
							newTableName,
							Boolean.TRUE,
ReuseFactory.getInteger(StatementType.RENAME_TABLE),
							getContextManager());
	}
}
*/

/*
 * <A NAME="alterTableRenameColumnStatement">alterTableRenameColumnStatement</A>
 */
/*
StatementNode
alterTableRenameColumnStatement(TableName tableName) throws StandardException :
{
	String oldColumnName;
	String newColumnName;
}
{
	oldColumnName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true) <TO> newColumnName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true)
	{
		return (StatementNode) nodeFactory.getNode(
							C_NodeTypes.RENAME_NODE,
							tableName,
							oldColumnName,
							newColumnName,
							Boolean.TRUE,
ReuseFactory.getInteger(StatementType.RENAME_COLUMN),
							getContextManager());
	}
}
*/
// GemStone changes BEGIN
  final public char alterTableAction(TableName tableName, TableElementList tableElementList,
        GfxdAttributesMutator mutator, int[] changeType, boolean[] isSet, int[] behavior,
        boolean[] sequential) throws ParseException, StandardException {int                                     evictionLimit;
        int                                     expirationKind;
        ExpirationAttributes[] exprAttrs = new ExpirationAttributes[1];
        String gatewayId = null;
        String hdfsStoreName = null;
        java.sql.Timestamp startTime = null;
        BigDecimal[] interval = new BigDecimal[1];
        long startMillis = 0, intervalMillis = 0;
/*
char
alterTableAction(TableElementList tableElementList, int[] changeType, int[] behavior, boolean[] sequential) throws StandardException :
{
*/
// GemStone changes END
        char                            lockGranularity = '\0';
        TableElementNode        tableElement;
        DataTypeDescriptor      typeDescriptor;
        Token                           tok = null;
        String                          columnName;
// GemStone changes BEGIN
        long[]                          autoIncrementInfo = new long[7];
        /* (original code)
	long[]				autoIncrementInfo = new long[4];
	*/
// GemStone changes END

    switch (jj_nt.kind) {
    case ADD:{
      jj_consume_token(ADD);
      if (jj_2_72(1)) {
        tableElement = addColumnDefinition(tableElementList);
      } else {
        switch (jj_nt.kind) {
        case CHECK:
        case CONSTRAINT:
        case FOREIGN:
        case PRIMARY:
        case UNIQUE:{
          tableElement = tableConstraintDefinition();
          break;
          }
        default:
          jj_la1[404] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
if (tableElement instanceof ColumnDefinitionNode)
                {
                        //bug 5724 - auto increment columns not allowed in ALTER TABLE statement
                        ColumnDefinitionNode cdn = (ColumnDefinitionNode) tableElement;
                        if ( cdn.isAutoincrementColumn())
                                {if (true) throw StandardException.newException(SQLState.LANG_ALTER_TABLE_AUTOINCREMENT_COLUMN_NOT_ALLOWED);}
                }
                changeType[0] = DDLStatementNode.ADD_TYPE;
                tableElementList.addTableElement(tableElement);
                {if ("" != null) return lockGranularity;}
      break;
      }
    case ALTER:{
      jj_consume_token(ALTER);
      switch (jj_nt.kind) {
      case COLUMN:{
        jj_consume_token(COLUMN);
        break;
        }
      default:
        jj_la1[405] = jj_gen;
        ;
      }
      columnName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
      tableElement = columnAlterClause(columnName);
changeType[0] = DDLStatementNode.MODIFY_TYPE;
                tableElementList.addTableElement(tableElement);
                isSet[0]=true;
                {if ("" != null) return lockGranularity;}
      break;
      }
    case DROP:{
      jj_consume_token(DROP);
      if (jj_2_73(1)) {
        tableElement = dropColumnDefinition(behavior);
      } else if (jj_2_74(1)) {
        tableElement = dropTableConstraintDefinition();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
changeType[0] = DDLStatementNode.DROP_TYPE;
                tableElementList.addTableElement(tableElement);
                {if ("" != null) return lockGranularity;}
      break;
      }
    case SET:{
      jj_consume_token(SET);
      switch (jj_nt.kind) {
      case EVICTION:{
        jj_consume_token(EVICTION);
        switch (jj_nt.kind) {
        case MAXSIZE:{
          jj_consume_token(MAXSIZE);
          evictionLimit = simpleValueSpecification_int();
mutator.setEvictionMaximum(evictionLimit);
                          changeType[0] = DDLStatementNode.MODIFY_TYPE;
                          isSet[0]=true;
                          {if ("" != null) return lockGranularity;}
          break;
          }
        case FREQUENCY:{
          startTime = evictionFrequency(interval);
if (startTime != null) {
                  startMillis = startTime.getTime();
                }
                intervalMillis = interval[0].longValue() * 1000L;
                if (!Misc.getMemStoreBooting().isHadoopGfxdLonerMode())
                        mutator.setCustomEvictionAttributes(startMillis, intervalMillis);
                changeType[0] = DDLStatementNode.MODIFY_TYPE;
                isSet[0] = true;
                {if ("" != null) return lockGranularity;}
          break;
          }
        default:
          jj_la1[406] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case GATEWAYSENDER:{
        jj_consume_token(GATEWAYSENDER);
        jj_consume_token(LEFT_PAREN);
        if (jj_2_75(1)) {
          gatewayId = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
mutator.addGatewaySenderId(gatewayId);
          label_61:
          while (true) {
            switch (jj_nt.kind) {
            case COMMA:{
              ;
              break;
              }
            default:
              jj_la1[407] = jj_gen;
              break label_61;
            }
            jj_consume_token(COMMA);
            gatewayId = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
mutator.addGatewaySenderId(gatewayId);
          }
        } else {
          ;
        }
        jj_consume_token(RIGHT_PAREN);
mutator.setIsAlterGatewaySender(true);
              changeType[0] = DDLStatementNode.MODIFY_TYPE;
              isSet[0]=true;
          {if ("" != null) return lockGranularity;}
        break;
        }
      case ASYNCLISTENER:{
        jj_consume_token(ASYNCLISTENER);
        jj_consume_token(LEFT_PAREN);
        if (jj_2_76(1)) {
          gatewayId = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
mutator.addAsyncEventQueueId(gatewayId);
          label_62:
          while (true) {
            switch (jj_nt.kind) {
            case COMMA:{
              ;
              break;
              }
            default:
              jj_la1[408] = jj_gen;
              break label_62;
            }
            jj_consume_token(COMMA);
            gatewayId = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
mutator.addAsyncEventQueueId(gatewayId);
          }
        } else {
          ;
        }
        jj_consume_token(RIGHT_PAREN);
mutator.setIsAlterAsyncEventListener(true);
              changeType[0] = DDLStatementNode.MODIFY_TYPE;
              isSet[0]=true;
          {if ("" != null) return lockGranularity;}
        break;
        }
      case EXPIRE:{
        expirationKind = expirationKindDefinition(exprAttrs);
mutator.setExpirationKind(expirationKind);
                        mutator.setExpirationAttributes(exprAttrs[0]);
                        changeType[0] = DDLStatementNode.MODIFY_TYPE;
                        isSet[0]=true;
                        {if ("" != null) return lockGranularity;}
        break;
        }
      default:
        jj_la1[409] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[410] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * Handle
 *
 *    ALTER TABLE tablename DROP [ COLUMN ] columnname [ CASCADE | RESTRICT ]
 */
  final public TableElementNode dropColumnDefinition(int []behavior) throws ParseException, StandardException {String columnName;
        TableElementNode tableElement;
    switch (jj_nt.kind) {
    case COLUMN:{
      jj_consume_token(COLUMN);
      break;
      }
    default:
      jj_la1[411] = jj_gen;
      ;
    }
    columnName = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
    dropColumnReferentialAction(behavior);
{if ("" != null) return (TableElementNode) nodeFactory.getNode(
                                                C_NodeTypes.DROP_COLUMN_NODE,
                                                columnName, null,
                                                null, null,
                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public void dropColumnReferentialAction(int []behavior) throws ParseException {int refBehavior = StatementType.DROP_RESTRICT;
    switch (jj_nt.kind) {
    case CASCADE:
    case RESTRICT:{
      switch (jj_nt.kind) {
      case CASCADE:{
        jj_consume_token(CASCADE);
refBehavior = StatementType.DROP_CASCADE;
        break;
        }
      case RESTRICT:{
        jj_consume_token(RESTRICT);
refBehavior = StatementType.DROP_RESTRICT;
        break;
        }
      default:
        jj_la1[412] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[413] = jj_gen;
      ;
    }
behavior[0] = refBehavior;
  }

  final public TableElementNode addColumnDefinition(TableElementList tableElementList) throws ParseException, StandardException {TableElementNode        tableElement;
    switch (jj_nt.kind) {
    case COLUMN:{
      jj_consume_token(COLUMN);
      break;
      }
    default:
      jj_la1[414] = jj_gen;
      ;
    }
    tableElement = columnDefinition(tableElementList);
{if ("" != null) return tableElement;}
    throw new Error("Missing return statement in function");
  }

/*
 * Various variants of the ALTER TABLE ALTER COLUMN statement.
 *
 * By the type we get here, we've parsed
 *    ALTER TABLE tablename ALTER [COLUMN] columnname
 * and here we parse the remainder of the ALTER COLUMN clause, one of:
 *		SET DATA TYPE data_type
 *		SET INCREMENT BY increment_value
 *		RESTART WITH increment_restart_value
 *		[WITH] DEFAULT default_value
 *      [NOT] NULL
 */
  final public TableElementNode columnAlterClause(String columnName) throws ParseException, StandardException {ValueNode       defaultNode;
// GemStone changes BEGIN
        long[]                          autoIncrementInfo = new long[7];
        /* (original code)
	long[]				autoIncrementInfo = new long[4];
	*/

// GemStone changes END
        long                            autoIncrementIncrement = 1;
        long                            autoIncrementRestartWith = 1;
        DataTypeDescriptor      typeDescriptor = null;
    if (getToken(2).kind == DATA) {
      jj_consume_token(SET);
      jj_consume_token(DATA);
      jj_consume_token(TYPE);
      typeDescriptor = dataTypeDDL();
{if ("" != null) return (TableElementNode) nodeFactory.getNode(
                                                C_NodeTypes.MODIFY_COLUMN_TYPE_NODE,
                                                columnName, null,
                                                typeDescriptor, null,
                                                getContextManager());}
    } else if (getToken(2).kind == INCREMENT) {
      jj_consume_token(SET);
      jj_consume_token(INCREMENT);
      jj_consume_token(BY);
      autoIncrementIncrement = exactNumber();
autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_INC_INDEX] = autoIncrementIncrement;
                autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_CREATE_MODIFY] = ColumnDefinitionNode.MODIFY_AUTOINCREMENT_INC_VALUE;
                autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_IS_GENERATED_BY_DEFAULT] = 1;
                {if ("" != null) return (TableElementNode) nodeFactory.getNode(
                                                C_NodeTypes.MODIFY_COLUMN_DEFAULT_NODE,
                                                columnName,
                                                null, null, autoIncrementInfo,
                                                getContextManager());}
    } else if (getToken(2).kind == GENERATED) {
      jj_consume_token(SET);
      jj_consume_token(GENERATED);
      jj_consume_token(ALWAYS);
      jj_consume_token(AS);
      jj_consume_token(IDENTITY);
autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_START_INDEX] = 1;
            autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_INC_INDEX] = 1;
                autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_IS_AUTOINCREMENT_INDEX] = 1;
                autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_CREATE_MODIFY] = ColumnDefinitionNode.CREATE_AUTOINCREMENT;
                autoIncrementInfo[QueryTreeNode.SET_AUTOINCREMENT] = 1;
                {if ("" != null) return (TableElementNode) nodeFactory.getNode(
                                                C_NodeTypes.MODIFY_COLUMN_DEFAULT_NODE,
                                                columnName,
                                                null, null, autoIncrementInfo,
                                                getContextManager());}
    } else {
      switch (jj_nt.kind) {
      case RESTART:{
        jj_consume_token(RESTART);
        jj_consume_token(WITH);
        autoIncrementRestartWith = exactNumber();
autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_START_INDEX] = autoIncrementRestartWith;
                autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_CREATE_MODIFY] = ColumnDefinitionNode.MODIFY_AUTOINCREMENT_RESTART_VALUE;
                autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_IS_GENERATED_BY_DEFAULT] = 1;
                {if ("" != null) return (TableElementNode) nodeFactory.getNode(
                                                C_NodeTypes.MODIFY_COLUMN_DEFAULT_NODE,
                                                columnName,
                                                null, null, autoIncrementInfo,
                                                getContextManager());}
        break;
        }
      default:
        jj_la1[415] = jj_gen;
        if (getToken(1).kind == WITH || getToken(1).kind == _DEFAULT) {
          defaultNode = defaultClause(autoIncrementInfo, columnName);
if (autoIncrementInfo[QueryTreeNode.AUTOINCREMENT_IS_AUTOINCREMENT_INDEX]
                                 == 0)
                {
                        autoIncrementInfo = null;
                }

                {if ("" != null) return (TableElementNode) nodeFactory.getNode(
                                                                C_NodeTypes.MODIFY_COLUMN_DEFAULT_NODE,
                                                                columnName,
                                                                defaultNode, null, autoIncrementInfo,
                                                                getContextManager());}
        } else if (getToken(1).kind == NULL) {
          jj_consume_token(NULL);
// for a MODIFY column NULL clause form a modify_column node
                // with all null values. In a column definition a [NOT] NULL
                // column constraint is specified by setting the right value
                // in the nullability field of the data type but we don't have
                // a datatype here.
                {if ("" != null) return (TableElementNode) nodeFactory.getNode(
                                                                C_NodeTypes.MODIFY_COLUMN_CONSTRAINT_NODE,
                                                                columnName, null, null, null,
                                                                getContextManager());}
        } else if (getToken(1).kind == NOT) {
          jj_consume_token(NOT);
          jj_consume_token(NULL);
// for a MODIFY column NOT NULL clause form a modify_column node
                // with all null values. In a column definition a [NOT] NULL
                // column constraint is specified by setting the right value
                // in the nullability field of the data type but we don't have
                // a datatype here.
                {if ("" != null) return (TableElementNode) nodeFactory.getNode(
                                                                C_NodeTypes.MODIFY_COLUMN_CONSTRAINT_NOT_NULL_NODE,
                                                                columnName, null, null, null,
                                                                getContextManager());}
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public TableElementNode dropTableConstraintDefinition() throws ParseException, StandardException {TableName                constraintName;
    if (getToken(1).kind == CONSTRAINT) {
      jj_consume_token(CONSTRAINT);
      constraintName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
{if ("" != null) return (TableElementNode) nodeFactory.getNode(
                                                C_NodeTypes.CONSTRAINT_DEFINITION_NODE,
                                                constraintName,
                                                ReuseFactory.getInteger(DataDictionary.DROP_CONSTRAINT),
                                                null,
                                                null,
                                                null,
                                                null,
                                                ReuseFactory.getInteger(StatementType.DROP_DEFAULT),
                                                getContextManager()
                                                );}
    } else if (getToken(1).kind == PRIMARY) {
      jj_consume_token(PRIMARY);
      jj_consume_token(KEY);
{if ("" != null) return (TableElementNode) nodeFactory.getNode(
                                                C_NodeTypes.CONSTRAINT_DEFINITION_NODE,
                                                null,
                                                ReuseFactory.getInteger(DataDictionary.DROP_CONSTRAINT),
                                                null,
                                                null,
                                                null,
                                                null,
                                                ReuseFactory.getInteger(StatementType.DROP_DEFAULT),
                                                getContextManager()
                                                );}
    } else if (getToken(1).kind == FOREIGN) {
      jj_consume_token(FOREIGN);
      jj_consume_token(KEY);
      constraintName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
{if ("" != null) return (TableElementNode) nodeFactory.getNode(
                                                C_NodeTypes.CONSTRAINT_DEFINITION_NODE,
                                                constraintName,
                                                ReuseFactory.getInteger(DataDictionary.DROP_CONSTRAINT),
                                                null,
                                                null,
                                                null,
                                                null,
                                                ReuseFactory.getInteger(StatementType.DROP_DEFAULT),
                                                ReuseFactory.getInteger(DataDictionary.FOREIGNKEY_CONSTRAINT),
                                                getContextManager()
                                                );}
    } else if (getToken(1).kind == UNIQUE) {
      jj_consume_token(UNIQUE);
      constraintName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
{if ("" != null) return (TableElementNode) nodeFactory.getNode(
                                                C_NodeTypes.CONSTRAINT_DEFINITION_NODE,
                                                constraintName,
                                                ReuseFactory.getInteger(DataDictionary.DROP_CONSTRAINT),
                                                null,
                                                null,
                                                null,
                                                null,
                                                ReuseFactory.getInteger(StatementType.DROP_DEFAULT),
                                                ReuseFactory.getInteger(DataDictionary.UNIQUE_CONSTRAINT),
                                                getContextManager()
                                                );}
    } else {
      switch (jj_nt.kind) {
      case CHECK:{
        jj_consume_token(CHECK);
        constraintName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
{if ("" != null) return (TableElementNode) nodeFactory.getNode(
                                                C_NodeTypes.CONSTRAINT_DEFINITION_NODE,
                                                constraintName,
                                                ReuseFactory.getInteger(DataDictionary.DROP_CONSTRAINT),
                                                null,
                                                null,
                                                null,
                                                null,
                                                ReuseFactory.getInteger(StatementType.DROP_DEFAULT),
                                                ReuseFactory.getInteger(DataDictionary.CHECK_CONSTRAINT),
                                                getContextManager()
                                                );}
        break;
        }
      default:
        jj_la1[416] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="dropTableStatement">dropTableStatement</A>
 */
  final public StatementNode dropTableStatement() throws ParseException, StandardException {TableName tableName;
// GemStone changes BEGIN
        Boolean onlyIfExists = Boolean.FALSE;
        CompilerContext cc = getCompilerContext();
// GemStone changes END

    jj_consume_token(TABLE);
cc.markAsDDLForSnappyUse(true);
          cc.setForcedDDLrouting(true);
    switch (jj_nt.kind) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
onlyIfExists = Boolean.TRUE;
      break;
      }
    default:
      jj_la1[417] = jj_gen;
      ;
    }
    tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
// DB2 does not support a drop behaviour
                {if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                                        C_NodeTypes.DROP_TABLE_NODE,
                                                                                        tableName,
// GemStone changes BEGIN
                                                                                        onlyIfExists,
                                                                                        // changed to use Integer.valueOf()
                                                                                        Integer.valueOf(StatementType.DROP_DEFAULT),
// GemStone changes END
                                                                                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="dropIndexStatement">dropIndexStatement</A>
 */
  final public StatementNode dropIndexStatement() throws ParseException, StandardException {TableName indexName;
// GemStone changes BEGIN
        Boolean onlyIfExists = Boolean.FALSE;
// GemStone changes END

    jj_consume_token(INDEX);
    switch (jj_nt.kind) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
onlyIfExists = Boolean.TRUE;
      break;
      }
    default:
      jj_la1[418] = jj_gen;
      ;
    }
    indexName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
{if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.DROP_INDEX_NODE,
                                                                indexName,
// GemStone changes BEGIN								
                                                                onlyIfExists,
// GemStone changes END								
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="dropAliasStatement">dropAliasStatement</A>
 */
  final public StatementNode dropAliasStatement() throws ParseException, StandardException {Object aliasName;
// GemStone changes BEGIN
        Boolean onlyIfExists = Boolean.FALSE;
// GemStone changes END

    switch (jj_nt.kind) {
    case PROCEDURE:{
      jj_consume_token(PROCEDURE);
      switch (jj_nt.kind) {
      case IF:{
        jj_consume_token(IF);
        jj_consume_token(EXISTS);
onlyIfExists = Boolean.TRUE;
        break;
        }
      default:
        jj_la1[419] = jj_gen;
        ;
      }
      // GemStone changes END
              aliasName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
{if ("" != null) return dropAliasNode(aliasName, AliasInfo.ALIAS_TYPE_PROCEDURE_AS_CHAR
// GemStone changes BEGIN
                                        ,onlyIfExists
// GemStone changes END
                                        );}
      break;
      }
    case FUNCTION:{
      jj_consume_token(FUNCTION);
      switch (jj_nt.kind) {
      case IF:{
        jj_consume_token(IF);
        jj_consume_token(EXISTS);
onlyIfExists = Boolean.TRUE;
        break;
        }
      default:
        jj_la1[420] = jj_gen;
        ;
      }
      // GemStone changes END
          aliasName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
{if ("" != null) return dropAliasNode(aliasName, AliasInfo.ALIAS_TYPE_FUNCTION_AS_CHAR
// GemStone changes BEGIN
                                        ,onlyIfExists
// GemStone changes END
                                        );}
      break;
      }
    case SYNONYM:{
      jj_consume_token(SYNONYM);
      switch (jj_nt.kind) {
      case IF:{
        jj_consume_token(IF);
        jj_consume_token(EXISTS);
onlyIfExists = Boolean.TRUE;
        break;
        }
      default:
        jj_la1[421] = jj_gen;
        ;
      }
      // GemStone changes END
              aliasName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
checkVersion(DataDictionary.DD_VERSION_DERBY_10_1, "DROP SYNONYM");

                {if ("" != null) return dropAliasNode(aliasName, AliasInfo.ALIAS_TYPE_SYNONYM_AS_CHAR
// GemStone changes BEGIN
                                        ,onlyIfExists
// GemStone changes END
                                        );}
      break;
      }
    case TYPE:{
      jj_consume_token(TYPE);
      switch (jj_nt.kind) {
      case IF:{
        jj_consume_token(IF);
        jj_consume_token(EXISTS);
onlyIfExists = Boolean.TRUE;
        break;
        }
      default:
        jj_la1[422] = jj_gen;
        ;
      }
      // GemStone changes END
              aliasName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
      jj_consume_token(RESTRICT);
checkVersion(DataDictionary.DD_VERSION_DERBY_10_4, "DROP TYPE");

                {if ("" != null) return dropAliasNode(aliasName, AliasInfo.ALIAS_TYPE_UDT_AS_CHAR
// GemStone changes BEGIN
                                        ,onlyIfExists
// GemStone changes END
                                        );}
      break;
      }
    case ALIAS:{
      jj_consume_token(ALIAS);
      switch (jj_nt.kind) {
      case IF:{
        jj_consume_token(IF);
        jj_consume_token(EXISTS);
onlyIfExists = Boolean.TRUE;
        break;
        }
      default:
        jj_la1[423] = jj_gen;
        ;
      }
      aliasName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
{if ("" != null) return dropAliasNode(aliasName,
                        AliasInfo.ALIAS_TYPE_RESULT_PROCESSOR_AS_CHAR,
                                        onlyIfExists);}
      break;
      }
    default:
      jj_la1[424] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public StatementNode dropViewStatement() throws ParseException, StandardException {TableName viewName;
// GemStone changes BEGIN
        Boolean onlyIfExists = Boolean.FALSE;
// GemStone changes END

    jj_consume_token(VIEW);
    switch (jj_nt.kind) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
onlyIfExists = Boolean.TRUE;
      break;
      }
    default:
      jj_la1[425] = jj_gen;
      ;
    }
    // GemStone changes END
            viewName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
{if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.DROP_VIEW_NODE,
                                                                viewName,
// GemStone changes BEGIN								
                                                                onlyIfExists,
// GemStone changes END								
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode dropTriggerStatement() throws ParseException, StandardException {TableName triggerName;
// GemStone changes BEGIN
        Boolean onlyIfExists = Boolean.FALSE;
// GemStone changes END

    jj_consume_token(TRIGGER);
    switch (jj_nt.kind) {
    case IF:{
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
onlyIfExists = Boolean.TRUE;
      break;
      }
    default:
      jj_la1[426] = jj_gen;
      ;
    }
    // GemStone changes END
            triggerName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
{if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                                C_NodeTypes.DROP_TRIGGER_NODE,
                                                                triggerName,
// GemStone changes BEGIN								
                                                                onlyIfExists,
// GemStone changes END								
                                                                getContextManager());}
    throw new Error("Missing return statement in function");
  }

  final public StatementNode truncateTableStatement() throws ParseException, StandardException {TableName tableName;
    jj_consume_token(TRUNCATE);
    jj_consume_token(TABLE);
    tableName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
// GemStone changes BEGIN
  CompilerContext cc = getCompilerContext();
  cc.markAsDDLForSnappyUse(true);
  cc.setForcedDDLrouting(true);
                {if ("" != null) return (StatementNode) nodeFactory.getNode(
                                                        C_NodeTypes.ALTER_TABLE_NODE,
                                                        tableName,
                                                        getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="grantStatement">grantStatement</A>
 */
  final public StatementNode grantStatement() throws ParseException, StandardException {StatementNode node;
    if (getToken(1).kind == GRANT &&
                                    ((getToken(2).kind == TRIGGER &&
                                      ((getToken(3).kind == COMMA &&
                                            isPrivilegeKeywordExceptTrigger(getToken(4).kind)) ||
                                       getToken(3).kind == ON)) ||
                                     isPrivilegeKeywordExceptTrigger(getToken(2).kind))) {
      jj_consume_token(GRANT);
checkVersion( DataDictionary.DD_VERSION_DERBY_10_2, "GRANT");
                checkSqlStandardAccess( "GRANT");
      switch (jj_nt.kind) {
      case ALL:
      case ALTER:
      case DELETE:
      case INSERT:
      case REFERENCES:
      case SELECT:
      case UPDATE:
      case TRIGGER:{
        node = tableGrantStatement();
        break;
        }
      case EXECUTE:{
        node = routineGrantStatement();
        break;
        }
      default:
        jj_la1[427] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return node;}
    } else if (getToken(1).kind == GRANT &&
                                    ((getToken(2).kind == TRIGGER &&
                                      ((getToken(3).kind == COMMA &&
                                            !isPrivilegeKeywordExceptTrigger(getToken(4).kind)) ||
                                       getToken(3).kind == TO)) ||
                                     !isPrivilegeKeywordExceptTrigger(getToken(2).kind))) {
      jj_consume_token(GRANT);
      node = roleGrantStatement();
{if ("" != null) return node;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="tableGrantStatement">tableGrantStatement</A>
 */
  final public StatementNode tableGrantStatement() throws ParseException, StandardException {PrivilegeNode privileges;
    List grantees;
    privileges = tablePrivileges();
    jj_consume_token(TO);
    grantees = granteeList();
{if ("" != null) return (StatementNode) nodeFactory.getNode( C_NodeTypes.GRANT_NODE,
                                    privileges, grantees,
                                    getContextManager());}
    throw new Error("Missing return statement in function");
  }

// end of tableGrantStatement

/*
 * <A NAME="tablePrivileges">tablePrivileges</A>
 */
  final public PrivilegeNode tablePrivileges() throws ParseException, StandardException {TablePrivilegesNode tablePrivilegesNode = null;
    TableName objectName = null;
    tablePrivilegesNode = tableActions();
    jj_consume_token(ON);
    switch (jj_nt.kind) {
    case TABLE:{
      jj_consume_token(TABLE);
      break;
      }
    default:
      jj_la1[428] = jj_gen;
      ;
    }
    objectName = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
{if ("" != null) return (PrivilegeNode) nodeFactory.getNode( C_NodeTypes.PRIVILEGE_NODE,
                                                    ReuseFactory.getInteger( PrivilegeNode.TABLE_PRIVILEGES),
                                                    objectName, tablePrivilegesNode,
                                                    getContextManager());}
    throw new Error("Missing return statement in function");
  }

// end of   tablePrivilege                               

/*
 * <A NAME="tableActions">tableActions</A>
 */
  final public TablePrivilegesNode tableActions() throws ParseException, StandardException {TablePrivilegesNode tableActionsNode = (TablePrivilegesNode)
      nodeFactory.getNode( C_NodeTypes.TABLE_PRIVILEGES_NODE, getContextManager());
    switch (jj_nt.kind) {
    case ALL:{
      jj_consume_token(ALL);
      jj_consume_token(PRIVILEGES);
tableActionsNode.addAll();
        {if ("" != null) return tableActionsNode;}
      break;
      }
    case ALTER:
    case DELETE:
    case INSERT:
    case REFERENCES:
    case SELECT:
    case UPDATE:
    case TRIGGER:{
      tableAction(tableActionsNode);
      label_63:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[429] = jj_gen;
          break label_63;
        }
        jj_consume_token(COMMA);
        tableAction(tableActionsNode);
      }
{if ("" != null) return tableActionsNode;}
      break;
      }
    default:
      jj_la1[430] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// end of tableActions

/*
 * <A NAME="routineGrantStatement">routineGrantStatement</A>
 */
  final public StatementNode routineGrantStatement() throws ParseException, StandardException {List grantees;
    RoutineDesignator routine;
    jj_consume_token(EXECUTE);
    jj_consume_token(ON);
    routine = routineDesignator();
    jj_consume_token(TO);
    grantees = granteeList();
PrivilegeNode routinePrivilege = (PrivilegeNode)
          nodeFactory.getNode( C_NodeTypes.PRIVILEGE_NODE,
                               ReuseFactory.getInteger( PrivilegeNode.ROUTINE_PRIVILEGES),
                               routine, null,
                               getContextManager());
        {if ("" != null) return (StatementNode) nodeFactory.getNode( C_NodeTypes.GRANT_NODE,
                                    routinePrivilege, grantees,
                                    getContextManager());}
    throw new Error("Missing return statement in function");
  }

// end of routineGrantStatement

/*
 * <A NAME="routineAlias">routineAlias</A>
 */
  final public RoutineDesignator routineDesignator() throws ParseException, StandardException {Token procOrFunction;
    TableName name;
    List paramTypeList = null;
    switch (jj_nt.kind) {
    case FUNCTION:{
      procOrFunction = jj_consume_token(FUNCTION);
      break;
      }
    case PROCEDURE:{
      procOrFunction = jj_consume_token(PROCEDURE);
      break;
      }
    default:
      jj_la1[431] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    name = qualifiedName(Limits.MAX_IDENTIFIER_LENGTH);
    switch (jj_nt.kind) {
    case LEFT_PAREN:{
      jj_consume_token(LEFT_PAREN);
      paramTypeList = parameterTypeList();
      jj_consume_token(RIGHT_PAREN);
      break;
      }
    default:
      jj_la1[432] = jj_gen;
      ;
    }
{if ("" != null) return new RoutineDesignator( false,
                                      name,
                                      (procOrFunction.kind == FUNCTION),
                                      paramTypeList);}
    throw new Error("Missing return statement in function");
  }

// end of routineDesignator


/*
 * <A NAME="parameterTypeList">parameterTypeList</A>
 */
  final public List/*<TypeDescriptor>*/ parameterTypeList() throws ParseException, StandardException {ArrayList list = new ArrayList();
    TypeDescriptor type;
    if (jj_2_77(1)) {
      type = catalogType();
list.add(type);
      label_64:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[433] = jj_gen;
          break label_64;
        }
        jj_consume_token(COMMA);
        type = catalogType();
list.add(type);
      }
    } else {
      ;
    }
{if ("" != null) return list;}
    throw new Error("Missing return statement in function");
  }

// end of parameterTypeList


/*
 * <A NAME="tableAction">tableAction</A>
 */
  final public void tableAction(TablePrivilegesNode tablePrivilegesNode) throws ParseException, StandardException {ResultColumnList columnList = null;
    switch (jj_nt.kind) {
    case SELECT:{
      jj_consume_token(SELECT);
      switch (jj_nt.kind) {
      case LEFT_PAREN:{
        columnList = privilegeColumnList();
        break;
        }
      default:
        jj_la1[434] = jj_gen;
        ;
      }
tablePrivilegesNode.addAction( TablePrivilegeInfo.SELECT_ACTION, columnList);
      break;
      }
    case DELETE:{
      jj_consume_token(DELETE);
tablePrivilegesNode.addAction( TablePrivilegeInfo.DELETE_ACTION, (ResultColumnList) null);
      break;
      }
    case INSERT:{
      jj_consume_token(INSERT);
tablePrivilegesNode.addAction( TablePrivilegeInfo.INSERT_ACTION, (ResultColumnList) null);
      break;
      }
    case UPDATE:{
      jj_consume_token(UPDATE);
      switch (jj_nt.kind) {
      case LEFT_PAREN:{
        columnList = privilegeColumnList();
        break;
        }
      default:
        jj_la1[435] = jj_gen;
        ;
      }
tablePrivilegesNode.addAction( TablePrivilegeInfo.UPDATE_ACTION, columnList);
      break;
      }
    case REFERENCES:{
      jj_consume_token(REFERENCES);
      switch (jj_nt.kind) {
      case LEFT_PAREN:{
        columnList = privilegeColumnList();
        break;
        }
      default:
        jj_la1[436] = jj_gen;
        ;
      }
tablePrivilegesNode.addAction( TablePrivilegeInfo.REFERENCES_ACTION, columnList);
      break;
      }
    case TRIGGER:{
      jj_consume_token(TRIGGER);
tablePrivilegesNode.addAction( TablePrivilegeInfo.TRIGGER_ACTION, (ResultColumnList) null);
      break;
      }
    case ALTER:{
      jj_consume_token(ALTER);
tablePrivilegesNode.addAction( TablePrivilegeInfo.ALTER_ACTION, (ResultColumnList) null);
      break;
      }
    default:
      jj_la1[437] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

// end of tableAction

/*
 * <A NAME="privilegeColumnList">privilegeColumnList</A>
 */
  final public ResultColumnList privilegeColumnList() throws ParseException, StandardException {ResultColumnList cl = (ResultColumnList) nodeFactory.getNode( C_NodeTypes.RESULT_COLUMN_LIST,
                                                                  getContextManager());
    jj_consume_token(LEFT_PAREN);
    columnNameList(cl);
    jj_consume_token(RIGHT_PAREN);
{if ("" != null) return cl;}
    throw new Error("Missing return statement in function");
  }

// end of privilegeColumnList

/*
 * <A NAME="granteeList">granteeList</A>
 */
  final public List granteeList() throws ParseException, StandardException {ArrayList list = new ArrayList();
    grantee(list);
    label_65:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[438] = jj_gen;
        break label_65;
      }
      jj_consume_token(COMMA);
      grantee(list);
    }
{if ("" != null) return list;}
    throw new Error("Missing return statement in function");
  }

  final public void grantee(List list) throws ParseException, StandardException {String str;
    switch (jj_nt.kind) {
    case LDAPGROUP:{
      jj_consume_token(LDAPGROUP);
      jj_consume_token(COLON);
      str = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
list.add(Constants.LDAP_GROUP_PREFIX + str);
      break;
      }
    default:
      jj_la1[439] = jj_gen;
      if (jj_2_78(1)) {
        // GemStone changes END
            str = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
list.add(str);
      } else {
        switch (jj_nt.kind) {
        case PUBLIC:{
          jj_consume_token(PUBLIC);
list.add( Authorizer.PUBLIC_AUTHORIZATION_ID);
          break;
          }
        default:
          jj_la1[440] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

/*
 * <A NAME="roleGrantStatement">roleGrantStatement</A>
 */
  final public StatementNode roleGrantStatement() throws ParseException, StandardException {List rolesGranted;
        List grantees;
    /*
    	 * GRANT <rolename> {, <rolename>}* TO <authentication identifier>
    	 *									{, <authentication identifier>}*
    	 *
    	 * not implemented: WITH ADMIN OPTION, GRANTED BY clauses
    	 */
            rolesGranted = roleList();
    jj_consume_token(TO);
    grantees = granteeList();
checkSqlStandardAccess("GRANT <role>");
                checkVersion( DataDictionary.DD_VERSION_DERBY_10_4, "ROLES");

                {if ("" != null) return (StatementNode) nodeFactory.getNode
                        (C_NodeTypes.GRANT_ROLE_NODE,
                         rolesGranted,
                         grantees,
                         getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="roleList">roleList</A>
 */
  final public List roleList() throws ParseException, StandardException {ArrayList list = new ArrayList();
    roleElement(list);
    label_66:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[441] = jj_gen;
        break label_66;
      }
      jj_consume_token(COMMA);
      roleElement(list);
    }
{if ("" != null) return list;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="roleElement">roleElement</A>
 */
  final public void roleElement(List list) throws ParseException, StandardException {String str;
    str = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
list.add(str);
  }

/*
 * <A NAME="revokeStatement">revokeStatement</A>
 */
  final public StatementNode revokeStatement() throws ParseException, StandardException {StatementNode node;
    if (getToken(1).kind == REVOKE &&
                                    ((getToken(2).kind == TRIGGER &&
                                      ((getToken(3).kind == COMMA &&
                                            isPrivilegeKeywordExceptTrigger(getToken(4).kind)) ||
                                       getToken(3).kind == ON)) ||
                                     isPrivilegeKeywordExceptTrigger(getToken(2).kind))) {
      jj_consume_token(REVOKE);
checkVersion( DataDictionary.DD_VERSION_DERBY_10_2, "REVOKE");
                checkSqlStandardAccess( "REVOKE");
      switch (jj_nt.kind) {
      case ALL:
      case ALTER:
      case DELETE:
      case INSERT:
      case REFERENCES:
      case SELECT:
      case UPDATE:
      case TRIGGER:{
        node = tableRevokeStatement();
        break;
        }
      case EXECUTE:{
        node = routineRevokeStatement();
        break;
        }
      default:
        jj_la1[442] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return node;}
    } else if (getToken(1).kind == REVOKE &&
                                    ((getToken(2).kind == TRIGGER &&
                                      ((getToken(3).kind == COMMA &&
                                            !isPrivilegeKeywordExceptTrigger(getToken(4).kind)) ||
                                       getToken(3).kind == FROM)) ||
                                     !isPrivilegeKeywordExceptTrigger(getToken(2).kind))) {
      jj_consume_token(REVOKE);
{if (true) throw StandardException.newException
            (SQLState.NOT_IMPLEMENTED, "ROLES");}
                checkVersion( DataDictionary.DD_VERSION_DERBY_10_4, "ROLES");
                checkSqlStandardAccess("REVOKE <role>");
      node = roleRevokeStatement();
{if ("" != null) return node;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="tableRevokeStatement">tableRevokeStatement</A>
 */
  final public StatementNode tableRevokeStatement() throws ParseException, StandardException {PrivilegeNode privileges = null;
    List grantees;
    privileges = tablePrivileges();
    jj_consume_token(FROM);
    grantees = granteeList();
{if ("" != null) return (StatementNode) nodeFactory.getNode( C_NodeTypes.REVOKE_NODE,
                                    privileges, grantees,
                                    getContextManager());}
    throw new Error("Missing return statement in function");
  }

// end of tableRevokeStatement

/*
 * <A NAME="routineRevokeStatement">routineRevokeStatement</A>
 */
  final public StatementNode routineRevokeStatement() throws ParseException, StandardException {List grantees;
    RoutineDesignator routine = null;
    jj_consume_token(EXECUTE);
    jj_consume_token(ON);
    routine = routineDesignator();
    jj_consume_token(FROM);
    grantees = granteeList();
    jj_consume_token(RESTRICT);
PrivilegeNode routinePrivilege = (PrivilegeNode)
          nodeFactory.getNode( C_NodeTypes.PRIVILEGE_NODE,
                               ReuseFactory.getInteger( PrivilegeNode.ROUTINE_PRIVILEGES),
                               routine, null,
                               getContextManager());
        {if ("" != null) return (StatementNode) nodeFactory.getNode( C_NodeTypes.REVOKE_NODE,
                                    routinePrivilege, grantees,
                                    getContextManager());}
    throw new Error("Missing return statement in function");
  }

// end of routineRevokeStatement


/*
 * <A NAME="roleRevokeStatement">roleRevokeStatement</A>
 */
  final public StatementNode roleRevokeStatement() throws ParseException, StandardException {List rolesRevokeed;
        List grantees;
    rolesRevokeed = roleList();
    jj_consume_token(FROM);
    grantees = granteeList();
{if ("" != null) return (StatementNode) nodeFactory.getNode
                        (C_NodeTypes.REVOKE_ROLE_NODE,
                         rolesRevokeed,
                         grantees,
                         getContextManager());}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="identifier">identifier</A>
 */
  final public String internalIdentifier(int id_length_limit, boolean checkLength) throws ParseException, StandardException {String  str;
        Token   tok;
    switch (jj_nt.kind) {
    case IDENTIFIER:{
      tok = jj_consume_token(IDENTIFIER);
str = StringUtil.SQLToUpperCase(tok.image);

                if (checkLength) {//if checkLength false, then calling method would do the length limit checks
                        //limit the identifier to the id length limit passed to this method
                        checkIdentifierLengthLimit(str, id_length_limit);
                }
                // Remember whether last token was a delimited identifier
                nextToLastTokenDelimitedIdentifier = lastTokenDelimitedIdentifier;
                lastTokenDelimitedIdentifier = Boolean.FALSE;
                nextToLastIdentifierToken = lastIdentifierToken;
                lastIdentifierToken = tok;
                {if ("" != null) return str;}
      break;
      }
    case DELIMITED_IDENTIFIER:{
      str = delimitedIdentifier();
if (checkLength) {//if checkLength false, then calling method would do the length limit checks
                        //limit the identifier to the id length limit passed to this method
                        checkIdentifierLengthLimit(str, id_length_limit);
                }
                {if ("" != null) return str;}
      break;
      }
    default:
      jj_la1[443] = jj_gen;
      if (jj_2_79(1)) {
        str = nonReservedKeyword();
{if ("" != null) return StringUtil.SQLToUpperCase(str);}
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public String identifier(int id_length_limit, boolean checkLength) throws ParseException, StandardException {String  id;
    id = internalIdentifier(id_length_limit, checkLength);
{if ("" != null) return id;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="delimitedIdentifier">delimitedIdentifier</A>
 */
  final public String delimitedIdentifier() throws ParseException {String  str;
        Token   tok;
    tok = jj_consume_token(DELIMITED_IDENTIFIER);
//GemStone changes BEGIN
        str = tok.image;
        //originally str = tok.image.substring(1, tok.image.length() -1);
        //GemStone changes END
                str = normalizeDelimitedID( str );
                // Remember whether last token was a delimited identifier
                nextToLastTokenDelimitedIdentifier = lastTokenDelimitedIdentifier;
                lastTokenDelimitedIdentifier = Boolean.TRUE;
                nextToLastIdentifierToken = lastIdentifierToken;
                lastIdentifierToken = tok;

                {if ("" != null) return str;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="reservedKeyword">reservedKeyword</A>
 */
  final public String reservedKeyword() throws ParseException {Token   tok;
    switch (jj_nt.kind) {
    case ADD:{
      /* SQL92 reserved Keywords */
              tok = jj_consume_token(ADD);
      break;
      }
    case ALL:{
      tok = jj_consume_token(ALL);
      break;
      }
    case ALLOCATE:{
      tok = jj_consume_token(ALLOCATE);
      break;
      }
    case ALTER:{
      tok = jj_consume_token(ALTER);
      break;
      }
    case AND:{
      tok = jj_consume_token(AND);
      break;
      }
    case ANY:{
      tok = jj_consume_token(ANY);
      break;
      }
    case ARE:{
      tok = jj_consume_token(ARE);
      break;
      }
    case AS:{
      tok = jj_consume_token(AS);
      break;
      }
    case ASC:{
      tok = jj_consume_token(ASC);
      break;
      }
    case ASSERTION:{
      tok = jj_consume_token(ASSERTION);
      break;
      }
    case AT:{
      tok = jj_consume_token(AT);
      break;
      }
    case AUTHORIZATION:{
      tok = jj_consume_token(AUTHORIZATION);
      break;
      }
    case AVG:{
      tok = jj_consume_token(AVG);
      break;
      }
    case BEGIN:{
      tok = jj_consume_token(BEGIN);
      break;
      }
    case BETWEEN:{
      tok = jj_consume_token(BETWEEN);
      break;
      }
    case BIT:{
      tok = jj_consume_token(BIT);
      break;
      }
    case BOTH:{
      tok = jj_consume_token(BOTH);
      break;
      }
    case BY:{
      tok = jj_consume_token(BY);
      break;
      }
    case CASCADE:{
      tok = jj_consume_token(CASCADE);
      break;
      }
    case CASCADED:{
      tok = jj_consume_token(CASCADED);
      break;
      }
    case CASE:{
      tok = jj_consume_token(CASE);
      break;
      }
    case CAST:{
      tok = jj_consume_token(CAST);
      break;
      }
    case CHAR:{
      tok = jj_consume_token(CHAR);
      break;
      }
    case CHARACTER:{
      tok = jj_consume_token(CHARACTER);
      break;
      }
    case CHECK:{
      tok = jj_consume_token(CHECK);
      break;
      }
    case CLOSE:{
      tok = jj_consume_token(CLOSE);
      break;
      }
    case COLLATE:{
      tok = jj_consume_token(COLLATE);
      break;
      }
    case COLLATION:{
      tok = jj_consume_token(COLLATION);
      break;
      }
    case COLUMN:{
      tok = jj_consume_token(COLUMN);
      break;
      }
    case COMMIT:{
      tok = jj_consume_token(COMMIT);
      break;
      }
    case CONNECT:{
      tok = jj_consume_token(CONNECT);
      break;
      }
    case CONNECTION:{
      tok = jj_consume_token(CONNECTION);
      break;
      }
    case CONSTRAINT:{
      tok = jj_consume_token(CONSTRAINT);
      break;
      }
    case CONSTRAINTS:{
      tok = jj_consume_token(CONSTRAINTS);
      break;
      }
    case CONTINUE:{
      tok = jj_consume_token(CONTINUE);
      break;
      }
    case CONVERT:{
      tok = jj_consume_token(CONVERT);
      break;
      }
    case CORRESPONDING:{
      tok = jj_consume_token(CORRESPONDING);
      break;
      }
    case CREATE:{
      tok = jj_consume_token(CREATE);
      break;
      }
    case CURRENT:{
      tok = jj_consume_token(CURRENT);
      break;
      }
    case CURRENT_DATE:{
      tok = jj_consume_token(CURRENT_DATE);
      break;
      }
    case CURRENT_TIME:{
      tok = jj_consume_token(CURRENT_TIME);
      break;
      }
    case CURRENT_TIMESTAMP:{
      tok = jj_consume_token(CURRENT_TIMESTAMP);
      break;
      }
    case CURRENT_USER:{
      tok = jj_consume_token(CURRENT_USER);
      break;
      }
    case CURSOR:{
      tok = jj_consume_token(CURSOR);
      break;
      }
    case DEALLOCATE:{
      tok = jj_consume_token(DEALLOCATE);
      break;
      }
    case DEC:{
      tok = jj_consume_token(DEC);
      break;
      }
    case DECIMAL:{
      tok = jj_consume_token(DECIMAL);
      break;
      }
    case DECLARE:{
      tok = jj_consume_token(DECLARE);
      break;
      }
    case _DEFAULT:{
      tok = jj_consume_token(_DEFAULT);
      break;
      }
    case DEFERRABLE:{
      tok = jj_consume_token(DEFERRABLE);
      break;
      }
    case DEFERRED:{
      tok = jj_consume_token(DEFERRED);
      break;
      }
    case DELETE:{
      tok = jj_consume_token(DELETE);
      break;
      }
    case DESC:{
      tok = jj_consume_token(DESC);
      break;
      }
    case DESCRIBE:{
      tok = jj_consume_token(DESCRIBE);
      break;
      }
    case DIAGNOSTICS:{
      tok = jj_consume_token(DIAGNOSTICS);
      break;
      }
    case DISCONNECT:{
      tok = jj_consume_token(DISCONNECT);
      break;
      }
    case DISTINCT:{
      tok = jj_consume_token(DISTINCT);
      break;
      }
    case DOUBLE:{
      tok = jj_consume_token(DOUBLE);
      break;
      }
    case DROP:{
      tok = jj_consume_token(DROP);
      break;
      }
    case ELSE:{
      tok = jj_consume_token(ELSE);
      break;
      }
    case END:{
      tok = jj_consume_token(END);
      break;
      }
    case ENDEXEC:{
      tok = jj_consume_token(ENDEXEC);
      break;
      }
    case ESCAPE:{
      tok = jj_consume_token(ESCAPE);
      break;
      }
    case EXCEPT:{
      tok = jj_consume_token(EXCEPT);
      break;
      }
    case EXCEPTION:{
      tok = jj_consume_token(EXCEPTION);
      break;
      }
    case EXEC:{
      tok = jj_consume_token(EXEC);
      break;
      }
    case EXECUTE:{
      tok = jj_consume_token(EXECUTE);
      break;
      }
    case EXISTS:{
      tok = jj_consume_token(EXISTS);
      break;
      }
    case EXTERNAL:{
      tok = jj_consume_token(EXTERNAL);
      break;
      }
    case FALSE:{
      tok = jj_consume_token(FALSE);
      break;
      }
    case FETCH:{
      tok = jj_consume_token(FETCH);
      break;
      }
    case FIRST:{
      tok = jj_consume_token(FIRST);
      break;
      }
    case FLOAT:{
      tok = jj_consume_token(FLOAT);
      break;
      }
    case FOR:{
      tok = jj_consume_token(FOR);
      break;
      }
    case FOREIGN:{
      tok = jj_consume_token(FOREIGN);
      break;
      }
    case FOUND:{
      tok = jj_consume_token(FOUND);
      break;
      }
    case FROM:{
      tok = jj_consume_token(FROM);
      break;
      }
    case FULL:{
      tok = jj_consume_token(FULL);
      break;
      }
    case FUNCTION:{
      tok = jj_consume_token(FUNCTION);
      break;
      }
    case GET:{
      tok = jj_consume_token(GET);
      break;
      }
    case GET_CURRENT_CONNECTION:{
      tok = jj_consume_token(GET_CURRENT_CONNECTION);
      break;
      }
    case GLOBAL:{
      tok = jj_consume_token(GLOBAL);
      break;
      }
    case GO:{
      tok = jj_consume_token(GO);
      break;
      }
    case GOTO:{
      tok = jj_consume_token(GOTO);
      break;
      }
    case GRANT:{
      tok = jj_consume_token(GRANT);
      break;
      }
    case GROUP:{
      tok = jj_consume_token(GROUP);
      break;
      }
    case HAVING:{
      tok = jj_consume_token(HAVING);
      break;
      }
    case HOUR:{
      tok = jj_consume_token(HOUR);
      break;
      }
    case IDENTITY:{
      tok = jj_consume_token(IDENTITY);
      break;
      }
    case IMMEDIATE:{
      tok = jj_consume_token(IMMEDIATE);
      break;
      }
    case IN:{
      tok = jj_consume_token(IN);
      break;
      }
    case INDICATOR:{
      tok = jj_consume_token(INDICATOR);
      break;
      }
    case INITIALLY:{
      tok = jj_consume_token(INITIALLY);
      break;
      }
    case INNER:{
      tok = jj_consume_token(INNER);
      break;
      }
    case INOUT:{
      tok = jj_consume_token(INOUT);
      break;
      }
    case INPUT:{
      tok = jj_consume_token(INPUT);
      break;
      }
    case INSENSITIVE:{
      tok = jj_consume_token(INSENSITIVE);
      break;
      }
    case INSERT:{
      tok = jj_consume_token(INSERT);
      break;
      }
    case INT:{
      tok = jj_consume_token(INT);
      break;
      }
    case INTEGER:{
      tok = jj_consume_token(INTEGER);
      break;
      }
    case INTERSECT:{
      tok = jj_consume_token(INTERSECT);
      break;
      }
    case INTO:{
      tok = jj_consume_token(INTO);
      break;
      }
    case IS:{
      tok = jj_consume_token(IS);
      break;
      }
    case ISOLATION:{
      tok = jj_consume_token(ISOLATION);
      break;
      }
    case JOIN:{
      tok = jj_consume_token(JOIN);
      break;
      }
    case KEY:{
      tok = jj_consume_token(KEY);
      break;
      }
    case LAST:{
      tok = jj_consume_token(LAST);
      break;
      }
    case LEADING:{
      tok = jj_consume_token(LEADING);
      break;
      }
    case LEFT:{
      tok = jj_consume_token(LEFT);
      break;
      }
    case LIKE:{
      tok = jj_consume_token(LIKE);
      break;
      }
    case LOWER:{
      tok = jj_consume_token(LOWER);
      break;
      }
    case MATCH:{
      tok = jj_consume_token(MATCH);
      break;
      }
    case MAX:{
      tok = jj_consume_token(MAX);
      break;
      }
    case MIN:{
      tok = jj_consume_token(MIN);
      break;
      }
    case MINUTE:{
      tok = jj_consume_token(MINUTE);
      break;
      }
    case NATIONAL:{
      tok = jj_consume_token(NATIONAL);
      break;
      }
    case NATURAL:{
      tok = jj_consume_token(NATURAL);
      break;
      }
    case NCHAR:{
      tok = jj_consume_token(NCHAR);
      break;
      }
    case NVARCHAR:{
      tok = jj_consume_token(NVARCHAR);
      break;
      }
    case NEXT:{
      tok = jj_consume_token(NEXT);
      break;
      }
    case NO:{
      tok = jj_consume_token(NO);
      break;
      }
    case NONE:{
      tok = jj_consume_token(NONE);
      break;
      }
    case NOT:{
      tok = jj_consume_token(NOT);
      break;
      }
    case NULL:{
      tok = jj_consume_token(NULL);
      break;
      }
    case NULLIF:{
      tok = jj_consume_token(NULLIF);
      break;
      }
    case NUMERIC:{
      tok = jj_consume_token(NUMERIC);
      break;
      }
    case OF:{
      tok = jj_consume_token(OF);
      break;
      }
    case ON:{
      tok = jj_consume_token(ON);
      break;
      }
    case ONLY:{
      tok = jj_consume_token(ONLY);
      break;
      }
    case OPEN:{
      tok = jj_consume_token(OPEN);
      break;
      }
    case OPTION:{
      tok = jj_consume_token(OPTION);
      break;
      }
    case OR:{
      tok = jj_consume_token(OR);
      break;
      }
    case ORDER:{
      tok = jj_consume_token(ORDER);
      break;
      }
    case OUT:{
      tok = jj_consume_token(OUT);
      break;
      }
    case OUTER:{
      tok = jj_consume_token(OUTER);
      break;
      }
    case OUTPUT:{
      tok = jj_consume_token(OUTPUT);
      break;
      }
    case OVERLAPS:{
      tok = jj_consume_token(OVERLAPS);
      break;
      }
    case PAD:{
      tok = jj_consume_token(PAD);
      break;
      }
    case PARTIAL:{
      tok = jj_consume_token(PARTIAL);
      break;
      }
    case PREPARE:{
      tok = jj_consume_token(PREPARE);
      break;
      }
    case PRESERVE:{
      tok = jj_consume_token(PRESERVE);
      break;
      }
    case PRIMARY:{
      tok = jj_consume_token(PRIMARY);
      break;
      }
    case PRIOR:{
      tok = jj_consume_token(PRIOR);
      break;
      }
    case PRIVILEGES:{
      tok = jj_consume_token(PRIVILEGES);
      break;
      }
    case PROCEDURE:{
      tok = jj_consume_token(PROCEDURE);
      break;
      }
    case PUBLIC:{
      tok = jj_consume_token(PUBLIC);
      break;
      }
    case READ:{
      tok = jj_consume_token(READ);
      break;
      }
    case REAL:{
      tok = jj_consume_token(REAL);
      break;
      }
    case REFERENCES:{
      tok = jj_consume_token(REFERENCES);
      break;
      }
    case RELATIVE:{
      tok = jj_consume_token(RELATIVE);
      break;
      }
    case RESTRICT:{
      tok = jj_consume_token(RESTRICT);
      break;
      }
    case REVOKE:{
      tok = jj_consume_token(REVOKE);
      break;
      }
    case RIGHT:{
      tok = jj_consume_token(RIGHT);
      break;
      }
    case ROLLBACK:{
      tok = jj_consume_token(ROLLBACK);
      break;
      }
    case ROWS:{
      tok = jj_consume_token(ROWS);
      break;
      }
    case SCHEMA:{
      tok = jj_consume_token(SCHEMA);
      break;
      }
    case SCROLL:{
      tok = jj_consume_token(SCROLL);
      break;
      }
    case SECOND:{
      tok = jj_consume_token(SECOND);
      break;
      }
    case SELECT:{
      tok = jj_consume_token(SELECT);
      break;
      }
    case SESSION_USER:{
      tok = jj_consume_token(SESSION_USER);
      break;
      }
    case SET:{
      tok = jj_consume_token(SET);
      break;
      }
    case SMALLINT:{
      tok = jj_consume_token(SMALLINT);
      break;
      }
    case SOME:{
      tok = jj_consume_token(SOME);
      break;
      }
    case SPACE:{
      tok = jj_consume_token(SPACE);
      break;
      }
    case SQL:{
      tok = jj_consume_token(SQL);
      break;
      }
    case SQLCODE:{
      tok = jj_consume_token(SQLCODE);
      break;
      }
    case SQLERROR:{
      tok = jj_consume_token(SQLERROR);
      break;
      }
    case SQLSTATE:{
      tok = jj_consume_token(SQLSTATE);
      break;
      }
    case SUBSTRING:{
      tok = jj_consume_token(SUBSTRING);
      break;
      }
    case SUM:{
      tok = jj_consume_token(SUM);
      break;
      }
    case SYSTEM_USER:{
      tok = jj_consume_token(SYSTEM_USER);
      break;
      }
    case TABLE:{
      tok = jj_consume_token(TABLE);
      break;
      }
    case TEMPORARY:{
      tok = jj_consume_token(TEMPORARY);
      break;
      }
    case TIMEZONE_HOUR:{
      tok = jj_consume_token(TIMEZONE_HOUR);
      break;
      }
    case TIMEZONE_MINUTE:{
      tok = jj_consume_token(TIMEZONE_MINUTE);
      break;
      }
    case TO:{
      tok = jj_consume_token(TO);
      break;
      }
    case TRAILING:{
      tok = jj_consume_token(TRAILING);
      break;
      }
    case TRANSACTION:{
      tok = jj_consume_token(TRANSACTION);
      break;
      }
    case TRANSLATE:{
      tok = jj_consume_token(TRANSLATE);
      break;
      }
    case TRANSLATION:{
      tok = jj_consume_token(TRANSLATION);
      break;
      }
    case TRUE:{
      tok = jj_consume_token(TRUE);
      break;
      }
    case UNION:{
      tok = jj_consume_token(UNION);
      break;
      }
    case UNIQUE:{
      tok = jj_consume_token(UNIQUE);
      break;
      }
    case UNKNOWN:{
      tok = jj_consume_token(UNKNOWN);
      break;
      }
    case UPDATE:{
      tok = jj_consume_token(UPDATE);
      break;
      }
    case UPPER:{
      tok = jj_consume_token(UPPER);
      break;
      }
    case USER:{
      tok = jj_consume_token(USER);
      break;
      }
    case USING:{
      tok = jj_consume_token(USING);
      break;
      }
    case VALUES:{
      tok = jj_consume_token(VALUES);
      break;
      }
    case VARCHAR:{
      tok = jj_consume_token(VARCHAR);
      break;
      }
    case VARYING:{
      tok = jj_consume_token(VARYING);
      break;
      }
    case VIEW:{
      tok = jj_consume_token(VIEW);
      break;
      }
    case WHENEVER:{
      tok = jj_consume_token(WHENEVER);
      break;
      }
    case WHERE:{
      tok = jj_consume_token(WHERE);
      break;
      }
    case WITH:{
      tok = jj_consume_token(WITH);
      break;
      }
    case WORK:{
      tok = jj_consume_token(WORK);
      break;
      }
    case WRITE:{
      tok = jj_consume_token(WRITE);
      break;
      }
    case YEAR:{
      tok = jj_consume_token(YEAR);
      break;
      }
    case BOOLEAN:{
      tok = jj_consume_token(BOOLEAN);
      break;
      }
    case CALL:{
      tok = jj_consume_token(CALL);
      break;
      }
    case CURRENT_ROLE:{
      tok = jj_consume_token(CURRENT_ROLE);
      break;
      }
    case EXPLAIN:{
      tok = jj_consume_token(EXPLAIN);
      break;
      }
    case LONGINT:{
      tok = jj_consume_token(LONGINT);
      break;
      }
    case LTRIM:{
      tok = jj_consume_token(LTRIM);
      break;
      }
    case RTRIM:{
      tok = jj_consume_token(RTRIM);
      break;
      }
    case TRIM:{
      tok = jj_consume_token(TRIM);
      break;
      }
    case SUBSTR:{
      tok = jj_consume_token(SUBSTR);
      break;
      }
    case XML:{
      tok = jj_consume_token(XML);
      break;
      }
    case XMLPARSE:{
      tok = jj_consume_token(XMLPARSE);
      break;
      }
    case XMLSERIALIZE:{
      tok = jj_consume_token(XMLSERIALIZE);
      break;
      }
    case XMLEXISTS:{
      tok = jj_consume_token(XMLEXISTS);
      break;
      }
    case XMLQUERY:{
      tok = jj_consume_token(XMLQUERY);
      break;
      }
    default:
      jj_la1[444] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
// Remember whether last token was a delimited identifier
                nextToLastTokenDelimitedIdentifier = lastTokenDelimitedIdentifier;
                lastTokenDelimitedIdentifier = Boolean.FALSE;
                {if ("" != null) return tok.image;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="nonReservedKeyword">nonReservedKeyword</A>
 */
  final public String nonReservedKeyword() throws ParseException {Token   tok;
    switch (jj_nt.kind) {
    case ABS:{
      tok = jj_consume_token(ABS);
      break;
      }
    case ABSVAL:{
      tok = jj_consume_token(ABSVAL);
      break;
      }
    case ACTION:{
      tok = jj_consume_token(ACTION);
      break;
      }
    case AFTER:{
      tok = jj_consume_token(AFTER);
      break;
      }
    case ALWAYS:{
      tok = jj_consume_token(ALWAYS);
      break;
      }
    case BEFORE:{
      tok = jj_consume_token(BEFORE);
      break;
      }
    case BINARY:{
      tok = jj_consume_token(BINARY);
      break;
      }
    case BLOB:{
      tok = jj_consume_token(BLOB);
      break;
      }
    case C:{
      tok = jj_consume_token(C);
      break;
      }
    case CALLED:{
      tok = jj_consume_token(CALLED);
      break;
      }
    case CLASS:{
      tok = jj_consume_token(CLASS);
      break;
      }
    case CLOB:{
      tok = jj_consume_token(CLOB);
      break;
      }
    case COALESCE:{
      tok = jj_consume_token(COALESCE);
      break;
      }
    case COBOL:{
      tok = jj_consume_token(COBOL);
      break;
      }
    case COMMITTED:{
      tok = jj_consume_token(COMMITTED);
      break;
      }
    case COMPRESS:{
      tok = jj_consume_token(COMPRESS);
      break;
      }
    case CONCAT:{
      tok = jj_consume_token(CONCAT);
      break;
      }
    case CONTAINS:{
      tok = jj_consume_token(CONTAINS);
      break;
      }
    case CONTENT:{
      tok = jj_consume_token(CONTENT);
      break;
      }
    case COUNT:{
      tok = jj_consume_token(COUNT);
      break;
      }
    case CS:{
      tok = jj_consume_token(CS);
      break;
      }
    case CURDATE:{
      tok = jj_consume_token(CURDATE);
      break;
      }
    case CURTIME:{
      tok = jj_consume_token(CURTIME);
      break;
      }
    case D:{
      tok = jj_consume_token(D);
      break;
      }
    case DATA:{
      tok = jj_consume_token(DATA);
      break;
      }
    case DATE:{
      tok = jj_consume_token(DATE);
      break;
      }
    case DAY:{
      tok = jj_consume_token(DAY);
      break;
      }
    case DIRTY:{
      tok = jj_consume_token(DIRTY);
      break;
      }
    case DYNAMIC:{
      tok = jj_consume_token(DYNAMIC);
      break;
      }
    case DATABASE:{
      tok = jj_consume_token(DATABASE);
      break;
      }
    case DB2SQL:{
      tok = jj_consume_token(DB2SQL);
      break;
      }
    case DERBY_JDBC_RESULT_SET:{
      tok = jj_consume_token(DERBY_JDBC_RESULT_SET);
      break;
      }
    case DOCUMENT:{
      tok = jj_consume_token(DOCUMENT);
      break;
      }
    case EACH:{
      tok = jj_consume_token(EACH);
      break;
      }
    case EMPTY:{
      tok = jj_consume_token(EMPTY);
      break;
      }
    case EXCLUSIVE:{
      tok = jj_consume_token(EXCLUSIVE);
      break;
      }
    case FN:{
      tok = jj_consume_token(FN);
      break;
      }
    case FORTRAN:{
      tok = jj_consume_token(FORTRAN);
      break;
      }
    case GENERATED:{
      tok = jj_consume_token(GENERATED);
      break;
      }
    case IDENTITY_VAL_LOCAL:{
      tok = jj_consume_token(IDENTITY_VAL_LOCAL);
      break;
      }
    case INCREMENT:{
      tok = jj_consume_token(INCREMENT);
      break;
      }
    case INDEX:{
      tok = jj_consume_token(INDEX);
      break;
      }
    case INITIAL:{
      tok = jj_consume_token(INITIAL);
      break;
      }
    case INTERVAL:{
      tok = jj_consume_token(INTERVAL);
      break;
      }
    case JAVA:{
      tok = jj_consume_token(JAVA);
      break;
      }
    case LANGUAGE:{
      tok = jj_consume_token(LANGUAGE);
      break;
      }
    case LARGE:{
      tok = jj_consume_token(LARGE);
      break;
      }
    case LCASE:{
      tok = jj_consume_token(LCASE);
      break;
      }
    case LENGTH:{
      tok = jj_consume_token(LENGTH);
      break;
      }
    case LEVEL:{
      tok = jj_consume_token(LEVEL);
      break;
      }
    case LOCATE:{
      tok = jj_consume_token(LOCATE);
      break;
      }
    case LOCK:{
      tok = jj_consume_token(LOCK);
      break;
      }
    case LOCKS:{
      tok = jj_consume_token(LOCKS);
      break;
      }
    case LOCKSIZE:{
      tok = jj_consume_token(LOCKSIZE);
      break;
      }
    case LOGGED:{
      tok = jj_consume_token(LOGGED);
      break;
      }
    case LONG:{
      tok = jj_consume_token(LONG);
      break;
      }
    case MESSAGE_LOCALE:{
      tok = jj_consume_token(MESSAGE_LOCALE);
      break;
      }
    case METHOD:{
      tok = jj_consume_token(METHOD);
      break;
      }
    case MOD:{
      tok = jj_consume_token(MOD);
      break;
      }
    case MODE:{
      tok = jj_consume_token(MODE);
      break;
      }
    case MODIFIES:{
      tok = jj_consume_token(MODIFIES);
      break;
      }
    case MODIFY:{
      tok = jj_consume_token(MODIFY);
      break;
      }
    case MODULE:{
      tok = jj_consume_token(MODULE);
      break;
      }
    case MONTH:{
      tok = jj_consume_token(MONTH);
      break;
      }
    case _MORE:{
      tok = jj_consume_token(_MORE);
      break;
      }
    case MUMPS:{
      tok = jj_consume_token(MUMPS);
      break;
      }
    case NAME:{
      tok = jj_consume_token(NAME);
      break;
      }
    case NCLOB:{
      tok = jj_consume_token(NCLOB);
      break;
      }
    case NEW:{
      tok = jj_consume_token(NEW);
      break;
      }
    case NEW_TABLE:{
      tok = jj_consume_token(NEW_TABLE);
      break;
      }
    case NULLABLE:{
      tok = jj_consume_token(NULLABLE);
      break;
      }
    case NULLS:{
      tok = jj_consume_token(NULLS);
      break;
      }
    case NUMBER:{
      tok = jj_consume_token(NUMBER);
      break;
      }
    case OBJECT:{
      tok = jj_consume_token(OBJECT);
      break;
      }
    case OFF:{
      tok = jj_consume_token(OFF);
      break;
      }
    default:
      jj_la1[445] = jj_gen;
      if (getToken(1).kind == OFFSET &&
                  !seeingOffsetClause()) {
        tok = jj_consume_token(OFFSET);
      } else {
        switch (jj_nt.kind) {
        case OLD:{
          tok = jj_consume_token(OLD);
          break;
          }
        case OLD_TABLE:{
          tok = jj_consume_token(OLD_TABLE);
          break;
          }
        case OJ:{
          tok = jj_consume_token(OJ);
          break;
          }
        case OVER:{
          tok = jj_consume_token(OVER);
          break;
          }
        case PASCAL:{
          tok = jj_consume_token(PASCAL);
          break;
          }
        case PASSING:{
          tok = jj_consume_token(PASSING);
          break;
          }
        case PLI:{
          tok = jj_consume_token(PLI);
          break;
          }
        case PRECISION:{
          tok = jj_consume_token(PRECISION);
          break;
          }
        case PROPERTIES:{
          tok = jj_consume_token(PROPERTIES);
          break;
          }
        case READS:{
          tok = jj_consume_token(READS);
          break;
          }
        case REF:{
          tok = jj_consume_token(REF);
          break;
          }
        case RELEASE:{
          tok = jj_consume_token(RELEASE);
          break;
          }
        case RENAME:{
          tok = jj_consume_token(RENAME);
          break;
          }
        case REPEATABLE:{
          tok = jj_consume_token(REPEATABLE);
          break;
          }
        case REFERENCING:{
          tok = jj_consume_token(REFERENCING);
          break;
          }
        case RESET:{
          tok = jj_consume_token(RESET);
          break;
          }
        case RESTART:{
          tok = jj_consume_token(RESTART);
          break;
          }
        case RESULT:{
          tok = jj_consume_token(RESULT);
          break;
          }
        case RETAIN:{
          tok = jj_consume_token(RETAIN);
          break;
          }
        case RETURNING:{
          tok = jj_consume_token(RETURNING);
          break;
          }
        case RETURNS:{
          tok = jj_consume_token(RETURNS);
          break;
          }
        case ROLE:{
          tok = jj_consume_token(ROLE);
          break;
          }
        case ROW:{
          tok = jj_consume_token(ROW);
          break;
          }
        case ROW_NUMBER:{
          tok = jj_consume_token(ROW_NUMBER);
          break;
          }
        case RR:{
          tok = jj_consume_token(RR);
          break;
          }
        case RS:{
          tok = jj_consume_token(RS);
          break;
          }
        case SCALE:{
          tok = jj_consume_token(SCALE);
          break;
          }
        case SAVEPOINT:{
          tok = jj_consume_token(SAVEPOINT);
          break;
          }
        case SECURITY:{
          tok = jj_consume_token(SECURITY);
          break;
          }
        case SEQUENCE:{
          tok = jj_consume_token(SEQUENCE);
          break;
          }
        case SEQUENTIAL:{
          tok = jj_consume_token(SEQUENTIAL);
          break;
          }
        case SERIALIZABLE:{
          tok = jj_consume_token(SERIALIZABLE);
          break;
          }
        case SETS:{
          tok = jj_consume_token(SETS);
          break;
          }
        case SHARE:{
          tok = jj_consume_token(SHARE);
          break;
          }
        case SPECIFIC:{
          tok = jj_consume_token(SPECIFIC);
          break;
          }
        case SQLID:{
          tok = jj_consume_token(SQLID);
          break;
          }
        case SQL_TSI_FRAC_SECOND:{
          tok = jj_consume_token(SQL_TSI_FRAC_SECOND);
          break;
          }
        case SQL_TSI_SECOND:{
          tok = jj_consume_token(SQL_TSI_SECOND);
          break;
          }
        case SQL_TSI_MINUTE:{
          tok = jj_consume_token(SQL_TSI_MINUTE);
          break;
          }
        case SQL_TSI_HOUR:{
          tok = jj_consume_token(SQL_TSI_HOUR);
          break;
          }
        case SQL_TSI_DAY:{
          tok = jj_consume_token(SQL_TSI_DAY);
          break;
          }
        case SQL_TSI_WEEK:{
          tok = jj_consume_token(SQL_TSI_WEEK);
          break;
          }
        case SQL_TSI_MONTH:{
          tok = jj_consume_token(SQL_TSI_MONTH);
          break;
          }
        case SQL_TSI_QUARTER:{
          tok = jj_consume_token(SQL_TSI_QUARTER);
          break;
          }
        case SQL_TSI_YEAR:{
          tok = jj_consume_token(SQL_TSI_YEAR);
          break;
          }
        case SQRT:{
          tok = jj_consume_token(SQRT);
          break;
          }
        case STABILITY:{
          tok = jj_consume_token(STABILITY);
          break;
          }
        case START:{
          tok = jj_consume_token(START);
          break;
          }
        case STATEMENT:{
          tok = jj_consume_token(STATEMENT);
          break;
          }
        case STRIP:{
          tok = jj_consume_token(STRIP);
          break;
          }
        case SYNONYM:{
          tok = jj_consume_token(SYNONYM);
          break;
          }
        case STYLE:{
          tok = jj_consume_token(STYLE);
          break;
          }
        case T:{
          tok = jj_consume_token(T);
          break;
          }
        case THEN:{
          tok = jj_consume_token(THEN);
          break;
          }
        case TIME:{
          tok = jj_consume_token(TIME);
          break;
          }
        case TIMESTAMP:{
          tok = jj_consume_token(TIMESTAMP);
          break;
          }
        case TIMESTAMPADD:{
          tok = jj_consume_token(TIMESTAMPADD);
          break;
          }
        case TIMESTAMPDIFF:{
          tok = jj_consume_token(TIMESTAMPDIFF);
          break;
          }
        case TRIGGER:{
          tok = jj_consume_token(TRIGGER);
          break;
          }
        case TRUNCATE:{
          tok = jj_consume_token(TRUNCATE);
          break;
          }
        case TS:{
          tok = jj_consume_token(TS);
          break;
          }
        case TYPE:{
          tok = jj_consume_token(TYPE);
          break;
          }
        case UCASE:{
          tok = jj_consume_token(UCASE);
          break;
          }
        case UNCOMMITTED:{
          tok = jj_consume_token(UNCOMMITTED);
          break;
          }
        case UR:{
          tok = jj_consume_token(UR);
          break;
          }
        case USAGE:{
          tok = jj_consume_token(USAGE);
          break;
          }
        case VALUE:{
          tok = jj_consume_token(VALUE);
          break;
          }
        case VARBINARY:{
          tok = jj_consume_token(VARBINARY);
          break;
          }
        case PARAMETER:{
          tok = jj_consume_token(PARAMETER);
          break;
          }
        case WHEN:{
          tok = jj_consume_token(WHEN);
          break;
          }
        case WHITESPACE:{
          tok = jj_consume_token(WHITESPACE);
          break;
          }
        case ALIAS:{
          tok = jj_consume_token(ALIAS);
          break;
          }
        case ARRAY:{
          tok = jj_consume_token(ARRAY);
          break;
          }
        case ASYNCHRONOUS:{
          tok = jj_consume_token(ASYNCHRONOUS);
          break;
          }
        case BUCKETS:{
          tok = jj_consume_token(BUCKETS);
          break;
          }
        case COLOCATE:{
          tok = jj_consume_token(COLOCATE);
          break;
          }
        case CRITERIA:{
          tok = jj_consume_token(CRITERIA);
          break;
          }
        case DECODE:{
          tok = jj_consume_token(DECODE);
          break;
          }
        case DESTROY:{
          tok = jj_consume_token(DESTROY);
          break;
          }
        case DISKDIR:{
          tok = jj_consume_token(DISKDIR);
          break;
          }
        case ENTRY:{
          tok = jj_consume_token(ENTRY);
          break;
          }
        case EVICT:{
          tok = jj_consume_token(EVICT);
          break;
          }
        case EVICTACTION:{
          tok = jj_consume_token(EVICTACTION);
          break;
          }
        case EVICTION:{
          tok = jj_consume_token(EVICTION);
          break;
          }
        case EXPIRE:{
          tok = jj_consume_token(EXPIRE);
          break;
          }
        case FREQUENCY:{
          tok = jj_consume_token(FREQUENCY);
          break;
          }
        case DAYS:{
          tok = jj_consume_token(DAYS);
          break;
          }
        case HOURS:{
          tok = jj_consume_token(HOURS);
          break;
          }
        case MINUTES:{
          tok = jj_consume_token(MINUTES);
          break;
          }
        case SECONDS:{
          tok = jj_consume_token(SECONDS);
          break;
          }
        case MILLISECONDS:{
          tok = jj_consume_token(MILLISECONDS);
          break;
          }
        case LAST_MODIFIED_DURATION:{
          tok = jj_consume_token(LAST_MODIFIED_DURATION);
          break;
          }
        case LAST_MODIFIED_TIME:{
          tok = jj_consume_token(LAST_MODIFIED_TIME);
          break;
          }
        case LAST_MODIFIED_TIME_MILLIS:{
          tok = jj_consume_token(LAST_MODIFIED_TIME_MILLIS);
          break;
          }
        case ROWID:{
          tok = jj_consume_token(ROWID);
          break;
          }
        case GROUPS:{
          tok = jj_consume_token(GROUPS);
          break;
          }
        case HASH:{
          tok = jj_consume_token(HASH);
          break;
          }
        case IDLETIME:{
          tok = jj_consume_token(IDLETIME);
          break;
          }
        case IF:{
          tok = jj_consume_token(IF);
          break;
          }
        case INCOMING:{
          tok = jj_consume_token(INCOMING);
          break;
          }
        case INITSIZE:{
          tok = jj_consume_token(INITSIZE);
          break;
          }
        case INFINITY:{
          tok = jj_consume_token(INFINITY);
          break;
          }
        case LDAPGROUP:{
          tok = jj_consume_token(LDAPGROUP);
          break;
          }
        case LIST:{
          tok = jj_consume_token(LIST);
          break;
          }
        case LOADER:{
          tok = jj_consume_token(LOADER);
          break;
          }
        case LRUCOUNT:{
          tok = jj_consume_token(LRUCOUNT);
          break;
          }
        case LRUHEAPPERCENT:{
          tok = jj_consume_token(LRUHEAPPERCENT);
          break;
          }
        case LRUMEMSIZE:{
          tok = jj_consume_token(LRUMEMSIZE);
          break;
          }
        case MAXPARTSIZE:{
          tok = jj_consume_token(MAXPARTSIZE);
          break;
          }
        case MAXSIZE:{
          tok = jj_consume_token(MAXSIZE);
          break;
          }
        case NVL:{
          tok = jj_consume_token(NVL);
          break;
          }
        case OVERFLOW:{
          tok = jj_consume_token(OVERFLOW);
          break;
          }
        case RANGE:{
          tok = jj_consume_token(RANGE);
          break;
          }
        case RECOVERYDELAY:{
          tok = jj_consume_token(RECOVERYDELAY);
          break;
          }
        case REDUNDANCY:{
          tok = jj_consume_token(REDUNDANCY);
          break;
          }
        case REPLICATE:{
          tok = jj_consume_token(REPLICATE);
          break;
          }
        case PARTITION:{
          tok = jj_consume_token(PARTITION);
          break;
          }
        case PERSISTENT:{
          tok = jj_consume_token(PERSISTENT);
          break;
          }
        case ASYNCLISTENER:{
          tok = jj_consume_token(ASYNCLISTENER);
          break;
          }
        case SERVER:{
          tok = jj_consume_token(SERVER);
          break;
          }
        case PROCESSOR:{
          tok = jj_consume_token(PROCESSOR);
          break;
          }
        case COHORT:{
          tok = jj_consume_token(COHORT);
          break;
          }
        case NOWAIT:{
          tok = jj_consume_token(NOWAIT);
          break;
          }
        case LOCAL:{
          tok = jj_consume_token(LOCAL);
          break;
          }
        case STARTUPRECOVERYDELAY:{
          tok = jj_consume_token(STARTUPRECOVERYDELAY);
          break;
          }
        case SYNCHRONOUS:{
          tok = jj_consume_token(SYNCHRONOUS);
          break;
          }
        case TIMETOLIVE:{
          tok = jj_consume_token(TIMETOLIVE);
          break;
          }
        case DISKSTORE:{
          tok = jj_consume_token(DISKSTORE);
          break;
          }
        case HDFSSTORE:{
          tok = jj_consume_token(HDFSSTORE);
          break;
          }
        case NAMENODE:{
          tok = jj_consume_token(NAMENODE);
          break;
          }
        case HOMEDIR:{
          tok = jj_consume_token(HOMEDIR);
          break;
          }
        case BLOCKCACHESIZE:{
          tok = jj_consume_token(BLOCKCACHESIZE);
          break;
          }
        case CLIENTCONFIGFILE:{
          tok = jj_consume_token(CLIENTCONFIGFILE);
          break;
          }
        case COMPACTIONTHRESHOLD:{
          tok = jj_consume_token(COMPACTIONTHRESHOLD);
          break;
          }
        case AUTOCOMPACT:{
          tok = jj_consume_token(AUTOCOMPACT);
          break;
          }
        case ALLOWFORCECOMPACTION:{
          tok = jj_consume_token(ALLOWFORCECOMPACTION);
          break;
          }
        case TIMEINTERVAL:{
          tok = jj_consume_token(TIMEINTERVAL);
          break;
          }
        case WRITEBUFFERSIZE:{
          tok = jj_consume_token(WRITEBUFFERSIZE);
          break;
          }
        case QUEUESIZE:{
          tok = jj_consume_token(QUEUESIZE);
          break;
          }
        case MAXLOGSIZE:{
          tok = jj_consume_token(MAXLOGSIZE);
          break;
          }
        case GATEWAYSENDER:{
          tok = jj_consume_token(GATEWAYSENDER);
          break;
          }
        case REMOTEDSID:{
          tok = jj_consume_token(REMOTEDSID);
          break;
          }
        case SOCKETBUFFERSIZE:{
          tok = jj_consume_token(SOCKETBUFFERSIZE);
          break;
          }
        case MANUALSTART:{
          tok = jj_consume_token(MANUALSTART);
          break;
          }
        case SOCKETREADTIMEOUT:{
          tok = jj_consume_token(SOCKETREADTIMEOUT);
          break;
          }
        case ENABLEBATCHCONFLATION:{
          tok = jj_consume_token(ENABLEBATCHCONFLATION);
          break;
          }
        case BATCHSIZE:{
          tok = jj_consume_token(BATCHSIZE);
          break;
          }
        case DISPATCHERTHREADS:{
          tok = jj_consume_token(DISPATCHERTHREADS);
          break;
          }
        case BATCHTIMEINTERVAL:{
          tok = jj_consume_token(BATCHTIMEINTERVAL);
          break;
          }
        case ENABLEPERSISTENCE:{
          tok = jj_consume_token(ENABLEPERSISTENCE);
          break;
          }
        case DISKSTORENAME:{
          tok = jj_consume_token(DISKSTORENAME);
          break;
          }
        case MAXQUEUEMEMORY:{
          tok = jj_consume_token(MAXQUEUEMEMORY);
          break;
          }
        case QUEUEPERSISTENT:{
          tok = jj_consume_token(QUEUEPERSISTENT);
          break;
          }
        case DISKSYNCHRONOUS:{
          tok = jj_consume_token(DISKSYNCHRONOUS);
          break;
          }
        case ALERTTHRESHOLD:{
          tok = jj_consume_token(ALERTTHRESHOLD);
          break;
          }
        case LISTENERCLASS:{
          tok = jj_consume_token(LISTENERCLASS);
          break;
          }
        case INITPARAMS:{
          tok = jj_consume_token(INITPARAMS);
          break;
          }
        case GATEWAYRECEIVER:{
          tok = jj_consume_token(GATEWAYRECEIVER);
          break;
          }
        case STARTPORT:{
          tok = jj_consume_token(STARTPORT);
          break;
          }
        case ENDPORT:{
          tok = jj_consume_token(ENDPORT);
          break;
          }
        case ISPARALLEL:{
          tok = jj_consume_token(ISPARALLEL);
          break;
          }
        case MAXTIMEBETWEENPINGS:{
          tok = jj_consume_token(MAXTIMEBETWEENPINGS);
          break;
          }
        case BINDADDRESS:{
          tok = jj_consume_token(BINDADDRESS);
          break;
          }
        case OFFHEAP:{
          tok = jj_consume_token(OFFHEAP);
          break;
          }
        case MINORCOMPACT:{
          tok = jj_consume_token(MINORCOMPACT);
          break;
          }
        case MAJORCOMPACT:{
          tok = jj_consume_token(MAJORCOMPACT);
          break;
          }
        case MAXINPUTFILESIZE:{
          tok = jj_consume_token(MAXINPUTFILESIZE);
          break;
          }
        case MININPUTFILECOUNT:{
          tok = jj_consume_token(MININPUTFILECOUNT);
          break;
          }
        case MAXINPUTFILECOUNT:{
          tok = jj_consume_token(MAXINPUTFILECOUNT);
          break;
          }
        case MINORCOMPACTIONTHREADS:{
          tok = jj_consume_token(MINORCOMPACTIONTHREADS);
          break;
          }
        case MAJORCOMPACTIONINTERVAL:{
          tok = jj_consume_token(MAJORCOMPACTIONINTERVAL);
          break;
          }
        case MAJORCOMPACTIONTHREADS:{
          tok = jj_consume_token(MAJORCOMPACTIONTHREADS);
          break;
          }
        case PURGEINTERVAL:{
          tok = jj_consume_token(PURGEINTERVAL);
          break;
          }
        case WRITEONLY:{
          tok = jj_consume_token(WRITEONLY);
          break;
          }
        case ENABLE:{
          tok = jj_consume_token(ENABLE);
          break;
          }
        case CONCURRENCY:{
          tok = jj_consume_token(CONCURRENCY);
          break;
          }
        case CHECKS:{
          tok = jj_consume_token(CHECKS);
          break;
          }
        case MAXWRITEONLYFILESIZE:{
          tok = jj_consume_token(MAXWRITEONLYFILESIZE);
          break;
          }
        case WRITEONLYFILEROLLOVERINTERVAL:{
          tok = jj_consume_token(WRITEONLYFILEROLLOVERINTERVAL);
          break;
          }
        case PUT:{
          tok = jj_consume_token(PUT);
          break;
          }
        case JSON:{
          tok = jj_consume_token(JSON);
          break;
          }
        case CLOB_STRING:{
          tok = jj_consume_token(CLOB_STRING);
          break;
          }
        default:
          jj_la1[446] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
// Remember whether last token was a delimited identifier
                nextToLastTokenDelimitedIdentifier = lastTokenDelimitedIdentifier;
                lastTokenDelimitedIdentifier = Boolean.FALSE;
                nextToLastIdentifierToken = lastIdentifierToken;
                lastIdentifierToken = tok;
                {if ("" != null) return tok.image;}
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="caseSensitiveIdentifierPlusReservedWords">caseSensitiveIdentifinonerPlusReservedWords</A>
 */
  final public String caseSensitiveIdentifierPlusReservedWords() throws ParseException {String str;
    if (jj_2_80(1)) {
      str = caseSensitiveIdentifier();
{if ("" != null) return str;}
    } else {
      switch (jj_nt.kind) {
      case ADD:
      case ALL:
      case ALLOCATE:
      case ALTER:
      case AND:
      case ANY:
      case ARE:
      case AS:
      case ASC:
      case ASSERTION:
      case AT:
      case AUTHORIZATION:
      case AVG:
      case BEGIN:
      case BETWEEN:
      case BIT:
      case BOTH:
      case BY:
      case CASCADE:
      case CASCADED:
      case CASE:
      case CAST:
      case CHAR:
      case CHARACTER:
      case CHECK:
      case CLOSE:
      case COLLATE:
      case COLLATION:
      case COLUMN:
      case COMMIT:
      case CONNECT:
      case CONNECTION:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTINUE:
      case CONVERT:
      case CORRESPONDING:
      case CREATE:
      case CURRENT:
      case CURRENT_DATE:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case DEALLOCATE:
      case DEC:
      case DECIMAL:
      case DECLARE:
      case _DEFAULT:
      case DEFERRABLE:
      case DEFERRED:
      case DELETE:
      case DESC:
      case DESCRIBE:
      case DIAGNOSTICS:
      case DISCONNECT:
      case DISTINCT:
      case DOUBLE:
      case DROP:
      case ELSE:
      case END:
      case ENDEXEC:
      case ESCAPE:
      case EXCEPT:
      case EXCEPTION:
      case EXEC:
      case EXECUTE:
      case EXISTS:
      case EXTERNAL:
      case FALSE:
      case FETCH:
      case FIRST:
      case FLOAT:
      case FOR:
      case FOREIGN:
      case FOUND:
      case FROM:
      case FULL:
      case FUNCTION:
      case GET:
      case GLOBAL:
      case GO:
      case GOTO:
      case GRANT:
      case GROUP:
      case HAVING:
      case HOUR:
      case IDENTITY:
      case IMMEDIATE:
      case IN:
      case INDICATOR:
      case INITIALLY:
      case INNER:
      case INPUT:
      case INSENSITIVE:
      case INSERT:
      case INT:
      case INTEGER:
      case INTERSECT:
      case INTO:
      case IS:
      case ISOLATION:
      case JOIN:
      case KEY:
      case LAST:
      case LEADING:
      case LEFT:
      case LIKE:
      case LOWER:
      case MATCH:
      case MAX:
      case MIN:
      case MINUTE:
      case NATIONAL:
      case NATURAL:
      case NCHAR:
      case NEXT:
      case NO:
      case NOT:
      case NULL:
      case NULLIF:
      case NUMERIC:
      case OF:
      case ON:
      case ONLY:
      case OPEN:
      case OPTION:
      case OR:
      case ORDER:
      case OUTER:
      case OUTPUT:
      case OVERLAPS:
      case PAD:
      case PARTIAL:
      case PREPARE:
      case PRESERVE:
      case PRIMARY:
      case PRIOR:
      case PRIVILEGES:
      case PROCEDURE:
      case PUBLIC:
      case READ:
      case REAL:
      case REFERENCES:
      case RELATIVE:
      case RESTRICT:
      case REVOKE:
      case RIGHT:
      case ROLLBACK:
      case ROWS:
      case SCHEMA:
      case SCROLL:
      case SECOND:
      case SELECT:
      case SESSION_USER:
      case SET:
      case SMALLINT:
      case SOME:
      case SPACE:
      case SQL:
      case SQLCODE:
      case SQLERROR:
      case SQLSTATE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE:
      case TEMPORARY:
      case TIMEZONE_HOUR:
      case TIMEZONE_MINUTE:
      case TO:
      case TRANSACTION:
      case TRANSLATE:
      case TRANSLATION:
      case TRAILING:
      case TRIM:
      case TRUE:
      case UNION:
      case UNIQUE:
      case UNKNOWN:
      case UPDATE:
      case UPPER:
      case USER:
      case USING:
      case VALUES:
      case VARCHAR:
      case VARYING:
      case VIEW:
      case WHENEVER:
      case WHERE:
      case WITH:
      case WORK:
      case WRITE:
      case YEAR:
      case INOUT:
      case BOOLEAN:
      case CALL:
      case CURRENT_ROLE:
      case GET_CURRENT_CONNECTION:
      case EXPLAIN:
      case LONGINT:
      case LTRIM:
      case NONE:
      case RTRIM:
      case SUBSTR:
      case XML:
      case XMLEXISTS:
      case XMLPARSE:
      case XMLQUERY:
      case XMLSERIALIZE:
      case NVARCHAR:
      case OUT:{
        str = reservedKeyword();
{if ("" != null) return str;}
        break;
        }
      default:
        jj_la1[447] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="caseInsensitiveIdentifierPlusReservedWords">caseInsensitiveIdentifierPlusReservedWords</A>
 */
  final public String caseInsensitiveIdentifierPlusReservedWords() throws ParseException, StandardException {String str;
    if (jj_2_81(1)) {
      str = identifier(Limits.MAX_IDENTIFIER_LENGTH, true);
{if ("" != null) return str;}
    } else {
      switch (jj_nt.kind) {
      case ADD:
      case ALL:
      case ALLOCATE:
      case ALTER:
      case AND:
      case ANY:
      case ARE:
      case AS:
      case ASC:
      case ASSERTION:
      case AT:
      case AUTHORIZATION:
      case AVG:
      case BEGIN:
      case BETWEEN:
      case BIT:
      case BOTH:
      case BY:
      case CASCADE:
      case CASCADED:
      case CASE:
      case CAST:
      case CHAR:
      case CHARACTER:
      case CHECK:
      case CLOSE:
      case COLLATE:
      case COLLATION:
      case COLUMN:
      case COMMIT:
      case CONNECT:
      case CONNECTION:
      case CONSTRAINT:
      case CONSTRAINTS:
      case CONTINUE:
      case CONVERT:
      case CORRESPONDING:
      case CREATE:
      case CURRENT:
      case CURRENT_DATE:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case DEALLOCATE:
      case DEC:
      case DECIMAL:
      case DECLARE:
      case _DEFAULT:
      case DEFERRABLE:
      case DEFERRED:
      case DELETE:
      case DESC:
      case DESCRIBE:
      case DIAGNOSTICS:
      case DISCONNECT:
      case DISTINCT:
      case DOUBLE:
      case DROP:
      case ELSE:
      case END:
      case ENDEXEC:
      case ESCAPE:
      case EXCEPT:
      case EXCEPTION:
      case EXEC:
      case EXECUTE:
      case EXISTS:
      case EXTERNAL:
      case FALSE:
      case FETCH:
      case FIRST:
      case FLOAT:
      case FOR:
      case FOREIGN:
      case FOUND:
      case FROM:
      case FULL:
      case FUNCTION:
      case GET:
      case GLOBAL:
      case GO:
      case GOTO:
      case GRANT:
      case GROUP:
      case HAVING:
      case HOUR:
      case IDENTITY:
      case IMMEDIATE:
      case IN:
      case INDICATOR:
      case INITIALLY:
      case INNER:
      case INPUT:
      case INSENSITIVE:
      case INSERT:
      case INT:
      case INTEGER:
      case INTERSECT:
      case INTO:
      case IS:
      case ISOLATION:
      case JOIN:
      case KEY:
      case LAST:
      case LEADING:
      case LEFT:
      case LIKE:
      case LOWER:
      case MATCH:
      case MAX:
      case MIN:
      case MINUTE:
      case NATIONAL:
      case NATURAL:
      case NCHAR:
      case NEXT:
      case NO:
      case NOT:
      case NULL:
      case NULLIF:
      case NUMERIC:
      case OF:
      case ON:
      case ONLY:
      case OPEN:
      case OPTION:
      case OR:
      case ORDER:
      case OUTER:
      case OUTPUT:
      case OVERLAPS:
      case PAD:
      case PARTIAL:
      case PREPARE:
      case PRESERVE:
      case PRIMARY:
      case PRIOR:
      case PRIVILEGES:
      case PROCEDURE:
      case PUBLIC:
      case READ:
      case REAL:
      case REFERENCES:
      case RELATIVE:
      case RESTRICT:
      case REVOKE:
      case RIGHT:
      case ROLLBACK:
      case ROWS:
      case SCHEMA:
      case SCROLL:
      case SECOND:
      case SELECT:
      case SESSION_USER:
      case SET:
      case SMALLINT:
      case SOME:
      case SPACE:
      case SQL:
      case SQLCODE:
      case SQLERROR:
      case SQLSTATE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE:
      case TEMPORARY:
      case TIMEZONE_HOUR:
      case TIMEZONE_MINUTE:
      case TO:
      case TRANSACTION:
      case TRANSLATE:
      case TRANSLATION:
      case TRAILING:
      case TRIM:
      case TRUE:
      case UNION:
      case UNIQUE:
      case UNKNOWN:
      case UPDATE:
      case UPPER:
      case USER:
      case USING:
      case VALUES:
      case VARCHAR:
      case VARYING:
      case VIEW:
      case WHENEVER:
      case WHERE:
      case WITH:
      case WORK:
      case WRITE:
      case YEAR:
      case INOUT:
      case BOOLEAN:
      case CALL:
      case CURRENT_ROLE:
      case GET_CURRENT_CONNECTION:
      case EXPLAIN:
      case LONGINT:
      case LTRIM:
      case NONE:
      case RTRIM:
      case SUBSTR:
      case XML:
      case XMLEXISTS:
      case XMLPARSE:
      case XMLQUERY:
      case XMLSERIALIZE:
      case NVARCHAR:
      case OUT:{
        str = reservedKeyword();
{if ("" != null) return StringUtil.SQLToUpperCase(str);}
        break;
        }
      default:
        jj_la1[448] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/*
 * <A NAME="caseSensitiveIdentifier">caseSensitiveIdentifier</A>
 */
  final public String caseSensitiveIdentifier() throws ParseException {String  str;
        Token   tok;
    switch (jj_nt.kind) {
    case IDENTIFIER:{
      tok = jj_consume_token(IDENTIFIER);
// Remember whether last token was a delimited identifier
                nextToLastTokenDelimitedIdentifier = lastTokenDelimitedIdentifier;
                lastTokenDelimitedIdentifier = Boolean.FALSE;
                {if ("" != null) return tok.image;}
      break;
      }
    case DELIMITED_IDENTIFIER:{
      str = delimitedIdentifier();
{if ("" != null) return str;}
      break;
      }
    default:
      jj_la1[449] = jj_gen;
      if (jj_2_82(1)) {
        str = nonReservedKeyword();
{if ("" != null) return str;}
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_2_48(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_48(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  private boolean jj_2_49(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_49(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  private boolean jj_2_50(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_50(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  private boolean jj_2_51(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_51(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  private boolean jj_2_52(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_52(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  private boolean jj_2_53(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_53(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  private boolean jj_2_54(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_54(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  private boolean jj_2_55(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_55(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  private boolean jj_2_56(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_56(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  private boolean jj_2_57(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_57(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  private boolean jj_2_58(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_58(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  private boolean jj_2_59(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_59(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  private boolean jj_2_60(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_60(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  private boolean jj_2_61(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_61(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  private boolean jj_2_62(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_62(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  private boolean jj_2_63(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_63(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  private boolean jj_2_64(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_64(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  private boolean jj_2_65(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_65(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  private boolean jj_2_66(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_66(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  private boolean jj_2_67(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_67(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  private boolean jj_2_68(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_68(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  private boolean jj_2_69(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_69(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  private boolean jj_2_70(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_70(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  private boolean jj_2_71(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_71(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  private boolean jj_2_72(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_72(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  private boolean jj_2_73(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_73(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  private boolean jj_2_74(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_74(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(73, xla); }
  }

  private boolean jj_2_75(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_75(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(74, xla); }
  }

  private boolean jj_2_76(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_76(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(75, xla); }
  }

  private boolean jj_2_77(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_77(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(76, xla); }
  }

  private boolean jj_2_78(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_78(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(77, xla); }
  }

  private boolean jj_2_79(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_79(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(78, xla); }
  }

  private boolean jj_2_80(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_80(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(79, xla); }
  }

  private boolean jj_2_81(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_81(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(80, xla); }
  }

  private boolean jj_2_82(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_82(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(81, xla); }
  }

  private boolean jj_3R_412()
 {
    if (jj_scan_token(SELECT)) return true;
    return false;
  }

  private boolean jj_3R_310()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(180)) {
    jj_scanpos = xsp;
    if (jj_scan_token(179)) return true;
    }
    return false;
  }

  private boolean jj_3R_259()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_310()) {
    jj_scanpos = xsp;
    if (jj_3R_311()) {
    jj_scanpos = xsp;
    if (jj_3R_312()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_371()
 {
    if (jj_scan_token(SECOND)) return true;
    return false;
  }

  private boolean jj_3R_382()
 {
    if (jj_3R_384()) return true;
    return false;
  }

  private boolean jj_3R_278()
 {
    if (jj_3R_259()) return true;
    return false;
  }

  private boolean jj_3R_370()
 {
    if (jj_3R_387()) return true;
    return false;
  }

  private boolean jj_3R_346()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_370()) {
    jj_scanpos = xsp;
    if (jj_3R_371()) return true;
    }
    return false;
  }

  private boolean jj_3R_411()
 {
    if (jj_3R_413()) return true;
    return false;
  }

  private boolean jj_3R_377()
 {
    if (jj_scan_token(APPROXIMATE_NUMERIC)) return true;
    return false;
  }

  private boolean jj_3R_136()
 {
    if (jj_scan_token(DROP)) return true;
    return false;
  }

  private boolean jj_3R_410()
 {
    if (jj_3R_412()) return true;
    return false;
  }

  private boolean jj_3R_409()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_410()) {
    jj_scanpos = xsp;
    if (jj_3R_411()) return true;
    }
    return false;
  }

  private boolean jj_3R_162()
 {
    if (jj_3R_245()) return true;
    return false;
  }

  private boolean jj_3R_376()
 {
    if (jj_scan_token(EXACT_NUMERIC)) return true;
    return false;
  }

  private boolean jj_3R_353()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_376()) {
    jj_scanpos = xsp;
    if (jj_3R_377()) return true;
    }
    return false;
  }

  private boolean jj_3R_400()
 {
    if (jj_scan_token(LEFT_PAREN)) return true;
    return false;
  }

  private boolean jj_3R_399()
 {
    if (jj_3R_409()) return true;
    return false;
  }

  private boolean jj_3R_380()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_399()) {
    jj_scanpos = xsp;
    if (jj_3R_400()) return true;
    }
    return false;
  }

  private boolean jj_3R_338()
 {
    if (jj_scan_token(NUMERIC)) return true;
    return false;
  }

  private boolean jj_3_13()
 {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_277()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_338()) {
    jj_scanpos = xsp;
    if (jj_scan_token(128)) {
    jj_scanpos = xsp;
    if (jj_scan_token(127)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_135()
 {
    if (jj_scan_token(CREATE)) return true;
    return false;
  }

  private boolean jj_3R_242()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_277()) {
    jj_scanpos = xsp;
    if (jj_3R_278()) return true;
    }
    return false;
  }

  private boolean jj_3_65()
 {
    if (jj_3R_121()) return true;
    return false;
  }

  private boolean jj_3_52()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_337()
 {
    if (jj_3R_360()) return true;
    return false;
  }

  private boolean jj_3R_381()
 {
    if (jj_scan_token(CALL)) return true;
    return false;
  }

  private boolean jj_3R_359()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_381()) {
    jj_scanpos = xsp;
    if (jj_3R_382()) return true;
    }
    return false;
  }

  private boolean jj_3R_328()
 {
    if (jj_scan_token(UR)) return true;
    return false;
  }

  private boolean jj_3_22()
 {
    if (jj_3R_92()) return true;
    return false;
  }

  private boolean jj_3_62()
 {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_327()
 {
    if (jj_scan_token(CS)) return true;
    return false;
  }

  private boolean jj_3R_209()
 {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_326()
 {
    if (jj_scan_token(RS)) return true;
    return false;
  }

  private boolean jj_3R_91()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_155()) {
    jj_scanpos = xsp;
    if (jj_3_22()) return true;
    }
    return false;
  }

  private boolean jj_3R_155()
 {
    if (jj_3R_242()) return true;
    return false;
  }

  private boolean jj_3R_120()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_209()) jj_scanpos = xsp;
    if (jj_3R_208()) return true;
    return false;
  }

  private boolean jj_3R_325()
 {
    if (jj_scan_token(RR)) return true;
    return false;
  }

  private boolean jj_3R_222()
 {
    if (jj_scan_token(READ)) return true;
    return false;
  }

  private boolean jj_3_64()
 {
    if (jj_3R_120()) return true;
    return false;
  }

  private boolean jj_3R_324()
 {
    if (jj_3R_357()) return true;
    return false;
  }

  private boolean jj_3R_221()
 {
    if (jj_scan_token(READ)) return true;
    return false;
  }

  private boolean jj_3R_268()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_325()) {
    jj_scanpos = xsp;
    if (jj_3R_326()) {
    jj_scanpos = xsp;
    if (jj_3R_327()) {
    jj_scanpos = xsp;
    if (jj_3R_328()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_398()
 {
    if (jj_scan_token(NATIONAL)) return true;
    return false;
  }

  private boolean jj_3R_323()
 {
    if (jj_3R_356()) return true;
    return false;
  }

  private boolean jj_3R_293()
 {
    if (jj_scan_token(IDENTITY_VAL_LOCAL)) return true;
    return false;
  }

  private boolean jj_3R_106()
 {
    if (jj_3R_81()) return true;
    return false;
  }

  private boolean jj_3R_397()
 {
    if (jj_3R_241()) return true;
    return false;
  }

  private boolean jj_3R_322()
 {
    if (jj_3R_355()) return true;
    return false;
  }

  private boolean jj_3R_292()
 {
    if (jj_scan_token(MOD)) return true;
    return false;
  }

  private boolean jj_3R_98()
 {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3R_333()
 {
    if (jj_scan_token(LEFT_BRACE)) return true;
    return false;
  }

  private boolean jj_3R_220()
 {
    if (jj_scan_token(DIRTY)) return true;
    return false;
  }

  private boolean jj_3R_332()
 {
    if (jj_3R_359()) return true;
    return false;
  }

  private boolean jj_3R_396()
 {
    if (jj_scan_token(BINARY)) return true;
    return false;
  }

  private boolean jj_3R_321()
 {
    if (jj_3R_354()) return true;
    return false;
  }

  private boolean jj_3_48()
 {
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_203()
 {
    if (jj_scan_token(LEFT_PAREN)) return true;
    return false;
  }

  private boolean jj_3R_219()
 {
    if (jj_scan_token(CURSOR)) return true;
    return false;
  }

  private boolean jj_3R_352()
 {
    if (jj_3R_339()) return true;
    return false;
  }

  private boolean jj_3R_320()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_352()) jj_scanpos = xsp;
    if (jj_3R_353()) return true;
    return false;
  }

  private boolean jj_3R_267()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_320()) {
    jj_scanpos = xsp;
    if (jj_3R_321()) {
    jj_scanpos = xsp;
    if (jj_3R_322()) {
    jj_scanpos = xsp;
    if (jj_3R_323()) {
    jj_scanpos = xsp;
    if (jj_3R_324()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_395()
 {
    if (jj_scan_token(NCLOB)) return true;
    return false;
  }

  private boolean jj_3R_274()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_332()) {
    jj_scanpos = xsp;
    if (jj_3R_333()) return true;
    }
    return false;
  }

  private boolean jj_3R_218()
 {
    if (jj_scan_token(REPEATABLE)) return true;
    return false;
  }

  private boolean jj_3R_288()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(77)) {
    jj_scanpos = xsp;
    if (jj_scan_token(78)) {
    jj_scanpos = xsp;
    if (jj_scan_token(79)) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) {
    jj_scanpos = xsp;
    if (jj_scan_token(85)) {
    jj_scanpos = xsp;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(88)) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) {
    jj_scanpos = xsp;
    if (jj_scan_token(90)) {
    jj_scanpos = xsp;
    if (jj_scan_token(91)) {
    jj_scanpos = xsp;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_scan_token(94)) {
    jj_scanpos = xsp;
    if (jj_scan_token(95)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) {
    jj_scanpos = xsp;
    if (jj_scan_token(97)) {
    jj_scanpos = xsp;
    if (jj_scan_token(98)) {
    jj_scanpos = xsp;
    if (jj_scan_token(99)) {
    jj_scanpos = xsp;
    if (jj_scan_token(100)) {
    jj_scanpos = xsp;
    if (jj_scan_token(101)) {
    jj_scanpos = xsp;
    if (jj_scan_token(103)) {
    jj_scanpos = xsp;
    if (jj_scan_token(104)) {
    jj_scanpos = xsp;
    if (jj_scan_token(106)) {
    jj_scanpos = xsp;
    if (jj_scan_token(107)) {
    jj_scanpos = xsp;
    if (jj_scan_token(108)) {
    jj_scanpos = xsp;
    if (jj_scan_token(109)) {
    jj_scanpos = xsp;
    if (jj_scan_token(110)) {
    jj_scanpos = xsp;
    if (jj_scan_token(111)) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) {
    jj_scanpos = xsp;
    if (jj_scan_token(113)) {
    jj_scanpos = xsp;
    if (jj_scan_token(114)) {
    jj_scanpos = xsp;
    if (jj_scan_token(115)) {
    jj_scanpos = xsp;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_scan_token(118)) {
    jj_scanpos = xsp;
    if (jj_scan_token(119)) {
    jj_scanpos = xsp;
    if (jj_scan_token(120)) {
    jj_scanpos = xsp;
    if (jj_scan_token(121)) {
    jj_scanpos = xsp;
    if (jj_scan_token(122)) {
    jj_scanpos = xsp;
    if (jj_scan_token(123)) {
    jj_scanpos = xsp;
    if (jj_scan_token(124)) {
    jj_scanpos = xsp;
    if (jj_scan_token(126)) {
    jj_scanpos = xsp;
    if (jj_scan_token(127)) {
    jj_scanpos = xsp;
    if (jj_scan_token(128)) {
    jj_scanpos = xsp;
    if (jj_scan_token(129)) {
    jj_scanpos = xsp;
    if (jj_scan_token(130)) {
    jj_scanpos = xsp;
    if (jj_scan_token(131)) {
    jj_scanpos = xsp;
    if (jj_scan_token(132)) {
    jj_scanpos = xsp;
    if (jj_scan_token(133)) {
    jj_scanpos = xsp;
    if (jj_scan_token(134)) {
    jj_scanpos = xsp;
    if (jj_scan_token(135)) {
    jj_scanpos = xsp;
    if (jj_scan_token(136)) {
    jj_scanpos = xsp;
    if (jj_scan_token(137)) {
    jj_scanpos = xsp;
    if (jj_scan_token(138)) {
    jj_scanpos = xsp;
    if (jj_scan_token(139)) {
    jj_scanpos = xsp;
    if (jj_scan_token(140)) {
    jj_scanpos = xsp;
    if (jj_scan_token(141)) {
    jj_scanpos = xsp;
    if (jj_scan_token(143)) {
    jj_scanpos = xsp;
    if (jj_scan_token(144)) {
    jj_scanpos = xsp;
    if (jj_scan_token(145)) {
    jj_scanpos = xsp;
    if (jj_scan_token(146)) {
    jj_scanpos = xsp;
    if (jj_scan_token(147)) {
    jj_scanpos = xsp;
    if (jj_scan_token(148)) {
    jj_scanpos = xsp;
    if (jj_scan_token(149)) {
    jj_scanpos = xsp;
    if (jj_scan_token(150)) {
    jj_scanpos = xsp;
    if (jj_scan_token(151)) {
    jj_scanpos = xsp;
    if (jj_scan_token(152)) {
    jj_scanpos = xsp;
    if (jj_scan_token(153)) {
    jj_scanpos = xsp;
    if (jj_scan_token(154)) {
    jj_scanpos = xsp;
    if (jj_scan_token(155)) {
    jj_scanpos = xsp;
    if (jj_scan_token(156)) {
    jj_scanpos = xsp;
    if (jj_scan_token(157)) {
    jj_scanpos = xsp;
    if (jj_scan_token(158)) {
    jj_scanpos = xsp;
    if (jj_scan_token(159)) {
    jj_scanpos = xsp;
    if (jj_scan_token(160)) {
    jj_scanpos = xsp;
    if (jj_scan_token(161)) {
    jj_scanpos = xsp;
    if (jj_scan_token(162)) {
    jj_scanpos = xsp;
    if (jj_scan_token(369)) {
    jj_scanpos = xsp;
    if (jj_scan_token(163)) {
    jj_scanpos = xsp;
    if (jj_scan_token(164)) {
    jj_scanpos = xsp;
    if (jj_scan_token(165)) {
    jj_scanpos = xsp;
    if (jj_scan_token(166)) {
    jj_scanpos = xsp;
    if (jj_scan_token(167)) {
    jj_scanpos = xsp;
    if (jj_scan_token(168)) {
    jj_scanpos = xsp;
    if (jj_scan_token(169)) {
    jj_scanpos = xsp;
    if (jj_scan_token(170)) {
    jj_scanpos = xsp;
    if (jj_scan_token(171)) {
    jj_scanpos = xsp;
    if (jj_scan_token(172)) {
    jj_scanpos = xsp;
    if (jj_scan_token(173)) {
    jj_scanpos = xsp;
    if (jj_scan_token(174)) {
    jj_scanpos = xsp;
    if (jj_scan_token(175)) {
    jj_scanpos = xsp;
    if (jj_scan_token(304)) {
    jj_scanpos = xsp;
    if (jj_scan_token(176)) {
    jj_scanpos = xsp;
    if (jj_scan_token(177)) {
    jj_scanpos = xsp;
    if (jj_scan_token(178)) {
    jj_scanpos = xsp;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(180)) {
    jj_scanpos = xsp;
    if (jj_scan_token(181)) {
    jj_scanpos = xsp;
    if (jj_scan_token(182)) {
    jj_scanpos = xsp;
    if (jj_scan_token(183)) {
    jj_scanpos = xsp;
    if (jj_scan_token(184)) {
    jj_scanpos = xsp;
    if (jj_scan_token(185)) {
    jj_scanpos = xsp;
    if (jj_scan_token(186)) {
    jj_scanpos = xsp;
    if (jj_scan_token(187)) {
    jj_scanpos = xsp;
    if (jj_scan_token(188)) {
    jj_scanpos = xsp;
    if (jj_scan_token(189)) {
    jj_scanpos = xsp;
    if (jj_scan_token(190)) {
    jj_scanpos = xsp;
    if (jj_scan_token(191)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) {
    jj_scanpos = xsp;
    if (jj_scan_token(193)) {
    jj_scanpos = xsp;
    if (jj_scan_token(194)) {
    jj_scanpos = xsp;
    if (jj_scan_token(195)) {
    jj_scanpos = xsp;
    if (jj_scan_token(197)) {
    jj_scanpos = xsp;
    if (jj_scan_token(198)) {
    jj_scanpos = xsp;
    if (jj_scan_token(199)) {
    jj_scanpos = xsp;
    if (jj_scan_token(411)) {
    jj_scanpos = xsp;
    if (jj_scan_token(200)) {
    jj_scanpos = xsp;
    if (jj_scan_token(201)) {
    jj_scanpos = xsp;
    if (jj_scan_token(374)) {
    jj_scanpos = xsp;
    if (jj_scan_token(202)) {
    jj_scanpos = xsp;
    if (jj_scan_token(203)) {
    jj_scanpos = xsp;
    if (jj_scan_token(204)) {
    jj_scanpos = xsp;
    if (jj_scan_token(205)) {
    jj_scanpos = xsp;
    if (jj_scan_token(206)) {
    jj_scanpos = xsp;
    if (jj_scan_token(207)) {
    jj_scanpos = xsp;
    if (jj_scan_token(208)) {
    jj_scanpos = xsp;
    if (jj_scan_token(209)) {
    jj_scanpos = xsp;
    if (jj_scan_token(210)) {
    jj_scanpos = xsp;
    if (jj_scan_token(211)) {
    jj_scanpos = xsp;
    if (jj_scan_token(212)) {
    jj_scanpos = xsp;
    if (jj_scan_token(416)) {
    jj_scanpos = xsp;
    if (jj_scan_token(213)) {
    jj_scanpos = xsp;
    if (jj_scan_token(214)) {
    jj_scanpos = xsp;
    if (jj_scan_token(215)) {
    jj_scanpos = xsp;
    if (jj_scan_token(216)) {
    jj_scanpos = xsp;
    if (jj_scan_token(217)) {
    jj_scanpos = xsp;
    if (jj_scan_token(218)) {
    jj_scanpos = xsp;
    if (jj_scan_token(219)) {
    jj_scanpos = xsp;
    if (jj_scan_token(220)) {
    jj_scanpos = xsp;
    if (jj_scan_token(221)) {
    jj_scanpos = xsp;
    if (jj_scan_token(222)) {
    jj_scanpos = xsp;
    if (jj_scan_token(223)) {
    jj_scanpos = xsp;
    if (jj_scan_token(224)) {
    jj_scanpos = xsp;
    if (jj_scan_token(225)) {
    jj_scanpos = xsp;
    if (jj_scan_token(226)) {
    jj_scanpos = xsp;
    if (jj_scan_token(227)) {
    jj_scanpos = xsp;
    if (jj_scan_token(228)) {
    jj_scanpos = xsp;
    if (jj_scan_token(229)) {
    jj_scanpos = xsp;
    if (jj_scan_token(230)) {
    jj_scanpos = xsp;
    if (jj_scan_token(231)) {
    jj_scanpos = xsp;
    if (jj_scan_token(232)) {
    jj_scanpos = xsp;
    if (jj_scan_token(233)) {
    jj_scanpos = xsp;
    if (jj_scan_token(234)) {
    jj_scanpos = xsp;
    if (jj_scan_token(235)) {
    jj_scanpos = xsp;
    if (jj_scan_token(236)) {
    jj_scanpos = xsp;
    if (jj_scan_token(237)) {
    jj_scanpos = xsp;
    if (jj_scan_token(238)) {
    jj_scanpos = xsp;
    if (jj_scan_token(239)) {
    jj_scanpos = xsp;
    if (jj_scan_token(240)) {
    jj_scanpos = xsp;
    if (jj_scan_token(241)) {
    jj_scanpos = xsp;
    if (jj_scan_token(242)) {
    jj_scanpos = xsp;
    if (jj_scan_token(243)) {
    jj_scanpos = xsp;
    if (jj_scan_token(244)) {
    jj_scanpos = xsp;
    if (jj_scan_token(245)) {
    jj_scanpos = xsp;
    if (jj_scan_token(246)) {
    jj_scanpos = xsp;
    if (jj_scan_token(247)) {
    jj_scanpos = xsp;
    if (jj_scan_token(248)) {
    jj_scanpos = xsp;
    if (jj_scan_token(249)) {
    jj_scanpos = xsp;
    if (jj_scan_token(251)) {
    jj_scanpos = xsp;
    if (jj_scan_token(252)) {
    jj_scanpos = xsp;
    if (jj_scan_token(253)) {
    jj_scanpos = xsp;
    if (jj_scan_token(254)) {
    jj_scanpos = xsp;
    if (jj_scan_token(255)) {
    jj_scanpos = xsp;
    if (jj_scan_token(259)) {
    jj_scanpos = xsp;
    if (jj_scan_token(256)) {
    jj_scanpos = xsp;
    if (jj_scan_token(257)) {
    jj_scanpos = xsp;
    if (jj_scan_token(258)) {
    jj_scanpos = xsp;
    if (jj_scan_token(261)) {
    jj_scanpos = xsp;
    if (jj_scan_token(263)) {
    jj_scanpos = xsp;
    if (jj_scan_token(264)) {
    jj_scanpos = xsp;
    if (jj_scan_token(265)) {
    jj_scanpos = xsp;
    if (jj_scan_token(266)) {
    jj_scanpos = xsp;
    if (jj_scan_token(267)) {
    jj_scanpos = xsp;
    if (jj_scan_token(268)) {
    jj_scanpos = xsp;
    if (jj_scan_token(269)) {
    jj_scanpos = xsp;
    if (jj_scan_token(271)) {
    jj_scanpos = xsp;
    if (jj_scan_token(273)) {
    jj_scanpos = xsp;
    if (jj_scan_token(274)) {
    jj_scanpos = xsp;
    if (jj_scan_token(275)) {
    jj_scanpos = xsp;
    if (jj_scan_token(276)) {
    jj_scanpos = xsp;
    if (jj_scan_token(277)) {
    jj_scanpos = xsp;
    if (jj_scan_token(278)) {
    jj_scanpos = xsp;
    if (jj_scan_token(279)) {
    jj_scanpos = xsp;
    if (jj_scan_token(280)) {
    jj_scanpos = xsp;
    if (jj_scan_token(281)) {
    jj_scanpos = xsp;
    if (jj_scan_token(363)) {
    jj_scanpos = xsp;
    if (jj_scan_token(364)) {
    jj_scanpos = xsp;
    if (jj_scan_token(366)) {
    jj_scanpos = xsp;
    if (jj_scan_token(370)) {
    jj_scanpos = xsp;
    if (jj_scan_token(371)) {
    jj_scanpos = xsp;
    if (jj_scan_token(373)) {
    jj_scanpos = xsp;
    if (jj_scan_token(378)) {
    jj_scanpos = xsp;
    if (jj_scan_token(260)) {
    jj_scanpos = xsp;
    if (jj_scan_token(379)) {
    jj_scanpos = xsp;
    if (jj_scan_token(380)) {
    jj_scanpos = xsp;
    if (jj_scan_token(382)) {
    jj_scanpos = xsp;
    if (jj_scan_token(384)) {
    jj_scanpos = xsp;
    if (jj_scan_token(381)) {
    jj_scanpos = xsp;
    if (jj_scan_token(383)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_291()
 {
    if (jj_scan_token(SQRT)) return true;
    return false;
  }

  private boolean jj_3R_217()
 {
    if (jj_scan_token(SERIALIZABLE)) return true;
    return false;
  }

  private boolean jj_3R_394()
 {
    if (jj_scan_token(JSON)) return true;
    return false;
  }

  private boolean jj_3R_290()
 {
    if (jj_scan_token(ABSVAL)) return true;
    return false;
  }

  private boolean jj_3R_216()
 {
    if (jj_3R_268()) return true;
    return false;
  }

  private boolean jj_3R_289()
 {
    if (jj_scan_token(ABS)) return true;
    return false;
  }

  private boolean jj_3R_253()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_289()) {
    jj_scanpos = xsp;
    if (jj_3R_290()) {
    jj_scanpos = xsp;
    if (jj_3R_291()) {
    jj_scanpos = xsp;
    if (jj_3R_292()) {
    jj_scanpos = xsp;
    if (jj_3R_293()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_392()
 {
    if (jj_scan_token(CLOB)) return true;
    return false;
  }

  private boolean jj_3R_123()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_216()) {
    jj_scanpos = xsp;
    if (jj_3R_217()) {
    jj_scanpos = xsp;
    if (jj_3R_218()) {
    jj_scanpos = xsp;
    if (jj_3R_219()) {
    jj_scanpos = xsp;
    if (jj_3R_220()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == READ && getToken(2).kind == COMMITTED;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_221()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == READ && getToken(2).kind == UNCOMMITTED;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_222()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_68()
 {
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3R_393()
 {
    if (jj_scan_token(CLOB_STRING)) return true;
    return false;
  }

  private boolean jj_3R_391()
 {
    if (jj_scan_token(BLOB)) return true;
    return false;
  }

  private boolean jj_3R_358()
 {
    if (jj_3R_380()) return true;
    return false;
  }

  private boolean jj_3R_374()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_391()) {
    jj_scanpos = xsp;
    if (jj_3R_392()) {
    jj_scanpos = xsp;
    if (jj_3R_393()) {
    jj_scanpos = xsp;
    if (jj_3R_394()) {
    jj_scanpos = xsp;
    if (jj_3R_395()) {
    jj_scanpos = xsp;
    if (jj_3R_396()) {
    jj_scanpos = xsp;
    if (jj_3R_397()) {
    jj_scanpos = xsp;
    if (jj_3R_398()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_315()
 {
    if (jj_scan_token(INOUT)) return true;
    return false;
  }

  private boolean jj_3R_314()
 {
    if (jj_scan_token(OUT)) return true;
    return false;
  }

  private boolean jj_3R_227()
 {
    if (jj_scan_token(CHECK)) return true;
    return false;
  }

  private boolean jj_3R_313()
 {
    if (jj_scan_token(IN)) return true;
    return false;
  }

  private boolean jj_3R_262()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_313()) {
    jj_scanpos = xsp;
    if (jj_3R_314()) {
    jj_scanpos = xsp;
    if (jj_3R_315()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_269()
 {
    if (jj_scan_token(DELIMITED_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_202()
 {
    if (jj_3R_261()) return true;
    return false;
  }

  private boolean jj_3_11()
 {
    if (jj_3R_80()) return true;
    return false;
  }

  private boolean jj_3R_206()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_262()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_226()
 {
    if (jj_scan_token(UNIQUE)) return true;
    return false;
  }

  private boolean jj_3R_236()
 {
    if (jj_scan_token(CURRENT)) return true;
    return false;
  }

  private boolean jj_3R_154()
 {
    if (jj_scan_token(NVARCHAR)) return true;
    return false;
  }

  private boolean jj_3R_143()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(184)) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == CURRENT && getToken(2).kind == ISOLATION;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_236()) return true;
    }
    return false;
  }

  private boolean jj_3R_82()
 {
    if (jj_3R_145()) return true;
    return false;
  }

  private boolean jj_3R_207()
 {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3_79()
 {
    if (jj_3R_127()) return true;
    return false;
  }

  private boolean jj_3R_119()
 {
    if (jj_3R_206()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_207()) jj_scanpos = xsp;
    if (jj_3R_208()) return true;
    return false;
  }

  private boolean jj_3R_78()
 {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_302()
 {
    if (jj_scan_token(XMLQUERY)) return true;
    return false;
  }

  private boolean jj_3R_153()
 {
    if (jj_scan_token(NCHAR)) return true;
    return false;
  }

  private boolean jj_3R_225()
 {
    if (jj_scan_token(FOREIGN)) return true;
    return false;
  }

  private boolean jj_3_12()
 {
    if (jj_3R_81()) return true;
    return false;
  }

  private boolean jj_3R_329()
 {
    if (jj_3R_358()) return true;
    return false;
  }

  private boolean jj_3R_80()
 {
    if (jj_3R_103()) return true;
    return false;
  }

  private boolean jj_3R_301()
 {
    if (jj_scan_token(XMLEXISTS)) return true;
    return false;
  }

  private boolean jj_3R_239()
 {
    if (jj_3R_269()) return true;
    return false;
  }

  private boolean jj_3R_341()
 {
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3_63()
 {
    if (jj_3R_119()) return true;
    return false;
  }

  private boolean jj_3R_300()
 {
    if (jj_scan_token(XMLSERIALIZE)) return true;
    return false;
  }

  private boolean jj_3R_152()
 {
    if (jj_scan_token(NATIONAL)) return true;
    return false;
  }

  private boolean jj_3R_299()
 {
    if (jj_scan_token(XMLPARSE)) return true;
    return false;
  }

  private boolean jj_3R_255()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_299()) {
    jj_scanpos = xsp;
    if (jj_3R_300()) {
    jj_scanpos = xsp;
    if (jj_3R_301()) {
    jj_scanpos = xsp;
    if (jj_3R_302()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_224()
 {
    if (jj_scan_token(PRIMARY)) return true;
    return false;
  }

  private boolean jj_3_58()
 {
    if (jj_3R_81()) return true;
    return false;
  }

  private boolean jj_3R_215()
 {
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_384()
 {
    if (jj_scan_token(QUESTION_MARK)) return true;
    return false;
  }

  private boolean jj_3R_205()
 {
    if (jj_scan_token(TABLE)) return true;
    return false;
  }

  private boolean jj_3R_90()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_152()) {
    jj_scanpos = xsp;
    if (jj_3R_153()) {
    jj_scanpos = xsp;
    if (jj_3R_154()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_145()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_238()) {
    jj_scanpos = xsp;
    if (jj_3R_239()) {
    jj_scanpos = xsp;
    if (jj_3_79()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_238()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_67()
 {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_126()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == CONSTRAINT;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_223()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == PRIMARY;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_224()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == FOREIGN;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_225()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == UNIQUE;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_226()) {
    jj_scanpos = xsp;
    if (jj_3R_227()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_223()
 {
    if (jj_scan_token(CONSTRAINT)) return true;
    return false;
  }

  private boolean jj_3_61()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_214()
 {
    if (jj_3R_250()) return true;
    return false;
  }

  private boolean jj_3R_191()
 {
    if (jj_3R_258()) return true;
    return false;
  }

  private boolean jj_3R_309()
 {
    if (jj_scan_token(VARCHAR)) return true;
    return false;
  }

  private boolean jj_3R_213()
 {
    if (jj_3R_250()) return true;
    return false;
  }

  private boolean jj_3R_308()
 {
    if (jj_scan_token(CHAR)) return true;
    return false;
  }

  private boolean jj_3R_258()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_308()) {
    jj_scanpos = xsp;
    if (jj_3R_309()) return true;
    }
    return false;
  }

  private boolean jj_3R_117()
 {
    if (jj_3R_205()) return true;
    return false;
  }

  private boolean jj_3R_116()
 {
    if (jj_3R_204()) return true;
    return false;
  }

  private boolean jj_3R_273()
 {
    if (jj_scan_token(UPDATE)) return true;
    return false;
  }

  private boolean jj_3R_115()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_57()) {
    jj_scanpos = xsp;
    if (jj_3_58()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == LEFT_PAREN &&
                                (
                                        getToken(2).kind == SELECT ||
                                        getToken(2).kind == VALUES
                                );
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_202()) {
    jj_scanpos = xsp;
    if (jj_3R_203()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3_57()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = newInvocationFollows(1);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_116()) {
    jj_scanpos = xsp;
    if (jj_3R_117()) return true;
    }
    return false;
  }

  private boolean jj_3R_212()
 {
    if (jj_3R_266()) return true;
    return false;
  }

  private boolean jj_3_43()
 {
    if (jj_3R_108()) return true;
    return false;
  }

  private boolean jj_3R_241()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(100)) {
    jj_scanpos = xsp;
    if (jj_scan_token(101)) return true;
    }
    return false;
  }

  private boolean jj_3R_81()
 {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_76()
 {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_211()
 {
    if (jj_3R_265()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_75()
 {
    if (jj_3R_140()) return true;
    return false;
  }

  private boolean jj_3R_107()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_190()) {
    jj_scanpos = xsp;
    if (jj_3_43()) {
    jj_scanpos = xsp;
    if (jj_3R_191()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_190()
 {
    if (jj_3R_257()) return true;
    return false;
  }

  private boolean jj_3R_77()
 {
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_204()
 {
    if (jj_scan_token(NEW)) return true;
    return false;
  }

  private boolean jj_3R_122()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getToken(2).kind == SCHEMA || getToken(2).kind == SQLID;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_210()) {
    jj_scanpos = xsp;
    if (jj_3R_211()) {
    jj_scanpos = xsp;
    if (jj_3R_212()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == DATE ||
                getToken(1).kind == TIME ||
                getToken(1).kind == TIMESTAMP;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_213()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(2).kind == LEFT_PAREN ||
                       (getToken(4).kind == LEFT_PAREN &&
                        getToken(2).kind != COMMA);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_214()) {
    jj_scanpos = xsp;
    if (jj_3_67()) {
    jj_scanpos = xsp;
    if (jj_3R_215()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_210()
 {
    if (jj_scan_token(CURRENT)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3R_74()
 {
    if (jj_3R_139()) return true;
    return false;
  }

  private boolean jj_3R_73()
 {
    if (jj_3R_138()) return true;
    return false;
  }

  private boolean jj_3R_72()
 {
    if (jj_3R_137()) return true;
    return false;
  }

  private boolean jj_3R_71()
 {
    if (jj_3R_136()) return true;
    return false;
  }

  private boolean jj_3R_70()
 {
    if (jj_3R_135()) return true;
    return false;
  }

  private boolean jj_3_30()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3_51()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3_1()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) {
    jj_scanpos = xsp;
    if (jj_3_2()) {
    jj_scanpos = xsp;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_3R_77()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_10()
 {
    if (jj_3R_81()) return true;
    return false;
  }

  private boolean jj_3R_182()
 {
    if (jj_3R_255()) return true;
    return false;
  }

  private boolean jj_3R_151()
 {
    if (jj_3R_241()) return true;
    return false;
  }

  private boolean jj_3R_266()
 {
    if (jj_scan_token(CURRENT_ROLE)) return true;
    return false;
  }

  private boolean jj_3R_150()
 {
    if (jj_scan_token(VARCHAR)) return true;
    return false;
  }

  private boolean jj_3R_251()
 {
    if (jj_scan_token(CAST)) return true;
    return false;
  }

  private boolean jj_3R_88()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_150()) {
    jj_scanpos = xsp;
    if (jj_3R_151()) return true;
    }
    return false;
  }

  private boolean jj_3R_390()
 {
    if (jj_scan_token(TIMESTAMP)) return true;
    return false;
  }

  private boolean jj_3R_260()
 {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_181()
 {
    if (jj_scan_token(LENGTH)) return true;
    return false;
  }

  private boolean jj_3_56()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(84)) jj_scanpos = xsp;
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3_66()
 {
    if (jj_3R_122()) return true;
    return false;
  }

  private boolean jj_3_82()
 {
    if (jj_3R_127()) return true;
    return false;
  }

  private boolean jj_3R_319()
 {
    if (jj_scan_token(SESSION_USER)) return true;
    return false;
  }

  private boolean jj_3R_180()
 {
    if (jj_scan_token(DECODE)) return true;
    return false;
  }

  private boolean jj_3R_134()
 {
    if (jj_scan_token(REVOKE)) return true;
    return false;
  }

  private boolean jj_3R_229()
 {
    if (jj_3R_269()) return true;
    return false;
  }

  private boolean jj_3R_351()
 {
    if (jj_3R_375()) return true;
    return false;
  }

  private boolean jj_3R_350()
 {
    if (jj_3R_374()) return true;
    return false;
  }

  private boolean jj_3R_179()
 {
    if (jj_scan_token(NVL)) return true;
    return false;
  }

  private boolean jj_3R_349()
 {
    if (jj_3R_373()) return true;
    return false;
  }

  private boolean jj_3R_318()
 {
    if (jj_scan_token(CURRENT_USER)) return true;
    return false;
  }

  private boolean jj_3R_366()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(193)) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) {
    jj_scanpos = xsp;
    if (jj_scan_token(194)) {
    jj_scanpos = xsp;
    if (jj_scan_token(248)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_89()
 {
    return false;
  }

  private boolean jj_3R_128()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_228()) {
    jj_scanpos = xsp;
    if (jj_3R_229()) {
    jj_scanpos = xsp;
    if (jj_3_82()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_228()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_178()
 {
    if (jj_scan_token(VALUE)) return true;
    return false;
  }

  private boolean jj_3R_389()
 {
    if (jj_scan_token(TIME)) return true;
    return false;
  }

  private boolean jj_3R_87()
 {
    return false;
  }

  private boolean jj_3R_347()
 {
    if (jj_3R_372()) return true;
    return false;
  }

  private boolean jj_3R_331()
 {
    if (jj_scan_token(PUT)) return true;
    return false;
  }

  private boolean jj_3R_317()
 {
    if (jj_scan_token(USER)) return true;
    return false;
  }

  private boolean jj_3R_265()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_317()) {
    jj_scanpos = xsp;
    if (jj_3R_318()) {
    jj_scanpos = xsp;
    if (jj_3R_319()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_21()
 {
    if (jj_3R_91()) return true;
    return false;
  }

  private boolean jj_3R_177()
 {
    if (jj_scan_token(COALESCE)) return true;
    return false;
  }

  private boolean jj_3R_69()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == REVOKE &&
                                ((getToken(2).kind == TRIGGER &&
                                  ((getToken(3).kind == COMMA &&
                                        isPrivilegeKeywordExceptTrigger(getToken(4).kind)) ||
                                   getToken(3).kind == ON)) ||
                                 isPrivilegeKeywordExceptTrigger(getToken(2).kind));
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_133()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == REVOKE &&
                                ((getToken(2).kind == TRIGGER &&
                                  ((getToken(3).kind == COMMA &&
                                        !isPrivilegeKeywordExceptTrigger(getToken(4).kind)) ||
                                   getToken(3).kind == FROM)) ||
                                 !isPrivilegeKeywordExceptTrigger(getToken(2).kind));
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_134()) return true;
    }
    return false;
  }

  private boolean jj_3R_133()
 {
    if (jj_scan_token(REVOKE)) return true;
    return false;
  }

  private boolean jj_3R_388()
 {
    if (jj_scan_token(DATE)) return true;
    return false;
  }

  private boolean jj_3R_372()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_388()) {
    jj_scanpos = xsp;
    if (jj_3R_389()) {
    jj_scanpos = xsp;
    if (jj_3R_390()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_201()
 {
    if (jj_scan_token(LEFT_BRACE)) return true;
    return false;
  }

  private boolean jj_3R_142()
 {
    if (jj_scan_token(EXPLAIN)) return true;
    return false;
  }

  private boolean jj_3R_348()
 {
    if (jj_scan_token(BOOLEAN)) return true;
    return false;
  }

  private boolean jj_3R_330()
 {
    if (jj_scan_token(INSERT)) return true;
    return false;
  }

  private boolean jj_3R_272()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_330()) {
    jj_scanpos = xsp;
    if (jj_3R_331()) return true;
    }
    return false;
  }

  private boolean jj_3_50()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3_20()
 {
    jj_lookingAhead = true;
    jj_semLA = getToken(3).kind != LARGE;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_89()) return true;
    if (jj_3R_90()) return true;
    return false;
  }

  private boolean jj_3_42()
 {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_114()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_55()) {
    jj_scanpos = xsp;
    if (jj_3R_201()) return true;
    }
    return false;
  }

  private boolean jj_3_55()
 {
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3R_365()
 {
    if (jj_3R_266()) return true;
    return false;
  }

  private boolean jj_3_19()
 {
    jj_lookingAhead = true;
    jj_semLA = getToken(2).kind != LARGE;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_87()) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_176()
 {
    if (jj_3R_254()) return true;
    return false;
  }

  private boolean jj_3R_364()
 {
    if (jj_3R_265()) return true;
    return false;
  }

  private boolean jj_3R_175()
 {
    if (jj_3R_253()) return true;
    return false;
  }

  private boolean jj_3_81()
 {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_343()
 {
    if (jj_3R_366()) return true;
    return false;
  }

  private boolean jj_3R_363()
 {
    if (jj_3R_384()) return true;
    return false;
  }

  private boolean jj_3R_342()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_363()) {
    jj_scanpos = xsp;
    if (jj_3R_364()) {
    jj_scanpos = xsp;
    if (jj_3R_365()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_54()
 {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_316()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_19()) {
    jj_scanpos = xsp;
    if (jj_3_20()) {
    jj_scanpos = xsp;
    if (jj_3_21()) {
    jj_scanpos = xsp;
    if (jj_3R_347()) {
    jj_scanpos = xsp;
    if (jj_3R_348()) {
    jj_scanpos = xsp;
    if (jj_3R_349()) {
    jj_scanpos = xsp;
    if (jj_3R_350()) {
    jj_scanpos = xsp;
    if (jj_3R_351()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_102()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_174()) {
    jj_scanpos = xsp;
    if (jj_3R_175()) {
    jj_scanpos = xsp;
    if (jj_3R_176()) {
    jj_scanpos = xsp;
    if (jj_3_42()) {
    jj_scanpos = xsp;
    if (jj_3R_177()) {
    jj_scanpos = xsp;
    if (jj_3R_178()) {
    jj_scanpos = xsp;
    if (jj_3R_179()) {
    jj_scanpos = xsp;
    if (jj_3R_180()) {
    jj_scanpos = xsp;
    if (jj_3R_181()) {
    jj_scanpos = xsp;
    if (jj_3R_182()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_174()
 {
    if (jj_scan_token(GET_CURRENT_CONNECTION)) return true;
    return false;
  }

  private boolean jj_3R_141()
 {
    if (jj_scan_token(EXECUTE)) return true;
    return false;
  }

  private boolean jj_3_35()
 {
    if (jj_3R_102()) return true;
    return false;
  }

  private boolean jj_3R_252()
 {
    if (jj_3R_288()) return true;
    return false;
  }

  private boolean jj_3_18()
 {
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3R_379()
 {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3_80()
 {
    if (jj_3R_128()) return true;
    return false;
  }

  private boolean jj_3R_173()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_80()) {
    jj_scanpos = xsp;
    if (jj_3R_252()) return true;
    }
    return false;
  }

  private boolean jj_3R_124()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(108)) jj_scanpos = xsp;
    if (jj_3R_85()) return true;
    return false;
  }

  private boolean jj_3R_378()
 {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_357()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_378()) {
    jj_scanpos = xsp;
    if (jj_3R_379()) return true;
    }
    return false;
  }

  private boolean jj_3R_386()
 {
    if (jj_3R_403()) return true;
    return false;
  }

  private boolean jj_3_29()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_408()
 {
    if (jj_scan_token(MINUTE)) return true;
    return false;
  }

  private boolean jj_3_41()
 {
    if (jj_3R_106()) return true;
    return false;
  }

  private boolean jj_3R_407()
 {
    if (jj_scan_token(HOUR)) return true;
    return false;
  }

  private boolean jj_3R_369()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_29()) {
    jj_scanpos = xsp;
    if (jj_3R_386()) return true;
    }
    return false;
  }

  private boolean jj_3R_271()
 {
    if (jj_3R_329()) return true;
    return false;
  }

  private boolean jj_3R_406()
 {
    if (jj_scan_token(DAY)) return true;
    return false;
  }

  private boolean jj_3_40()
 {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_121()
 {
    if (jj_3R_208()) return true;
    return false;
  }

  private boolean jj_3R_405()
 {
    if (jj_scan_token(MONTH)) return true;
    return false;
  }

  private boolean jj_3R_404()
 {
    if (jj_scan_token(YEAR)) return true;
    return false;
  }

  private boolean jj_3R_387()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_404()) {
    jj_scanpos = xsp;
    if (jj_3R_405()) {
    jj_scanpos = xsp;
    if (jj_3R_406()) {
    jj_scanpos = xsp;
    if (jj_3R_407()) {
    jj_scanpos = xsp;
    if (jj_3R_408()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_125()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(108)) jj_scanpos = xsp;
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_345()
 {
    if (jj_3R_369()) return true;
    return false;
  }

  private boolean jj_3R_264()
 {
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3R_208()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = commonDatatypeName(false);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_263()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind != GENERATED;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_264()) return true;
    }
    return false;
  }

  private boolean jj_3R_263()
 {
    if (jj_3R_316()) return true;
    return false;
  }

  private boolean jj_3R_101()
 {
    if (jj_3R_173()) return true;
    return false;
  }

  private boolean jj_3R_307()
 {
    if (jj_3R_346()) return true;
    return false;
  }

  private boolean jj_3R_306()
 {
    if (jj_scan_token(TIMESTAMP)) return true;
    return false;
  }

  private boolean jj_3_60()
 {
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3R_118()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_60()) jj_scanpos = xsp;
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3_78()
 {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_305()
 {
    if (jj_scan_token(DATE)) return true;
    return false;
  }

  private boolean jj_3_34()
 {
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3_71()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_303()
 {
    if (jj_3R_345()) return true;
    return false;
  }

  private boolean jj_3_59()
 {
    if (jj_3R_118()) return true;
    return false;
  }

  private boolean jj_3R_286()
 {
    if (jj_3R_343()) return true;
    return false;
  }

  private boolean jj_3R_304()
 {
    if (jj_scan_token(TIME)) return true;
    return false;
  }

  private boolean jj_3R_257()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_304()) {
    jj_scanpos = xsp;
    if (jj_3R_305()) {
    jj_scanpos = xsp;
    if (jj_3R_306()) {
    jj_scanpos = xsp;
    if (jj_3R_307()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_276()
 {
    if (jj_3R_337()) return true;
    return false;
  }

  private boolean jj_3R_285()
 {
    if (jj_scan_token(COUNT)) return true;
    return false;
  }

  private boolean jj_3R_249()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_285()) {
    jj_scanpos = xsp;
    if (jj_3R_286()) return true;
    }
    return false;
  }

  private boolean jj_3_76()
 {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_192()
 {
    if (jj_3R_259()) return true;
    return false;
  }

  private boolean jj_3R_85()
 {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_3R_80()) return true;
    return false;
  }

  private boolean jj_3R_108()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_47()) {
    jj_scanpos = xsp;
    if (jj_3R_192()) return true;
    }
    return false;
  }

  private boolean jj_3_47()
 {
    if (jj_3R_93()) return true;
    return false;
  }

  private boolean jj_3_33()
 {
    if (jj_3R_100()) return true;
    return false;
  }

  private boolean jj_3R_146()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = javaClassFollows();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_240()) {
    jj_scanpos = xsp;
    if (jj_3_33()) return true;
    }
    return false;
  }

  private boolean jj_3R_240()
 {
    if (jj_3R_276()) return true;
    return false;
  }

  private boolean jj_3R_256()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(202)) jj_scanpos = xsp;
    if (jj_3R_303()) return true;
    return false;
  }

  private boolean jj_3R_403()
 {
    if (jj_scan_token(EXISTS)) return true;
    return false;
  }

  private boolean jj_3_49()
 {
    if (jj_3R_112()) return true;
    return false;
  }

  private boolean jj_3R_189()
 {
    if (jj_scan_token(CURRENT_TIMESTAMP)) return true;
    return false;
  }

  private boolean jj_3_75()
 {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_287()
 {
    if (jj_3R_102()) return true;
    return false;
  }

  private boolean jj_3R_250()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = // GemStone changes BEGIN
             ( ((lookAhead = getToken(1)).kind == GET_CURRENT_CONNECTION ||
                lookAhead.kind == ABS ||
                lookAhead.kind == ABSVAL ||
                lookAhead.kind == SQRT ||
                lookAhead.kind == MOD ||
                lookAhead.kind == COALESCE ||
                lookAhead.kind == VALUE ||
                lookAhead.kind == NVL ||
                lookAhead.kind == DECODE ||
                lookAhead.kind == IDENTITY_VAL_LOCAL ||
                lookAhead.kind == SUBSTRING ||
                lookAhead.kind == SUBSTR ||
                lookAhead.kind == UPPER ||
                lookAhead.kind == LOWER ||
                lookAhead.kind == UCASE ||
                lookAhead.kind == LCASE ||
                lookAhead.kind == LTRIM ||
                lookAhead.kind == RTRIM ||
                lookAhead.kind == TRIM ||
                lookAhead.kind == DATE ||
                lookAhead.kind == TIME ||
                lookAhead.kind == TIMESTAMP ||
                        lookAhead.kind == DOUBLE ||
                        lookAhead.kind == CHAR ||
                        lookAhead.kind == VARCHAR ||
                        lookAhead.kind == INTEGER ||
                        lookAhead.kind == INT ||
                        lookAhead.kind == SMALLINT ||
                        lookAhead.kind == LONGINT ||
                lookAhead.kind == YEAR ||
                lookAhead.kind == MONTH ||
                lookAhead.kind == DAY ||
                lookAhead.kind == HOUR ||
                lookAhead.kind == MINUTE ||
                lookAhead.kind == SECOND ||
                lookAhead.kind == LENGTH ||
                lookAhead.kind == LOCATE ||
                lookAhead.kind == XMLPARSE ||
                lookAhead.kind == XMLSERIALIZE ||
                lookAhead.kind == XMLEXISTS ||
                lookAhead.kind == XMLQUERY) &&
                /* (original code)
             ( (getToken(1).kind == GET_CURRENT_CONNECTION ||
                getToken(1).kind == ABS ||
                getToken(1).kind == ABSVAL ||
                getToken(1).kind == SQRT ||
                getToken(1).kind == MOD ||
                getToken(1).kind == COALESCE ||
                getToken(1).kind == VALUE ||
                getToken(1).kind == IDENTITY_VAL_LOCAL ||
                getToken(1).kind == SUBSTRING ||
                getToken(1).kind == SUBSTR ||
                getToken(1).kind == UPPER ||
                getToken(1).kind == LOWER ||
                getToken(1).kind == UCASE ||
                getToken(1).kind == LCASE ||
                getToken(1).kind == LTRIM ||
                getToken(1).kind == RTRIM ||
                getToken(1).kind == TRIM ||
                getToken(1).kind == DATE ||
                getToken(1).kind == TIME ||
                getToken(1).kind == TIMESTAMP ||
		getToken(1).kind == DOUBLE ||
		getToken(1).kind == CHAR ||
		getToken(1).kind == VARCHAR ||
		getToken(1).kind == INTEGER ||
		getToken(1).kind == INT || 
		getToken(1).kind == SMALLINT ||
		getToken(1).kind == LONGINT ||
                getToken(1).kind == YEAR ||
                getToken(1).kind == MONTH ||
                getToken(1).kind == DAY ||
                getToken(1).kind == HOUR ||
                getToken(1).kind == MINUTE ||
                getToken(1).kind == SECOND ||
                getToken(1).kind == LENGTH ||
                getToken(1).kind == LOCATE ||
                getToken(1).kind == XMLPARSE ||
                getToken(1).kind == XMLSERIALIZE ||
                getToken(1).kind == XMLEXISTS ||
                getToken(1).kind == XMLQUERY ) &&
                */
// GemStone changes END
              getToken(2).kind == LEFT_PAREN
              );
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_287()) {
    jj_scanpos = xsp;
    if (jj_3_40()) {
    jj_scanpos = xsp;
    if (jj_3_41()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_188()
 {
    if (jj_scan_token(CURRENT)) return true;
    return false;
  }

  private boolean jj_3R_197()
 {
    if (jj_3R_260()) return true;
    return false;
  }

  private boolean jj_3_17()
 {
    if (jj_3R_85()) return true;
    return false;
  }

  private boolean jj_3R_187()
 {
    if (jj_scan_token(CURRENT_TIME)) return true;
    return false;
  }

  private boolean jj_3R_199()
 {
    if (jj_scan_token(NULLS)) return true;
    return false;
  }

  private boolean jj_3R_111()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_32()) {
    jj_scanpos = xsp;
    if (jj_3R_197()) return true;
    }
    return false;
  }

  private boolean jj_3_32()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3_38()
 {
    if (jj_3R_103()) return true;
    return false;
  }

  private boolean jj_3R_172()
 {
    if (jj_3R_251()) return true;
    return false;
  }

  private boolean jj_3R_112()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getToken(2).kind == LAST;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_198()) {
    jj_scanpos = xsp;
    if (jj_3R_199()) return true;
    }
    return false;
  }

  private boolean jj_3R_198()
 {
    if (jj_scan_token(NULLS)) return true;
    return false;
  }

  private boolean jj_3R_186()
 {
    if (jj_scan_token(CURRENT)) return true;
    return false;
  }

  private boolean jj_3R_183()
 {
    if (jj_3R_256()) return true;
    return false;
  }

  private boolean jj_3R_196()
 {
    if (jj_scan_token(RETURNING)) return true;
    return false;
  }

  private boolean jj_3R_185()
 {
    if (jj_scan_token(CURRENT_DATE)) return true;
    return false;
  }

  private boolean jj_3R_110()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getToken(2).kind == SEQUENCE;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_195()) {
    jj_scanpos = xsp;
    if (jj_3R_196()) return true;
    }
    return false;
  }

  private boolean jj_3R_195()
 {
    if (jj_scan_token(RETURNING)) return true;
    return false;
  }

  private boolean jj_3R_105()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = (getToken(1).kind == CURRENT && getToken(2).kind == DATE);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_184()) {
    jj_scanpos = xsp;
    if (jj_3R_185()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = (getToken(1).kind == CURRENT && getToken(2).kind == TIME);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_186()) {
    jj_scanpos = xsp;
    if (jj_3R_187()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = (getToken(1).kind == CURRENT && getToken(2).kind == TIMESTAMP);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_188()) {
    jj_scanpos = xsp;
    if (jj_3R_189()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_184()
 {
    if (jj_scan_token(CURRENT)) return true;
    return false;
  }

  private boolean jj_3_74()
 {
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_284()
 {
    if (jj_scan_token(CASE)) return true;
    return false;
  }

  private boolean jj_3_73()
 {
    if (jj_3R_125()) return true;
    return false;
  }

  private boolean jj_3_77()
 {
    if (jj_3R_121()) return true;
    return false;
  }

  private boolean jj_3R_103()
 {
    if (jj_3R_183()) return true;
    return false;
  }

  private boolean jj_3R_171()
 {
    if (jj_scan_token(LEFT_PAREN)) return true;
    return false;
  }

  private boolean jj_3_39()
 {
    if (jj_3R_104()) return true;
    return false;
  }

  private boolean jj_3R_170()
 {
    if (jj_3R_250()) return true;
    return false;
  }

  private boolean jj_3R_270()
 {
    if (jj_scan_token(DELETE)) return true;
    return false;
  }

  private boolean jj_3R_96()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(84)) jj_scanpos = xsp;
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_169()
 {
    if (jj_3R_249()) return true;
    return false;
  }

  private boolean jj_3R_283()
 {
    if (jj_scan_token(NULLIF)) return true;
    return false;
  }

  private boolean jj_3_72()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_360()
 {
    if (jj_3R_383()) return true;
    return false;
  }

  private boolean jj_3R_282()
 {
    if (jj_3R_342()) return true;
    return false;
  }

  private boolean jj_3R_168()
 {
    if (jj_3R_204()) return true;
    return false;
  }

  private boolean jj_3R_149()
 {
    if (jj_scan_token(ON)) return true;
    return false;
  }

  private boolean jj_3R_194()
 {
    if (jj_scan_token(BY)) return true;
    return false;
  }

  private boolean jj_3_28()
 {
    if (jj_3R_96()) return true;
    return false;
  }

  private boolean jj_3R_281()
 {
    if (jj_3R_341()) return true;
    return false;
  }

  private boolean jj_3R_235()
 {
    if (jj_3R_275()) return true;
    return false;
  }

  private boolean jj_3R_148()
 {
    if (jj_scan_token(ON)) return true;
    return false;
  }

  private boolean jj_3R_248()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_281()) {
    jj_scanpos = xsp;
    if (jj_3R_282()) {
    jj_scanpos = xsp;
    if (jj_3R_283()) {
    jj_scanpos = xsp;
    if (jj_3R_284()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_413()
 {
    if (jj_scan_token(VALUES)) return true;
    return false;
  }

  private boolean jj_3R_147()
 {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_109()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getToken(2).kind == REF;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_193()) {
    jj_scanpos = xsp;
    if (jj_3R_194()) return true;
    }
    return false;
  }

  private boolean jj_3R_193()
 {
    if (jj_scan_token(BY)) return true;
    return false;
  }

  private boolean jj_3R_167()
 {
    if (jj_3R_248()) return true;
    return false;
  }

  private boolean jj_3R_234()
 {
    if (jj_3R_274()) return true;
    return false;
  }

  private boolean jj_3R_383()
 {
    if (jj_3R_173()) return true;
    return false;
  }

  private boolean jj_3R_355()
 {
    if (jj_scan_token(HEX_STRING)) return true;
    return false;
  }

  private boolean jj_3R_233()
 {
    if (jj_3R_273()) return true;
    return false;
  }

  private boolean jj_3R_84()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_147()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == ON && getToken(2).kind == COMMIT;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_148()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == ON && getToken(2).kind == ROLLBACK;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_149()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_166()
 {
    if (jj_scan_token(CURRENT)) return true;
    return false;
  }

  private boolean jj_3R_232()
 {
    if (jj_3R_272()) return true;
    return false;
  }

  private boolean jj_3R_97()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_165()
 {
    if (jj_scan_token(CURRENT)) return true;
    return false;
  }

  private boolean jj_3R_231()
 {
    if (jj_3R_271()) return true;
    return false;
  }

  private boolean jj_3R_86()
 {
    if (jj_3R_81()) return true;
    return false;
  }

  private boolean jj_3R_247()
 {
    if (jj_scan_token(PERIOD)) return true;
    return false;
  }

  private boolean jj_3R_100()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = escapedValueFunctionFollows();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_164()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(2).kind == SCHEMA || getToken(2).kind == SQLID;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_165()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(2).kind == ISOLATION;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_166()) {
    jj_scanpos = xsp;
    if (jj_3R_167()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = newInvocationFollows(1);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_168()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = aggregateFollows();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_169()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = miscBuiltinFollows();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_170()) {
    jj_scanpos = xsp;
    if (jj_3_39()) {
    jj_scanpos = xsp;
    if (jj_3R_171()) {
    jj_scanpos = xsp;
    if (jj_3R_172()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_164()
 {
    if (jj_scan_token(LEFT_BRACE)) return true;
    return false;
  }

  private boolean jj_3R_200()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_139()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_230()) {
    jj_scanpos = xsp;
    if (jj_3R_231()) {
    jj_scanpos = xsp;
    if (jj_3R_232()) {
    jj_scanpos = xsp;
    if (jj_3R_233()) {
    jj_scanpos = xsp;
    if (jj_3R_234()) {
    jj_scanpos = xsp;
    if (jj_3R_235()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_230()
 {
    if (jj_3R_270()) return true;
    return false;
  }

  private boolean jj_3_16()
 {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_354()
 {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3_27()
 {
    if (jj_3R_97()) return true;
    return false;
  }

  private boolean jj_3R_138()
 {
    if (jj_scan_token(DECLARE)) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_3R_78()) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3R_402()
 {
    if (jj_scan_token(LTRIM)) return true;
    return false;
  }

  private boolean jj_3_26()
 {
    if (jj_3R_96()) return true;
    return false;
  }

  private boolean jj_3R_401()
 {
    if (jj_scan_token(RTRIM)) return true;
    return false;
  }

  private boolean jj_3R_385()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_401()) {
    jj_scanpos = xsp;
    if (jj_3R_402()) return true;
    }
    return false;
  }

  private boolean jj_3_46()
 {
    if (jj_3R_109()) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3R_130()
 {
    if (jj_scan_token(SET)) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_78()) return true;
    return false;
  }

  private boolean jj_3R_163()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getToken(3).kind == LEFT_PAREN;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_246()) {
    jj_scanpos = xsp;
    if (jj_3R_247()) return true;
    }
    return false;
  }

  private boolean jj_3R_246()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(584)) {
    jj_scanpos = xsp;
    if (jj_scan_token(566)) return true;
    }
    return false;
  }

  private boolean jj_3R_244()
 {
    if (jj_scan_token(ROW_NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_113()
 {
    if (jj_3R_200()) return true;
    return false;
  }

  private boolean jj_3R_67()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == SET && getToken(2).kind != CURRENT;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_129()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == SET && getToken(2).kind == CURRENT;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_130()) return true;
    }
    return false;
  }

  private boolean jj_3R_129()
 {
    if (jj_scan_token(SET)) return true;
    return false;
  }

  private boolean jj_3_70()
 {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_375()
 {
    if (jj_scan_token(XML)) return true;
    return false;
  }

  private boolean jj_3_15()
 {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_99()
 {
    if (jj_3R_163()) return true;
    return false;
  }

  private boolean jj_3R_237()
 {
    if (jj_scan_token(CURRENT)) return true;
    return false;
  }

  private boolean jj_3R_144()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(234)) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == CURRENT && ( getToken(2).kind == SCHEMA ||  getToken(2).kind == SQLID );
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_237()) return true;
    }
    return false;
  }

  private boolean jj_3_31()
 {
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3R_132()
 {
    if (jj_scan_token(GRANT)) return true;
    return false;
  }

  private boolean jj_3R_83()
 {
    if (jj_3R_146()) return true;
    return false;
  }

  private boolean jj_3R_127()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(282)) {
    jj_scanpos = xsp;
    if (jj_scan_token(283)) {
    jj_scanpos = xsp;
    if (jj_scan_token(284)) {
    jj_scanpos = xsp;
    if (jj_scan_token(386)) {
    jj_scanpos = xsp;
    if (jj_scan_token(285)) {
    jj_scanpos = xsp;
    if (jj_scan_token(387)) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(286)) {
    jj_scanpos = xsp;
    if (jj_scan_token(287)) {
    jj_scanpos = xsp;
    if (jj_scan_token(288)) {
    jj_scanpos = xsp;
    if (jj_scan_token(388)) {
    jj_scanpos = xsp;
    if (jj_scan_token(289)) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) {
    jj_scanpos = xsp;
    if (jj_scan_token(290)) {
    jj_scanpos = xsp;
    if (jj_scan_token(291)) {
    jj_scanpos = xsp;
    if (jj_scan_token(389)) {
    jj_scanpos = xsp;
    if (jj_scan_token(292)) {
    jj_scanpos = xsp;
    if (jj_scan_token(293)) {
    jj_scanpos = xsp;
    if (jj_scan_token(390)) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) {
    jj_scanpos = xsp;
    if (jj_scan_token(391)) {
    jj_scanpos = xsp;
    if (jj_scan_token(365)) {
    jj_scanpos = xsp;
    if (jj_scan_token(367)) {
    jj_scanpos = xsp;
    if (jj_scan_token(125)) {
    jj_scanpos = xsp;
    if (jj_scan_token(294)) {
    jj_scanpos = xsp;
    if (jj_scan_token(295)) {
    jj_scanpos = xsp;
    if (jj_scan_token(296)) {
    jj_scanpos = xsp;
    if (jj_scan_token(395)) {
    jj_scanpos = xsp;
    if (jj_scan_token(298)) {
    jj_scanpos = xsp;
    if (jj_scan_token(368)) {
    jj_scanpos = xsp;
    if (jj_scan_token(393)) {
    jj_scanpos = xsp;
    if (jj_scan_token(394)) {
    jj_scanpos = xsp;
    if (jj_scan_token(396)) {
    jj_scanpos = xsp;
    if (jj_scan_token(397)) {
    jj_scanpos = xsp;
    if (jj_scan_token(398)) {
    jj_scanpos = xsp;
    if (jj_scan_token(399)) {
    jj_scanpos = xsp;
    if (jj_scan_token(400)) {
    jj_scanpos = xsp;
    if (jj_scan_token(299)) {
    jj_scanpos = xsp;
    if (jj_scan_token(300)) {
    jj_scanpos = xsp;
    if (jj_scan_token(301)) {
    jj_scanpos = xsp;
    if (jj_scan_token(302)) {
    jj_scanpos = xsp;
    if (jj_scan_token(401)) {
    jj_scanpos = xsp;
    if (jj_scan_token(303)) {
    jj_scanpos = xsp;
    if (jj_scan_token(305)) {
    jj_scanpos = xsp;
    if (jj_scan_token(402)) {
    jj_scanpos = xsp;
    if (jj_scan_token(307)) {
    jj_scanpos = xsp;
    if (jj_scan_token(308)) {
    jj_scanpos = xsp;
    if (jj_scan_token(403)) {
    jj_scanpos = xsp;
    if (jj_scan_token(309)) {
    jj_scanpos = xsp;
    if (jj_scan_token(310)) {
    jj_scanpos = xsp;
    if (jj_scan_token(404)) {
    jj_scanpos = xsp;
    if (jj_scan_token(405)) {
    jj_scanpos = xsp;
    if (jj_scan_token(311)) {
    jj_scanpos = xsp;
    if (jj_scan_token(312)) {
    jj_scanpos = xsp;
    if (jj_scan_token(313)) {
    jj_scanpos = xsp;
    if (jj_scan_token(372)) {
    jj_scanpos = xsp;
    if (jj_scan_token(406)) {
    jj_scanpos = xsp;
    if (jj_scan_token(407)) {
    jj_scanpos = xsp;
    if (jj_scan_token(314)) {
    jj_scanpos = xsp;
    if (jj_scan_token(408)) {
    jj_scanpos = xsp;
    if (jj_scan_token(315)) {
    jj_scanpos = xsp;
    if (jj_scan_token(316)) {
    jj_scanpos = xsp;
    if (jj_scan_token(196)) {
    jj_scanpos = xsp;
    if (jj_scan_token(317)) {
    jj_scanpos = xsp;
    if (jj_scan_token(318)) {
    jj_scanpos = xsp;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(320)) {
    jj_scanpos = xsp;
    if (jj_scan_token(321)) {
    jj_scanpos = xsp;
    if (jj_scan_token(409)) {
    jj_scanpos = xsp;
    if (jj_scan_token(410)) {
    jj_scanpos = xsp;
    if (jj_scan_token(322)) {
    jj_scanpos = xsp;
    if (jj_scan_token(323)) {
    jj_scanpos = xsp;
    if (jj_scan_token(324)) {
    jj_scanpos = xsp;
    if (jj_scan_token(325)) {
    jj_scanpos = xsp;
    if (jj_scan_token(413)) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == OFFSET &&
            !seeingOffsetClause();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_scan_token(326)) {
    jj_scanpos = xsp;
    if (jj_scan_token(414)) {
    jj_scanpos = xsp;
    if (jj_scan_token(415)) {
    jj_scanpos = xsp;
    if (jj_scan_token(412)) {
    jj_scanpos = xsp;
    if (jj_scan_token(375)) {
    jj_scanpos = xsp;
    if (jj_scan_token(327)) {
    jj_scanpos = xsp;
    if (jj_scan_token(418)) {
    jj_scanpos = xsp;
    if (jj_scan_token(328)) {
    jj_scanpos = xsp;
    if (jj_scan_token(329)) {
    jj_scanpos = xsp;
    if (jj_scan_token(419)) {
    jj_scanpos = xsp;
    if (jj_scan_token(420)) {
    jj_scanpos = xsp;
    if (jj_scan_token(421)) {
    jj_scanpos = xsp;
    if (jj_scan_token(330)) {
    jj_scanpos = xsp;
    if (jj_scan_token(423)) {
    jj_scanpos = xsp;
    if (jj_scan_token(331)) {
    jj_scanpos = xsp;
    if (jj_scan_token(422)) {
    jj_scanpos = xsp;
    if (jj_scan_token(424)) {
    jj_scanpos = xsp;
    if (jj_scan_token(332)) {
    jj_scanpos = xsp;
    if (jj_scan_token(425)) {
    jj_scanpos = xsp;
    if (jj_scan_token(426)) {
    jj_scanpos = xsp;
    if (jj_scan_token(427)) {
    jj_scanpos = xsp;
    if (jj_scan_token(333)) {
    jj_scanpos = xsp;
    if (jj_scan_token(376)) {
    jj_scanpos = xsp;
    if (jj_scan_token(334)) {
    jj_scanpos = xsp;
    if (jj_scan_token(377)) {
    jj_scanpos = xsp;
    if (jj_scan_token(428)) {
    jj_scanpos = xsp;
    if (jj_scan_token(429)) {
    jj_scanpos = xsp;
    if (jj_scan_token(336)) {
    jj_scanpos = xsp;
    if (jj_scan_token(335)) {
    jj_scanpos = xsp;
    if (jj_scan_token(337)) {
    jj_scanpos = xsp;
    if (jj_scan_token(430)) {
    jj_scanpos = xsp;
    if (jj_scan_token(431)) {
    jj_scanpos = xsp;
    if (jj_scan_token(338)) {
    jj_scanpos = xsp;
    if (jj_scan_token(432)) {
    jj_scanpos = xsp;
    if (jj_scan_token(433)) {
    jj_scanpos = xsp;
    if (jj_scan_token(435)) {
    jj_scanpos = xsp;
    if (jj_scan_token(434)) {
    jj_scanpos = xsp;
    if (jj_scan_token(339)) {
    jj_scanpos = xsp;
    if (jj_scan_token(340)) {
    jj_scanpos = xsp;
    if (jj_scan_token(341)) {
    jj_scanpos = xsp;
    if (jj_scan_token(342)) {
    jj_scanpos = xsp;
    if (jj_scan_token(343)) {
    jj_scanpos = xsp;
    if (jj_scan_token(344)) {
    jj_scanpos = xsp;
    if (jj_scan_token(345)) {
    jj_scanpos = xsp;
    if (jj_scan_token(346)) {
    jj_scanpos = xsp;
    if (jj_scan_token(347)) {
    jj_scanpos = xsp;
    if (jj_scan_token(436)) {
    jj_scanpos = xsp;
    if (jj_scan_token(437)) {
    jj_scanpos = xsp;
    if (jj_scan_token(348)) {
    jj_scanpos = xsp;
    if (jj_scan_token(349)) {
    jj_scanpos = xsp;
    if (jj_scan_token(438)) {
    jj_scanpos = xsp;
    if (jj_scan_token(350)) {
    jj_scanpos = xsp;
    if (jj_scan_token(439)) {
    jj_scanpos = xsp;
    if (jj_scan_token(250)) {
    jj_scanpos = xsp;
    if (jj_scan_token(351)) {
    jj_scanpos = xsp;
    if (jj_scan_token(352)) {
    jj_scanpos = xsp;
    if (jj_scan_token(353)) {
    jj_scanpos = xsp;
    if (jj_scan_token(354)) {
    jj_scanpos = xsp;
    if (jj_scan_token(355)) {
    jj_scanpos = xsp;
    if (jj_scan_token(440)) {
    jj_scanpos = xsp;
    if (jj_scan_token(356)) {
    jj_scanpos = xsp;
    if (jj_scan_token(262)) {
    jj_scanpos = xsp;
    if (jj_scan_token(357)) {
    jj_scanpos = xsp;
    if (jj_scan_token(441)) {
    jj_scanpos = xsp;
    if (jj_scan_token(358)) {
    jj_scanpos = xsp;
    if (jj_scan_token(442)) {
    jj_scanpos = xsp;
    if (jj_scan_token(359)) {
    jj_scanpos = xsp;
    if (jj_scan_token(270)) {
    jj_scanpos = xsp;
    if (jj_scan_token(272)) {
    jj_scanpos = xsp;
    if (jj_scan_token(417)) {
    jj_scanpos = xsp;
    if (jj_scan_token(360)) {
    jj_scanpos = xsp;
    if (jj_scan_token(443)) {
    jj_scanpos = xsp;
    if (jj_scan_token(444)) {
    jj_scanpos = xsp;
    if (jj_scan_token(445)) {
    jj_scanpos = xsp;
    if (jj_scan_token(446)) {
    jj_scanpos = xsp;
    if (jj_scan_token(447)) {
    jj_scanpos = xsp;
    if (jj_scan_token(449)) {
    jj_scanpos = xsp;
    if (jj_scan_token(450)) {
    jj_scanpos = xsp;
    if (jj_scan_token(451)) {
    jj_scanpos = xsp;
    if (jj_scan_token(452)) {
    jj_scanpos = xsp;
    if (jj_scan_token(453)) {
    jj_scanpos = xsp;
    if (jj_scan_token(454)) {
    jj_scanpos = xsp;
    if (jj_scan_token(455)) {
    jj_scanpos = xsp;
    if (jj_scan_token(456)) {
    jj_scanpos = xsp;
    if (jj_scan_token(457)) {
    jj_scanpos = xsp;
    if (jj_scan_token(458)) {
    jj_scanpos = xsp;
    if (jj_scan_token(459)) {
    jj_scanpos = xsp;
    if (jj_scan_token(460)) {
    jj_scanpos = xsp;
    if (jj_scan_token(461)) {
    jj_scanpos = xsp;
    if (jj_scan_token(462)) {
    jj_scanpos = xsp;
    if (jj_scan_token(463)) {
    jj_scanpos = xsp;
    if (jj_scan_token(464)) {
    jj_scanpos = xsp;
    if (jj_scan_token(465)) {
    jj_scanpos = xsp;
    if (jj_scan_token(466)) {
    jj_scanpos = xsp;
    if (jj_scan_token(467)) {
    jj_scanpos = xsp;
    if (jj_scan_token(468)) {
    jj_scanpos = xsp;
    if (jj_scan_token(469)) {
    jj_scanpos = xsp;
    if (jj_scan_token(470)) {
    jj_scanpos = xsp;
    if (jj_scan_token(471)) {
    jj_scanpos = xsp;
    if (jj_scan_token(472)) {
    jj_scanpos = xsp;
    if (jj_scan_token(473)) {
    jj_scanpos = xsp;
    if (jj_scan_token(474)) {
    jj_scanpos = xsp;
    if (jj_scan_token(475)) {
    jj_scanpos = xsp;
    if (jj_scan_token(476)) {
    jj_scanpos = xsp;
    if (jj_scan_token(477)) {
    jj_scanpos = xsp;
    if (jj_scan_token(478)) {
    jj_scanpos = xsp;
    if (jj_scan_token(480)) {
    jj_scanpos = xsp;
    if (jj_scan_token(481)) {
    jj_scanpos = xsp;
    if (jj_scan_token(482)) {
    jj_scanpos = xsp;
    if (jj_scan_token(483)) {
    jj_scanpos = xsp;
    if (jj_scan_token(484)) {
    jj_scanpos = xsp;
    if (jj_scan_token(486)) {
    jj_scanpos = xsp;
    if (jj_scan_token(487)) {
    jj_scanpos = xsp;
    if (jj_scan_token(491)) {
    jj_scanpos = xsp;
    if (jj_scan_token(492)) {
    jj_scanpos = xsp;
    if (jj_scan_token(493)) {
    jj_scanpos = xsp;
    if (jj_scan_token(494)) {
    jj_scanpos = xsp;
    if (jj_scan_token(488)) {
    jj_scanpos = xsp;
    if (jj_scan_token(489)) {
    jj_scanpos = xsp;
    if (jj_scan_token(499)) {
    jj_scanpos = xsp;
    if (jj_scan_token(495)) {
    jj_scanpos = xsp;
    if (jj_scan_token(490)) {
    jj_scanpos = xsp;
    if (jj_scan_token(448)) {
    jj_scanpos = xsp;
    if (jj_scan_token(485)) {
    jj_scanpos = xsp;
    if (jj_scan_token(479)) {
    jj_scanpos = xsp;
    if (jj_scan_token(496)) {
    jj_scanpos = xsp;
    if (jj_scan_token(497)) {
    jj_scanpos = xsp;
    if (jj_scan_token(498)) {
    jj_scanpos = xsp;
    if (jj_scan_token(500)) {
    jj_scanpos = xsp;
    if (jj_scan_token(501)) {
    jj_scanpos = xsp;
    if (jj_scan_token(502)) {
    jj_scanpos = xsp;
    if (jj_scan_token(503)) {
    jj_scanpos = xsp;
    if (jj_scan_token(504)) {
    jj_scanpos = xsp;
    if (jj_scan_token(505)) {
    jj_scanpos = xsp;
    if (jj_scan_token(506)) {
    jj_scanpos = xsp;
    if (jj_scan_token(507)) {
    jj_scanpos = xsp;
    if (jj_scan_token(508)) {
    jj_scanpos = xsp;
    if (jj_scan_token(509)) {
    jj_scanpos = xsp;
    if (jj_scan_token(510)) {
    jj_scanpos = xsp;
    if (jj_scan_token(511)) {
    jj_scanpos = xsp;
    if (jj_scan_token(512)) {
    jj_scanpos = xsp;
    if (jj_scan_token(513)) {
    jj_scanpos = xsp;
    if (jj_scan_token(514)) {
    jj_scanpos = xsp;
    if (jj_scan_token(515)) {
    jj_scanpos = xsp;
    if (jj_scan_token(516)) {
    jj_scanpos = xsp;
    if (jj_scan_token(517)) {
    jj_scanpos = xsp;
    if (jj_scan_token(518)) {
    jj_scanpos = xsp;
    if (jj_scan_token(519)) {
    jj_scanpos = xsp;
    if (jj_scan_token(520)) {
    jj_scanpos = xsp;
    if (jj_scan_token(521)) {
    jj_scanpos = xsp;
    if (jj_scan_token(522)) {
    jj_scanpos = xsp;
    if (jj_scan_token(523)) {
    jj_scanpos = xsp;
    if (jj_scan_token(524)) {
    jj_scanpos = xsp;
    if (jj_scan_token(525)) {
    jj_scanpos = xsp;
    if (jj_scan_token(526)) {
    jj_scanpos = xsp;
    if (jj_scan_token(527)) {
    jj_scanpos = xsp;
    if (jj_scan_token(528)) {
    jj_scanpos = xsp;
    if (jj_scan_token(529)) {
    jj_scanpos = xsp;
    if (jj_scan_token(530)) {
    jj_scanpos = xsp;
    if (jj_scan_token(531)) {
    jj_scanpos = xsp;
    if (jj_scan_token(532)) {
    jj_scanpos = xsp;
    if (jj_scan_token(533)) {
    jj_scanpos = xsp;
    if (jj_scan_token(534)) {
    jj_scanpos = xsp;
    if (jj_scan_token(535)) {
    jj_scanpos = xsp;
    if (jj_scan_token(537)) {
    jj_scanpos = xsp;
    if (jj_scan_token(538)) {
    jj_scanpos = xsp;
    if (jj_scan_token(539)) {
    jj_scanpos = xsp;
    if (jj_scan_token(540)) {
    jj_scanpos = xsp;
    if (jj_scan_token(541)) {
    jj_scanpos = xsp;
    if (jj_scan_token(542)) {
    jj_scanpos = xsp;
    if (jj_scan_token(543)) {
    jj_scanpos = xsp;
    if (jj_scan_token(544)) {
    jj_scanpos = xsp;
    if (jj_scan_token(545)) {
    jj_scanpos = xsp;
    if (jj_scan_token(546)) {
    jj_scanpos = xsp;
    if (jj_scan_token(547)) {
    jj_scanpos = xsp;
    if (jj_scan_token(548)) {
    jj_scanpos = xsp;
    if (jj_scan_token(549)) {
    jj_scanpos = xsp;
    if (jj_scan_token(550)) {
    jj_scanpos = xsp;
    if (jj_scan_token(551)) {
    jj_scanpos = xsp;
    if (jj_scan_token(552)) {
    jj_scanpos = xsp;
    if (jj_scan_token(553)) {
    jj_scanpos = xsp;
    if (jj_scan_token(361)) {
    jj_scanpos = xsp;
    if (jj_scan_token(362)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_137()
 {
    if (jj_scan_token(ALTER)) return true;
    return false;
  }

  private boolean jj_3_36()
 {
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  private boolean jj_3_53()
 {
    if (jj_3R_113()) return true;
    return false;
  }

  private boolean jj_3R_79()
 {
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_161()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getToken(2).kind == PERIOD &&
                        (
                                getToken(3).kind == ASTERISK ||
                                (getToken(4).kind == PERIOD && getToken(5).kind == ASTERISK)
                        );
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_243()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == ROW_NUMBER &&
                        getToken(2).kind == LEFT_PAREN &&
                        getToken(3).kind == RIGHT_PAREN;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_244()) {
    jj_scanpos = xsp;
    if (jj_3_27()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_243()
 {
    if (jj_3R_81()) return true;
    return false;
  }

  private boolean jj_3_37()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_68()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == GRANT &&
                                ((getToken(2).kind == TRIGGER &&
                                  ((getToken(3).kind == COMMA &&
                                        isPrivilegeKeywordExceptTrigger(getToken(4).kind)) ||
                                   getToken(3).kind == ON)) ||
                                 isPrivilegeKeywordExceptTrigger(getToken(2).kind));
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_131()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == GRANT &&
                                ((getToken(2).kind == TRIGGER &&
                                  ((getToken(3).kind == COMMA &&
                                        !isPrivilegeKeywordExceptTrigger(getToken(4).kind)) ||
                                   getToken(3).kind == TO)) ||
                                 !isPrivilegeKeywordExceptTrigger(getToken(2).kind));
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_132()) return true;
    }
    return false;
  }

  private boolean jj_3R_131()
 {
    if (jj_scan_token(GRANT)) return true;
    return false;
  }

  private boolean jj_3R_362()
 {
    if (jj_scan_token(MINUS_SIGN)) return true;
    return false;
  }

  private boolean jj_3R_373()
 {
    if (jj_scan_token(LONG)) return true;
    return false;
  }

  private boolean jj_3R_361()
 {
    if (jj_scan_token(PLUS_SIGN)) return true;
    return false;
  }

  private boolean jj_3R_339()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_361()) {
    jj_scanpos = xsp;
    if (jj_3R_362()) return true;
    }
    return false;
  }

  private boolean jj_3R_336()
 {
    if (jj_scan_token(RELEASE)) return true;
    return false;
  }

  private boolean jj_3R_335()
 {
    if (jj_scan_token(ROLLBACK)) return true;
    return false;
  }

  private boolean jj_3R_95()
 {
    if (jj_3R_161()) return true;
    return false;
  }

  private boolean jj_3R_334()
 {
    if (jj_scan_token(SAVEPOINT)) return true;
    return false;
  }

  private boolean jj_3R_158()
 {
    if (jj_scan_token(DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_275()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_334()) {
    jj_scanpos = xsp;
    if (jj_3R_335()) {
    jj_scanpos = xsp;
    if (jj_3R_336()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_93()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getToken(2).kind == PRECISION;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_158()) {
    jj_scanpos = xsp;
    if (jj_scan_token(139)) return true;
    }
    return false;
  }

  private boolean jj_3R_368()
 {
    if (jj_scan_token(TRIM)) return true;
    return false;
  }

  private boolean jj_3_25()
 {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3_23()
 {
    if (jj_3R_93()) return true;
    return false;
  }

  private boolean jj_3R_367()
 {
    if (jj_3R_385()) return true;
    return false;
  }

  private boolean jj_3R_344()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_367()) {
    jj_scanpos = xsp;
    if (jj_3R_368()) return true;
    }
    return false;
  }

  private boolean jj_3_69()
 {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3_44()
 {
    if (jj_3R_109()) return true;
    return false;
  }

  private boolean jj_3R_140()
 {
    if (jj_scan_token(TRUNCATE)) return true;
    return false;
  }

  private boolean jj_3R_157()
 {
    if (jj_scan_token(REAL)) return true;
    return false;
  }

  private boolean jj_3_14()
 {
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_104()
 {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_356()
 {
    if (jj_scan_token(LEFT_BRACE)) return true;
    return false;
  }

  private boolean jj_3R_279()
 {
    if (jj_3R_339()) return true;
    return false;
  }

  private boolean jj_3R_340()
 {
    if (jj_3R_106()) return true;
    return false;
  }

  private boolean jj_3R_280()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getToken(2).kind == PERIOD &&
                getToken(4).kind == LEFT_PAREN;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_340()) {
    jj_scanpos = xsp;
    if (jj_3_14()) return true;
    }
    return false;
  }

  private boolean jj_3_45()
 {
    if (jj_3R_110()) return true;
    return false;
  }

  private boolean jj_3R_245()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_279()) jj_scanpos = xsp;
    if (jj_3R_280()) return true;
    return false;
  }

  private boolean jj_3R_298()
 {
    if (jj_scan_token(LOCATE)) return true;
    return false;
  }

  private boolean jj_3R_160()
 {
    if (jj_scan_token(ALL)) return true;
    return false;
  }

  private boolean jj_3R_297()
 {
    if (jj_3R_344()) return true;
    return false;
  }

  private boolean jj_3R_296()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(441)) {
    jj_scanpos = xsp;
    if (jj_scan_token(403)) return true;
    }
    return false;
  }

  private boolean jj_3R_92()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_156()) {
    jj_scanpos = xsp;
    if (jj_3R_157()) {
    jj_scanpos = xsp;
    if (jj_3_23()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_156()
 {
    if (jj_scan_token(FLOAT)) return true;
    return false;
  }

  private boolean jj_3R_261()
 {
    if (jj_scan_token(LEFT_PAREN)) return true;
    return false;
  }

  private boolean jj_3R_94()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == DISTINCT &&
                        !(
                                getToken(2).kind == PERIOD ||
                                getToken(2).kind == DOUBLE_COLON
                        );
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_159()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == ALL &&
                        !(
                                getToken(2).kind == PERIOD ||
                                getToken(2).kind == DOUBLE_COLON
                        );
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_160()) return true;
    }
    return false;
  }

  private boolean jj_3R_159()
 {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_295()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(267)) {
    jj_scanpos = xsp;
    if (jj_scan_token(191)) return true;
    }
    return false;
  }

  private boolean jj_3_24()
 {
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3R_294()
 {
    if (jj_scan_token(SUBSTR)) return true;
    return false;
  }

  private boolean jj_3R_254()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_294()) {
    jj_scanpos = xsp;
    if (jj_3R_295()) {
    jj_scanpos = xsp;
    if (jj_3R_296()) {
    jj_scanpos = xsp;
    if (jj_3R_297()) {
    jj_scanpos = xsp;
    if (jj_3R_298()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_312()
 {
    if (jj_scan_token(LONGINT)) return true;
    return false;
  }

  private boolean jj_3R_311()
 {
    if (jj_scan_token(SMALLINT)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public SQLParserTokenManager token_source;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[450];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static private int[] jj_la1_6;
  static private int[] jj_la1_7;
  static private int[] jj_la1_8;
  static private int[] jj_la1_9;
  static private int[] jj_la1_10;
  static private int[] jj_la1_11;
  static private int[] jj_la1_12;
  static private int[] jj_la1_13;
  static private int[] jj_la1_14;
  static private int[] jj_la1_15;
  static private int[] jj_la1_16;
  static private int[] jj_la1_17;
  static private int[] jj_la1_18;
  static private int[] jj_la1_19;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
      jj_la1_init_4();
      jj_la1_init_5();
      jj_la1_init_6();
      jj_la1_init_7();
      jj_la1_init_8();
      jj_la1_init_9();
      jj_la1_init_10();
      jj_la1_init_11();
      jj_la1_init_12();
      jj_la1_init_13();
      jj_la1_init_14();
      jj_la1_init_15();
      jj_la1_init_16();
      jj_la1_init_17();
      jj_la1_init_18();
      jj_la1_init_19();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x4000,0x4000,0x4000,0x0,0x0,0x4000,0x4000,0x0,0x0,0x0,0x0,0x100000,0x0,0x20000,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x44000,0x40000,0x0,0x0,0x0,0x80,0x0,0x0,0x100000,0x0,0x80,0x80,0x0,0x100000,0x0,0x80,0x100000,0x0,0x80,0x0,0x0,0x0,0x200000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x1000000,0x0,0x0,0x1000000,0x80,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x80,0x0,0x0,0x0,0x12000,0x0,0x0,0x0,0x0,0x0,0x0,0x12000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x14000,0x0,0x0,0x14000,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x14000,0x0,0xefffe000,0x10000000,0x0,0xefffe000,0xefffe000,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10080,0x10080,0x10080,0x10080,0x0,0x10080,0x10080,0x30,0x0,0x0,0x30,0x0,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30,0x80000000,0x80000000,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000004,0x8,0x0,0x200,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x2000000,0x4000000,0x0,0x200000,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x20000000,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000004,0x0,0x0,0x10000,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x10000,0x0,0x0,0x80,0x0,0x0,0x0,0x10080,0x1000,0x0,0x0,0x0,0x0,0x0,0x1000,0x1,0x1,0x1000,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xdfdffdbf,0x20200200,0x0,0xdfdffdbf,0xdfdffdbf,0x0,};
   }
   private static void jj_la1_init_4() {
      jj_la1_4 = new int[] {0x0,0x20,0x0,0x1022,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x2000000,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x20000000,0x4,0x0,0x0,0x4,0x0,0x4,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x1,0x0,0x0,0x1,0x0,0x0,0x0,0x8000000,0x800,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x400,0x400,0x400,0x400,0x40000,0x0,0x400,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x20000,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x40,0x40,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000000,0x1000000,0x1000000,0x1000000,0x0,0x0,0x1000000,0x1000000,0x1000000,0x1000000,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0xa000,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200020,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x200020,0x0,0xffffbfff,0x0,0x0,0xffffbfff,0xffffbfff,0x0,};
   }
   private static void jj_la1_init_5() {
      jj_la1_5 = new int[] {0x0,0x40000,0x0,0x40000,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0xa,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x180000,0x0,0x0,0x0,0x180000,0x180000,0x180000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x40001000,0x0,0x0,0x40001000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x80000000,0x0,0x0,0x80000000,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x180000,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20008000,0x0,0x20008000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x40000,0x0,0x0,0x40000,0x2,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x40000,0x0,0xffffffff,0x0,0x0,0xffffffff,0xffffffff,0x0,};
   }
   private static void jj_la1_init_6() {
      jj_la1_6 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x0,0x8000,0x0,0x0,0x0,0x8000,0x0,0x400,0x8000000,0x0,0x10000000,0x10000c00,0x10000c00,0x10000c00,0x0,0x10000c00,0x10000c00,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x2000,0x2000,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x400,0x0,0x0,0x400,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x800,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6,0x6,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x80000,0x0,0x0,0x10000000,0x10000000,0x8000,0x0,0x8000,0x8000,0x0,0x200,0x800,0x200,0x0,0x0,0x0,0x10000c00,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffef,0x10,0x0,0xffffffef,0xffffffef,0x0,};
   }
   private static void jj_la1_init_7() {
      jj_la1_7 = new int[] {0x0,0x2000,0x0,0x2100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x8000400,0x8000400,0x8000,0x0,0x0,0x0,0x0,0x8000000,0x0,0x2100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x80000000,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x8,0x8,0x0,0x8,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x10000,0x0,0x10000,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x804000,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x4000,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x1000,0x0,0x0,0x4000,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x200,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x80,0x80,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x8000000,0x8000000,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x4000,0x0,0x0,0x0,0x0,0x0,0x4000000,0x8000000,0x0,0x0,0x0,0x2100,0x0,0x0,0x0,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x400,0x400,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x8020,0x0,0x0,0x0,0x8,0x0,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x20,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2008,0x8000000,0x0,0x2008,0x0,0x0,0x0,0x0,0x0,0x0,0x2008,0x0,0x0,0x1,0x0,0x2008,0x0,0xfbffffff,0x0,0x4000000,0xfbffffff,0xfbffffff,0x0,};
   }
   private static void jj_la1_init_8() {
      jj_la1_8 = new int[] {0x0,0x8400,0x0,0x8400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x80100,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8400,0x200000,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x200000,0x0,0x0,0x0,0x200000,0x0,0x0,0x400000,0x200000,0x0,0x0,0x0,0x0,0x100,0x800000,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x100,0x400100,0x100,0x100,0x400000,0x100,0x400100,0x40000000,0x0,0x40000,0x20000,0x0,0x0,0x0,0x40000,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x8000,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x1000,0x0,0x0,0xc000000,0x0,0x2000000,0x0,0x800,0x0,0x0,0x810,0x10,0x0,0x8,0x0,0x0,0x1020,0x0,0xc000810,0x4000,0x0,0x2000000,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x20,0x1000,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0x20,0x20,0x20,0x0,0x0,0x20,0x20,0x20,0x20,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x400000,0x20000000,0x0,0x0,0x0,0x0,0x1000,0x20,0x0,0x20,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x8400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x1020,0x0,0x0,0x0,0x0,0x100,0x100,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x400,0x0,0x3febfbf,0xfc000000,0x14040,0x3febfbf,0x3febfbf,0x0,};
   }
   private static void jj_la1_init_9() {
      jj_la1_9 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x1000,0x0,0x1000,0x82,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000100,0x0,0x10,0x0,0x0,0x4002000,0x0,0x20000100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4002000,0x200000,0x0,0x20000180,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000180,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8080421,0x400,0x8080421,0x1,0x0,0x0,0x10000,0x10000,0x8080421,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0xfffafdff,0x0,0x10000,0x10000,0x0,};
   }
   private static void jj_la1_init_10() {
      jj_la1_10 = new int[] {0x0,0x0,0x0,0x8400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x40000000,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8400,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x4000,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x2000,0x0,0x2000,0x2000,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20004000,0x0,0x4000,0x4000,0x4000,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40800,0x0,0x40800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f,0xffffff80,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_11() {
      jj_la1_11 = new int[] {0x0,0x1000,0x0,0x1000,0x10,0x40000,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000020,0x1000020,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10100e03,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x600,0x80000,0x0,0x0,0x0,0x80000,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa00c,0xc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc200000,0x4200000,0x0,0x0,0x4200000,0x0,0x4000,0x0,0xc220000,0xe0000000,0x0,0x3,0x0,0xe0000000,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x3,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x400000,0x0,0x0,0x0,0x0,0x0,0x4000,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfc6e5800,0x11a000,0x38007ff,0xfc6e5800,0xfc6e5800,0x0,};
   }
   private static void jj_la1_init_12() {
      jj_la1_12 = new int[] {0x0,0x0,0x200000,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x20000,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x180000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x180000,0x1,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x4,0x0,0x0,0x0,0xc6000000,0x0,0x0,0x0,0x0,0xc6000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x8000,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x880,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000001,0x27fffefc,0xd0000000,0x8000001,0x8000001,0x0,};
   }
   private static void jj_la1_init_13() {
      jj_la1_13 = new int[] {0x0,0x0,0x80,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x11000000,0x11000000,0x11000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x2000000,0x0,0x2000000,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x2100000,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x80000000,0x80000000,0x80000000,0x0,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x40000000,0x40000000,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80212,0x0,0x80212,0x0,0x0,0x0,0x1,0x1,0x80212,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x4003000,0x4003000,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x1000000,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x1000000,0x0,0x1,0x0,0xfffffffe,0x1,0x1,0x0,};
   }
   private static void jj_la1_init_14() {
      jj_la1_14 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000000,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000000,0x84000600,0x4,0x84000600,0x0,0x80000000,0x2,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x10,0x280,0xf000,0x0,0x1f000,0x0,0x0,0x0,0x0,0x800000,0x800000,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x600,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000000,0x1000000,0x1000000,0x1000000,0x1000000,0x1000000,0x0,0x1000000,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_15() {
      jj_la1_15 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x380000,0x380000,0x380000,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x3800000,0x1000000,0x0,0x0,0x2800000,0x3800000,0xfc000000,0x0,0x0,0xfc000000,0x0,0x0,0x0,0x29f308,0x7,0x29f308,0x17108,0x17108,0x0,0x13008,0x13108,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x13008,0x0,0x7,0x0,0x20000,0x20000,0x80,0x0,0x0,0x0,0x0,0x20000,0xe4000000,0x18000000,0xfc000000,0x40000,0x40000,0x0,0x20000,0x20000,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_16() {
      jj_la1_16 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40002,0x40002,0x40002,0x0,0xf0000080,0x0,0xc000000,0xfc000280,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20def8,0x0,0x0,0x0,0x0,0x0,0x20def8,0x20ded0,0x0,0x0,0x0,0x0,0x0,0x20ded0,0x0,0x0,0x0,0x1d80008,0x0,0x0,0x1d80008,0xfc007b80,0xf0001180,0x0,0xc006000,0x0,0xfc007b80,0x1,0x0,0x0,0x1,0x0,0x0,0x0,0x2000002,0x0,0x2000002,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfeffffff,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_17() {
      jj_la1_17 = new int[] {0x4000000,0x14200,0x0,0x14200,0x0,0x0,0x0,0x8000000,0x0,0x120000,0x120000,0x0,0x0,0x0,0x0,0x82,0x5,0x0,0x187,0x0,0x0,0x14200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x10000,0x0,0x10000,0x0,0x0,0x10000,0x10000,0x10000,0x10000,0x10000,0x10000,0x0,0x0,0x0,0x100000,0x10000,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x400000,0x400000,0x0,0x0,0x280000,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x40000,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf8000000,0x4000,0x4000,0x0,0xf8000000,0x280000,0x280000,0x840000,0x840000,0x280000,0x400000,0x400000,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x100000,0x0,0x100000,0x0,0x0,0x100000,0x0,0x0,0x20000,0x0,0x0,0x0,0x284000,0x10000,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x120000,0x0,0x0,0x0,0x100000,0x100000,0x0,0x0,0x0,0x280000,0x0,0x0,0x280000,0x280000,0x0,0x0,0x0,0x100000,0x100000,0x0,0x80000,0x280000,0x0,0x100000,0x0,0x100000,0x0,0x0,0x10000,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x4000,0x0,0x10000,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x10000,0x0,0x10000,0x100000,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x187,0x82,0x5,0x0,0x0,0x187,0x10000,0x100000,0x10000,0x10000,0x284000,0x0,0x0,0x30,0x0,0x30,0x0,0x0,0x0,0x0,0x0,0x10000,0x100000,0x100000,0x100000,0x100000,0x100000,0x100000,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x100000,0x0,0x100000,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x100000,0x0,0x0,0x0,0x284000,0x280000,0x284000,0x280000,0x0,0x0,0x0,0x0,0x0,0x0,0x14200,0x10000,0x100000,0x100000,0x20000000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x284000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x10000,0x100000,0x10000,0x10000,0x10000,0x0,0x100000,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x3ff,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_18() {
      jj_la1_18 = new int[] {0x0,0x4,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x200,0x400,0xa0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x0,0x0,0x0,0x3,0x0,0x0,0x80,0x80,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1920004,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x20004,0x0,0x0,0x20004,0x20004,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x100000,0x100000,0x1920000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1920000,0x0,0x1920000,0x0,0x1020000,0x0,0x0,0x0,0x0,0x0,0x400004,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100004,0x0,0x0,0x0,0x100004,0x1920004,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10400,0x0,0x0,0x0,0x0,0x0,0x10400,};
   }
   private static void jj_la1_init_19() {
      jj_la1_19 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[82];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with user supplied CharStream. */
  public SQLParser(CharStream stream) {
    token_source = new SQLParserTokenManager(stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 450; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(CharStream stream) {
    token_source.ReInit(stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_lookingAhead = false;
    jj_gen = 0;
    for (int i = 0; i < 450; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public SQLParser(SQLParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 450; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(SQLParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 450; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken = token;
    if ((token = jj_nt).next != null) jj_nt = jj_nt.next;
    else jj_nt = jj_nt.next = token_source.getNextToken();
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    jj_nt = token;
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if ((token = jj_nt).next != null) jj_nt = jj_nt.next;
    else jj_nt = jj_nt.next = token_source.getNextToken();
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = jj_lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) {
       return;
    }

    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];

      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }

      for (int[] oldentry : jj_expentries) {
        if (oldentry.length == jj_expentry.length) {
          boolean isMatched = true;

          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              isMatched = false;
              break;
            }

          }
          if (isMatched) {
            jj_expentries.add(jj_expentry);
            break;
          }
        }
      }

      if (pos != 0) {
        jj_lasttokens[(jj_endpos = pos) - 1] = kind;
      }
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[613];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 450; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
          if ((jj_la1_5[i] & (1<<j)) != 0) {
            la1tokens[160+j] = true;
          }
          if ((jj_la1_6[i] & (1<<j)) != 0) {
            la1tokens[192+j] = true;
          }
          if ((jj_la1_7[i] & (1<<j)) != 0) {
            la1tokens[224+j] = true;
          }
          if ((jj_la1_8[i] & (1<<j)) != 0) {
            la1tokens[256+j] = true;
          }
          if ((jj_la1_9[i] & (1<<j)) != 0) {
            la1tokens[288+j] = true;
          }
          if ((jj_la1_10[i] & (1<<j)) != 0) {
            la1tokens[320+j] = true;
          }
          if ((jj_la1_11[i] & (1<<j)) != 0) {
            la1tokens[352+j] = true;
          }
          if ((jj_la1_12[i] & (1<<j)) != 0) {
            la1tokens[384+j] = true;
          }
          if ((jj_la1_13[i] & (1<<j)) != 0) {
            la1tokens[416+j] = true;
          }
          if ((jj_la1_14[i] & (1<<j)) != 0) {
            la1tokens[448+j] = true;
          }
          if ((jj_la1_15[i] & (1<<j)) != 0) {
            la1tokens[480+j] = true;
          }
          if ((jj_la1_16[i] & (1<<j)) != 0) {
            la1tokens[512+j] = true;
          }
          if ((jj_la1_17[i] & (1<<j)) != 0) {
            la1tokens[544+j] = true;
          }
          if ((jj_la1_18[i] & (1<<j)) != 0) {
            la1tokens[576+j] = true;
          }
          if ((jj_la1_19[i] & (1<<j)) != 0) {
            la1tokens[608+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 613; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 82; i++) {
      try {
        JJCalls p = jj_2_rtns[i];

        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
              case 2: jj_3_3(); break;
              case 3: jj_3_4(); break;
              case 4: jj_3_5(); break;
              case 5: jj_3_6(); break;
              case 6: jj_3_7(); break;
              case 7: jj_3_8(); break;
              case 8: jj_3_9(); break;
              case 9: jj_3_10(); break;
              case 10: jj_3_11(); break;
              case 11: jj_3_12(); break;
              case 12: jj_3_13(); break;
              case 13: jj_3_14(); break;
              case 14: jj_3_15(); break;
              case 15: jj_3_16(); break;
              case 16: jj_3_17(); break;
              case 17: jj_3_18(); break;
              case 18: jj_3_19(); break;
              case 19: jj_3_20(); break;
              case 20: jj_3_21(); break;
              case 21: jj_3_22(); break;
              case 22: jj_3_23(); break;
              case 23: jj_3_24(); break;
              case 24: jj_3_25(); break;
              case 25: jj_3_26(); break;
              case 26: jj_3_27(); break;
              case 27: jj_3_28(); break;
              case 28: jj_3_29(); break;
              case 29: jj_3_30(); break;
              case 30: jj_3_31(); break;
              case 31: jj_3_32(); break;
              case 32: jj_3_33(); break;
              case 33: jj_3_34(); break;
              case 34: jj_3_35(); break;
              case 35: jj_3_36(); break;
              case 36: jj_3_37(); break;
              case 37: jj_3_38(); break;
              case 38: jj_3_39(); break;
              case 39: jj_3_40(); break;
              case 40: jj_3_41(); break;
              case 41: jj_3_42(); break;
              case 42: jj_3_43(); break;
              case 43: jj_3_44(); break;
              case 44: jj_3_45(); break;
              case 45: jj_3_46(); break;
              case 46: jj_3_47(); break;
              case 47: jj_3_48(); break;
              case 48: jj_3_49(); break;
              case 49: jj_3_50(); break;
              case 50: jj_3_51(); break;
              case 51: jj_3_52(); break;
              case 52: jj_3_53(); break;
              case 53: jj_3_54(); break;
              case 54: jj_3_55(); break;
              case 55: jj_3_56(); break;
              case 56: jj_3_57(); break;
              case 57: jj_3_58(); break;
              case 58: jj_3_59(); break;
              case 59: jj_3_60(); break;
              case 60: jj_3_61(); break;
              case 61: jj_3_62(); break;
              case 62: jj_3_63(); break;
              case 63: jj_3_64(); break;
              case 64: jj_3_65(); break;
              case 65: jj_3_66(); break;
              case 66: jj_3_67(); break;
              case 67: jj_3_68(); break;
              case 68: jj_3_69(); break;
              case 69: jj_3_70(); break;
              case 70: jj_3_71(); break;
              case 71: jj_3_72(); break;
              case 72: jj_3_73(); break;
              case 73: jj_3_74(); break;
              case 74: jj_3_75(); break;
              case 75: jj_3_76(); break;
              case 76: jj_3_77(); break;
              case 77: jj_3_78(); break;
              case 78: jj_3_79(); break;
              case 79: jj_3_80(); break;
              case 80: jj_3_81(); break;
              case 81: jj_3_82(); break;
            }
          }
          p = p.next;
        } while (p != null);

        } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }

    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

        // GemStone changes END
}
