/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.tools.planexporter;

import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.services.uuid.BasicUUID;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.tools.planexporter.AbstractCreatePlan;
import com.pivotal.gemfirexd.tools.planexporter.AccessDistributedSystem;
import com.pivotal.gemfirexd.tools.planexporter.CreateXML;
import com.pivotal.gemfirexd.tools.planexporter.ExecutionPlanMessage;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CreateResultSet
extends AbstractCreatePlan {
    private final long[] maxMinAvgSum = new long[4];

    public CreateResultSet(AccessDistributedSystem access, boolean isRemote) {
        super(access, isRemote, XPLAINUtil.XMLForms.none, null);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public List<String> getPlan() throws SQLException {
        ArrayList<String> rows = new ArrayList<String>();
        try {
            ExecutionPlanMessage msg = this.sendMessage();
            String queryNodePlanText = null;
            Element maxTimeNodePlanX = null;
            Element minTimeNodePlanX = null;
            for (char[] c : msg.getResults()) {
                if (GemFireXDUtils.TracePlanGeneration) {
                    SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("received plan " + new String(c) + " from " + (msg.getSender() == null ? " local member " : msg.getSender())));
                }
                if (GemFireXDUtils.TracePlanGeneration) {
                    SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)(" processing with " + (c != null ? " successful XML transformation " : " ALERT!!!!, unsucessful XML transformation ")));
                }
                if (c != null && c.length > 5 && c[0] == '<' && c[1] == '?' && c[2] == 'x' && c[3] == 'm' && c[4] == 'l') {
                    Element e = CreateXML.transformToXML(c);
                    long currentPlanTime = this.getTimeTaken(e);
                    if (currentPlanTime > this.getTimeTaken(maxTimeNodePlanX)) {
                        maxTimeNodePlanX = e;
                    }
                    if (minTimeNodePlanX != null && currentPlanTime >= this.getTimeTaken(minTimeNodePlanX)) continue;
                    minTimeNodePlanX = e;
                    continue;
                }
                if (queryNodePlanText != null) continue;
                queryNodePlanText = c != null ? String.valueOf(c) : "NULL";
            }
            rows.add(queryNodePlanText);
            ArrayList<Element> el = new ArrayList<Element>();
            if (maxTimeNodePlanX != null) {
                el.add(maxTimeNodePlanX);
                rows.add("Slowest Member Plan:\n" + String.valueOf(Misc.serializeXMLAsCharArr(el, "vanilla_text.xsl")));
            }
            el.clear();
            if (minTimeNodePlanX != null) {
                el.add(minTimeNodePlanX);
                rows.add("Fastest Member Plan:\n" + String.valueOf(Misc.serializeXMLAsCharArr(el, "vanilla_text.xsl")));
            }
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw Util.javaException(t);
        }
        return rows;
    }

    private long getTimeTaken(Element e) {
        if (e == null) {
            return 0L;
        }
        NodeList nl = e.getChildNodes();
        Timestamp begin = null;
        Timestamp end = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n == null) continue;
            if (n.getNodeName().equalsIgnoreCase("begin_exe_time")) {
                begin = Timestamp.valueOf(n.getTextContent());
                continue;
            }
            if (!n.getNodeName().equalsIgnoreCase("end_exe_time")) continue;
            end = Timestamp.valueOf(n.getTextContent());
        }
        assert (end != null && begin != null);
        return end.getTime() - begin.getTime();
    }

    @Override
    void processPlan(CharArrayWriter out, boolean isLocalPlanExtracted) throws SQLException, IOException {
        if (!this.ds.isRemote() && !this.ds.isDerbyActivation()) {
            this.createBaseInfo(out);
            this.createScatterInfo(out);
            this.createBaseIterationInfo(out);
            this.createOtherIterationInfo(out);
        }
        if (!isLocalPlanExtracted) {
            BasicUUID locallyExecutedId = new BasicUUID(this.ds.getQueryID());
            if (!this.ds.isDerbyActivation()) {
                locallyExecutedId.setLocallyExecuted(1);
            }
            if (GemFireXDUtils.TracePlanGeneration) {
                SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("Now determining locally Executed Plan if any for " + this.ds.getQueryID() + " with local stmtUUID=" + locallyExecutedId.toString()));
            }
            CharArrayWriter tmpXML = new CharArrayWriter();
            new CreateXML(this.ds.getClone(locallyExecutedId.toString()), true, XPLAINUtil.XMLForms.none, null).processPlan(tmpXML, true);
            if (GemFireXDUtils.TracePlanGeneration) {
                SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("CreateResultSet: Got Local Plan as : " + tmpXML.size() + " data " + tmpXML.toString()));
            }
            if (tmpXML.size() > 0) {
                Element e = CreateXML.transformToXML(tmpXML.toCharArray());
                ArrayList<Element> el = new ArrayList<Element>();
                el.add(e);
                out.write(String.valueOf(Misc.serializeXMLAsCharArr(el, "vanilla_text.xsl")));
            }
            tmpXML.close();
        }
    }

    private void createBaseInfo(CharArrayWriter out) throws SQLException, IOException {
        StringBuilder introLine = new StringBuilder();
        String introQuery = "SELECT ORIGIN_MEMBER_ID, BEGIN_EXE_TIME, END_EXE_TIME from SYSSTAT.SYSXPLAIN_STATEMENTS a join SYSSTAT.SYSXPLAIN_STATEMENT_TIMINGS b on a.TIMING_ID = b.TIMING_ID where a.STMT_ID = ? ";
        PreparedStatement ps = this.ds.conn.prepareStatementByPassQueryInfo(-1L, "SELECT ORIGIN_MEMBER_ID, BEGIN_EXE_TIME, END_EXE_TIME from SYSSTAT.SYSXPLAIN_STATEMENTS a join SYSSTAT.SYSXPLAIN_STATEMENT_TIMINGS b on a.TIMING_ID = b.TIMING_ID where a.STMT_ID = ? ", false, false, false, null, 0L, 0);
        ps.setString(1, this.ds.getQueryID());
        ResultSet results = ps.executeQuery();
        if (results.next()) {
            introLine.append("ORIGINATOR ").append(results.getString(1)).append(" BEGIN TIME ").append(results.getTimestamp(2)).append(" END TIME ").append(results.getTimestamp(3)).append("\n");
        }
        assert (!results.next());
        out.write(introLine.toString());
    }

    private boolean createBaseResponseInfo(CharArrayWriter out) throws SQLException, IOException {
        StringBuilder introLine = new StringBuilder();
        String introQuery = "SELECT CURRENT_MEMBER_ID, BEGIN_EXE_TIME, END_EXE_TIME from SYSSTAT.SYSXPLAIN_STATEMENTS a join SYSSTAT.SYSXPLAIN_STATEMENT_TIMINGS b on a.TIMING_ID = b.TIMING_ID where a.STMT_ID = ? ";
        PreparedStatement ps = this.ds.conn.prepareStatementByPassQueryInfo(-1L, "SELECT CURRENT_MEMBER_ID, BEGIN_EXE_TIME, END_EXE_TIME from SYSSTAT.SYSXPLAIN_STATEMENTS a join SYSSTAT.SYSXPLAIN_STATEMENT_TIMINGS b on a.TIMING_ID = b.TIMING_ID where a.STMT_ID = ? ", false, false, false, null, 0L, 0);
        ps.setString(1, this.ds.getQueryID());
        ResultSet results = ps.executeQuery();
        if (results.next()) {
            introLine.append("LOCAL MEMBER ").append(results.getString(1)).append(" BEGIN TIME ").append(results.getTimestamp(2)).append(" END TIME ").append(results.getTimestamp(3));
            assert (!results.next());
            out.write(introLine.toString());
            return true;
        }
        return false;
    }

    private void createScatterInfo(CharArrayWriter out) throws SQLException, IOException {
        StringBuilder scatterLine = new StringBuilder();
        String queryScatter = "SELECT 'DISTRIBUTION to ' || TRIM(CHAR(NO_PRUNED_MEMBERS)) || ' members took ' || TRIM(CHAR(SCATTER_TIME/1000)) || ' microseconds '  from SYSSTAT.SYSXPLAIN_DIST_PROPS  where STMT_RS_ID = ? and DIST_OBJECT_TYPE = 'QUERY-SCATTER' ";
        PreparedStatement ps = this.ds.conn.prepareStatementByPassQueryInfo(-1L, "SELECT 'DISTRIBUTION to ' || TRIM(CHAR(NO_PRUNED_MEMBERS)) || ' members took ' || TRIM(CHAR(SCATTER_TIME/1000)) || ' microseconds '  from SYSSTAT.SYSXPLAIN_DIST_PROPS  where STMT_RS_ID = ? and DIST_OBJECT_TYPE = 'QUERY-SCATTER' ", false, false, false, null, 0L, 0);
        ps.setString(1, this.ds.getQueryID());
        ResultSet results = ps.executeQuery();
        if (results.next()) {
            scatterLine.append(results.getString(1));
        }
        assert (!results.next());
        results.close();
        ps.close();
        this.getCompressedDistDetails("QUERY-SEND", this.maxMinAvgSum);
        scatterLine.append(" ( message sending min/max/avg time ").append(this.maxMinAvgSum[0]).append("/").append(this.maxMinAvgSum[1]).append("/").append(this.maxMinAvgSum[2]).append(" microseconds");
        this.getCompressedDistDetails("RESULT-RECEIVE", this.maxMinAvgSum);
        scatterLine.append(" and receiving min/max/avg time ").append(this.maxMinAvgSum[0]).append("/").append(this.maxMinAvgSum[1]).append("/").append(this.maxMinAvgSum[2]).append(" microseconds ) ").append("\n");
        out.write(scatterLine.toString());
    }

    private void createMsgReceiveAndResultSendInfo(CharArrayWriter out) throws SQLException, IOException {
        StringBuilder gatherLine = new StringBuilder();
        this.getCompressedDistDetails("QUERY-RECEIVE", this.maxMinAvgSum);
        this.getCompressedDistDetails("RESULT-SEND", this.maxMinAvgSum);
        String queryScatter = "SELECT 'DISTRIBUTION to ' || TRIM(CHAR(NO_PRUNED_MEMBERS)) || ' members took ' || TRIM(CHAR(SCATTER_TIME/1000)) || ' microseconds '  from SYSSTAT.SYSXPLAIN_DIST_PROPS  where STMT_RS_ID = ? and DIST_OBJECT_TYPE = 'QUERY-SCATTER' ";
        PreparedStatement ps = this.ds.conn.prepareStatementByPassQueryInfo(-1L, "SELECT 'DISTRIBUTION to ' || TRIM(CHAR(NO_PRUNED_MEMBERS)) || ' members took ' || TRIM(CHAR(SCATTER_TIME/1000)) || ' microseconds '  from SYSSTAT.SYSXPLAIN_DIST_PROPS  where STMT_RS_ID = ? and DIST_OBJECT_TYPE = 'QUERY-SCATTER' ", false, false, false, null, 0L, 0);
        ps.setString(1, this.ds.getQueryID());
        ResultSet results = ps.executeQuery();
        if (results.next()) {
            gatherLine.append(results.getString(1));
        }
        assert (!results.next());
        results.close();
        ps.close();
        out.write(gatherLine.toString());
    }

    private void createBaseIterationInfo(CharArrayWriter out) throws SQLException, IOException {
        StringBuilder resultIterationLine = new StringBuilder();
        this.getCompressedDistDetails("RESULT-HOLDER", this.maxMinAvgSum);
        PreparedStatement ps = this.ds.conn.prepareStatementByPassQueryInfo(-1L, "SELECT b.OP_IDENTIFIER, b.RETURNED_ROWS, a.EXECUTE_TIME  from (SYSSTAT.SYSXPLAIN_RESULTSET_TIMINGS a JOIN SYSSTAT.SYSXPLAIN_RESULTSETS b on a.timing_id = b.timing_id)  where b.STMT_ID = ? and b.OP_IDENTIFIER IN ('SEQUENTIAL-ITERATION','ROUNDROBIN-ITERATION','REGION-GET','REGION-PUT','REGION-GETALL','LOCAL-INDEX-GETALL','REGION-PUTALL')", false, false, false, null, 0L, 0);
        ps.setString(1, this.ds.getQueryID());
        ResultSet results = ps.executeQuery();
        if (results.next()) {
            resultIterationLine.append(results.getString(1)).append(" of ").append(results.getInt(2)).append(" rows took ").append(results.getLong(3) / 1000L).append(" microseconds").append("\n");
        }
        if (results.next()) {
            StringBuilder errStr = new StringBuilder();
            do {
                errStr.append("op_identifier ").append(results.getString(1)).append(" stmt_id ").append(this.ds.getQueryID()).append("\n");
            } while (results.next());
            SanityManager.THROWASSERT((String)("ROWS found \n" + errStr.toString() + "\n current iteration line " + resultIterationLine.toString()));
        }
        out.write(resultIterationLine.toString());
    }

    private void createOtherIterationInfo(CharArrayWriter out) throws SQLException, IOException {
        StringBuilder resultIterationLine = new StringBuilder();
        PreparedStatement ps = this.ds.conn.prepareStatementByPassQueryInfo(-1L, " SELECT b.OP_IDENTIFIER, b.RETURNED_ROWS, a.EXECUTE_TIME, c.NO_INPUT_ROWS  from (SYSSTAT.SYSXPLAIN_RESULTSET_TIMINGS a JOIN SYSSTAT.SYSXPLAIN_RESULTSETS b on a.timing_id = b.timing_id LEFT OUTER JOIN SYSSTAT.SYSXPLAIN_SORT_PROPS c on b.SORT_RS_ID = c.SORT_RS_ID)  where b.STMT_ID = ? and b.OP_IDENTIFIER IN ('ORDERED-ITERATION','GROUPED-ITERATION','OUTER-JOIN-ITERATION','ROW-COUNT-ITERATION' ) order by INSERT_ORDER ", false, false, false, null, 0L, 0);
        ps.setString(1, this.ds.getQueryID());
        ResultSet results = ps.executeQuery();
        while (results.next()) {
            String opIdentifier = results.getString(1);
            resultIterationLine.append(opIdentifier).append(" of ").append(results.getInt(2)).append(" rows with ");
            int numInputRows = results.getInt(4);
            if (numInputRows != 0) {
                resultIterationLine.append(numInputRows).append(" input rows took ");
            }
            resultIterationLine.append(results.getLong(3) / 1000L).append(" microseconds \n");
        }
        assert (!results.next());
        out.write(resultIterationLine.toString());
    }

    private void getCompressedDistDetails(String opDetails, long[] output) throws SQLException {
        String messagingTime = "SER_DESER_TIME + PROCESS_TIME + THROTTLE_TIME";
        String messagingQuery = " MIN(SER_DESER_TIME + PROCESS_TIME + THROTTLE_TIME), MAX(SER_DESER_TIME + PROCESS_TIME + THROTTLE_TIME), AVG(SER_DESER_TIME + PROCESS_TIME + THROTTLE_TIME), SUM ( SER_DESER_TIME + PROCESS_TIME + THROTTLE_TIME) from SYSSTAT.SYSXPLAIN_DIST_PROPS  where STMT_RS_ID = ? and DIST_OBJECT_TYPE = '";
        String sendQuery = "SELECT  MIN(SER_DESER_TIME + PROCESS_TIME + THROTTLE_TIME), MAX(SER_DESER_TIME + PROCESS_TIME + THROTTLE_TIME), AVG(SER_DESER_TIME + PROCESS_TIME + THROTTLE_TIME), SUM ( SER_DESER_TIME + PROCESS_TIME + THROTTLE_TIME) from SYSSTAT.SYSXPLAIN_DIST_PROPS  where STMT_RS_ID = ? and DIST_OBJECT_TYPE = '" + opDetails + "' ";
        PreparedStatement ps = this.ds.conn.prepareStatementByPassQueryInfo(-1L, sendQuery, false, false, false, null, 0L, 0);
        ps.setString(1, this.ds.getQueryID());
        ResultSet results = ps.executeQuery();
        if (results.next()) {
            output[0] = results.getLong(1) / 1000L;
            output[1] = results.getLong(2) / 1000L;
            output[2] = results.getLong(3) / 1000L;
            output[3] = results.getLong(4) / 1000L;
        }
        assert (!results.next());
    }
}

