/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.thrift.server;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gnu.trove.THashSet;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.impl.jdbc.TransactionResourceImpl;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.thrift.GFXDException;
import com.pivotal.gemfirexd.thrift.GFXDExceptionData;
import com.pivotal.gemfirexd.thrift.HostAddress;
import com.pivotal.gemfirexd.thrift.LocatorService;
import com.pivotal.gemfirexd.thrift.ServerType;
import com.pivotal.gemfirexd.thrift.common.ThriftExceptionUtil;
import com.pivotal.gemfirexd.thrift.common.ThriftUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.thrift.ProcessFunction;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;

public class LocatorServiceImpl
implements LocatorService.Iface {
    protected final String hostAddress;
    protected final int hostPort;
    private volatile boolean isActive;
    private final CancelCriterion stopper;

    public LocatorServiceImpl(String address, int port) {
        this.hostAddress = address;
        this.hostPort = port;
        this.isActive = true;
        final GemFireStore store = Misc.getMemStoreBooting();
        this.stopper = new CancelCriterion(){

            public RuntimeException generateCancelledException(Throwable t) {
                RuntimeException ce = store.getAdvisee().getCancelCriterion().generateCancelledException(t);
                if (ce != null) {
                    return ce;
                }
                return new CacheClosedException(MessageService.getCompleteMessage("XJ015.M", null), t);
            }

            public String cancelInProgress() {
                String cancel = store.getAdvisee().getCancelCriterion().cancelInProgress();
                if (cancel != null) {
                    return cancel;
                }
                if (LocatorServiceImpl.this.isActive()) {
                    return null;
                }
                return MessageService.getCompleteMessage("XJ015.M", null);
            }
        };
    }

    public final HostAddress getPreferredServer(Set<ServerType> serverTypes, Set<String> serverGroups, Set<HostAddress> failedServers) throws GFXDException {
        ServerLocation prefServer;
        THashSet intersectGroups;
        int ntypes;
        if (failedServers == null) {
            failedServers = Collections.emptySet();
        }
        if (serverTypes != null && (ntypes = serverTypes.size()) > 0) {
            if (ntypes == 1) {
                intersectGroups = Collections.singleton(serverTypes.iterator().next().getServerGroupName());
            } else {
                THashSet igroups;
                intersectGroups = igroups = new THashSet(ntypes);
                for (ServerType serverType : serverTypes) {
                    intersectGroups.add(serverType.getServerGroupName());
                }
            }
        } else {
            intersectGroups = null;
        }
        if (SanityManager.TraceClientHA) {
            SanityManager.DEBUG_PRINT((String)"TraceClientHA", (String)("getPreferredServer(): getting preferred server for typeGroups=" + intersectGroups + (serverGroups != null ? " serverGroups=" + serverGroups : "")));
        }
        try {
            prefServer = GemFireXDUtils.getPreferredServer(serverGroups, intersectGroups, failedServers, null, true);
        }
        catch (Throwable t) {
            throw this.gfxdException(t);
        }
        HostAddress prefHost = prefServer != null ? ThriftUtils.getHostAddress((String)prefServer.getHostName(), (int)prefServer.getPort()) : HostAddress.NULL_ADDRESS;
        return prefHost;
    }

    public final List<HostAddress> getAllServersWithPreferredServer(Set<ServerType> serverTypes, Set<String> serverGroups, Set<HostAddress> failedServers) throws GFXDException {
        THashSet allTypes;
        HostAddress prefServer = this.getPreferredServer(serverTypes, serverGroups, failedServers);
        ArrayList<HostAddress> prefAndAllServers = new ArrayList<HostAddress>();
        if (prefServer == null) {
            prefServer = HostAddress.NULL_ADDRESS;
        }
        if (serverTypes == null || serverTypes.isEmpty()) {
            allTypes = null;
        } else {
            THashSet types;
            allTypes = types = new THashSet(serverTypes.size() * 2);
            allTypes.addAll(serverTypes);
            for (ServerType serverType : serverTypes) {
                ServerType locatorType;
                if (!serverType.isThriftGFXD() || serverTypes.contains(locatorType = serverType.getCorrespondingLocatorType())) continue;
                allTypes.add(locatorType);
            }
        }
        prefAndAllServers.add(prefServer);
        try {
            GemFireXDUtils.getGfxdAdvisor().getAllThriftServers((Set<ServerType>)allTypes, (Collection<HostAddress>)prefAndAllServers);
        }
        catch (Throwable t) {
            throw this.gfxdException(t);
        }
        if (SanityManager.TraceClientHA) {
            SanityManager.DEBUG_PRINT((String)"TraceClientHA", (String)("getAllServersWithPreferredServer(): returning preferred server and all hosts " + prefAndAllServers));
        }
        return prefAndAllServers;
    }

    public void closeConnection() {
    }

    public final CancelCriterion getCancelCriterion() {
        return this.stopper;
    }

    protected GFXDException gfxdException(Throwable t) {
        SQLException sqle;
        if (t instanceof SQLException) {
            sqle = (SQLException)t;
        } else {
            String nodeFailure;
            if (t instanceof GFXDException) {
                return (GFXDException)t;
            }
            if (t instanceof Error) {
                Error err = (Error)t;
                if (SystemFailure.isJVMFailureError((Error)err)) {
                    SystemFailure.initiateFailure((Error)err);
                    throw err;
                }
                SystemFailure.checkFailure();
            }
            if ((nodeFailure = this.getCancelCriterion().cancelInProgress()) != null) {
                if (!GemFireXDUtils.nodeFailureException(t)) {
                    t = this.getCancelCriterion().generateCancelledException(t);
                }
            } else {
                LocatorServiceImpl.log("Unexpected error in execution", t, null, true);
            }
            sqle = TransactionResourceImpl.wrapInSQLException(t);
        }
        GFXDExceptionData exData = new GFXDExceptionData(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode());
        ArrayList<GFXDExceptionData> nextExceptions = new ArrayList<GFXDExceptionData>(4);
        SQLException next = sqle.getNextException();
        if (next != null) {
            nextExceptions = new ArrayList();
            do {
                nextExceptions.add(new GFXDExceptionData(next.getMessage(), next.getSQLState(), next.getErrorCode()));
            } while ((next = next.getNextException()) != null);
        }
        GFXDException gfxde = new GFXDException(exData, this.getServerInfo());
        StringBuilder stack = t instanceof TException ? new StringBuilder("Cause: ").append(ThriftExceptionUtil.getExceptionString((Throwable)t)).append("; Server STACK: ") : new StringBuilder("Server STACK: ");
        SanityManager.getStackTrace((Throwable)t, (StringBuilder)stack);
        nextExceptions.add(new GFXDExceptionData(stack.toString(), "X0Z35", 20000));
        gfxde.setNextExceptions(nextExceptions);
        return gfxde;
    }

    public GFXDException newGFXDException(String messageId, Object ... args) {
        GFXDExceptionData exData = new GFXDExceptionData();
        exData.setSqlState(StandardException.getSQLStateFromIdentifier(messageId));
        exData.setSeverity(StandardException.getSeverityFromIdentifier(messageId));
        exData.setReason(MessageService.getCompleteMessage(messageId, args));
        return new GFXDException(exData, this.getServerInfo());
    }

    protected String getServerInfo() {
        return "Locator=" + this.hostAddress + '[' + this.hostPort + "] Thread=" + Thread.currentThread().getName();
    }

    static void log(String message, Throwable t, String logLevel, boolean forceLog) {
        if (forceLog | GemFireXDUtils.TraceThriftAPI) {
            logLevel = logLevel != null ? logLevel + ':' + "TraceThriftAPI" : "TraceThriftAPI";
            SanityManager.DEBUG_PRINT((String)logLevel, (String)message, (Throwable)t);
        }
    }

    public final boolean isActive() {
        return this.isActive;
    }

    public void stop() {
        this.isActive = false;
    }

    public static final class Processor
    extends LocatorService.Processor<LocatorServiceImpl> {
        private final LocatorServiceImpl inst;
        private final HashMap<String, ProcessFunction<LocatorServiceImpl, ?>> fnMap;

        public Processor(LocatorServiceImpl inst) {
            super((LocatorService.Iface)inst);
            this.inst = inst;
            this.fnMap = new HashMap(super.getProcessMapView());
        }

        public final boolean process(TProtocol in, TProtocol out) throws TException {
            TMessage msg = in.readMessageBegin();
            ProcessFunction<LocatorServiceImpl, ?> fn = this.fnMap.get(msg.name);
            if (fn != null) {
                fn.process(msg.seqid, in, out, (Object)this.inst);
                return fn.getClass() != LocatorService.Processor.closeConnection.class;
            }
            TProtocolUtil.skip((TProtocol)in, (byte)12);
            in.readMessageEnd();
            TApplicationException x = new TApplicationException(1, "Invalid method name: '" + msg.name + "'");
            out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
            x.write(out);
            out.writeMessageEnd();
            out.getTransport().flush();
            return true;
        }
    }
}

