/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.thrift.server;

import com.gemstone.gemfire.internal.cache.locks.NonReentrantLock;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gnu.trove.TIntArrayList;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.thrift.OpenConnectionArgs;
import com.pivotal.gemfirexd.thrift.SecurityMechanism;
import com.pivotal.gemfirexd.thrift.StatementAttrs;
import com.pivotal.gemfirexd.thrift.common.ThriftExceptionUtil;
import com.pivotal.gemfirexd.thrift.server.GFXDServiceImpl;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

final class ConnectionHolder {
    private final EmbedConnection conn;
    private final int connId;
    private final ByteBuffer token;
    private final String clientHostName;
    private final String clientID;
    private final String userName;
    private final boolean useStringForDecimal;
    private EmbedStatement reusableStatement;
    private final ArrayList<StatementHolder> activeStatements;
    private final NonReentrantLock sync;

    ConnectionHolder(EmbedConnection conn, OpenConnectionArgs args, int connId, SecureRandom rnd) throws SQLException {
        int tokenSize;
        this.conn = conn;
        this.connId = connId;
        if (args.getSecurity() == SecurityMechanism.PLAIN || args.getSecurity() == SecurityMechanism.DIFFIE_HELLMAN) {
            tokenSize = 16;
            if (args.isSetTokenSize()) {
                if (args.getTokenSize() < tokenSize) {
                    throw ThriftExceptionUtil.newSQLException((String)"08004.C.1", null, (Object[])new Object[]{"specified connection token size " + args.getTokenSize() + " smaller than minimum allowed of " + tokenSize});
                }
                tokenSize = args.getTokenSize();
            }
        } else {
            throw ThriftExceptionUtil.newSQLException((String)"08004.C.1", null, (Object[])new Object[]{"unsupported security mechanism " + args.getSecurity()});
        }
        byte[] rndBytes = new byte[tokenSize];
        rnd.nextBytes(rndBytes);
        this.token = ByteBuffer.wrap(rndBytes);
        this.clientHostName = args.getClientHostName();
        this.clientID = args.getClientID();
        this.userName = args.getUserName();
        this.useStringForDecimal = args.isSetUseStringForDecimal() && args.useStringForDecimal;
        this.reusableStatement = (EmbedStatement)conn.createStatement();
        this.activeStatements = new ArrayList(4);
        this.sync = new NonReentrantLock(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EmbedStatement createNewStatement(StatementAttrs attrs) throws SQLException {
        int resultSetType = GFXDServiceImpl.getResultType(attrs);
        int resultSetConcurrency = GFXDServiceImpl.getResultSetConcurrency(attrs);
        int resultSetHoldability = GFXDServiceImpl.getResultSetHoldability(attrs);
        this.sync.lock();
        try {
            EmbedStatement stmt = this.reusableStatement;
            if (stmt != null) {
                stmt.reset(resultSetType, resultSetConcurrency, resultSetHoldability);
                this.reusableStatement = null;
                EmbedStatement embedStatement = stmt;
                return embedStatement;
            }
        }
        finally {
            this.sync.unlock();
        }
        return (EmbedStatement)this.conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    final EmbedConnection getConnection() {
        return this.conn;
    }

    final int getConnectionId() {
        return this.connId;
    }

    final ByteBuffer getToken() {
        return this.token;
    }

    final String getTokenAsString() {
        return ConnectionHolder.getTokenAsString(this.token);
    }

    static final String getTokenAsString(ByteBuffer connId) {
        if (connId != null) {
            return ClientSharedUtils.toHexString((ByteBuffer)connId);
        }
        return "NULL";
    }

    final String getClientHostName() {
        return this.clientHostName;
    }

    final String getClientID() {
        return this.clientID;
    }

    final String getUserName() {
        return this.userName;
    }

    final boolean useStringForDecimal() {
        return this.useStringForDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStatementForReuse(EmbedStatement stmt) throws SQLException {
        this.sync.lock();
        try {
            this.setStatementForReuseNoLock(stmt);
        }
        finally {
            this.sync.unlock();
        }
    }

    private final void setStatementForReuseNoLock(EmbedStatement stmt) throws SQLException {
        if (this.reusableStatement == null) {
            stmt.resetForReuse();
            this.reusableStatement = stmt;
        } else {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatementHolder registerStatement(Statement stmt, StatementAttrs attrs, int stmtId, String preparedSQL) {
        StatementHolder stmtHolder;
        this.sync.lock();
        try {
            stmtHolder = new StatementHolder(stmt, attrs, stmtId, preparedSQL);
            this.activeStatements.add(stmtHolder);
        }
        finally {
            this.sync.unlock();
        }
        return stmtHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatementHolder registerResultSet(Statement stmt, StatementAttrs attrs, int stmtId, ResultSet rs, int cursorId, String sql) {
        StatementHolder stmtHolder;
        this.sync.lock();
        try {
            stmtHolder = new StatementHolder(stmt, attrs, stmtId, sql);
            stmtHolder.addResultSetNoLock(rs, cursorId);
            this.activeStatements.add(stmtHolder);
        }
        finally {
            this.sync.unlock();
        }
        return stmtHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeStatement(StatementHolder stmtHolder, GFXDServiceImpl service) {
        int stmtId = stmtHolder.getStatementId();
        this.sync.lock();
        try {
            EmbedStatement estmt;
            this.removeActiveStatementNoLock(stmtHolder);
            stmtHolder.closeAllResultSets(service);
            Statement stmt = stmtHolder.getStatement();
            if (stmt instanceof EmbedStatement && !(estmt = (EmbedStatement)stmt).isPrepared()) {
                this.setStatementForReuseNoLock(estmt);
            } else if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.sync.unlock();
            service.statementMap.removePrimitive((long)stmtId);
        }
    }

    private final void removeActiveStatementNoLock(StatementHolder stmtHolder) {
        ArrayList<StatementHolder> statements = this.activeStatements;
        int size = statements.size();
        while (--size >= 0) {
            if (statements.get(size) != stmtHolder) continue;
            statements.remove(size);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(GFXDServiceImpl service) {
        this.sync.lock();
        try {
            for (StatementHolder stmtHolder : this.activeStatements) {
                stmtHolder.closeAllResultSets(service);
                Statement stmt = stmtHolder.getStatement();
                if (stmt == null) continue;
                try {
                    stmt.close();
                }
                catch (SQLException sqle) {
                    GFXDServiceImpl.log("unexpected exception in Statement.close()", sqle, "error", true);
                }
                finally {
                    service.statementMap.removePrimitive((long)stmtHolder.getStatementId());
                }
            }
            if (this.reusableStatement != null) {
                try {
                    this.reusableStatement.close();
                }
                catch (SQLException sqle) {
                    GFXDServiceImpl.log("unexpected exception in Statement.close()", sqle, "error", true);
                }
            }
            try {
                this.conn.close();
            }
            catch (SQLException sqle) {
                this.conn.forceClose();
            }
        }
        finally {
            this.sync.unlock();
        }
    }

    final boolean equals(ByteBuffer otherId) {
        if (this.token == null) {
            return true;
        }
        return ClientSharedUtils.equalBuffers((ByteBuffer)this.token, (ByteBuffer)otherId);
    }

    public final int hashCode() {
        return this.connId;
    }

    final class StatementHolder {
        private final Statement stmt;
        private final StatementAttrs stmtAttrs;
        private final int stmtId;
        private final String sql;
        private int singleCursorId;
        private Object resultSets;
        private TIntArrayList cursorIds;

        private StatementHolder(Statement stmt, StatementAttrs attrs, int stmtId, String sql) {
            this.stmt = stmt;
            this.stmtAttrs = attrs;
            this.stmtId = stmtId;
            this.sql = sql;
            this.singleCursorId = 0;
        }

        final ConnectionHolder getConnectionHolder() {
            return ConnectionHolder.this;
        }

        final Statement getStatement() {
            return this.stmt;
        }

        final int getStatementId() {
            return this.stmtId;
        }

        final String getSQL() {
            return this.sql;
        }

        final StatementAttrs getStatementAttrs() {
            return this.stmtAttrs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addResultSet(ResultSet rs, int cursorId) {
            NonReentrantLock sync = ConnectionHolder.this.sync;
            sync.lock();
            try {
                this.addResultSetNoLock(rs, cursorId);
            }
            finally {
                sync.unlock();
            }
        }

        private void addResultSetNoLock(ResultSet rs, int cursorId) {
            if (this.resultSets == null) {
                this.resultSets = rs;
                this.singleCursorId = cursorId;
            } else if (this.singleCursorId != 0) {
                assert (this.resultSets instanceof ResultSet) : "unexpected resultset " + this.resultSets;
                ArrayList<Object> results = new ArrayList<Object>(4);
                results.add(this.resultSets);
                results.add(rs);
                this.resultSets = results;
                this.cursorIds = new TIntArrayList(4);
                this.cursorIds.add(this.singleCursorId);
                this.cursorIds.add(cursorId);
                this.singleCursorId = 0;
            } else {
                ArrayList results = (ArrayList)this.resultSets;
                results.add(rs);
                this.cursorIds.add(cursorId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ResultSet findResultSet(int cursorId) {
            NonReentrantLock sync = ConnectionHolder.this.sync;
            sync.lock();
            try {
                if (this.singleCursorId == cursorId) {
                    ResultSet resultSet = (ResultSet)this.resultSets;
                    return resultSet;
                }
                TIntArrayList ids = this.cursorIds;
                if (ids != null) {
                    ArrayList results = (ArrayList)this.resultSets;
                    int index = ids.size();
                    while (--index >= 0) {
                        if (ids.getQuick(index) != cursorId) continue;
                        ResultSet resultSet = (ResultSet)results.get(index);
                        return resultSet;
                    }
                }
            }
            finally {
                sync.unlock();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ResultSet removeResultSet(int cursorId) {
            ResultSet rs;
            block9: {
                rs = null;
                NonReentrantLock sync = ConnectionHolder.this.sync;
                sync.lock();
                try {
                    if (this.singleCursorId == cursorId) {
                        rs = (ResultSet)this.resultSets;
                        this.resultSets = null;
                        this.singleCursorId = 0;
                        break block9;
                    }
                    TIntArrayList ids = this.cursorIds;
                    if (ids == null) break block9;
                    ArrayList results = (ArrayList)this.resultSets;
                    int index = ids.size();
                    while (--index >= 0) {
                        if (ids.getQuick(index) != cursorId) continue;
                        rs = (ResultSet)results.get(index);
                        if (ids.size() == 2) {
                            if (index == 1) {
                                this.resultSets = results.get(0);
                                this.singleCursorId = ids.getQuick(0);
                            } else {
                                this.resultSets = results.get(1);
                                this.singleCursorId = ids.getQuick(1);
                            }
                            this.cursorIds = null;
                        } else {
                            results.remove(index);
                            ids.remove(index);
                        }
                        break;
                    }
                }
                finally {
                    sync.unlock();
                }
            }
            return rs;
        }

        void closeResultSet(int cursorId, GFXDServiceImpl service) {
            ResultSet rs = this.removeResultSet(cursorId);
            if (rs != null) {
                service.resultSetMap.removePrimitive((long)cursorId);
                try {
                    rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void closeAllResultSets(GFXDServiceImpl service) {
            if (this.singleCursorId != 0) {
                try {
                    ((ResultSet)this.resultSets).close();
                }
                catch (SQLException sqle) {
                    GFXDServiceImpl.log("unexpected exception in ResultSet.close()", sqle, "error", true);
                }
                finally {
                    service.resultSetMap.removePrimitive((long)this.singleCursorId);
                    this.resultSets = null;
                    this.singleCursorId = 0;
                }
            } else {
                TIntArrayList ids = this.cursorIds;
                if (ids != null) {
                    ArrayList results = (ArrayList)this.resultSets;
                    int size = ids.size();
                    for (int index = 0; index < size; ++index) {
                        try {
                            ((ResultSet)results.get(index)).close();
                            continue;
                        }
                        catch (SQLException sqle) {
                            GFXDServiceImpl.log("unexpected exception in ResultSet.close()", sqle, "error", true);
                            continue;
                        }
                        finally {
                            service.resultSetMap.removePrimitive((long)ids.getQuick(index));
                        }
                    }
                    this.resultSets = null;
                    this.cursorIds = null;
                }
            }
        }
    }
}

