/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.services.locks.Latch;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.PageKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RecordHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RowLock;
import java.util.Hashtable;

public final class RecordId
implements RecordHandle {
    private final PageKey pageId;
    private final int recordId;
    private transient int slotNumberHint;

    public RecordId(ContainerKey container, long pageNumber, int recordId) {
        this.pageId = new PageKey(container, pageNumber);
        this.recordId = recordId;
    }

    public RecordId(PageKey pageId, int recordId) {
        this.pageId = pageId;
        this.recordId = recordId;
    }

    public RecordId(PageKey pageId, int recordId, int current_slot) {
        this.pageId = pageId;
        this.recordId = recordId;
        this.slotNumberHint = current_slot;
    }

    @Override
    public int getId() {
        return this.recordId;
    }

    @Override
    public long getPageNumber() {
        return this.pageId.getPageNumber();
    }

    @Override
    public Object getPageId() {
        return this.pageId;
    }

    @Override
    public ContainerKey getContainerId() {
        return this.pageId.getContainerId();
    }

    @Override
    public int getSlotNumberHint() {
        return this.slotNumberHint;
    }

    @Override
    public void lockEvent(Latch lockInfo) {
    }

    @Override
    public boolean requestCompatible(Object requestedQualifier, Object grantedQualifier) {
        SanityManager.ASSERT((requestedQualifier == RowLock.RS2 || requestedQualifier == RowLock.RS3 || requestedQualifier == RowLock.RU2 || requestedQualifier == RowLock.RU3 || requestedQualifier == RowLock.RIP || requestedQualifier == RowLock.RI || requestedQualifier == RowLock.RX2 || requestedQualifier == RowLock.RX3 ? 1 : 0) != 0);
        SanityManager.ASSERT((grantedQualifier == RowLock.RS2 || grantedQualifier == RowLock.RS3 || grantedQualifier == RowLock.RU2 || grantedQualifier == RowLock.RU3 || grantedQualifier == RowLock.RIP || grantedQualifier == RowLock.RI || grantedQualifier == RowLock.RX2 || grantedQualifier == RowLock.RX3 ? 1 : 0) != 0);
        RowLock rlRequested = (RowLock)requestedQualifier;
        RowLock rlGranted = (RowLock)grantedQualifier;
        return rlRequested.isCompatible(rlGranted);
    }

    @Override
    public boolean lockerAlwaysCompatible() {
        return true;
    }

    @Override
    public void unlockEvent(Latch lockInfo) {
    }

    public boolean equals(Object ref) {
        if (!(ref instanceof RecordId)) {
            return false;
        }
        RecordId other = (RecordId)ref;
        return this.recordId == other.recordId && this.pageId.equals(other.pageId);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this.pageId.hashCode();
        hash = 89 * hash + this.recordId;
        return hash;
    }

    public String toString() {
        return "Record id=" + this.recordId + " " + this.pageId.toString();
    }

    @Override
    public boolean lockAttributes(int flag, Hashtable attributes) {
        SanityManager.ASSERT((attributes != null ? 1 : 0) != 0, (String)"cannot call lockProperties with null attribute list");
        SanityManager.ASSERT((this.pageId != null ? 1 : 0) != 0, (String)"RecordId PageId is null");
        if ((flag & 2) == 0) {
            return false;
        }
        attributes.put("CONTAINERID", new Long(this.pageId.getContainerId().getContainerId()));
        attributes.put("LOCKNAME", "(" + this.pageId.getPageNumber() + "," + this.recordId + ")");
        attributes.put("TYPE", "ROW");
        return true;
    }
}

