/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.btree.index;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.ColumnOrdering;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.Conglomerate;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.ConglomerateFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.ControlRow;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.index.B2I;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.index.B2I_10_3;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.index.B2I_v10_2;
import java.util.Properties;

public class B2IFactory
implements ConglomerateFactory,
ModuleControl {
    private static final String IMPLEMENTATIONID = "BTREE";
    private static final String FORMATUUIDSTRING = "C6CEEEF0-DAD3-11d0-BB01-0060973F0942";
    private UUID formatUUID;

    @Override
    public Properties defaultProperties() {
        return new Properties();
    }

    @Override
    public boolean supportsImplementation(String implementationId) {
        return implementationId.equals(IMPLEMENTATIONID);
    }

    @Override
    public String primaryImplementationType() {
        return IMPLEMENTATIONID;
    }

    @Override
    public boolean supportsFormat(UUID formatid) {
        return formatid.equals(this.formatUUID);
    }

    @Override
    public UUID primaryFormat() {
        return this.formatUUID;
    }

    @Override
    public int getConglomerateFactoryId() {
        return 1;
    }

    @Override
    public Conglomerate createConglomerate(TransactionManager xact_mgr, int segment, long input_containerid, DataValueDescriptor[] template, ColumnOrdering[] columnOrder, int[] collationIds, Properties properties, int temporaryFlag) throws StandardException {
        B2I btree = null;
        btree = xact_mgr.checkVersion(10, 4, null) ? new B2I() : (xact_mgr.checkVersion(10, 3, null) ? new B2I_10_3() : new B2I_v10_2());
        btree.create(xact_mgr, segment, input_containerid, template, columnOrder, collationIds, properties, temporaryFlag);
        return btree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Conglomerate readConglomerate(TransactionManager xact_manager, ContainerKey container_key) throws StandardException {
        B2I btree = null;
        ContainerHandle container = null;
        ControlRow root = null;
        try {
            container = xact_manager.getRawStoreXact().openContainer(container_key, null, 8);
            if (container == null) {
                throw StandardException.newException("XSAI2.S", new Long(container_key.getContainerId()));
            }
            root = ControlRow.get(container, 1L);
            SanityManager.ASSERT((boolean)root.getPage().isLatched());
            btree = (B2I)root.getConglom(470);
            SanityManager.ASSERT((boolean)(btree instanceof B2I));
        }
        finally {
            if (root != null) {
                root.release();
            }
            if (container != null) {
                container.close();
            }
        }
        return btree;
    }

    @Override
    public boolean canSupport(String identifier, Properties startParams) {
        String impl = startParams.getProperty("gemfirexd.access.Conglomerate.type");
        if (impl == null) {
            return false;
        }
        return this.supportsImplementation(impl);
    }

    @Override
    public void boot(boolean create, Properties startParams) throws StandardException {
        UUIDFactory uuidFactory = Monitor.getMonitor().getUUIDFactory();
        this.formatUUID = uuidFactory.recreateUUID(FORMATUUIDSTRING);
    }

    @Override
    public void stop() {
    }
}

