/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.internal.cache.TXState;
import com.gemstone.gnu.trove.TIntHashSet;
import com.gemstone.gnu.trove.TIntIntHashMap;
import com.gemstone.gnu.trove.TIntObjectHashMap;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.engine.distributed.ReferencedKeyCheckerMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.RegionExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OHAddressCache;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapResourceHolder;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.io.StreamStorable;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultDescription;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.RowChanger;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.util.ReuseFactory;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DMLWriteResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.FKInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.RISetChecker;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.RowUtil;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TableScanResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TemporaryRowHolderImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TriggerEventActivator;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TriggerEvents;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TriggerInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.UpdateConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ValueRow;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public final class UpdateResultSet
extends DMLWriteResultSet
implements OffHeapResourceHolder {
    private TransactionController tc;
    private ExecRow newBaseRow;
    private ExecRow row;
    private ExecRow deferredSparseRow;
    UpdateConstantAction constants;
    private NoPutResultSet source;
    NoPutResultSet savedSource;
    private RowChanger rowChanger;
    protected ConglomerateController deferredBaseCC;
    protected long[] deferredUniqueCIDs;
    protected boolean[] deferredUniqueCreated;
    protected ConglomerateController[] deferredUniqueCC;
    protected ScanController[] deferredUniqueScans;
    private TemporaryRowHolderImpl deletedRowHolder;
    private TemporaryRowHolderImpl insertedRowHolder;
    private RISetChecker riChecker;
    private TriggerInfo triggerInfo;
    private TriggerEventActivator triggerActivator;
    private boolean updatingReferencedKey;
    private boolean updatingForeignKey;
    private int numOpens;
    private long heapConglom;
    private FKInfo[] fkInfoArray;
    private FormatableBitSet baseRowReadList;
    private GeneratedMethod checkGM;
    private int resultWidth;
    private int numberOfBaseColumns;
    private ExecRow deferredTempRow;
    private ExecRow deferredBaseRow;
    private ExecRow oldDeletedRow;
    int lockMode;
    boolean deferred;
    boolean beforeUpdateCopyRequired = false;
    private final GemFireContainer container;
    private final ArrayList<DataValueDescriptor[]> referencedKeyCheckRows;
    private OHAddressCache deferredRowsOHCache = null;
    private final int[] refColsImpacted;
    private final FormatableBitSet refColsUpdtdBits;
    private final TIntIntHashMap refCol2IndexMap;
    private final TIntObjectHashMap refColUpdtd2DependentCols;
    protected final GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();

    UpdateResultSet(NoPutResultSet source, GeneratedMethod checkGM, Activation activation) throws StandardException {
        this(source, checkGM, activation, activation.getConstantAction(), null);
    }

    UpdateResultSet(NoPutResultSet source, GeneratedMethod checkGM, Activation activation, int constantActionItem, int rsdItem) throws StandardException {
        this(source, checkGM, activation, (ConstantAction)activation.getSavedObject(constantActionItem), (ResultDescription)activation.getSavedObject(rsdItem));
        this.deferred = true;
        if (this.container.isOffHeap() && this.deferredRowsOHCache == null) {
            this.deferredRowsOHCache = new TableScanResultSet.SingleOHAddressCache();
        }
    }

    UpdateResultSet(NoPutResultSet source, GeneratedMethod checkGM, Activation activation, ConstantAction passedInConstantAction, ResultDescription passedInRsd) throws StandardException {
        super(activation, passedInConstantAction);
        this.tc = activation.getTransactionController();
        this.source = source;
        this.checkGM = checkGM;
        this.constants = (UpdateConstantAction)this.constantAction;
        this.fkInfoArray = this.constants.getFKInfo();
        this.triggerInfo = this.constants.getTriggerInfo();
        this.heapConglom = this.constants.conglomId;
        this.baseRowReadList = this.constants.getBaseRowReadList();
        ResultDescription resultDescription = passedInRsd == null ? activation.getResultDescription() : passedInRsd;
        if (resultDescription == null) {
            SanityManager.ASSERT((this.triggerInfo == null ? 1 : 0) != 0, (String)"triggers need a result description to pass to result sets given to users");
        }
        if (this.fkInfoArray != null) {
            for (int i = 0; i < this.fkInfoArray.length; ++i) {
                if (this.fkInfoArray[i].type == 2) {
                    SanityManager.ASSERT((boolean)this.constants.deferred, (String)"updating referenced key but update not deferred, wuzzup?");
                    continue;
                }
                this.updatingForeignKey = true;
            }
        }
        this.resultWidth = resultDescription.getColumnCount();
        this.numberOfBaseColumns = (this.resultWidth - 1) / 2;
        this.newBaseRow = RowUtil.getEmptyValueRow(this.numberOfBaseColumns, this.lcc);
        this.deferred = this.constants.deferred;
        if (this.triggerInfo != null || this.fkInfoArray != null) {
            this.beforeUpdateCopyRequired = true;
        }
        this.container = ((MemConglomerate)this.constants.heapSCOCI.getConglom()).getGemFireContainer();
        if (!this.container.isTemporaryContainer()) {
            TIntObjectHashMap tempRefColUpdtd2DependentCols = new TIntObjectHashMap();
            Map<Integer, Boolean> refColsImpactedMap = this.getReferencedUpdateCols(tempRefColUpdtd2DependentCols);
            if (refColsImpactedMap != null) {
                this.refColUpdtd2DependentCols = tempRefColUpdtd2DependentCols;
                this.refColsImpacted = new int[refColsImpactedMap.size()];
                this.refColsUpdtdBits = new FormatableBitSet(this.refColsImpacted.length);
                this.refCol2IndexMap = new TIntIntHashMap();
                int j = 0;
                for (Map.Entry<Integer, Boolean> entry : refColsImpactedMap.entrySet()) {
                    int colNum;
                    this.refColsImpacted[j] = colNum = entry.getKey().intValue();
                    if (entry.getValue().booleanValue()) {
                        this.refColsUpdtdBits.set(j);
                    }
                    this.refCol2IndexMap.put(colNum, j);
                    ++j;
                }
            } else {
                this.refColsImpacted = null;
                this.refColsUpdtdBits = null;
                this.refCol2IndexMap = null;
                this.refColUpdtd2DependentCols = null;
            }
        } else {
            this.refColsImpacted = null;
            this.refColsUpdtdBits = null;
            this.refColUpdtd2DependentCols = null;
            this.refCol2IndexMap = null;
        }
        if (this.refColsImpacted != null) {
            this.referencedKeyCheckRows = new ArrayList();
            this.deferred = true;
        } else {
            this.referencedKeyCheckRows = null;
        }
        if (this.deferred && this.container.isOffHeap()) {
            this.deferredRowsOHCache = new TableScanResultSet.SingleOHAddressCache();
        }
    }

    private Map<Integer, Boolean> getReferencedUpdateCols(TIntObjectHashMap tempRefColUpdtd2DependentCols) {
        int[] refKeyCols = this.container.getExtraTableInfo().getReferencedKeyColumns();
        if (refKeyCols != null) {
            TreeMap<Integer, Boolean> referencedImpactedColsMap = new TreeMap<Integer, Boolean>();
            for (int i = 0; i < this.constants.changedColumnIds.length; ++i) {
                int modColID = this.constants.changedColumnIds[i];
                for (int refKeyColID : refKeyCols) {
                    if (refKeyColID != modColID) continue;
                    TIntHashSet dependentCols = new TIntHashSet(refKeyCols.length);
                    tempRefColUpdtd2DependentCols.put(refKeyColID, (Object)dependentCols);
                    referencedImpactedColsMap.put(refKeyColID, Boolean.TRUE);
                    this.addCompanionRefColsToMap(refKeyColID, referencedImpactedColsMap, dependentCols);
                }
            }
            return referencedImpactedColsMap;
        }
        return null;
    }

    private void addCompanionRefColsToMap(int refColID, Map<Integer, Boolean> referencedImpactedColsMap, TIntHashSet dependentCols) {
        Set<int[]> refColsSet = this.container.getExtraTableInfo().getReferencedKeyColumns2IndexNumbers().keySet();
        block0: for (int[] cols : refColsSet) {
            for (int col : cols) {
                if (col != refColID) continue;
                for (int colx : cols) {
                    if (colx == refColID) continue;
                    if (!referencedImpactedColsMap.containsKey(colx)) {
                        referencedImpactedColsMap.put(colx, Boolean.FALSE);
                    }
                    dependentCols.add(colx);
                }
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws StandardException {
        if (this.deferredRowsOHCache != null) {
            this.registerWithGemFireTransaction(this);
        }
        try {
            this.setup();
            if (this.observer != null) {
                this.observer.onUpdateResultSetOpen(this);
            }
            this.collectAffectedRows();
            if (!this.lcc.isSkipListeners() && this.container.getRegion().isSerialWanEnabled()) {
                this.distributeBulkOpToDBSynchronizer();
            }
            if (this.deferred) {
                this.runChecker(true);
                boolean doUpdates = true;
                if (this.referencedKeyCheckRows != null) {
                    RegionExecutorMessage msg;
                    int numRefKeys = this.referencedKeyCheckRows.size();
                    if (numRefKeys > 0) {
                        ReferencedKeyCheckerMessage.referencedKeyCheck(this.container, this.lcc, this.referencedKeyCheckRows, null, false, true, this.refColsImpacted, this.refColsUpdtdBits, this.refColUpdtd2DependentCols, this.refCol2IndexMap, this.constants.getBaseRowReadMap());
                    }
                    this.checkCancellationFlag();
                    GemFireTransaction tran = (GemFireTransaction)this.tc;
                    if (tran.getActiveTXState() == null && (msg = (RegionExecutorMessage)this.activation.getFunctionContext()) != null && msg.getNumRecipients() > 1) {
                        DM dm = Misc.getDistributedSystem().getDM();
                        ReferencedKeyCheckerMessage.ReferencedKeyReplyProcessor processor = new ReferencedKeyCheckerMessage.ReferencedKeyReplyProcessor(dm, msg.getSender());
                        msg.getResultSender().sendResult((Object)processor.getProcessorId());
                        doUpdates = processor.waitForResult();
                    }
                }
                if (doUpdates) {
                    this.updateDeferredRows();
                    this.rowChanger.finish();
                    this.runChecker(false);
                }
            } else {
                this.rowChanger.finish();
            }
            if (this.observer != null) {
                this.observer.onUpdateResultSetDoneUpdate(this);
            }
        }
        finally {
            this.cleanUp(false);
        }
    }

    @Override
    protected void setup() throws StandardException {
        super.setup();
        this.lockMode = this.decodeLockMode(this.constants.lockMode);
        boolean firstOpen = this.rowChanger == null;
        this.rowCount = 0;
        if (this.lcc.getRunTimeStatisticsMode()) {
            this.savedSource = this.source;
        }
        if (firstOpen) {
            this.rowChanger = this.lcc.getLanguageConnectionFactory().getExecutionFactory().getRowChanger(this.heapConglom, this.constants.heapSCOCI, this.heapDCOCI, ReuseFactory.getZeroLenIRGArray(), ReuseFactory.getZeroLenLongArray(), this.constants.indexSCOCIs, this.indexDCOCIs, this.constants.numColumns, this.tc, this.constants.changedColumnIds, this.constants.getBaseRowReadList(), this.constants.getBaseRowReadMap(), this.constants.getStreamStorableHeapColIds(), this.activation);
            this.rowChanger.setIndexNames(this.constants.indexNames);
        } else {
            this.lcc.getStatementContext().setTopResultSet(this, this.subqueryTrackingArray);
        }
        this.rowChanger.open(this.lockMode);
        if (this.numOpens++ == 0) {
            this.source.openCore();
        } else {
            this.source.reopenCore();
        }
        if (this.deferred) {
            this.activation.clearIndexScanInfo();
        }
        if (this.fkInfoArray != null) {
            if (this.riChecker == null) {
                this.riChecker = new RISetChecker(this.tc, this.fkInfoArray);
            } else {
                this.riChecker.reopen();
            }
        }
        if (this.deferred) {
            if (this.deferredTempRow == null) {
                this.deferredTempRow = RowUtil.getEmptyValueRow(this.numberOfBaseColumns + 1, this.lcc);
                this.oldDeletedRow = RowUtil.getEmptyValueRow(this.numberOfBaseColumns, this.lcc);
            }
            Properties properties = new Properties();
            if (this.beforeUpdateCopyRequired) {
                this.deletedRowHolder = new TemporaryRowHolderImpl(this.activation, properties);
            }
            this.insertedRowHolder = new TemporaryRowHolderImpl(this.activation, properties);
            this.rowChanger.setRowHolder(this.insertedRowHolder);
        }
    }

    private FormatableBitSet checkStreamCols() {
        DataValueDescriptor[] cols = this.row.getRowArray();
        FormatableBitSet streamCols = null;
        for (int i = 0; i < this.numberOfBaseColumns; ++i) {
            if (!(cols[i + this.numberOfBaseColumns] instanceof StreamStorable)) continue;
            if (streamCols == null) {
                streamCols = new FormatableBitSet(this.numberOfBaseColumns);
            }
            streamCols.set(i);
        }
        return streamCols;
    }

    private void objectifyStream(ExecRow tempRow, FormatableBitSet streamCols) throws StandardException {
        DataValueDescriptor[] cols = tempRow.getRowArray();
        for (int i = 0; i < this.numberOfBaseColumns; ++i) {
            if (cols[i] == null || !streamCols.get(i)) continue;
            ((StreamStorable)((Object)cols[i])).loadStream();
        }
    }

    public boolean collectAffectedRows() throws StandardException {
        TXState localTXState = this.source.initLocalTXState();
        boolean rowsFound = false;
        this.row = this.getNextRowCore(this.source);
        if (this.row != null) {
            rowsFound = true;
        } else {
            this.activation.addWarning(StandardException.newNoRowFoundWarning());
        }
        TableScanResultSet tableScan = (TableScanResultSet)this.activation.getForUpdateIndexScan();
        boolean notifyCursor = false;
        boolean checkStream = this.deferred && rowsFound && !this.constants.singleRowSource;
        FormatableBitSet streamCols = checkStream ? this.checkStreamCols() : null;
        boolean bl = checkStream = streamCols != null;
        while (this.row != null) {
            RowLocation baseRowLocation = null;
            if (this.deferred) {
                if (this.triggerInfo == null) {
                    UpdateResultSet.evaluateCheckConstraints(this.checkGM, this.activation);
                }
                RowUtil.copyRefColumns(this.deferredTempRow, this.row, this.numberOfBaseColumns, this.numberOfBaseColumns + 1);
                if (checkStream) {
                    this.objectifyStream(this.deferredTempRow, streamCols);
                }
                this.insertedRowHolder.insert(this.deferredTempRow);
                if (this.beforeUpdateCopyRequired) {
                    RowUtil.copyRefColumns(this.oldDeletedRow, this.row, this.numberOfBaseColumns);
                    this.deletedRowHolder.insert(this.oldDeletedRow);
                }
                if (this.deferredBaseRow == null) {
                    this.deferredBaseRow = RowUtil.getEmptyValueRow(this.numberOfBaseColumns, this.lcc);
                    RowUtil.copyCloneColumns(this.deferredBaseRow, this.row, this.numberOfBaseColumns);
                    this.deferredSparseRow = this.makeDeferredSparseRow(this.deferredBaseRow, this.baseRowReadList, this.lcc);
                }
                baseRowLocation = (RowLocation)this.row.getColumn(this.resultWidth).getObject();
                if (this.referencedKeyCheckRows != null) {
                    boolean doRICheck = false;
                    int pos = this.refColsUpdtdBits.anySetBit();
                    while (pos != -1) {
                        int posInExecRow;
                        int[] baseRowReadMap = this.constants.getBaseRowReadMap();
                        int n = posInExecRow = baseRowReadMap != null ? baseRowReadMap[this.refColsImpacted[pos] - 1] : this.refColsImpacted[pos] - 1;
                        if (!this.row.getColumn(posInExecRow + 1).equals(this.row.getColumn((this.resultWidth - 1) / 2 + posInExecRow + 1))) {
                            doRICheck = true;
                            break;
                        }
                        pos = this.refColsUpdtdBits.anySetBit(pos);
                    }
                    if (doRICheck) {
                        this.referencedKeyCheckRows.add(this.row.getRowArrayClone());
                    }
                }
                if (localTXState != null && baseRowLocation != null) {
                    this.source.upgradeReadLockToWrite(baseRowLocation, null);
                }
            } else {
                UpdateResultSet.evaluateCheckConstraints(this.checkGM, this.activation);
                baseRowLocation = (RowLocation)this.row.getColumn(this.resultWidth).getObject();
                RowUtil.copyRefColumns(this.newBaseRow, this.row, this.numberOfBaseColumns, this.numberOfBaseColumns);
                if (this.riChecker != null) {
                    this.riChecker.doFKCheck(this.newBaseRow);
                }
                if (localTXState != null && baseRowLocation != null) {
                    this.source.upgradeReadLockToWrite(baseRowLocation, null);
                }
                this.source.updateRow(this.newBaseRow);
                if (this.rowChanger.updateRow(this.row, this.newBaseRow, baseRowLocation)) {
                    ++this.rowCount;
                }
                if (notifyCursor) {
                    this.notifyForUpdateCursor(this.row.getRowArray(), this.newBaseRow.getRowArray(), baseRowLocation, tableScan);
                }
            }
            this.source.releasePreviousByteSource();
            if (this.constants.singleRowSource) {
                this.row = null;
                continue;
            }
            this.row = this.getNextRowCore(this.source);
        }
        return rowsFound;
    }

    private void notifyForUpdateCursor(DataValueDescriptor[] row, DataValueDescriptor[] newBaseRow, RowLocation rl, TableScanResultSet tableScan) throws StandardException {
        int[] indexCols = tableScan.indexCols;
        int[] changedCols = this.constants.changedColumnIds;
        boolean placedForward = false;
        boolean decided = false;
        boolean overlap = false;
        for (int i = 0; i < indexCols.length; ++i) {
            boolean ascending;
            int basePos = indexCols[i];
            if (basePos > 0) {
                ascending = true;
            } else {
                ascending = false;
                basePos = -basePos;
            }
            for (int j = 0; j < changedCols.length; ++j) {
                if (basePos != changedCols[j]) continue;
                decided = true;
                int[] map = this.constants.getBaseRowReadMap();
                int k = map == null ? basePos - 1 : map[basePos - 1];
                DataValueDescriptor key = tableScan.compareToLastKey() ? tableScan.lastCursorKey.getColumn(i + 1) : row[k];
                if (ascending && key.greaterThan(newBaseRow[k], key).equals(true) || !ascending && key.lessThan(newBaseRow[k], key).equals(true)) {
                    placedForward = true;
                    break;
                }
                if (!key.equals(newBaseRow[k], key).equals(true)) break;
                decided = false;
                overlap = true;
                break;
            }
            if (decided) break;
        }
        if (overlap && !decided) {
            placedForward = true;
        }
        if (placedForward) {
            int maxCapacity = this.lcc.getOptimizerFactory().getMaxMemoryPerTable() / 16;
            if (maxCapacity < 100) {
                maxCapacity = 100;
            }
            if (tableScan.past2FutureTbl == null) {
                double rowCount = tableScan.getEstimatedRowCount();
                int initCapacity = 32768;
                if (rowCount > 0.0 && (rowCount = rowCount / 0.75 + 1.0) < (double)initCapacity) {
                    initCapacity = (int)rowCount;
                }
                if (maxCapacity < initCapacity) {
                    initCapacity = maxCapacity;
                }
                tableScan.past2FutureTbl = new Hashtable(initCapacity);
            }
            Hashtable past2FutureTbl = tableScan.past2FutureTbl;
            RowLocation updatedRL = (RowLocation)rl.getClone();
            if (past2FutureTbl.size() < maxCapacity) {
                past2FutureTbl.put(updatedRL, updatedRL);
            } else {
                block17: {
                    ExecRow aRow;
                    tableScan.setSkipFutureRowHolder(true);
                    ValueRow rlRow = new ValueRow(1);
                    do {
                        if ((aRow = tableScan.getNextRowCore()) == null) {
                            tableScan.setSourceDrained(true);
                            tableScan.past2FutureTbl = null;
                            break block17;
                        }
                        RowLocation rowLoc = (RowLocation)aRow.getLastColumn();
                        if (updatedRL.equals(rowLoc)) {
                            this.saveLastCusorKey(tableScan, aRow);
                            break block17;
                        }
                        if (tableScan.futureForUpdateRows == null) {
                            tableScan.futureForUpdateRows = new TemporaryRowHolderImpl(this.activation, null, 100, false, true);
                        }
                        rlRow.setColumn(1, rowLoc);
                        tableScan.futureForUpdateRows.insert(rlRow);
                    } while (past2FutureTbl.size() >= maxCapacity);
                    past2FutureTbl.put(updatedRL, updatedRL);
                    this.saveLastCusorKey(tableScan, aRow);
                }
                tableScan.setSkipFutureRowHolder(false);
            }
        }
    }

    private void saveLastCusorKey(TableScanResultSet tableScan, ExecRow aRow) throws StandardException {
        if (tableScan.lastCursorKey == null) {
            tableScan.lastCursorKey = new ValueRow(aRow.nColumns() - 1);
        }
        for (int i = 1; i <= tableScan.lastCursorKey.nColumns(); ++i) {
            DataValueDescriptor aCol = aRow.getColumn(i);
            if (aCol == null) continue;
            tableScan.lastCursorKey.setColumn(i, aCol.getClone());
        }
    }

    void fireBeforeTriggers() throws StandardException {
        if (this.activation.getFunctionContext() != null) {
            return;
        }
        if (GemFireXDUtils.TraceActivation) {
            SanityManager.DEBUG_PRINT((String)"TraceActivation", (String)("UpdateResultSet::fireAfterTriggers activation is: " + this.activation + " function context is null"), (Throwable)new Throwable());
        }
        if (this.deferred && this.triggerInfo != null) {
            if (this.triggerActivator == null) {
                this.triggerActivator = new TriggerEventActivator(this.lcc, this.tc, this.constants.targetUUID, this.triggerInfo, 1, this.activation, null);
            } else {
                this.triggerActivator.reopen();
            }
            this.triggerActivator.notifyEvent(TriggerEvents.BEFORE_UPDATE, this.deletedRowHolder.getResultSet(), this.insertedRowHolder.getResultSet());
        }
    }

    void fireAfterTriggers() throws StandardException {
        if (this.activation.getFunctionContext() != null) {
            return;
        }
        if (GemFireXDUtils.TraceActivation) {
            SanityManager.DEBUG_PRINT((String)"TraceActivation", (String)("UpdateResultSet::fireAfterTriggers activation is: " + this.activation + " function context is null"), (Throwable)new Throwable());
        }
        if (this.deferred && this.triggerActivator != null) {
            this.triggerActivator.notifyEvent(TriggerEvents.AFTER_UPDATE, this.deletedRowHolder.getResultSet(), this.insertedRowHolder.getResultSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateDeferredRows() throws StandardException {
        if (this.deferred) {
            if (this.observer != null) {
                this.observer.beforeDeferredUpdate();
            }
            this.deferredBaseCC = this.tc.openCompiledConglomerate(false, 4 | 0x2000, this.lockMode, 5, this.constants.heapSCOCI, this.heapDCOCI);
            CursorResultSet rs = this.insertedRowHolder.getResultSet();
            try {
                ExecRow deferredTempRow2;
                FormatableBitSet readBitSet = RowUtil.shift(this.baseRowReadList, 1);
                rs.open();
                while ((deferredTempRow2 = rs.getNextRow()) != null) {
                    boolean row_exists;
                    if (this.triggerInfo != null) {
                        this.source.setCurrentRow(deferredTempRow2);
                        UpdateResultSet.evaluateCheckConstraints(this.checkGM, this.activation);
                    }
                    DataValueDescriptor rlColumn = deferredTempRow2.getColumn(this.numberOfBaseColumns + 1);
                    RowLocation baseRowLocation = (RowLocation)rlColumn.getObject();
                    baseRowLocation = this.deferredBaseCC.fetch(baseRowLocation, this.deferredSparseRow, readBitSet, false, this.deferredRowsOHCache != null ? this : (GemFireTransaction)this.lcc.getTransactionExecute());
                    boolean bl = row_exists = baseRowLocation != null;
                    if (!row_exists) continue;
                    rlColumn.setValue(baseRowLocation);
                    if (!row_exists) {
                        SanityManager.THROWASSERT((String)("did not find base row in deferred update for base rowlocation" + baseRowLocation));
                    }
                    RowUtil.copyRefColumns(this.newBaseRow, deferredTempRow2, this.numberOfBaseColumns);
                    if (this.rowChanger.updateRow(this.deferredBaseRow, this.newBaseRow, baseRowLocation)) {
                        ++this.rowCount;
                    }
                    this.source.updateRow(this.newBaseRow);
                    if (this.deferredRowsOHCache == null) continue;
                    this.deferredRowsOHCache.releaseByteSource(0);
                }
            }
            finally {
                this.source.clearCurrentRow();
                rs.close(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runChecker(boolean restrictCheckOnly) throws StandardException {
        int i;
        if (this.deferred && this.updatingReferencedKey) {
            for (i = 0; i < this.fkInfoArray.length; ++i) {
                if (this.fkInfoArray[i].type == 1) continue;
                CursorResultSet deletedRows = this.deletedRowHolder.getResultSet();
                try {
                    ExecRow deletedRow;
                    deletedRows.open();
                    while ((deletedRow = deletedRows.getNextRow()) != null) {
                        if (UpdateResultSet.foundRow(deletedRow, this.fkInfoArray[i].colArray, this.insertedRowHolder)) continue;
                        this.riChecker.doRICheck(i, deletedRow, restrictCheckOnly);
                    }
                    continue;
                }
                finally {
                    deletedRows.close(false);
                }
            }
        }
        if (this.deferred && this.updatingForeignKey) {
            for (i = 0; i < this.fkInfoArray.length; ++i) {
                if (this.fkInfoArray[i].type == 2) continue;
                CursorResultSet insertedRows = this.insertedRowHolder.getResultSet();
                try {
                    ExecRow insertedRow;
                    insertedRows.open();
                    while ((insertedRow = insertedRows.getNextRow()) != null) {
                        if (UpdateResultSet.foundRow(insertedRow, this.fkInfoArray[i].colArray, this.deletedRowHolder)) continue;
                        this.riChecker.doRICheck(i, insertedRow, restrictCheckOnly);
                    }
                    continue;
                }
                finally {
                    insertedRows.close(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean foundRow(ExecRow checkRow, int[] colsToCheck, TemporaryRowHolderImpl rowHolder) throws StandardException {
        boolean foundMatch = false;
        DataValueDescriptor[] checkRowArray = checkRow.getRowArray();
        CursorResultSet rs = rowHolder.getResultSet();
        try {
            ExecRow scanRow;
            rs.open();
            while ((scanRow = rs.getNextRow()) != null) {
                DataValueDescriptor scanCol;
                DataValueDescriptor checkCol;
                BooleanDataValue result;
                int i;
                DataValueDescriptor[] scanRowArray = scanRow.getRowArray();
                for (i = 0; i < colsToCheck.length && (result = (checkCol = checkRowArray[colsToCheck[i] - 1]).equals(scanCol = scanRowArray[colsToCheck[i] - 1], checkCol)).getBoolean(); ++i) {
                }
                if (i != colsToCheck.length) continue;
                foundMatch = true;
                break;
            }
        }
        finally {
            rs.close(false);
        }
        return foundMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp(boolean cleanupOnError) throws StandardException {
        this.numOpens = 0;
        try {
            if (this.source != null) {
                this.source.close(cleanupOnError);
            }
            if (this.triggerActivator != null) {
                this.triggerActivator.cleanup(cleanupOnError);
            }
            if (this.rowChanger != null) {
                this.rowChanger.close();
            }
            if (this.deferredBaseCC != null) {
                this.deferredBaseCC.close();
            }
            this.deferredBaseCC = null;
            if (this.insertedRowHolder != null) {
                this.insertedRowHolder.close();
            }
            if (this.deletedRowHolder != null) {
                this.deletedRowHolder.close();
            }
            if (this.riChecker != null) {
                this.riChecker.close();
            }
        }
        catch (Throwable throwable) {
            super.close(cleanupOnError);
            this.endTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
            throw throwable;
        }
        super.close(cleanupOnError);
        this.endTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
    }

    void rowChangerFinish() throws StandardException {
        this.rowChanger.finish();
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        if (this.savedSource != null) {
            visitor.setNumberOfChildren(1);
        } else {
            visitor.setNumberOfChildren(0);
        }
        visitor.visit(this);
        if (this.savedSource != null) {
            this.savedSource.accept(visitor);
        }
    }

    public void release() {
        this.deferredRowsOHCache.release();
    }

    @Override
    public void addByteSource(OffHeapByteSource byteSource) {
        if (byteSource != null) {
            this.deferredRowsOHCache.put(byteSource.getMemoryAddress());
        } else {
            this.deferredRowsOHCache.put(0L);
        }
    }

    @Override
    public void registerWithGemFireTransaction(OffHeapResourceHolder owner) {
        GemFireTransaction tran = (GemFireTransaction)this.lcc.getTransactionExecute();
        tran.registerOffHeapResourceHolder(owner);
    }

    @Override
    public boolean optimizedForOffHeap() {
        return true;
    }

    @Override
    public void releaseByteSource(int positionFromEnd) {
        this.deferredRowsOHCache.release();
    }
}

