/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndex;
import com.pivotal.gemfirexd.internal.engine.distributed.ResultHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.message.StatementExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.procedure.coordinate.ProcedureProcessorResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.XPLAINDistPropsDescriptor;
import com.pivotal.gemfirexd.internal.engine.sql.execute.DistributionPlanCollector;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireDeleteResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireDistributedResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireRegionSizeResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireUpdateResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GfxdSubqueryResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.NcjPullResultSet;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.ConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.info.JVMInfo;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableProperties;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.PreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.services.uuid.BasicUUID;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINResultSetDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINResultSetTimingsDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINScanPropsDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINSortPropsDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINStatementDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINStatementTimingsDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINTableDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AbstractStatisticsCollector;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AggregatorInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AnyResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BasicNoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DeleteResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DistinctGroupedAggregateResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DistinctScanResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GroupedAggregateResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.HashLeftOuterJoinResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.HashScanResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.HashTableResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.IndexRowToBaseRowResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.JoinResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.LastIndexKeyResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.MiscResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NestedLoopLeftOuterJoinResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoRowsResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NormalizeResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.OnceResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ProjectRestrictResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.RowCountResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.RowResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ScalarAggregateResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ScrollInsensitiveResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.SortResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TableScanResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TemporaryRowHolderResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.UnionResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.UpdateResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.WindowResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.tools.planexporter.CreateXML;
import com.pivotal.gemfirexd.tools.planexporter.StatisticsCollectionObserver;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public final class StatementPlanCollector
extends AbstractStatisticsCollector {
    private final boolean no_call_stmts = true;
    private LanguageConnectionContext lcc;
    private Connection nestedConnection = null;
    private DataDictionary dd;
    private BaseActivation activation;
    private boolean considerTimingInformation = false;
    private ExecPreparedStatement preStmt;
    private XPLAINStatementDescriptor stmt;
    private XPLAINStatementTimingsDescriptor stmtTimings = null;
    private UUID stmtUUID;
    private final ArrayList<XPLAINResultSetDescriptor> rsets;
    private final List<XPLAINResultSetTimingsDescriptor> rsetsTimings;
    private final List<XPLAINSortPropsDescriptor> sortrsets;
    private final List<XPLAINScanPropsDescriptor> scanrsets;
    private final List<XPLAINDistPropsDescriptor> dsets;
    private final ArrayDeque<UUID> UUIDStack;
    private final XPLAINUtil.ChildNodeTimeCollector childTiming;
    private final DistributionPlanCollector distributionPlan;
    private final GemFireStore.StoreStatistics stats;
    public final StatisticsCollectionObserver observer = StatisticsCollectionObserver.getInstance();

    public StatementPlanCollector(ResultSetStatisticsVisitor nextCollector) {
        super(nextCollector);
        this.rsets = new ArrayList();
        this.rsetsTimings = new ArrayList<XPLAINResultSetTimingsDescriptor>();
        this.sortrsets = new ArrayList<XPLAINSortPropsDescriptor>();
        this.scanrsets = new ArrayList<XPLAINScanPropsDescriptor>();
        this.dsets = new ArrayList<XPLAINDistPropsDescriptor>();
        this.UUIDStack = new ArrayDeque();
        this.childTiming = new XPLAINUtil.ChildNodeTimeCollector(null);
        this.distributionPlan = new DistributionPlanCollector(this, this.dsets);
        this.stats = Misc.getMemStore().getStoreStatistics();
    }

    @Override
    public ResultSetStatisticsVisitor getClone() {
        return new StatementPlanCollector(super.getClone());
    }

    private void pushUUIDnoChildren(UUID uuid) {
        for (int i = 0; i < this.noChildren; ++i) {
            this.UUIDStack.push(uuid);
        }
    }

    public UUID popUUIDFromStack() {
        return this.UUIDStack.pop();
    }

    public void pushUUIDToStack(UUID id) {
        this.UUIDStack.push(id);
    }

    @Override
    public <T> void process(EmbedConnection conn, StatementExecutorMessage<T> msg, EmbedStatement est, boolean isLocallyExecuted) throws StandardException {
        long beginTime = NanoTimer.getTime();
        XPLAINTableDescriptor.registerStatements(conn);
        if (GemFireXDUtils.TracePlanGeneration) {
            SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("Generating plan for " + est.getSQLText()));
        }
        if (msg.getSender() != null) {
            this.sender = msg.getSender().toString();
        }
        ResultSet resultsToWrap = est.getResultsToWrap();
        this.processResultSet(conn, msg, null, resultsToWrap, est.getGPrepStmt(), isLocallyExecuted);
        this.stats.collectStatementPlanStats(NanoTimer.getTime() - beginTime, true);
        if (this.nextCollector != null) {
            this.nextCollector.process(conn, msg, est, isLocallyExecuted);
        } else {
            est.getResultsToWrap().resetStatistics();
        }
    }

    @Override
    public <T> void process(EmbedConnection conn, StatementExecutorMessage<T> msg, ResultHolder rh, boolean isLocallyExecuted) throws StandardException {
        long beginTime = NanoTimer.getTime();
        XPLAINTableDescriptor.registerStatements(conn);
        if (GemFireXDUtils.TracePlanGeneration) {
            SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("Generating plan for message : " + msg));
        }
        if (msg.getSender() != null) {
            this.sender = msg.getSender().toString();
        }
        ResultSet rs = rh.getERS().getSourceResultSet();
        this.processResultSet(conn, msg, rh, rs, rh.getGPrepStmt(), isLocallyExecuted);
        this.stats.collectStatementPlanStats(NanoTimer.getTime() - beginTime, true);
        if (this.nextCollector != null) {
            this.nextCollector.process(conn, msg, rh, isLocallyExecuted);
        } else {
            rs.resetStatistics();
        }
    }

    private <T> void processResultSet(EmbedConnection conn, StatementExecutorMessage<T> msg, ResultHolder rh, ResultSet rs, PreparedStatement gps, boolean isLocallyExecuted) throws StandardException {
        if (conn == null || conn.isClosed()) {
            return;
        }
        this.init((BaseActivation)rs.getActivation(), gps);
        if (!this.lcc.getRunTimeStatisticsMode() || this.nestedConnection == null) {
            return;
        }
        this.activation.setExecutionID(msg.getExecutionId());
        boolean continuePlanCapture = true;
        continuePlanCapture = this.generateStatementDescriptor(msg.getConstructTime(), msg.getEndProcessTime(), isLocallyExecuted);
        if (continuePlanCapture) {
            this.distributionPlan.setup(this.activation);
            this.distributionPlan.processMessage(msg, rh, isLocallyExecuted);
            this.doXPLAIN(rs, this.activation, false, this.considerTimingInformation, isLocallyExecuted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doXPLAIN(ResultSet rs, Activation activation, boolean genStatementDesc, boolean timeStatsEnabled, boolean isLocallyExecuted) throws StandardException {
        long beginTime;
        block18: {
            beginTime = NanoTimer.getTime();
            try {
                if (GemFireXDUtils.TracePlanGeneration) {
                    SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("Capturing ResultSet processing plan for connectionID=" + activation.getConnectionID() + " statementID=" + activation.getStatementID() + " executionID=" + activation.getExecutionID()));
                }
                boolean continuePlanCapture = true;
                if (genStatementDesc) {
                    Activation act = rs.getActivation();
                    SanityManager.ASSERT((!act.isClosed() ? 1 : 0) != 0, (String)"activation shouldn't be closed at this point");
                    this.init((BaseActivation)act, act.getPreparedStatement());
                    if (this.nestedConnection == null) {
                        return;
                    }
                    this.considerTimingInformation = timeStatsEnabled;
                    continuePlanCapture = this.generateStatementDescriptor(rs.getBeginExecutionTimestamp(), rs.getEndExecutionTimestamp(), isLocallyExecuted);
                }
                if (!continuePlanCapture) break block18;
                GemFireTransaction parentTran = null;
                try {
                    if (GemFireXDUtils.TracePlanGeneration) {
                        SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("StatementPlanCollector: starting from root resultset " + rs));
                    }
                    rs.accept(this);
                    if (this.observer != null) {
                        this.observer.processSelectMessage(this.stmt, this.rsets, this.rsetsTimings, this.scanrsets, this.sortrsets, this.dsets);
                    }
                    if ((parentTran = this.lcc.getParentOfNestedTransactionExecute()) != null) {
                        parentTran.suspendTransaction();
                    }
                    this.addArraysToSystemCatalogs();
                }
                catch (SQLException e) {
                    throw Misc.wrapSQLException(e, e);
                }
                finally {
                    if (parentTran != null) {
                        parentTran.resumeTransactionIfSuspended();
                    }
                }
            }
            finally {
                this.clean();
            }
        }
        this.stats.collectStatementPlanStats(NanoTimer.getTime() - beginTime, false);
        if (genStatementDesc && this.nextCollector != null) {
            this.nextCollector.doXPLAIN(rs, activation, genStatementDesc, timeStatsEnabled, isLocallyExecuted);
        }
        if (this.observer != null) {
            this.observer.end();
        }
    }

    @Override
    public UUID getStatementUUID() {
        return this.stmtUUID;
    }

    private boolean generateStatementDescriptor(Timestamp beginExeTime, Timestamp endExeTime, boolean isLocallyExecuted) throws StandardException {
        String origin_member;
        String type;
        if (this.preStmt == null) {
            SanityManager.THROWASSERT((String)("statement null for activation " + this.activation));
        }
        if ((type = XPLAINUtil.getStatementType(this.preStmt.getUserQueryString(this.activation.getLanguageConnectionContext()))) == null || type.equalsIgnoreCase("C")) {
            return false;
        }
        Object stmtTimingsUUID = null;
        long stmt_id = this.activation.getStatementID();
        if (stmt_id == -1L) {
            if (GemFireXDUtils.TracePlanGeneration) {
                SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)"Returning without plan capture due to stmt_id == -1");
            }
            return false;
        }
        this.stmtUUID = this.dd.getUUIDFactory().createUUID(stmt_id, this.activation.getExecutionID());
        if (isLocallyExecuted) {
            ((BasicUUID)this.stmtUUID).setLocallyExecuted(1);
        }
        String xaID = this.lcc.getTransactionExecute().getTransactionIdString();
        String sessionID = Integer.toString(this.lcc.getInstanceNumber());
        String jvmID = Integer.toString(JVMInfo.JDK_ID);
        String osID = System.getProperty("os.name");
        long current = System.currentTimeMillis();
        String XPLAINtype = this.lcc.explainConnection() ? "O" : "F";
        Timestamp time = new Timestamp(current);
        String threadID = Thread.currentThread().toString();
        if (this.lcc.isConnectionForRemote() && this.sender != null) {
            origin_member = this.sender;
        } else {
            SanityManager.ASSERT((isLocallyExecuted || !this.lcc.isConnectionForRemote() ? 1 : 0) != 0);
            GemFireCacheImpl c = Misc.getGemFireCacheNoThrow();
            origin_member = c != null ? c.getDistributedSystem().getDistributedMember().toString() : null;
        }
        long exeTime = -1L;
        if (GemFireXDUtils.TracePlanGeneration && (endExeTime == null || beginExeTime == null)) {
            SanityManager.THROWASSERT((String)("beginExeTs=" + beginExeTime + " endExeTs=" + endExeTime));
        }
        exeTime = endExeTime.getTime() - beginExeTime.getTime();
        if (GemFireXDUtils.TracePlanGeneration) {
            SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("Introducing Statement Descriptor for " + this.preStmt.getUserQueryString(this.activation.getLanguageConnectionContext()) + " statementId=" + this.activation.getStatementID() + " executionId=" + this.activation.getExecutionID() + " uuid=" + this.stmtUUID + (this.considerTimingInformation ? " with time stats " : " without time stats ") + " isLocallyExecuted=" + isLocallyExecuted), (Throwable)new Throwable());
        }
        this.stmt = new XPLAINStatementDescriptor(this.stmtUUID, this.activation.getCursorName(), type, this.preStmt.getUserQueryString(this.activation.getLanguageConnectionContext()), jvmID, osID, String.valueOf(GemFireStore.getMyId()), origin_member, Boolean.valueOf(isLocallyExecuted).toString(), XPLAINtype, time, threadID, xaID, sessionID, this.lcc.getDbname(), this.lcc.getDrdaID(), this.preStmt.getParseTimeInMillis(), this.preStmt.getBindTimeInMillis(), this.preStmt.getOptimizeTimeInMillis(), this.preStmt.getRoutingInfoTimeInMillis(), this.preStmt.getGenerateTimeInMillis(), this.preStmt.getCompileTimeInMillis(), exeTime, this.preStmt.getBeginCompileTimestamp(), this.preStmt.getEndCompileTimestamp(), beginExeTime, endExeTime);
        GemFireTransaction parentTran = null;
        try {
            parentTran = this.lcc.getParentOfNestedTransactionExecute();
            if (parentTran != null) {
                parentTran.suspendTransaction();
            }
            this.addStmtDescriptorsToSystemCatalog();
        }
        catch (SQLException e) {
            if (GemFireXDUtils.TracePlanGeneration) {
                SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("Got Exception while adding statement descriptors to system catalog " + e), (Throwable)e);
            }
            throw StandardException.plainWrapException(e);
        }
        finally {
            if (parentTran != null) {
                parentTran.resumeTransactionIfSuspended();
            }
        }
        return true;
    }

    public void init(BaseActivation act, PreparedStatement preparedStatement) throws StandardException {
        this.activation = act;
        this.lcc = this.activation.getLanguageConnectionContext();
        this.dd = this.lcc.getDataDictionary();
        this.considerTimingInformation = this.lcc.getStatisticsTiming() || this.lcc.explainConnection();
        this.preStmt = (ExecPreparedStatement)preparedStatement;
        if (this.nestedConnection == null) {
            this.nestedConnection = this.getDefaultConn();
        }
    }

    @Override
    public void clear() {
        this.preStmt = null;
        this.activation = null;
        this.lcc = null;
        this.dd = null;
    }

    public UUID getStmtUUID() {
        return this.stmtUUID;
    }

    private void clean() {
        this.activation = null;
        this.lcc = null;
        if (this.nestedConnection != null) {
            try {
                this.nestedConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.nestedConnection = null;
        this.dd = null;
        this.stmt = null;
        this.stmtTimings = null;
        this.rsets.clear();
        this.rsetsTimings.clear();
        this.sortrsets.clear();
        this.scanrsets.clear();
        this.dsets.clear();
        this.UUIDStack.clear();
    }

    private final Connection getDefaultConn() throws StandardException {
        Connection conn;
        block5: {
            ConnectionContext cc = (ConnectionContext)((Object)this.lcc.getContextManager().getContext("JDBC_ConnectionContext"));
            if (cc == null) {
                return null;
            }
            conn = null;
            try {
                conn = cc.getNestedConnection(true);
            }
            catch (SQLException sqle) {
                if ("08003".equals(sqle.getSQLState())) break block5;
                throw Misc.wrapSQLException(sqle, sqle);
            }
        }
        assert (conn instanceof EmbedConnection);
        if (conn != null && ((EmbedConnection)conn).getLanguageConnectionContext() != this.lcc) {
            SanityManager.THROWASSERT((String)"Nested Connection returning with different LCC ");
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStmtDescriptorsToSystemCatalog() throws StandardException, SQLException {
        boolean statsSave = this.lcc.getRunTimeStatisticsMode();
        try {
            this.lcc.setRunTimeStatisticsMode(false, true);
            assert (this.nestedConnection != null) : "NestedConnection shouldn't be null at this point";
            if (GemFireXDUtils.TracePlanGeneration) {
                // empty if block
            }
            java.sql.PreparedStatement ps = this.nestedConnection.prepareStatement(this.lcc.getExplainStatement("SYSXPLAIN_STATEMENTS"));
            this.stmt.setStatementParameters(ps);
            int updateCount = ps.executeUpdate();
            if (GemFireXDUtils.TracePlanGeneration && updateCount != 1) {
                SanityManager.DEBUG_PRINT((String)"warning", (String)("insert for " + this.stmt + " statement should have succeeded. updateCount=" + updateCount));
            }
            ps.close();
        }
        finally {
            this.lcc.setRunTimeStatisticsMode(statsSave, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addArraysToSystemCatalogs() throws StandardException, SQLException {
        if (this.rsets.size() == 0) {
            if (GemFireXDUtils.TracePlanGeneration) {
                SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("NO XML to create as no query layers are present for " + this.stmtUUID));
            }
            return;
        }
        StringBuilder xmlFragment = new StringBuilder();
        try {
            this.rankResultSetsByTimings();
            this.createXMLFragment(0, 0, xmlFragment, new StringBuilder("root/"));
            if (GemFireXDUtils.TracePlanGeneration) {
                SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("XML Fragment aquired " + xmlFragment));
                if (GemFireXDUtils.TracePlanAssertion) {
                    SanityManager.ASSERT((boolean)CreateXML.testXML(xmlFragment));
                }
            }
        }
        catch (Throwable t) {
            System.out.println("exception occurred.");
            t.printStackTrace(System.err);
            return;
        }
        boolean statsSave = this.lcc.getRunTimeStatisticsMode();
        try {
            this.lcc.setRunTimeStatisticsMode(false, true);
            assert (this.nestedConnection != null) : "NestedConnection shouldn't be null at this point";
            java.sql.PreparedStatement ps = this.nestedConnection.prepareStatement(this.lcc.getExplainStatement("SYSXPLAIN_RESULTSETS"));
            XPLAINResultSetDescriptor.setStatementParameters(this.nestedConnection, ps, this.stmtUUID, xmlFragment);
            int updateCount = ps.executeUpdate();
            assert (updateCount == 1) : "insert for " + xmlFragment + " should have succeeded ";
            ps.close();
        }
        finally {
            this.lcc.setRunTimeStatisticsMode(statsSave, true);
        }
    }

    private void rankResultSetsByTimings() {
        Object[] sortedDescs = this.rsets.toArray(new XPLAINResultSetDescriptor[this.rsets.size()]);
        Arrays.sort(sortedDescs);
        double totalExecuteTimeNanos = 0.0;
        for (XPLAINResultSetDescriptor r : this.rsets) {
            totalExecuteTimeNanos += (double)r.getExecuteTime();
        }
        if (GemFireXDUtils.TracePlanGeneration) {
            SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("Ranking resultSets of size " + this.rsets.size() + " with TotalExecutionTimeNanos=" + totalExecuteTimeNanos + " ResultSets[]" + Arrays.toString(sortedDescs)));
        }
        int rank = 1;
        for (Object r : sortedDescs) {
            ((XPLAINResultSetDescriptor)r).setRank(rank++);
            ((XPLAINResultSetDescriptor)r).setTotalExecuteTimeNanos(totalExecuteTimeNanos);
        }
    }

    private int createXMLFragment(int xmlDepth, int currentLevel, StringBuilder sb, StringBuilder lineage) {
        if (currentLevel >= this.rsets.size()) {
            return currentLevel;
        }
        XPLAINResultSetDescriptor rdesc = this.rsets.get(currentLevel);
        StringBuilder currentlineage = new StringBuilder(lineage).append(rdesc.rs_name).append("/");
        PlanUtils.addSpaces(sb, xmlDepth).append("<node");
        PlanUtils.xmlAttribute(sb, "lineage", currentlineage);
        rdesc.getXMLAttributes(sb, this.observer);
        if (rdesc.num_children > 0) {
            sb.append(">\n");
        }
        for (int i = 1; i <= rdesc.num_children; ++i) {
            currentLevel = this.createXMLFragment(xmlDepth + 1, currentLevel + 1, sb, currentlineage);
        }
        if (rdesc.num_children > 0) {
            PlanUtils.addSpaces(sb, xmlDepth).append("</node>\n");
        } else {
            sb.append("/>\n");
        }
        if (this.observer != null) {
            this.observer.processedResultSetDescriptor(rdesc);
        }
        return currentLevel;
    }

    private long getNodeTime(BasicNoPutResultSetImpl currentrs) {
        long time = currentrs.getTimeSpent(0, 0);
        if (GemFireXDUtils.TracePlanGeneration) {
            // empty if block
        }
        return time == 0L ? 1L : time;
    }

    private XPLAINResultSetTimingsDescriptor createResultSetTimingDescriptor(BasicNoPutResultSetImpl bnprs, UUID timingID) {
        return this.createResultSetTimingDescriptor(timingID, bnprs.constructorTime, bnprs.openTime, bnprs.nextTime, bnprs.closeTime, this.getNodeTime(bnprs), bnprs.rowsSeen, -1L, -1L);
    }

    private XPLAINResultSetTimingsDescriptor createResultSetTimingDescriptor(NoRowsResultSetImpl nrrs, UUID timingID) {
        return this.createResultSetTimingDescriptor(timingID, -1L, -1L, -1L, -1L, nrrs.getExecuteTime(), -1, -1L, -1L);
    }

    private XPLAINResultSetTimingsDescriptor createResultSetTimingDescriptor(ProjectRestrictResultSet rs, UUID timingID) {
        return this.createResultSetTimingDescriptor(timingID, rs.constructorTime, rs.openTime, rs.nextTime, rs.closeTime, this.getNodeTime(rs), rs.rowsSeen, rs.projectionTime, rs.restrictionTime);
    }

    public XPLAINResultSetTimingsDescriptor createResultSetTimingDescriptor(UUID timingID, long constructorTime, long openTime, long nextTime, long closeTime, long nodeTime, int rowsSeen, long projectionTime, long restrictionTime) {
        XPLAINResultSetTimingsDescriptor timing_desc = new XPLAINResultSetTimingsDescriptor(timingID, constructorTime, openTime, nextTime, closeTime, nodeTime, nextTime >= 0L ? XPLAINUtil.getAVGNextTime(nextTime, rowsSeen) : -1L, projectionTime, restrictionTime, -1L, -1L);
        if (GemFireXDUtils.TracePlanGeneration) {
            SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("StatementPlanCollector: recording timing of resultset " + timing_desc));
        }
        this.rsetsTimings.add(timing_desc);
        return timing_desc;
    }

    private XPLAINResultSetDescriptor createResultSetDescriptor(BasicNoPutResultSetImpl rs, XPLAINResultSetTimingsDescriptor timingID, String lockMode, String lockGran, String rsxplaintype, String rsxplaindetail, XPLAINScanPropsDescriptor scan, XPLAINSortPropsDescriptor sort, int rowsReturned) {
        return this.createResultSetDescriptor(rs.getClass().getSimpleName(), timingID, lockMode, lockGran, rsxplaintype, rsxplaindetail, rs.numOpens, rs.optimizerEstimatedRowCount, rs.optimizerEstimatedCost, rs.rowsSeen, rs.rowsFiltered, rowsReturned == -1 ? rs.rowsSeen - rs.rowsFiltered : rowsReturned, scan, sort, null);
    }

    private XPLAINResultSetDescriptor createResultSetDescriptor(NoRowsResultSetImpl rs, XPLAINResultSetTimingsDescriptor timingID, String rsxplaintype, String rsxplaindetail) {
        return this.createResultSetDescriptor(rs.getClass().getSimpleName(), timingID, null, null, rsxplaintype, rsxplaindetail, -1, -1.0, -1.0, -1, -1, -1, null, null, null);
    }

    public XPLAINResultSetDescriptor createResultSetDescriptor(String rs_name, XPLAINResultSetTimingsDescriptor timingID, String lockMode, String lockGran, String rsxplaintype, String rsxplaindetail, int numOpens, double optimizerEstimatedRowCount, double optimizerEstimatedCost, int rowsSeen, int rowsFiltered, int returned_rows, XPLAINScanPropsDescriptor scan, XPLAINSortPropsDescriptor sort, XPLAINDistPropsDescriptor distdesc) {
        UUID rsID = this.dd.getUUIDFactory().createUUID();
        XPLAINResultSetDescriptor rsdesc = new XPLAINResultSetDescriptor(rs_name, this.noChildren, this.rsets.size(), rsID, rsxplaintype, rsxplaindetail, numOpens < 0 ? null : Integer.valueOf(numOpens), null, lockMode, lockGran, this.UUIDStack.isEmpty() ? null : this.UUIDStack.pop(), optimizerEstimatedRowCount < 0.0 ? null : Double.valueOf(optimizerEstimatedRowCount), optimizerEstimatedCost < 0.0 ? null : Double.valueOf(optimizerEstimatedCost), null, null, null, rowsSeen, null, rowsFiltered, returned_rows < 0 ? null : Integer.valueOf(returned_rows), null, null, scan, sort, this.stmtUUID, timingID, distdesc);
        this.pushUUIDnoChildren(rsID);
        if (GemFireXDUtils.TracePlanGeneration) {
            SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("StatementPlanCollector: recording resultset " + rsdesc));
        }
        this.rsets.add(rsdesc);
        return rsdesc;
    }

    public XPLAINScanPropsDescriptor createScanPropDescriptor(String scanObjectType, String scanObjectName, String startPosition, String stopPosition, UUID scanID, int isoLevel, int rowsPerRead, Qualifier[][] qualifiers, Properties scanProperties, int[] hashkey_columns) {
        XPLAINScanPropsDescriptor scanRSDescriptor = new XPLAINScanPropsDescriptor(scanID, scanObjectName, scanObjectType, null, XPLAINUtil.getIsolationLevelCode(isoLevel), null, null, null, null, null, null, null, rowsPerRead < 0 ? null : Integer.valueOf(rowsPerRead), startPosition, stopPosition, NoPutResultSetImpl.printQualifiers(qualifiers, true), null, XPLAINUtil.getHashKeyColumnNumberString(hashkey_columns), null);
        FormatableProperties props = new FormatableProperties();
        if (scanProperties != null) {
            Enumeration<Object> e = scanProperties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                props.put(key, scanProperties.get(key));
            }
        }
        this.scanrsets.add(XPLAINUtil.extractScanProps(scanRSDescriptor, props));
        return scanRSDescriptor;
    }

    public XPLAINSortPropsDescriptor createSortPropDescriptor(UUID sortID, Properties props, String sorttype, int inputrows, int outputrows, int mergerows, boolean eliminateDuplicates, boolean inSortedOrder) {
        XPLAINSortPropsDescriptor sortRSDescriptor = new XPLAINSortPropsDescriptor(sortID, sorttype, inputrows < 0 ? null : Integer.valueOf(inputrows), outputrows < 0 ? null : Integer.valueOf(outputrows), mergerows < 0 ? null : Integer.valueOf(mergerows), null, XPLAINUtil.getYesNoCharFromBoolean(eliminateDuplicates), XPLAINUtil.getYesNoCharFromBoolean(inSortedOrder), null);
        this.sortrsets.add(XPLAINUtil.extractSortProps(sortRSDescriptor, props));
        return sortRSDescriptor;
    }

    public void createDistPropDescriptor(XPLAINDistPropsDescriptor desc) {
        if (desc.getRSID() == null) {
            desc.setDistRSID(this.dd.getUUIDFactory().createUUID());
        }
        this.dsets.add(desc);
    }

    @Override
    public void visit(GemFireDeleteResultSet rs) {
    }

    @Override
    public void visit(DistinctGroupedAggregateResultSet rs) {
    }

    @Override
    public void visit(GroupedAggregateResultSet rs) {
        XPLAINResultSetTimingsDescriptor time_desc = null;
        if (this.considerTimingInformation) {
            UUID timingID = this.dd.getUUIDFactory().createUUID();
            time_desc = this.createResultSetTimingDescriptor(rs, timingID);
        }
        String rsxplaintype = "GROUPBY";
        this.createResultSetDescriptor(rs, time_desc, null, null, rsxplaintype, null, null, null, rs.rowsReturned);
    }

    @Override
    public void visit(DistinctScanResultSet rs) {
    }

    @Override
    public void visit(ProjectRestrictResultSet rs) {
        XPLAINResultSetTimingsDescriptor time_desc = null;
        if (this.considerTimingInformation) {
            UUID timingID = this.dd.getUUIDFactory().createUUID();
            time_desc = this.createResultSetTimingDescriptor(rs, timingID);
        }
        String rsxplaintype = rs.restriction != null && rs.doesProjection ? "PROJECT-FILTER" : (rs.doesProjection ? "PROJECTION" : (rs.restriction != null ? "FILTER" : "PROJECT-FILTER"));
        String rsxplaindetail = rs.projectedColumns != null ? rs.projectedColumns : null;
        this.createResultSetDescriptor(rs, time_desc, null, null, rsxplaintype, rsxplaindetail, null, null, -1);
    }

    @Override
    public void visit(IndexRowToBaseRowResultSet rs) {
        XPLAINResultSetTimingsDescriptor time_desc = null;
        if (this.considerTimingInformation) {
            UUID timingID = this.dd.getUUIDFactory().createUUID();
            time_desc = this.createResultSetTimingDescriptor(rs, timingID);
        }
        GemFireContainer gfc = rs.gfc;
        RowFormatter rf = gfc.getCurrentRowFormatter();
        StringBuilder accessedCols = new StringBuilder(rs.indexName).append(" : ");
        boolean first = true;
        if (rs.accessedHeapCols != null && rf != null) {
            for (int inPosition = 0; inPosition < rs.accessedHeapCols.getLength(); ++inPosition) {
                ColumnDescriptor cd;
                if (!rs.accessedHeapCols.isSet(inPosition) || (cd = rf.getColumnDescriptor(inPosition)) == null) continue;
                if (!first) {
                    accessedCols.append(", ");
                } else {
                    first = false;
                }
                accessedCols.append(cd.getColumnName());
            }
        }
        this.createResultSetDescriptor(rs, time_desc, null, null, "ROWIDSCAN", accessedCols.toString(), null, null, -1);
    }

    @Override
    public void visit(ScrollInsensitiveResultSet rs) {
        XPLAINResultSetTimingsDescriptor time_desc = null;
        if (this.considerTimingInformation) {
            UUID timingID = this.dd.getUUIDFactory().createUUID();
            time_desc = this.createResultSetTimingDescriptor(rs, timingID);
        }
        this.createResultSetDescriptor(rs, time_desc, null, null, "SCROLL-INSENSITIVE", "(" + rs.resultSetNumber + "), " + "[" + rs.numFromHashTable + ", " + rs.numToHashTable + "]", null, null, -1);
    }

    @Override
    public void visit(GemFireResultSet rs) {
        XPLAINResultSetTimingsDescriptor time_desc = null;
        if (this.considerTimingInformation) {
            UUID timingID = this.dd.getUUIDFactory().createUUID();
            time_desc = this.createResultSetTimingDescriptor(timingID, -1L, rs.openTime, rs.nextTime, rs.closeTime, rs.getTimeSpent(0, 0), 0, -1L, -1L);
        }
        GemFireContainer gfc = rs.getGFContainer();
        RowFormatter rf = rs.getProjectionFormat();
        StringBuilder rsexplaindetail = new StringBuilder(gfc.getSchemaName()).append(".").append(gfc.getTableName());
        if (rf != null) {
            boolean first = true;
            for (int inPosition = 0; inPosition < rf.getNumColumns(); ++inPosition) {
                ColumnDescriptor cd = rf.getColumnDescriptor(inPosition);
                if (cd == null) continue;
                if (!first) {
                    rsexplaindetail.append(", ");
                } else {
                    first = false;
                    rsexplaindetail.append(" ");
                }
                rsexplaindetail.append(cd.getColumnName());
            }
        }
        this.createResultSetDescriptor(rs.getClass().getSimpleName(), time_desc, null, null, rs.isGetAllLocalIndexPlan() ? "LOCAL-INDEX-GETALL" : (rs.isGetAllPlan() ? "REGION-GETALL" : "REGION-GET"), rsexplaindetail.toString(), 1, rs.getEstimatedRowCount(), -1.0, -1, -1, rs.rowsReturned, null, null, null);
    }

    @Override
    public void visit(NormalizeResultSet rs) {
    }

    @Override
    public void visit(AnyResultSet anyResultSet) {
    }

    @Override
    public void visit(GemFireDistributedResultSet rs) {
        if (GemFireXDUtils.TracePlanGeneration) {
            SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("StatementPlanCollector: Processing " + rs));
        }
        this.distributionPlan.processGFDistResultSet(rs);
    }

    @Override
    public void visit(LastIndexKeyResultSet rs) {
    }

    @Override
    public void visit(MiscResultSet rs) {
    }

    @Override
    public void visit(OnceResultSet rs) {
    }

    @Override
    public void visit(ProcedureProcessorResultSet rs) {
    }

    @Override
    public void visit(GfxdSubqueryResultSet rs) {
        this.distributionPlan.processDistribution(rs);
    }

    @Override
    public void visit(NcjPullResultSet rs) {
        this.distributionPlan.processDistribution(rs);
    }

    @Override
    public void visit(TemporaryRowHolderResultSet rs) {
    }

    @Override
    public void visit(WindowResultSet rs) {
    }

    @Override
    public void visit(SortResultSet rs) {
        XPLAINResultSetTimingsDescriptor time_desc = null;
        if (this.considerTimingInformation) {
            UUID timingID = this.dd.getUUIDFactory().createUUID();
            time_desc = this.createResultSetTimingDescriptor(rs, timingID);
        }
        UUID sortID = this.dd.getUUIDFactory().createUUID();
        XPLAINSortPropsDescriptor sort_desc = this.createSortPropDescriptor(sortID, rs.sortProperties, null, -1, -1, -1, rs.distinct, rs.isInSortedOrder);
        XPLAINResultSetDescriptor rsdesc = this.createResultSetDescriptor(rs, time_desc, null, null, "SORT", String.valueOf(rs.resultSetNumber), null, sort_desc, rs.rowsReturned);
        rsdesc.setInputRows(rs.rowsInput);
    }

    @Override
    public void visit(HashTableResultSet rs) {
        XPLAINResultSetTimingsDescriptor time_desc = null;
        if (this.considerTimingInformation) {
            UUID timingID = this.dd.getUUIDFactory().createUUID();
            time_desc = this.createResultSetTimingDescriptor(rs, timingID);
        }
        UUID scanID = this.dd.getUUIDFactory().createUUID();
        XPLAINScanPropsDescriptor scan_desc = this.createScanPropDescriptor(null, "Temporary HashTable", null, null, scanID, 2, -1, rs.nextQualifiers, rs.scanProperties, rs.keyColumns);
        scan_desc.setHashtableSize(rs.hashtableSize);
        this.createResultSetDescriptor(rs, time_desc, null, null, "HASHTABLE", "(" + rs.resultSetNumber + ")", scan_desc, null, -1);
    }

    @Override
    public void visit(UpdateResultSet rs) {
        XPLAINResultSetTimingsDescriptor time_desc = null;
        if (this.considerTimingInformation) {
            UUID timingID = this.dd.getUUIDFactory().createUUID();
            time_desc = this.createResultSetTimingDescriptor(rs, timingID);
        }
        XPLAINResultSetDescriptor rsdesc = this.createResultSetDescriptor(rs, time_desc, "UPDATE", null);
        rsdesc.setAffectedRows(rs.rowCount);
        rsdesc.setDeferredRows(rs.deferred);
        rsdesc.setIndexesUpdated(rs.constantAction.irgs.length);
    }

    @Override
    public void visit(DeleteResultSet rs, int overridable) {
    }

    @Override
    public void visit(GemFireUpdateResultSet rs, int overridable) {
    }

    public String toString() {
        return "STATEMENT PLAN COLLECTOR" + (this.nextCollector != null ? " + " + this.nextCollector.toString() : "");
    }

    @Override
    public void visit(GemFireRegionSizeResultSet regionSizeResultSet) {
    }

    @Override
    public void visit(RowCountResultSet rs) {
        XPLAINResultSetTimingsDescriptor time_desc = null;
        if (this.considerTimingInformation) {
            UUID timingID = this.dd.getUUIDFactory().createUUID();
            time_desc = this.createResultSetTimingDescriptor(rs, timingID);
        }
        this.createResultSetDescriptor(rs, time_desc, null, null, "ROW-COUNT", "(" + rs.resultSetNumber + ")", null, null, -1);
    }

    @Override
    public void visit(RowResultSet rs) {
        XPLAINResultSetTimingsDescriptor time_desc = null;
        if (this.considerTimingInformation) {
            UUID timingID = this.dd.getUUIDFactory().createUUID();
            time_desc = this.createResultSetTimingDescriptor(rs, timingID);
        }
        this.createResultSetDescriptor(rs, time_desc, null, null, "ROW", "(" + rs.resultSetNumber + ")", null, null, rs.rowsReturned);
    }

    @Override
    public void visit(UnionResultSet rs) {
        XPLAINResultSetTimingsDescriptor time_desc = null;
        if (this.considerTimingInformation) {
            UUID timingID = this.dd.getUUIDFactory().createUUID();
            time_desc = this.createResultSetTimingDescriptor(rs, timingID);
        }
        this.createResultSetDescriptor(rs, time_desc, null, null, "UNION", "(" + rs.resultSetNumber + ")", null, null, rs.rowsReturned);
    }

    @Override
    public void visit(TableScanResultSet rs, int overridable) {
        XPLAINResultSetTimingsDescriptor time_desc = null;
        if (this.considerTimingInformation) {
            UUID timingID = this.dd.getUUIDFactory().createUUID();
            time_desc = this.createResultSetTimingDescriptor(rs, timingID);
        }
        String lockString = null;
        lockString = rs.forUpdate() ? MessageService.getTextMessage("42Z82.U") : (rs.isolationLevel == 3 ? MessageService.getTextMessage("42Z83.U") : MessageService.getTextMessage("42Z84.U"));
        String lockMode = XPLAINUtil.getLockModeCode(lockString);
        String lockGran = XPLAINUtil.getLockGranularityCode(lockString);
        String rsxplaintype = null;
        String scanObjectType = null;
        String rsxplaindetail = null;
        String scanObjectName = null;
        String startPosition = null;
        String stopPosition = null;
        if (rs.indexName != null) {
            if (rs.isConstraint()) {
                rsxplaintype = "CONSTRAINTSCAN";
                scanObjectType = "C";
                rsxplaindetail = "C: " + rs.indexName;
                GemFireContainer gfc = ((MemConglomerate)rs.scoci).getGemFireContainer();
                scanObjectName = gfc != null ? gfc.getQualifiedTableName() : "HASH SCAN:" + rs.tableName;
                rsxplaindetail = rs.nonQualPreds != null ? "WHERE : " + rs.nonQualPreds : null;
            } else {
                rsxplaintype = "INDEXSCAN";
                scanObjectType = "I";
                rsxplaindetail = "";
                if (!((MemIndex)rs.scoci).caseSensitive()) {
                    rsxplaindetail = rsxplaindetail + "(Case Insensitive) ";
                }
                scanObjectName = rs.indexName;
                if (rs.nonQualPreds != null) {
                    rsxplaindetail = rsxplaindetail + "WHERE : " + rs.nonQualPreds;
                }
            }
            startPosition = rs.startPositionString;
            if (startPosition == null) {
                startPosition = rs.printStartPosition();
            }
            if ((stopPosition = rs.stopPositionString) == null) {
                stopPosition = rs.printStopPosition();
            }
        } else {
            rsxplaintype = "TABLESCAN";
            scanObjectType = "T";
            rsxplaindetail = "T: " + rs.tableName;
            scanObjectName = rs.regionName;
        }
        UUID scanID = this.dd.getUUIDFactory().createUUID();
        XPLAINScanPropsDescriptor scan_desc = this.createScanPropDescriptor(scanObjectType, scanObjectName, startPosition, stopPosition, scanID, rs.isolationLevel, rs.rowsPerRead, rs.qualifiers, rs.getScanProperties(), null);
        this.createResultSetDescriptor(rs, time_desc, lockMode, lockGran, rsxplaintype, rsxplaindetail, scan_desc, null, -1);
    }

    @Override
    public void visit(ScalarAggregateResultSet rs, int overridable) {
        XPLAINResultSetTimingsDescriptor time_desc = null;
        if (this.considerTimingInformation) {
            UUID timingID = this.dd.getUUIDFactory().createUUID();
            time_desc = this.createResultSetTimingDescriptor(rs, timingID);
        }
        int count = rs.aggInfoList.size();
        String aggDescription = "";
        for (int i = 0; i < count; ++i) {
            AggregatorInfo aggInfo = (AggregatorInfo)rs.aggInfoList.elementAt(i);
            if (i > 0) {
                aggDescription = aggDescription + ",";
            }
            if (aggInfo.isDistinct()) {
                aggDescription = aggDescription + "DISTINCT ";
            }
            aggDescription = aggDescription + aggInfo.getAggregateName();
        }
        XPLAINResultSetDescriptor rsdesc = this.createResultSetDescriptor(rs, time_desc, null, null, "AGGREGATION", aggDescription, null, null, 1);
        rsdesc.setInputRows(rs.rowsInput);
        rsdesc.setIndexKeyOptimization(rs.singleInputRow ? "Y" : "N");
    }

    @Override
    public void visit(JoinResultSet rs, int overridable) {
        int emptyRightRowsReturned;
        String xplainType;
        XPLAINResultSetTimingsDescriptor time_desc = null;
        if (this.considerTimingInformation) {
            UUID timingID = this.dd.getUUIDFactory().createUUID();
            time_desc = this.createResultSetTimingDescriptor(rs, timingID);
            time_desc.setAvgNextTime(XPLAINUtil.getAVGNextTime(rs.nextTime, rs.rowsSeenLeft + rs.rowsSeenRight));
        }
        switch (overridable) {
            case 1: {
                xplainType = "NLJOIN";
                emptyRightRowsReturned = -1;
                break;
            }
            case 2: {
                xplainType = "LONLJOIN";
                emptyRightRowsReturned = ((NestedLoopLeftOuterJoinResultSet)rs).emptyRightRowsReturned;
                break;
            }
            case 3: {
                xplainType = "HASHJOIN";
                emptyRightRowsReturned = -1;
                break;
            }
            case 4: {
                xplainType = "LOHASHJOIN";
                emptyRightRowsReturned = ((HashLeftOuterJoinResultSet)rs).emptyRightRowsReturned;
                break;
            }
            case 5: {
                xplainType = "MERGEJOIN";
                emptyRightRowsReturned = -1;
                break;
            }
            default: {
                xplainType = null;
                emptyRightRowsReturned = -1;
            }
        }
        StringBuilder op_details = new StringBuilder();
        op_details.append("(").append(rs.resultSetNumber).append(")");
        if (rs.oneRowRightSide) {
            op_details.append(", EXISTS JOIN");
        }
        XPLAINResultSetDescriptor rsdesc = this.createResultSetDescriptor(rs, time_desc, null, null, xplainType, op_details.toString(), null, null, rs.rowsReturned);
        rsdesc.setRowsSeenRight(rs.rowsSeenRight);
        rsdesc.setEmptyRightRowsReturned(emptyRightRowsReturned);
    }

    @Override
    public void visit(HashScanResultSet rs, int overridable) {
        String xplaindetail;
        String scanObjectName;
        String scanObjectType;
        boolean instantaneousLocks = false;
        HashScanResultSet hsrs = rs;
        String startPosition = null;
        String stopPosition = null;
        String lockString = null;
        lockString = hsrs.forUpdate ? MessageService.getTextMessage("42Z82.U") : (instantaneousLocks ? MessageService.getTextMessage("42Z83.U") : MessageService.getTextMessage("42Z84.U"));
        switch (hsrs.lockMode) {
            case 7: {
                lockString = lockString + " " + MessageService.getTextMessage("42Z85.U");
                break;
            }
            case 6: {
                lockString = lockString + " " + MessageService.getTextMessage("42Z86.U");
            }
        }
        if (hsrs.indexName != null) {
            startPosition = hsrs.startPositionString;
            if (startPosition == null) {
                startPosition = hsrs.printStartPosition();
            }
            if ((stopPosition = hsrs.stopPositionString) == null) {
                stopPosition = hsrs.printStopPosition();
            }
        }
        XPLAINResultSetTimingsDescriptor time_desc = null;
        if (this.considerTimingInformation) {
            UUID timingID = this.dd.getUUIDFactory().createUUID();
            time_desc = this.createResultSetTimingDescriptor(rs, timingID);
        }
        UUID scanID = this.dd.getUUIDFactory().createUUID();
        if (rs.indexName != null) {
            if (rs.isConstraint) {
                scanObjectType = "C";
                scanObjectName = rs.indexName;
                xplaindetail = "C: " + rs.indexName;
            } else {
                scanObjectType = "I";
                scanObjectName = rs.indexName;
                xplaindetail = "I: " + rs.indexName;
            }
        } else {
            scanObjectType = "T";
            scanObjectName = rs.tableName;
            xplaindetail = "T: " + rs.tableName;
        }
        XPLAINScanPropsDescriptor scan_desc = this.createScanPropDescriptor(scanObjectType, scanObjectName, startPosition, stopPosition, scanID, rs.isolationLevel, -1, rs.scanQualifiers, rs.scanProperties, rs.keyColumns);
        scan_desc.setHashtableSize(rs.hashtableSize);
        String lockMode = XPLAINUtil.getLockModeCode(lockString);
        String lockGran = XPLAINUtil.getLockGranularityCode(lockString);
        this.createResultSetDescriptor(rs, time_desc, lockMode, lockGran, overridable == 2 ? "DISTINCTSCAN" : "HASHSCAN", xplaindetail, scan_desc, null, -1);
    }
}

