/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapResourceHolder;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;

class RowResultSet
extends NoPutResultSetImpl
implements CursorResultSet,
OffHeapResourceHolder {
    public int rowsReturned;
    private boolean canCacheRow;
    private boolean next;
    private GeneratedMethod row;
    private ExecRow cachedRow;

    RowResultSet(Activation activation, GeneratedMethod row, boolean canCacheRow, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.row = row;
        this.canCacheRow = canCacheRow;
        this.recordConstructorTime();
        this.printResultSetHierarchy();
    }

    RowResultSet(Activation activation, ExecRow constantRow, boolean canCacheRow, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        Class<?> bsClass;
        Object byteSource;
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        this.cachedRow = constantRow;
        this.canCacheRow = canCacheRow;
        this.recordConstructorTime();
        if (constantRow != null && (byteSource = constantRow.getByteSource()) != null && (bsClass = byteSource.getClass()) != byte[].class && bsClass != byte[][].class) {
            this.registerWithGemFireTransaction(this);
        }
        this.printResultSetHierarchy();
    }

    @Override
    public void openCore() throws StandardException {
        this.next = false;
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        this.isOpen = true;
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        this.currentRow = null;
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            if (!this.next) {
                this.next = true;
                if (this.cachedRow != null) {
                    this.currentRow = this.cachedRow;
                } else if (this.row != null) {
                    this.currentRow = (ExecRow)this.row.invoke(this.activation);
                    if (this.canCacheRow) {
                        this.cachedRow = this.currentRow;
                    }
                }
                ++this.rowsReturned;
            }
            this.setCurrentRow(this.currentRow);
            if (this.statisticsTimingOn) {
                this.nextTime += this.getElapsedNanos(this.beginTime);
            }
        }
        return this.currentRow;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            this.clearCurrentRow();
            this.next = false;
            super.close(cleanupOnError);
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of RowResultSet repeated");
        }
        if (this.statisticsTimingOn) {
            this.closeTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        return totTime;
    }

    @Override
    public RowLocation getRowLocation() {
        SanityManager.THROWASSERT((String)"RowResultSet used in positioned update/delete");
        return null;
    }

    @Override
    public ExecRow getCurrentRow() {
        SanityManager.THROWASSERT((String)"RowResultSet used in positioned update/delete");
        return null;
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void resetStatistics() {
        this.rowsReturned = 0;
        super.resetStatistics();
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        PlanUtils.xmlTermTag(builder, context, "ROW");
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    public void release() {
        this.cachedRow.releaseByteSource();
    }

    @Override
    public void addByteSource(OffHeapByteSource byteSource) {
    }

    @Override
    public void registerWithGemFireTransaction(OffHeapResourceHolder owner) {
        ((GemFireTransaction)this.activation.getLanguageConnectionContext().getTransactionExecute()).registerOffHeapResourceHolder(owner);
    }

    @Override
    public boolean optimizedForOffHeap() {
        return false;
    }

    @Override
    public void releaseByteSource(int positionFromEnd) {
    }

    @Override
    public void printResultSetHierarchy() {
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("ResultSet Created: " + this.getClass().getSimpleName() + " with resultSetNumber=" + this.resultSetNumber));
        }
    }
}

